/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.FormulaAnalysis;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.rule.AbstractRule;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.HashCode;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.Parallel;
import org.linqs.psl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicalRule
extends AbstractRule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogicalRule.class);
    private final String groundingResourcesKey;
    protected Formula formula;
    protected final FormulaAnalysis.DNFClause negatedDNF;
    private int hash;

    public AbstractLogicalRule(Formula formula, String name) {
        super(name);
        this.formula = formula;
        this.groundingResourcesKey = AbstractLogicalRule.class.getName() + ";" + formula + ";GroundingResources";
        FormulaAnalysis analysis = new FormulaAnalysis(new Negation(formula));
        if (analysis.getNumDNFClauses() > 1) {
            throw new IllegalArgumentException("Formula must be a disjunction of literals (or a negative literal).");
        }
        this.negatedDNF = analysis.getDNFClause(0);
        Set<Variable> unboundVariables = this.negatedDNF.getUnboundVariables();
        if (unboundVariables.size() > 0) {
            Object[] sortedVariables = unboundVariables.toArray(new Variable[unboundVariables.size()]);
            Arrays.sort(sortedVariables);
            throw new IllegalArgumentException("Any variable used in a negated (non-functional) predicate must also participate in a positive (non-functional) predicate. The following variables do not meet this requirement: [" + StringUtils.join(", ", sortedVariables) + "].");
        }
        if (this.negatedDNF.isGround()) {
            throw new IllegalArgumentException("Formula has no Variables.");
        }
        if (!this.negatedDNF.isQueriable()) {
            throw new IllegalArgumentException("Formula is not a valid rule for unknown reason.");
        }
        this.hash = 17;
        for (Atom atom : this.negatedDNF.getPosLiterals()) {
            this.hash = HashCode.build(atom);
        }
        for (Atom atom : this.negatedDNF.getNegLiterals()) {
            this.hash = HashCode.build(atom);
        }
    }

    public Formula getFormula() {
        return this.formula;
    }

    public FormulaAnalysis.DNFClause getDNF() {
        return this.negatedDNF;
    }

    @Override
    public int groundAll(AtomManager atomManager, GroundRuleStore groundRuleStore) {
        QueryResultIterable queryResults = atomManager.executeGroundingQuery(this.negatedDNF.getQueryFormula());
        return this.groundAll(queryResults, atomManager, groundRuleStore);
    }

    @Override
    public boolean supportsIndividualGrounding() {
        return true;
    }

    @Override
    public Formula getGroundingFormula() {
        return this.negatedDNF.getQueryFormula();
    }

    @Override
    public GroundRule ground(Constant[] constants, Map<Variable, Integer> variableMap, AtomManager atomManager) {
        if (!Parallel.hasThreadObject(this.groundingResourcesKey)) {
            Parallel.putThreadObject(this.groundingResourcesKey, new GroundingResources(this.negatedDNF));
        }
        GroundingResources resources = (GroundingResources)Parallel.getThreadObject(this.groundingResourcesKey);
        return this.groundInternal(constants, variableMap, atomManager, resources);
    }

    public int groundAll(QueryResultIterable groundVariables, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        boolean oldAccessExceptionState = atomManager.enableAccessExceptions(false);
        int initialCount = groundRuleStore.size();
        final AtomManager finalAtomManager = atomManager;
        final GroundRuleStore finalGroundRuleStore = groundRuleStore;
        final Map<Variable, Integer> variableMap = groundVariables.getVariableMap();
        Parallel.foreach(groundVariables, new Parallel.Worker<Constant[]>(){

            @Override
            public void work(int index, Constant[] row) {
                GroundRule groundRule = AbstractLogicalRule.this.ground(row, variableMap, finalAtomManager);
                if (groundRule != null) {
                    finalGroundRuleStore.addGroundRule(groundRule);
                }
            }
        });
        int groundCount = groundRuleStore.size() - initialCount;
        atomManager.enableAccessExceptions(oldAccessExceptionState);
        log.debug("Grounded {} instances of rule {}", (Object)groundCount, (Object)this);
        return groundCount;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractLogicalRule)) {
            return false;
        }
        AbstractLogicalRule otherRule = (AbstractLogicalRule)other;
        if (this.hash != otherRule.hash) {
            return false;
        }
        List<Atom> thisPosLiterals = this.negatedDNF.getPosLiterals();
        List<Atom> otherPosLiterals = otherRule.negatedDNF.getPosLiterals();
        if (thisPosLiterals.size() != otherPosLiterals.size()) {
            return false;
        }
        List<Atom> thisNegLiterals = this.negatedDNF.getNegLiterals();
        List<Atom> otherNegLiterals = otherRule.negatedDNF.getNegLiterals();
        if (thisNegLiterals.size() != otherNegLiterals.size()) {
            return false;
        }
        return new HashSet<Atom>(thisPosLiterals).equals(new HashSet<Atom>(otherPosLiterals)) && new HashSet<Atom>(thisNegLiterals).equals(new HashSet<Atom>(otherNegLiterals));
    }

    protected abstract AbstractGroundLogicalRule groundFormulaInstance(List<GroundAtom> var1, List<GroundAtom> var2, short var3);

    private GroundRule groundInternal(Constant[] row, Map<Variable, Integer> variableMap, AtomManager atomManager, GroundingResources resources) {
        resources.positiveAtoms.clear();
        resources.negativeAtoms.clear();
        resources.accessExceptionAtoms.clear();
        short rvaCount = 0;
        short positiveRVACount = this.createAtoms(atomManager, variableMap, resources, this.negatedDNF.getPosLiterals(), row, resources.positiveAtomArgs, resources.positiveAtoms, 0.0);
        if (positiveRVACount == -1) {
            return null;
        }
        rvaCount = (short)(rvaCount + positiveRVACount);
        short negativeRVACount = this.createAtoms(atomManager, variableMap, resources, this.negatedDNF.getNegLiterals(), row, resources.negativeAtomArgs, resources.negativeAtoms, 1.0);
        if (negativeRVACount == -1) {
            return null;
        }
        if ((rvaCount = (short)(rvaCount + negativeRVACount)) == 0) {
            return null;
        }
        if (resources.accessExceptionAtoms.size() != 0) {
            RuntimeException ex = new RuntimeException(String.format("Found one or more RandomVariableAtoms (target ground atom) that were not explicitly specified in the targets. Offending atom(s): %s. This typically means that your specified target set is insufficient. This was encountered during the grounding of the rule: [%s].", resources.accessExceptionAtoms, this));
            atomManager.reportAccessException(ex, resources.accessExceptionAtoms.iterator().next());
        }
        return this.groundFormulaInstance(resources.positiveAtoms, resources.negativeAtoms, rvaCount);
    }

    private short createAtoms(AtomManager atomManager, Map<Variable, Integer> variableMap, GroundingResources resources, List<Atom> literals, Constant[] row, Constant[][] argumentBuffer, List<GroundAtom> groundAtoms, double trivialValue) {
        GroundAtom atom = null;
        short rvaCount = 0;
        for (int i = 0; i < literals.size(); ++i) {
            if (literals.get(i).getPredicate() instanceof GroundingOnlyPredicate) continue;
            atom = ((QueryAtom)literals.get(i)).ground(atomManager, row, variableMap, argumentBuffer[i]);
            if (atom instanceof RandomVariableAtom) {
                if (((RandomVariableAtom)atom).getAccessException()) {
                    resources.accessExceptionAtoms.add((RandomVariableAtom)atom);
                }
                rvaCount = (short)(rvaCount + 1);
            } else if (MathUtils.equals((double)atom.getValue(), trivialValue)) {
                return -1;
            }
            groundAtoms.add(atom);
        }
        return rvaCount;
    }

    private static class GroundingResources {
        public List<GroundAtom> positiveAtoms = new ArrayList<GroundAtom>(4);
        public List<GroundAtom> negativeAtoms = new ArrayList<GroundAtom>(4);
        public Set<GroundAtom> accessExceptionAtoms = new HashSet<GroundAtom>(4);
        public Constant[][] positiveAtomArgs;
        public Constant[][] negativeAtomArgs;

        public GroundingResources(FormulaAnalysis.DNFClause negatedDNF) {
            int i;
            int numLiterals = negatedDNF.getPosLiterals().size() + negatedDNF.getNegLiterals().size();
            this.positiveAtomArgs = new Constant[negatedDNF.getPosLiterals().size()][];
            for (i = 0; i < negatedDNF.getPosLiterals().size(); ++i) {
                this.positiveAtomArgs[i] = new Constant[negatedDNF.getPosLiterals().get(i).getArity()];
            }
            this.negativeAtomArgs = new Constant[negatedDNF.getNegLiterals().size()][];
            for (i = 0; i < negatedDNF.getNegLiterals().size(); ++i) {
                this.negativeAtomArgs[i] = new Constant[negatedDNF.getNegLiterals().get(i).getArity()];
            }
        }
    }
}

