/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.rule.logical.UnweightedLogicalRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.IteratorUtils;

public class UnweightedGroundLogicalRule
extends AbstractGroundLogicalRule
implements UnweightedGroundRule {
    protected UnweightedGroundLogicalRule(UnweightedLogicalRule rule, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals, short rvaCount) {
        super(rule, posLiterals, negLiterals, rvaCount);
    }

    @Override
    public UnweightedRule getRule() {
        return (UnweightedRule)((Object)this.rule);
    }

    @Override
    public double getInfeasibility() {
        return Math.abs((double)this.function.getValue() - 1.0);
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        return new ConstraintTerm(this.function, FunctionComparator.SmallerThan, 0.0f);
    }

    @Override
    public String toString() {
        return super.toString() + " .";
    }

    @Override
    protected GroundRule instantiateNegatedGroundRule(Formula disjunction, List<GroundAtom> positiveAtoms, List<GroundAtom> negativeAtoms, String name) {
        short rvaCount = 0;
        for (GroundAtom atom : IteratorUtils.join(positiveAtoms, negativeAtoms)) {
            if (!(atom instanceof RandomVariableAtom)) continue;
            rvaCount = (short)(rvaCount + 1);
        }
        UnweightedLogicalRule newRule = new UnweightedLogicalRule(this.rule.getFormula(), name);
        return new UnweightedGroundLogicalRule(newRule, positiveAtoms, negativeAtoms, rvaCount);
    }
}

