/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.Hyperplane;
import org.linqs.psl.reasoner.admm.term.LocalVariable;

public class LinearLossTerm
extends ADMMObjectiveTerm {
    private final float[] coefficients;

    LinearLossTerm(GroundRule groundRule, Hyperplane hyperplane) {
        super(hyperplane, groundRule);
        this.coefficients = hyperplane.getCoefficients();
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        for (int i = 0; i < this.size; ++i) {
            LocalVariable variable = this.variables[i];
            float value = consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize;
            variable.setValue(value -= weight * this.coefficients[i] / stepSize);
        }
    }

    @Override
    public float evaluate() {
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        float value = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * this.variables[i].getValue();
        }
        return weight * value;
    }
}

