/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Iterator;
import org.linqs.psl.config.Config;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermStore;

public class MemoryTermStore<E extends ReasonerTerm>
implements TermStore<E> {
    public static final String CONFIG_PREFIX = "memorytermstore";
    public static final String INITIAL_SIZE_KEY = "memorytermstore.initialsize";
    public static final int INITIAL_SIZE_DEFAULT = 5000;
    private ArrayList<E> store;

    public MemoryTermStore() {
        this(Config.getInt(INITIAL_SIZE_KEY, 5000));
    }

    public MemoryTermStore(int initialSize) {
        this.store = new ArrayList(initialSize);
    }

    @Override
    public synchronized void add(GroundRule rule, E term) {
        this.store.add(term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        this.store = null;
    }

    @Override
    public E get(int index) {
        return (E)((ReasonerTerm)this.store.get(index));
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        assert (capacity >= 0);
        if (capacity == 0) {
            return;
        }
        this.store.ensureCapacity(capacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.store.iterator();
    }
}

