"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * Use a CloudFront Distribution as an alias record target.
 *
 * @stability stable
 */
class CloudFrontTarget {
    /**
     * @stability stable
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @stability stable
     */
    static getHostedZoneId(scope) {
        var _b;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_b = scopeStack.node.tryFindChild(mappingName)) !== null && _b !== void 0 ? _b : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.distributionDomainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.CloudFrontTarget", version: "1.141.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 *
 * @stability stable
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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