"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticBeanstalkEnvironmentEndpointTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use an Elastic Beanstalk environment URL as an alias record target. E.g. mysampleenvironment.xyz.us-east-1.elasticbeanstalk.com.
 *
 * Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 *
 * @stability stable
 */
class ElasticBeanstalkEnvironmentEndpointTarget {
    /**
     * @stability stable
     */
    constructor(environmentEndpoint) {
        this.environmentEndpoint = environmentEndpoint;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        if (cdk.Token.isUnresolved(this.environmentEndpoint)) {
            throw new Error('Cannot use an EBS alias as `environmentEndpoint`. You must find your EBS environment endpoint via the AWS console. See the Elastic Beanstalk developer guide: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html');
        }
        const dnsName = this.environmentEndpoint;
        const region = cdk.Fn.select(2, cdk.Fn.split('.', dnsName));
        const { ebsEnvEndpointHostedZoneId: hostedZoneId } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Elastic Beanstalk environment target is not supported for the "${region}" region.`);
        }
        return {
            hostedZoneId,
            dnsName,
        };
    }
}
exports.ElasticBeanstalkEnvironmentEndpointTarget = ElasticBeanstalkEnvironmentEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
ElasticBeanstalkEnvironmentEndpointTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.ElasticBeanstalkEnvironmentEndpointTarget", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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