"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53RecordTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use another Route 53 record as an alias record target.
 *
 * @stability stable
 */
class Route53RecordTarget {
    /**
     * @stability stable
     */
    constructor(record) {
        this.record = record;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, zone) {
        if (!zone) { // zone introduced as optional to avoid a breaking change
            throw new Error('Cannot bind to record without a zone');
        }
        return {
            dnsName: this.record.domainName,
            hostedZoneId: zone.hostedZoneId,
        };
    }
}
exports.Route53RecordTarget = Route53RecordTarget;
_a = JSII_RTTI_SYMBOL_1;
Route53RecordTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.Route53RecordTarget", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGU1My1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZTUzLXJlY29yZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBR0EsTUFBYSxtQkFBbUI7Ozs7SUFDOUIsWUFBNkIsTUFBMEI7UUFBMUIsV0FBTSxHQUFOLE1BQU0sQ0FBb0I7S0FDdEQ7Ozs7OztJQUVNLElBQUksQ0FBQyxPQUEyQixFQUFFLElBQTBCO1FBQ2pFLElBQUksQ0FBQyxJQUFJLEVBQUUsRUFBRSx5REFBeUQ7WUFDcEUsTUFBTSxJQUFJLEtBQUssQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO1NBQ3pEO1FBQ0QsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVU7WUFDL0IsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1NBQ2hDLENBQUM7S0FDSDs7QUFaSCxrREFhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUm91dGU1M1JlY29yZFRhcmdldCBpbXBsZW1lbnRzIHJvdXRlNTMuSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSByZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCkge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0LCB6b25lPzogcm91dGU1My5JSG9zdGVkWm9uZSk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIGlmICghem9uZSkgeyAvLyB6b25lIGludHJvZHVjZWQgYXMgb3B0aW9uYWwgdG8gYXZvaWQgYSBicmVha2luZyBjaGFuZ2VcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGJpbmQgdG8gcmVjb3JkIHdpdGhvdXQgYSB6b25lJyk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICBkbnNOYW1lOiB0aGlzLnJlY29yZC5kb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZUlkOiB6b25lLmhvc3RlZFpvbmVJZCxcbiAgICB9O1xuICB9XG59XG4iXX0=