# Generated by Django 3.2.7 on 2022-02-28 19:16

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentGateway',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('thumbnail', models.ImageField(blank=True, null=True, upload_to='', verbose_name='Icon')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('rate_method', models.CharField(choices=[('PERCENT', 'Percentage'), ('NOMINAL', 'Nominal')], default='PERCENT', max_length=128, verbose_name='Rate method')),
                ('transfer_fee', models.DecimalField(decimal_places=2, default=0, max_digits=10, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Transfer fee')),
                ('auto_confirm', models.BooleanField(default=False, help_text='Customer should inform payment manual if false', verbose_name='Auto confirmation')),
                ('active', models.BooleanField(default=True)),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_payments.paymentgateway_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Gateway',
                'verbose_name_plural': 'Gateways',
                'db_table': 'simpel_payment_gateway',
            },
        ),
        migrations.CreateModel(
            name='CashGateway',
            fields=[
                ('paymentgateway_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_payments.paymentgateway')),
            ],
            options={
                'verbose_name': 'Cash Payment',
                'verbose_name_plural': 'Cash Payment',
                'db_table': 'simpel_payment_gateway_cash',
            },
            bases=('simpel_payments.paymentgateway',),
        ),
        migrations.CreateModel(
            name='ManualTransferGateway',
            fields=[
                ('paymentgateway_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_payments.paymentgateway')),
                ('bank_name', models.CharField(max_length=128, verbose_name='Bank Name')),
                ('bank_branch_office', models.CharField(max_length=128, verbose_name='Branch Office')),
                ('bank_account', models.CharField(max_length=128, verbose_name='Account number')),
                ('bank_holder_name', models.CharField(max_length=128, verbose_name='Account holder')),
            ],
            options={
                'verbose_name': 'Manual Transfer',
                'verbose_name_plural': 'Manual Transfers',
                'db_table': 'simpel_payment_gateway_manual_transfer',
            },
            bases=('simpel_payments.paymentgateway',),
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('date_pending', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date pending')),
                ('date_validated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date validated')),
                ('date_canceled', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date canceled')),
                ('date_approved', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date approved')),
                ('date_rejected', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date rejected')),
                ('status', models.IntegerField(choices=[(23, 'Pending'), (17, 'Validated'), (19, 'Rejected'), (18, 'Approved'), (40, 'Canceled')], default=23, verbose_name='Status')),
                ('type', models.CharField(choices=[('RCP', 'Receipt'), ('CWD', 'Withdraw')], default='RCP', max_length=15, verbose_name='Type')),
                ('reference_id', models.CharField(max_length=255, null=True, verbose_name='Reference')),
                ('amount', models.DecimalField(decimal_places=2, default=0, max_digits=15, verbose_name='Amount')),
                ('note', models.CharField(blank=True, default='', max_length=255, null=True, verbose_name='Memo')),
                ('gateway', models.ForeignKey(blank=True, help_text='Payment gateway', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='payments', to='simpel_payments.paymentgateway')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_payments.payment_set+', to='contenttypes.contenttype')),
                ('reference_type', models.ForeignKey(blank=True, help_text='Please select reference type, then provide valid inner id as reference, otherwise leave it blank.', limit_choices_to={'model__in': ['invoice', 'salesorder']}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='payments', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='payments', to=settings.AUTH_USER_MODEL, verbose_name='Created By')),
            ],
            options={
                'verbose_name': 'Payment',
                'verbose_name_plural': 'Payments',
                'db_table': 'simpel_payment',
                'permissions': (('validate_payment', 'Can validate Payment'), ('approve_payment', 'Can approve Payment'), ('reject_payment', 'Can reject Payment'), ('cancel_payment', 'Can cancel Payment'), ('export_payment', 'Can export Payment'), ('import_payment', 'Can import Payment')),
            },
        ),
    ]
