"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
class SecureLogBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props?.bucketName,
            encryption: props?.encryption ?? aws_secure_bucket_1.SecureBucketEncryption.S3_MANAGED,
            versioned: true,
            objectOwnership: props?.objectOwnership,
            lifecycleRules: [{
                    id: 'archive-step-lifecycle-rule',
                    enabled: true,
                    transitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.infrequentAccessDays ?? 60),
                        },
                        {
                            storageClass: s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.intelligentTieringDays ?? 120),
                        },
                        {
                            storageClass: s3.StorageClass.GLACIER,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.glacierDays ?? 180),
                        },
                        {
                            storageClass: s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.deepArchiveDays ?? 360),
                        },
                    ],
                }],
        });
    }
}
exports.SecureLogBucket = SecureLogBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureLogBucket[_a] = { fqn: "@gammarer/aws-secure-log-bucket.SecureLogBucket", version: "1.3.1" };
//# sourceMappingURL=data:application/json;base64,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