# coding: utf-8
"""
Draw Named Events.
"""
from __future__ import annotations


class DrawNamedEvent:
    """
    Named events for utils.draw.Draw class
    """

    GET_SHAPES_ERROR = "draw_get_shapes_error"
    """Draw get_shapes error command see :py:meth:`Draw.get_shapes() <.utils.draw.Draw.get_shapes>`"""

    EXPORTING_PAGE_PNG = "draw_exporting_page_png"
    """
    Exporting a Draw Page to image format of PNG.
    """
    EXPORTED_PAGE_PNG = "draw_exported_page_png"
    """
    Exported a Draw Page to image format of PNG.
    """

    EXPORTING_PAGE_JPG = "draw_exporting_page_jpg"
    """
    Exporting a Draw Page to image format of JPG.
    """
    EXPORTED_PAGE_JPG = "draw_exported_page_jpg"
    """
    Exported a Draw Page to image format of JPG.
    """

    EXPORTING_SHAPE_PNG = "draw_exporting_page_png"
    """
    Exporting a Shape to image format of PNG.
    """
    EXPORTED_SHAPE_PNG = "draw_exported_page_png"
    """
    Exported a Shape to image format of PNG.
    """

    EXPORTING_SHAPE_JPG = "draw_exporting_page_jpg"
    """
    Exporting a Shape to image format of JPG.
    """
    EXPORTED_SHAPE_JPG = "draw_exported_page_jpg"
    """
    Exported a Shape to image format of JPG.
    """
