from __future__ import annotations
from enum import Enum


class UnitEnergyKind(Enum):
    """Energy units"""

    # CALORIE_THERMO_PICO = "pc" # don't know why but this one errors with Err:502
    # """pico Thermochemicial calorie 10/-12"""
    BTU = "BTU"
    """British Thermal Unit"""
    CALORIE_INT_YOTTA = "Ycal"
    """yotta International Steam Table calorie 10/24"""
    CALORIE_INT_ZETTA = "Zcal"
    """zetta International Steam Table calorie 10/21"""
    CALORIE_INT_EXA = "Ecal"
    """exa 10/18"""
    CALORIE_INT_PETA = "Pcal"
    """peta International Steam Table calorie 10/15"""
    CALORIE_INT_TERA = "Tcal"
    """tera International Steam Table calorie 10/12"""
    CALORIE_INT_GIGA = "Gcal"
    """giga International Steam Table calorie 10/9"""
    CALORIE_INT_MEGA = "Mcal"
    """mega International Steam Table calorie 10/6"""
    CALORIE_INT_KILO = "kcal"
    """kilo International Steam Table calorie 10/3"""
    CALORIE_INT_HECTO = "hcal"
    """hecto International Steam Table calorie 10/2"""
    CALORIE_INT_DECA = "ecal"
    """deca International Steam Table calorie 10/1"""
    CALORIE_INT = "cal"
    """International Steam Table calorie"""
    CALORIE_INT_DECI = "dcal"
    """deci International Steam Table calorie 10/-1"""
    CALORIE_INT_CENTI = "ccal"
    """centi International Steam Table calorie 10/-2"""
    CALORIE_INT_MILLI = "mcal"
    """milli International Steam Table calorie 10/-3"""
    CALORIE_INT_MICRO = "ucal"
    """micro International Steam Table calorie 10/-6"""
    CALORIE_INT_NANO = "ncal"
    """nano International Steam Table calorie 10/-9"""
    CALORIE_INT_PICO = "pcal"
    """pico International Steam Table calorie 10/-12"""
    CALORIE_INT_FEMTO = "fcal"
    """femto International Steam Table calorie 10/-15"""
    CALORIE_INT_ATTO = "acal"
    """atto International Steam Table calorie 10/-18"""
    CALORIE_INT_ZEPTO = "zcal"
    """zepto International Steam Table calorie 10/-21"""
    CALORIE_INT_YOCTO = "ycal"
    """yocto International Steam Table calorie 10/-24"""
    CALORIE_THERMO_YOTTA = "Yc"
    """yotta Thermochemicial calorie 10/24"""
    CALORIE_THERMO_ZETTA = "Zc"
    """zetta Thermochemicial calorie 10/21"""
    CALORIE_THERMO_EXA = "Ec"
    """exa 10/18"""
    CALORIE_THERMO_PETA = "Pc"
    """peta Thermochemicial calorie 10/15"""
    CALORIE_THERMO_TERA = "Tc"
    """tera Thermochemicial calorie 10/12"""
    CALORIE_THERMO_GIGA = "Gc"
    """giga Thermochemicial calorie 10/9"""
    CALORIE_THERMO_MEGA = "Mc"
    """mega Thermochemicial calorie 10/6"""
    CALORIE_THERMO_KILO = "kc"
    """kilo Thermochemicial calorie 10/3"""
    CALORIE_THERMO_HECTO = "hc"
    """hecto Thermochemicial calorie 10/2"""
    CALORIE_THERMO_DECA = "ec"
    """deca Thermochemicial calorie 10/1"""
    CALORIE_THERMO = "c"
    """Thermochemicial calorie"""
    CALORIE_THERMO_DECI = "dc"
    """deci Thermochemicial calorie 10/-1"""
    CALORIE_THERMO_CENTI = "cc"
    """centi Thermochemicial calorie 10/-2"""
    CALORIE_THERMO_MILLI = "mc"
    """milli Thermochemicial calorie 10/-3"""
    CALORIE_THERMO_MICRO = "uc"
    """micro Thermochemicial calorie 10/-6"""
    CALORIE_THERMO_NANO = "nc"
    """nano Thermochemicial calorie 10/-9"""

    CALORIE_THERMO_FEMTO = "fc"
    """femto Thermochemicial calorie 10/-15"""
    CALORIE_THERMO_ATTO = "ac"
    """atto Thermochemicial calorie 10/-18"""
    CALORIE_THERMO_ZEPTO = "zc"
    """zepto Thermochemicial calorie 10/-21"""
    CALORIE_THERMO_YOCTO = "yc"
    """yocto Thermochemicial calorie 10/-24"""
    ERG_YOTTA = "Ye"
    """yotta erg 10/24"""
    ERG_ZETTA = "Ze"
    """zetta erg 10/21"""
    ERG_EXA = "Ee"
    """exa 10/18"""
    ERG_PETA = "Pe"
    """peta erg 10/15"""
    ERG_TERA = "Te"
    """tera erg 10/12"""
    ERG_GIGA = "Ge"
    """giga erg 10/9"""
    ERG_MEGA = "Me"
    """mega erg 10/6"""
    ERG_KILO = "ke"
    """kilo erg 10/3"""
    ERG_HECTO = "he"
    """hecto erg 10/2"""
    ERG_DECA = "ee"
    """deca erg 10/1"""
    ERG = "e"
    """erg 10/0"""
    ERG_DECI = "de"
    """deci erg 10/-1"""
    ERG_CENTI = "ce"
    """centi erg 10/-2"""
    ERG_MILLI = "me"
    """milli erg 10/-3"""
    ERG_MICRO = "ue"
    """micro erg 10/-6"""
    ERG_NANO = "ne"
    """nano erg 10/-9"""
    ERG_PICO = "pe"
    """pico erg 10/-12"""
    ERG_FEMTO = "fe"
    """femto erg 10/-15"""
    ERG_ATTO = "ae"
    """atto erg 10/-18"""
    ERG_ZEPTO = "ze"
    """zepto erg 10/-21"""
    ERG_YOCTO = "ye"
    """yocto erg 10/-24"""
    ELECTRON_VOLT_YOTTA = "YeV"
    """yotta erg 10/24"""
    ELECTRON_VOLT_ZETTA = "ZeV"
    """zetta erg 10/21"""
    ELECTRON_VOLT_EXA = "EeV"
    """exa 10/18"""
    ELECTRON_VOLT_PETA = "PeV"
    """peta erg 10/15"""
    ELECTRON_VOLT_TERA = "TeV"
    """tera erg 10/12"""
    ELECTRON_VOLT_GIGA = "GeV"
    """giga erg 10/9"""
    ELECTRON_VOLT_MEGA = "MeV"
    """mega erg 10/6"""
    ELECTRON_VOLT_KILO = "keV"
    """kilo erg 10/3"""
    ELECTRON_VOLT_HECTO = "heV"
    """hecto erg 10/2"""
    ELECTRON_VOLT_DECA = "eeV"
    """deca erg 10/1"""
    ELECTRON_VOLT = "eV"
    """erg 10/0"""
    ELECTRON_VOLT_DECI = "deV"
    """deci erg 10/-1"""
    ELECTRON_VOLT_CENTI = "ceV"
    """centi erg 10/-2"""
    ELECTRON_VOLT_MILLI = "meV"
    """milli erg 10/-3"""
    ELECTRON_VOLT_MICRO = "ueV"
    """micro erg 10/-6"""
    ELECTRON_VOLT_NANO = "neV"
    """nano erg 10/-9"""
    ELECTRON_VOLT_PICO = "peV"
    """pico erg 10/-12"""
    ELECTRON_VOLT_FEMTO = "feV"
    """femto erg 10/-15"""
    ELECTRON_VOLT_ATTO = "aeV"
    """atto erg 10/-18"""
    ELECTRON_VOLT_ZEPTO = "zeV"
    """zepto erg 10/-21"""
    ELECTRON_VOLT_YOCTO = "yeV"
    """yocto erg 10/-24"""
    FT_POUND = "flb"
    """foot-pound"""
    JOULE_YOTTA = "YJ"
    """yotta Joule 10/24"""
    JOULE_ZETTA = "ZJ"
    """zetta Joule 10/21"""
    JOULE_EXA = "EJ"
    """exa 10/18"""
    JOULE_PETA = "PJ"
    """peta Joule 10/15"""
    JOULE_TERA = "TJ"
    """tera Joule 10/12"""
    JOULE_GIGA = "GJ"
    """giga Joule 10/9"""
    JOULE_MEGA = "MJ"
    """mega Joule 10/6"""
    JOULE_KILO = "kJ"
    """kilo Joule 10/3"""
    JOULE_HECTO = "hJ"
    """hecto Joule 10/2"""
    JOULE_DECA = "eJ"
    """deca Joule 10/1"""
    JOULE = "J"
    """Joule 10/0"""
    JOULE_DECI = "dJ"
    """deci Joule 10/-1"""
    JOULE_CENTI = "cJ"
    """centi Joule 10/-2"""
    JOULE_MILLI = "mJ"
    """milli Joule 10/-3"""
    JOULE_MICRO = "uJ"
    """micro Joule 10/-6"""
    JOULE_NANO = "nJ"
    """nano Joule 10/-9"""
    JOULE_PICO = "pJ"
    """pico Joule 10/-12"""
    JOULE_FEMTO = "fJ"
    """femto Joule 10/-15"""
    JOULE_ATTO = "aJ"
    """atto Joule 10/-18"""
    JOULE_ZEPTO = "zJ"
    """zepto Joule 10/-21"""
    JOULE_YOCTO = "yJ"

    """yocto Joule 10/-24"""
    WATT_HOUR_YOTTA = "YWh"
    """yotta Watt-hour 10/24"""
    WATT_HOUR_ZETTA = "ZWh"
    """zetta Watt-hour 10/21"""
    WATT_HOUR_EXA = "EWh"
    """exa 10/18"""
    WATT_HOUR_PETA = "PWh"
    """peta Watt-hour 10/15"""
    WATT_HOUR_TERA = "TWh"
    """tera Watt-hour 10/12"""
    WATT_HOUR_GIGA = "GWh"
    """giga Watt-hour 10/9"""
    WATT_HOUR_MEGA = "MWh"
    """mega Watt-hour 10/6"""
    WATT_HOUR_KILO = "kWh"
    """kilo Watt-hour 10/3"""
    WATT_HOUR_HECTO = "hWh"
    """hecto Watt-hour 10/2"""
    WATT_HOUR_DECA = "eWh"
    """deca Watt-hour 10/1"""
    WATT_HOUR = "Wh"
    """Watt-hour 10/0"""
    WATT_HOUR_DECI = "dWh"
    """deci Watt-hour 10/-1"""
    WATT_HOUR_CENTI = "cWh"
    """centi Watt-hour 10/-2"""
    WATT_HOUR_MILLI = "mWh"
    """milli Watt-hour 10/-3"""
    WATT_HOUR_MICRO = "uWh"
    """micro Watt-hour 10/-6"""
    WATT_HOUR_NANO = "nWh"
    """nano Watt-hour 10/-9"""
    WATT_HOUR_PICO = "pWh"
    """pico Watt-hour 10/-12"""
    WATT_HOUR_FEMTO = "fWh"
    """femto Watt-hour 10/-15"""
    WATT_HOUR_ATTO = "aWh"
    """atto Watt-hour 10/-18"""
    WATT_HOUR_ZEPTO = "zWh"
    """zepto Watt-hour 10/-21"""
    WATT_HOUR_YOCTO = "yWh"
    """yocto Watt-hour 10/-24"""

    def __str__(self) -> str:
        return self.value
