from __future__ import annotations
from enum import Enum


class UnitFluxDensityKind(Enum):
    """Flux Density units"""

    GAUSS_YOTTA = "Yga"
    """yotta Gauss 10/24"""
    GAUSS_ZETTA = "Zga"
    """zetta Gauss 10/21"""
    GAUSS_EXA = "Ega"
    """exa 10/18"""
    GAUSS_PETA = "Pga"
    """peta Gauss 10/15"""
    GAUSS_TERA = "Tga"
    """tera Gauss 10/12"""
    GAUSS_GIGA = "Gga"
    """giga Gauss 10/9"""
    GAUSS_MEGA = "Mga"
    """mega Gauss 10/6"""
    GAUSS_KILO = "kga"
    """kilo Gauss 10/3"""
    GAUSS_HECTO = "hga"
    """hecto Gauss 10/2"""
    GAUSS_DECA = "ega"
    """deca Gauss 10/1"""
    GAUSS = "ga"
    """Gauss 10/0"""
    GAUSS_DECI = "dga"
    """deci Gauss 10/-1"""
    GAUSS_CENTI = "cga"
    """centi Gauss 10/-2"""
    GAUSS_MILLI = "mga"
    """milli Gauss 10/-3"""
    GAUSS_MICRO = "uga"
    """micro Gauss 10/-6"""
    GAUSS_NANO = "nga"
    """nano Gauss 10/-9"""
    GAUSS_PICO = "pga"
    """pico Gauss 10/-12"""
    GAUSS_FEMTO = "fga"
    """femto Gauss 10/-15"""
    GAUSS_ATTO = "aga"
    """atto Gauss 10/-18"""
    GAUSS_ZEPTO = "zga"
    """zepto Gauss 10/-21"""
    GAUSS_YOCTO = "yga"
    """yocto Gauss 10/-24"""
    TESLA_YOTTA = "YT"
    """yotta Tesla 10/24"""
    TESLA_ZETTA = "ZT"
    """zetta Tesla 10/21"""
    TESLA_EXA = "ET"
    """exa 10/18"""
    TESLA_PETA = "PT"
    """peta Tesla 10/15"""
    TESLA_TERA = "TT"
    """tera Tesla 10/12"""
    TESLA_GIGA = "GT"
    """giga Tesla 10/9"""
    TESLA_MEGA = "MT"
    """mega Tesla 10/6"""
    TESLA_KILO = "kT"
    """kilo Tesla 10/3"""
    TESLA_HECTO = "hT"
    """hecto Tesla 10/2"""
    TESLA_DECA = "eT"
    """deca Tesla 10/1"""
    TESLA = "T"
    """Tesla 10/0"""
    TESLA_DECI = "dT"
    """deci Tesla 10/-1"""
    TESLA_CENTI = "cT"
    """centi Tesla 10/-2"""
    TESLA_MILLI = "mT"
    """milli Tesla 10/-3"""
    TESLA_MICRO = "uT"
    """micro Tesla 10/-6"""
    TESLA_NANO = "nT"
    """nano Tesla 10/-9"""
    TESLA_PICO = "pT"
    """pico Tesla 10/-12"""
    TESLA_FEMTO = "fT"
    """femto Tesla 10/-15"""
    TESLA_ATTO = "aT"
    """atto Tesla 10/-18"""
    TESLA_ZEPTO = "zT"
    """zepto Tesla 10/-21"""
    TESLA_YOCTO = "yT"
    """yocto Tesla 10/-24"""

    def __str__(self) -> str:
        return self.value
