from __future__ import annotations
from enum import Enum


class UnitLengthKind(Enum):
    """Length units"""

    ANG_YOTTA = "Yang"
    """yotta Angstrom 10/24"""
    ANG_ZETTA = "Zang"
    """zetta Angstrom 10/21"""
    ANG_EXA = "Eang"
    """exa 10/18"""
    ANG_PETA = "Pang"
    """peta Angstrom 10/15"""
    ANG_TERA = "Tang"
    """tera Angstrom 10/12"""
    ANG_GIGA = "Gang"
    """giga Angstrom 10/9"""
    ANG_MEGA = "Mang"
    """mega Angstrom 10/6"""
    ANG_KILO = "kang"
    """kilo Angstrom 10/3"""
    ANG_HECTO = "hang"
    """hecto Angstrom 10/2"""
    ANG_DECA = "eang"
    """deca Angstrom 10/1"""
    ANG = "ang"
    """ang"""
    ANG_DECI = "dang"
    """deci Angstrom 10/-1"""
    ANG_CENTI = "cang"
    """centi Angstrom 10/-2"""
    ANG_MILLI = "mang"
    """milli Angstrom 10/-3"""
    ANG_MICRO = "uang"
    """micro Angstrom 10/-6"""
    ANG_NANO = "nang"
    """nano Angstrom 10/-9"""
    ANG_PICO = "pang"
    """pico Angstrom 10/-12"""
    ANG_FEMTO = "fang"
    """femto Angstrom 10/-15"""
    ANG_ATTO = "aang"
    """atto Angstrom 10/-18"""
    ANG_ZEPTO = "zang"
    """zepto Angstrom 10/-21"""
    ANG_YOCTO = "yang"
    """yocto Angstrom 10/-24"""
    ELL = "ell"
    """ell"""
    IN = "in"
    """inch"""
    LIGHT_YEAR_YOTTA = "Yly"
    """yotta Light-year 10/24"""
    LIGHT_YEAR_ZETTA = "Zly"
    """zetta Light-year 10/21"""
    LIGHT_YEAR_EXA = "Ely"
    """exa 10/18"""
    LIGHT_YEAR_PETA = "Ply"
    """peta Light-year 10/15"""
    LIGHT_YEAR_TERA = "Tly"
    """tera Light-year 10/12"""
    LIGHT_YEAR_GIGA = "Gly"
    """giga Light-year 10/9"""
    LIGHT_YEAR_MEGA = "Mly"
    """mega Light-year 10/6"""
    LIGHT_YEAR_KILO = "kly"
    """kilo Light-year 10/3"""
    LIGHT_YEAR_HECTO = "hly"
    """hecto Light-year 10/2"""
    LIGHT_YEAR_DECA = "ely"
    """deca Light-year 10/1"""
    LIGHT_YEAR = "ly"
    """Light-year"""
    LIGHT_YEAR_DECI = "dly"
    """deci Light-year 10/-1"""
    LIGHT_YEAR_CENTI = "cly"
    """centi Light-year 10/-2"""
    LIGHT_YEAR_MILLI = "mly"
    """milli Light-year 10/-3"""
    LIGHT_YEAR_MICRO = "uly"
    """micro Light-year 10/-6"""
    LIGHT_YEAR_NANO = "nly"
    """nano Light-year 10/-9"""
    LIGHT_YEAR_PICO = "ply"
    """pico Light-year 10/-12"""
    LIGHT_YEAR_FEMTO = "fly"
    """femto Light-year 10/-15"""
    LIGHT_YEAR_ATTO = "aly"
    """atto Light-year 10/-18"""
    LIGHT_YEAR_ZEPTO = "zly"
    """zepto Light-year 10/-21"""
    LIGHT_YEAR_YOCTO = "yly"
    """yocto Light-year 10/-24"""
    METER_YOTTA = "Ym"
    """yotta meter 10/24"""
    METER_ZETTA = "Zm"
    """zetta meter 10/21"""
    METER_EXA = "Em"
    """exa 10/18"""
    METER_PETA = "Pm"
    """peta meter 10/15"""
    METER_TERA = "Tm"
    """tera meter 10/12"""
    METER_GIGA = "Gm"
    """giga meter 10/9"""
    METER_MEGA = "Mm"
    """mega meter 10/6"""
    METER_KILO = "km"
    """kilo meter 10/3"""
    METER_HECTO = "hm"
    """hecto meter 10/2"""
    METER_DECA = "em"
    """deca meter 10/1"""
    METER = "m"
    """meter"""
    METER_DECI = "dm"
    """deci meter 10/-1"""
    METER_CENTI = "cm"
    """centi meter 10/-2"""
    METER_MILLI = "mm"
    """milli meter 10/-3"""
    METER_MICRO = "um"
    """micro meter 10/-6"""
    METER_NANO = "nm"
    """nano meter 10/-9"""
    METER_PICO = "pm"
    """pico meter 10/-12"""
    METER_FEMTO = "fm"
    """femto meter 10/-15"""
    METER_ATTO = "am"
    """atto meter 10/-18"""
    METER_ZEPTO = "zm"
    """zepto meter 10/-21"""
    METER_YOCTO = "ym"
    """yocto meter 10/-24"""
    MILE_INTERNATIONAL = "mi"
    """mile (international)"""
    MILE_NAUTICAL = "Nmi"
    """mile (nautical)"""
    PARSEC_YOTTA = "Yparsec"
    """yotta parsec 10/24"""
    PARSEC_ZETTA = "Zparsec"
    """zetta parsec 10/21"""
    PARSEC_EXA = "Eparsec"
    """exa 10/18"""
    PARSEC_PETA = "Pparsec"
    """peta parsec 10/15"""
    PARSEC_TERA = "Tparsec"
    """tera parsec 10/12"""
    PARSEC_GIGA = "Gparsec"
    """giga parsec 10/9"""
    PARSEC_MEGA = "Mparsec"
    """mega parsec 10/6"""
    PARSEC_KILO = "kparsec"
    """kilo parsec 10/3"""
    PARSEC_HECTO = "hparsec"
    """hecto parsec 10/2"""
    PARSEC_DECA = "eparsec"
    """deca parsec 10/1"""
    PARSEC = "parsec"
    """parsec"""
    PARSEC_DECI = "dparsec"
    """deci parsec 10/-1"""
    PARSEC_CENTI = "cparsec"
    """centi parsec 10/-2"""
    PARSEC_MILLI = "mparsec"
    """milli parsec 10/-3"""
    PARSEC_MICRO = "uparsec"
    """micro parsec 10/-6"""
    PARSEC_NANO = "nparsec"
    """nano parsec 10/-9"""
    PARSEC_PICO = "pparsec"
    """pico parsec 10/-12"""
    PARSEC_FEMTO = "fparsec"
    """femto parsec 10/-15"""
    PARSEC_ATTO = "aparsec"
    """atto parsec 10/-18"""
    PARSEC_ZEPTO = "zparsec"
    """zepto parsec 10/-21"""
    PARSEC_YOCTO = "yparsec"
    """yocto parsec 10/-24"""
    PICA_POINT = "Pica"
    """pica point"""
    PICA = "pica"
    """pica"""
    MILE_US_SURVEY = "survey_mi"
    """mile (US survey)"""
    YARD = "yd"
    """yard"""
    MM = METER_MILLI
    """milli meter 10/-3"""
    CM = METER_CENTI
    """centi-meter 10/-2"""
    KM = METER_KILO
    """kilo meter 10/3"""

    def __str__(self) -> str:
        return self.value
