from __future__ import annotations
from enum import Enum


class UnitPressureKind(Enum):
    """Pressure units"""

    ATM_YOTTA = "Yatm"
    """yotta Standard atmosphere 10/24"""
    ATM_ZETTA = "Zatm"
    """zetta Standard atmosphere 10/21"""
    ATM_EXA = "Eatm"
    """exa 10/18"""
    ATM_PETA = "Patm"
    """peta Standard atmosphere 10/15"""
    ATM_TERA = "Tatm"
    """tera Standard atmosphere 10/12"""
    ATM_GIGA = "Gatm"
    """giga Standard atmosphere 10/9"""
    ATM_MEGA = "Matm"
    """mega Standard atmosphere 10/6"""
    ATM_KILO = "katm"
    """kilo Standard atmosphere 10/3"""
    ATM_HECTO = "hatm"
    """hecto Standard atmosphere 10/2"""
    ATM_DECA = "eatm"
    """deca Standard atmosphere 10/1"""
    ATM = "atm"
    """Standard atmosphere 10/0"""
    ATM_DECI = "datm"
    """deci Standard atmosphere 10/-1"""
    ATM_CENTI = "catm"
    """centi Standard atmosphere 10/-2"""
    ATM_MILLI = "matm"
    """milli Standard atmosphere 10/-3"""
    ATM_MICRO = "uatm"
    """micro Standard atmosphere 10/-6"""
    ATM_NANO = "natm"
    """nano Standard atmosphere 10/-9"""
    ATM_PICO = "patm"
    """pico Standard atmosphere 10/-12"""
    ATM_FEMTO = "fatm"
    """femto Standard atmosphere 10/-15"""
    ATM_ATTO = "aatm"
    """atto Standard atmosphere 10/-18"""
    ATM_ZEPTO = "zatm"
    """zepto Standard atmosphere 10/-21"""
    ATM_YOCTO = "yatm"
    """yocto Standard atmosphere 10/-24"""
    MM_HG_YOTTA = "YmmHg"
    """yotta Millimeter of mercury 10/24"""
    MM_HG_ZETTA = "ZmmHg"
    """zetta Millimeter of mercury 10/21"""
    MM_HG_EXA = "EmmHg"
    """exa 10/18"""
    MM_HG_PETA = "PmmHg"
    """peta Millimeter of mercury 10/15"""
    MM_HG_TERA = "TmmHg"
    """tera Millimeter of mercury 10/12"""
    MM_HG_GIGA = "GmmHg"
    """giga Millimeter of mercury 10/9"""
    MM_HG_MEGA = "MmmHg"
    """mega Millimeter of mercury 10/6"""
    MM_HG_KILO = "kmmHg"
    """kilo Millimeter of mercury 10/3"""
    MM_HG_HECTO = "hmmHg"
    """hecto Millimeter of mercury 10/2"""
    MM_HG_DECA = "emmHg"
    """deca Millimeter of mercury 10/1"""
    MM_HG = "mmHg"
    """Millimeter of mercury 10/0"""
    MM_HG_DECI = "dmmHg"
    """deci Millimeter of mercury 10/-1"""
    MM_HG_CENTI = "cmmHg"
    """centi Millimeter of mercury 10/-2"""
    MM_HG_MILLI = "mmmHg"
    """milli Millimeter of mercury 10/-3"""
    MM_HG_MICRO = "ummHg"
    """micro Millimeter of mercury 10/-6"""
    MM_HG_NANO = "nmmHg"
    """nano Millimeter of mercury 10/-9"""
    MM_HG_PICO = "pmmHg"
    """pico Millimeter of mercury 10/-12"""
    MM_HG_FEMTO = "fmmHg"
    """femto Millimeter of mercury 10/-15"""
    MM_HG_ATTO = "ammHg"
    """atto Millimeter of mercury 10/-18"""
    MM_HG_ZEPTO = "zmmHg"
    """zepto Millimeter of mercury 10/-21"""
    MM_HG_YOCTO = "ymmHg"
    """yocto Millimeter of mercury 10/-24"""
    PASCAL_YOTTA = "YPa"
    """yotta Pascal 10/24"""
    PASCAL_ZETTA = "ZPa"
    """zetta Pascal 10/21"""
    PASCAL_EXA = "EPa"
    """exa 10/18"""
    PASCAL_PETA = "PPa"
    """peta Pascal 10/15"""
    PASCAL_TERA = "TPa"
    """tera Pascal 10/12"""
    PASCAL_GIGA = "GPa"
    """giga Pascal 10/9"""
    PASCAL_MEGA = "MPa"
    """mega Pascal 10/6"""
    PASCAL_KILO = "kPa"
    """kilo Pascal 10/3"""
    PASCAL_HECTO = "hPa"
    """hecto Pascal 10/2"""
    PASCAL_DECA = "ePa"
    """deca Pascal 10/1"""
    PASCAL = "Pa"
    """Pascal 10/0"""
    PASCAL_DECI = "dPa"
    """deci Pascal 10/-1"""
    PASCAL_CENTI = "cPa"
    """centi Pascal 10/-2"""
    PASCAL_MILLI = "mPa"
    """milli Pascal 10/-3"""
    PASCAL_MICRO = "uPa"
    """micro Pascal 10/-6"""
    PASCAL_NANO = "nPa"
    """nano Pascal 10/-9"""
    PASCAL_PICO = "pPa"
    """pico Pascal 10/-12"""
    PASCAL_FEMTO = "fPa"
    """femto Pascal 10/-15"""
    PASCAL_ATTO = "aPa"
    """atto Pascal 10/-18"""
    PASCAL_ZEPTO = "zPa"
    """zepto Pascal 10/-21"""
    PASCAL_YOCTO = "yPa"
    """yocto Pascal 10/-24"""
    PSI = "psi"
    """Pound-force per square inch 10/0"""
    TORR = "Torr"
    """Torr 10/0"""

    def __str__(self) -> str:
        return self.value
