from __future__ import annotations
from enum import Enum


class UnitTempKind(Enum):
    """Temperature units"""

    C = "C"
    """Celsius 10/0"""
    F = "F"
    """Fahrenheit 10/0"""
    KELVIN_YOTTA = "YK"
    """yotta Kelvin 10/24"""
    KELVIN_ZETTA = "ZK"
    """zetta Kelvin 10/21"""
    KELVIN_EXA = "EK"
    """exa 10/18"""
    KELVIN_PETA = "PK"
    """peta Kelvin 10/15"""
    KELVIN_TERA = "TK"
    """tera Kelvin 10/12"""
    KELVIN_GIGA = "GK"
    """giga Kelvin 10/9"""
    KELVIN_MEGA = "MK"
    """mega Kelvin 10/6"""
    KELVIN_KILO = "kK"
    """kilo Kelvin 10/3"""
    KELVIN_HECTO = "hK"
    """hecto Kelvin 10/2"""
    KELVIN_DECA = "eK"
    """deca Kelvin 10/1"""
    KELVIN = "K"
    """Kelvin 10/0"""
    KELVIN_DECI = "dK"
    """deci Kelvin 10/-1"""
    KELVIN_CENTI = "cK"
    """centi Kelvin 10/-2"""
    KELVIN_MILLI = "mK"
    """milli Kelvin 10/-3"""
    KELVIN_MICRO = "uK"
    """micro Kelvin 10/-6"""
    KELVIN_NANO = "nK"
    """nano Kelvin 10/-9"""
    KELVIN_PICO = "pK"
    """pico Kelvin 10/-12"""
    KELVIN_FEMTO = "fK"
    """femto Kelvin 10/-15"""
    KELVIN_ATTO = "aK"
    """atto Kelvin 10/-18"""
    KELVIN_ZEPTO = "zK"
    """zepto Kelvin 10/-21"""
    KELVIN_YOCTO = "yK"
    """yocto Kelvin 10/-24"""
    RANK = "Rank"
    """Degrees Rankine 10/0"""
    REAU = "Reau"
    """Degrees Reaumur 10/0"""

    def __str__(self) -> str:
        return self.value
