from __future__ import annotations
from enum import Enum


class UnitTimeKind(Enum):
    """Time units"""

    DAY = "day"
    """Day 10/0"""
    HOUR = "hr"
    """Hour 10/0"""
    MINUTE = "mn"
    """Minute 10/0"""
    SEC_YOTTA = "Ysec"
    """yotta Second 10/24"""
    SEC_ZETTA = "Zsec"
    """zetta Second 10/21"""
    SEC_EXA = "Esec"
    """exa 10/18"""
    SEC_PETA = "Psec"
    """peta Second 10/15"""
    SEC_TERA = "Tsec"
    """tera Second 10/12"""
    SEC_GIGA = "Gsec"
    """giga Second 10/9"""
    SEC_MEGA = "Msec"
    """mega Second 10/6"""
    SEC_KILO = "ksec"
    """kilo Second 10/3"""
    SEC_HECTO = "hsec"
    """hecto Second 10/2"""
    SEC_DECA = "esec"
    """deca Second 10/1"""
    SEC = "sec"
    """Second 10/0"""
    SEC_DECI = "dsec"
    """deci Second 10/-1"""
    SEC_CENTI = "csec"
    """centi Second 10/-2"""
    SEC_MILLI = "msec"
    """milli Second 10/-3"""
    SEC_MICRO = "usec"
    """micro Second 10/-6"""
    SEC_NANO = "nsec"
    """nano Second 10/-9"""
    SEC_PICO = "psec"
    """pico Second 10/-12"""
    SEC_FEMTO = "fsec"
    """femto Second 10/-15"""
    SEC_ATTO = "asec"
    """atto Second 10/-18"""
    SEC_ZEPTO = "zsec"
    """zepto Second 10/-21"""
    SEC_YOCTO = "ysec"
    """yocto Second 10/-24"""
    YEAR = "yr"
    """Year 10/0"""

    def __str__(self) -> str:
        return self.value
