from __future__ import annotations
from enum import Enum


class UnitVolumeKind(Enum):
    """Volume units"""

    ANGSTROM_YOTTA = "Yang3"
    """yotta Cubic angstrom 10/24"""
    ANGSTROM_ZETTA = "Zang3"
    """zetta Cubic angstrom 10/21"""
    ANGSTROM_EXA = "Eang3"
    """exa 10/18"""
    ANGSTROM_PETA = "Pang3"
    """peta Cubic angstrom 10/15"""
    ANGSTROM_TERA = "Tang3"
    """tera Cubic angstrom 10/12"""
    ANGSTROM_GIGA = "Gang3"
    """giga Cubic angstrom 10/9"""
    ANGSTROM_MEGA = "Mang3"
    """mega Cubic angstrom 10/6"""
    ANGSTROM_KILO = "kang3"
    """kilo Cubic angstrom 10/3"""
    ANGSTROM_HECTO = "hang3"
    """hecto Cubic angstrom 10/2"""
    ANGSTROM_DECA = "eang3"
    """deca Cubic angstrom 10/1"""
    ANGSTROM = "ang3"
    """Cubic angstrom 10/0"""
    ANGSTROM_DECI = "dang3"
    """deci Cubic angstrom 10/-1"""
    ANGSTROM_CENTI = "cang3"
    """centi Cubic angstrom 10/-2"""
    ANGSTROM_MILLI = "mang3"
    """milli Cubic angstrom 10/-3"""
    ANGSTROM_MICRO = "uang3"
    """micro Cubic angstrom 10/-6"""
    ANGSTROM_NANO = "nang3"
    """nano Cubic angstrom 10/-9"""
    ANGSTROM_PICO = "pang3"
    """pico Cubic angstrom 10/-12"""
    ANGSTROM_FEMTO = "fang3"
    """femto Cubic angstrom 10/-15"""
    ANGSTROM_ATTO = "aang3"
    """atto Cubic angstrom 10/-18"""
    ANGSTROM_ZEPTO = "zang3"
    """zepto Cubic angstrom 10/-21"""
    ANGSTROM_YOCTO = "yang3"
    """yocto Cubic angstrom 10/-24"""
    BARREL_OIL = "barrel"
    """Oil barrel"""
    BUSHEL_US = "bushel"
    """Bushel"""
    CUP_US = "cup"
    """Cup"""
    FOOT_CUBIC = "ft3"
    """Cubic foot"""
    GALLON_US = "gal"
    """Gallon"""
    GLASS = "Glass"
    """Australian glass (200 milliliters)"""
    GRT = "GRT"
    """Gross register tonnage"""
    HUMPEN = "Humpen"
    """Humpen (500 milliliters)"""
    INCH_CUBIC = "in3"
    """Cubic inch"""
    LITER_YOTTA = "Yl"
    """yotta Liter 10/24"""
    LITER_ZETTA = "Zl"
    """zetta Liter 10/21"""
    LITER_EXA = "El"
    """exa 10/18"""
    LITER_PETA = "Pl"
    """peta Liter 10/15"""
    LITER_TERA = "Tl"
    """tera Liter 10/12"""
    LITER_GIGA = "Gl"
    """giga Liter 10/9"""
    LITER_MEGA = "Ml"
    """mega Liter 10/6"""
    LITER_KILO = "kl"
    """kilo Liter 10/3"""
    LITER_HECTO = "hl"
    """hecto Liter 10/2"""
    LITER_DECA = "el"
    """deca Liter 10/1"""
    LITER = "l"
    """Liter 10/0"""
    LITER_DECI = "dl"
    """deci Liter 10/-1"""
    LITER_CENTI = "cl"
    """centi Liter 10/-2"""
    LITER_MILLI = "ml"
    """milli Liter 10/-3"""
    LITER_MICRO = "ul"
    """micro Liter 10/-6"""
    LITER_NANO = "nl"
    """nano Liter 10/-9"""
    LITER_PICO = "pl"
    """pico Liter 10/-12"""
    LITER_FEMTO = "fl"
    """femto Liter 10/-15"""
    LITER_ATTO = "al"
    """atto Liter 10/-18"""
    LITER_ZEPTO = "zl"
    """zepto Liter 10/-21"""
    LITER_YOCTO = "yl"
    """yocto Liter 10/-24"""
    LIGHT_YEAR_CUBIC = "ly3"
    """Cubic light year"""
    METER_YOTTA = "Ym3"
    """yotta Cubic meter 10/24"""
    METER_ZETTA = "Zm3"
    """zetta Cubic meter 10/21"""
    METER_EXA = "Em3"
    """exa 10/18"""
    METER_PETA = "Pm3"
    """peta Cubic meter 10/15"""
    METER_TERA = "Tm3"
    """tera Cubic meter 10/12"""
    METER_GIGA = "Gm3"
    """giga Cubic meter 10/9"""
    METER_MEGA = "Mm3"
    """mega Cubic meter 10/6"""
    METER_KILO = "km3"
    """kilo Cubic meter 10/3"""
    METER_HECTO = "hm3"
    """hecto Cubic meter 10/2"""
    METER_DECA = "em3"
    """deca Cubic meter 10/1"""
    METER = "m3"
    """Cubic meter 10/0"""
    METER_DECI = "dm3"
    """deci Cubic meter 10/-1"""
    METER_CENTI = "cm3"
    """centi Cubic meter 10/-2"""
    METER_MILLI = "mm3"
    """milli Cubic meter 10/-3"""
    METER_MICRO = "um3"
    """micro Cubic meter 10/-6"""
    METER_NANO = "nm3"
    """nano Cubic meter 10/-9"""
    METER_PICO = "pm3"
    """pico Cubic meter 10/-12"""
    METER_FEMTO = "fm3"
    """femto Cubic meter 10/-15"""
    METER_ATTO = "am3"
    """atto Cubic meter 10/-18"""
    METER_ZEPTO = "zm3"
    """zepto Cubic meter 10/-21"""
    METER_YOCTO = "ym3"
    """yocto Cubic meter 10/-24"""
    MILE_CUBIC = "mi3"
    """Cubic mile (international)"""
    MIDDY = "Middy"
    """Australian middy (285 milliliters)"""
    MTON = "MTON"
    """Measurement ton"""
    MILE_NAUTICAL_CUBIC = "Nmi3"
    """Cubic nautical mile"""
    OZ = "oz"
    """Fluid ounce (us)"""
    PICA_POINT_CUBIC = "Pica3"
    """Cubic pica point"""
    PICA_CUBIC = "pica3"
    """Cubic pica"""
    PINT_US = "pt"
    """Pint"""
    QUART_US = "qt"
    """Quart"""
    SCHOONER = "Schooner"
    """Australian schooner (425 milliliters)"""
    SIX_PACK = "Sixpack"
    """Six pack (2 liters)"""
    TBS = "tbs"
    """Tablespoon (us)"""
    TEASPOON_US = "tsp"
    """Teaspoon (us)"""
    TEASPOON_METRIC = "tspm"
    """Teaspoon (metric)"""
    GALLON_IMPERIAL = "uk_gal"
    """Gallon (imperial)"""
    PINT = "uk_pt"
    """Pint (imperial)"""
    QUART_IMPERIAL = "uk_qt"
    """Quart (imperial)"""
    YARD_CUBIC = "yd3"
    """Cubic yard"""

    def __str__(self) -> str:
        return self.value
