from __future__ import annotations
from enum import Enum


class UnitWeightKind(Enum):
    """Weight units"""

    HUNDRED_WEIGHT = "cwt"
    """Hundred weight 10/0"""
    GRAM_YOTTA = "Yg"
    """yotta Gram 10/24"""
    GRAM_ZETTA = "Zg"
    """zetta Gram 10/21"""
    GRAM_EXA = "Eg"
    """exa 10/18"""
    GRAM_PETA = "Pg"
    """peta Gram 10/15"""
    GRAM_TERA = "Tg"
    """tera Gram 10/12"""
    GRAM_GIGA = "Gg"
    """giga Gram 10/9"""
    GRAM_MEGA = "Mg"
    """mega Gram 10/6"""
    GRAM_KILO = "kg"
    """kilo Gram 10/3"""
    GRAM_HECTO = "hg"
    """hecto Gram 10/2"""
    GRAM_DECA = "eg"
    """deca Gram 10/1"""
    GRAM = "g"
    """Gram 10/0"""
    GRAM_DECI = "dg"
    """deci Gram 10/-1"""
    GRAM_CENTI = "cg"
    """centi Gram 10/-2"""
    GRAM_MILLI = "mg"
    """milli Gram 10/-3"""
    GRAM_MICRO = "ug"
    """micro Gram 10/-6"""
    GRAM_NANO = "ng"
    """nano Gram 10/-9"""
    GRAM_PICO = "pg"
    """pico Gram 10/-12"""
    GRAM_FEMTO = "fg"
    """femto Gram 10/-15"""
    GRAM_ATTO = "ag"
    """atto Gram 10/-18"""
    GRAM_ZEPTO = "zg"
    """zepto Gram 10/-21"""
    GRAM_YOCTO = "yg"
    """yocto Gram 10/-24"""
    GRAIN = "grain"
    """Grain 10/0"""
    POUND = "lbm"
    """Pound mass 10/0"""
    OUNCE = "ozm"
    """Ounce mass 10/0"""
    PENNY_WEIGHT = "pweight"
    """Penny weight 10/0"""
    SLUG = "sg"
    """Slug 10/0"""
    STONE = "stone"
    """Stone 10/0"""
    TON = "ton"
    """Short Ton 10/0"""
    UAMU_YOTTA = "Yu"
    """yotta Unified atomic mass unit 10/24"""
    UAMU_ZETTA = "Zu"
    """zetta Unified atomic mass unit 10/21"""
    UAMU_EXA = "Eu"
    """exa 10/18"""
    UAMU_PETA = "Pu"
    """peta Unified atomic mass unit 10/15"""
    UAMU_TERA = "Tu"
    """tera Unified atomic mass unit 10/12"""
    UAMU_GIGA = "Gu"
    """giga Unified atomic mass unit 10/9"""
    UAMU_MEGA = "Mu"
    """mega Unified atomic mass unit 10/6"""
    UAMU_KILO = "ku"
    """kilo Unified atomic mass unit 10/3"""
    UAMU_HECTO = "hu"
    """hecto Unified atomic mass unit 10/2"""
    UAMU_DECA = "eu"
    """deca Unified atomic mass unit 10/1"""
    UAMU = "u"
    """Unified atomic mass unit 10/0"""
    UAMU_DECI = "du"
    """deci Unified atomic mass unit 10/-1"""
    UAMU_CENTI = "cu"
    """centi Unified atomic mass unit 10/-2"""
    UAMU_MILLI = "mu"
    """milli Unified atomic mass unit 10/-3"""
    UAMU_MICRO = "uu"
    """micro Unified atomic mass unit 10/-6"""
    UAMU_NANO = "nu"
    """nano Unified atomic mass unit 10/-9"""
    UAMU_PICO = "pu"
    """pico Unified atomic mass unit 10/-12"""
    UAMU_FEMTO = "fu"
    """femto Unified atomic mass unit 10/-15"""
    UAMU_ATTO = "au"
    """atto Unified atomic mass unit 10/-18"""
    UAMU_ZEPTO = "zu"
    """zepto Unified atomic mass unit 10/-21"""
    UAMU_YOCTO = "yu"
    """yocto Unified atomic mass unit 10/-24"""
    HUNDRED_WEIGHT_LONG = "uk_cwt"
    """Hundred weight 10/0"""
    TON_LONG = "uk_ton"
    """Long Ton 10/0"""

    def __str__(self) -> str:
        return self.value
