class GlobalViewDispatch:
    """
    Global View Dispatch Commands

    See Also:
        - :py:meth:`.Lo.dispatch_cmd`
        - `Global Dispatch commands <https://wiki.documentfoundation.org/Development/DispatchCommands#Global>`_
    """

    ACTIVATE = "Activate"
    BEAMER = "Beamer"
    BROWSE_VIEW = "BrowseView"
    """Web"""
    COMMAND_POPUP = "CommandPopup"
    """Search Commands"""
    CONTEXT = "Context"
    """Current Context"""
    DESIGNER_DIALOG = "DesignerDialog"
    """Show the Styles Sidebar"""
    FULL_SCREEN = "FullScreen"
    """Full Screen"""
    GRID_USE = "GridUse"
    """Snap to Grid"""
    GRID_VISIBLE = "GridVisible"
    """Display Grid"""
    HELPLINES_MOVE = "HelplinesMove"
    INSPECT_SELECTED_OBJECT = "InspectSelectedObject"
    IS_LOADING = "IsLoading"
    IS_LOADING_IMAGES = "IsLoadingImages"
    MODIFIED = "Modified"
    MODIFIED_STATUS = "ModifiedStatus"
    NEW_WINDOW = "NewWindow"
    """New Window"""
    NOTEBOOKBAR = "Notebookbar"
    OUTLINE_COLLAPSE = "OutlineCollapse"
    """Hide Sub-points"""
    OUTLINE_COLLAPSE_ALL = "OutlineCollapseAll"
    """Show Only First Level"""
    OUTLINE_DOWN = "OutlineDown"
    """Move selected paragraphs down one paragraph"""
    OUTLINE_EXPAND = "OutlineExpand"
    """Show Sub-points"""
    OUTLINE_EXPAND_ALL = "OutlineExpandAll"
    """Show All Levels"""
    OUTLINE_LEFT = "OutlineLeft"
    """Promote outline level of selected list paragraphs"""
    OUTLINE_RIGHT = "OutlineRight"
    """Demote outline level of selected list paragraphs"""
    OUTLINE_UP = "OutlineUp"
    """Move selected paragraphs up one paragraph"""
    PRINT_PREVIEW = "PrintPreview"
    """Close Preview"""
    REFRESH_VIEW = "RefreshView"
    """Refresh document layout"""
    RESTORE_EDITING_VIEW = "RestoreEditingView"
    """Restore Editing View"""
    SHOW_ANNOTATIONS = "ShowAnnotations"
    """Comments"""
    SIDEBAR = "Sidebar"
    SIDEBAR_MENU = "SidebarMenu"
    SIZE = "Size"
    SM_EDIT_OPTIONS = "SmEditOptions"
    """Formula Options"""
    STATE_TABLE_CELL = "StateTableCell"
    """Cell"""
    STATUS_BAR_VISIBLE = "StatusBarVisible"
    """Status Bar"""
    SWITCH_VIEW_SHELL = "SwitchViewShell"
    ZOOM = "Zoom"
    ZOOM_100_PERCENT = "Zoom100Percent"
    """100%"""
    ZOOM_150_PERCENT = "Zoom150Percent"
    """150%"""
    ZOOM_200_PERCENT = "Zoom200Percent"
    """200%"""
    ZOOM_50_PERCENT = "Zoom50Percent"
    """50%"""
    ZOOM_75_PERCENT = "Zoom75Percent"
    """75%"""
    ZOOM_MENU = "ZoomMenu"
    ZOOM_MINUS = "ZoomMinus"
    """Zoom Out"""
    ZOOM_NEXT = "ZoomNext"
    """Zoom Next"""
    ZOOM_OBJECTS = "ZoomObjects"
    """Object Zoom"""
    ZOOM_PAGE = "ZoomPage"
    """Entire Page"""
    ZOOM_PAGE_WIDTH = "ZoomPageWidth"
    """Page Width"""
    ZOOM_PLUS = "ZoomPlus"
    """Zoom In"""
    ZOOM_PREVIOUS = "ZoomPrevious"
    """Zoom Previous"""
    ZOOM_TOOL_BOX = "ZoomToolBox"
    """Zoom"""
