from enum import Enum
from ooodev.utils.kind import kind_helper


class ShapeDispatchKind(str, Enum):
    """
    Shapes Lookup dispatch commands for

    .. cssclass:: ul-list

        * ``3D Shapes``
        * ``.uno:ArrowShapes``
        * ``.uno:BasicShapes``
        * ``.uno:CalloutShapes``
        * ``.uno:FlowChartShapes``
        * ``.uno:StarShapes``
        * ``.uno:SymbolShapes``

    See Also:
        - :py:meth:`.Draw.add_dispatch_shape`
        - :py:meth:`.Lo.dispatch_cmd`
        - `Dispatch commands <https://wiki.documentfoundation.org/Development/DispatchCommands>`_
    """

    ARROW_SHAPES_CHEVRON = "ArrowShapes.chevron"
    """Chevron"""
    ARROW_SHAPES_CIRCULAR_ARROW = "ArrowShapes.circular-arrow"
    """Circular Arrow"""
    ARROW_SHAPES_CORNER_RIGHT_ARROW = "ArrowShapes.corner-right-arrow"
    """Corner Right Arrow"""
    ARROW_SHAPES_DOWN_ARROW = "ArrowShapes.down-arrow"
    """Down Arrow"""
    ARROW_SHAPES_DOWN_ARROW_CALLOUT = "ArrowShapes.down-arrow-callout"
    """Down Arrow Callout"""
    ARROW_SHAPES_LEFT_ARROW = "ArrowShapes.left-arrow"
    """Left Arrow"""
    ARROW_SHAPES_LEFT_ARROW_CALLOUT = "ArrowShapes.left-arrow-callout"
    """Left Arrow Callout"""
    ARROW_SHAPES_LEFT_RIGHT_ARROW = "ArrowShapes.left-right-arrow"
    """Left and Right Arrow"""
    ARROW_SHAPES_LEFT_RIGHT_ARROW_CALLOUT = "ArrowShapes.left-right-arrow-callout"
    """Left and Right Arrow Callout"""
    ARROW_SHAPES_NOTCHED_RIGHT_ARROW = "ArrowShapes.notched-right-arrow"
    """Notched Right Arrow"""
    ARROW_SHAPES_PENTAGON_RIGHT = "ArrowShapes.pentagon-right"
    """Pentagon"""
    ARROW_SHAPES_QUAD_ARROW = "ArrowShapes.quad-arrow"
    """4-way Arrow"""
    ARROW_SHAPES_QUAD_ARROW_CALLOUT = "ArrowShapes.quad-arrow-callout"
    """	4-way Arrow Callout"""
    ARROW_SHAPES_RIGHT_ARROW = "ArrowShapes.right-arrow"
    """Right Arrow"""
    ARROW_SHAPES_RIGHT_ARROW_CALLOUT = "ArrowShapes.right-arrow-callout"
    """Right Arrow Callout"""
    ARROW_SHAPES_S_SHARPED_ARROW = "ArrowShapes.s-sharped-arrow"
    """S-shaped Arrow"""
    ARROW_SHAPES_SPLIT_ARROW = "ArrowShapes.split-arrow"
    """Split Arrow"""
    ARROW_SHAPES_SPLIT_ROUND_ARROW = "ArrowShapes.split-round-arrow"
    """Right or Left Arrow"""
    ARROW_SHAPES_STRIPED_RIGHT_ARROW = "ArrowShapes.striped-right-arrow"
    """Striped Right Arrow"""
    ARROW_SHAPES_UP_ARROW = "ArrowShapes.up-arrow"
    """Up Arrow"""
    ARROW_SHAPES_UP_ARROW_CALLOUT = "ArrowShapes.up-arrow-callout"
    """Up Arrow Callout"""
    ARROW_SHAPES_UP_DOWN_ARROW = "ArrowShapes.up-down-arrow"
    """Up and Down Arrow"""
    ARROW_SHAPES_UP_DOWN_ARROW_CALLOUT = "ArrowShapes.up-down-arrow-callout"
    """Up and Down Arrow Callout"""
    ARROW_SHAPES_UP_RIGHT_ARROW = "ArrowShapes.up-right-arrow"
    """Up and Right Arrow"""
    ARROW_SHAPES_UP_RIGHT_ARROW_CALLOUT = "ArrowShapes.up-right-arrow-callout"
    """Up and Right Arrow Callout"""
    ARROW_SHAPES_UP_RIGHT_DOWN_ARROW = "ArrowShapes.up-right-down-arrow"
    """Up, Right and Down Arrow"""

    BASIC_SHAPES_BLOCK_ARC = "BasicShapes.block-arc"
    """Block Arc"""
    BASIC_SHAPES_CAN = "BasicShapes.can"
    """Cylinder"""
    BASIC_SHAPES_CIRCLE = "BasicShapes.circle"
    """Circle"""
    BASIC_SHAPES_CIRCLE_PIE = "BasicShapes.circle-pie"
    """Circle Pie"""
    BASIC_SHAPES_CROSS = "BasicShapes.cross"
    """Cross"""
    BASIC_SHAPES_CUBE = "BasicShapes.cube"
    """Cube"""
    BASIC_SHAPES_DIAMOND = "BasicShapes.diamond"
    """Diamond"""
    BASIC_SHAPES_ELLIPSE = "BasicShapes.ellipse"
    """Ellipse"""
    BASIC_SHAPES_FRAME = "BasicShapes.frame"
    """Frame"""
    BASIC_SHAPES_HEXAGON = "BasicShapes.hexagon"
    """Hexagon"""
    BASIC_SHAPES_ISOSCELES_TRIANGLE = "BasicShapes.isosceles-triangle"
    """Isosceles Triangle"""
    BASIC_SHAPES_OCTAGON = "BasicShapes.octagon"
    """Octagon"""
    BASIC_SHAPES_PAPER = "BasicShapes.paper"
    """Folded Corner"""
    BASIC_SHAPES_PARALLELOGRAM = "BasicShapes.parallelogram"
    """Parallelogram"""
    BASIC_SHAPES_PENTAGON = "BasicShapes.pentagon"
    """Regular Pentagon	"""
    BASIC_SHAPES_QUADRAT = "BasicShapes.quadrat"
    """Square"""
    BASIC_SHAPES_RECTANGLE = "BasicShapes.rectangle"
    """Rectangle"""
    BASIC_SHAPES_RIGHT_TRIANGLE = "BasicShapes.right-triangle"
    """Right Triangle"""
    BASIC_SHAPES_RING = "BasicShapes.ring"
    """Ring"""
    BASIC_SHAPES_ROUND_QUADRAT = "BasicShapes.round-quadrat"
    """Square, Rounded"""
    BASIC_SHAPES_ROUND_RECTANGLE = "BasicShapes.round-rectangle"
    """Rectangle, Rounded"""
    BASIC_SHAPES_TRAPEZOID = "BasicShapes.trapezoid"
    """Trapezoid"""

    CALLOUT_SHAPES_CLOUD_CALLOUT = "CalloutShapes.cloud-callout"
    """Cloud"""
    CALLOUT_SHAPES_LINE_CALLOUT_1 = "CalloutShapes.line-callout-1"
    """Line Callout 1"""
    CALLOUT_SHAPES_LINE_CALLOUT_2 = "CalloutShapes.line-callout-2"
    """Line Callout 2"""
    CALLOUT_SHAPES_LINE_CALLOUT_3 = "CalloutShapes.line-callout-3"
    """Line Callout 3"""
    CALLOUT_SHAPES_RECTANGULAR_CALLOUT = "CalloutShapes.rectangular-callout"
    """Rectangular Callout"""
    CALLOUT_SHAPES_ROUND_CALLOUT = "CalloutShapes.round-callout"
    """Round Callout"""
    CALLOUT_SHAPES_ROUND_RECTANGULAR_CALLOUT = "CalloutShapes.round-rectangular-callout"
    """Rounded Rectangular Callout"""

    FLOW_CHART_SHAPES_FLOWCHART_ALTERNATE_PROCESS = "FlowChartShapes.flowchart-alternate-process"
    """Flowchart: Alternate Process"""
    FLOW_CHART_SHAPES_FLOWCHART_CARD = "FlowChartShapes.flowchart-card"
    """Flowchart: Card"""
    FLOW_CHART_SHAPES_FLOWCHART_COLLATE = "FlowChartShapes.flowchart-collate"
    """Flowchart: Collate"""
    FLOW_CHART_SHAPES_FLOWCHART_CONNECTOR = "FlowChartShapes.flowchart-connector"
    """Flowchart: Connector"""
    FLOW_CHART_SHAPES_FLOWCHART_DATA = "FlowChartShapes.flowchart-data"
    """Flowchart: Data"""
    FLOW_CHART_SHAPES_FLOWCHART_DECISION = "FlowChartShapes.flowchart-decision"
    """Flowchart: Decision"""
    FLOW_CHART_SHAPES_FLOWCHART_DELAY = "FlowChartShapes.flowchart-delay"
    """Flowchart: Delay"""
    FLOW_CHART_SHAPES_FLOWCHART_DIRECT_ACCESS_STORAGE = "FlowChartShapes.flowchart-direct-access-storage"
    """Flowchart: Direct Access Storage"""
    FLOW_CHART_SHAPES_FLOWCHART_DISPLAY = "FlowChartShapes.flowchart-display"
    """Flowchart: Display"""
    FLOW_CHART_SHAPES_FLOWCHART_DOCUMENT = "FlowChartShapes.flowchart-document"
    """Flowchart: Document"""
    FLOW_CHART_SHAPES_FLOWCHART_EXTRACT = "FlowChartShapes.flowchart-extract"
    """Flowchart: Extract"""
    FLOW_CHART_SHAPES_FLOWCHART_INTERNAL_STORAGE = "FlowChartShapes.flowchart-internal-storage"
    """Flowchart: Internal Storage"""
    FLOW_CHART_SHAPES_FLOWCHART_MAGNETIC_DISK = "FlowChartShapes.flowchart-magnetic-disk"
    """Flowchart: Magnetic Disc"""
    FLOW_CHART_SHAPES_FLOWCHART_MANUAL_INPUT = "FlowChartShapes.flowchart-manual-input"
    """Flowchart: Manual Input"""
    FLOW_CHART_SHAPES_FLOWCHART_MANUAL_OPERATION = "FlowChartShapes.flowchart-manual-operation"
    """Flowchart: Manual Operation"""
    FLOW_CHART_SHAPES_FLOWCHART_MERGE = "FlowChartShapes.flowchart-merge"
    """Flowchart: Merge"""
    FLOW_CHART_SHAPES_FLOWCHART_MULTIDOCUMENT = "FlowChartShapes.flowchart-multidocument"
    """Flowchart: Multi-document"""
    FLOW_CHART_SHAPES_FLOWCHART_OFF_PAGE_CONNECTOR = "FlowChartShapes.flowchart-off-page-connector"
    """Flowchart: Off-page Connector"""
    FLOW_CHART_SHAPES_FLOWCHART_OR = "FlowChartShapes.flowchart-or"
    """Flowchart: Or"""
    FLOW_CHART_SHAPES_FLOWCHART_PREDEFINED_PROCESS = "FlowChartShapes.flowchart-predefined-process"
    """Flowchart: Predefined Process"""
    FLOW_CHART_SHAPES_FLOWCHART_PREPARATION = "FlowChartShapes.flowchart-preparation"
    """Flowchart: Preparation"""
    FLOW_CHART_SHAPES_FLOWCHART_PROCESS = "FlowChartShapes.flowchart-process"
    """Flowchart: Process"""
    FLOW_CHART_SHAPES_FLOWCHART_PUNCHED_TAPE = "FlowChartShapes.flowchart-punched-tape"
    """Flowchart: Punched Tape"""
    FLOW_CHART_SHAPES_FLOWCHART_SEQUENTIAL_ACCESS = "FlowChartShapes.flowchart-sequential-access"
    """Flowchart: Sequential Access"""
    FLOW_CHART_SHAPES_FLOWCHART_SORT = "FlowChartShapes.flowchart-sort"
    """Flowchart: Sort"""
    FLOW_CHART_SHAPES_FLOWCHART_STORED_DATA = "FlowChartShapes.flowchart-stored-data"
    """Flowchart: Stored Data"""
    FLOW_CHART_SHAPES_FLOWCHART_SUMMING_JUNCTION = "FlowChartShapes.flowchart-summing-junction"
    """Flowchart: Summing Junction"""
    FLOW_CHART_SHAPES_FLOWCHART_TERMINATOR = "FlowChartShapes.flowchart-terminator"
    """Flowchart: Terminator"""

    THREE_D_HALF_SPHERE = "HalfSphere"
    """3D Half-Sphere"""
    THREE_D_CONE = "Cone"
    """3D Cone"""
    THREE_D_CYRAMID = "Cyramid"
    """3D Pyramid"""
    THREE_D_CYLINDER = "Cylinder"
    """3D Cylinder"""
    THREE_D_SPHERE = "Sphere"
    """3D Sphere"""
    THREE_D_TORUS = "Torus"
    """3D Torus"""

    STAR_SHAPES_BANG = "StarShapes.bang"
    """Explosion"""
    STAR_SHAPES_CONCAVE_STAR6 = "StarShapes.concave-star6"
    """6-Point Star, Concave"""
    STAR_SHAPES_DOORPLATE = "StarShapes.doorplate"
    """Doorplate"""
    STAR_SHAPES_HORIZONTAL_SCROLL = "StarShapes.horizontal-scroll"
    """Horizontal Scroll"""
    STAR_SHAPES_SIGNET = "StarShapes.signet"
    """Signet"""
    STAR_SHAPES_STAR_12 = "StarShapes.star12"
    """12-Point Star"""
    STAR_SHAPES_STAR_24 = "StarShapes.star24"
    """24-Point Star"""
    STAR_SHAPES_STAR_4 = "StarShapes.star4"
    """4-Point Star"""
    STAR_SHAPES_STAR_5 = "StarShapes.star5"
    """5-Point Star"""
    STAR_SHAPES_STAR_6 = "StarShapes.star6"
    """6-Point Star"""
    STAR_SHAPES_STAR_8 = "StarShapes.star8"
    """8-Point Star"""
    STAR_SHAPES_VERTICAL_SCROLL = "StarShapes.vertical-scroll"
    """Vertical Scroll"""

    SYMBOL_SHAPES_BRACE_PAIR = "SymbolShapes.brace-pair"
    """Double Brace"""
    SYMBOL_SHAPES_BRACKET_PAIR = "SymbolShapes.bracket-pair"
    """Double Bracket"""
    SYMBOL_SHAPES_CLOUD = "SymbolShapes.cloud"
    """Cloud"""
    SYMBOL_SHAPES_DIAMOND_BEVEL = "SymbolShapes.diamond-bevel"
    """Diamond Bevel"""
    SYMBOL_SHAPES_FLOWER = "SymbolShapes.flower"
    """Flower"""
    SYMBOL_SHAPES_FORBIDDEN = "SymbolShapes.forbidden"
    """Prohibited"""
    SYMBOL_SHAPES_HEART = "SymbolShapes.heart"
    """Heart"""
    SYMBOL_SHAPES_LEFT_BRACE = "SymbolShapes.left-brace"
    """Left Brace"""
    SYMBOL_SHAPES_LEFT_BRACKET = "SymbolShapes.left-bracket"
    """Left Bracket"""
    SYMBOL_SHAPES_LIGHTNING = "SymbolShapes.lightning"
    """Lightning Bolt"""
    SYMBOL_SHAPES_MOON = "SymbolShapes.moon"
    """Moon"""
    SYMBOL_SHAPES_OCTAGON_BEVEL = "SymbolShapes.octagon-bevel"
    """Octagon Bevel"""
    SYMBOL_SHAPES_PUZZLE = "SymbolShapes.puzzle"
    """Puzzle"""
    SYMBOL_SHAPES_QUAD_BEVEL = "SymbolShapes.quad-bevel"
    """Square Bevel"""
    SYMBOL_SHAPES_RIGHT_BRACE = "SymbolShapes.right-brace"
    """Right Brace"""
    SYMBOL_SHAPES_RIGHT_BRACKET = "SymbolShapes.right-bracket"
    """Right Bracket"""
    SYMBOL_SHAPES_SMILEY = "SymbolShapes.smiley"
    """Smiley Face"""
    SYMBOL_SHAPES_SUN = "SymbolShapes.sun"
    """Sun"""

    def __str__(self) -> str:
        return self.value

    @staticmethod
    def from_str(s: str) -> "ShapeDispatchKind":
        """
        Gets an ``DrawingBitmapKind`` instance from string.

        Args:
            s (str): String that represents the name of an enum Name.
                ``s`` is case insensitive and can be ``CamelCase``, ``pascal_case`` , ``snake_case``,
                ``hyphen-case``, ``normal case``.

        Raises:
            ValueError: If input string is empty.
            AttributeError: If unable to get ``ShapeKind`` instance.

        Returns:
            ShapeKind: Enum instance.
        """
        return kind_helper.enum_from_string(s, ShapeDispatchKind)
