# 政府研究員助手 LangGraph Agent 產品需求文件 (PRD)

## 1. 產品概述

### 1.1 產品名稱
Government Researcher Agent (政府研究員助手)

### 1.2 產品描述
一個基於 LangGraph 框架的智能助手，專門協助民眾研究與詢問政府相關問題。透過多階段的分析、搜尋、推理和驗證流程，提供準確、可信賴的政府資訊查詢服務。

### 1.3 目標用戶
- 需要查詢政府政策、法規、程序的一般民眾
- 需要研究政府資訊的學者和研究人員
- 需要了解政府服務流程的企業用戶

### 1.4 核心價值
- 透過 LangGraph 的狀態管理確保多步驟推理的連貫性
- 利用循環圖結構實現自我驗證和錯誤修正
- 提供可配置的模型和提示詞以適應不同需求

## 2. 技術架構

### 2.1 LangGraph 架構設計

本系統採用 LangGraph 的圖形工作流架構，包含以下核心概念：

**節點 (Nodes)**: 每個處理步驟對應一個節點，負責特定的計算任務
**邊 (Edges)**: 定義節點間的流轉邏輯，支持條件分支
**狀態 (State)**: 在所有節點間共享的持久化狀態，確保上下文連貫性

### 2.2 工作流圖結構

```
用戶輸入 → TopicDecompositionNode → ParallelSearchNode → ReasoningAnalysisNode 
→ ComputationVerificationNode (條件性) → HallucinationVerificationNode → SummaryResponseNode → 輸出結果
```

## 3. 功能需求

### 3.1 核心工作流節點

#### 3.1.1 Step-001: 題目拆解節點 (TopicDecompositionNode)

**節點功能:**
- 智能分析用戶提問的複雜度
- 單純問題：轉化為更細緻的單一子題目
- 複雜問題：拆解為多個子題目以確保回答的準確性

**輸入:** 用戶原始問題 + General Guide
**輸出:** 結構化的子題目列表
**狀態更新:** 將子題目列表存入共享狀態

**可配置項目:**
- 模型選擇: 支援 Claude、GPT、Gemini 等 (預設: gemini-2.5-pro)
- 自定義提示詞模板

#### 3.1.2 Step-002: 平行搜尋節點 (ParallelSearchNode)

**節點功能:**
- 分析常見搜尋錯誤策略 vs 精準搜尋策略
- 對所有子題目進行平行網路搜尋
- 完整保留原始引用文字，不得篡改
- 清楚標示網路來源資料

**輸入:** 子題目列表 (從狀態中讀取)
**輸出:** 每個子題目的搜尋結果和來源
**狀態更新:** 將搜尋結果存入共享狀態

**可配置項目:**
- 搜尋引擎選擇: "perplexity_sonar" | "tavily" (預設: perplexity_sonar)
- 最大並行搜尋數量 (預設: 5)
- 搜尋專用提示詞模板

**技術限制:** 此節點不使用 LLM 模型，僅調用搜尋 API

#### 3.1.3 Step-003: 推理分析節點 (ReasoningAnalysisNode)

**節點功能:**
- 基於搜尋結果和內建知識進行推理
- 分析常見錯誤後進行縝密推理
- 逐一回答所有子題目

**輸入:** 搜尋結果和子題目 (從狀態中讀取)
**輸出:** 每個子題目的推理結果
**狀態更新:** 將推理結果存入共享狀態

**可配置項目:**
- 模型選擇: 支援 Claude、GPT、Gemini 等 (預設: gemini-2.5-flash)
- 自定義推理提示詞模板

#### 3.1.4 Step-004: 計算驗證節點 (ComputationVerificationNode)

**節點功能:**
- 針對需要計算的題目進行獨立驗算
- 使用 Gemini 2.5 Flash/Pro 搭配 Code Execution 功能
- 基於搜尋到的計算方式設計驗證程序
- 非計算題目則跳過此步驟 (條件邊)

**輸入:** 推理結果 (從狀態中讀取)
**輸出:** 計算驗證結果
**狀態更新:** 將計算結果存入共享狀態

**可配置項目:**
- 模型選擇: "gemini-2.5-flash" | "gemini-2.5-pro" (預設: gemini-2.5-flash)
- 計算驗證專用提示詞模板

**技術限制:** 僅支援 Gemini 2.5 系列，必須啟用 Code Execution

#### 3.1.5 Step-005: 幻覺驗證節點 (HallucinationVerificationNode)

**節點功能:**
- 以獨立審查者角度檢視前述步驟
- 假設前面結果有高機率的錯誤
- 識別可能的AI幻覺位置
- 透過延伸搜尋證明或反駁前面的結論

**輸入:** 前面所有步驟的結果 (從狀態中讀取)
**輸出:** 幻覺檢驗報告和修正建議
**狀態更新:** 將驗證結果存入共享狀態

**可配置項目:**
- 模型選擇: 支援 Claude、GPT、Gemini 等 (預設: gemini-2.5-flash)
- 搜尋引擎選擇: "perplexity_sonar" | "tavily" (預設: perplexity_sonar)
- 幻覺驗證專用提示詞模板

#### 3.1.6 Step-006: 匯總回答節點 (SummaryResponseNode)

**節點功能:**
- 提供「精準回答」：簡潔的結論
- 提供「詳實回答」：完整的推理過程和引證
- 使用適當的 emoji 輔助閱讀
- 根據目標受眾調整語氣和格式

**輸入:** 所有步驟的處理結果 (從狀態中讀取)
**輸出:** 格式化的最終回答
**狀態更新:** 產生最終回答

**可配置項目:**
- 模型選擇: 支援 Claude、GPT、Gemini 等 (預設: gemini-2.5-flash)
- 回答格式模板
- 目標受眾設定

### 3.2 回應個性設定 (General Guide)

**預設 General Guide:**
```
<General Guide>
妳回應時會採用臺灣繁體中文，並且避免中國大陸用語
妳絕對不會使用 markdown 語法回應
但是你絕對不會使用 ** 或者 ### ，各種類型的 markdown 語法都禁止使用
如果要比較美觀排版的話，妳可以搭配使用 emoji or 純文字 or 斷行 or 空白 來展示你想講的
每一個 step 的前面增添適當斷行
每個分段的標題「前面」要增添適當 emoji （這個 emoji 挑選必須跟動態情境吻合）
</General Guide>
```

**配置特性:**
- 使用者可完全自定義 General Guide 內容
- 所有節點都會遵循 General Guide 的指導原則
- 可在執行時動態覆蓋預設值

## 4. 狀態管理

LangGraph 的狀態管理機制確保各節點間能共享資訊：

### 4.1 狀態流轉

1. **初始化**: 接收用戶問題和配置
2. **題目拆解**: 更新 decomposed_topics
3. **平行搜尋**: 更新 search_results
4. **推理分析**: 更新 reasoning_results
5. **計算驗證**: 條件性更新 computation_results
6. **幻覺驗證**: 更新 hallucination_check
7. **匯總回答**: 更新 final_answer

## 5. 配置需求

### 5.1 全局配置

支援配置項目：
- General Guide (可自定義，有預設值)
- 預設搜尋引擎選擇
- 語言設定
- 執行時間限制

### 5.2 節點級配置

每個節點支援以下配置：
- 模型選擇 (各節點有預設值)
- 自定義提示詞模板
- 節點特定參數 (如搜尋數量限制等)

