#ifndef ACMCONFIG_H
#define ACMCONFIG_H
/* Consistent with DSP Codes */
// 电机类型
    #define INDUCTION_MACHINE_CLASSIC_MODEL 1
    #define INDUCTION_MACHINE_FLUX_ONLY_MODEL 11
    #define PM_SYNCHRONOUS_MACHINE 2
#define MACHINE_TYPE 2
	#define PMSM_RESISTANCE                    0.475
	#define PMSM_D_AXIS_INDUCTANCE             0.0020499999999999997
	#define PMSM_Q_AXIS_INDUCTANCE             0.0020499999999999997
	#define PMSM_PERMANENT_MAGNET_FLUX_LINKAGE 0.010719670358105074
	#define MOTOR_NUMBER_OF_POLE_PAIRS         4
	#define MOTOR_RATED_CURRENT_RMS            3.5
	#define MOTOR_RATED_POWER_WATT             100
	#define MOTOR_RATED_SPEED_RPM              3000
	#define MOTOR_SHAFT_INERTIA                3.5000000000000004e-06

// 指令类型
    #define EXCITATION_POSITION 0
    #define EXCITATION_VELOCITY 1
    #define EXCITATION_SWEEP_FREQUENCY 2
#define EXCITATION_TYPE (1)
    #define IM_FLUX_COMMAND_SINE_HERZ   (1)

// 控制策略
	#define NULL_D_AXIS_CURRENT_CONTROL -1
	#define MTPA -2 // not supported
#define CONTROL_STRATEGY NULL_D_AXIS_CURRENT_CONTROL
#define NUMBER_OF_STEPS 80000
#define DOWN_SAMPLE 1
#define SENSORLESS_CONTROL TRUE
#define SENSORLESS_CONTROL_HFSI FALSE
#define VOLTAGE_CURRENT_DECOUPLING_CIRCUIT TRUE
#define SATURATED_MAGNETIC_CIRCUIT FALSE
#define INVERTER_NONLINEARITY FALSE
#define CL_TS          (5e-05)
#define CL_TS_INVERSE  (20000)
#define TS_UPSAMPLING_FREQ_EXE 0.5
#define TS_UPSAMPLING_FREQ_EXE_INVERSE 2

#define VL_TS          (0.0002)
#define PL_TS VL_TS
#define SPEED_LOOP_CEILING (4)

#define CLARKE_TRANS_TORQUE_GAIN (1.5) // consistent with experiment
#define POW2AMPL (0.816496581) // = 1/sqrt(1.5) power-invariant to aplitude-invariant (the dqn vector becomes shorter to have the same length as the abc vector)
#define AMPL2POW (1.22474487)

#define LOAD_INERTIA    0.16
#define LOAD_TORQUE     0
#define VISCOUS_COEFF   0.0007

#define MOTOR_RATED_TORQUE ( MOTOR_RATED_POWER_WATT / (MOTOR_RATED_SPEED_RPM/60.0*2*3.1415926) )
#define MOTOR_TORQUE_CONSTANT ( MOTOR_RATED_TORQUE / (MOTOR_RATED_CURRENT_RMS*1.414) )
#define MOTOR_BACK_EMF_CONSTANT ( MOTOR_TORQUE_CONSTANT / 1.5 / MOTOR_NUMBER_OF_POLE_PAIRS )
#define MOTOR_BACK_EMF_CONSTANT_mV_PER_RPM ( MOTOR_BACK_EMF_CONSTANT * 1e3 / (1.0/MOTOR_NUMBER_OF_POLE_PAIRS/2/3.1415926*60) )

#define CURRENT_KP (2.64657)
#define CURRENT_KI (231.707)
#define CURRENT_KI_CODE (CURRENT_KI*CURRENT_KP*CL_TS)
#define SPEED_KP (0.00313437)
#define SPEED_KI (30.5565)
#define SPEED_KI_CODE (SPEED_KI*SPEED_KP*VL_TS)

#define SPEED_LOOP_PID_PROPORTIONAL_GAIN 0.00121797
#define SPEED_LOOP_PID_INTEGRAL_TIME_CONSTANT (1/312.3)
#define SPEED_LOOP_PID_DIREVATIVE_TIME_CONSTANT 0
#define SPEED_LOOP_LIMIT_NEWTON_METER (1*MOTOR_RATED_TORQUE)
#define SPEED_LOOP_LIMIT_AMPERE (1*1.414*MOTOR_RATED_CURRENT_RMS)

#define CURRENT_LOOP_PID_PROPORTIONAL_GAIN 9.2363 // (CL_TS_INVERSE*0.1*PMSM_D_AXIS_INDUCTANCE) // 9.2363
#define CURRENT_LOOP_PID_INTEGRAL_TIME_CONSTANT (1/352.143)
#define CURRENT_LOOP_PID_DIREVATIVE_TIME_CONSTANT 0
#define CURRENT_LOOP_LIMIT_VOLTS (48)
#define DATA_FILE_NAME "../dat/PMSM_Velocity-205-1000-123-158.dat"
#define PC_SIMULATION TRUE

#define MACHINE_TS         (CL_TS*TS_UPSAMPLING_FREQ_EXE) //1.25e-4 
#define MACHINE_TS_INVERSE (CL_TS_INVERSE*TS_UPSAMPLING_FREQ_EXE_INVERSE) // 8000

#define SWEEP_FREQ_MAX_FREQ 200
#define SWEEP_FREQ_INIT_FREQ 2
#define SWEEP_FREQ_VELOCITY_AMPL 500
#define SWEEP_FREQ_CURRENT_AMPL 1
#define SWEEP_FREQ_C2V FALSE
#define SWEEP_FREQ_C2C FALSE

#endif
