from collections import UserDict

import utils_noroot as utnr
#-----------------------
class ndict(UserDict):
    '''
    Class used to map pairs of objects to a third object
    Can enforce that all keys have been used with check()
    '''
    log = utnr.getLogger(__name__)
    #--------------------------------
    def __init__(self):
        self._s_key_x = set()
        self._s_key_y = set()

        super().__init__()
    #--------------------------------
    def __setitem__(self, key, val):
        try:
            key_x, key_y = key
        except:
            self.log.error(f'Argument is not a pair of objects: {key}')
            raise

        self._s_key_x.add(key_x)
        self._s_key_y.add(key_y)

        self.data[key] = val
    #--------------------------------
    @property
    def x_axis(self):
        return self._s_key_x
    @property
    def y_axis(self):
        return self._s_key_y
    #--------------------------------
    def has_val(self, val, axis=None):
        if   axis == 'x':
            axis = [ xval for xval, _    in self.data ]
        elif axis == 'y':
            axis = [ yval for    _, yval in self.data ]
        else:
            self.log.error(f'Wrong axis: {axis}')
            raise
 
        return val in axis
    #--------------------------------
    def __str__(self):
        msg = f'\n-----------------------\n'
        msg+= f'ndict'
        msg+= f'\n-----------------------\n'
        for xval, yval in self.data.keys():
            msg += f'{xval:<20}{yval:<20}\n'
        msg+='-----------------------\n'

        return msg
    #--------------------------------
    def check(self):
        for key_x in self._s_key_x:
            for key_y in self._s_key_y:
                t_key = (key_x, key_y)
                if t_key not in self.data:
                    self.log.error(f'No data found for: {t_key}')
                    print(self)
                    raise
#-----------------------

