import { Test } from 'nodeunit';
declare const _default: {
    'default stream'(test: Test): void;
    'stream from attributes'(test: Test): void;
    "uses explicit shard count"(test: Test): void;
    "uses explicit retention period"(test: Test): void;
    "retention period must be between 24 and 168 hours"(test: Test): void;
    "auto-creates KMS key if encryption type is KMS but no key is provided"(test: Test): void;
    "uses explicit KMS key if encryption type is KMS and a key is provided"(test: Test): void;
    "permissions": {
        "with encryption": {
            "grantRead creates and attaches a policy with read only access to Stream and EncryptionKey"(test: Test): void;
            "grantWrite creates and attaches a policy with write only access to Stream and EncryptionKey"(test: Test): void;
            "grantReadWrite creates and attaches a policy with access to Stream and EncryptionKey"(test: Test): void;
        };
        "with no encryption": {
            "grantRead creates and associates a policy with read only access to Stream"(test: Test): void;
            "grantWrite creates and attaches a policy with write only access to Stream"(test: Test): void;
            "greatReadWrite creates and attaches a policy with write only access to Stream"(test: Test): void;
        };
    };
    "cross-stack permissions": {
        "no encryption"(test: Test): void;
        "fails with encryption due to cyclic dependency"(test: Test): void;
    };
};
export = _default;
