# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExadbVmClustersResult',
    'AwaitableGetExadbVmClustersResult',
    'get_exadb_vm_clusters',
    'get_exadb_vm_clusters_output',
]

@pulumi.output_type
class GetExadbVmClustersResult:
    """
    A collection of values returned by getExadbVmClusters.
    """
    def __init__(__self__, compartment_id=None, display_name=None, exadb_vm_clusters=None, exascale_db_storage_vault_id=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadb_vm_clusters and not isinstance(exadb_vm_clusters, list):
            raise TypeError("Expected argument 'exadb_vm_clusters' to be a list")
        pulumi.set(__self__, "exadb_vm_clusters", exadb_vm_clusters)
        if exascale_db_storage_vault_id and not isinstance(exascale_db_storage_vault_id, str):
            raise TypeError("Expected argument 'exascale_db_storage_vault_id' to be a str")
        pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadbVmClusters")
    def exadb_vm_clusters(self) -> Sequence['outputs.GetExadbVmClustersExadbVmClusterResult']:
        """
        The list of exadb_vm_clusters.
        """
        return pulumi.get(self, "exadb_vm_clusters")

    @property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExadbVmClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Exadata VM cluster on Exascale Infrastructure.
        """
        return pulumi.get(self, "state")


class AwaitableGetExadbVmClustersResult(GetExadbVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadbVmClustersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            exadb_vm_clusters=self.exadb_vm_clusters,
            exascale_db_storage_vault_id=self.exascale_db_storage_vault_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_exadb_vm_clusters(compartment_id: Optional[str] = None,
                          display_name: Optional[str] = None,
                          exascale_db_storage_vault_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetExadbVmClustersFilterArgs', 'GetExadbVmClustersFilterArgsDict']]] = None,
                          state: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadbVmClustersResult:
    """
    This data source provides the list of Exadb Vm Clusters in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata VM clusters on Exascale Infrastructure in the specified compartment. Applies to Exadata Database Service on Exascale Infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_clusters = oci.Database.get_exadb_vm_clusters(compartment_id=compartment_id,
        display_name=exadb_vm_cluster_display_name,
        exascale_db_storage_vault_id=test_exascale_db_storage_vault["id"],
        state=exadb_vm_cluster_state)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str exascale_db_storage_vault_id: A filter to return only Exadata VM clusters on Exascale Infrastructure that match the given Exascale Database Storage Vault ID.
    :param str state: A filter to return only Exadata VM clusters on Exascale Infrastructure that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exascaleDbStorageVaultId'] = exascale_db_storage_vault_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExadbVmClusters:getExadbVmClusters', __args__, opts=opts, typ=GetExadbVmClustersResult).value

    return AwaitableGetExadbVmClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadb_vm_clusters=pulumi.get(__ret__, 'exadb_vm_clusters'),
        exascale_db_storage_vault_id=pulumi.get(__ret__, 'exascale_db_storage_vault_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_exadb_vm_clusters_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 exascale_db_storage_vault_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExadbVmClustersFilterArgs', 'GetExadbVmClustersFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExadbVmClustersResult]:
    """
    This data source provides the list of Exadb Vm Clusters in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata VM clusters on Exascale Infrastructure in the specified compartment. Applies to Exadata Database Service on Exascale Infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_clusters = oci.Database.get_exadb_vm_clusters(compartment_id=compartment_id,
        display_name=exadb_vm_cluster_display_name,
        exascale_db_storage_vault_id=test_exascale_db_storage_vault["id"],
        state=exadb_vm_cluster_state)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str exascale_db_storage_vault_id: A filter to return only Exadata VM clusters on Exascale Infrastructure that match the given Exascale Database Storage Vault ID.
    :param str state: A filter to return only Exadata VM clusters on Exascale Infrastructure that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exascaleDbStorageVaultId'] = exascale_db_storage_vault_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExadbVmClusters:getExadbVmClusters', __args__, opts=opts, typ=GetExadbVmClustersResult)
    return __ret__.apply(lambda __response__: GetExadbVmClustersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadb_vm_clusters=pulumi.get(__response__, 'exadb_vm_clusters'),
        exascale_db_storage_vault_id=pulumi.get(__response__, 'exascale_db_storage_vault_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
