# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExecutionActionResult',
    'AwaitableGetExecutionActionResult',
    'get_execution_action',
    'get_execution_action_output',
]

@pulumi.output_type
class GetExecutionActionResult:
    """
    A collection of values returned by getExecutionAction.
    """
    def __init__(__self__, action_members=None, action_params=None, action_type=None, compartment_id=None, defined_tags=None, description=None, display_name=None, estimated_time_in_mins=None, execution_action_id=None, execution_action_order=None, execution_window_id=None, freeform_tags=None, id=None, lifecycle_details=None, lifecycle_substate=None, state=None, time_created=None, time_updated=None, total_time_taken_in_mins=None):
        if action_members and not isinstance(action_members, list):
            raise TypeError("Expected argument 'action_members' to be a list")
        pulumi.set(__self__, "action_members", action_members)
        if action_params and not isinstance(action_params, dict):
            raise TypeError("Expected argument 'action_params' to be a dict")
        pulumi.set(__self__, "action_params", action_params)
        if action_type and not isinstance(action_type, str):
            raise TypeError("Expected argument 'action_type' to be a str")
        pulumi.set(__self__, "action_type", action_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins and not isinstance(estimated_time_in_mins, int):
            raise TypeError("Expected argument 'estimated_time_in_mins' to be a int")
        pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if execution_action_id and not isinstance(execution_action_id, str):
            raise TypeError("Expected argument 'execution_action_id' to be a str")
        pulumi.set(__self__, "execution_action_id", execution_action_id)
        if execution_action_order and not isinstance(execution_action_order, int):
            raise TypeError("Expected argument 'execution_action_order' to be a int")
        pulumi.set(__self__, "execution_action_order", execution_action_order)
        if execution_window_id and not isinstance(execution_window_id, str):
            raise TypeError("Expected argument 'execution_window_id' to be a str")
        pulumi.set(__self__, "execution_window_id", execution_window_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate and not isinstance(lifecycle_substate, str):
            raise TypeError("Expected argument 'lifecycle_substate' to be a str")
        pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_time_taken_in_mins and not isinstance(total_time_taken_in_mins, int):
            raise TypeError("Expected argument 'total_time_taken_in_mins' to be a int")
        pulumi.set(__self__, "total_time_taken_in_mins", total_time_taken_in_mins)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Sequence['outputs.GetExecutionActionActionMemberResult']:
        """
        List of action members of this execution action.
        """
        return pulumi.get(self, "action_members")

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Mapping[str, str]:
        """
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The action type of the execution action being performed
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the execution action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the execution action. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> int:
        """
        The estimated time of the execution action in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="executionActionId")
    def execution_action_id(self) -> str:
        return pulumi.get(self, "execution_action_id")

    @property
    @pulumi.getter(name="executionActionOrder")
    def execution_action_order(self) -> int:
        """
        The priority order of the execution action.
        """
        return pulumi.get(self, "execution_action_order")

    @property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        """
        return pulumi.get(self, "execution_window_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> str:
        """
        The current sub-state of the execution action. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the execution action was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last date and time that the execution action was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> int:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")


class AwaitableGetExecutionActionResult(GetExecutionActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionActionResult(
            action_members=self.action_members,
            action_params=self.action_params,
            action_type=self.action_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            estimated_time_in_mins=self.estimated_time_in_mins,
            execution_action_id=self.execution_action_id,
            execution_action_order=self.execution_action_order,
            execution_window_id=self.execution_window_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            lifecycle_substate=self.lifecycle_substate,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            total_time_taken_in_mins=self.total_time_taken_in_mins)


def get_execution_action(execution_action_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionActionResult:
    """
    This data source provides details about a specific Execution Action resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified execution action.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_action = oci.Database.get_execution_action(execution_action_id=test_execution_action_oci_database_execution_action["id"])
    ```


    :param str execution_action_id: The execution action [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['executionActionId'] = execution_action_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExecutionAction:getExecutionAction', __args__, opts=opts, typ=GetExecutionActionResult).value

    return AwaitableGetExecutionActionResult(
        action_members=pulumi.get(__ret__, 'action_members'),
        action_params=pulumi.get(__ret__, 'action_params'),
        action_type=pulumi.get(__ret__, 'action_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__ret__, 'estimated_time_in_mins'),
        execution_action_id=pulumi.get(__ret__, 'execution_action_id'),
        execution_action_order=pulumi.get(__ret__, 'execution_action_order'),
        execution_window_id=pulumi.get(__ret__, 'execution_window_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__ret__, 'lifecycle_substate'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_time_taken_in_mins=pulumi.get(__ret__, 'total_time_taken_in_mins'))
def get_execution_action_output(execution_action_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExecutionActionResult]:
    """
    This data source provides details about a specific Execution Action resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified execution action.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_action = oci.Database.get_execution_action(execution_action_id=test_execution_action_oci_database_execution_action["id"])
    ```


    :param str execution_action_id: The execution action [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['executionActionId'] = execution_action_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExecutionAction:getExecutionAction', __args__, opts=opts, typ=GetExecutionActionResult)
    return __ret__.apply(lambda __response__: GetExecutionActionResult(
        action_members=pulumi.get(__response__, 'action_members'),
        action_params=pulumi.get(__response__, 'action_params'),
        action_type=pulumi.get(__response__, 'action_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__response__, 'estimated_time_in_mins'),
        execution_action_id=pulumi.get(__response__, 'execution_action_id'),
        execution_action_order=pulumi.get(__response__, 'execution_action_order'),
        execution_window_id=pulumi.get(__response__, 'execution_window_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__response__, 'lifecycle_substate'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        total_time_taken_in_mins=pulumi.get(__response__, 'total_time_taken_in_mins')))
