# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalDbSystemDiscoveriesResult',
    'AwaitableGetExternalDbSystemDiscoveriesResult',
    'get_external_db_system_discoveries',
    'get_external_db_system_discoveries_output',
]

@pulumi.output_type
class GetExternalDbSystemDiscoveriesResult:
    """
    A collection of values returned by getExternalDbSystemDiscoveries.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_db_system_discovery_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_system_discovery_collections and not isinstance(external_db_system_discovery_collections, list):
            raise TypeError("Expected argument 'external_db_system_discovery_collections' to be a list")
        pulumi.set(__self__, "external_db_system_discovery_collections", external_db_system_discovery_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDbSystemDiscoveryCollections")
    def external_db_system_discovery_collections(self) -> Sequence['outputs.GetExternalDbSystemDiscoveriesExternalDbSystemDiscoveryCollectionResult']:
        """
        The list of external_db_system_discovery_collection.
        """
        return pulumi.get(self, "external_db_system_discovery_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalDbSystemDiscoveriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalDbSystemDiscoveriesResult(GetExternalDbSystemDiscoveriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbSystemDiscoveriesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_db_system_discovery_collections=self.external_db_system_discovery_collections,
            filters=self.filters,
            id=self.id)


def get_external_db_system_discoveries(compartment_id: Optional[str] = None,
                                       display_name: Optional[str] = None,
                                       filters: Optional[Sequence[Union['GetExternalDbSystemDiscoveriesFilterArgs', 'GetExternalDbSystemDiscoveriesFilterArgsDict']]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbSystemDiscoveriesResult:
    """
    This data source provides the list of External Db System Discoveries in Oracle Cloud Infrastructure Database Management service.

    Lists the external DB system discovery resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_discoveries = oci.DatabaseManagement.get_external_db_system_discoveries(compartment_id=compartment_id,
        display_name=external_db_system_discovery_display_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbSystemDiscoveries:getExternalDbSystemDiscoveries', __args__, opts=opts, typ=GetExternalDbSystemDiscoveriesResult).value

    return AwaitableGetExternalDbSystemDiscoveriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_system_discovery_collections=pulumi.get(__ret__, 'external_db_system_discovery_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_external_db_system_discoveries_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExternalDbSystemDiscoveriesFilterArgs', 'GetExternalDbSystemDiscoveriesFilterArgsDict']]]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalDbSystemDiscoveriesResult]:
    """
    This data source provides the list of External Db System Discoveries in Oracle Cloud Infrastructure Database Management service.

    Lists the external DB system discovery resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_discoveries = oci.DatabaseManagement.get_external_db_system_discoveries(compartment_id=compartment_id,
        display_name=external_db_system_discovery_display_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalDbSystemDiscoveries:getExternalDbSystemDiscoveries', __args__, opts=opts, typ=GetExternalDbSystemDiscoveriesResult)
    return __ret__.apply(lambda __response__: GetExternalDbSystemDiscoveriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_db_system_discovery_collections=pulumi.get(__response__, 'external_db_system_discovery_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
