# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuditProfileArgs', 'AuditProfile']

@pulumi.input_type
class AuditProfileArgs:
    def __init__(__self__, *,
                 audit_profile_id: pulumi.Input[str],
                 change_retention_trigger: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AuditProfile resource.
        :param pulumi.Input[str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[int] change_retention_trigger: (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if change_retention_trigger is not None:
            pulumi.set(__self__, "change_retention_trigger", change_retention_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_paid_usage_enabled is not None:
            pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Input[str]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "audit_profile_id", value)

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "change_retention_trigger")

    @change_retention_trigger.setter
    def change_retention_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "change_retention_trigger", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_paid_usage_enabled", value)


@pulumi.input_type
class _AuditProfileState:
    def __init__(__self__, *,
                 audit_collected_volume: Optional[pulumi.Input[str]] = None,
                 audit_profile_id: Optional[pulumi.Input[str]] = None,
                 audit_trails: Optional[pulumi.Input[Sequence[pulumi.Input['AuditProfileAuditTrailArgs']]]] = None,
                 change_retention_trigger: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_override_global_retention_setting: Optional[pulumi.Input[bool]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 offline_months: Optional[pulumi.Input[int]] = None,
                 online_months: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuditProfile resources.
        :param pulumi.Input[str] audit_collected_volume: Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        :param pulumi.Input[str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[Sequence[pulumi.Input['AuditProfileAuditTrailArgs']]] audit_trails: Indicates the list of available audit trails on the target.
        :param pulumi.Input[int] change_retention_trigger: (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit profile in Data Safe.
        :param pulumi.Input[int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum: 12 months
        :param pulumi.Input[str] state: The current state of the audit profile.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the Data Safe target for which the audit profile is created.
        :param pulumi.Input[str] time_created: The date and time the audit profile was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        if audit_collected_volume is not None:
            pulumi.set(__self__, "audit_collected_volume", audit_collected_volume)
        if audit_profile_id is not None:
            pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if audit_trails is not None:
            pulumi.set(__self__, "audit_trails", audit_trails)
        if change_retention_trigger is not None:
            pulumi.set(__self__, "change_retention_trigger", change_retention_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_override_global_retention_setting is not None:
            pulumi.set(__self__, "is_override_global_retention_setting", is_override_global_retention_setting)
        if is_paid_usage_enabled is not None:
            pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if offline_months is not None:
            pulumi.set(__self__, "offline_months", offline_months)
        if online_months is not None:
            pulumi.set(__self__, "online_months", online_months)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="auditCollectedVolume")
    def audit_collected_volume(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        """
        return pulumi.get(self, "audit_collected_volume")

    @audit_collected_volume.setter
    def audit_collected_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_collected_volume", value)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_profile_id", value)

    @property
    @pulumi.getter(name="auditTrails")
    def audit_trails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditProfileAuditTrailArgs']]]]:
        """
        Indicates the list of available audit trails on the target.
        """
        return pulumi.get(self, "audit_trails")

    @audit_trails.setter
    def audit_trails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditProfileAuditTrailArgs']]]]):
        pulumi.set(self, "audit_trails", value)

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "change_retention_trigger")

    @change_retention_trigger.setter
    def change_retention_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "change_retention_trigger", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @is_override_global_retention_setting.setter
    def is_override_global_retention_setting(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_override_global_retention_setting", value)

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_paid_usage_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the audit profile in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @offline_months.setter
    def offline_months(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "offline_months", value)

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum: 12 months
        """
        return pulumi.get(self, "online_months")

    @online_months.setter
    def online_months(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "online_months", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Safe target for which the audit profile is created.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the audit profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AuditProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_profile_id: Optional[pulumi.Input[str]] = None,
                 change_retention_trigger: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Audit Profile resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit profile.

        ## Import

        AuditProfiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditProfile:AuditProfile test_audit_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[int] change_retention_trigger: (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Profile resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit profile.

        ## Import

        AuditProfiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditProfile:AuditProfile test_audit_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param AuditProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_profile_id: Optional[pulumi.Input[str]] = None,
                 change_retention_trigger: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_paid_usage_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditProfileArgs.__new__(AuditProfileArgs)

            if audit_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'audit_profile_id'")
            __props__.__dict__["audit_profile_id"] = audit_profile_id
            __props__.__dict__["change_retention_trigger"] = change_retention_trigger
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_paid_usage_enabled"] = is_paid_usage_enabled
            __props__.__dict__["audit_collected_volume"] = None
            __props__.__dict__["audit_trails"] = None
            __props__.__dict__["is_override_global_retention_setting"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["offline_months"] = None
            __props__.__dict__["online_months"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AuditProfile, __self__).__init__(
            'oci:DataSafe/auditProfile:AuditProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_collected_volume: Optional[pulumi.Input[str]] = None,
            audit_profile_id: Optional[pulumi.Input[str]] = None,
            audit_trails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuditProfileAuditTrailArgs', 'AuditProfileAuditTrailArgsDict']]]]] = None,
            change_retention_trigger: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_override_global_retention_setting: Optional[pulumi.Input[bool]] = None,
            is_paid_usage_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            offline_months: Optional[pulumi.Input[int]] = None,
            online_months: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AuditProfile':
        """
        Get an existing AuditProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_collected_volume: Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        :param pulumi.Input[str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuditProfileAuditTrailArgs', 'AuditProfileAuditTrailArgsDict']]]] audit_trails: Indicates the list of available audit trails on the target.
        :param pulumi.Input[int] change_retention_trigger: (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit profile.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_override_global_retention_setting: Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        :param pulumi.Input[bool] is_paid_usage_enabled: (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit profile in Data Safe.
        :param pulumi.Input[int] offline_months: Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        :param pulumi.Input[int] online_months: Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum: 12 months
        :param pulumi.Input[str] state: The current state of the audit profile.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the Data Safe target for which the audit profile is created.
        :param pulumi.Input[str] time_created: The date and time the audit profile was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditProfileState.__new__(_AuditProfileState)

        __props__.__dict__["audit_collected_volume"] = audit_collected_volume
        __props__.__dict__["audit_profile_id"] = audit_profile_id
        __props__.__dict__["audit_trails"] = audit_trails
        __props__.__dict__["change_retention_trigger"] = change_retention_trigger
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_override_global_retention_setting"] = is_override_global_retention_setting
        __props__.__dict__["is_paid_usage_enabled"] = is_paid_usage_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["offline_months"] = offline_months
        __props__.__dict__["online_months"] = online_months
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AuditProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditCollectedVolume")
    def audit_collected_volume(self) -> pulumi.Output[str]:
        """
        Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        """
        return pulumi.get(self, "audit_collected_volume")

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Output[str]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="auditTrails")
    def audit_trails(self) -> pulumi.Output[Sequence['outputs.AuditProfileAuditTrail']]:
        """
        Indicates the list of available audit trails on the target.
        """
        return pulumi.get(self, "audit_trails")

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Change Retention. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "change_retention_trigger")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the audit profile. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> pulumi.Output[bool]:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the audit profile in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> pulumi.Output[int]:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> pulumi.Output[int]:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum: 12 months
        """
        return pulumi.get(self, "online_months")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Data Safe target for which the audit profile is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the audit profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

