# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSqlFirewallAllowedSqlsResult',
    'AwaitableGetSqlFirewallAllowedSqlsResult',
    'get_sql_firewall_allowed_sqls',
    'get_sql_firewall_allowed_sqls_output',
]

@pulumi.output_type
class GetSqlFirewallAllowedSqlsResult:
    """
    A collection of values returned by getSqlFirewallAllowedSqls.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, scim_query=None, sql_firewall_allowed_sql_collections=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scim_query and not isinstance(scim_query, str):
            raise TypeError("Expected argument 'scim_query' to be a str")
        pulumi.set(__self__, "scim_query", scim_query)
        if sql_firewall_allowed_sql_collections and not isinstance(sql_firewall_allowed_sql_collections, list):
            raise TypeError("Expected argument 'sql_firewall_allowed_sql_collections' to be a list")
        pulumi.set(__self__, "sql_firewall_allowed_sql_collections", sql_firewall_allowed_sql_collections)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the SQL Firewall allowed SQL.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSqlFirewallAllowedSqlsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scimQuery")
    def scim_query(self) -> Optional[str]:
        return pulumi.get(self, "scim_query")

    @property
    @pulumi.getter(name="sqlFirewallAllowedSqlCollections")
    def sql_firewall_allowed_sql_collections(self) -> Sequence['outputs.GetSqlFirewallAllowedSqlsSqlFirewallAllowedSqlCollectionResult']:
        """
        The list of sql_firewall_allowed_sql_collection.
        """
        return pulumi.get(self, "sql_firewall_allowed_sql_collections")


class AwaitableGetSqlFirewallAllowedSqlsResult(GetSqlFirewallAllowedSqlsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlFirewallAllowedSqlsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            scim_query=self.scim_query,
            sql_firewall_allowed_sql_collections=self.sql_firewall_allowed_sql_collections)


def get_sql_firewall_allowed_sqls(access_level: Optional[str] = None,
                                  compartment_id: Optional[str] = None,
                                  compartment_id_in_subtree: Optional[bool] = None,
                                  filters: Optional[Sequence[Union['GetSqlFirewallAllowedSqlsFilterArgs', 'GetSqlFirewallAllowedSqlsFilterArgsDict']]] = None,
                                  scim_query: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlFirewallAllowedSqlsResult:
    """
    This data source provides the list of Sql Firewall Allowed Sqls in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all SQL Firewall allowed SQL statements.

    The ListSqlFirewallAllowedSqls operation returns only the SQL Firewall allowed SQL statements in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSqlFirewallPolicies on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_allowed_sqls = oci.DataSafe.get_sql_firewall_allowed_sqls(compartment_id=compartment_id,
        access_level=sql_firewall_allowed_sql_access_level,
        compartment_id_in_subtree=sql_firewall_allowed_sql_compartment_id_in_subtree,
        scim_query=sql_firewall_allowed_sql_scim_query)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(currentUser eq 'SCOTT') and (topLevel eq 'YES')
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['scimQuery'] = scim_query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlFirewallAllowedSqls:getSqlFirewallAllowedSqls', __args__, opts=opts, typ=GetSqlFirewallAllowedSqlsResult).value

    return AwaitableGetSqlFirewallAllowedSqlsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scim_query=pulumi.get(__ret__, 'scim_query'),
        sql_firewall_allowed_sql_collections=pulumi.get(__ret__, 'sql_firewall_allowed_sql_collections'))
def get_sql_firewall_allowed_sqls_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                         compartment_id: Optional[pulumi.Input[str]] = None,
                                         compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSqlFirewallAllowedSqlsFilterArgs', 'GetSqlFirewallAllowedSqlsFilterArgsDict']]]]] = None,
                                         scim_query: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlFirewallAllowedSqlsResult]:
    """
    This data source provides the list of Sql Firewall Allowed Sqls in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all SQL Firewall allowed SQL statements.

    The ListSqlFirewallAllowedSqls operation returns only the SQL Firewall allowed SQL statements in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSqlFirewallPolicies on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_allowed_sqls = oci.DataSafe.get_sql_firewall_allowed_sqls(compartment_id=compartment_id,
        access_level=sql_firewall_allowed_sql_access_level,
        compartment_id_in_subtree=sql_firewall_allowed_sql_compartment_id_in_subtree,
        scim_query=sql_firewall_allowed_sql_scim_query)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(currentUser eq 'SCOTT') and (topLevel eq 'YES')
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['scimQuery'] = scim_query
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlFirewallAllowedSqls:getSqlFirewallAllowedSqls', __args__, opts=opts, typ=GetSqlFirewallAllowedSqlsResult)
    return __ret__.apply(lambda __response__: GetSqlFirewallAllowedSqlsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scim_query=pulumi.get(__response__, 'scim_query'),
        sql_firewall_allowed_sql_collections=pulumi.get(__response__, 'sql_firewall_allowed_sql_collections')))
