# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDesktopPoolsResult',
    'AwaitableGetDesktopPoolsResult',
    'get_desktop_pools',
    'get_desktop_pools_output',
]

@pulumi.output_type
class GetDesktopPoolsResult:
    """
    A collection of values returned by getDesktopPools.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, desktop_pool_collections=None, display_name=None, filters=None, id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if desktop_pool_collections and not isinstance(desktop_pool_collections, list):
            raise TypeError("Expected argument 'desktop_pool_collections' to be a list")
        pulumi.set(__self__, "desktop_pool_collections", desktop_pool_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain of the desktop pool.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment of the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="desktopPoolCollections")
    def desktop_pool_collections(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionResult']:
        """
        The list of desktop_pool_collection.
        """
        return pulumi.get(self, "desktop_pool_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDesktopPoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the desktop pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the desktop pool.
        """
        return pulumi.get(self, "state")


class AwaitableGetDesktopPoolsResult(GetDesktopPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDesktopPoolsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            desktop_pool_collections=self.desktop_pool_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_desktop_pools(availability_domain: Optional[str] = None,
                      compartment_id: Optional[str] = None,
                      display_name: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetDesktopPoolsFilterArgs', 'GetDesktopPoolsFilterArgsDict']]] = None,
                      id: Optional[str] = None,
                      state: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDesktopPoolsResult:
    """
    This data source provides the list of Desktop Pools in Oracle Cloud Infrastructure Desktops service.

    Returns a list of desktop pools within the given compartment. You can limit the results to an availability domain, pool name, or pool state. You can limit the number of results returned, sort the results by time or name, and sort in ascending or descending order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pools = oci.Desktops.get_desktop_pools(compartment_id=compartment_id,
        availability_domain=desktop_pool_availability_domain,
        display_name=desktop_pool_display_name,
        id=desktop_pool_id,
        state=desktop_pool_state)
    ```


    :param str availability_domain: The name of the availability domain.
    :param str compartment_id: The OCID of the compartment of the desktop pool.
    :param str display_name: A filter to return only results with the given displayName.
    :param str id: A filter to return only results with the given OCID.
    :param str state: A filter to return only results with the given lifecycleState.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Desktops/getDesktopPools:getDesktopPools', __args__, opts=opts, typ=GetDesktopPoolsResult).value

    return AwaitableGetDesktopPoolsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        desktop_pool_collections=pulumi.get(__ret__, 'desktop_pool_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_desktop_pools_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                             compartment_id: Optional[pulumi.Input[str]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDesktopPoolsFilterArgs', 'GetDesktopPoolsFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[str]]] = None,
                             state: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDesktopPoolsResult]:
    """
    This data source provides the list of Desktop Pools in Oracle Cloud Infrastructure Desktops service.

    Returns a list of desktop pools within the given compartment. You can limit the results to an availability domain, pool name, or pool state. You can limit the number of results returned, sort the results by time or name, and sort in ascending or descending order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pools = oci.Desktops.get_desktop_pools(compartment_id=compartment_id,
        availability_domain=desktop_pool_availability_domain,
        display_name=desktop_pool_display_name,
        id=desktop_pool_id,
        state=desktop_pool_state)
    ```


    :param str availability_domain: The name of the availability domain.
    :param str compartment_id: The OCID of the compartment of the desktop pool.
    :param str display_name: A filter to return only results with the given displayName.
    :param str id: A filter to return only results with the given OCID.
    :param str state: A filter to return only results with the given lifecycleState.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Desktops/getDesktopPools:getDesktopPools', __args__, opts=opts, typ=GetDesktopPoolsResult)
    return __ret__.apply(lambda __response__: GetDesktopPoolsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        desktop_pool_collections=pulumi.get(__response__, 'desktop_pool_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
