# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryCommitsResult',
    'AwaitableGetRepositoryCommitsResult',
    'get_repository_commits',
    'get_repository_commits_output',
]

@pulumi.output_type
class GetRepositoryCommitsResult:
    """
    A collection of values returned by getRepositoryCommits.
    """
    def __init__(__self__, author_name=None, commit_message=None, exclude_ref_name=None, file_path=None, filters=None, id=None, ref_name=None, repository_commit_collections=None, repository_id=None, timestamp_greater_than_or_equal_to=None, timestamp_less_than_or_equal_to=None):
        if author_name and not isinstance(author_name, str):
            raise TypeError("Expected argument 'author_name' to be a str")
        pulumi.set(__self__, "author_name", author_name)
        if commit_message and not isinstance(commit_message, str):
            raise TypeError("Expected argument 'commit_message' to be a str")
        pulumi.set(__self__, "commit_message", commit_message)
        if exclude_ref_name and not isinstance(exclude_ref_name, str):
            raise TypeError("Expected argument 'exclude_ref_name' to be a str")
        pulumi.set(__self__, "exclude_ref_name", exclude_ref_name)
        if file_path and not isinstance(file_path, str):
            raise TypeError("Expected argument 'file_path' to be a str")
        pulumi.set(__self__, "file_path", file_path)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if repository_commit_collections and not isinstance(repository_commit_collections, list):
            raise TypeError("Expected argument 'repository_commit_collections' to be a list")
        pulumi.set(__self__, "repository_commit_collections", repository_commit_collections)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if timestamp_greater_than_or_equal_to and not isinstance(timestamp_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'timestamp_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "timestamp_greater_than_or_equal_to", timestamp_greater_than_or_equal_to)
        if timestamp_less_than_or_equal_to and not isinstance(timestamp_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'timestamp_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "timestamp_less_than_or_equal_to", timestamp_less_than_or_equal_to)

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[str]:
        """
        Name of the author of the repository.
        """
        return pulumi.get(self, "author_name")

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[str]:
        """
        The commit message.
        """
        return pulumi.get(self, "commit_message")

    @property
    @pulumi.getter(name="excludeRefName")
    def exclude_ref_name(self) -> Optional[str]:
        return pulumi.get(self, "exclude_ref_name")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryCommitsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[str]:
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="repositoryCommitCollections")
    def repository_commit_collections(self) -> Sequence['outputs.GetRepositoryCommitsRepositoryCommitCollectionResult']:
        """
        The list of repository_commit_collection.
        """
        return pulumi.get(self, "repository_commit_collections")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="timestampGreaterThanOrEqualTo")
    def timestamp_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "timestamp_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timestampLessThanOrEqualTo")
    def timestamp_less_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "timestamp_less_than_or_equal_to")


class AwaitableGetRepositoryCommitsResult(GetRepositoryCommitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryCommitsResult(
            author_name=self.author_name,
            commit_message=self.commit_message,
            exclude_ref_name=self.exclude_ref_name,
            file_path=self.file_path,
            filters=self.filters,
            id=self.id,
            ref_name=self.ref_name,
            repository_commit_collections=self.repository_commit_collections,
            repository_id=self.repository_id,
            timestamp_greater_than_or_equal_to=self.timestamp_greater_than_or_equal_to,
            timestamp_less_than_or_equal_to=self.timestamp_less_than_or_equal_to)


def get_repository_commits(author_name: Optional[str] = None,
                           commit_message: Optional[str] = None,
                           exclude_ref_name: Optional[str] = None,
                           file_path: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetRepositoryCommitsFilterArgs', 'GetRepositoryCommitsFilterArgsDict']]] = None,
                           ref_name: Optional[str] = None,
                           repository_id: Optional[str] = None,
                           timestamp_greater_than_or_equal_to: Optional[str] = None,
                           timestamp_less_than_or_equal_to: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryCommitsResult:
    """
    This data source provides the list of Repository Commits in Oracle Cloud Infrastructure Devops service.

    Returns a list of commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_commits = oci.DevOps.get_repository_commits(repository_id=test_repository["id"],
        author_name=repository_commit_author_name,
        commit_message=repository_commit_commit_message,
        exclude_ref_name=repository_commit_exclude_ref_name,
        file_path=repository_commit_file_path,
        ref_name=repository_commit_ref_name,
        timestamp_greater_than_or_equal_to=repository_commit_timestamp_greater_than_or_equal_to,
        timestamp_less_than_or_equal_to=repository_commit_timestamp_less_than_or_equal_to)
    ```


    :param str author_name: A filter to return any commits that are pushed by the requested author.
    :param str commit_message: A filter to return any commits that contains the given message.
    :param str exclude_ref_name: A filter to exclude commits that match the given reference name.
    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    :param str timestamp_greater_than_or_equal_to: A filter to return commits only created after the specified timestamp value.
    :param str timestamp_less_than_or_equal_to: A filter to return commits only created before the specified timestamp value.
    """
    __args__ = dict()
    __args__['authorName'] = author_name
    __args__['commitMessage'] = commit_message
    __args__['excludeRefName'] = exclude_ref_name
    __args__['filePath'] = file_path
    __args__['filters'] = filters
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    __args__['timestampGreaterThanOrEqualTo'] = timestamp_greater_than_or_equal_to
    __args__['timestampLessThanOrEqualTo'] = timestamp_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryCommits:getRepositoryCommits', __args__, opts=opts, typ=GetRepositoryCommitsResult).value

    return AwaitableGetRepositoryCommitsResult(
        author_name=pulumi.get(__ret__, 'author_name'),
        commit_message=pulumi.get(__ret__, 'commit_message'),
        exclude_ref_name=pulumi.get(__ret__, 'exclude_ref_name'),
        file_path=pulumi.get(__ret__, 'file_path'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        repository_commit_collections=pulumi.get(__ret__, 'repository_commit_collections'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        timestamp_greater_than_or_equal_to=pulumi.get(__ret__, 'timestamp_greater_than_or_equal_to'),
        timestamp_less_than_or_equal_to=pulumi.get(__ret__, 'timestamp_less_than_or_equal_to'))
def get_repository_commits_output(author_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  commit_message: Optional[pulumi.Input[Optional[str]]] = None,
                                  exclude_ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  file_path: Optional[pulumi.Input[Optional[str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRepositoryCommitsFilterArgs', 'GetRepositoryCommitsFilterArgsDict']]]]] = None,
                                  ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  repository_id: Optional[pulumi.Input[str]] = None,
                                  timestamp_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                  timestamp_less_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryCommitsResult]:
    """
    This data source provides the list of Repository Commits in Oracle Cloud Infrastructure Devops service.

    Returns a list of commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_commits = oci.DevOps.get_repository_commits(repository_id=test_repository["id"],
        author_name=repository_commit_author_name,
        commit_message=repository_commit_commit_message,
        exclude_ref_name=repository_commit_exclude_ref_name,
        file_path=repository_commit_file_path,
        ref_name=repository_commit_ref_name,
        timestamp_greater_than_or_equal_to=repository_commit_timestamp_greater_than_or_equal_to,
        timestamp_less_than_or_equal_to=repository_commit_timestamp_less_than_or_equal_to)
    ```


    :param str author_name: A filter to return any commits that are pushed by the requested author.
    :param str commit_message: A filter to return any commits that contains the given message.
    :param str exclude_ref_name: A filter to exclude commits that match the given reference name.
    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    :param str timestamp_greater_than_or_equal_to: A filter to return commits only created after the specified timestamp value.
    :param str timestamp_less_than_or_equal_to: A filter to return commits only created before the specified timestamp value.
    """
    __args__ = dict()
    __args__['authorName'] = author_name
    __args__['commitMessage'] = commit_message
    __args__['excludeRefName'] = exclude_ref_name
    __args__['filePath'] = file_path
    __args__['filters'] = filters
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    __args__['timestampGreaterThanOrEqualTo'] = timestamp_greater_than_or_equal_to
    __args__['timestampLessThanOrEqualTo'] = timestamp_less_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepositoryCommits:getRepositoryCommits', __args__, opts=opts, typ=GetRepositoryCommitsResult)
    return __ret__.apply(lambda __response__: GetRepositoryCommitsResult(
        author_name=pulumi.get(__response__, 'author_name'),
        commit_message=pulumi.get(__response__, 'commit_message'),
        exclude_ref_name=pulumi.get(__response__, 'exclude_ref_name'),
        file_path=pulumi.get(__response__, 'file_path'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ref_name=pulumi.get(__response__, 'ref_name'),
        repository_commit_collections=pulumi.get(__response__, 'repository_commit_collections'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        timestamp_greater_than_or_equal_to=pulumi.get(__response__, 'timestamp_greater_than_or_equal_to'),
        timestamp_less_than_or_equal_to=pulumi.get(__response__, 'timestamp_less_than_or_equal_to')))
