# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryProtectedBranchesResult',
    'AwaitableGetRepositoryProtectedBranchesResult',
    'get_repository_protected_branches',
    'get_repository_protected_branches_output',
]

@pulumi.output_type
class GetRepositoryProtectedBranchesResult:
    """
    A collection of values returned by getRepositoryProtectedBranches.
    """
    def __init__(__self__, filters=None, id=None, name=None, protected_branch_collections=None, repository_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protected_branch_collections and not isinstance(protected_branch_collections, list):
            raise TypeError("Expected argument 'protected_branch_collections' to be a list")
        pulumi.set(__self__, "protected_branch_collections", protected_branch_collections)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryProtectedBranchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedBranchCollections")
    def protected_branch_collections(self) -> Sequence['outputs.GetRepositoryProtectedBranchesProtectedBranchCollectionResult']:
        """
        The list of protected_branch_collection.
        """
        return pulumi.get(self, "protected_branch_collections")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")


class AwaitableGetRepositoryProtectedBranchesResult(GetRepositoryProtectedBranchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryProtectedBranchesResult(
            filters=self.filters,
            id=self.id,
            name=self.name,
            protected_branch_collections=self.protected_branch_collections,
            repository_id=self.repository_id)


def get_repository_protected_branches(filters: Optional[Sequence[Union['GetRepositoryProtectedBranchesFilterArgs', 'GetRepositoryProtectedBranchesFilterArgsDict']]] = None,
                                      name: Optional[str] = None,
                                      repository_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryProtectedBranchesResult:
    """
    This data source provides the list of Repository Protected Branches in Oracle Cloud Infrastructure Devops service.

    Returns a list of Protected Branches.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_protected_branches = oci.DevOps.get_repository_protected_branches(repository_id=test_repository["id"],
        name=repository_protected_branch_name)
    ```


    :param str name: A filter to return only resources that match the given branch name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryProtectedBranches:getRepositoryProtectedBranches', __args__, opts=opts, typ=GetRepositoryProtectedBranchesResult).value

    return AwaitableGetRepositoryProtectedBranchesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        protected_branch_collections=pulumi.get(__ret__, 'protected_branch_collections'),
        repository_id=pulumi.get(__ret__, 'repository_id'))
def get_repository_protected_branches_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRepositoryProtectedBranchesFilterArgs', 'GetRepositoryProtectedBranchesFilterArgsDict']]]]] = None,
                                             name: Optional[pulumi.Input[Optional[str]]] = None,
                                             repository_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryProtectedBranchesResult]:
    """
    This data source provides the list of Repository Protected Branches in Oracle Cloud Infrastructure Devops service.

    Returns a list of Protected Branches.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_protected_branches = oci.DevOps.get_repository_protected_branches(repository_id=test_repository["id"],
        name=repository_protected_branch_name)
    ```


    :param str name: A filter to return only resources that match the given branch name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepositoryProtectedBranches:getRepositoryProtectedBranches', __args__, opts=opts, typ=GetRepositoryProtectedBranchesResult)
    return __ret__.apply(lambda __response__: GetRepositoryProtectedBranchesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        protected_branch_collections=pulumi.get(__response__, 'protected_branch_collections'),
        repository_id=pulumi.get(__response__, 'repository_id')))
