# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZonesResult',
    'AwaitableGetZonesResult',
    'get_zones',
    'get_zones_output',
]

@pulumi.output_type
class GetZonesResult:
    """
    A collection of values returned by getZones.
    """
    def __init__(__self__, compartment_id=None, dnssec_state=None, filters=None, id=None, name=None, name_contains=None, scope=None, sort_by=None, sort_order=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, tsig_key_id=None, view_id=None, zone_type=None, zones=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dnssec_state and not isinstance(dnssec_state, str):
            raise TypeError("Expected argument 'dnssec_state' to be a str")
        pulumi.set(__self__, "dnssec_state", dnssec_state)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if sort_by and not isinstance(sort_by, str):
            raise TypeError("Expected argument 'sort_by' to be a str")
        pulumi.set(__self__, "sort_by", sort_by)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if tsig_key_id and not isinstance(tsig_key_id, str):
            raise TypeError("Expected argument 'tsig_key_id' to be a str")
        pulumi.set(__self__, "tsig_key_id", tsig_key_id)
        if view_id and not isinstance(view_id, str):
            raise TypeError("Expected argument 'view_id' to be a str")
        pulumi.set(__self__, "view_id", view_id)
        if zone_type and not isinstance(zone_type, str):
            raise TypeError("Expected argument 'zone_type' to be a str")
        pulumi.set(__self__, "zone_type", zone_type)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the zone.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dnssecState")
    def dnssec_state(self) -> Optional[str]:
        """
        The state of DNSSEC on the zone.
        """
        return pulumi.get(self, "dnssec_state")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetZonesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The scope of the zone.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[str]:
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[str]:
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the zone resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[str]:
        """
        The OCID of the private view containing the zone. This value will be null for zones in the global DNS, which are publicly resolvable and not part of a private view.
        """
        return pulumi.get(self, "view_id")

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[str]:
        """
        The type of the zone. Must be either `PRIMARY` or `SECONDARY`. `SECONDARY` is only supported for GLOBAL zones.
        """
        return pulumi.get(self, "zone_type")

    @property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetZonesZoneResult']:
        """
        The list of zones.
        """
        return pulumi.get(self, "zones")


class AwaitableGetZonesResult(GetZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZonesResult(
            compartment_id=self.compartment_id,
            dnssec_state=self.dnssec_state,
            filters=self.filters,
            id=self.id,
            name=self.name,
            name_contains=self.name_contains,
            scope=self.scope,
            sort_by=self.sort_by,
            sort_order=self.sort_order,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            tsig_key_id=self.tsig_key_id,
            view_id=self.view_id,
            zone_type=self.zone_type,
            zones=self.zones)


def get_zones(compartment_id: Optional[str] = None,
              dnssec_state: Optional[str] = None,
              filters: Optional[Sequence[Union['GetZonesFilterArgs', 'GetZonesFilterArgsDict']]] = None,
              name: Optional[str] = None,
              name_contains: Optional[str] = None,
              scope: Optional[str] = None,
              sort_by: Optional[str] = None,
              sort_order: Optional[str] = None,
              state: Optional[str] = None,
              time_created_greater_than_or_equal_to: Optional[str] = None,
              time_created_less_than: Optional[str] = None,
              tsig_key_id: Optional[str] = None,
              view_id: Optional[str] = None,
              zone_type: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZonesResult:
    """
    This data source provides the list of Zones in Oracle Cloud Infrastructure DNS service.

    Gets a list of all zones in the specified compartment.

    The collection can be filtered by name, time created, scope, associated view, and zone type.
    Filtering by view is only supported for private zones.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_zones = oci.Dns.get_zones(compartment_id=compartment_id,
        dnssec_state=zone_dnssec_state,
        name=zone_name,
        name_contains=zone_name_contains,
        scope=zone_scope,
        state=zone_state,
        time_created_greater_than_or_equal_to=zone_time_created_greater_than_or_equal_to,
        time_created_less_than=zone_time_created_less_than,
        tsig_key_id=test_tsig_key["id"],
        view_id=test_view["id"],
        zone_type=zone_zone_type)
    ```


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str dnssec_state: Search for zones that have the given `DnssecState`.
    :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
    :param str name_contains: Search by zone name. Will match any zone whose name (case-insensitive) contains the provided value.
    :param str scope: Specifies to operate only on resources that have a matching DNS scope.
    :param str sort_by: The field by which to sort zones. Allowed values are: name|zoneType|timeCreated
    :param str sort_order: The order to sort the resources. Allowed values are: ASC|DESC
    :param str state: The state of a resource.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    :param str tsig_key_id: Search for zones that are associated with a TSIG key.
    :param str view_id: The OCID of the view the resource is associated with.
    :param str zone_type: Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dnssecState'] = dnssec_state
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['scope'] = scope
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['tsigKeyId'] = tsig_key_id
    __args__['viewId'] = view_id
    __args__['zoneType'] = zone_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getZones:getZones', __args__, opts=opts, typ=GetZonesResult).value

    return AwaitableGetZonesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dnssec_state=pulumi.get(__ret__, 'dnssec_state'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        scope=pulumi.get(__ret__, 'scope'),
        sort_by=pulumi.get(__ret__, 'sort_by'),
        sort_order=pulumi.get(__ret__, 'sort_order'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        tsig_key_id=pulumi.get(__ret__, 'tsig_key_id'),
        view_id=pulumi.get(__ret__, 'view_id'),
        zone_type=pulumi.get(__ret__, 'zone_type'),
        zones=pulumi.get(__ret__, 'zones'))
def get_zones_output(compartment_id: Optional[pulumi.Input[str]] = None,
                     dnssec_state: Optional[pulumi.Input[Optional[str]]] = None,
                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetZonesFilterArgs', 'GetZonesFilterArgsDict']]]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                     scope: Optional[pulumi.Input[Optional[str]]] = None,
                     sort_by: Optional[pulumi.Input[Optional[str]]] = None,
                     sort_order: Optional[pulumi.Input[Optional[str]]] = None,
                     state: Optional[pulumi.Input[Optional[str]]] = None,
                     time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                     time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                     tsig_key_id: Optional[pulumi.Input[Optional[str]]] = None,
                     view_id: Optional[pulumi.Input[Optional[str]]] = None,
                     zone_type: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZonesResult]:
    """
    This data source provides the list of Zones in Oracle Cloud Infrastructure DNS service.

    Gets a list of all zones in the specified compartment.

    The collection can be filtered by name, time created, scope, associated view, and zone type.
    Filtering by view is only supported for private zones.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_zones = oci.Dns.get_zones(compartment_id=compartment_id,
        dnssec_state=zone_dnssec_state,
        name=zone_name,
        name_contains=zone_name_contains,
        scope=zone_scope,
        state=zone_state,
        time_created_greater_than_or_equal_to=zone_time_created_greater_than_or_equal_to,
        time_created_less_than=zone_time_created_less_than,
        tsig_key_id=test_tsig_key["id"],
        view_id=test_view["id"],
        zone_type=zone_zone_type)
    ```


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str dnssec_state: Search for zones that have the given `DnssecState`.
    :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
    :param str name_contains: Search by zone name. Will match any zone whose name (case-insensitive) contains the provided value.
    :param str scope: Specifies to operate only on resources that have a matching DNS scope.
    :param str sort_by: The field by which to sort zones. Allowed values are: name|zoneType|timeCreated
    :param str sort_order: The order to sort the resources. Allowed values are: ASC|DESC
    :param str state: The state of a resource.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    :param str tsig_key_id: Search for zones that are associated with a TSIG key.
    :param str view_id: The OCID of the view the resource is associated with.
    :param str zone_type: Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dnssecState'] = dnssec_state
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['scope'] = scope
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['tsigKeyId'] = tsig_key_id
    __args__['viewId'] = view_id
    __args__['zoneType'] = zone_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dns/getZones:getZones', __args__, opts=opts, typ=GetZonesResult)
    return __ret__.apply(lambda __response__: GetZonesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dnssec_state=pulumi.get(__response__, 'dnssec_state'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        scope=pulumi.get(__response__, 'scope'),
        sort_by=pulumi.get(__response__, 'sort_by'),
        sort_order=pulumi.get(__response__, 'sort_order'),
        state=pulumi.get(__response__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than'),
        tsig_key_id=pulumi.get(__response__, 'tsig_key_id'),
        view_id=pulumi.get(__response__, 'view_id'),
        zone_type=pulumi.get(__response__, 'zone_type'),
        zones=pulumi.get(__response__, 'zones')))
