# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCompliancePolicyRulesResult',
    'AwaitableGetCompliancePolicyRulesResult',
    'get_compliance_policy_rules',
    'get_compliance_policy_rules_output',
]

@pulumi.output_type
class GetCompliancePolicyRulesResult:
    """
    A collection of values returned by getCompliancePolicyRules.
    """
    def __init__(__self__, compartment_id=None, compliance_policy_id=None, compliance_policy_rule_collections=None, display_name=None, filters=None, id=None, patch_name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_policy_id and not isinstance(compliance_policy_id, str):
            raise TypeError("Expected argument 'compliance_policy_id' to be a str")
        pulumi.set(__self__, "compliance_policy_id", compliance_policy_id)
        if compliance_policy_rule_collections and not isinstance(compliance_policy_rule_collections, list):
            raise TypeError("Expected argument 'compliance_policy_rule_collections' to be a list")
        pulumi.set(__self__, "compliance_policy_rule_collections", compliance_policy_rule_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if patch_name and not isinstance(patch_name, str):
            raise TypeError("Expected argument 'patch_name' to be a str")
        pulumi.set(__self__, "patch_name", patch_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment the CompliancePolicyRule belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compliancePolicyId")
    def compliance_policy_id(self) -> Optional[str]:
        """
        Unique OCID of the CompliancePolicy.
        """
        return pulumi.get(self, "compliance_policy_id")

    @property
    @pulumi.getter(name="compliancePolicyRuleCollections")
    def compliance_policy_rule_collections(self) -> Sequence['outputs.GetCompliancePolicyRulesCompliancePolicyRuleCollectionResult']:
        """
        The list of compliance_policy_rule_collection.
        """
        return pulumi.get(self, "compliance_policy_rule_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCompliancePolicyRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique OCID of the CompliancePolicyRule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="patchName")
    def patch_name(self) -> Optional[str]:
        """
        Patch Name.
        """
        return pulumi.get(self, "patch_name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the CompliancePolicyRule.
        """
        return pulumi.get(self, "state")


class AwaitableGetCompliancePolicyRulesResult(GetCompliancePolicyRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCompliancePolicyRulesResult(
            compartment_id=self.compartment_id,
            compliance_policy_id=self.compliance_policy_id,
            compliance_policy_rule_collections=self.compliance_policy_rule_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            patch_name=self.patch_name,
            state=self.state)


def get_compliance_policy_rules(compartment_id: Optional[str] = None,
                                compliance_policy_id: Optional[str] = None,
                                display_name: Optional[str] = None,
                                filters: Optional[Sequence[Union['GetCompliancePolicyRulesFilterArgs', 'GetCompliancePolicyRulesFilterArgsDict']]] = None,
                                id: Optional[str] = None,
                                patch_name: Optional[str] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCompliancePolicyRulesResult:
    """
    This data source provides the list of Compliance Policy Rules in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of CompliancePolicyRules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policy_rules = oci.FleetAppsManagement.get_compliance_policy_rules(compartment_id=compartment_id,
        compliance_policy_id=test_compliance_policy["id"],
        display_name=compliance_policy_rule_display_name,
        id=compliance_policy_rule_id,
        patch_name=test_patch["name"],
        state=compliance_policy_rule_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str compliance_policy_id: unique CompliancePolicy identifier.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique CompliancePolicyRule identifier.
    :param str patch_name: A filter to return only resources that match the patch selection against the given patch name.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compliancePolicyId'] = compliance_policy_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['patchName'] = patch_name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getCompliancePolicyRules:getCompliancePolicyRules', __args__, opts=opts, typ=GetCompliancePolicyRulesResult).value

    return AwaitableGetCompliancePolicyRulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_policy_id=pulumi.get(__ret__, 'compliance_policy_id'),
        compliance_policy_rule_collections=pulumi.get(__ret__, 'compliance_policy_rule_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        patch_name=pulumi.get(__ret__, 'patch_name'),
        state=pulumi.get(__ret__, 'state'))
def get_compliance_policy_rules_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       compliance_policy_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCompliancePolicyRulesFilterArgs', 'GetCompliancePolicyRulesFilterArgsDict']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[str]]] = None,
                                       patch_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCompliancePolicyRulesResult]:
    """
    This data source provides the list of Compliance Policy Rules in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of CompliancePolicyRules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policy_rules = oci.FleetAppsManagement.get_compliance_policy_rules(compartment_id=compartment_id,
        compliance_policy_id=test_compliance_policy["id"],
        display_name=compliance_policy_rule_display_name,
        id=compliance_policy_rule_id,
        patch_name=test_patch["name"],
        state=compliance_policy_rule_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str compliance_policy_id: unique CompliancePolicy identifier.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique CompliancePolicyRule identifier.
    :param str patch_name: A filter to return only resources that match the patch selection against the given patch name.
    :param str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compliancePolicyId'] = compliance_policy_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['patchName'] = patch_name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getCompliancePolicyRules:getCompliancePolicyRules', __args__, opts=opts, typ=GetCompliancePolicyRulesResult)
    return __ret__.apply(lambda __response__: GetCompliancePolicyRulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_policy_id=pulumi.get(__response__, 'compliance_policy_id'),
        compliance_policy_rule_collections=pulumi.get(__response__, 'compliance_policy_rule_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        patch_name=pulumi.get(__response__, 'patch_name'),
        state=pulumi.get(__response__, 'state')))
