# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecipesResult',
    'AwaitableGetRecipesResult',
    'get_recipes',
    'get_recipes_output',
]

@pulumi.output_type
class GetRecipesResult:
    """
    A collection of values returned by getRecipes.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, recipe_summary_collections=None, recipe_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recipe_summary_collections and not isinstance(recipe_summary_collections, list):
            raise TypeError("Expected argument 'recipe_summary_collections' to be a list")
        pulumi.set(__self__, "recipe_summary_collections", recipe_summary_collections)
        if recipe_type and not isinstance(recipe_type, str):
            raise TypeError("Expected argument 'recipe_type' to be a str")
        pulumi.set(__self__, "recipe_type", recipe_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecipesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipeSummaryCollections")
    def recipe_summary_collections(self) -> Sequence['outputs.GetRecipesRecipeSummaryCollectionResult']:
        """
        The list of recipe_summary_collection.
        """
        return pulumi.get(self, "recipe_summary_collections")

    @property
    @pulumi.getter(name="recipeType")
    def recipe_type(self) -> Optional[str]:
        """
        The type of the recipe
        """
        return pulumi.get(self, "recipe_type")


class AwaitableGetRecipesResult(GetRecipesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecipesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            recipe_summary_collections=self.recipe_summary_collections,
            recipe_type=self.recipe_type)


def get_recipes(compartment_id: Optional[str] = None,
                display_name: Optional[str] = None,
                filters: Optional[Sequence[Union['GetRecipesFilterArgs', 'GetRecipesFilterArgsDict']]] = None,
                recipe_type: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecipesResult:
    """
    This data source provides the list of Recipes in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of Recipe Summary.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recipes = oci.GoldenGate.get_recipes(compartment_id=compartment_id,
        display_name=recipe_display_name,
        recipe_type=recipe_recipe_type)
    ```


    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str recipe_type: The pipeline's recipe type. The default value is ZERO_ETL.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['recipeType'] = recipe_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getRecipes:getRecipes', __args__, opts=opts, typ=GetRecipesResult).value

    return AwaitableGetRecipesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        recipe_summary_collections=pulumi.get(__ret__, 'recipe_summary_collections'),
        recipe_type=pulumi.get(__ret__, 'recipe_type'))
def get_recipes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                       display_name: Optional[pulumi.Input[Optional[str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRecipesFilterArgs', 'GetRecipesFilterArgsDict']]]]] = None,
                       recipe_type: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecipesResult]:
    """
    This data source provides the list of Recipes in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of Recipe Summary.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recipes = oci.GoldenGate.get_recipes(compartment_id=compartment_id,
        display_name=recipe_display_name,
        recipe_type=recipe_recipe_type)
    ```


    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str recipe_type: The pipeline's recipe type. The default value is ZERO_ETL.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['recipeType'] = recipe_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getRecipes:getRecipes', __args__, opts=opts, typ=GetRecipesResult)
    return __ret__.apply(lambda __response__: GetRecipesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        recipe_summary_collections=pulumi.get(__response__, 'recipe_summary_collections'),
        recipe_type=pulumi.get(__response__, 'recipe_type')))
