# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrailSequenceResult',
    'AwaitableGetTrailSequenceResult',
    'get_trail_sequence',
    'get_trail_sequence_output',
]

@pulumi.output_type
class GetTrailSequenceResult:
    """
    A collection of values returned by getTrailSequence.
    """
    def __init__(__self__, deployment_id=None, display_name=None, id=None, items=None, time_last_fetched=None, trail_file_id=None, trail_sequence_id=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if time_last_fetched and not isinstance(time_last_fetched, str):
            raise TypeError("Expected argument 'time_last_fetched' to be a str")
        pulumi.set(__self__, "time_last_fetched", time_last_fetched)
        if trail_file_id and not isinstance(trail_file_id, str):
            raise TypeError("Expected argument 'trail_file_id' to be a str")
        pulumi.set(__self__, "trail_file_id", trail_file_id)
        if trail_sequence_id and not isinstance(trail_sequence_id, str):
            raise TypeError("Expected argument 'trail_sequence_id' to be a str")
        pulumi.set(__self__, "trail_sequence_id", trail_sequence_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTrailSequenceItemResult']:
        """
        An array of TrailSequences.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="timeLastFetched")
    def time_last_fetched(self) -> str:
        """
        The time the data was last fetched from the deployment. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_fetched")

    @property
    @pulumi.getter(name="trailFileId")
    def trail_file_id(self) -> str:
        return pulumi.get(self, "trail_file_id")

    @property
    @pulumi.getter(name="trailSequenceId")
    def trail_sequence_id(self) -> str:
        return pulumi.get(self, "trail_sequence_id")


class AwaitableGetTrailSequenceResult(GetTrailSequenceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrailSequenceResult(
            deployment_id=self.deployment_id,
            display_name=self.display_name,
            id=self.id,
            items=self.items,
            time_last_fetched=self.time_last_fetched,
            trail_file_id=self.trail_file_id,
            trail_sequence_id=self.trail_sequence_id)


def get_trail_sequence(deployment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       trail_file_id: Optional[str] = None,
                       trail_sequence_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrailSequenceResult:
    """
    This data source provides details about a specific Trail Sequence resource in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Trail Sequences for a TrailFile in a given deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trail_sequence = oci.GoldenGate.get_trail_sequence(deployment_id=test_deployment["id"],
        trail_file_id=test_trail_file["id"],
        display_name=trail_sequence_display_name,
        trail_sequence_id=test_trail_sequence_oci_golden_gate_trail_sequence["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str trail_file_id: A Trail File identifier
    :param str trail_sequence_id: A Trail Sequence identifier
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['displayName'] = display_name
    __args__['trailFileId'] = trail_file_id
    __args__['trailSequenceId'] = trail_sequence_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getTrailSequence:getTrailSequence', __args__, opts=opts, typ=GetTrailSequenceResult).value

    return AwaitableGetTrailSequenceResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        time_last_fetched=pulumi.get(__ret__, 'time_last_fetched'),
        trail_file_id=pulumi.get(__ret__, 'trail_file_id'),
        trail_sequence_id=pulumi.get(__ret__, 'trail_sequence_id'))
def get_trail_sequence_output(deployment_id: Optional[pulumi.Input[str]] = None,
                              display_name: Optional[pulumi.Input[str]] = None,
                              trail_file_id: Optional[pulumi.Input[str]] = None,
                              trail_sequence_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrailSequenceResult]:
    """
    This data source provides details about a specific Trail Sequence resource in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Trail Sequences for a TrailFile in a given deployment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trail_sequence = oci.GoldenGate.get_trail_sequence(deployment_id=test_deployment["id"],
        trail_file_id=test_trail_file["id"],
        display_name=trail_sequence_display_name,
        trail_sequence_id=test_trail_sequence_oci_golden_gate_trail_sequence["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str trail_file_id: A Trail File identifier
    :param str trail_sequence_id: A Trail Sequence identifier
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['displayName'] = display_name
    __args__['trailFileId'] = trail_file_id
    __args__['trailSequenceId'] = trail_sequence_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getTrailSequence:getTrailSequence', __args__, opts=opts, typ=GetTrailSequenceResult)
    return __ret__.apply(lambda __response__: GetTrailSequenceResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        time_last_fetched=pulumi.get(__response__, 'time_last_fetched'),
        trail_file_id=pulumi.get(__response__, 'trail_file_id'),
        trail_sequence_id=pulumi.get(__response__, 'trail_sequence_id')))
