# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsPasswordPolicyArgs', 'DomainsPasswordPolicy']

@pulumi.input_type
class DomainsPasswordPolicyArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_chars: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dictionary_delimiter: Optional[pulumi.Input[str]] = None,
                 dictionary_location: Optional[pulumi.Input[str]] = None,
                 dictionary_word_disallowed: Optional[pulumi.Input[bool]] = None,
                 disallowed_chars: Optional[pulumi.Input[str]] = None,
                 disallowed_substrings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disallowed_user_attribute_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distinct_characters: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 first_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 force_password_reset: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]] = None,
                 last_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 lockout_duration: Optional[pulumi.Input[int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_repeated_chars: Optional[pulumi.Input[int]] = None,
                 max_special_chars: Optional[pulumi.Input[int]] = None,
                 min_alpha_numerals: Optional[pulumi.Input[int]] = None,
                 min_alphas: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case: Optional[pulumi.Input[int]] = None,
                 min_numerals: Optional[pulumi.Input[int]] = None,
                 min_password_age: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_unique_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_passwords_in_history: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password_expire_warning: Optional[pulumi.Input[int]] = None,
                 password_expires_after: Optional[pulumi.Input[int]] = None,
                 password_strength: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 required_chars: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 starts_with_alphabet: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]] = None,
                 user_name_disallowed: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DomainsPasswordPolicy resource.
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] allowed_chars: (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) A String that describes the password policy
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_delimiter: (Updatable) A delimiter used to separate characters in the dictionary file
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_location: (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] dictionary_word_disallowed: (Updatable) Indicates whether the password can match a dictionary word
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] disallowed_chars: (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_substrings: (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_user_attribute_values: (Updatable) List of User attributes whose values are not allowed in the password.
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] distinct_characters: (Updatable) The number of distinct characters between old password and new password
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] first_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] force_password_reset: (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]] groups: (Updatable) A list of groups that the password policy belongs to.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] last_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[int] lockout_duration: (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_incorrect_attempts: (Updatable) An integer that represents the maximum number of failed logins before an account is locked
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_length: (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_repeated_chars: (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_special_chars: (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alpha_numerals: (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alphas: (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_length: (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_lower_case: (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_numerals: (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_password_age: (Updatable) Minimum time after which the user can resubmit the reset password request
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_special_chars: (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_unique_chars: (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_upper_case: (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[int] num_passwords_in_history: (Updatable) The number of passwords that will be kept in history that may not be used as a password
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[int] password_expire_warning: (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] password_expires_after: (Updatable) The number of days after which the password expires automatically
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] password_strength: (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] priority: (Updatable) Password policy priority
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * idcsMinValue: 1
               * uniqueness: server
        :param pulumi.Input[str] required_chars: (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] starts_with_alphabet: (Updatable) Indicates that the password must begin with an alphabetic character
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_name_disallowed: (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        if allowed_chars is not None:
            pulumi.set(__self__, "allowed_chars", allowed_chars)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dictionary_delimiter is not None:
            pulumi.set(__self__, "dictionary_delimiter", dictionary_delimiter)
        if dictionary_location is not None:
            pulumi.set(__self__, "dictionary_location", dictionary_location)
        if dictionary_word_disallowed is not None:
            pulumi.set(__self__, "dictionary_word_disallowed", dictionary_word_disallowed)
        if disallowed_chars is not None:
            pulumi.set(__self__, "disallowed_chars", disallowed_chars)
        if disallowed_substrings is not None:
            pulumi.set(__self__, "disallowed_substrings", disallowed_substrings)
        if disallowed_user_attribute_values is not None:
            pulumi.set(__self__, "disallowed_user_attribute_values", disallowed_user_attribute_values)
        if distinct_characters is not None:
            pulumi.set(__self__, "distinct_characters", distinct_characters)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if first_name_disallowed is not None:
            pulumi.set(__self__, "first_name_disallowed", first_name_disallowed)
        if force_password_reset is not None:
            pulumi.set(__self__, "force_password_reset", force_password_reset)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if last_name_disallowed is not None:
            pulumi.set(__self__, "last_name_disallowed", last_name_disallowed)
        if lockout_duration is not None:
            pulumi.set(__self__, "lockout_duration", lockout_duration)
        if max_incorrect_attempts is not None:
            pulumi.set(__self__, "max_incorrect_attempts", max_incorrect_attempts)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_repeated_chars is not None:
            pulumi.set(__self__, "max_repeated_chars", max_repeated_chars)
        if max_special_chars is not None:
            pulumi.set(__self__, "max_special_chars", max_special_chars)
        if min_alpha_numerals is not None:
            pulumi.set(__self__, "min_alpha_numerals", min_alpha_numerals)
        if min_alphas is not None:
            pulumi.set(__self__, "min_alphas", min_alphas)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case is not None:
            pulumi.set(__self__, "min_lower_case", min_lower_case)
        if min_numerals is not None:
            pulumi.set(__self__, "min_numerals", min_numerals)
        if min_password_age is not None:
            pulumi.set(__self__, "min_password_age", min_password_age)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_unique_chars is not None:
            pulumi.set(__self__, "min_unique_chars", min_unique_chars)
        if min_upper_case is not None:
            pulumi.set(__self__, "min_upper_case", min_upper_case)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_passwords_in_history is not None:
            pulumi.set(__self__, "num_passwords_in_history", num_passwords_in_history)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if password_expire_warning is not None:
            pulumi.set(__self__, "password_expire_warning", password_expire_warning)
        if password_expires_after is not None:
            pulumi.set(__self__, "password_expires_after", password_expires_after)
        if password_strength is not None:
            pulumi.set(__self__, "password_strength", password_strength)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if required_chars is not None:
            pulumi.set(__self__, "required_chars", required_chars)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if starts_with_alphabet is not None:
            pulumi.set(__self__, "starts_with_alphabet", starts_with_alphabet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name_disallowed is not None:
            pulumi.set(__self__, "user_name_disallowed", user_name_disallowed)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="allowedChars")
    def allowed_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_chars")

    @allowed_chars.setter
    def allowed_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_chars", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String that describes the password policy

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dictionaryDelimiter")
    def dictionary_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A delimiter used to separate characters in the dictionary file

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_delimiter")

    @dictionary_delimiter.setter
    def dictionary_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_delimiter", value)

    @property
    @pulumi.getter(name="dictionaryLocation")
    def dictionary_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_location")

    @dictionary_location.setter
    def dictionary_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_location", value)

    @property
    @pulumi.getter(name="dictionaryWordDisallowed")
    def dictionary_word_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the password can match a dictionary word

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_word_disallowed")

    @dictionary_word_disallowed.setter
    def dictionary_word_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dictionary_word_disallowed", value)

    @property
    @pulumi.getter(name="disallowedChars")
    def disallowed_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_chars")

    @disallowed_chars.setter
    def disallowed_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disallowed_chars", value)

    @property
    @pulumi.getter(name="disallowedSubstrings")
    def disallowed_substrings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_substrings")

    @disallowed_substrings.setter
    def disallowed_substrings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disallowed_substrings", value)

    @property
    @pulumi.getter(name="disallowedUserAttributeValues")
    def disallowed_user_attribute_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of User attributes whose values are not allowed in the password.

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_user_attribute_values")

    @disallowed_user_attribute_values.setter
    def disallowed_user_attribute_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disallowed_user_attribute_values", value)

    @property
    @pulumi.getter(name="distinctCharacters")
    def distinct_characters(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of distinct characters between old password and new password

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "distinct_characters")

    @distinct_characters.setter
    def distinct_characters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distinct_characters", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="firstNameDisallowed")
    def first_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "first_name_disallowed")

    @first_name_disallowed.setter
    def first_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_name_disallowed", value)

    @property
    @pulumi.getter(name="forcePasswordReset")
    def force_password_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "force_password_reset")

    @force_password_reset.setter
    def force_password_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_password_reset", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]]:
        """
        (Updatable) A list of groups that the password policy belongs to.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="lastNameDisallowed")
    def last_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "last_name_disallowed")

    @last_name_disallowed.setter
    def last_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "last_name_disallowed", value)

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "lockout_duration")

    @lockout_duration.setter
    def lockout_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lockout_duration", value)

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An integer that represents the maximum number of failed logins before an account is locked

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @max_incorrect_attempts.setter
    def max_incorrect_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_incorrect_attempts", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxRepeatedChars")
    def max_repeated_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_repeated_chars")

    @max_repeated_chars.setter
    def max_repeated_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_repeated_chars", value)

    @property
    @pulumi.getter(name="maxSpecialChars")
    def max_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_special_chars")

    @max_special_chars.setter
    def max_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_special_chars", value)

    @property
    @pulumi.getter(name="minAlphaNumerals")
    def min_alpha_numerals(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alpha_numerals")

    @min_alpha_numerals.setter
    def min_alpha_numerals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_alpha_numerals", value)

    @property
    @pulumi.getter(name="minAlphas")
    def min_alphas(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alphas")

    @min_alphas.setter
    def min_alphas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_alphas", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minLowerCase")
    def min_lower_case(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_lower_case")

    @min_lower_case.setter
    def min_lower_case(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_lower_case", value)

    @property
    @pulumi.getter(name="minNumerals")
    def min_numerals(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_numerals")

    @min_numerals.setter
    def min_numerals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_numerals", value)

    @property
    @pulumi.getter(name="minPasswordAge")
    def min_password_age(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Minimum time after which the user can resubmit the reset password request

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_password_age")

    @min_password_age.setter
    def min_password_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_password_age", value)

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_special_chars", value)

    @property
    @pulumi.getter(name="minUniqueChars")
    def min_unique_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_unique_chars")

    @min_unique_chars.setter
    def min_unique_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_unique_chars", value)

    @property
    @pulumi.getter(name="minUpperCase")
    def min_upper_case(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_upper_case")

    @min_upper_case.setter
    def min_upper_case(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_upper_case", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numPasswordsInHistory")
    def num_passwords_in_history(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of passwords that will be kept in history that may not be used as a password

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "num_passwords_in_history")

    @num_passwords_in_history.setter
    def num_passwords_in_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_passwords_in_history", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="passwordExpireWarning")
    def password_expire_warning(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expire_warning")

    @password_expire_warning.setter
    def password_expire_warning(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_expire_warning", value)

    @property
    @pulumi.getter(name="passwordExpiresAfter")
    def password_expires_after(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days after which the password expires automatically

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expires_after")

    @password_expires_after.setter
    def password_expires_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_expires_after", value)

    @property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password_strength")

    @password_strength.setter
    def password_strength(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_strength", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Password policy priority

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * idcsMinValue: 1
        * uniqueness: server
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="requiredChars")
    def required_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "required_chars")

    @required_chars.setter
    def required_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "required_chars", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="startsWithAlphabet")
    def starts_with_alphabet(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates that the password must begin with an alphabetic character

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "starts_with_alphabet")

    @starts_with_alphabet.setter
    def starts_with_alphabet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "starts_with_alphabet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userNameDisallowed")
    def user_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_name_disallowed")

    @user_name_disallowed.setter
    def user_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_name_disallowed", value)


@pulumi.input_type
class _DomainsPasswordPolicyState:
    def __init__(__self__, *,
                 allowed_chars: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 configured_password_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs']]]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dictionary_delimiter: Optional[pulumi.Input[str]] = None,
                 dictionary_location: Optional[pulumi.Input[str]] = None,
                 dictionary_word_disallowed: Optional[pulumi.Input[bool]] = None,
                 disallowed_chars: Optional[pulumi.Input[str]] = None,
                 disallowed_substrings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disallowed_user_attribute_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distinct_characters: Optional[pulumi.Input[int]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 first_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 force_password_reset: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 lockout_duration: Optional[pulumi.Input[int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_repeated_chars: Optional[pulumi.Input[int]] = None,
                 max_special_chars: Optional[pulumi.Input[int]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyMetaArgs']]]] = None,
                 min_alpha_numerals: Optional[pulumi.Input[int]] = None,
                 min_alphas: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case: Optional[pulumi.Input[int]] = None,
                 min_numerals: Optional[pulumi.Input[int]] = None,
                 min_password_age: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_unique_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_passwords_in_history: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password_expire_warning: Optional[pulumi.Input[int]] = None,
                 password_expires_after: Optional[pulumi.Input[int]] = None,
                 password_strength: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 required_chars: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 starts_with_alphabet: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 user_name_disallowed: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DomainsPasswordPolicy resources.
        :param pulumi.Input[str] allowed_chars: (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs']]] configured_password_policy_rules: (Updatable) List of password policy rules that have values set. This map of stringKey:stringValue pairs can be used to aid users while setting/resetting password
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [key]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) A String that describes the password policy
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_delimiter: (Updatable) A delimiter used to separate characters in the dictionary file
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_location: (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] dictionary_word_disallowed: (Updatable) Indicates whether the password can match a dictionary word
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] disallowed_chars: (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_substrings: (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_user_attribute_values: (Updatable) List of User attributes whose values are not allowed in the password.
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] distinct_characters: (Updatable) The number of distinct characters between old password and new password
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] first_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] force_password_reset: (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]] groups: (Updatable) A list of groups that the password policy belongs to.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] last_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[int] lockout_duration: (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_incorrect_attempts: (Updatable) An integer that represents the maximum number of failed logins before an account is locked
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_length: (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_repeated_chars: (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_special_chars: (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[int] min_alpha_numerals: (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alphas: (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_length: (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_lower_case: (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_numerals: (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_password_age: (Updatable) Minimum time after which the user can resubmit the reset password request
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_special_chars: (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_unique_chars: (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_upper_case: (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[int] num_passwords_in_history: (Updatable) The number of passwords that will be kept in history that may not be used as a password
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[int] password_expire_warning: (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] password_expires_after: (Updatable) The number of days after which the password expires automatically
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] password_strength: (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] priority: (Updatable) Password policy priority
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * idcsMinValue: 1
               * uniqueness: server
        :param pulumi.Input[str] required_chars: (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] starts_with_alphabet: (Updatable) Indicates that the password must begin with an alphabetic character
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] user_name_disallowed: (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if allowed_chars is not None:
            pulumi.set(__self__, "allowed_chars", allowed_chars)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if configured_password_policy_rules is not None:
            pulumi.set(__self__, "configured_password_policy_rules", configured_password_policy_rules)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dictionary_delimiter is not None:
            pulumi.set(__self__, "dictionary_delimiter", dictionary_delimiter)
        if dictionary_location is not None:
            pulumi.set(__self__, "dictionary_location", dictionary_location)
        if dictionary_word_disallowed is not None:
            pulumi.set(__self__, "dictionary_word_disallowed", dictionary_word_disallowed)
        if disallowed_chars is not None:
            pulumi.set(__self__, "disallowed_chars", disallowed_chars)
        if disallowed_substrings is not None:
            pulumi.set(__self__, "disallowed_substrings", disallowed_substrings)
        if disallowed_user_attribute_values is not None:
            pulumi.set(__self__, "disallowed_user_attribute_values", disallowed_user_attribute_values)
        if distinct_characters is not None:
            pulumi.set(__self__, "distinct_characters", distinct_characters)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if first_name_disallowed is not None:
            pulumi.set(__self__, "first_name_disallowed", first_name_disallowed)
        if force_password_reset is not None:
            pulumi.set(__self__, "force_password_reset", force_password_reset)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if last_name_disallowed is not None:
            pulumi.set(__self__, "last_name_disallowed", last_name_disallowed)
        if lockout_duration is not None:
            pulumi.set(__self__, "lockout_duration", lockout_duration)
        if max_incorrect_attempts is not None:
            pulumi.set(__self__, "max_incorrect_attempts", max_incorrect_attempts)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_repeated_chars is not None:
            pulumi.set(__self__, "max_repeated_chars", max_repeated_chars)
        if max_special_chars is not None:
            pulumi.set(__self__, "max_special_chars", max_special_chars)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if min_alpha_numerals is not None:
            pulumi.set(__self__, "min_alpha_numerals", min_alpha_numerals)
        if min_alphas is not None:
            pulumi.set(__self__, "min_alphas", min_alphas)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case is not None:
            pulumi.set(__self__, "min_lower_case", min_lower_case)
        if min_numerals is not None:
            pulumi.set(__self__, "min_numerals", min_numerals)
        if min_password_age is not None:
            pulumi.set(__self__, "min_password_age", min_password_age)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_unique_chars is not None:
            pulumi.set(__self__, "min_unique_chars", min_unique_chars)
        if min_upper_case is not None:
            pulumi.set(__self__, "min_upper_case", min_upper_case)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_passwords_in_history is not None:
            pulumi.set(__self__, "num_passwords_in_history", num_passwords_in_history)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if password_expire_warning is not None:
            pulumi.set(__self__, "password_expire_warning", password_expire_warning)
        if password_expires_after is not None:
            pulumi.set(__self__, "password_expires_after", password_expires_after)
        if password_strength is not None:
            pulumi.set(__self__, "password_strength", password_strength)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if required_chars is not None:
            pulumi.set(__self__, "required_chars", required_chars)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if starts_with_alphabet is not None:
            pulumi.set(__self__, "starts_with_alphabet", starts_with_alphabet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if user_name_disallowed is not None:
            pulumi.set(__self__, "user_name_disallowed", user_name_disallowed)

    @property
    @pulumi.getter(name="allowedChars")
    def allowed_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_chars")

    @allowed_chars.setter
    def allowed_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_chars", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="configuredPasswordPolicyRules")
    def configured_password_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs']]]]:
        """
        (Updatable) List of password policy rules that have values set. This map of stringKey:stringValue pairs can be used to aid users while setting/resetting password

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [key]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "configured_password_policy_rules")

    @configured_password_policy_rules.setter
    def configured_password_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs']]]]):
        pulumi.set(self, "configured_password_policy_rules", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String that describes the password policy

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dictionaryDelimiter")
    def dictionary_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A delimiter used to separate characters in the dictionary file

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_delimiter")

    @dictionary_delimiter.setter
    def dictionary_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_delimiter", value)

    @property
    @pulumi.getter(name="dictionaryLocation")
    def dictionary_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_location")

    @dictionary_location.setter
    def dictionary_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_location", value)

    @property
    @pulumi.getter(name="dictionaryWordDisallowed")
    def dictionary_word_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the password can match a dictionary word

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_word_disallowed")

    @dictionary_word_disallowed.setter
    def dictionary_word_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dictionary_word_disallowed", value)

    @property
    @pulumi.getter(name="disallowedChars")
    def disallowed_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_chars")

    @disallowed_chars.setter
    def disallowed_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disallowed_chars", value)

    @property
    @pulumi.getter(name="disallowedSubstrings")
    def disallowed_substrings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_substrings")

    @disallowed_substrings.setter
    def disallowed_substrings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disallowed_substrings", value)

    @property
    @pulumi.getter(name="disallowedUserAttributeValues")
    def disallowed_user_attribute_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of User attributes whose values are not allowed in the password.

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_user_attribute_values")

    @disallowed_user_attribute_values.setter
    def disallowed_user_attribute_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disallowed_user_attribute_values", value)

    @property
    @pulumi.getter(name="distinctCharacters")
    def distinct_characters(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of distinct characters between old password and new password

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "distinct_characters")

    @distinct_characters.setter
    def distinct_characters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "distinct_characters", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="firstNameDisallowed")
    def first_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "first_name_disallowed")

    @first_name_disallowed.setter
    def first_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_name_disallowed", value)

    @property
    @pulumi.getter(name="forcePasswordReset")
    def force_password_reset(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "force_password_reset")

    @force_password_reset.setter
    def force_password_reset(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_password_reset", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]]:
        """
        (Updatable) A list of groups that the password policy belongs to.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="lastNameDisallowed")
    def last_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "last_name_disallowed")

    @last_name_disallowed.setter
    def last_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "last_name_disallowed", value)

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "lockout_duration")

    @lockout_duration.setter
    def lockout_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lockout_duration", value)

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An integer that represents the maximum number of failed logins before an account is locked

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @max_incorrect_attempts.setter
    def max_incorrect_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_incorrect_attempts", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxRepeatedChars")
    def max_repeated_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_repeated_chars")

    @max_repeated_chars.setter
    def max_repeated_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_repeated_chars", value)

    @property
    @pulumi.getter(name="maxSpecialChars")
    def max_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_special_chars")

    @max_special_chars.setter
    def max_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_special_chars", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="minAlphaNumerals")
    def min_alpha_numerals(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alpha_numerals")

    @min_alpha_numerals.setter
    def min_alpha_numerals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_alpha_numerals", value)

    @property
    @pulumi.getter(name="minAlphas")
    def min_alphas(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alphas")

    @min_alphas.setter
    def min_alphas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_alphas", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minLowerCase")
    def min_lower_case(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_lower_case")

    @min_lower_case.setter
    def min_lower_case(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_lower_case", value)

    @property
    @pulumi.getter(name="minNumerals")
    def min_numerals(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_numerals")

    @min_numerals.setter
    def min_numerals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_numerals", value)

    @property
    @pulumi.getter(name="minPasswordAge")
    def min_password_age(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Minimum time after which the user can resubmit the reset password request

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_password_age")

    @min_password_age.setter
    def min_password_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_password_age", value)

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_special_chars", value)

    @property
    @pulumi.getter(name="minUniqueChars")
    def min_unique_chars(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_unique_chars")

    @min_unique_chars.setter
    def min_unique_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_unique_chars", value)

    @property
    @pulumi.getter(name="minUpperCase")
    def min_upper_case(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_upper_case")

    @min_upper_case.setter
    def min_upper_case(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_upper_case", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numPasswordsInHistory")
    def num_passwords_in_history(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of passwords that will be kept in history that may not be used as a password

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "num_passwords_in_history")

    @num_passwords_in_history.setter
    def num_passwords_in_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_passwords_in_history", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="passwordExpireWarning")
    def password_expire_warning(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expire_warning")

    @password_expire_warning.setter
    def password_expire_warning(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_expire_warning", value)

    @property
    @pulumi.getter(name="passwordExpiresAfter")
    def password_expires_after(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of days after which the password expires automatically

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expires_after")

    @password_expires_after.setter
    def password_expires_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_expires_after", value)

    @property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password_strength")

    @password_strength.setter
    def password_strength(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_strength", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Password policy priority

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * idcsMinValue: 1
        * uniqueness: server
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="requiredChars")
    def required_chars(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "required_chars")

    @required_chars.setter
    def required_chars(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "required_chars", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="startsWithAlphabet")
    def starts_with_alphabet(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates that the password must begin with an alphabetic character

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "starts_with_alphabet")

    @starts_with_alphabet.setter
    def starts_with_alphabet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "starts_with_alphabet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsPasswordPolicyTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="userNameDisallowed")
    def user_name_disallowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_name_disallowed")

    @user_name_disallowed.setter
    def user_name_disallowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_name_disallowed", value)


class DomainsPasswordPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_chars: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dictionary_delimiter: Optional[pulumi.Input[str]] = None,
                 dictionary_location: Optional[pulumi.Input[str]] = None,
                 dictionary_word_disallowed: Optional[pulumi.Input[bool]] = None,
                 disallowed_chars: Optional[pulumi.Input[str]] = None,
                 disallowed_substrings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disallowed_user_attribute_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distinct_characters: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 first_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 force_password_reset: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyGroupArgs', 'DomainsPasswordPolicyGroupArgsDict']]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 last_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 lockout_duration: Optional[pulumi.Input[int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_repeated_chars: Optional[pulumi.Input[int]] = None,
                 max_special_chars: Optional[pulumi.Input[int]] = None,
                 min_alpha_numerals: Optional[pulumi.Input[int]] = None,
                 min_alphas: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case: Optional[pulumi.Input[int]] = None,
                 min_numerals: Optional[pulumi.Input[int]] = None,
                 min_password_age: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_unique_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_passwords_in_history: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password_expire_warning: Optional[pulumi.Input[int]] = None,
                 password_expires_after: Optional[pulumi.Input[int]] = None,
                 password_strength: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 required_chars: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 starts_with_alphabet: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyTagArgs', 'DomainsPasswordPolicyTagArgsDict']]]]] = None,
                 user_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Password Policy resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a password policy.

        ## Import

        PasswordPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsPasswordPolicy:DomainsPasswordPolicy test_password_policy "idcsEndpoint/{idcsEndpoint}/passwordPolicies/{passwordPolicyId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_chars: (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) A String that describes the password policy
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_delimiter: (Updatable) A delimiter used to separate characters in the dictionary file
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_location: (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] dictionary_word_disallowed: (Updatable) Indicates whether the password can match a dictionary word
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] disallowed_chars: (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_substrings: (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_user_attribute_values: (Updatable) List of User attributes whose values are not allowed in the password.
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] distinct_characters: (Updatable) The number of distinct characters between old password and new password
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] first_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] force_password_reset: (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyGroupArgs', 'DomainsPasswordPolicyGroupArgsDict']]]] groups: (Updatable) A list of groups that the password policy belongs to.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[bool] last_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[int] lockout_duration: (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_incorrect_attempts: (Updatable) An integer that represents the maximum number of failed logins before an account is locked
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_length: (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_repeated_chars: (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_special_chars: (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alpha_numerals: (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alphas: (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_length: (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_lower_case: (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_numerals: (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_password_age: (Updatable) Minimum time after which the user can resubmit the reset password request
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_special_chars: (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_unique_chars: (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_upper_case: (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[int] num_passwords_in_history: (Updatable) The number of passwords that will be kept in history that may not be used as a password
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[int] password_expire_warning: (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] password_expires_after: (Updatable) The number of days after which the password expires automatically
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] password_strength: (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] priority: (Updatable) Password policy priority
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * idcsMinValue: 1
               * uniqueness: server
        :param pulumi.Input[str] required_chars: (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] starts_with_alphabet: (Updatable) Indicates that the password must begin with an alphabetic character
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyTagArgs', 'DomainsPasswordPolicyTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_name_disallowed: (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsPasswordPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Password Policy resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a password policy.

        ## Import

        PasswordPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsPasswordPolicy:DomainsPasswordPolicy test_password_policy "idcsEndpoint/{idcsEndpoint}/passwordPolicies/{passwordPolicyId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsPasswordPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsPasswordPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_chars: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dictionary_delimiter: Optional[pulumi.Input[str]] = None,
                 dictionary_location: Optional[pulumi.Input[str]] = None,
                 dictionary_word_disallowed: Optional[pulumi.Input[bool]] = None,
                 disallowed_chars: Optional[pulumi.Input[str]] = None,
                 disallowed_substrings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disallowed_user_attribute_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 distinct_characters: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 first_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 force_password_reset: Optional[pulumi.Input[bool]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyGroupArgs', 'DomainsPasswordPolicyGroupArgsDict']]]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 last_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 lockout_duration: Optional[pulumi.Input[int]] = None,
                 max_incorrect_attempts: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_repeated_chars: Optional[pulumi.Input[int]] = None,
                 max_special_chars: Optional[pulumi.Input[int]] = None,
                 min_alpha_numerals: Optional[pulumi.Input[int]] = None,
                 min_alphas: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case: Optional[pulumi.Input[int]] = None,
                 min_numerals: Optional[pulumi.Input[int]] = None,
                 min_password_age: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_unique_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_passwords_in_history: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password_expire_warning: Optional[pulumi.Input[int]] = None,
                 password_expires_after: Optional[pulumi.Input[int]] = None,
                 password_strength: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 required_chars: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 starts_with_alphabet: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyTagArgs', 'DomainsPasswordPolicyTagArgsDict']]]]] = None,
                 user_name_disallowed: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsPasswordPolicyArgs.__new__(DomainsPasswordPolicyArgs)

            __props__.__dict__["allowed_chars"] = allowed_chars
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["description"] = description
            __props__.__dict__["dictionary_delimiter"] = dictionary_delimiter
            __props__.__dict__["dictionary_location"] = dictionary_location
            __props__.__dict__["dictionary_word_disallowed"] = dictionary_word_disallowed
            __props__.__dict__["disallowed_chars"] = disallowed_chars
            __props__.__dict__["disallowed_substrings"] = disallowed_substrings
            __props__.__dict__["disallowed_user_attribute_values"] = disallowed_user_attribute_values
            __props__.__dict__["distinct_characters"] = distinct_characters
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["first_name_disallowed"] = first_name_disallowed
            __props__.__dict__["force_password_reset"] = force_password_reset
            __props__.__dict__["groups"] = groups
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["last_name_disallowed"] = last_name_disallowed
            __props__.__dict__["lockout_duration"] = lockout_duration
            __props__.__dict__["max_incorrect_attempts"] = max_incorrect_attempts
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["max_repeated_chars"] = max_repeated_chars
            __props__.__dict__["max_special_chars"] = max_special_chars
            __props__.__dict__["min_alpha_numerals"] = min_alpha_numerals
            __props__.__dict__["min_alphas"] = min_alphas
            __props__.__dict__["min_length"] = min_length
            __props__.__dict__["min_lower_case"] = min_lower_case
            __props__.__dict__["min_numerals"] = min_numerals
            __props__.__dict__["min_password_age"] = min_password_age
            __props__.__dict__["min_special_chars"] = min_special_chars
            __props__.__dict__["min_unique_chars"] = min_unique_chars
            __props__.__dict__["min_upper_case"] = min_upper_case
            __props__.__dict__["name"] = name
            __props__.__dict__["num_passwords_in_history"] = num_passwords_in_history
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["password_expire_warning"] = password_expire_warning
            __props__.__dict__["password_expires_after"] = password_expires_after
            __props__.__dict__["password_strength"] = None if password_strength is None else pulumi.Output.secret(password_strength)
            __props__.__dict__["priority"] = priority
            __props__.__dict__["required_chars"] = required_chars
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["starts_with_alphabet"] = starts_with_alphabet
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name_disallowed"] = user_name_disallowed
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["configured_password_policy_rules"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passwordStrength"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainsPasswordPolicy, __self__).__init__(
            'oci:Identity/domainsPasswordPolicy:DomainsPasswordPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_chars: Optional[pulumi.Input[str]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            configured_password_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs', 'DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgsDict']]]]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dictionary_delimiter: Optional[pulumi.Input[str]] = None,
            dictionary_location: Optional[pulumi.Input[str]] = None,
            dictionary_word_disallowed: Optional[pulumi.Input[bool]] = None,
            disallowed_chars: Optional[pulumi.Input[str]] = None,
            disallowed_substrings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            disallowed_user_attribute_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            distinct_characters: Optional[pulumi.Input[int]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            first_name_disallowed: Optional[pulumi.Input[bool]] = None,
            force_password_reset: Optional[pulumi.Input[bool]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyGroupArgs', 'DomainsPasswordPolicyGroupArgsDict']]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyIdcsCreatedByArgs', 'DomainsPasswordPolicyIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyIdcsLastModifiedByArgs', 'DomainsPasswordPolicyIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            last_name_disallowed: Optional[pulumi.Input[bool]] = None,
            lockout_duration: Optional[pulumi.Input[int]] = None,
            max_incorrect_attempts: Optional[pulumi.Input[int]] = None,
            max_length: Optional[pulumi.Input[int]] = None,
            max_repeated_chars: Optional[pulumi.Input[int]] = None,
            max_special_chars: Optional[pulumi.Input[int]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyMetaArgs', 'DomainsPasswordPolicyMetaArgsDict']]]]] = None,
            min_alpha_numerals: Optional[pulumi.Input[int]] = None,
            min_alphas: Optional[pulumi.Input[int]] = None,
            min_length: Optional[pulumi.Input[int]] = None,
            min_lower_case: Optional[pulumi.Input[int]] = None,
            min_numerals: Optional[pulumi.Input[int]] = None,
            min_password_age: Optional[pulumi.Input[int]] = None,
            min_special_chars: Optional[pulumi.Input[int]] = None,
            min_unique_chars: Optional[pulumi.Input[int]] = None,
            min_upper_case: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            num_passwords_in_history: Optional[pulumi.Input[int]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            password_expire_warning: Optional[pulumi.Input[int]] = None,
            password_expires_after: Optional[pulumi.Input[int]] = None,
            password_strength: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            required_chars: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            starts_with_alphabet: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyTagArgs', 'DomainsPasswordPolicyTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            user_name_disallowed: Optional[pulumi.Input[bool]] = None) -> 'DomainsPasswordPolicy':
        """
        Get an existing DomainsPasswordPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_chars: (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgs', 'DomainsPasswordPolicyConfiguredPasswordPolicyRuleArgsDict']]]] configured_password_policy_rules: (Updatable) List of password policy rules that have values set. This map of stringKey:stringValue pairs can be used to aid users while setting/resetting password
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [key]
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) A String that describes the password policy
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_delimiter: (Updatable) A delimiter used to separate characters in the dictionary file
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] dictionary_location: (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] dictionary_word_disallowed: (Updatable) Indicates whether the password can match a dictionary word
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] disallowed_chars: (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_substrings: (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disallowed_user_attribute_values: (Updatable) List of User attributes whose values are not allowed in the password.
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] distinct_characters: (Updatable) The number of distinct characters between old password and new password
               
               **Added In:** 2303212224
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] first_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] force_password_reset: (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyGroupArgs', 'DomainsPasswordPolicyGroupArgsDict']]]] groups: (Updatable) A list of groups that the password policy belongs to.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyIdcsCreatedByArgs', 'DomainsPasswordPolicyIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyIdcsLastModifiedByArgs', 'DomainsPasswordPolicyIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] last_name_disallowed: (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[int] lockout_duration: (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_incorrect_attempts: (Updatable) An integer that represents the maximum number of failed logins before an account is locked
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_length: (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_repeated_chars: (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] max_special_chars: (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyMetaArgs', 'DomainsPasswordPolicyMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[int] min_alpha_numerals: (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_alphas: (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_length: (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_lower_case: (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_numerals: (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_password_age: (Updatable) Minimum time after which the user can resubmit the reset password request
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_special_chars: (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_unique_chars: (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] min_upper_case: (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[int] num_passwords_in_history: (Updatable) The number of passwords that will be kept in history that may not be used as a password
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[int] password_expire_warning: (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[int] password_expires_after: (Updatable) The number of days after which the password expires automatically
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] password_strength: (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] priority: (Updatable) Password policy priority
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * idcsMinValue: 1
               * uniqueness: server
        :param pulumi.Input[str] required_chars: (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] starts_with_alphabet: (Updatable) Indicates that the password must begin with an alphabetic character
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsPasswordPolicyTagArgs', 'DomainsPasswordPolicyTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] user_name_disallowed: (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsPasswordPolicyState.__new__(_DomainsPasswordPolicyState)

        __props__.__dict__["allowed_chars"] = allowed_chars
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["configured_password_policy_rules"] = configured_password_policy_rules
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["dictionary_delimiter"] = dictionary_delimiter
        __props__.__dict__["dictionary_location"] = dictionary_location
        __props__.__dict__["dictionary_word_disallowed"] = dictionary_word_disallowed
        __props__.__dict__["disallowed_chars"] = disallowed_chars
        __props__.__dict__["disallowed_substrings"] = disallowed_substrings
        __props__.__dict__["disallowed_user_attribute_values"] = disallowed_user_attribute_values
        __props__.__dict__["distinct_characters"] = distinct_characters
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["first_name_disallowed"] = first_name_disallowed
        __props__.__dict__["force_password_reset"] = force_password_reset
        __props__.__dict__["groups"] = groups
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["last_name_disallowed"] = last_name_disallowed
        __props__.__dict__["lockout_duration"] = lockout_duration
        __props__.__dict__["max_incorrect_attempts"] = max_incorrect_attempts
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["max_repeated_chars"] = max_repeated_chars
        __props__.__dict__["max_special_chars"] = max_special_chars
        __props__.__dict__["metas"] = metas
        __props__.__dict__["min_alpha_numerals"] = min_alpha_numerals
        __props__.__dict__["min_alphas"] = min_alphas
        __props__.__dict__["min_length"] = min_length
        __props__.__dict__["min_lower_case"] = min_lower_case
        __props__.__dict__["min_numerals"] = min_numerals
        __props__.__dict__["min_password_age"] = min_password_age
        __props__.__dict__["min_special_chars"] = min_special_chars
        __props__.__dict__["min_unique_chars"] = min_unique_chars
        __props__.__dict__["min_upper_case"] = min_upper_case
        __props__.__dict__["name"] = name
        __props__.__dict__["num_passwords_in_history"] = num_passwords_in_history
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["password_expire_warning"] = password_expire_warning
        __props__.__dict__["password_expires_after"] = password_expires_after
        __props__.__dict__["password_strength"] = password_strength
        __props__.__dict__["priority"] = priority
        __props__.__dict__["required_chars"] = required_chars
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["starts_with_alphabet"] = starts_with_alphabet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["user_name_disallowed"] = user_name_disallowed
        return DomainsPasswordPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedChars")
    def allowed_chars(self) -> pulumi.Output[str]:
        """
        (Updatable) A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_chars")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="configuredPasswordPolicyRules")
    def configured_password_policy_rules(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyConfiguredPasswordPolicyRule']]:
        """
        (Updatable) List of password policy rules that have values set. This map of stringKey:stringValue pairs can be used to aid users while setting/resetting password

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [key]
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "configured_password_policy_rules")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A String that describes the password policy

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dictionaryDelimiter")
    def dictionary_delimiter(self) -> pulumi.Output[str]:
        """
        (Updatable) A delimiter used to separate characters in the dictionary file

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_delimiter")

    @property
    @pulumi.getter(name="dictionaryLocation")
    def dictionary_location(self) -> pulumi.Output[str]:
        """
        (Updatable) A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_location")

    @property
    @pulumi.getter(name="dictionaryWordDisallowed")
    def dictionary_word_disallowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the password can match a dictionary word

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "dictionary_word_disallowed")

    @property
    @pulumi.getter(name="disallowedChars")
    def disallowed_chars(self) -> pulumi.Output[str]:
        """
        (Updatable) A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_chars")

    @property
    @pulumi.getter(name="disallowedSubstrings")
    def disallowed_substrings(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_substrings")

    @property
    @pulumi.getter(name="disallowedUserAttributeValues")
    def disallowed_user_attribute_values(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of User attributes whose values are not allowed in the password.

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "disallowed_user_attribute_values")

    @property
    @pulumi.getter(name="distinctCharacters")
    def distinct_characters(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of distinct characters between old password and new password

        **Added In:** 2303212224

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "distinct_characters")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="firstNameDisallowed")
    def first_name_disallowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "first_name_disallowed")

    @property
    @pulumi.getter(name="forcePasswordReset")
    def force_password_reset(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "force_password_reset")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyGroup']]:
        """
        (Updatable) A list of groups that the password policy belongs to.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="lastNameDisallowed")
    def last_name_disallowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "last_name_disallowed")

    @property
    @pulumi.getter(name="lockoutDuration")
    def lockout_duration(self) -> pulumi.Output[int]:
        """
        (Updatable) The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "lockout_duration")

    @property
    @pulumi.getter(name="maxIncorrectAttempts")
    def max_incorrect_attempts(self) -> pulumi.Output[int]:
        """
        (Updatable) An integer that represents the maximum number of failed logins before an account is locked

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_incorrect_attempts")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[int]:
        """
        (Updatable) The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="maxRepeatedChars")
    def max_repeated_chars(self) -> pulumi.Output[int]:
        """
        (Updatable) The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_repeated_chars")

    @property
    @pulumi.getter(name="maxSpecialChars")
    def max_special_chars(self) -> pulumi.Output[int]:
        """
        (Updatable) The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "max_special_chars")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="minAlphaNumerals")
    def min_alpha_numerals(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alpha_numerals")

    @property
    @pulumi.getter(name="minAlphas")
    def min_alphas(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_alphas")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="minLowerCase")
    def min_lower_case(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_lower_case")

    @property
    @pulumi.getter(name="minNumerals")
    def min_numerals(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_numerals")

    @property
    @pulumi.getter(name="minPasswordAge")
    def min_password_age(self) -> pulumi.Output[int]:
        """
        (Updatable) Minimum time after which the user can resubmit the reset password request

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_password_age")

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_special_chars")

    @property
    @pulumi.getter(name="minUniqueChars")
    def min_unique_chars(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_unique_chars")

    @property
    @pulumi.getter(name="minUpperCase")
    def min_upper_case(self) -> pulumi.Output[int]:
        """
        (Updatable) The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "min_upper_case")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numPasswordsInHistory")
    def num_passwords_in_history(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of passwords that will be kept in history that may not be used as a password

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "num_passwords_in_history")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="passwordExpireWarning")
    def password_expire_warning(self) -> pulumi.Output[int]:
        """
        (Updatable) An integer indicating the number of days before which the user should be warned about password expiry.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expire_warning")

    @property
    @pulumi.getter(name="passwordExpiresAfter")
    def password_expires_after(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of days after which the password expires automatically

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "password_expires_after")

    @property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> pulumi.Output[str]:
        """
        (Updatable) Indicates whether the password policy is configured as Simple, Standard, or Custom.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password_strength")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        (Updatable) Password policy priority

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * idcsMinValue: 1
        * uniqueness: server
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="requiredChars")
    def required_chars(self) -> pulumi.Output[str]:
        """
        (Updatable) A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "required_chars")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="startsWithAlphabet")
    def starts_with_alphabet(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates that the password must begin with an alphabetic character

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "starts_with_alphabet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsPasswordPolicyTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="userNameDisallowed")
    def user_name_disallowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_name_disallowed")

