# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAgentInstallersResult',
    'AwaitableGetAgentInstallersResult',
    'get_agent_installers',
    'get_agent_installers_output',
]

@pulumi.output_type
class GetAgentInstallersResult:
    """
    A collection of values returned by getAgentInstallers.
    """
    def __init__(__self__, agent_installer_collections=None, compartment_id=None, filters=None, fleet_id=None, id=None, os_family=None, platform_architecture=None):
        if agent_installer_collections and not isinstance(agent_installer_collections, list):
            raise TypeError("Expected argument 'agent_installer_collections' to be a list")
        pulumi.set(__self__, "agent_installer_collections", agent_installer_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if platform_architecture and not isinstance(platform_architecture, str):
            raise TypeError("Expected argument 'platform_architecture' to be a str")
        pulumi.set(__self__, "platform_architecture", platform_architecture)

    @property
    @pulumi.getter(name="agentInstallerCollections")
    def agent_installer_collections(self) -> Sequence['outputs.GetAgentInstallersAgentInstallerCollectionResult']:
        """
        The list of agent_installer_collection.
        """
        return pulumi.get(self, "agent_installer_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAgentInstallersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[str]:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The target operating system family for the agent installer.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="platformArchitecture")
    def platform_architecture(self) -> Optional[str]:
        """
        The target operating system architecture for the installer.
        """
        return pulumi.get(self, "platform_architecture")


class AwaitableGetAgentInstallersResult(GetAgentInstallersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentInstallersResult(
            agent_installer_collections=self.agent_installer_collections,
            compartment_id=self.compartment_id,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            os_family=self.os_family,
            platform_architecture=self.platform_architecture)


def get_agent_installers(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetAgentInstallersFilterArgs', 'GetAgentInstallersFilterArgsDict']]] = None,
                         fleet_id: Optional[str] = None,
                         os_family: Optional[str] = None,
                         platform_architecture: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentInstallersResult:
    """
    This data source provides the list of Agent Installers in Oracle Cloud Infrastructure Jms service.

    Returns a list of the agent installer information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_installers = oci.Jms.get_agent_installers(compartment_id=compartment_id,
        fleet_id=test_fleet["id"],
        os_family=agent_installer_os_family,
        platform_architecture=agent_installer_platform_architecture)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str fleet_id: The ID of the Fleet.
    :param str os_family: The OS family for the agent installer.
    :param str platform_architecture: The platform architecture for the agent installer.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['osFamily'] = os_family
    __args__['platformArchitecture'] = platform_architecture
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getAgentInstallers:getAgentInstallers', __args__, opts=opts, typ=GetAgentInstallersResult).value

    return AwaitableGetAgentInstallersResult(
        agent_installer_collections=pulumi.get(__ret__, 'agent_installer_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        platform_architecture=pulumi.get(__ret__, 'platform_architecture'))
def get_agent_installers_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAgentInstallersFilterArgs', 'GetAgentInstallersFilterArgsDict']]]]] = None,
                                fleet_id: Optional[pulumi.Input[Optional[str]]] = None,
                                os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                platform_architecture: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentInstallersResult]:
    """
    This data source provides the list of Agent Installers in Oracle Cloud Infrastructure Jms service.

    Returns a list of the agent installer information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_installers = oci.Jms.get_agent_installers(compartment_id=compartment_id,
        fleet_id=test_fleet["id"],
        os_family=agent_installer_os_family,
        platform_architecture=agent_installer_platform_architecture)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str fleet_id: The ID of the Fleet.
    :param str os_family: The OS family for the agent installer.
    :param str platform_architecture: The platform architecture for the agent installer.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['osFamily'] = os_family
    __args__['platformArchitecture'] = platform_architecture
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getAgentInstallers:getAgentInstallers', __args__, opts=opts, typ=GetAgentInstallersResult)
    return __ret__.apply(lambda __response__: GetAgentInstallersResult(
        agent_installer_collections=pulumi.get(__response__, 'agent_installer_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        os_family=pulumi.get(__response__, 'os_family'),
        platform_architecture=pulumi.get(__response__, 'platform_architecture')))
