# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsageCarbonEmissionsQueryResult',
    'AwaitableGetUsageCarbonEmissionsQueryResult',
    'get_usage_carbon_emissions_query',
    'get_usage_carbon_emissions_query_output',
]

@pulumi.output_type
class GetUsageCarbonEmissionsQueryResult:
    """
    A collection of values returned by getUsageCarbonEmissionsQuery.
    """
    def __init__(__self__, compartment_id=None, id=None, query_definitions=None, usage_carbon_emissions_query_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query_definitions and not isinstance(query_definitions, list):
            raise TypeError("Expected argument 'query_definitions' to be a list")
        pulumi.set(__self__, "query_definitions", query_definitions)
        if usage_carbon_emissions_query_id and not isinstance(usage_carbon_emissions_query_id, str):
            raise TypeError("Expected argument 'usage_carbon_emissions_query_id' to be a str")
        pulumi.set(__self__, "usage_carbon_emissions_query_id", usage_carbon_emissions_query_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The query OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="queryDefinitions")
    def query_definitions(self) -> Sequence['outputs.GetUsageCarbonEmissionsQueryQueryDefinitionResult']:
        """
        The common fields for queries.
        """
        return pulumi.get(self, "query_definitions")

    @property
    @pulumi.getter(name="usageCarbonEmissionsQueryId")
    def usage_carbon_emissions_query_id(self) -> str:
        return pulumi.get(self, "usage_carbon_emissions_query_id")


class AwaitableGetUsageCarbonEmissionsQueryResult(GetUsageCarbonEmissionsQueryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsageCarbonEmissionsQueryResult(
            compartment_id=self.compartment_id,
            id=self.id,
            query_definitions=self.query_definitions,
            usage_carbon_emissions_query_id=self.usage_carbon_emissions_query_id)


def get_usage_carbon_emissions_query(usage_carbon_emissions_query_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsageCarbonEmissionsQueryResult:
    """
    This data source provides details about a specific Usage Carbon Emissions Query resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the usage carbon emissions saved query.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_query = oci.MeteringComputation.get_usage_carbon_emissions_query(usage_carbon_emissions_query_id=test_usage_carbon_emissions_query_oci_metering_computation_usage_carbon_emissions_query["id"])
    ```


    :param str usage_carbon_emissions_query_id: The query unique OCID.
    """
    __args__ = dict()
    __args__['usageCarbonEmissionsQueryId'] = usage_carbon_emissions_query_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getUsageCarbonEmissionsQuery:getUsageCarbonEmissionsQuery', __args__, opts=opts, typ=GetUsageCarbonEmissionsQueryResult).value

    return AwaitableGetUsageCarbonEmissionsQueryResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        query_definitions=pulumi.get(__ret__, 'query_definitions'),
        usage_carbon_emissions_query_id=pulumi.get(__ret__, 'usage_carbon_emissions_query_id'))
def get_usage_carbon_emissions_query_output(usage_carbon_emissions_query_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsageCarbonEmissionsQueryResult]:
    """
    This data source provides details about a specific Usage Carbon Emissions Query resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the usage carbon emissions saved query.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_query = oci.MeteringComputation.get_usage_carbon_emissions_query(usage_carbon_emissions_query_id=test_usage_carbon_emissions_query_oci_metering_computation_usage_carbon_emissions_query["id"])
    ```


    :param str usage_carbon_emissions_query_id: The query unique OCID.
    """
    __args__ = dict()
    __args__['usageCarbonEmissionsQueryId'] = usage_carbon_emissions_query_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MeteringComputation/getUsageCarbonEmissionsQuery:getUsageCarbonEmissionsQuery', __args__, opts=opts, typ=GetUsageCarbonEmissionsQueryResult)
    return __ret__.apply(lambda __response__: GetUsageCarbonEmissionsQueryResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        query_definitions=pulumi.get(__response__, 'query_definitions'),
        usage_carbon_emissions_query_id=pulumi.get(__response__, 'usage_carbon_emissions_query_id')))
