# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSupportedHostShapesResult',
    'AwaitableGetSupportedHostShapesResult',
    'get_supported_host_shapes',
    'get_supported_host_shapes_output',
]

@pulumi.output_type
class GetSupportedHostShapesResult:
    """
    A collection of values returned by getSupportedHostShapes.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, initial_host_shape_name=None, is_single_host_sddc_supported=None, items=None, name=None, sddc_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_host_shape_name and not isinstance(initial_host_shape_name, str):
            raise TypeError("Expected argument 'initial_host_shape_name' to be a str")
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if is_single_host_sddc_supported and not isinstance(is_single_host_sddc_supported, bool):
            raise TypeError("Expected argument 'is_single_host_sddc_supported' to be a bool")
        pulumi.set(__self__, "is_single_host_sddc_supported", is_single_host_sddc_supported)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sddc_type and not isinstance(sddc_type, str):
            raise TypeError("Expected argument 'sddc_type' to be a str")
        pulumi.set(__self__, "sddc_type", sddc_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSupportedHostShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[str]:
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="isSingleHostSddcSupported")
    def is_single_host_sddc_supported(self) -> Optional[bool]:
        """
        Indicates whether the shape supports single host SDDCs.
        """
        return pulumi.get(self, "is_single_host_sddc_supported")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSupportedHostShapesItemResult']:
        """
        A list of the supported compute shapes for ESXi hosts.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the supported compute shape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sddcType")
    @_utilities.deprecated("""The 'sddc_type' field has been deprecated. Please use 'is_single_host_sddc_supported' instead.""")
    def sddc_type(self) -> Optional[str]:
        return pulumi.get(self, "sddc_type")


class AwaitableGetSupportedHostShapesResult(GetSupportedHostShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSupportedHostShapesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            initial_host_shape_name=self.initial_host_shape_name,
            is_single_host_sddc_supported=self.is_single_host_sddc_supported,
            items=self.items,
            name=self.name,
            sddc_type=self.sddc_type)


def get_supported_host_shapes(compartment_id: Optional[str] = None,
                              filters: Optional[Sequence[Union['GetSupportedHostShapesFilterArgs', 'GetSupportedHostShapesFilterArgsDict']]] = None,
                              initial_host_shape_name: Optional[str] = None,
                              is_single_host_sddc_supported: Optional[bool] = None,
                              name: Optional[str] = None,
                              sddc_type: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSupportedHostShapesResult:
    """
    This data source provides the list of Supported Host Shapes in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported compute shapes for ESXi hosts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_host_shapes = oci.Ocvp.get_supported_host_shapes(compartment_id=compartment_id,
        initial_host_shape_name=test_shape["name"],
        is_single_host_sddc_supported=supported_host_shape_is_single_host_sddc_supported,
        name=supported_host_shape_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str initial_host_shape_name: A filter to return only the shapes compatible with the initial host shape of the Cluster.
    :param bool is_single_host_sddc_supported: A filter to return only resources that support single host SDDC.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str sddc_type: (Optional) A filter to return only resources that match the given SDDC type exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['initialHostShapeName'] = initial_host_shape_name
    __args__['isSingleHostSddcSupported'] = is_single_host_sddc_supported
    __args__['name'] = name
    __args__['sddcType'] = sddc_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getSupportedHostShapes:getSupportedHostShapes', __args__, opts=opts, typ=GetSupportedHostShapesResult).value

    return AwaitableGetSupportedHostShapesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        initial_host_shape_name=pulumi.get(__ret__, 'initial_host_shape_name'),
        is_single_host_sddc_supported=pulumi.get(__ret__, 'is_single_host_sddc_supported'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'),
        sddc_type=pulumi.get(__ret__, 'sddc_type'))
def get_supported_host_shapes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSupportedHostShapesFilterArgs', 'GetSupportedHostShapesFilterArgsDict']]]]] = None,
                                     initial_host_shape_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     is_single_host_sddc_supported: Optional[pulumi.Input[Optional[bool]]] = None,
                                     name: Optional[pulumi.Input[Optional[str]]] = None,
                                     sddc_type: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSupportedHostShapesResult]:
    """
    This data source provides the list of Supported Host Shapes in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported compute shapes for ESXi hosts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_host_shapes = oci.Ocvp.get_supported_host_shapes(compartment_id=compartment_id,
        initial_host_shape_name=test_shape["name"],
        is_single_host_sddc_supported=supported_host_shape_is_single_host_sddc_supported,
        name=supported_host_shape_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str initial_host_shape_name: A filter to return only the shapes compatible with the initial host shape of the Cluster.
    :param bool is_single_host_sddc_supported: A filter to return only resources that support single host SDDC.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str sddc_type: (Optional) A filter to return only resources that match the given SDDC type exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['initialHostShapeName'] = initial_host_shape_name
    __args__['isSingleHostSddcSupported'] = is_single_host_sddc_supported
    __args__['name'] = name
    __args__['sddcType'] = sddc_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ocvp/getSupportedHostShapes:getSupportedHostShapes', __args__, opts=opts, typ=GetSupportedHostShapesResult)
    return __ret__.apply(lambda __response__: GetSupportedHostShapesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        initial_host_shape_name=pulumi.get(__response__, 'initial_host_shape_name'),
        is_single_host_sddc_supported=pulumi.get(__response__, 'is_single_host_sddc_supported'),
        items=pulumi.get(__response__, 'items'),
        name=pulumi.get(__response__, 'name'),
        sddc_type=pulumi.get(__response__, 'sddc_type')))
