# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceGroupsResult',
    'AwaitableGetManagedInstanceGroupsResult',
    'get_managed_instance_groups',
    'get_managed_instance_groups_output',
]

@pulumi.output_type
class GetManagedInstanceGroupsResult:
    """
    A collection of values returned by getManagedInstanceGroups.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, is_managed_by_autonomous_linux=None, location_not_equal_tos=None, locations=None, managed_instance_group_collections=None, managed_instance_group_id=None, os_family=None, software_source_id=None, state=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if location_not_equal_tos and not isinstance(location_not_equal_tos, list):
            raise TypeError("Expected argument 'location_not_equal_tos' to be a list")
        pulumi.set(__self__, "location_not_equal_tos", location_not_equal_tos)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if managed_instance_group_collections and not isinstance(managed_instance_group_collections, list):
            raise TypeError("Expected argument 'managed_instance_group_collections' to be a list")
        pulumi.set(__self__, "managed_instance_group_collections", managed_instance_group_collections)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[str]:
        """
        The CPU architecture of the instances in the managed instance group.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[bool]:
        """
        Indicates whether the Autonomous Linux service manages the group.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="locationNotEqualTos")
    def location_not_equal_tos(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "location_not_equal_tos")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        The location of managed instances attached to the group.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="managedInstanceGroupCollections")
    def managed_instance_group_collections(self) -> Sequence['outputs.GetManagedInstanceGroupsManagedInstanceGroupCollectionResult']:
        """
        The list of managed_instance_group_collection.
        """
        return pulumi.get(self, "managed_instance_group_collections")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The operating system type of the instances in the managed instance group.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[str]:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the managed instance group.
        """
        return pulumi.get(self, "state")


class AwaitableGetManagedInstanceGroupsResult(GetManagedInstanceGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceGroupsResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            location_not_equal_tos=self.location_not_equal_tos,
            locations=self.locations,
            managed_instance_group_collections=self.managed_instance_group_collections,
            managed_instance_group_id=self.managed_instance_group_id,
            os_family=self.os_family,
            software_source_id=self.software_source_id,
            state=self.state)


def get_managed_instance_groups(arch_type: Optional[str] = None,
                                compartment_id: Optional[str] = None,
                                display_name_contains: Optional[str] = None,
                                display_names: Optional[Sequence[str]] = None,
                                filters: Optional[Sequence[Union['GetManagedInstanceGroupsFilterArgs', 'GetManagedInstanceGroupsFilterArgsDict']]] = None,
                                is_managed_by_autonomous_linux: Optional[bool] = None,
                                location_not_equal_tos: Optional[Sequence[str]] = None,
                                locations: Optional[Sequence[str]] = None,
                                managed_instance_group_id: Optional[str] = None,
                                os_family: Optional[str] = None,
                                software_source_id: Optional[str] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceGroupsResult:
    """
    This data source provides the list of Managed Instance Groups in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instance groups that match the specified compartment or managed instance group [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a variety of criteria including but not limited to name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_groups = oci.OsManagementHub.get_managed_instance_groups(arch_type=managed_instance_group_arch_type,
        compartment_id=compartment_id,
        display_names=managed_instance_group_display_name,
        display_name_contains=managed_instance_group_display_name_contains,
        is_managed_by_autonomous_linux=managed_instance_group_is_managed_by_autonomous_linux,
        locations=managed_instance_group_location,
        location_not_equal_tos=managed_instance_group_location_not_equal_to,
        managed_instance_group_id=test_managed_instance_group["id"],
        os_family=managed_instance_group_os_family,
        software_source_id=test_software_source["id"],
        state=managed_instance_group_state)
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group. This filter returns resources associated with this group.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param str state: A filter to return only managed instance groups that are in the specified state.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['osFamily'] = os_family
    __args__['softwareSourceId'] = software_source_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceGroups:getManagedInstanceGroups', __args__, opts=opts, typ=GetManagedInstanceGroupsResult).value

    return AwaitableGetManagedInstanceGroupsResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        location_not_equal_tos=pulumi.get(__ret__, 'location_not_equal_tos'),
        locations=pulumi.get(__ret__, 'locations'),
        managed_instance_group_collections=pulumi.get(__ret__, 'managed_instance_group_collections'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        state=pulumi.get(__ret__, 'state'))
def get_managed_instance_groups_output(arch_type: Optional[pulumi.Input[Optional[str]]] = None,
                                       compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                       display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedInstanceGroupsFilterArgs', 'GetManagedInstanceGroupsFilterArgsDict']]]]] = None,
                                       is_managed_by_autonomous_linux: Optional[pulumi.Input[Optional[bool]]] = None,
                                       location_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       locations: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       managed_instance_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                       software_source_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedInstanceGroupsResult]:
    """
    This data source provides the list of Managed Instance Groups in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instance groups that match the specified compartment or managed instance group [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a variety of criteria including but not limited to name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_groups = oci.OsManagementHub.get_managed_instance_groups(arch_type=managed_instance_group_arch_type,
        compartment_id=compartment_id,
        display_names=managed_instance_group_display_name,
        display_name_contains=managed_instance_group_display_name_contains,
        is_managed_by_autonomous_linux=managed_instance_group_is_managed_by_autonomous_linux,
        locations=managed_instance_group_location,
        location_not_equal_tos=managed_instance_group_location_not_equal_to,
        managed_instance_group_id=test_managed_instance_group["id"],
        os_family=managed_instance_group_os_family,
        software_source_id=test_software_source["id"],
        state=managed_instance_group_state)
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group. This filter returns resources associated with this group.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param str state: A filter to return only managed instance groups that are in the specified state.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['osFamily'] = os_family
    __args__['softwareSourceId'] = software_source_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagedInstanceGroups:getManagedInstanceGroups', __args__, opts=opts, typ=GetManagedInstanceGroupsResult)
    return __ret__.apply(lambda __response__: GetManagedInstanceGroupsResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        display_names=pulumi.get(__response__, 'display_names'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__response__, 'is_managed_by_autonomous_linux'),
        location_not_equal_tos=pulumi.get(__response__, 'location_not_equal_tos'),
        locations=pulumi.get(__response__, 'locations'),
        managed_instance_group_collections=pulumi.get(__response__, 'managed_instance_group_collections'),
        managed_instance_group_id=pulumi.get(__response__, 'managed_instance_group_id'),
        os_family=pulumi.get(__response__, 'os_family'),
        software_source_id=pulumi.get(__response__, 'software_source_id'),
        state=pulumi.get(__response__, 'state')))
