# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementStationsResult',
    'AwaitableGetManagementStationsResult',
    'get_management_stations',
    'get_management_stations_output',
]

@pulumi.output_type
class GetManagementStationsResult:
    """
    A collection of values returned by getManagementStations.
    """
    def __init__(__self__, compartment_id=None, display_name=None, display_name_contains=None, filters=None, id=None, managed_instance_id=None, management_station_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if management_station_collections and not isinstance(management_station_collections, list):
            raise TypeError("Expected argument 'management_station_collections' to be a list")
        pulumi.set(__self__, "management_station_collections", management_station_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the management station.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementStationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="managementStationCollections")
    def management_station_collections(self) -> Sequence['outputs.GetManagementStationsManagementStationCollectionResult']:
        """
        The list of management_station_collection.
        """
        return pulumi.get(self, "management_station_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the management station.
        """
        return pulumi.get(self, "state")


class AwaitableGetManagementStationsResult(GetManagementStationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementStationsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            management_station_collections=self.management_station_collections,
            state=self.state)


def get_management_stations(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            display_name_contains: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetManagementStationsFilterArgs', 'GetManagementStationsFilterArgsDict']]] = None,
                            id: Optional[str] = None,
                            managed_instance_id: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementStationsResult:
    """
    This data source provides the list of Management Stations in Oracle Cloud Infrastructure Os Management Hub service.

    Lists management stations in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_stations = oci.OsManagementHub.get_management_stations(compartment_id=compartment_id,
        display_name=management_station_display_name,
        display_name_contains=management_station_display_name_contains,
        id=management_station_id,
        managed_instance_id=test_managed_instance["id"],
        state=management_station_state)
    ```


    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station. A filter that returns information about the specified management station.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param str state: A filter that returns information for management stations in the specified state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagementStations:getManagementStations', __args__, opts=opts, typ=GetManagementStationsResult).value

    return AwaitableGetManagementStationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        management_station_collections=pulumi.get(__ret__, 'management_station_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_management_stations_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagementStationsFilterArgs', 'GetManagementStationsFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   managed_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementStationsResult]:
    """
    This data source provides the list of Management Stations in Oracle Cloud Infrastructure Os Management Hub service.

    Lists management stations in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_stations = oci.OsManagementHub.get_management_stations(compartment_id=compartment_id,
        display_name=management_station_display_name,
        display_name_contains=management_station_display_name_contains,
        id=management_station_id,
        managed_instance_id=test_managed_instance["id"],
        state=management_station_state)
    ```


    :param str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station. A filter that returns information about the specified management station.
    :param str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance. This filter returns resources associated with this managed instance.
    :param str state: A filter that returns information for management stations in the specified state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagementStations:getManagementStations', __args__, opts=opts, typ=GetManagementStationsResult)
    return __ret__.apply(lambda __response__: GetManagementStationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        management_station_collections=pulumi.get(__response__, 'management_station_collections'),
        state=pulumi.get(__response__, 'state')))
