# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWindowsUpdateResult',
    'AwaitableGetWindowsUpdateResult',
    'get_windows_update',
    'get_windows_update_output',
]

@pulumi.output_type
class GetWindowsUpdateResult:
    """
    A collection of values returned by getWindowsUpdate.
    """
    def __init__(__self__, description=None, id=None, installable=None, installation_requirements=None, is_reboot_required_for_installation=None, kb_article_ids=None, name=None, size_in_bytes=None, update_id=None, update_type=None, windows_update_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installable and not isinstance(installable, str):
            raise TypeError("Expected argument 'installable' to be a str")
        pulumi.set(__self__, "installable", installable)
        if installation_requirements and not isinstance(installation_requirements, list):
            raise TypeError("Expected argument 'installation_requirements' to be a list")
        pulumi.set(__self__, "installation_requirements", installation_requirements)
        if is_reboot_required_for_installation and not isinstance(is_reboot_required_for_installation, bool):
            raise TypeError("Expected argument 'is_reboot_required_for_installation' to be a bool")
        pulumi.set(__self__, "is_reboot_required_for_installation", is_reboot_required_for_installation)
        if kb_article_ids and not isinstance(kb_article_ids, list):
            raise TypeError("Expected argument 'kb_article_ids' to be a list")
        pulumi.set(__self__, "kb_article_ids", kb_article_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if size_in_bytes and not isinstance(size_in_bytes, str):
            raise TypeError("Expected argument 'size_in_bytes' to be a str")
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if update_id and not isinstance(update_id, str):
            raise TypeError("Expected argument 'update_id' to be a str")
        pulumi.set(__self__, "update_id", update_id)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if windows_update_id and not isinstance(windows_update_id, str):
            raise TypeError("Expected argument 'windows_update_id' to be a str")
        pulumi.set(__self__, "windows_update_id", windows_update_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the update.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def installable(self) -> str:
        """
        Indicates whether the update can be installed using the service.
        """
        return pulumi.get(self, "installable")

    @property
    @pulumi.getter(name="installationRequirements")
    def installation_requirements(self) -> Sequence[str]:
        """
        List of requirements for installing the update on the managed instance.
        """
        return pulumi.get(self, "installation_requirements")

    @property
    @pulumi.getter(name="isRebootRequiredForInstallation")
    def is_reboot_required_for_installation(self) -> bool:
        """
        Indicates whether a reboot is required to complete the installation of this update.
        """
        return pulumi.get(self, "is_reboot_required_for_installation")

    @property
    @pulumi.getter(name="kbArticleIds")
    def kb_article_ids(self) -> Sequence[str]:
        """
        List of the Microsoft Knowledge Base Article Ids related to this Windows Update.
        """
        return pulumi.get(self, "kb_article_ids")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Windows update.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        size of the package in bytes
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="updateId")
    def update_id(self) -> str:
        """
        Unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
        """
        return pulumi.get(self, "update_id")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> str:
        """
        The type of Windows update.
        """
        return pulumi.get(self, "update_type")

    @property
    @pulumi.getter(name="windowsUpdateId")
    def windows_update_id(self) -> str:
        return pulumi.get(self, "windows_update_id")


class AwaitableGetWindowsUpdateResult(GetWindowsUpdateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWindowsUpdateResult(
            description=self.description,
            id=self.id,
            installable=self.installable,
            installation_requirements=self.installation_requirements,
            is_reboot_required_for_installation=self.is_reboot_required_for_installation,
            kb_article_ids=self.kb_article_ids,
            name=self.name,
            size_in_bytes=self.size_in_bytes,
            update_id=self.update_id,
            update_type=self.update_type,
            windows_update_id=self.windows_update_id)


def get_windows_update(windows_update_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWindowsUpdateResult:
    """
    This data source provides details about a specific Windows Update resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns a Windows Update object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_windows_update = oci.OsManagementHub.get_windows_update(windows_update_id=test_windows_update_oci_os_management_hub_windows_update["id"])
    ```


    :param str windows_update_id: The unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    __args__ = dict()
    __args__['windowsUpdateId'] = windows_update_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getWindowsUpdate:getWindowsUpdate', __args__, opts=opts, typ=GetWindowsUpdateResult).value

    return AwaitableGetWindowsUpdateResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        installable=pulumi.get(__ret__, 'installable'),
        installation_requirements=pulumi.get(__ret__, 'installation_requirements'),
        is_reboot_required_for_installation=pulumi.get(__ret__, 'is_reboot_required_for_installation'),
        kb_article_ids=pulumi.get(__ret__, 'kb_article_ids'),
        name=pulumi.get(__ret__, 'name'),
        size_in_bytes=pulumi.get(__ret__, 'size_in_bytes'),
        update_id=pulumi.get(__ret__, 'update_id'),
        update_type=pulumi.get(__ret__, 'update_type'),
        windows_update_id=pulumi.get(__ret__, 'windows_update_id'))
def get_windows_update_output(windows_update_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWindowsUpdateResult]:
    """
    This data source provides details about a specific Windows Update resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns a Windows Update object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_windows_update = oci.OsManagementHub.get_windows_update(windows_update_id=test_windows_update_oci_os_management_hub_windows_update["id"])
    ```


    :param str windows_update_id: The unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    __args__ = dict()
    __args__['windowsUpdateId'] = windows_update_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getWindowsUpdate:getWindowsUpdate', __args__, opts=opts, typ=GetWindowsUpdateResult)
    return __ret__.apply(lambda __response__: GetWindowsUpdateResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        installable=pulumi.get(__response__, 'installable'),
        installation_requirements=pulumi.get(__response__, 'installation_requirements'),
        is_reboot_required_for_installation=pulumi.get(__response__, 'is_reboot_required_for_installation'),
        kb_article_ids=pulumi.get(__response__, 'kb_article_ids'),
        name=pulumi.get(__response__, 'name'),
        size_in_bytes=pulumi.get(__response__, 'size_in_bytes'),
        update_id=pulumi.get(__response__, 'update_id'),
        update_type=pulumi.get(__response__, 'update_type'),
        windows_update_id=pulumi.get(__response__, 'windows_update_id')))
