# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecoveryServiceSubnetsResult',
    'AwaitableGetRecoveryServiceSubnetsResult',
    'get_recovery_service_subnets',
    'get_recovery_service_subnets_output',
]

@pulumi.output_type
class GetRecoveryServiceSubnetsResult:
    """
    A collection of values returned by getRecoveryServiceSubnets.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, recovery_service_subnet_collections=None, state=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recovery_service_subnet_collections and not isinstance(recovery_service_subnet_collections, list):
            raise TypeError("Expected argument 'recovery_service_subnet_collections' to be a list")
        pulumi.set(__self__, "recovery_service_subnet_collections", recovery_service_subnet_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-provided name for the recovery service subnet.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecoveryServiceSubnetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recoveryServiceSubnetCollections")
    def recovery_service_subnet_collections(self) -> Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult']:
        """
        The list of recovery_service_subnet_collection.
        """
        return pulumi.get(self, "recovery_service_subnet_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the recovery service subnet.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        VCN Identifier.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetRecoveryServiceSubnetsResult(GetRecoveryServiceSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecoveryServiceSubnetsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            recovery_service_subnet_collections=self.recovery_service_subnet_collections,
            state=self.state,
            vcn_id=self.vcn_id)


def get_recovery_service_subnets(compartment_id: Optional[str] = None,
                                 display_name: Optional[str] = None,
                                 filters: Optional[Sequence[Union['GetRecoveryServiceSubnetsFilterArgs', 'GetRecoveryServiceSubnetsFilterArgsDict']]] = None,
                                 id: Optional[str] = None,
                                 state: Optional[str] = None,
                                 vcn_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecoveryServiceSubnetsResult:
    """
    This data source provides the list of Recovery Service Subnets in Oracle Cloud Infrastructure Recovery service.

    Returns a list of Recovery Service Subnets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recovery_service_subnets = oci.RecoveryMod.get_recovery_service_subnets(compartment_id=compartment_id,
        display_name=recovery_service_subnet_display_name,
        id=recovery_service_subnet_id,
        state=recovery_service_subnet_state,
        vcn_id=test_vcn["id"])
    ```


    :param str compartment_id: The compartment OCID.
    :param str display_name: A filter to return only resources that match the entire 'displayname' given.
    :param str id: The recovery service subnet OCID.
    :param str state: A filter to return only the resources that match the specified lifecycle state.
    :param str vcn_id: The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:RecoveryMod/getRecoveryServiceSubnets:getRecoveryServiceSubnets', __args__, opts=opts, typ=GetRecoveryServiceSubnetsResult).value

    return AwaitableGetRecoveryServiceSubnetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        recovery_service_subnet_collections=pulumi.get(__ret__, 'recovery_service_subnet_collections'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_recovery_service_subnets_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRecoveryServiceSubnetsFilterArgs', 'GetRecoveryServiceSubnetsFilterArgsDict']]]]] = None,
                                        id: Optional[pulumi.Input[Optional[str]]] = None,
                                        state: Optional[pulumi.Input[Optional[str]]] = None,
                                        vcn_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecoveryServiceSubnetsResult]:
    """
    This data source provides the list of Recovery Service Subnets in Oracle Cloud Infrastructure Recovery service.

    Returns a list of Recovery Service Subnets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_recovery_service_subnets = oci.RecoveryMod.get_recovery_service_subnets(compartment_id=compartment_id,
        display_name=recovery_service_subnet_display_name,
        id=recovery_service_subnet_id,
        state=recovery_service_subnet_state,
        vcn_id=test_vcn["id"])
    ```


    :param str compartment_id: The compartment OCID.
    :param str display_name: A filter to return only resources that match the entire 'displayname' given.
    :param str id: The recovery service subnet OCID.
    :param str state: A filter to return only the resources that match the specified lifecycle state.
    :param str vcn_id: The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:RecoveryMod/getRecoveryServiceSubnets:getRecoveryServiceSubnets', __args__, opts=opts, typ=GetRecoveryServiceSubnetsResult)
    return __ret__.apply(lambda __response__: GetRecoveryServiceSubnetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        recovery_service_subnet_collections=pulumi.get(__response__, 'recovery_service_subnet_collections'),
        state=pulumi.get(__response__, 'state'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
