# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProcessSetResult',
    'AwaitableGetProcessSetResult',
    'get_process_set',
    'get_process_set_output',
]

@pulumi.output_type
class GetProcessSetResult:
    """
    A collection of values returned by getProcessSet.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, process_set_id=None, revision=None, specifications=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if process_set_id and not isinstance(process_set_id, str):
            raise TypeError("Expected argument 'process_set_id' to be a str")
        pulumi.set(__self__, "process_set_id", process_set_id)
        if revision and not isinstance(revision, str):
            raise TypeError("Expected argument 'revision' to be a str")
        pulumi.set(__self__, "revision", revision)
        if specifications and not isinstance(specifications, list):
            raise TypeError("Expected argument 'specifications' to be a list")
        pulumi.set(__self__, "specifications", specifications)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the Process Set.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Process Set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="processSetId")
    def process_set_id(self) -> str:
        return pulumi.get(self, "process_set_id")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The current revision of the Process Set.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def specifications(self) -> Sequence['outputs.GetProcessSetSpecificationResult']:
        """
        Collection of regular expression specifications used to identify the processes to be monitored.
        """
        return pulumi.get(self, "specifications")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the process set was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the process set was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetProcessSetResult(GetProcessSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProcessSetResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            process_set_id=self.process_set_id,
            revision=self.revision,
            specifications=self.specifications,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_process_set(process_set_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProcessSetResult:
    """
    This data source provides details about a specific Process Set resource in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of a Process Set by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_process_set = oci.StackMonitoring.get_process_set(process_set_id=test_process_set_oci_stack_monitoring_process_set["id"])
    ```


    :param str process_set_id: The Process Set ID
    """
    __args__ = dict()
    __args__['processSetId'] = process_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getProcessSet:getProcessSet', __args__, opts=opts, typ=GetProcessSetResult).value

    return AwaitableGetProcessSetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        process_set_id=pulumi.get(__ret__, 'process_set_id'),
        revision=pulumi.get(__ret__, 'revision'),
        specifications=pulumi.get(__ret__, 'specifications'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_process_set_output(process_set_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProcessSetResult]:
    """
    This data source provides details about a specific Process Set resource in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of a Process Set by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_process_set = oci.StackMonitoring.get_process_set(process_set_id=test_process_set_oci_stack_monitoring_process_set["id"])
    ```


    :param str process_set_id: The Process Set ID
    """
    __args__ = dict()
    __args__['processSetId'] = process_set_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getProcessSet:getProcessSet', __args__, opts=opts, typ=GetProcessSetResult)
    return __ret__.apply(lambda __response__: GetProcessSetResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        process_set_id=pulumi.get(__response__, 'process_set_id'),
        revision=pulumi.get(__response__, 'revision'),
        specifications=pulumi.get(__response__, 'specifications'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
