iddtxt = """!IDD_Version 9.6.0
!IDD_BUILD f420c06a69
! **************************************************************************
! This file is the Input Data Dictionary (IDD) for EnergyPlus.
! The IDD defines the syntax and data model for each type of input "Object."
! Lines in EnergyPlus input files (and IDD) are limited to 500 characters.
!
!
! Note on IDD Processing/Usage
! ----------------------------
! The IDD is converted to the epJSON schema and compiled into the EnergyPlus exe.
! Any modification to this IDD will have no impact on EnergyPlus input processing
! without rebuilding the exe.  Only the IDF Editor and possibly other third-party
! tools read the IDD directly.
!
! Object Description
! ------------------
! To define an object (a record with data), develop a key word that is unique
! Each data item to the object can be A (Alphanumeric string) or N (numeric)
! Number each A and N. This will show how the data items will be put into the
! arrays that are passed to the Input Processor "Get" (GetObjectItem) routines.
! All alpha fields are limited to 100 characters. Numeric fields should be
! valid numerics (can include such as 1.0E+05) and are placed into double
! precision variables.
!
! NOTE: Even though a field may be optional, a comma representing that field
!   must be included (unless it is the last field in the object). Since the
!   entire input is "field-oriented" and not "keyword-oriented", the EnergyPlus
!   Input Processor must have some representation (even if blank) for each
!   field.
!
! Object Documentation
! --------------------
! In addition, the following special comments appear one per line and
! most are followed by a value. Comments may apply to a field or the object
! or a group of objects.
!
! Field-level comments:
!
!  \\field           Name of field
!                     (should be succinct and readable, blanks are encouraged)
!
!  \\note            Note describing the field and its valid values. If multiple lines,
!                   start each line with \\note. Limit line length to 100 characters.
!
!  \\required-field  To flag fields which must have a value. If the idf input is blank and
!                   there is a \\default, then the default will be used. However, as of v8.6.0
!                   the use of \\required-field and \\default on the same field is discouraged
!                   and instances with both have been changed.
!                     (this comment has no "value")
!
!  \\begin-extensible  Marks the first field at which the object accepts an extensible
!                   field set. A fixed number of fields from this marker define the
!                   extensible field set, see the object code \\extensible for
!                   more information.
!
!  \\units           Units (must be from EnergyPlus standard units list)
!                   EnergyPlus units are standard SI units
!
!  \\ip-units        IP-Units (for use by input processors with IP units)
!                   This is only used if the default conversion is not
!                   appropriate.
!
!  \\unitsBasedOnField  For fields that may have multiple possible units, indicates
!                   the field in the object that can be used to determine
!                   the units. The field reference is in the A2 form.
!
!  \\minimum         Minimum that includes the following value
!
!  \\minimum>        Minimum that must be > than the following value
!
!  \\maximum         Maximum that includes the following value
!
!  \\maximum<        Maximum that must be < than the following value
!
!  \\default         Default for the field (if N/A then omit entire line). If a default is
!                   added to an existing field, then \\required-field should be removed if present.
!                   Defaults are filled in only if the field is within \\min-fields, or the actual
!                   object is longer than this field.
!
!  \\deprecated      This field is not really used and will be deleted from the object.
!                   The required information is gotten internally or
!                   not needed by the program.
!
!  \\autosizable     Flag to indicate that this field can be used with the Auto
!                   Sizing routines to produce calculated results for the
!                   field. If a value follows this, then that will be used
!                   when the "Autosize" feature is flagged. To trigger
!                   autosizing for a field, enter Autosize as the field's
!                   value. Only applicable to numeric fields.
!
!  \\autocalculatable Flag to indicate that this field can be automatically
!                   calculated. To trigger auto calculation for a field, enter
!                   Autocalculate as the field's value. Only applicable to
!                   numeric fields.
!
!  \\type            Type of data for the field -
!                     integer
!                     real
!                     alpha       (arbitrary string),
!                     choice      (alpha with specific list of choices, see
!                                 \\key)
!                     object-list (link to a list of objects defined elsewhere,
!                                  see \\object-list and \\reference)
!                     external-list (uses a special list from an external source,
!                                    see \\external-list)
!                     node        (name used in connecting HVAC components)
!
!  \\retaincase      Retains the alphabetic case for alpha type fields
!
!  \\key             Possible value for "\\type choice" (blanks are significant)
!                     use multiple \\key lines to indicate all valid choices
!
!  \\object-list     Name of a list of user-provided object names that are valid
!                     entries for this field (used with "\\reference")
!                     see Zone and BuildingSurface:Detailed objects below for
!                     examples.
!                  ** Note that a field may have multiple \\object-list commands.
!
!  \\external-list   The values for this field should be selected from a special
!                   list generated outside of the IDD file. The choices for the
!                   special lists are:
!                        autoRDDvariable
!                        autoRDDmeter
!                        autoRDDvariableMeter
!                   When one of these are selected the options for the field
!                   are taken from the RDD or MDD file or both.
!
!  \\reference       Name of a list of names to which this object belongs
!                     used with "\\type object-list" and with "\\object-list"
!                     see Zone and BuildingSurface:Detailed objects below for
!                     examples:
!
!                        Zone,
!                          A1 , \\field Name
!                               \\type alpha
!                               \\reference ZoneNames
!
!                        BuildingSurface:Detailed,
!                          A4 , \\field Zone Name
!                               \\note Zone the surface is a part of
!                               \\type object-list
!                               \\object-list ZoneNames
!
!             For each zone, the field "Name" may be referenced
!             by other objects, such as BuildingSurface:Detailed, so it is
!             commented with "\\reference ZoneNames"
!             Fields that reference a zone name, such as BuildingSurface:Detailed's
!             "Zone Name", are commented as
!             "\\type object-list" and "\\object-list ZoneNames"
!             ** Note that a field may have multiple \\reference commands.
!             ** This is useful if the object belongs to a small specific
!             object-list as well as a larger more general object-list.
!
! Object-level comments:
!
!  \\memo            Memo describing the object. If multiple lines, start each line
!                   with \\memo.
!                   Limit line length to 100 characters.
!
!  \\unique-object   To flag objects which should appear only once in an idf
!                     (this comment has no "value")
!
!  \\required-object To flag objects which are required in every idf
!                     (this comment has no "value")
!
!  \\min-fields      Minimum number of fields that should be included in the
!                   object. If appropriate, the Input Processor will fill
!                   any missing fields with defaults (for numeric fields).
!                   It will also supply that number of fields to the "get"
!                   routines using blanks for alpha fields (note -- blanks
!                   may not be allowable for some alpha fields).
!
!  \\obsolete        This object has been replaced though is kept (and is read)
!                   in the current version. Please refer to documentation as
!                   to the dispersal of the object. If this object is
!                   encountered in an IDF, the InputProcessor will post an
!                   appropriate message to the error file.
!                   usage:  \\obsolete New=>[New object name]
!
!  \\extensible:<#>  This object is dynamically extensible -- meaning the input
!                   object may be extended beyond the number of fields shown in
!                   the IDD.  <#> signifies the size of the extensible field set.
!                   The first field of the first instance of the extensible field
!                   set is marked with \\begin-extensible.  EnergyPlus will accept
!                   an extensible object of any length as long as the extended
!                   fields match the extensible field set size.  Note that the
!                   classic windows IDF Editor limits objects to the number of
!                   fields specified in the IDD. Editing the IDD enables IDF
!                   Editor to read longer objects.  In the epJSON schema, each
!                   extensible group is a named array. See Energy+.schema.epJSON
!
!  \\begin-extensible See previous item, marks beginning of extensible fields in
!                   an object.
!
!  \\format          The object should have a special format when saved in
!                   the IDF Editor with the special format option enabled.
!                   The options include SingleLine, Vertices, CompactSchedule,
!                   FluidProperties, ViewFactors, and Spectral.
!                   The SingleLine option puts all the fields for the object
!                   on a single line. The Vertices option is used in objects
!                   that use X, Y and Z fields to format those three fields
!                   on a single line.
!                   The CompactSchedule formats that specific object.
!                   The FluidProperty option formats long lists of fluid
!                   properties to ten values per line.
!                   The ViewFactor option formats three fields related to
!                   view factors per line.
!                   The Spectral option formats the four fields related to
!                   window glass spectral data per line.
!
!   \\reference-class-name Adds the name of the class to the reference list
!                   similar to \\reference.
!
! Group-level comments:
!
!  \\group          Name for a group of related objects
!
!
! Notes on comments
! -----------------
!
! 1. If a particular comment is not applicable (such as units, or default)
! then simply omit the comment rather than indicating N/A.
!
! 2. Memos and notes should be brief (recommend 5 lines or less per block).
! More extensive explanations are expected to be in the user documentation
!
! Default IP conversions (no \\ip-units necessary)
!      $/(m3/s)               =>   $/(ft3/min)         0.000472000059660808
!      $/(W/K)                =>   $/(Btu/h-F)         0.52667614683731
!      $/kW                   =>   $/(kBtuh/h)         0.293083235638921
!      $/m2                   =>   $/ft2               0.0928939733269818
!      $/m3                   =>   $/ft3               0.0283127014102352
!      (kg/s)/W               =>   (lbm/sec)/(Btu/hr)  0.646078115385742
!      1/K                    =>   1/F                 0.555555555555556
!      1/m                    =>   1/ft                0.3048
!      A/K                    =>   A/F                 0.555555555555556
!      C                      =>   F                   1.8 (plus 32)
!      cm                     =>   in                  0.3937
!      cm2                    =>   inch2               0.15500031000062
!      deltaC                 =>   deltaF              1.8
!      deltaC/hr              =>   deltaF/hr           1.8
!      deltaJ/kg              =>   deltaBtu/lb         0.0004299
!      g/GJ                   =>   lb/MWh              0.00793664091373665
!      g/kg                   =>   grains/lb           7
!      g/MJ                   =>   lb/MWh              7.93664091373665
!      g/mol                  =>   lb/mol              0.0022046
!      g/m-s                  =>   lb/ft-s             0.000671968949659
!      g/m-s-K                =>   lb/ft-s-F           0.000373574867724868
!      GJ                     =>   ton-hrs             78.9889415481832
!      J                      =>   Wh                  0.000277777777777778
!      J/K                    =>   Btu/F               526.565
!      J/kg                   =>   Btu/lb              0.00042986 (plus 7.686)
!      J/kg-K                 =>   Btu/lb-F            0.000239005736137667
!      J/kg-K2                =>   Btu/lb-F2           0.000132889924714692
!      J/kg-K3                =>   Btu/lb-F3           7.38277359526066E-05
!      J/m2-K                 =>   Btu/ft2-F           4.89224766847393E-05
!      J/m3                   =>   Btu/ft3             2.68096514745308E-05
!      J/m3-K                 =>   Btu/ft3-F           1.49237004739337E-05
!      K                      =>   R                   1.8
!      K/m                    =>   F/ft                0.54861322767449
!      kg                     =>   lb                  2.2046
!      kg/J                   =>   lb/Btu              2325.83774250441
!      kg/kg-K                =>   lb/lb-F             0.555555555555556
!      kg/m                   =>   lb/ft               0.67196893069637
!      kg/m2                  =>   lb/ft2              0.204794053596664
!      kg/m3                  =>   lb/ft3              0.062428
!      kg/m-s                 =>   lb/ft-s             0.67196893069637
!      kg/m-s-K               =>   lb/ft-s-F           0.373316072609094
!      kg/m-s-K2              =>   lb/ft-s-F2          0.207397818116164
!      kg/Pa-s-m2             =>   lb/psi-s-ft2        1412.00523459398
!      kg/s                   =>   lb/s                2.20462247603796
!      kg/s2                  =>   lb/s2               2.2046
!      kg/s-m                 =>   lb/s-ft             0.67196893069637
!      kJ/kg                  =>   Btu/lb              0.429925
!      kPa                    =>   psi                 0.145038
!      L/day                  =>   pint/day            2.11337629827348
!      L/GJ                   =>   gal/kWh             0.000951022349025202
!      L/kWh                  =>   pint/kWh            2.11337629827348
!      L/MJ                   =>   gal/kWh             0.951022349025202
!      lux                    =>   foot-candles        0.092902267
!      m                      =>   ft                  3.28083989501312
!      m/hr                   =>   ft/hr               3.28083989501312
!      m/s                    =>   ft/min              196.850393700787
!      m/s                    =>   miles/hr            2.2369362920544
!      m/yr                   =>   inch/yr             39.3700787401575
!      m2                     =>   ft2                 10.7639104167097
!      m2/m                   =>   ft2/ft              3.28083989501312
!      m2/person              =>   ft2/person          10.764961
!      m2/s                   =>   ft2/s               10.7639104167097
!      m2-K/W                 =>   ft2-F-hr/Btu        5.678263
!      m3                     =>   ft3                 35.3146667214886
!      m3                     =>   gal                 264.172037284185
!      m3/GJ                  =>   ft3/MWh             127.13292
!      m3/hr                  =>   ft3/hr              35.3146667214886
!      m3/hr-m2               =>   ft3/hr-ft2          3.28083989501312
!      m3/hr-person           =>   ft3/hr-person       35.3146667214886
!      m3/kg                  =>   ft3/lb              16.018
!      m3/m2                  =>   ft3/ft2             3.28083989501312
!      m3/MJ                  =>   ft3/kWh             127.13292
!      m3/person              =>   ft3/person          35.3146667214886
!      m3/s                   =>   ft3/min             2118.88000328931
!      m3/s-m                 =>   ft3/min-ft          645.89
!      m3/s-m2                =>   ft3/min-ft2         196.85
!      m3/s-person            =>   ft3/min-person      2118.6438
!      m3/s-W                 =>   (ft3/min)/(Btu/h)   621.099127332943
!      N-m                    =>   lbf-in              8.85074900525547
!      N-s/m2                 =>   lbf-s/ft2           0.0208857913669065
!      Pa                     =>   psi                 0.000145037743897283
!      percent/K              =>   percent/F           0.555555555555556
!      person/m2              =>   person/ft2          0.0928939733269818
!      s/m                    =>   s/ft                0.3048
!      V/K                    =>   V/F                 0.555555555555556
!      W                      =>   Btu/h               3.4121412858518
!      W/((m3/s)-Pa)          =>   W/((gal/min)-ftH20) 0.188582274697355
!      W/((m3/s)-Pa)          =>   W/((ft3/min)-inH2O) 0.117556910599482
!      W/(m3/s)               =>   W/(ft3/min)         0.0004719475
!      W/K                    =>   Btu/h-F             1.89563404769544
!      W/m                    =>   Btu/h-ft            1.04072
!      W/m2                   =>   Btu/h-ft2           0.316957210776545
!      W/m2                   =>   W/ft2               0.09290304
!      W/m2-K                 =>   Btu/h-ft2-F         0.176110194261872
!      W/m2-K2                =>   Btu/h-ft2-F2        0.097826
!      W/m-K                  =>   Btu-in/h-ft2-F      6.93481276005548
!      W/m-K2                 =>   Btu/h-F2-ft         0.321418310071648
!      W/m-K3                 =>   Btu/h-F3-ft         0.178565727817582
!      W/person               =>   Btu/h-person        3.4121412858518
!
! Other conversions supported (needs the \\ip-units code)
!
!      kPa                    =>   inHg                0.29523
!      m                      =>   in                  39.3700787401575
!      m3/hr                  =>   gal/hr              264.172037284185
!      m3/hr-m2               =>   gal/hr-ft2          24.5423853466941
!      m3/hr-person           =>   gal/hr-person       264.172037284185
!      m3/m2                  =>   gal/ft2             24.5423853466941
!      m3/person              =>   gal/person          264.172037284185
!      m3/s                   =>   gal/min             15850.3222370511
!      m3/s-m                 =>   gal/min-ft          4831.17821785317
!      m3/s-W                 =>   (gal/min)/(Btu/h)   4645.27137336702
!      Pa                     =>   ftH2O               0.00033455
!      Pa                     =>   inH2O               0.00401463
!      Pa                     =>   inHg                0.00029613
!      Pa                     =>   Pa                  1
!      W                      =>   W                   1
!      W/(m3/s)               =>   W/(gal/min)         0.0000630902
!      W/m2                   =>   W/m2                1
!      W/m-K                  =>   Btu/h-ft-F          0.577796066000163
!      W/person               =>   W/person            1
!
! Units fields that are not translated
!      $
!      1/hr
!      A
!      A/V
!      Ah
!      Availability
!      Control
!      cycles/hr
!      days
!      deg
!      dimensionless
!      eV
!      hh:mm
!      hr
!      J/J
!      kg/kg
!      kgWater/kgDryAir
!      kmol
!      kmol/s
!      m3/m3
!      micron
!      minutes
!      Mode
!      ms
!      ohms
!      percent
!      ppm
!      rev/min
!      s
!      V
!      VA
!      W/m2 or deg C
!      W/m2, W or deg C
!      W/s
!      W/W
!      years
! **************************************************************************

\\group Simulation Parameters

Version,
      \\memo Specifies the EnergyPlus version of the IDF file.
      \\unique-object
      \\format singleLine
  A1 ; \\field Version Identifier
      \\default 9.6

SimulationControl,
      \\unique-object
      \\memo Note that the following 3 fields are related to the Sizing:Zone, Sizing:System,
      \\memo and Sizing:Plant objects. Having these fields set to Yes but no corresponding
      \\memo Sizing object will not cause the sizing to be done. However, having any of these
      \\memo fields set to No, the corresponding Sizing object is ignored.
      \\memo Note also, if you want to do system sizing, you must also do zone sizing in the same
      \\memo run or an error will result.
      \\min-fields 7
  A1, \\field Do Zone Sizing Calculation
      \\note If Yes, Zone sizing is accomplished from corresponding Sizing:Zone objects
      \\note and autosize fields.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A2, \\field Do System Sizing Calculation
      \\note If Yes, System sizing is accomplished from corresponding Sizing:System objects
      \\note and autosize fields.
      \\note If Yes, Zone sizing (previous field) must also be Yes.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A3, \\field Do Plant Sizing Calculation
      \\note If Yes, Plant sizing is accomplished from corresponding Sizing:Plant objects
      \\note and autosize fields.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A4, \\field Run Simulation for Sizing Periods
      \\note If Yes, SizingPeriod:* objects are executed and results from those may be displayed..
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A5, \\field Run Simulation for Weather File Run Periods
      \\note If Yes, RunPeriod:* objects are executed and results from those may be displayed..
      \\type choice
      \\key Yes
      \\key No
      \\default Yes
  A6, \\field Do HVAC Sizing Simulation for Sizing Periods
      \\note If Yes, SizingPeriod:* objects are exectuted additional times for advanced sizing.
      \\note Currently limited to use with coincident plant sizing, see Sizing:Plant object
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N1; \\field Maximum Number of HVAC Sizing Simulation Passes
      \\note the entire set of SizingPeriod:* objects may be repeated to fine tune size results
      \\note this input sets a limit on the number of passes that the sizing algorithms can repeate the set
      \\type integer
      \\minimum 1
      \\default 1

PerformancePrecisionTradeoffs,
      \\unique-object
      \\memo This object enables users to choose certain options that speed up EnergyPlus simulation,
      \\memo but may lead to small decreases in accuracy of results.
  A1, \\field Use Coil Direct Solutions
      \\note If Yes, an analytical or empirical solution will be used to replace iterations in
      \\note the coil performance calculations.
      \\type choice
      \\key Yes
      \\key No
      \\default No
  A2, \\field Zone Radiant Exchange Algorithm
      \\note Determines which algorithm will be used to solve long wave radiant exchange among surfaces within a zone.
      \\type choice
      \\key ScriptF
      \\key CarrollMRT
      \\default ScriptF
  A3, \\field Override Mode
      \\note The increasing mode number roughly correspond with increased speed. A description of each mode
      \\note are shown in the documentation. When Advanced is selected the N1 field value is used.
      \\type choice
      \\key Normal
      \\key Mode01
      \\key Mode02
      \\key Mode03
      \\key Mode04
      \\key Mode05
      \\key Mode06
      \\key Mode07
      \\key Mode08
      \\key Advanced
      \\default Normal
  N1, \\field MaxZoneTempDiff
      \\note Maximum zone temperature change before HVAC timestep is shortened.
      \\note Only used when Override Mode is set to Advanced
      \\type real
      \\minimum 0.1
      \\maximum 3.0
      \\default 0.3
  N2, \\field MaxAllowedDelTemp
      \\note Maximum surface temperature change before HVAC timestep is shortened.
      \\note Only used when Override Mode is set to Advanced
      \\type real
      \\minimum 0.002
      \\maximum 0.1
      \\default 0.002
  A4; \\field Use Representative Surfaces for Calculations
      \\note Automatically group surfaces with similar characteristics and perform relevant calculations only once for each group.
      \\type choice
      \\key Yes
      \\key No
      \\default No

Building,
       \\memo Describes parameters that are used during the simulation
       \\memo of the building. There are necessary correlations between the entries for
       \\memo this object and some entries in the Site:WeatherStation and
       \\memo Site:HeightVariation objects, specifically the Terrain field.
       \\unique-object
       \\required-object
       \\min-fields 8
  A1 , \\field Name
       \\retaincase
       \\default NONE
  N1 , \\field North Axis
       \\note degrees from true North
       \\units deg
       \\type real
       \\default 0.0
  A2 , \\field Terrain
       \\note  Country=FlatOpenCountry | Suburbs=CountryTownsSuburbs | City=CityCenter | Ocean=body of water (5km) | Urban=Urban-Industrial-Forest
       \\type choice
       \\key Country
       \\key Suburbs
       \\key City
       \\key Ocean
       \\key Urban
       \\default Suburbs
  N2 , \\field Loads Convergence Tolerance Value
       \\note Loads Convergence Tolerance Value is a change in load from one warmup day to the next
       \\type real
       \\minimum> 0.0
       \\maximum .5
       \\default .04
       \\units W
  N3 , \\field Temperature Convergence Tolerance Value
       \\units deltaC
       \\type real
       \\minimum> 0.0
       \\maximum .5
       \\default .4
  A3 , \\field Solar Distribution
       \\note  MinimalShadowing | FullExterior | FullInteriorAndExterior | FullExteriorWithReflections | FullInteriorAndExteriorWithReflections
       \\type choice
       \\key MinimalShadowing
       \\key FullExterior
       \\key FullInteriorAndExterior
       \\key FullExteriorWithReflections
       \\key FullInteriorAndExteriorWithReflections
       \\default FullExterior
  N4 , \\field Maximum Number of Warmup Days
       \\note EnergyPlus will only use as many warmup days as needed to reach convergence tolerance.
       \\note This field's value should NOT be set less than 25.
       \\type integer
       \\minimum> 0
       \\default 25
  N5 ; \\field Minimum Number of Warmup Days
       \\note The minimum number of warmup days that produce enough temperature and flux history
       \\note to start EnergyPlus simulation for all reference buildings was suggested to be 6.
       \\note However this can lead to excessive run times as warmup days can be repeated needlessly.
       \\note For faster execution rely on the convergence criteria to detect when warmup is complete.
       \\note When this field is greater than the maximum warmup days defined previous field
       \\note the maximum number of warmup days will be reset to the minimum value entered here.
       \\note Warmup days will be set to be the value you entered. The default is 1.
       \\type integer
       \\minimum> 0
       \\default 1

ShadowCalculation,
       \\unique-object
       \\memo This object is used to control details of the solar, shading, and daylighting models
       \\extensible:1
  A1 , \\field Shading Calculation Method
       \\note Select between CPU-based polygon clipping method, the GPU-based pixel counting method,
       \\note or importing from external shading data.
       \\note If PixelCounting is selected and GPU hardware (or GPU emulation) is not available, a warning will be
       \\note displayed and EnergyPlus will revert to PolygonClipping.
       \\note If Scheduled is chosen, the External Shading Fraction Schedule Name is required
       \\note in SurfaceProperty:LocalEnvironment.
       \\note If Imported is chosen, the Schedule:File:Shading object is required.
       \\type choice
       \\key PolygonClipping
       \\key PixelCounting
       \\key Scheduled
       \\key Imported
       \\default PolygonClipping
  A2 , \\field Shading Calculation Update Frequency Method
       \\note choose calculation frequency method. note that Timestep is only needed for certain cases
       \\note and can increase execution time significantly.
       \\type choice
       \\key Periodic
       \\key Timestep
       \\default Periodic
  N1 , \\field Shading Calculation Update Frequency
       \\type integer
       \\minimum 1
       \\default 20
       \\note enter number of days
       \\note this field is only used if the previous field is set to Periodic
       \\note warning issued if >31
  N2 , \\field Maximum Figures in Shadow Overlap Calculations
       \\note Number of allowable figures in shadow overlap in PolygonClipping calculations
       \\type integer
       \\minimum 200
       \\default 15000
  A3 , \\field Polygon Clipping Algorithm
       \\note Advanced Feature. Internal default is SutherlandHodgman
       \\note Refer to InputOutput Reference and Engineering Reference for more information
       \\type choice
       \\key ConvexWeilerAtherton
       \\key SutherlandHodgman
       \\key SlaterBarskyandSutherlandHodgman
       \\default SutherlandHodgman
  N3 , \\field Pixel Counting Resolution
       \\note Number of pixels in both dimensions of the surface rendering
       \\type integer
       \\default 512
  A4 , \\field Sky Diffuse Modeling Algorithm
       \\note Advanced Feature. Internal default is SimpleSkyDiffuseModeling
       \\note If you have shading elements that change transmittance over the
       \\note year, you may wish to choose the detailed method.
       \\note Refer to InputOutput Reference and Engineering Reference for more information
       \\type choice
       \\key SimpleSkyDiffuseModeling
       \\key DetailedSkyDiffuseModeling
       \\default SimpleSkyDiffuseModeling
  A5 , \\field Output External Shading Calculation Results
       \\type choice
       \\key Yes
       \\key No
       \\default No
       \\note If Yes is chosen, the calculated external shading fraction results will be saved to an external CSV file with surface names as the column headers.
  A6 , \\field Disable Self-Shading Within Shading Zone Groups
       \\note If Yes, self-shading will be disabled from all exterior surfaces in a given Shading Zone Group to surfaces within
       \\note the same Shading Zone Group.
       \\note If both Disable Self-Shading Within Shading Zone Groups and Disable Self-Shading From Shading Zone Groups to Other Zones = Yes,
       \\note then all self-shading from exterior surfaces will be disabled.
       \\note If only one of these fields = Yes, then at least one Shading Zone Group must be specified, or this field will be ignored.
       \\note Shading from Shading:* surfaces, overhangs, fins, and reveals will not be disabled.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A7 , \\field Disable Self-Shading From Shading Zone Groups to Other Zones
       \\note If Yes, self-shading will be disabled from all exterior surfaces in a given Shading Zone Group to all other zones in the model.
       \\note If both Disable Self-Shading Within Shading Zone Groups and Disable Self-Shading From Shading Zone Groups to Other Zones = Yes,
       \\note then all self-shading from exterior surfaces will be disabled.
       \\note If only one of these fields = Yes, then at least one Shading Zone Group must be specified, or this field will be ignored.
       \\note Shading from Shading:* surfaces, overhangs, fins, and reveals will not be disabled.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A8 , \\field Shading Zone Group 1 ZoneList Name
       \\note Specifies a group of zones which are controlled by the Disable Self-Shading fields.
       \\type object-list
       \\object-list ZoneListNames
       \\begin-extensible
  A9 , \\field Shading Zone Group 2 ZoneList Name
       \\type object-list
       \\object-list ZoneListNames
  A10, \\field Shading Zone Group 3 ZoneList Name
       \\type object-list
       \\object-list ZoneListNames
  A11, \\field Shading Zone Group 4 ZoneList Name
       \\type object-list
       \\object-list ZoneListNames
  A12, \\field Shading Zone Group 5 ZoneList Name
       \\type object-list
       \\object-list ZoneListNames
  A13; \\field Shading Zone Group 6 ZoneList Name
       \\type object-list
       \\object-list ZoneListNames

SurfaceConvectionAlgorithm:Inside,
       \\memo Default indoor surface heat transfer convection algorithm to be used for all zones
       \\unique-object
       \\format singleLine
  A1 ; \\field Algorithm
       \\type choice
       \\key Simple
       \\key TARP
       \\key CeilingDiffuser
       \\key AdaptiveConvectionAlgorithm
       \\key ASTMC1340
       \\default TARP
       \\note Simple = constant value natural convection (ASHRAE)
       \\note TARP = variable natural convection based on temperature difference (ASHRAE, Walton)
       \\note CeilingDiffuser = ACH-based forced and mixed convection correlations
       \\note  for ceiling diffuser configuration with simple natural convection limit
       \\note AdaptiveConvectionAlgorithm = dynamic selection of convection models based on conditions
       \\note ASTMC1340 = mixed convection correlations based on heat flow direction,
       \\note  surface tilt angle, surface characteristic length, and air speed past the surface.

SurfaceConvectionAlgorithm:Outside,
       \\memo Default outside surface heat transfer convection algorithm to be used for all zones
       \\unique-object
       \\format singleLine
  A1 ; \\field Algorithm
       \\type choice
       \\key SimpleCombined
       \\key TARP
       \\key MoWiTT
       \\key DOE-2
       \\key AdaptiveConvectionAlgorithm
       \\default DOE-2
       \\note SimpleCombined = Combined radiation and convection coefficient using simple ASHRAE model
       \\note TARP = correlation from models developed by ASHRAE, Walton, and Sparrow et. al.
       \\note MoWiTT = correlation from measurements by Klems and Yazdanian for smooth surfaces
       \\note DOE-2 = correlation from measurements by Klems and Yazdanian for rough surfaces
       \\note AdaptiveConvectionAlgorithm = dynamic selection of correlations based on conditions

HeatBalanceAlgorithm,
       \\memo Determines which Heat Balance Algorithm will be used ie.
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: ConductionFiniteDifferenceSimplified
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\unique-object
       \\format singleLine
  A1 , \\field Algorithm
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  N1 , \\field Surface Temperature Upper Limit
       \\type real
       \\minimum 200
       \\default 200
       \\units C
  N2 , \\field Minimum Surface Convection Heat Transfer Coefficient Value
       \\units W/m2-K
       \\default 0.1
       \\minimum> 0.0
  N3 ; \\field Maximum Surface Convection Heat Transfer Coefficient Value
       \\units W/m2-K
       \\default 1000
       \\minimum 1.0

HeatBalanceSettings:ConductionFiniteDifference,
       \\memo Determines settings for the Conduction Finite Difference
       \\memo algorithm for surface heat transfer modeling.
       \\unique-object
  A1 , \\field Difference Scheme
       \\type choice
       \\key CrankNicholsonSecondOrder
       \\key FullyImplicitFirstOrder
       \\default FullyImplicitFirstOrder
  N1 , \\field Space Discretization Constant
       \\note increase or decrease number of nodes
       \\type real
       \\default 3
  N2 , \\field Relaxation Factor
       \\type real
       \\default 1.0
       \\minimum 0.01
       \\maximum 1.0
  N3 ; \\field Inside Face Surface Temperature Convergence Criteria
       \\type real
       \\default 0.002
       \\minimum 1.0E-7
       \\maximum 0.01

ZoneAirHeatBalanceAlgorithm,
       \\memo Determines which algorithm will be used to solve the zone air heat balance.
       \\unique-object
       \\format singleLine
       \\min-fields 1
  A1 ; \\field Algorithm
       \\type choice
       \\key ThirdOrderBackwardDifference
       \\key AnalyticalSolution
       \\key EulerMethod
       \\default ThirdOrderBackwardDifference

ZoneAirContaminantBalance,
       \\memo Determines which contaminant concentration will be simulates.
       \\unique-object
       \\format singleLine
  A1 , \\field Carbon Dioxide Concentration
       \\note If Yes, CO2 simulation will be performed.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A2 , \\field Outdoor Carbon Dioxide Schedule Name
       \\note Schedule values should be in parts per million (ppm)
       \\type object-list
       \\object-list ScheduleNames
  A3 , \\field Generic Contaminant Concentration
       \\note If Yes, generic contaminant simulation will be performed.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A4 ; \\field Outdoor Generic Contaminant Schedule Name
       \\note Schedule values should be generic contaminant concentration in parts per
       \\note million (ppm)
       \\type object-list
       \\object-list ScheduleNames

ZoneAirMassFlowConservation,
       \\memo Enforces the zone air mass flow balance by either adjusting zone mixing object flow only,
       \\memo adjusting zone total return flow only, zone mixing and the zone total return flows,
       \\memo or adjusting the zone total return and zone mixing object flows. Zone infiltration flow air
       \\memo flow is increased or decreased depending user selection in the infiltration treatment method.
       \\memo If either of zone mixing or zone return flow adjusting methods or infiltration is active,
       \\memo then the zone air mass flow balance calculation will attempt to enforce conservation of
       \\memo mass for each zone. If flow balancing method is "None" and infiltration is "None", then the
       \\memo zone air mass flow calculation defaults to assume self-balanced simple flow mixing and
       \\memo infiltration objects.
       \\unique-object
       \\min-fields 3
  A1,  \\field Adjust Zone Mixing and Return For Air Mass Flow Balance
       \\note If "AdjustMixingOnly", zone mixing object flow rates are adjusted to balance the zone air mass
       \\note flow and zone infiltration air flow may be increased or decreased if required in order to balance
       \\note the zone air mass flow. If "AdjustReturnOnly", zone total return flow rate is adjusted to balance
       \\note the zone air mass flow and zone infiltration air flow may be increased or decreased if required
       \\note in order to balance the zone air mass flow. If "AdjustMixingThenReturn", first the zone mixing
       \\note objects flow rates are adjusted to balance the zone air flow, second zone total return flow rate
       \\note is adjusted and zone infiltration air flow may be increased or decreased if required in order to
       \\note balance the zone air mass flow. If "AdjustReturnThenMixing", first zone total return flow rate is
       \\note adjusted to balance the zone air flow, second the zone mixing object flow rates are adjusted and
       \\note infiltration air flow may be increased or decreased if required in order to balance the zone
       \\note air mass flow.
       \\type choice
       \\key AdjustMixingOnly
       \\key AdjustReturnOnly
       \\key AdjustMixingThenReturn
       \\key AdjustReturnThenMixing
       \\key None
       \\default None
  A2,  \\field Infiltration Balancing Method
       \\note This input field allows user to choose how zone infiltration flow is treated during
       \\note the zone air mass flow balance calculation.
       \\type choice
       \\key AddInfiltrationFlow
       \\key AdjustInfiltrationFlow
       \\key None
       \\default AddInfiltrationFlow
       \\note AddInfiltrationFlow may add infiltration to the base flow specified in the
       \\note infiltration object to balance the zone air mass flow. The additional infiltration
       \\note air mass flow is not self-balanced. The base flow is assumed to be self-balanced.
       \\note AdjustInfiltrationFlow may adjust the base flow calculated using
       \\note the base flow specified in the infiltration object to balance the zone air mass flow. If it
       \\note If no adjustment is required, then the base infiltration is assumed to be self-balanced.
       \\note None will make no changes to the base infiltration flow.
  A3;  \\field Infiltration Balancing Zones
       \\note This input field allows user to choose which zones are included in infiltration balancing.
       \\note MixingSourceZonesOnly allows infiltration balancing only in zones which as source zones for mixing
       \\note which also have an infiltration object defined.
       \\note AllZones allows infiltration balancing in any zone which has an infiltration object defined.
       \\type choice
       \\key MixingSourceZonesOnly
       \\key AllZones
       \\default MixingSourceZonesOnly

ZoneCapacitanceMultiplier:ResearchSpecial,
       \\format singleLine
       \\memo Multiplier altering the relative capacitance of the air compared to an empty zone
       \\min-fields 6
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList Name
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\note If this field is left blank, the multipliers are applied to all the zones not specified
  N1 , \\field Temperature Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to heat or temperature
  N2 , \\field Humidity Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to moisture or humidity ratio
  N3 , \\field Carbon Dioxide Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to zone air carbon dioxide concentration
  N4 ; \\field Generic Contaminant Capacity Multiplier
       \\type real
       \\default 1.0
       \\minimum> 0.0
       \\note Used to alter the capacitance of zone air with respect to zone air generic contaminant concentration

Timestep,
       \\memo Specifies the "basic" timestep for the simulation. The
       \\memo value entered here is also known as the Zone Timestep. This is used in
       \\memo the Zone Heat Balance Model calculation as the driving timestep for heat
       \\memo transfer and load calculations.
       \\unique-object
       \\format singleLine
  N1 ; \\field Number of Timesteps per Hour
       \\note Number in hour: normal validity 4 to 60: 6 suggested
       \\note Must be evenly divisible into 60
       \\note Allowable values include 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, and 60
       \\note Normal 6 is minimum as lower values may cause inaccuracies
       \\note A minimum value of 20 is suggested for both ConductionFiniteDifference
       \\note and CombinedHeatAndMoistureFiniteElement surface heat balance algorithms
       \\note A minimum of 12 is suggested for simulations involving a Vegetated Roof (Material:RoofVegetation).
       \\default 6
       \\type integer
       \\minimum 1
       \\maximum 60

ConvergenceLimits,
       \\memo Specifies limits on HVAC system simulation timesteps and iterations.
       \\memo This item is an advanced feature that should be used only with caution.
       \\unique-object
  N1 , \\field Minimum System Timestep
       \\units minutes
       \\type integer
       \\note 0 sets the minimum to the zone timestep (ref: Timestep)
       \\note 1 is normal (ratchet down to 1 minute)
       \\note setting greater than zone timestep (in minutes) will effectively set to zone timestep
       \\minimum 0
       \\maximum 60
  N2 , \\field Maximum HVAC Iterations
       \\type integer
       \\default 20
       \\minimum 1
  N3 , \\field Minimum Plant Iterations
       \\note Controls the minimum number of plant system solver iterations within a single HVAC iteration
       \\note Larger values will increase runtime but might improve solution accuracy for complicated plant systems
       \\note Complex plants include: several interconnected loops, heat recovery, thermal load following generators, etc.
       \\type integer
       \\default 2
       \\minimum 1
  N4 ; \\field Maximum Plant Iterations
       \\note Controls the maximum number of plant system solver iterations within a single HVAC iteration
       \\note Smaller values might decrease runtime but could decrease solution accuracy for complicated plant systems
       \\type integer
       \\default 8
       \\minimum 2

HVACSystemRootFindingAlgorithm,
       \\memo Specifies a HVAC system solver algorithm to find a root
       \\unique-object
  A1 , \\field Algorithm
       \\type choice
       \\key RegulaFalsi
       \\key Bisection
       \\key BisectionThenRegulaFalsi
       \\key RegulaFalsiThenBisection
       \\key Alternation
       \\default RegulaFalsi
  N1 ; \\field Number of Iterations Before Algorithm Switch
       \\note This field is used when RegulaFalsiThenBisection or BisectionThenRegulaFalsi is
       \\note entered. When iteration number is greater than the value, algorithm switches.
       \\type integer
       \\default 5

\\group Compliance Objects

Compliance:Building,
       \\memo Building level inputs related to compliance to building standards, building codes, and beyond energy code programs.
       \\unique-object
       \\min-fields 1
  N1;  \\field Building Rotation for Appendix G
       \\note Additional degrees of rotation to be used with the requirement in ASHRAE Standard 90.1 Appendix G
       \\note that states that the baseline building should be rotated in four directions.
       \\units deg
       \\type real
       \\default 0.0

\\group Location and Climate

Site:Location,
       \\memo Specifies the building's location. Only one location is allowed.
       \\memo Weather data file location, if it exists, will override this object.
       \\unique-object
       \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type alpha
  N1 , \\field Latitude
       \\units deg
       \\minimum -90.0
       \\maximum +90.0
       \\default 0.0
       \\note + is North, - is South, degree minutes represented in decimal (i.e. 30 minutes is .5)
       \\type real
  N2 , \\field Longitude
       \\units deg
       \\minimum -180.0
       \\maximum +180.0
       \\default 0.0
       \\note - is West, + is East, degree minutes represented in decimal (i.e. 30 minutes is .5)
       \\type real
  N3 , \\field Time Zone
       \\note basic these limits on the WorldTimeZone Map (2003)
       \\units hr
       \\minimum -12.0
       \\maximum +14.0
       \\default 0.0
       \\note  Time relative to GMT. Decimal hours.
       \\type real
  N4 ; \\field Elevation
       \\units m
       \\minimum -300.0
       \\maximum< 8900.0
       \\default 0.0
       \\type real

Site:VariableLocation,
       \\memo Captures the scheduling of a moving/reorienting building, or more likely a vessel
       \\unique-object
       \\min-fields 1
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Building Location Latitude Schedule
       \\note The name of a schedule that defines the latitude of the building at any time.
       \\note If not entered, the latitude defined in the Site:Location, or the default
       \\note latitude, will be used for the entirety of the simulation
       \\type object-list
       \\object-list ScheduleNames
  A3 , \\field Building Location Longitude Schedule
       \\note The name of a schedule that defines the longitude of the building at any time.
       \\note If not entered, the longitude defined in the Site:Location, or the default
       \\note longitude, will be used for the entirety of the simulation
       \\type object-list
       \\object-list ScheduleNames
  A4 ; \\field Building Location Orientation Schedule
       \\note The name of a schedule that defines the orientation of the building at any time.
       \\note This orientation is based on a change from the original orientation. -- NEED TO REFINE THIS
       \\note If not entered, the original orientation will be used for the entirety of the simulation
       \\type object-list
       \\object-list ScheduleNames

SizingPeriod:DesignDay,
      \\memo The design day object creates the parameters for the program to create
      \\memo the 24 hour weather profile that can be used for sizing as well as
      \\memo running to test the other simulation parameters. Parameters in this
      \\memo include a date (month and day), a day type (which uses the appropriate
      \\memo schedules for either sizing or simple tests), min/max temperatures,
      \\memo wind speeds, and solar radiation values.
  A1, \\field Name
       \\type alpha
       \\required-field
       \\reference RunPeriodsAndDesignDays
  N1,  \\field Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2,  \\field Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
       \\note must be valid for Month field
  A2,  \\field Day Type
       \\required-field
       \\note Day Type selects the schedules appropriate for this design day
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  N3,  \\field Maximum Dry-Bulb Temperature
       \\note This field is required when field "Dry-Bulb Temperature Range Modifier Type"
       \\note is not "TemperatureProfileSchedule".
       \\units C
       \\minimum -90
       \\maximum 70
       \\type real
  N4,  \\field Daily Dry-Bulb Temperature Range
       \\note Must still produce appropriate maximum dry-bulb (within range)
       \\note This field is not needed if Dry-Bulb Temperature Range Modifier Type
       \\note is "delta".
       \\units deltaC
       \\minimum 0
       \\default 0
       \\type real
  A3,  \\field Dry-Bulb Temperature Range Modifier Type
       \\note Type of modifier to the dry-bulb temperature calculated for the timestep
       \\type choice
       \\key MultiplierSchedule
       \\key DifferenceSchedule
       \\key TemperatureProfileSchedule
       \\key DefaultMultipliers
       \\default DefaultMultipliers
  A4,  \\field Dry-Bulb Temperature Range Modifier Day Schedule Name
       \\type object-list
       \\object-list DayScheduleNames
       \\note Only used when previous field is "MultiplierSchedule", "DifferenceSchedule" or
       \\note   "TemperatureProfileSchedule".
       \\note For type "MultiplierSchedule"  the hour/time interval values should specify
       \\note   the fraction (0-1) of the dry-bulb temperature range to be subtracted
       \\note   from the maximum dry-bulb temperature for each timestep in the day
       \\note For type "DifferenceSchedule" the values should specify a number to be subtracted
       \\note   from the maximum dry-bulb temperature for each timestep in the day.
       \\note Note that numbers in the difference schedule cannot be negative as that
       \\note   would result in a higher maximum than the maximum previously specified.
       \\note For type "TemperatureProfileSchedule" the values should specify the actual dry-bulb
       \\note   temperature for each timestep in the day.
  A5,  \\field Humidity Condition Type
       \\note values/schedules indicated here and in subsequent fields create the humidity
       \\note values in the 24 hour design day conditions profile.
       \\type choice
       \\key WetBulb
       \\key DewPoint
       \\key HumidityRatio
       \\key Enthalpy
       \\key RelativeHumiditySchedule
       \\key WetBulbProfileMultiplierSchedule
       \\key WetBulbProfileDifferenceSchedule
       \\key WetBulbProfileDefaultMultipliers
       \\default WetBulb
  N5,  \\field Wetbulb or DewPoint at Maximum Dry-Bulb
       \\note Wetbulb or dewpoint temperature coincident with the maximum temperature.
       \\note Required only if field Humidity Condition Type is "Wetbulb", "Dewpoint",
       \\note "WetBulbProfileMultiplierSchedule", "WetBulbProfileDifferenceSchedule",
       \\note or "WetBulbProfileDefaultMultipliers"
       \\type real
       \\units C
  A6,  \\field Humidity Condition Day Schedule Name
       \\type object-list
       \\object-list DayScheduleNames
       \\note Only used when Humidity Condition Type is "RelativeHumiditySchedule",
       \\note  "WetBulbProfileMultiplierSchedule", or "WetBulbProfileDifferenceSchedule"
       \\note For type "RelativeHumiditySchedule", the hour/time interval values should specify
       \\note   relative humidity (percent) from 0.0 to 100.0.
       \\note For type "WetBulbProfileMultiplierSchedule" the hour/time interval values should specify
       \\note   the fraction (0-1) of the wet-bulb temperature range to be subtracted from the
       \\note   maximum wet-bulb temperature for each timestep in the day (units = Fraction)
       \\note For type "WetBulbProfileDifferenceSchedule" the values should specify a number to be subtracted
       \\note   from the maximum wet-bulb temperature for each timestep in the day. (units = deltaC)
  N6,  \\field Humidity Ratio at Maximum Dry-Bulb
       \\note Humidity ratio coincident with the maximum temperature (constant humidity ratio throughout day).
       \\note Required only if field Humidity Condition Type is "HumidityRatio".
       \\type real
       \\units kgWater/kgDryAir
  N7,  \\field Enthalpy at Maximum Dry-Bulb
       \\note Enthalpy coincident with the maximum temperature.
       \\note Required only if field Humidity Condition Type is "Enthalpy".
       \\type real
       \\units J/kg
  N8,  \\field Daily Wet-Bulb Temperature Range
       \\units deltaC
       \\note Required only if Humidity Condition Type = "WetbulbProfileMultiplierSchedule" or
       \\note "WetBulbProfileDefaultMultipliers"
  N9,  \\field Barometric Pressure
       \\note This field's value is also checked against the calculated "standard barometric pressure"
       \\note for the location. If out of range (>10%) or blank, then is replaced by standard value.
       \\units Pa
       \\minimum 31000
       \\maximum 120000
       \\type real
       \\ip-units inHg
  N10, \\field Wind Speed
       \\required-field
       \\units m/s
       \\minimum 0
       \\maximum 40
       \\ip-units miles/hr
       \\type real
  N11, \\field Wind Direction
       \\required-field
       \\units deg
       \\minimum 0
       \\maximum 360
       \\note North=0.0 East=90.0
       \\note 0 and 360 are the same direction.
       \\type real
  A7,  \\field Rain Indicator
       \\note Yes is raining (all day), No is not raining
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A8,  \\field Snow Indicator
       \\type choice
       \\key Yes
       \\key No
       \\default No
       \\note Yes is Snow on Ground, No is no Snow on Ground
  A9,  \\field Daylight Saving Time Indicator
       \\note Yes -- use schedules modified for Daylight Saving Time Schedules.
       \\note No - do not use schedules modified for Daylight Saving Time Schedules
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A10, \\field Solar Model Indicator
       \\type choice
       \\key ASHRAEClearSky
       \\key ZhangHuang
       \\key Schedule
       \\key ASHRAETau
       \\key ASHRAETau2017
       \\default ASHRAEClearSky
  A11, \\field Beam Solar Day Schedule Name
       \\note if Solar Model Indicator = Schedule, then beam schedule name (for day)
       \\type object-list
       \\object-list DayScheduleNames
  A12, \\field Diffuse Solar Day Schedule Name
       \\note if Solar Model Indicator = Schedule, then diffuse schedule name (for day)
       \\type object-list
       \\object-list DayScheduleNames
  N12, \\field ASHRAE Clear Sky Optical Depth for Beam Irradiance (taub)
       \\units dimensionless
       \\note Required if Solar Model Indicator = ASHRAETau or ASHRAETau2017
       \\note ASHRAETau2017 solar model can be used with 2013 and 2017 HOF matching taub
       \\minimum 0
       \\maximum 1.2
       \\default 0
  N13, \\field ASHRAE Clear Sky Optical Depth for Diffuse Irradiance (taud)
       \\units dimensionless
       \\note Required if Solar Model Indicator = ASHRAETau or ASHRAETau2017
       \\note ASHRAETau2017 solar model can be used with 2013 and 2017 HOF matching taud
       \\minimum 0
       \\maximum 3
       \\default 0
  N14, \\field Sky Clearness
       \\note Used if Sky Model Indicator = ASHRAEClearSky or ZhangHuang
       \\minimum 0.0
       \\maximum 1.2
       \\default 0.0
       \\note 0.0 is totally unclear, 1.0 is totally clear
       \\type real
  N15, \\field Maximum Number Warmup Days
       \\note If used this design day will be run with a custom limit on the maximum number of days that are repeated for warmup.
       \\note Limiting the number of warmup days can improve run time.
       \\type integer
  A13; \\field Begin Environment Reset Mode
       \\note If used this can control if you want the thermal history to be reset at the beginning of the design day.
       \\note When using a series of similiar design days, this field can be used to retain warmup state from the previous design day.
       \\type choice
       \\key FullResetAtBeginEnvironment
       \\key SuppressAllBeginEnvironmentResets
       \\default FullResetAtBeginEnvironment

SizingPeriod:WeatherFileDays,
       \\memo Use a weather file period for design sizing calculations.
  A1 , \\field Name
       \\reference RunPeriodsAndDesignDays
       \\required-field
       \\note user supplied name for reporting
  N1 , \\field Begin Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2 , \\field Begin Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N3 , \\field End Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N4 , \\field End Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  A2 , \\field Day of Week for Start Day
       \\note  =[|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|SummerDesignDay|WinterDesignDay|
       \\note    |CustomDay1|CustomDay2];
       \\note if you use SummerDesignDay or WinterDesignDay or the CustomDays then this will apply
       \\note to the whole period; other days (i.e., Monday) will signify a start day and
       \\note normal sequence of subsequent days
       \\default Monday
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A3,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4;  \\field Use Weather File Rain and Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

SizingPeriod:WeatherFileConditionType,
       \\memo Use a weather file period for design sizing calculations.
       \\memo EPW weather files are created with typical and extreme periods
       \\memo created heuristically from the weather file data. For more
       \\memo details on these periods, see AuxiliaryPrograms document.
  A1 , \\field Name
       \\required-field
       \\reference RunPeriodsAndDesignDays
       \\note user supplied name for reporting
  A2 , \\field Period Selection
       \\required-field
       \\retaincase
       \\note Following is a list of all possible types of Extreme and Typical periods that
       \\note might be identified in the Weather File. Not all possible types are available
       \\note for all weather files.
       \\type choice
       \\key SummerExtreme
       \\key SummerTypical
       \\key WinterExtreme
       \\key WinterTypical
       \\key AutumnTypical
       \\key SpringTypical
       \\key WetSeason
       \\key DrySeason
       \\key NoDrySeason
       \\key NoWetSeason
       \\key TropicalHot
       \\key TropicalCold
       \\key NoDrySeasonMax
       \\key NoDrySeasonMin
       \\key NoWetSeasonMax
       \\key NoWetSeasonMin
  A3 , \\field Day of Week for Start Day
       \\note  =[|Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|SummerDesignDay|WinterDesignDay|
       \\note    |CustomDay1|CustomDay2];
       \\note if you use SummerDesignDay or WinterDesignDay or the CustomDays then this will apply
       \\note to the whole period; other days (i.e., Monday) will signify a start day and
       \\note normal sequence of subsequent days
       \\default Monday
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A4,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A5;  \\field Use Weather File Rain and Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

RunPeriod,
       \\memo Specify a range of dates and other parameters for a simulation.
       \\memo Multiple run periods may be input, but they may not overlap.
       \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\reference RunPeriodsAndDesignDays
       \\note descriptive name (used in reporting mainly)
       \\note Cannot be not blank and must be unique
  N1 , \\field Begin Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N2 , \\field Begin Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N3,  \\field Begin Year
       \\note Start year of the simulation, if this field is specified it must agree with the Day of Week for Start Day
       \\note If this field is blank, the year will be selected to match the weekday, which is Sunday if not specified
  N4 , \\field End Month
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N5 , \\field End Day of Month
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N6,  \\field End Year
       \\note end year of simulation, if specified
  A2 , \\field Day of Week for Start Day
       \\note =[Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday];
       \\note If no year is input, this field will default to Sunday
       \\note If a year is input and this field is blank, the correct weekday is determined
       \\type choice
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
  A3,  \\field Use Weather File Holidays and Special Days
       \\note If yes or blank, use holidays as specified on Weatherfile.
       \\note If no, do not use the holidays specified on the Weatherfile.
       \\note Note: You can still specify holidays/special days using the RunPeriodControl:SpecialDays object(s).
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4,  \\field Use Weather File Daylight Saving Period
       \\note If yes or blank, use daylight saving period as specified on Weatherfile.
       \\note If no, do not use the daylight saving period as specified on the Weatherfile.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A5,  \\field Apply Weekend Holiday Rule
       \\note if yes and single day holiday falls on weekend, "holiday" occurs on following Monday
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A6,  \\field Use Weather File Rain Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  A7,  \\field Use Weather File Snow Indicators
       \\type choice
       \\key Yes
       \\key No
       \\default Yes
  A8,  \\field Treat Weather as Actual
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A9; \\field First Hour Interpolation Starting Values
       \\note When the weather data timestep is longer than the simulation timestep, weather data is interpolated. For the first hour of the
       \\note simulation, this field specifies which values from the first day of the run period to use as the interpolation starting point.
       \\note This same interpolation will be used for repeated warmup days.
       \\type choice
       \\key Hour1
       \\key Hour24
       \\default Hour24

RunPeriodControl:SpecialDays,
     \\min-fields 4
     \\memo This object sets up holidays/special days to be used during weather file
     \\memo run periods. (These are not used with SizingPeriod:* objects.)
     \\memo Depending on the value in the run period, days on the weather file may also
     \\memo be used. However, the weather file specification will take precedence over
     \\memo any specification shown here. (No error message on duplicate days or overlapping
     \\memo days).
 A1, \\field Name
     \\required-field
 A2, \\field Start Date
     \\required-field
     \\note  Dates can be several formats:
     \\note  <number>/<number>  (month/day)
     \\note  <number> <Month>
     \\note  <Month> <number>
     \\note <Nth> <Weekday> in <Month)
     \\note Last <WeekDay> in <Month>
     \\note <Month> can be January, February, March, April, May, June, July, August, September, October, November, December
     \\note Months can be the first 3 letters of the month
     \\note <Weekday> can be Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday
     \\note <Nth> can be 1 or 1st, 2 or 2nd, etc. up to 5(?)
 N1, \\field Duration
     \\units days
     \\minimum 1
     \\maximum 366
     \\default 1
 A3; \\field Special Day Type
       \\note Special Day Type selects the schedules appropriate for each day so labeled
       \\type choice
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
       \\default Holiday

RunPeriodControl:DaylightSavingTime,
     \\unique-object
     \\min-fields 2
     \\memo This object sets up the daylight saving time period for any RunPeriod.
     \\memo Ignores any daylight saving time period on the weather file and uses this definition.
     \\memo These are not used with SizingPeriod:DesignDay objects.
     \\memo Use with SizingPeriod:WeatherFileDays object can be controlled in that object.
 A1, \\field Start Date
     \\required-field
 A2; \\field End Date
     \\required-field
     \\note  Dates can be several formats:
     \\note  <number>/<number>  (month/day)
     \\note  <number> <Month>
     \\note  <Month> <number>
     \\note <Nth> <Weekday> in <Month)
     \\note Last <WeekDay> in <Month>
     \\note <Month> can be January, February, March, April, May, June, July, August, September, October, November, December
     \\note Months can be the first 3 letters of the month
     \\note <Weekday> can be Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday
     \\note <Nth> can be 1 or 1st, 2 or 2nd, etc. up to 5(?)

WeatherProperty:SkyTemperature,
       \\memo This object is used to override internal sky temperature calculations.
  A1,  \\field Name
       \\note blank in this field will apply to all run periods (that is, all objects=
       \\note SizingPeriod:WeatherFileDays, SizingPeriod:WeatherFileConditionType or RunPeriod
       \\note otherwise, this name must match one of the environment object names.
       \\type object-list
       \\object-list RunPeriodsAndDesignDays
  A2,  \\field Calculation Type
       \\required-field
       \\note The field indicates that the sky temperature will be imported from external schedules or calculated by alternative methods other than default.
       \\type choice
       \\key ClarkAllen
       \\key Brunt
       \\key Idso
       \\key BerdahlMartin
       \\key ScheduleValue
       \\key DifferenceScheduleDryBulbValue
       \\key DifferenceScheduleDewPointValue
       \\default ClarkAllen
  A3,  \\field Schedule Name
       \\note if name matches a SizingPeriod:DesignDay, put in a day schedule of this name
       \\note if name is for a SizingPeriod:WeatherFileDays, SizingPeriod:WeatherFileConditionType or
       \\note RunPeriod, put in a full year schedule that covers the appropriate days.
       \\note Required if Calculation Type is ScheduleValue, DifferenceScheduleDryBulbValue or DifferenceScheduleDewPointValue.
       \\type object-list
       \\object-list DayScheduleNames
       \\object-list ScheduleNames
  A4; \\field Use Weather File Horizontal IR
       \\note If yes or blank, use Horizontal IR values from weather file when present, otherwise use the specified sky model.
       \\note If no, always use the specified sky model and ignore the horizontal IR values from the weather file.
       \\note For Calculation Type = ScheduleValue, DifferenceScheduleDryBulbValue or DifferenceScheduleDewPointValue, this field is ignored and the scheduled values are used.
       \\type choice
       \\default Yes
       \\key Yes
       \\key No

Site:WeatherStation,
       \\unique-object
       \\memo This object should only be used for non-standard weather data. Standard weather data
       \\memo such as TMY2, IWEC, and ASHRAE design day data are all measured at the
       \\memo default conditions and do not require this object.
  N1 , \\field Wind Sensor Height Above Ground
       \\type real
       \\units m
       \\default 10.0
       \\minimum> 0.0
  N2 , \\field Wind Speed Profile Exponent
       \\type real
       \\default 0.14
       \\minimum 0.0
  N3 , \\field Wind Speed Profile Boundary Layer Thickness
       \\type real
       \\units m
       \\default 270.0
       \\minimum 0.0
  N4 ; \\field Air Temperature Sensor Height Above Ground
       \\type real
       \\units m
       \\default 1.5
       \\minimum 0.0

Site:HeightVariation,
       \\unique-object
       \\memo This object is used if the user requires advanced control over height-dependent
       \\memo variations in wind speed and temperature. When this object is not present, the default model
       \\memo for temperature dependence on height is used, and the wind speed is modeled according
       \\memo to the Terrain field of the BUILDING object.
  N1 , \\field Wind Speed Profile Exponent
       \\note Set to zero for no wind speed dependence on height.
       \\type real
       \\default 0.22
       \\minimum 0.0
  N2 , \\field Wind Speed Profile Boundary Layer Thickness
       \\type real
       \\units m
       \\default 370.0
       \\minimum> 0.0
  N3 ; \\field Air Temperature Gradient Coefficient
       \\note Set to zero for no air temperature dependence on height.
       \\type real
       \\units K/m
       \\default 0.0065
       \\minimum 0.0

Site:GroundTemperature:BuildingSurface,
       \\memo These temperatures are specifically for those surfaces that have the outside environment
       \\memo of "Ground". Documentation about what values these should be is located in the
       \\memo Auxiliary programs document (Ground Heat Transfer) as well as the InputOutput Reference.
       \\memo CAUTION - Do not use the "undisturbed" ground temperatures from the weather data.
       \\memo These values are too extreme for the soil under a conditioned building.
       \\memo For best results, use the Slab or Basement program to calculate custom monthly
       \\memo average ground temperatures (see Auxiliary Programs). For typical commercial
       \\memo buildings in the USA, a reasonable default value is 2C less than the average indoor space temperature.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Ground Temperature
       \\units C
       \\type real
       \\default 18
  N2 , \\field February Ground Temperature
       \\units C
       \\type real
       \\default 18
  N3 , \\field March Ground Temperature
       \\units C
       \\type real
       \\default 18
  N4 , \\field April Ground Temperature
       \\units C
       \\type real
       \\default 18
  N5 , \\field May Ground Temperature
       \\units C
       \\type real
       \\default 18
  N6 , \\field June Ground Temperature
       \\units C
       \\type real
       \\default 18
  N7 , \\field July Ground Temperature
       \\units C
       \\type real
       \\default 18
  N8 , \\field August Ground Temperature
       \\units C
       \\type real
       \\default 18
  N9 , \\field September Ground Temperature
       \\units C
       \\type real
       \\default 18
  N10, \\field October Ground Temperature
       \\units C
       \\type real
       \\default 18
  N11, \\field November Ground Temperature
       \\units C
       \\type real
       \\default 18
  N12; \\field December Ground Temperature
       \\units C
       \\type real
       \\default 18

Site:GroundTemperature:FCfactorMethod,
       \\memo These temperatures are specifically for underground walls and ground floors
       \\memo defined with the C-factor and F-factor methods, and should be close to the
       \\memo monthly average outdoor air temperature delayed by 3 months for the location.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Ground Temperature
       \\units C
       \\type real
       \\default 13
  N2 , \\field February Ground Temperature
       \\units C
       \\type real
       \\default 13
  N3 , \\field March Ground Temperature
       \\units C
       \\type real
       \\default 13
  N4 , \\field April Ground Temperature
       \\units C
       \\type real
       \\default 13
  N5 , \\field May Ground Temperature
       \\units C
       \\type real
       \\default 13
  N6 , \\field June Ground Temperature
       \\units C
       \\type real
       \\default 13
  N7 , \\field July Ground Temperature
       \\units C
       \\type real
       \\default 13
  N8 , \\field August Ground Temperature
       \\units C
       \\type real
       \\default 13
  N9 , \\field September Ground Temperature
       \\units C
       \\type real
       \\default 13
  N10, \\field October Ground Temperature
       \\units C
       \\type real
       \\default 13
  N11, \\field November Ground Temperature
       \\units C
       \\type real
       \\default 13
  N12; \\field December Ground Temperature
       \\units C
       \\type real
       \\default 13

Site:GroundTemperature:Shallow,
       \\memo These temperatures are specifically for the Surface Ground Heat Exchanger and
       \\memo should probably be close to the average outdoor air temperature for the location.
       \\memo They are not used in other models.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N2 , \\field February Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N3 , \\field March Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N4 , \\field April Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N5 , \\field May Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N6 , \\field June Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N7 , \\field July Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N8 , \\field August Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N9 , \\field September Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N10, \\field October Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N11, \\field November Surface Ground Temperature
       \\units C
       \\type real
       \\default 13
  N12; \\field December Surface Ground Temperature
       \\units C
       \\type real
       \\default 13

Site:GroundTemperature:Deep,
       \\memo These temperatures are specifically for the ground heat exchangers that would use
       \\memo "deep" (3-4 m depth) ground temperatures for their heat source.
       \\memo They are not used in other models.
       \\unique-object
       \\min-fields 12
       \\format singleLine
  N1 , \\field January Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N2 , \\field February Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N3 , \\field March Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N4 , \\field April Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N5 , \\field May Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N6 , \\field June Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N7 , \\field July Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N8 , \\field August Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N9 , \\field September Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N10, \\field October Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N11, \\field November Deep Ground Temperature
       \\units C
       \\type real
       \\default 16
  N12; \\field December Deep Ground Temperature
       \\units C
       \\type real
       \\default 16

Site:GroundTemperature:Undisturbed:FiniteDifference,
       \\memo Undisturbed ground temperature object using a
       \\memo detailed finite difference 1-D model
       \\min-fields 7
  A1,  \\field Name
       \\required-field
       \\reference UndisturbedGroundTempModels
  N1,  \\field Soil Thermal Conductivity
       \\required-field
       \\type real
       \\units W/m-K
       \\minimum> 0.0
  N2,  \\field Soil Density
       \\required-field
       \\type real
       \\units kg/m3
       \\minimum> 0.0
  N3,  \\field Soil Specific Heat
       \\required-field
       \\type real
       \\units J/kg-K
       \\minimum> 0.0
  N4,  \\field Soil Moisture Content Volume Fraction
       \\type real
       \\units percent
       \\minimum 0
       \\maximum 100
       \\default 30
  N5,  \\field Soil Moisture Content Volume Fraction at Saturation
       \\type real
       \\units percent
       \\minimum 0
       \\maximum 100
       \\default 50
   N6; \\field Evapotranspiration Ground Cover Parameter
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum 1.5
       \\default 0.4
       \\note This specifies the ground cover effects during evapotranspiration
       \\note  calculations. The value roughly represents the following cases:
       \\note  = 0   : concrete or other solid, non-permeable ground surface material
       \\note  = 0.5 : short grass, much like a manicured lawn
       \\note  = 1   : standard reference state (12 cm grass)
       \\note  = 1.5 : wild growth

Site:GroundTemperature:Undisturbed:KusudaAchenbach,
       \\memo Undisturbed ground temperature object using the
       \\memo Kusuda-Achenbach 1965 correlation.
       \\min-fields 7
  A1,  \\field Name
       \\required-field
       \\reference UndisturbedGroundTempModels
  N1,  \\field Soil Thermal Conductivity
       \\required-field
       \\type real
       \\units W/m-K
       \\minimum> 0.0
  N2,  \\field Soil Density
       \\required-field
       \\type real
       \\units kg/m3
       \\minimum> 0.0
  N3,  \\field Soil Specific Heat
       \\required-field
       \\type real
       \\units J/kg-K
       \\minimum> 0.0
  N4,  \\field Average Soil Surface Temperature
       \\type real
       \\units C
       \\note Annual average surface temperature
       \\note If left blank the Site:GroundTemperature:Shallow object must be included in the input
       \\note The soil temperature, amplitude, and phase shift must all be included or omitted together
  N5,  \\field Average Amplitude of Surface Temperature
       \\type real
       \\units deltaC
       \\minimum 0
       \\note Annual average surface temperature variation from average.
       \\note If left blank the Site:GroundTemperature:Shallow object must be included in the input
       \\note The soil temperature, amplitude, and phase shift must all be included or omitted together
  N6;  \\field Phase Shift of Minimum Surface Temperature
       \\type real
       \\units days
       \\minimum 0
       \\maximum< 365
       \\note The phase shift of minimum surface temperature, or the day
       \\note of the year when the minimum surface temperature occurs.
       \\note If left blank the Site:GroundTemperature:Shallow object must be included in the input
       \\note The soil temperature, amplitude, and phase shift must all be included or omitted together

Site:GroundTemperature:Undisturbed:Xing,
       \\memo Undisturbed ground temperature object using the
       \\memo Xing 2014 2 harmonic parameter model.
       \\min-fields 9
  A1,  \\field Name
       \\required-field
       \\reference UndisturbedGroundTempModels
  N1,  \\field Soil Thermal Conductivity
       \\required-field
       \\type real
       \\units W/m-K
       \\minimum> 0.0
  N2,  \\field Soil Density
       \\required-field
       \\type real
       \\units kg/m3
       \\minimum> 0.0
  N3,  \\field Soil Specific Heat
       \\required-field
       \\type real
       \\units J/kg-K
       \\minimum> 0.0
  N4,  \\field Average Soil Surface Tempeature
       \\required-field
       \\type real
       \\units C
  N5,  \\field Soil Surface Temperature Amplitude 1
       \\required-field
       \\type real
       \\units deltaC
  N6,  \\field Soil Surface Temperature Amplitude 2
       \\required-field
       \\type real
       \\units deltaC
  N7,  \\field Phase Shift of Temperature Amplitude 1
       \\required-field
       \\type real
       \\units days
       \\maximum< 365
  N8;  \\field Phase Shift of Temperature Amplitude 2
       \\required-field
       \\type real
       \\units days
       \\maximum< 365

Site:GroundDomain:Slab,
        \\memo Ground-coupled slab model for on-grade and
        \\memo in-grade cases with or without insulation.
   A1,  \\field Name
        \\required-field
   N1,  \\field Ground Domain Depth
        \\type real
        \\default 10
        \\units m
        \\minimum> 0.0
   N2,  \\field Aspect Ratio
        \\type real
        \\default 1
   N3,  \\field Perimeter Offset
        \\type real
        \\default 5
        \\units m
        \\minimum> 0.0
   N4,  \\field Soil Thermal Conductivity
        \\type real
        \\default 1.5
        \\units W/m-K
        \\minimum> 0.0
   N5,  \\field Soil Density
        \\type real
        \\default 2800
        \\units kg/m3
        \\minimum> 0.0
   N6,  \\field Soil Specific Heat
        \\type real
        \\default 850
        \\units J/kg-K
        \\minimum> 0.0
   N7,  \\field Soil Moisture Content Volume Fraction
        \\type real
        \\units percent
        \\minimum 0
        \\maximum 100
        \\default 30
   N8,  \\field Soil Moisture Content Volume Fraction at Saturation
        \\type real
        \\units percent
        \\minimum 0
        \\maximum 100
        \\default 50
   A2,  \\field Undisturbed Ground Temperature Model Type
        \\required-field
        \\type choice
        \\key Site:GroundTemperature:Undisturbed:FiniteDifference
        \\key Site:GroundTemperature:Undisturbed:KusudaAchenbach
        \\key Site:GroundTemperature:Undisturbed:Xing
   A3,  \\field Undisturbed Ground Temperature Model Name
        \\required-field
        \\type object-list
        \\object-list UndisturbedGroundTempModels
   N9,  \\field Evapotranspiration Ground Cover Parameter
        \\type real
        \\minimum 0
        \\maximum 1.5
        \\default 0.4
        \\note This specifies the ground cover effects during evapotranspiration
        \\note  calculations. The value roughly represents the following cases:
        \\note  = 0   : concrete or other solid, non-permeable ground surface material
        \\note  = 0.5 : short grass, much like a manicured lawn
        \\note  = 1   : standard reference state (12 cm grass)
        \\note  = 1.5 : wild growth
   A4,  \\field Slab Boundary Condition Model Name
        \\required-field
        \\type object-list
        \\object-list OSCMNames
   A5,  \\field Slab Location
        \\required-field
        \\type choice
        \\key InGrade
        \\key OnGrade
        \\note This field specifies whether the slab is located "in-grade" or "on-grade"
   A6,  \\field Slab Material Name
        \\type object-list
        \\object-list MaterialName
        \\note Only applicable for the in-grade case
   A7,  \\field Horizontal Insulation
        \\type choice
        \\key Yes
        \\key No
        \\default No
        \\note This field specifies the presence of insulation beneath the slab.
        \\note Only required for in-grade case.
   A8,  \\field Horizontal Insulation Material Name
        \\type object-list
        \\object-list MaterialName
        \\note This field specifies the horizontal insulation material.
   A9,  \\field Horizontal Insulation Extents
        \\type choice
        \\key Full
        \\key Perimeter
        \\default Full
        \\note This field specifies whether the horizontal insulation fully insulates
        \\note the surface or is perimeter only insulation
   N10, \\field Perimeter Insulation Width
        \\type real
        \\units m
        \\minimum> 0.0
        \\note This field specifies the width of the underfloor perimeter insulation
   A10, \\field Vertical Insulation
        \\type choice
        \\key Yes
        \\key No
        \\default No
        \\note This field specifies the presence of vertical insulation at the slab edge.
   A11, \\field Vertical Insulation Material Name
        \\type object-list
        \\object-list MaterialName
        \\note This field specifies the vertical insulation material.
   N11, \\field Vertical Insulation Depth
        \\type real
        \\units m
        \\minimum> 0.0
        \\note Only used when including vertical insulation
        \\note This field specifies the depth of the vertical insulation
   A12, \\field Simulation Timestep
        \\type choice
        \\key Timestep
        \\key Hourly
        \\default Hourly
        \\note This field specifies the ground domain simulation timestep.
   N12, \\field Geometric Mesh Coefficient
        \\type real
        \\minimum 1.0
        \\maximum 2.0
        \\default 1.6
   N13; \\field Mesh Density Parameter
        \\type integer
        \\minimum 4
        \\default 6

Site:GroundDomain:Basement,
        \\memo Ground-coupled basement model for simulating basements
        \\memo or other underground zones.
   A1,  \\field Name
        \\required-field
   N1,  \\field Ground Domain Depth
        \\type real
        \\default 10
        \\units m
        \\minimum> 0.0
        \\note The depth from ground surface to the deep ground boundary of the domain.
   N2,  \\field Aspect Ratio
        \\type real
        \\default 1
        \\note This defines the height to width ratio of the basement zone.
   N3,  \\field Perimeter Offset
        \\type real
        \\default 5
        \\units m
        \\minimum> 0.0
        \\note The distance from the basement wall edge to the edge of the ground domain
   N4,  \\field Soil Thermal Conductivity
        \\type real
        \\default 1.5
        \\units W/m-K
        \\minimum> 0.0
   N5,  \\field Soil Density
        \\type real
        \\default 2800
        \\units kg/m3
        \\minimum> 0.0
   N6,  \\field Soil Specific Heat
        \\type real
        \\default 850
        \\units J/kg-K
        \\minimum> 0.0
   N7, \\field Soil Moisture Content Volume Fraction
        \\type real
        \\units percent
        \\minimum 0
        \\maximum 100
        \\default 30
   N8, \\field Soil Moisture Content Volume Fraction at Saturation
        \\type real
        \\units percent
        \\minimum 0
        \\maximum 100
        \\default 50
   A2,  \\field Undisturbed Ground Temperature Model Type
        \\required-field
        \\type choice
        \\key Site:GroundTemperature:Undisturbed:FiniteDifference
        \\key Site:GroundTemperature:Undisturbed:KusudaAchenbach
        \\key Site:GroundTemperature:Undisturbed:Xing
   A3,  \\field Undisturbed Ground Temperature Model Name
        \\required-field
        \\type object-list
        \\object-list UndisturbedGroundTempModels
   N9,  \\field Evapotranspiration Ground Cover Parameter
        \\type real
        \\minimum 0
        \\maximum 1.5
        \\default 0.4
        \\note This specifies the ground cover effects during evapotranspiration
        \\note  calculations. The value roughly represents the following cases:
        \\note  = 0   : concrete or other solid, non-permeable ground surface material
        \\note  = 0.5 : short grass, much like a manicured lawn
        \\note  = 1   : standard reference state (12 cm grass)
        \\note  = 1.5 : wild growth
   A4,  \\field Basement Floor Boundary Condition Model Name
        \\required-field
        \\type object-list
        \\object-list OSCMNames
   A5,  \\field Horizontal Insulation
        \\type choice
        \\key Yes
        \\key No
        \\default No
        \\note This field specifies the presence of insulation beneath the basement floor.
   A6,  \\field Horizontal Insulation Material Name
        \\type object-list
        \\object-list MaterialName
   A7,  \\field Horizontal Insulation Extents
        \\type choice
        \\key Perimeter
        \\key Full
        \\default Full
        \\note This field specifies whether the horizontal insulation fully insulates
        \\note the surface or is perimeter only insulation
   N10, \\field Perimeter Horizontal Insulation Width
        \\type real
        \\units m
        \\minimum> 0.0
        \\note Width of horizontal perimeter insulation measured from
        \\note foundation wall inside surface.
   N11, \\field Basement Wall Depth
        \\type real
        \\units m
        \\minimum> 0.0
        \\note Depth measured from ground surface.
   A8,  \\field Basement Wall Boundary Condition Model Name
        \\required-field
        \\type object-list
        \\object-list OSCMNames
   A9,  \\field Vertical Insulation
        \\type choice
        \\key Yes
        \\key No
        \\default No
   A10, \\field Basement Wall Vertical Insulation Material Name
        \\type object-list
        \\object-list MaterialName
   N12, \\field Vertical Insulation Depth
        \\type real
        \\units m
        \\minimum> 0.0
        \\note Depth measured from the ground surface.
   A11, \\field Simulation Timestep
        \\type choice
        \\key Timestep
        \\key Hourly
        \\default Hourly
        \\note This field specifies the basement domain simulation interval.
   N13; \\field Mesh Density Parameter
        \\type integer
        \\default 4
        \\minimum 2

Site:GroundReflectance,
        \\memo Specifies the ground reflectance values used to calculate ground reflected solar.
        \\memo The ground reflectance can be further modified when snow is on the ground
        \\memo by Site:GroundReflectance:SnowModifier.
  \\unique-object
  \\min-fields 12
  \\format singleLine
  N1 , \\field January Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N2 , \\field February Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N3 , \\field March Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N4 , \\field April Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N5 , \\field May Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N6 , \\field June Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N7 , \\field July Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N8 , \\field August Ground Reflectance
        \\default 0.2
        \\type real
        \\minimum 0.0
        \\maximum 1.0
        \\units dimensionless
   N9 , \\field September Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N10 , \\field October Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N11 , \\field November Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless
   N12 ; \\field December Ground Reflectance
         \\default 0.2
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\units dimensionless

Site:GroundReflectance:SnowModifier,
      \\memo Specifies ground reflectance multipliers when snow resident on the ground.
      \\memo These multipliers are applied to the "normal" ground reflectances specified
      \\memo in Site:GroundReflectance.
  N1, \\field Ground Reflected Solar Modifier
  \\minimum 0.0
  \\default 1.0
    \\note Value for modifying the "normal" ground reflectance when Snow is on ground
    \\note  when calculating the "Ground Reflected Solar Radiation Value"
    \\note  a value of 1.0 here uses the "normal" ground reflectance
    \\note  Ground Reflected Solar = (BeamSolar*CosSunZenith + DiffuseSolar)*GroundReflectance
    \\note    This would be further modified by the Snow Ground Reflectance Modifier when Snow was on the ground
    \\note    When Snow on ground, effective GroundReflectance is normal GroundReflectance*"Ground Reflectance Snow Modifier"
    \\note  Ground Reflectance achieved in this manner will be restricted to [0.0,1.0]
  N2; \\field Daylighting Ground Reflected Solar Modifier
  \\minimum 0.0
  \\default 1.0
    \\note Value for modifying the "normal" daylighting ground reflectance when Snow is on ground
    \\note  when calculating the "Ground Reflected Solar Radiation Value"
    \\note  a value of 1.0 here uses the "normal" ground reflectance
    \\note  Ground Reflected Solar = (BeamSolar*CosSunZenith + DiffuseSolar)*GroundReflectance
    \\note    This would be further modified by the Snow Ground Reflectance Modifier when Snow was on the ground
    \\note    When Snow on ground, effective GroundReflectance is normal GroundReflectance*"Daylighting Ground Reflectance Snow Modifier"
    \\note  Ground Reflectance achieved in this manner will be restricted to [0.0,1.0]

Site:WaterMainsTemperature,
       \\memo Used to calculate water mains temperatures delivered by underground water main pipes.
       \\memo Water mains temperatures are a function of outdoor climate conditions
       \\memo and vary with time of year.
  A1 , \\field Calculation Method
       \\required-field
       \\type choice
       \\key Schedule
       \\key Correlation
       \\key CorrelationFromWeatherFile
       \\default CorrelationFromWeatherFile
       \\note If calculation method is CorrelationFromWeatherFile, the two numeric input
       \\note fields are ignored. Instead, EnergyPlus calculates them from weather file.
  A2 , \\field Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Annual Average Outdoor Air Temperature
       \\note If calculation method is CorrelationFromWeatherFile or Schedule, this input
       \\note field is ignored.
       \\type real
       \\units C
  N2 ; \\field Maximum Difference In Monthly Average Outdoor Air Temperatures
       \\note If calculation method is CorrelationFromWeatherFile or Schedule, this input
       \\note field is ignored.
       \\type real
       \\units deltaC
       \\minimum 0

Site:Precipitation,
      \\memo Used to describe the amount of water precipitation at the building site.
      \\memo Precipitation includes both rain and the equivalent water content of snow.
  A1, \\field Precipitation Model Type
      \\type choice
      \\key ScheduleAndDesignLevel
  N1, \\field Design Level for Total Annual Precipitation
      \\note meters of water per year used for design level
      \\units m/yr
  A2, \\field Precipitation Rates Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Schedule values in meters of water per hour
      \\note values should be non-negative
  N2; \\field Average Total Annual Precipitation
      \\note meters of water per year from average weather statistics
      \\minimum 0
      \\units m/yr

RoofIrrigation,
      \\memo Used to describe the amount of irrigation on the ecoroof surface over the course
      \\memo of the simulation runperiod.
  A1, \\field Irrigation Model Type
      \\type choice
      \\key Schedule
      \\key SmartSchedule
      \\note SmartSchedule will not allow irrigation when soil is already moist.
      \\note Current threshold set at 30% of saturation.
  A2, \\field Irrigation Rate Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Schedule values in meters of water per hour
      \\note values should be non-negative
  N1; \\field Irrigation Maximum Saturation Threshold
      \\note Used with SmartSchedule to set the saturation level at which no
      \\note irrigation is allowed.
      \\units percent
      \\minimum 0.0
      \\maximum 100.0
      \\default 40.0

Site:SolarAndVisibleSpectrum,
      \\memo If this object is omitted, the default solar and visible spectrum data will be used.
      \\unique-object
  A1, \\field Name
      \\required-field
      \\type alpha
  A2, \\field Spectrum Data Method
      \\note The method specifies which of the solar and visible spectrum data to use in the calculations.
      \\note Choices: Default - existing hard-wired spectrum data in EnergyPlus.
      \\note UserDefined - user specified spectrum data referenced by the next two fields
      \\type choice
      \\key Default
      \\key UserDefined
      \\default Default
  A3, \\field Solar Spectrum Data Object Name
      \\type object-list
      \\object-list SpectrumDataNames
  A4; \\field Visible Spectrum Data Object Name
      \\type object-list
      \\object-list SpectrumDataNames

Site:SpectrumData,
      \\min-fields 8
      \\memo Spectrum Data Type is followed by up to 107 sets of normal-incidence measured values of
      \\memo [wavelength, spectrum] for wavelengths covering the solar (0.25 to 2.5 microns) or visible
      \\memo spectrum (0.38 to 0.78 microns)
      \\extensible:2
  A1, \\field Name
      \\required-field
      \\type alpha
      \\reference SpectrumDataNames
  A2, \\field Spectrum Data Type
      \\required-field
      \\type choice
      \\key Solar
      \\key Visible
  N1, \\field Wavelength
      \\type real
      \\units micron
  N2, \\field Spectrum
      \\type real
  N3, \\field Wavelength
      \\type real
      \\units micron
  N4, \\field Spectrum
      \\type real
  N5, \\field Wavelength
      \\begin-extensible
      \\type real
      \\units micron
  N6, \\field Spectrum
      \\type real
  N7, N8,       \\note fields as indicated
  N9, N10,      \\note fields as indicated
  N11, N12,     \\note fields as indicated
  N13, N14,     \\note fields as indicated
  N15, N16,     \\note fields as indicated
  N17, N18,     \\note fields as indicated
  N19, N20,     \\note fields as indicated
  N21, N22,     \\note fields as indicated
  N23, N24,     \\note fields as indicated
  N25, N26,     \\note fields as indicated
  N27, N28,     \\note fields as indicated
  N29, N30,     \\note fields as indicated
  N31, N32,     \\note fields as indicated
  N33, N34,     \\note fields as indicated
  N35, N36,     \\note fields as indicated
  N37, N38,     \\note fields as indicated
  N39, N40,     \\note fields as indicated
  N41, N42,     \\note fields as indicated
  N43, N44,     \\note fields as indicated
  N45, N46,     \\note fields as indicated
  N47, N48,     \\note fields as indicated
  N49, N50,     \\note fields as indicated
  N51, N52,     \\note fields as indicated
  N53, N54,     \\note fields as indicated
  N55, N56,     \\note fields as indicated
  N57, N58,     \\note fields as indicated
  N59, N60,     \\note fields as indicated
  N61, N62,     \\note fields as indicated
  N63, N64,     \\note fields as indicated
  N65, N66,     \\note fields as indicated
  N67, N68,     \\note fields as indicated
  N69, N70,     \\note fields as indicated
  N71, N72,     \\note fields as indicated
  N73, N74,     \\note fields as indicated
  N75, N76,     \\note fields as indicated
  N77, N78,     \\note fields as indicated
  N79, N80,     \\note fields as indicated
  N81, N82,     \\note fields as indicated
  N83, N84,     \\note fields as indicated
  N85, N86,     \\note fields as indicated
  N87, N88,     \\note fields as indicated
  N89, N90,     \\note fields as indicated
  N91, N92,     \\note fields as indicated
  N93, N94,     \\note fields as indicated
  N95, N96,     \\note fields as indicated
  N97, N98,     \\note fields as indicated
  N99, N100,    \\note fields as indicated
  N101, N102,   \\note fields as indicated
  N103, N104,   \\note fields as indicated
  N105, N106,   \\note fields as indicated
  N107, N108,   \\note fields as indicated
  N109, N110,   \\note fields as indicated
  N111, N112,   \\note fields as indicated
  N113, N114,   \\note fields as indicated
  N115, N116,   \\note fields as indicated
  N117, N118,   \\note fields as indicated
  N119, N120,   \\note fields as indicated
  N121, N122,   \\note fields as indicated
  N123, N124,   \\note fields as indicated
  N125, N126,   \\note fields as indicated
  N127, N128,   \\note fields as indicated
  N129, N130,   \\note fields as indicated
  N131, N132,   \\note fields as indicated
  N133, N134,   \\note fields as indicated
  N135, N136,   \\note fields as indicated
  N137, N138,   \\note fields as indicated
  N139, N140,   \\note fields as indicated
  N141, N142,   \\note fields as indicated
  N143, N144,   \\note fields as indicated
  N145, N146,   \\note fields as indicated
  N147, N148,   \\note fields as indicated
  N149, N150,   \\note fields as indicated
  N151, N152,   \\note fields as indicated
  N153, N154,   \\note fields as indicated
  N155, N156,   \\note fields as indicated
  N157, N158,   \\note fields as indicated
  N159, N160,   \\note fields as indicated
  N161, N162,   \\note fields as indicated
  N163, N164,   \\note fields as indicated
  N165, N166,   \\note fields as indicated
  N167, N168,   \\note fields as indicated
  N169, N170,   \\note fields as indicated
  N171, N172,   \\note fields as indicated
  N173, N174,   \\note fields as indicated
  N175, N176,   \\note fields as indicated
  N177, N178,   \\note fields as indicated
  N179, N180,   \\note fields as indicated
  N181, N182,   \\note fields as indicated
  N183, N184,   \\note fields as indicated
  N185, N186,   \\note fields as indicated
  N187, N188,   \\note fields as indicated
  N189, N190,   \\note fields as indicated
  N191, N192,   \\note fields as indicated
  N193, N194,   \\note fields as indicated
  N195, N196,   \\note fields as indicated
  N197, N198,   \\note fields as indicated
  N199, N200,   \\note fields as indicated
  N201, N202,   \\note fields as indicated
  N203, N204,   \\note fields as indicated
  N205, N206,   \\note fields as indicated
  N207, N208,   \\note fields as indicated
  N209, N210,   \\note fields as indicated
  N211, N212,   \\note fields as indicated
  N213, N214;   \\note fields as indicated

\\group Schedules

ScheduleTypeLimits,
       \\memo ScheduleTypeLimits specifies the data types and limits for the values contained in schedules
  A1,  \\field Name
       \\required-field
       \\reference ScheduleTypeLimitsNames
       \\note used to validate schedule types in various schedule objects
  N1,  \\field Lower Limit Value
       \\note lower limit (real or integer) for the Schedule Type. e.g. if fraction, this is 0.0
       \\unitsBasedOnField A3
  N2,  \\field Upper Limit Value
       \\note upper limit (real or integer) for the Schedule Type. e.g. if fraction, this is 1.0
       \\unitsBasedOnField A3
  A2,  \\field Numeric Type
       \\note Numeric type is either Continuous (all numbers within the min and
       \\note max are valid or Discrete (only integer numbers between min and
       \\note max are valid. (Could also allow REAL and INTEGER to mean the
       \\note same things)
       \\type choice
       \\key Continuous
       \\key Discrete
  A3;  \\field Unit Type
       \\note Temperature (C or F)
       \\note DeltaTemperature (C or F)
       \\note PrecipitationRate (m/hr or ft/hr)
       \\note Angle (degrees)
       \\note Convection Coefficient (W/m2-K or Btu/sqft-hr-F)
       \\note Activity Level (W/person)
       \\note Velocity (m/s or ft/min)
       \\note Capacity (W or Btu/h)
       \\note Power (W)
       \\type choice
       \\key Dimensionless
       \\key Temperature
       \\key DeltaTemperature
       \\key PrecipitationRate
       \\key Angle
       \\key ConvectionCoefficient
       \\key ActivityLevel
       \\key Velocity
       \\key Capacity
       \\key Power
       \\key Availability
       \\key Percent
       \\key Control
       \\key Mode
       \\default Dimensionless

Schedule:Day:Hourly,
       \\min-fields 26
       \\memo A Schedule:Day:Hourly contains 24 values for each hour of the day.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  N1 , \\field Hour 1
       \\type real
       \\default 0
  N2 , \\field Hour 2
       \\type real
       \\default 0
  N3 , \\field Hour 3
       \\type real
       \\default 0
  N4 , \\field Hour 4
       \\type real
       \\default 0
  N5 , \\field Hour 5
       \\type real
       \\default 0
  N6 , \\field Hour 6
       \\type real
       \\default 0
  N7 , \\field Hour 7
       \\type real
       \\default 0
  N8 , \\field Hour 8
       \\type real
       \\default 0
  N9 , \\field Hour 9
       \\type real
       \\default 0
  N10, \\field Hour 10
       \\type real
       \\default 0
  N11, \\field Hour 11
       \\type real
       \\default 0
  N12, \\field Hour 12
       \\type real
       \\default 0
  N13, \\field Hour 13
       \\type real
       \\default 0
  N14, \\field Hour 14
       \\type real
       \\default 0
  N15, \\field Hour 15
       \\type real
       \\default 0
  N16, \\field Hour 16
       \\type real
       \\default 0
  N17, \\field Hour 17
       \\type real
       \\default 0
  N18, \\field Hour 18
       \\type real
       \\default 0
  N19, \\field Hour 19
       \\type real
       \\default 0
  N20, \\field Hour 20
       \\type real
       \\default 0
  N21, \\field Hour 21
       \\type real
       \\default 0
  N22, \\field Hour 22
       \\type real
       \\default 0
  N23, \\field Hour 23
       \\type real
       \\default 0
  N24; \\field Hour 24
       \\type real
       \\default 0

Schedule:Day:Interval,
       \\extensible:2 - repeat last two fields, remembering to remove ; from "inner" fields.
       \\memo A Schedule:Day:Interval contains a full day of values with specified end times for each value
       \\memo Currently, is set up to allow for 10 minute intervals for an entire day.
       \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a Average choice will average between the intervals request (to
       \\note timestep resolution. A No choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not. A Linear choice will interpolate linearly between successive values.
       \\type choice
       \\key Average
       \\key Linear
       \\key No
       \\default No
 A4  , \\field Time 1
       \\begin-extensible
       \\note "until" includes the time entered.
       \\units hh:mm
 N1  , \\field Value Until Time 1
 A5  , \\field Time 2
       \\note "until" includes the time entered.
       \\units hh:mm
 N2  , \\field Value Until Time 2
 A6  , \\field Time 3
       \\note "until" includes the time entered.
       \\units hh:mm
 N3  , \\field Value Until Time 3
 A7  , \\field Time 4
       \\note "until" includes the time entered.
       \\units hh:mm
 N4  , \\field Value Until Time 4
 A8  , \\field Time 5
       \\note "until" includes the time entered.
       \\units hh:mm
 N5  , \\field Value Until Time 5
 A9  , \\field Time 6
       \\note "until" includes the time entered.
       \\units hh:mm
 N6  , \\field Value Until Time 6
 A10 , \\field Time 7
       \\note "until" includes the time entered.
       \\units hh:mm
 N7  , \\field Value Until Time 7
 A11 , \\field Time 8
       \\note "until" includes the time entered.
       \\units hh:mm
 N8  , \\field Value Until Time 8
 A12 , \\field Time 9
       \\note "until" includes the time entered.
       \\units hh:mm
 N9  , \\field Value Until Time 9
 A13 , \\field Time 10
       \\note "until" includes the time entered.
       \\units hh:mm
 N10 , \\field Value Until Time 10
 A14 , \\field Time 11
       \\note "until" includes the time entered.
       \\units hh:mm
 N11 , \\field Value Until Time 11
 A15 , \\field Time 12
       \\note "until" includes the time entered.
       \\units hh:mm
 N12 , \\field Value Until Time 12
 A16 , \\field Time 13
       \\note "until" includes the time entered.
       \\units hh:mm
 N13 , \\field Value Until Time 13
 A17 , \\field Time 14
       \\note "until" includes the time entered.
       \\units hh:mm
 N14 , \\field Value Until Time 14
 A18 , \\field Time 15
       \\note "until" includes the time entered.
       \\units hh:mm
 N15 , \\field Value Until Time 15
 A19 , \\field Time 16
       \\note "until" includes the time entered.
       \\units hh:mm
 N16 , \\field Value Until Time 16
 A20 , \\field Time 17
       \\note "until" includes the time entered.
       \\units hh:mm
 N17 , \\field Value Until Time 17
 A21 , \\field Time 18
       \\note "until" includes the time entered.
       \\units hh:mm
 N18 , \\field Value Until Time 18
 A22 , \\field Time 19
       \\note "until" includes the time entered.
       \\units hh:mm
 N19 , \\field Value Until Time 19
 A23 , \\field Time 20
       \\note "until" includes the time entered.
       \\units hh:mm
 N20 , \\field Value Until Time 20
 A24 , \\field Time 21
       \\note "until" includes the time entered.
       \\units hh:mm
 N21 , \\field Value Until Time 21
 A25 , \\field Time 22
       \\note "until" includes the time entered.
       \\units hh:mm
 N22 , \\field Value Until Time 22
 A26 , \\field Time 23
       \\note "until" includes the time entered.
       \\units hh:mm
 N23 , \\field Value Until Time 23
 A27 , \\field Time 24
       \\note "until" includes the time entered.
       \\units hh:mm
 N24 , \\field Value Until Time 24
 A28 , \\field Time 25
       \\note "until" includes the time entered.
       \\units hh:mm
 N25 , \\field Value Until Time 25
 A29 , \\field Time 26
       \\note "until" includes the time entered.
       \\units hh:mm
 N26 , \\field Value Until Time 26
 A30 , \\field Time 27
       \\note "until" includes the time entered.
       \\units hh:mm
 N27 , \\field Value Until Time 27
 A31 , \\field Time 28
       \\note "until" includes the time entered.
       \\units hh:mm
 N28 , \\field Value Until Time 28
 A32 , \\field Time 29
       \\note "until" includes the time entered.
       \\units hh:mm
 N29 , \\field Value Until Time 29
 A33 , \\field Time 30
       \\note "until" includes the time entered.
       \\units hh:mm
 N30 , \\field Value Until Time 30
 A34 , \\field Time 31
       \\note "until" includes the time entered.
       \\units hh:mm
 N31 , \\field Value Until Time 31
 A35 , \\field Time 32
       \\note "until" includes the time entered.
       \\units hh:mm
 N32 , \\field Value Until Time 32
 A36 , \\field Time 33
       \\note "until" includes the time entered.
       \\units hh:mm
 N33 , \\field Value Until Time 33
 A37 , \\field Time 34
       \\note "until" includes the time entered.
       \\units hh:mm
 N34 , \\field Value Until Time 34
 A38 , \\field Time 35
       \\note "until" includes the time entered.
       \\units hh:mm
 N35 , \\field Value Until Time 35
 A39 , \\field Time 36
       \\note "until" includes the time entered.
       \\units hh:mm
 N36 , \\field Value Until Time 36
 A40 , \\field Time 37
       \\note "until" includes the time entered.
       \\units hh:mm
 N37 , \\field Value Until Time 37
 A41 , \\field Time 38
       \\note "until" includes the time entered.
       \\units hh:mm
 N38 , \\field Value Until Time 38
 A42 , \\field Time 39
       \\note "until" includes the time entered.
       \\units hh:mm
 N39 , \\field Value Until Time 39
 A43 , \\field Time 40
       \\note "until" includes the time entered.
       \\units hh:mm
 N40 , \\field Value Until Time 40
 A44 , \\field Time 41
       \\note "until" includes the time entered.
       \\units hh:mm
 N41 , \\field Value Until Time 41
 A45 , \\field Time 42
       \\note "until" includes the time entered.
       \\units hh:mm
 N42 , \\field Value Until Time 42
 A46 , \\field Time 43
       \\note "until" includes the time entered.
       \\units hh:mm
 N43 , \\field Value Until Time 43
 A47 , \\field Time 44
       \\note "until" includes the time entered.
       \\units hh:mm
 N44 , \\field Value Until Time 44
 A48 , \\field Time 45
       \\note "until" includes the time entered.
       \\units hh:mm
 N45 , \\field Value Until Time 45
 A49 , \\field Time 46
       \\note "until" includes the time entered.
       \\units hh:mm
 N46 , \\field Value Until Time 46
 A50 , \\field Time 47
       \\note "until" includes the time entered.
       \\units hh:mm
 N47 , \\field Value Until Time 47
 A51 , \\field Time 48
       \\note "until" includes the time entered.
       \\units hh:mm
 N48 , \\field Value Until Time 48
 A52 , \\field Time 49
       \\note "until" includes the time entered.
       \\units hh:mm
 N49 , \\field Value Until Time 49
 A53 , \\field Time 50
       \\note "until" includes the time entered.
       \\units hh:mm
 N50 , \\field Value Until Time 50
 A54 , \\field Time 51
       \\note "until" includes the time entered.
       \\units hh:mm
 N51 , \\field Value Until Time 51
 A55 , \\field Time 52
       \\note "until" includes the time entered.
       \\units hh:mm
 N52 , \\field Value Until Time 52
 A56 , \\field Time 53
       \\note "until" includes the time entered.
       \\units hh:mm
 N53 , \\field Value Until Time 53
 A57 , \\field Time 54
       \\note "until" includes the time entered.
       \\units hh:mm
 N54 , \\field Value Until Time 54
 A58 , \\field Time 55
       \\note "until" includes the time entered.
       \\units hh:mm
 N55 , \\field Value Until Time 55
 A59 , \\field Time 56
       \\note "until" includes the time entered.
       \\units hh:mm
 N56 , \\field Value Until Time 56
 A60 , \\field Time 57
       \\note "until" includes the time entered.
       \\units hh:mm
 N57 , \\field Value Until Time 57
 A61 , \\field Time 58
       \\note "until" includes the time entered.
       \\units hh:mm
 N58 , \\field Value Until Time 58
 A62 , \\field Time 59
       \\note "until" includes the time entered.
       \\units hh:mm
 N59 , \\field Value Until Time 59
 A63 , \\field Time 60
       \\note "until" includes the time entered.
       \\units hh:mm
 N60 , \\field Value Until Time 60
 A64 , \\field Time 61
       \\note "until" includes the time entered.
       \\units hh:mm
 N61 , \\field Value Until Time 61
 A65 , \\field Time 62
       \\note "until" includes the time entered.
       \\units hh:mm
 N62 , \\field Value Until Time 62
 A66 , \\field Time 63
       \\note "until" includes the time entered.
       \\units hh:mm
 N63 , \\field Value Until Time 63
 A67 , \\field Time 64
       \\note "until" includes the time entered.
       \\units hh:mm
 N64 , \\field Value Until Time 64
 A68 , \\field Time 65
       \\note "until" includes the time entered.
       \\units hh:mm
 N65 , \\field Value Until Time 65
 A69 , \\field Time 66
       \\note "until" includes the time entered.
       \\units hh:mm
 N66 , \\field Value Until Time 66
 A70 , \\field Time 67
       \\note "until" includes the time entered.
       \\units hh:mm
 N67 , \\field Value Until Time 67
 A71 , \\field Time 68
       \\note "until" includes the time entered.
       \\units hh:mm
 N68 , \\field Value Until Time 68
 A72 , \\field Time 69
       \\note "until" includes the time entered.
       \\units hh:mm
 N69 , \\field Value Until Time 69
 A73 , \\field Time 70
       \\note "until" includes the time entered.
       \\units hh:mm
 N70 , \\field Value Until Time 70
 A74 , \\field Time 71
       \\note "until" includes the time entered.
       \\units hh:mm
 N71 , \\field Value Until Time 71
 A75 , \\field Time 72
       \\note "until" includes the time entered.
       \\units hh:mm
 N72 , \\field Value Until Time 72
 A76 , \\field Time 73
       \\note "until" includes the time entered.
       \\units hh:mm
 N73 , \\field Value Until Time 73
 A77 , \\field Time 74
       \\note "until" includes the time entered.
       \\units hh:mm
 N74 , \\field Value Until Time 74
 A78 , \\field Time 75
       \\note "until" includes the time entered.
       \\units hh:mm
 N75 , \\field Value Until Time 75
 A79 , \\field Time 76
       \\note "until" includes the time entered.
       \\units hh:mm
 N76 , \\field Value Until Time 76
 A80 , \\field Time 77
       \\note "until" includes the time entered.
       \\units hh:mm
 N77 , \\field Value Until Time 77
 A81 , \\field Time 78
       \\note "until" includes the time entered.
       \\units hh:mm
 N78 , \\field Value Until Time 78
 A82 , \\field Time 79
       \\note "until" includes the time entered.
       \\units hh:mm
 N79 , \\field Value Until Time 79
 A83 , \\field Time 80
       \\note "until" includes the time entered.
       \\units hh:mm
 N80 , \\field Value Until Time 80
 A84 , \\field Time 81
       \\note "until" includes the time entered.
       \\units hh:mm
 N81 , \\field Value Until Time 81
 A85 , \\field Time 82
       \\note "until" includes the time entered.
       \\units hh:mm
 N82 , \\field Value Until Time 82
 A86 , \\field Time 83
       \\note "until" includes the time entered.
       \\units hh:mm
 N83 , \\field Value Until Time 83
 A87 , \\field Time 84
       \\note "until" includes the time entered.
       \\units hh:mm
 N84 , \\field Value Until Time 84
 A88 , \\field Time 85
       \\note "until" includes the time entered.
       \\units hh:mm
 N85 , \\field Value Until Time 85
 A89 , \\field Time 86
       \\note "until" includes the time entered.
       \\units hh:mm
 N86 , \\field Value Until Time 86
 A90 , \\field Time 87
       \\note "until" includes the time entered.
       \\units hh:mm
 N87 , \\field Value Until Time 87
 A91 , \\field Time 88
       \\note "until" includes the time entered.
       \\units hh:mm
 N88 , \\field Value Until Time 88
 A92 , \\field Time 89
       \\note "until" includes the time entered.
       \\units hh:mm
 N89 , \\field Value Until Time 89
 A93 , \\field Time 90
       \\note "until" includes the time entered.
       \\units hh:mm
 N90 , \\field Value Until Time 90
 A94 , \\field Time 91
       \\note "until" includes the time entered.
       \\units hh:mm
 N91 , \\field Value Until Time 91
 A95 , \\field Time 92
       \\note "until" includes the time entered.
       \\units hh:mm
 N92 , \\field Value Until Time 92
 A96 , \\field Time 93
       \\note "until" includes the time entered.
       \\units hh:mm
 N93 , \\field Value Until Time 93
 A97 , \\field Time 94
       \\note "until" includes the time entered.
       \\units hh:mm
 N94 , \\field Value Until Time 94
 A98 , \\field Time 95
       \\note "until" includes the time entered.
       \\units hh:mm
 N95 , \\field Value Until Time 95
 A99 , \\field Time 96
       \\note "until" includes the time entered.
       \\units hh:mm
 N96 , \\field Value Until Time 96
 A100, \\field Time 97
       \\note "until" includes the time entered.
       \\units hh:mm
 N97 , \\field Value Until Time 97
 A101, \\field Time 98
       \\note "until" includes the time entered.
       \\units hh:mm
 N98 , \\field Value Until Time 98
 A102, \\field Time 99
       \\note "until" includes the time entered.
       \\units hh:mm
 N99 , \\field Value Until Time 99
 A103, \\field Time 100
       \\note "until" includes the time entered.
       \\units hh:mm
 N100, \\field Value Until Time 100
 A104, \\field Time 101
       \\note "until" includes the time entered.
       \\units hh:mm
 N101, \\field Value Until Time 101
 A105, \\field Time 102
       \\note "until" includes the time entered.
       \\units hh:mm
 N102, \\field Value Until Time 102
 A106, \\field Time 103
       \\note "until" includes the time entered.
       \\units hh:mm
 N103, \\field Value Until Time 103
 A107, \\field Time 104
       \\note "until" includes the time entered.
       \\units hh:mm
 N104, \\field Value Until Time 104
 A108, \\field Time 105
       \\note "until" includes the time entered.
       \\units hh:mm
 N105, \\field Value Until Time 105
 A109, \\field Time 106
       \\note "until" includes the time entered.
       \\units hh:mm
 N106, \\field Value Until Time 106
 A110, \\field Time 107
       \\note "until" includes the time entered.
       \\units hh:mm
 N107, \\field Value Until Time 107
 A111, \\field Time 108
       \\note "until" includes the time entered.
       \\units hh:mm
 N108, \\field Value Until Time 108
 A112, \\field Time 109
       \\note "until" includes the time entered.
       \\units hh:mm
 N109, \\field Value Until Time 109
 A113, \\field Time 110
       \\note "until" includes the time entered.
       \\units hh:mm
 N110, \\field Value Until Time 110
 A114, \\field Time 111
       \\note "until" includes the time entered.
       \\units hh:mm
 N111, \\field Value Until Time 111
 A115, \\field Time 112
       \\note "until" includes the time entered.
       \\units hh:mm
 N112, \\field Value Until Time 112
 A116, \\field Time 113
       \\note "until" includes the time entered.
       \\units hh:mm
 N113, \\field Value Until Time 113
 A117, \\field Time 114
       \\note "until" includes the time entered.
       \\units hh:mm
 N114, \\field Value Until Time 114
 A118, \\field Time 115
       \\note "until" includes the time entered.
       \\units hh:mm
 N115, \\field Value Until Time 115
 A119, \\field Time 116
       \\note "until" includes the time entered.
       \\units hh:mm
 N116, \\field Value Until Time 116
 A120, \\field Time 117
       \\note "until" includes the time entered.
       \\units hh:mm
 N117, \\field Value Until Time 117
 A121, \\field Time 118
       \\note "until" includes the time entered.
       \\units hh:mm
 N118, \\field Value Until Time 118
 A122, \\field Time 119
       \\note "until" includes the time entered.
       \\units hh:mm
 N119, \\field Value Until Time 119
 A123, \\field Time 120
       \\note "until" includes the time entered.
       \\units hh:mm
 N120, \\field Value Until Time 120
 A124, \\field Time 121
       \\note "until" includes the time entered.
       \\units hh:mm
 N121, \\field Value Until Time 121
 A125, \\field Time 122
       \\note "until" includes the time entered.
       \\units hh:mm
 N122, \\field Value Until Time 122
 A126, \\field Time 123
       \\note "until" includes the time entered.
       \\units hh:mm
 N123, \\field Value Until Time 123
 A127, \\field Time 124
       \\note "until" includes the time entered.
       \\units hh:mm
 N124, \\field Value Until Time 124
 A128, \\field Time 125
       \\note "until" includes the time entered.
       \\units hh:mm
 N125, \\field Value Until Time 125
 A129, \\field Time 126
       \\note "until" includes the time entered.
       \\units hh:mm
 N126, \\field Value Until Time 126
 A130, \\field Time 127
       \\note "until" includes the time entered.
       \\units hh:mm
 N127, \\field Value Until Time 127
 A131, \\field Time 128
       \\note "until" includes the time entered.
       \\units hh:mm
 N128, \\field Value Until Time 128
 A132, \\field Time 129
       \\note "until" includes the time entered.
       \\units hh:mm
 N129, \\field Value Until Time 129
 A133, \\field Time 130
       \\note "until" includes the time entered.
       \\units hh:mm
 N130, \\field Value Until Time 130
 A134, \\field Time 131
       \\note "until" includes the time entered.
       \\units hh:mm
 N131, \\field Value Until Time 131
 A135, \\field Time 132
       \\note "until" includes the time entered.
       \\units hh:mm
 N132, \\field Value Until Time 132
 A136, \\field Time 133
       \\note "until" includes the time entered.
       \\units hh:mm
 N133, \\field Value Until Time 133
 A137, \\field Time 134
       \\note "until" includes the time entered.
       \\units hh:mm
 N134, \\field Value Until Time 134
 A138, \\field Time 135
       \\note "until" includes the time entered.
       \\units hh:mm
 N135, \\field Value Until Time 135
 A139, \\field Time 136
       \\note "until" includes the time entered.
       \\units hh:mm
 N136, \\field Value Until Time 136
 A140, \\field Time 137
       \\note "until" includes the time entered.
       \\units hh:mm
 N137, \\field Value Until Time 137
 A141, \\field Time 138
       \\note "until" includes the time entered.
       \\units hh:mm
 N138, \\field Value Until Time 138
 A142, \\field Time 139
       \\note "until" includes the time entered.
       \\units hh:mm
 N139, \\field Value Until Time 139
 A143, \\field Time 140
       \\note "until" includes the time entered.
       \\units hh:mm
 N140, \\field Value Until Time 140
 A144, \\field Time 141
       \\note "until" includes the time entered.
       \\units hh:mm
 N141, \\field Value Until Time 141
 A145, \\field Time 142
       \\note "until" includes the time entered.
       \\units hh:mm
 N142, \\field Value Until Time 142
 A146, \\field Time 143
       \\note "until" includes the time entered.
       \\units hh:mm
 N143, \\field Value Until Time 143
 A147, \\field Time 144
       \\note "until" includes the time entered.
       \\units hh:mm
 N144; \\field Value Until Time 144

Schedule:Day:List,
      \\memo Schedule:Day:List will allow the user to list 24 hours worth of values, which can be sub-hourly in nature.
      \\min-fields 5
      \\extensible:1
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference DayScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a "Average" choice will average between the intervals request (to
       \\note timestep resolution. A "No" choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not. A "Linear" choice will interpolate linearly between successive values.
       \\type choice
       \\key Average
       \\key Linear
       \\key No
       \\default No
  N1 , \\field Minutes per Item
       \\note Must be evenly divisible into 60
       \\type integer
       \\minimum 1
       \\maximum 60
  N2,  \\field Value 1
       \\begin-extensible
       \\default 0.0
        N3,N4,         N5,N6,N7,N8,         N9,N10,N11,N12,      N13,N14,N15,N16,     N17,N18,N19,N20, \\note fields as indicated
  N21,N22,N23,N24,     N25,N26,N27,N28,     N29,N30,N31,N32,     N33,N34,N35,N36,     N37,N38,N39,N40, \\note fields as indicated
  N41,N42,N43,N44,     N45,N46,N47,N48,     N49,N50,N51,N52,     N53,N54,N55,N56,     N57,N58,N59,N60, \\note fields as indicated
  N61,N62,N63,N64,     N65,N66,N67,N68,     N69,N70,N71,N72,     N73,N74,N75,N76,     N77,N78,N79,N80, \\note fields as indicated
  N81,N82,N83,N84,     N85,N86,N87,N88,     N89,N90,N91,N92,     N93,N94,N95,N96,     N97,N98,N99,N100, \\note fields as indicated

  N101,N102,N103,N104, N105,N106,N107,N108, N109,N110,N111,N112, N113,N114,N115,N116, N117,N118,N119,N120, \\note fields as indicated
  N121,N122,N123,N124, N125,N126,N127,N128, N129,N130,N131,N132, N133,N134,N135,N136, N137,N138,N139,N140, \\note fields as indicated
  N141,N142,N143,N144, N145,N146,N147,N148, N149,N150,N151,N152, N153,N154,N155,N156, N157,N158,N159,N160, \\note fields as indicated
  N161,N162,N163,N164, N165,N166,N167,N168, N169,N170,N171,N172, N173,N174,N175,N176, N177,N178,N179,N180, \\note fields as indicated
  N181,N182,N183,N184, N185,N186,N187,N188, N189,N190,N191,N192, N193,N194,N195,N196, N197,N198,N199,N200, \\note fields as indicated

  N201,N202,N203,N204, N205,N206,N207,N208, N209,N210,N211,N212, N213,N214,N215,N216, N217,N218,N219,N220, \\note fields as indicated
  N221,N222,N223,N224, N225,N226,N227,N228, N229,N230,N231,N232, N233,N234,N235,N236, N237,N238,N239,N240, \\note fields as indicated
  N241,N242,N243,N244, N245,N246,N247,N248, N249,N250,N251,N252, N253,N254,N255,N256, N257,N258,N259,N260, \\note fields as indicated
  N261,N262,N263,N264, N265,N266,N267,N268, N269,N270,N271,N272, N273,N274,N275,N276, N277,N278,N279,N280, \\note fields as indicated
  N281,N282,N283,N284, N285,N286,N287,N288, N289,N290,N291,N292, N293,N294,N295,N296, N297,N298,N299,N300, \\note fields as indicated

  N301,N302,N303,N304, N305,N306,N307,N308, N309,N310,N311,N312, N313,N314,N315,N316, N317,N318,N319,N320, \\note fields as indicated
  N321,N322,N323,N324, N325,N326,N327,N328, N329,N330,N331,N332, N333,N334,N335,N336, N337,N338,N339,N340, \\note fields as indicated
  N341,N342,N343,N344, N345,N346,N347,N348, N349,N350,N351,N352, N353,N354,N355,N356, N357,N358,N359,N360, \\note fields as indicated
  N361,N362,N363,N364, N365,N366,N367,N368, N369,N370,N371,N372, N373,N374,N375,N376, N377,N378,N379,N380, \\note fields as indicated
  N381,N382,N383,N384, N385,N386,N387,N388, N389,N390,N391,N392, N393,N394,N395,N396, N397,N398,N399,N400, \\note fields as indicated

  N401,N402,N403,N404, N405,N406,N407,N408, N409,N410,N411,N412, N413,N414,N415,N416, N417,N418,N419,N420, \\note fields as indicated
  N421,N422,N423,N424, N425,N426,N427,N428, N429,N430,N431,N432, N433,N434,N435,N436, N437,N438,N439,N440, \\note fields as indicated
  N441,N442,N443,N444, N445,N446,N447,N448, N449,N450,N451,N452, N453,N454,N455,N456, N457,N458,N459,N460, \\note fields as indicated
  N461,N462,N463,N464, N465,N466,N467,N468, N469,N470,N471,N472, N473,N474,N475,N476, N477,N478,N479,N480, \\note fields as indicated
  N481,N482,N483,N484, N485,N486,N487,N488, N489,N490,N491,N492, N493,N494,N495,N496, N497,N498,N499,N500, \\note fields as indicated

  N501,N502,N503,N504, N505,N506,N507,N508, N509,N510,N511,N512, N513,N514,N515,N516, N517,N518,N519,N520, \\note fields as indicated
  N521,N522,N523,N524, N525,N526,N527,N528, N529,N530,N531,N532, N533,N534,N535,N536, N537,N538,N539,N540, \\note fields as indicated
  N541,N542,N543,N544, N545,N546,N547,N548, N549,N550,N551,N552, N553,N554,N555,N556, N557,N558,N559,N560, \\note fields as indicated
  N561,N562,N563,N564, N565,N566,N567,N568, N569,N570,N571,N572, N573,N574,N575,N576, N577,N578,N579,N580, \\note fields as indicated
  N581,N582,N583,N584, N585,N586,N587,N588, N589,N590,N591,N592, N593,N594,N595,N596, N597,N598,N599,N600, \\note fields as indicated

  N601,N602,N603,N604, N605,N606,N607,N608, N609,N610,N611,N612, N613,N614,N615,N616, N617,N618,N619,N620, \\note fields as indicated
  N621,N622,N623,N624, N625,N626,N627,N628, N629,N630,N631,N632, N633,N634,N635,N636, N637,N638,N639,N640, \\note fields as indicated
  N641,N642,N643,N644, N645,N646,N647,N648, N649,N650,N651,N652, N653,N654,N655,N656, N657,N658,N659,N660, \\note fields as indicated
  N661,N662,N663,N664, N665,N666,N667,N668, N669,N670,N671,N672, N673,N674,N675,N676, N677,N678,N679,N680, \\note fields as indicated
  N681,N682,N683,N684, N685,N686,N687,N688, N689,N690,N691,N692, N693,N694,N695,N696, N697,N698,N699,N700, \\note fields as indicated

  N701,N702,N703,N704, N705,N706,N707,N708, N709,N710,N711,N712, N713,N714,N715,N716, N717,N718,N719,N720, \\note fields as indicated
  N721,N722,N723,N724, N725,N726,N727,N728, N729,N730,N731,N732, N733,N734,N735,N736, N737,N738,N739,N740, \\note fields as indicated
  N741,N742,N743,N744, N745,N746,N747,N748, N749,N750,N751,N752, N753,N754,N755,N756, N757,N758,N759,N760, \\note fields as indicated
  N761,N762,N763,N764, N765,N766,N767,N768, N769,N770,N771,N772, N773,N774,N775,N776, N777,N778,N779,N780, \\note fields as indicated
  N781,N782,N783,N784, N785,N786,N787,N788, N789,N790,N791,N792, N793,N794,N795,N796, N797,N798,N799,N800, \\note fields as indicated

  N801,N802,N803,N804, N805,N806,N807,N808, N809,N810,N811,N812, N813,N814,N815,N816, N817,N818,N819,N820, \\note fields as indicated
  N821,N822,N823,N824, N825,N826,N827,N828, N829,N830,N831,N832, N833,N834,N835,N836, N837,N838,N839,N840, \\note fields as indicated
  N841,N842,N843,N844, N845,N846,N847,N848, N849,N850,N851,N852, N853,N854,N855,N856, N857,N858,N859,N860, \\note fields as indicated
  N861,N862,N863,N864, N865,N866,N867,N868, N869,N870,N871,N872, N873,N874,N875,N876, N877,N878,N879,N880, \\note fields as indicated
  N881,N882,N883,N884, N885,N886,N887,N888, N889,N890,N891,N892, N893,N894,N895,N896, N897,N898,N899,N900, \\note fields as indicated

  N901,N902,N903,N904, N905,N906,N907,N908, N909,N910,N911,N912, N913,N914,N915,N916, N917,N918,N919,N920, \\note fields as indicated
  N921,N922,N923,N924, N925,N926,N927,N928, N929,N930,N931,N932, N933,N934,N935,N936, N937,N938,N939,N940, \\note fields as indicated
  N941,N942,N943,N944, N945,N946,N947,N948, N949,N950,N951,N952, N953,N954,N955,N956, N957,N958,N959,N960, \\note fields as indicated
  N961,N962,N963,N964, N965,N966,N967,N968, N969,N970,N971,N972, N973,N974,N975,N976, N977,N978,N979,N980, \\note fields as indicated
  N981,N982,N983,N984, N985,N986,N987,N988, N989,N990,N991,N992, N993,N994,N995,N996, N997,N998,N999,N1000, \\note fields as indicated

  N1001,N1002,N1003,N1004, N1005,N1006,N1007,N1008, N1009,N1010,N1011,N1012, N1013,N1014,N1015,N1016, N1017,N1018,N1019,N1020, \\note fields as indicated
  N1021,N1022,N1023,N1024, N1025,N1026,N1027,N1028, N1029,N1030,N1031,N1032, N1033,N1034,N1035,N1036, N1037,N1038,N1039,N1040, \\note fields as indicated
  N1041,N1042,N1043,N1044, N1045,N1046,N1047,N1048, N1049,N1050,N1051,N1052, N1053,N1054,N1055,N1056, N1057,N1058,N1059,N1060, \\note fields as indicated
  N1061,N1062,N1063,N1064, N1065,N1066,N1067,N1068, N1069,N1070,N1071,N1072, N1073,N1074,N1075,N1076, N1077,N1078,N1079,N1080, \\note fields as indicated
  N1081,N1082,N1083,N1084, N1085,N1086,N1087,N1088, N1089,N1090,N1091,N1092, N1093,N1094,N1095,N1096, N1097,N1098,N1099,N1100, \\note fields as indicated

  N1101,N1102,N1103,N1104, N1105,N1106,N1107,N1108, N1109,N1110,N1111,N1112, N1113,N1114,N1115,N1116, N1117,N1118,N1119,N1120, \\note fields as indicated
  N1121,N1122,N1123,N1124, N1125,N1126,N1127,N1128, N1129,N1130,N1131,N1132, N1133,N1134,N1135,N1136, N1137,N1138,N1139,N1140, \\note fields as indicated
  N1141,N1142,N1143,N1144, N1145,N1146,N1147,N1148, N1149,N1150,N1151,N1152, N1153,N1154,N1155,N1156, N1157,N1158,N1159,N1160, \\note fields as indicated
  N1161,N1162,N1163,N1164, N1165,N1166,N1167,N1168, N1169,N1170,N1171,N1172, N1173,N1174,N1175,N1176, N1177,N1178,N1179,N1180, \\note fields as indicated
  N1181,N1182,N1183,N1184, N1185,N1186,N1187,N1188, N1189,N1190,N1191,N1192, N1193,N1194,N1195,N1196, N1197,N1198,N1199,N1200, \\note fields as indicated

  N1201,N1202,N1203,N1204, N1205,N1206,N1207,N1208, N1209,N1210,N1211,N1212, N1213,N1214,N1215,N1216, N1217,N1218,N1219,N1220,\\note fields as indicated
  N1221,N1222,N1223,N1224, N1225,N1226,N1227,N1228, N1229,N1230,N1231,N1232, N1233,N1234,N1235,N1236, N1237,N1238,N1239,N1240,\\note fields as indicated
  N1241,N1242,N1243,N1244, N1245,N1246,N1247,N1248, N1249,N1250,N1251,N1252, N1253,N1254,N1255,N1256, N1257,N1258,N1259,N1260,\\note fields as indicated
  N1261,N1262,N1263,N1264, N1265,N1266,N1267,N1268, N1269,N1270,N1271,N1272, N1273,N1274,N1275,N1276, N1277,N1278,N1279,N1280,\\note fields as indicated
  N1281,N1282,N1283,N1284, N1285,N1286,N1287,N1288, N1289,N1290,N1291,N1292, N1293,N1294,N1295,N1296, N1297,N1298,N1299,N1300,\\note fields as indicated

  N1301,N1302,N1303,N1304, N1305,N1306,N1307,N1308, N1309,N1310,N1311,N1312, N1313,N1314,N1315,N1316, N1317,N1318,N1319,N1320,\\note fields as indicated
  N1321,N1322,N1323,N1324, N1325,N1326,N1327,N1328, N1329,N1330,N1331,N1332, N1333,N1334,N1335,N1336, N1337,N1338,N1339,N1340,\\note fields as indicated
  N1341,N1342,N1343,N1344, N1345,N1346,N1347,N1348, N1349,N1350,N1351,N1352, N1353,N1354,N1355,N1356, N1357,N1358,N1359,N1360,\\note fields as indicated
  N1361,N1362,N1363,N1364, N1365,N1366,N1367,N1368, N1369,N1370,N1371,N1372, N1373,N1374,N1375,N1376, N1377,N1378,N1379,N1380,\\note fields as indicated
  N1381,N1382,N1383,N1384, N1385,N1386,N1387,N1388, N1389,N1390,N1391,N1392, N1393,N1394,N1395,N1396, N1397,N1398,N1399,N1400,\\note fields as indicated

  N1401,N1402,N1403,N1404, N1405,N1406,N1407,N1408, N1409,N1410,N1411,N1412, N1413,N1414,N1415,N1416, N1417,N1418,N1419,N1420,\\note fields as indicated
  N1421,N1422,N1423,N1424, N1425,N1426,N1427,N1428, N1429,N1430,N1431,N1432, N1433,N1434,N1435,N1436, N1437,N1438,N1439,N1440,\\note fields as indicated
  N1441;\\note fields as indicated

Schedule:Week:Daily,
  \\min-fields 13
       \\memo  A Schedule:Week:Daily contains 12 Schedule:Day:Hourly objects, one for each day type.
  A1 , \\field Name
       \\required-field
       \\reference WeekScheduleNames
       \\type alpha
  A2 , \\field Sunday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A3 , \\field Monday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A4 , \\field Tuesday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A5 , \\field Wednesday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A6 , \\field Thursday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A7 , \\field Friday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A8 , \\field Saturday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A9 , \\field Holiday Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A10, \\field SummerDesignDay Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A11, \\field WinterDesignDay Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A12, \\field CustomDay1 Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A13; \\field CustomDay2 Schedule:Day Name
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames

Schedule:Week:Compact,
  \\extensible:2 - repeat last two fields, remembering to remove ; from "inner" fields.
  \\memo Compact definition for Schedule:Day:List
  \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\reference WeekScheduleNames
       \\type alpha
  A2 , \\field DayType List 1
       \\begin-extensible
       \\note "For" is an optional prefix/start of the For fields. Choices can be combined on single line
       \\note if separated by spaces. i.e. "Holiday Weekends"
       \\note Should have a space after For, if it is included. i.e. "For Alldays"
       \\required-field
       \\type choice
       \\key AllDays
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A3 , \\field Schedule:Day Name 1
       \\required-field
       \\type object-list
       \\object-list DayScheduleNames
  A4 , \\field DayType List 2
       \\type choice
       \\key AllDays
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A5 , \\field Schedule:Day Name 2
       \\type object-list
       \\object-list DayScheduleNames
  A6 , \\field DayType List 3
       \\type choice
       \\key AllDays
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A7 , \\field Schedule:Day Name 3
       \\type object-list
       \\object-list DayScheduleNames
  A8 , \\field DayType List 4
       \\type choice
       \\key AllDays
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A9 , \\field Schedule:Day Name 4
       \\type object-list
       \\object-list DayScheduleNames
  A10, \\field DayType List 5
       \\type choice
       \\key AllDays
       \\key AllOtherDays
       \\key Weekdays
       \\key Weekends
       \\key Sunday
       \\key Monday
       \\key Tuesday
       \\key Wednesday
       \\key Thursday
       \\key Friday
       \\key Saturday
       \\key Holiday
       \\key SummerDesignDay
       \\key WinterDesignDay
       \\key CustomDay1
       \\key CustomDay2
  A11; \\field Schedule:Day Name 5
       \\type object-list
       \\object-list DayScheduleNames

Schedule:Year,
       \\min-fields 7
       \\extensible:5
       \\memo A Schedule:Year contains from 1 to 52 week schedules
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Schedule:Week Name 1
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list WeekScheduleNames
  N1 , \\field Start Month 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 12
  N2 , \\field Start Day 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 31
  N3 , \\field End Month 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 12
  N4 , \\field End Day 1
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 31
  A4 , \\field Schedule:Week Name 2
       \\type object-list
       \\object-list WeekScheduleNames
  N5 , \\field Start Month 2
       \\type integer
       \\minimum 1
       \\maximum 12
  N6 , \\field Start Day 2
       \\type integer
       \\minimum 1
       \\maximum 31
  N7 , \\field End Month 2
       \\type integer
       \\minimum 1
       \\maximum 12
  N8 , \\field End Day 2
       \\type integer
       \\minimum 1
       \\maximum 31
  A5 , \\field Schedule:Week Name 3
       \\type object-list
       \\object-list WeekScheduleNames
  N9 , \\field Start Month 3
       \\type integer
       \\minimum 1
       \\maximum 12
  N10, \\field Start Day 3
       \\type integer
       \\minimum 1
       \\maximum 31
  N11, \\field End Month 3
       \\type integer
       \\minimum 1
       \\maximum 12
  N12, \\field End Day 3
       \\type integer
       \\minimum 1
       \\maximum 31
  A6 , \\field Schedule:Week Name 4
       \\type object-list
       \\object-list WeekScheduleNames
  N13, \\field Start Month 4
       \\type integer
       \\minimum 1
       \\maximum 12
  N14, \\field Start Day 4
       \\type integer
       \\minimum 1
       \\maximum 31
  N15, \\field End Month 4
       \\type integer
       \\minimum 1
       \\maximum 12
  N16, \\field End Day 4
       \\type integer
       \\minimum 1
       \\maximum 31
  A7 , \\field Schedule:Week Name 5
       \\type object-list
       \\object-list WeekScheduleNames
  N17, \\field Start Month 5
       \\type integer
       \\minimum 1
       \\maximum 12
  N18, \\field Start Day 5
       \\type integer
       \\minimum 1
       \\maximum 31
  N19, \\field End Month 5
       \\type integer
       \\minimum 1
       \\maximum 12
  N20, \\field End Day 5
       \\type integer
       \\minimum 1
       \\maximum 31
  A8 , \\field Schedule:Week Name 6
       \\type object-list
       \\object-list WeekScheduleNames
  N21, \\field Start Month 6
       \\type integer
       \\minimum 1
       \\maximum 12
  N22, \\field Start Day 6
       \\type integer
       \\minimum 1
       \\maximum 31
  N23, \\field End Month 6
       \\type integer
       \\minimum 1
       \\maximum 12
  N24, \\field End Day 6
       \\type integer
       \\minimum 1
       \\maximum 31
  A9 , \\field Schedule:Week Name 7
       \\type object-list
       \\object-list WeekScheduleNames
  N25, \\field Start Month 7
       \\type integer
       \\minimum 1
       \\maximum 12
  N26, \\field Start Day 7
       \\type integer
       \\minimum 1
       \\maximum 31
  N27, \\field End Month 7
       \\type integer
       \\minimum 1
       \\maximum 12
  N28, \\field End Day 7
       \\type integer
       \\minimum 1
       \\maximum 31
  A10, \\field Schedule:Week Name 8
       \\type object-list
       \\object-list WeekScheduleNames
  N29, \\field Start Month 8
       \\type integer
       \\minimum 1
       \\maximum 12
  N30, \\field Start Day 8
       \\type integer
       \\minimum 1
       \\maximum 31
  N31, \\field End Month 8
       \\type integer
       \\minimum 1
       \\maximum 12
  N32, \\field End Day 8
       \\type integer
       \\minimum 1
       \\maximum 31
  A11, \\field Schedule:Week Name 9
       \\type object-list
       \\object-list WeekScheduleNames
  N33, \\field Start Month 9
       \\type integer
       \\minimum 1
       \\maximum 12
  N34, \\field Start Day 9
       \\type integer
       \\minimum 1
       \\maximum 31
  N35, \\field End Month 9
       \\type integer
       \\minimum 1
       \\maximum 12
  N36, \\field End Day 9
       \\type integer
       \\minimum 1
       \\maximum 31
  A12, \\field Schedule:Week Name 10
       \\type object-list
       \\object-list WeekScheduleNames
  N37, \\field Start Month 10
       \\type integer
       \\minimum 1
       \\maximum 12
  N38, \\field Start Day 10
       \\type integer
       \\minimum 1
       \\maximum 31
  N39, \\field End Month 10
       \\type integer
       \\minimum 1
       \\maximum 12
  N40, \\field End Day 10
       \\type integer
       \\minimum 1
       \\maximum 31
  A13, \\field Schedule:Week Name 11
       \\type object-list
       \\object-list WeekScheduleNames
  N41, \\field Start Month 11
       \\type integer
       \\minimum 1
       \\maximum 12
  N42, \\field Start Day 11
       \\type integer
       \\minimum 1
       \\maximum 31
  N43, \\field End Month 11
       \\type integer
       \\minimum 1
       \\maximum 12
  N44, \\field End Day 11
       \\type integer
       \\minimum 1
       \\maximum 31
  A14, \\field Schedule:Week Name 12
       \\type object-list
       \\object-list WeekScheduleNames
  N45, \\field Start Month 12
       \\type integer
       \\minimum 1
       \\maximum 12
  N46, \\field Start Day 12
       \\type integer
       \\minimum 1
       \\maximum 31
  N47, \\field End Month 12
       \\type integer
       \\minimum 1
       \\maximum 12
  N48, \\field End Day 12
       \\type integer
       \\minimum 1
       \\maximum 31
  A15, \\field Schedule:Week Name 13
       \\type object-list
       \\object-list WeekScheduleNames
  N49, \\field Start Month 13
       \\type integer
       \\minimum 1
       \\maximum 12
  N50, \\field Start Day 13
       \\type integer
       \\minimum 1
       \\maximum 31
  N51, \\field End Month 13
       \\type integer
       \\minimum 1
       \\maximum 12
  N52, \\field End Day 13
       \\type integer
       \\minimum 1
       \\maximum 31
  A16, \\field Schedule:Week Name 14
       \\type object-list
       \\object-list WeekScheduleNames
  N53, \\field Start Month 14
       \\type integer
       \\minimum 1
       \\maximum 12
  N54, \\field Start Day 14
       \\type integer
       \\minimum 1
       \\maximum 31
  N55, \\field End Month 14
       \\type integer
       \\minimum 1
       \\maximum 12
  N56, \\field End Day 14
       \\type integer
       \\minimum 1
       \\maximum 31
  A17, \\field Schedule:Week Name 15
       \\type object-list
       \\object-list WeekScheduleNames
  N57, \\field Start Month 15
       \\type integer
       \\minimum 1
       \\maximum 12
  N58, \\field Start Day 15
       \\type integer
       \\minimum 1
       \\maximum 31
  N59, \\field End Month 15
       \\type integer
       \\minimum 1
       \\maximum 12
  N60, \\field End Day 15
       \\type integer
       \\minimum 1
       \\maximum 31
  A18, \\field Schedule:Week Name 16
       \\type object-list
       \\object-list WeekScheduleNames
  N61, \\field Start Month 16
       \\type integer
       \\minimum 1
       \\maximum 12
  N62, \\field Start Day 16
       \\type integer
       \\minimum 1
       \\maximum 31
  N63, \\field End Month 16
       \\type integer
       \\minimum 1
       \\maximum 12
  N64, \\field End Day 16
       \\type integer
       \\minimum 1
       \\maximum 31
  A19, \\field Schedule:Week Name 17
       \\type object-list
       \\object-list WeekScheduleNames
  N65, \\field Start Month 17
       \\type integer
       \\minimum 1
       \\maximum 12
  N66, \\field Start Day 17
       \\type integer
       \\minimum 1
       \\maximum 31
  N67, \\field End Month 17
       \\type integer
       \\minimum 1
       \\maximum 12
  N68, \\field End Day 17
       \\type integer
       \\minimum 1
       \\maximum 31
  A20, \\field Schedule:Week Name 18
       \\type object-list
       \\object-list WeekScheduleNames
  N69, \\field Start Month 18
       \\type integer
       \\minimum 1
       \\maximum 12
  N70, \\field Start Day 18
       \\type integer
       \\minimum 1
       \\maximum 31
  N71, \\field End Month 18
       \\type integer
       \\minimum 1
       \\maximum 12
  N72, \\field End Day 18
       \\type integer
       \\minimum 1
       \\maximum 31
  A21, \\field Schedule:Week Name 19
       \\type object-list
       \\object-list WeekScheduleNames
  N73, \\field Start Month 19
       \\type integer
       \\minimum 1
       \\maximum 12
  N74, \\field Start Day 19
       \\type integer
       \\minimum 1
       \\maximum 31
  N75, \\field End Month 19
       \\type integer
       \\minimum 1
       \\maximum 12
  N76, \\field End Day 19
       \\type integer
       \\minimum 1
       \\maximum 31
  A22, \\field Schedule:Week Name 20
       \\type object-list
       \\object-list WeekScheduleNames
  N77, \\field Start Month 20
       \\type integer
       \\minimum 1
       \\maximum 12
  N78, \\field Start Day 20
       \\type integer
       \\minimum 1
       \\maximum 31
  N79, \\field End Month 20
       \\type integer
       \\minimum 1
       \\maximum 12
  N80, \\field End Day 20
       \\type integer
       \\minimum 1
       \\maximum 31
  A23, \\field Schedule:Week Name 21
       \\type object-list
       \\object-list WeekScheduleNames
  N81, \\field Start Month 21
       \\type integer
       \\minimum 1
       \\maximum 12
  N82, \\field Start Day 21
       \\type integer
       \\minimum 1
       \\maximum 31
  N83, \\field End Month 21
       \\type integer
       \\minimum 1
       \\maximum 12
  N84, \\field End Day 21
       \\type integer
       \\minimum 1
       \\maximum 31
  A24, \\field Schedule:Week Name 22
       \\type object-list
       \\object-list WeekScheduleNames
  N85, \\field Start Month 22
       \\type integer
       \\minimum 1
       \\maximum 12
  N86, \\field Start Day 22
       \\type integer
       \\minimum 1
       \\maximum 31
  N87, \\field End Month 22
       \\type integer
       \\minimum 1
       \\maximum 12
  N88, \\field End Day 22
       \\type integer
       \\minimum 1
       \\maximum 31
  A25, \\field Schedule:Week Name 23
       \\type object-list
       \\object-list WeekScheduleNames
  N89, \\field Start Month 23
       \\type integer
       \\minimum 1
       \\maximum 12
  N90, \\field Start Day 23
       \\type integer
       \\minimum 1
       \\maximum 31
  N91, \\field End Month 23
       \\type integer
       \\minimum 1
       \\maximum 12
  N92, \\field End Day 23
       \\type integer
       \\minimum 1
       \\maximum 31
  A26, \\field Schedule:Week Name 24
       \\type object-list
       \\object-list WeekScheduleNames
  N93, \\field Start Month 24
       \\type integer
       \\minimum 1
       \\maximum 12
  N94, \\field Start Day 24
       \\type integer
       \\minimum 1
       \\maximum 31
  N95, \\field End Month 24
       \\type integer
       \\minimum 1
       \\maximum 12
  N96, \\field End Day 24
       \\type integer
       \\minimum 1
       \\maximum 31
  A27, \\field Schedule:Week Name 25
       \\type object-list
       \\object-list WeekScheduleNames
  N97, \\field Start Month 25
       \\type integer
       \\minimum 1
       \\maximum 12
  N98, \\field Start Day 25
       \\type integer
       \\minimum 1
       \\maximum 31
  N99, \\field End Month 25
       \\type integer
       \\minimum 1
       \\maximum 12
 N100, \\field End Day 25
       \\type integer
       \\minimum 1
       \\maximum 31
  A28, \\field Schedule:Week Name 26
       \\type object-list
       \\object-list WeekScheduleNames
 N101, \\field Start Month 26
       \\type integer
       \\minimum 1
       \\maximum 12
 N102, \\field Start Day 26
       \\type integer
       \\minimum 1
       \\maximum 31
 N103, \\field End Month 26
       \\type integer
       \\minimum 1
       \\maximum 12
 N104, \\field End Day 26
       \\type integer
       \\minimum 1
       \\maximum 31
 \\note Schedule:Week for Weeks 27-53 are condensed
 A29,N105,N106,N107,N108, \\note For Week  27
 A30,N109,N110,N111,N112, \\note For Week  28
 A31,N113,N114,N115,N116, \\note For Week  29
 A32,N117,N118,N119,N120, \\note For Week  30
 A33,N121,N122,N123,N124, \\note For Week  31
 A34,N125,N126,N127,N128, \\note For Week  32
 A35,N129,N130,N131,N132, \\note For Week  33
 A36,N133,N134,N135,N136, \\note For Week  34
 A37,N137,N138,N139,N140, \\note For Week  35
 A38,N141,N142,N143,N144, \\note For Week  36
 A39,N145,N146,N147,N148, \\note For Week  37
 A40,N149,N150,N151,N152, \\note For Week  38
 A41,N153,N154,N155,N156, \\note For Week  39
 A42,N157,N158,N159,N160, \\note For Week  40
 A43,N161,N162,N163,N164, \\note For Week  41
 A44,N165,N166,N167,N168, \\note For Week  42
 A45,N169,N170,N171,N172, \\note For Week  43
 A46,N173,N174,N175,N176, \\note For Week  44
 A47,N177,N178,N179,N180, \\note For Week  45
 A48,N181,N182,N183,N184, \\note For Week  46
 A49,N185,N186,N187,N188, \\note For Week  47
 A50,N189,N190,N191,N192, \\note For Week  48
 A51,N193,N194,N195,N196, \\note For Week  49
 A52,N197,N198,N199,N200, \\note For Week  50
 A53,N201,N202,N203,N204, \\note For Week  51
 A54,N205,N206,N207,N208, \\note For Week  52
 A55,N209,N210,N211,N212; \\note For Week  53

Schedule:Compact,
   \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
   \\min-fields 5
   \\memo Irregular object. Does not follow the usual definition for fields. Fields A3... are:
   \\memo Through: Date
   \\memo For: Applicable days (ref: Schedule:Week:Compact)
   \\memo Interpolate: Average/Linear/No (ref: Schedule:Day:Interval) -- optional, if not used will be "No"
   \\memo Until: <Time> (ref: Schedule:Day:Interval)
   \\memo <numeric value>
   \\memo words "Through","For","Interpolate","Until" must be included.
   \\format compactSchedule
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field Field 1
       \\begin-extensible
  A4 , \\field Field 2
  A5 , \\field Field 3
  A6 , \\field Field 4
  A7 , \\field Field 5
  A8 , \\field Field 6
  A9 , \\field Field 7
  A10, \\field Field 8
  A11, \\field Field 9
  A12, \\field Field 10
  A13, \\field Field 11
  A14, \\field Field 12
  A15, \\field Field 13
  A16, \\field Field 14
  A17, \\field Field 15
  A18, \\field Field 16
  A19, \\field Field 17
  A20, \\field Field 18
  A21, \\field Field 19
  A22, \\field Field 20
  A23, \\field Field 21
  A24, \\field Field 22
  A25, \\field Field 23
  A26, \\field Field 24
  A27, \\field Field 25
  A28, \\field Field 26
  A29, \\field Field 27
  A30, \\field Field 28
  A31, \\field Field 29
  A32, \\field Field 30
  A33, \\field Field 31
  A34, \\field Field 32
  A35, \\field Field 33
  A36, \\field Field 34
  A37, \\field Field 35
  A38, \\field Field 36
  A39, \\field Field 37
  A40, \\field Field 38
  A41, \\field Field 39
  A42, \\field Field 40
  A43, \\field Field 41
  A44, \\field Field 42
  A45, \\field Field 43
  A46, \\field Field 44
  A47, \\field Field 45
  A48, \\field Field 46
  A49, \\field Field 47
  A50, \\field Field 48
  A51, \\field Field 49
  A52, \\field Field 50
  A53, \\field Field 51
  A54, \\field Field 52
  A55, \\field Field 53
  A56, \\field Field 54
  A57, \\field Field 55
  A58, \\field Field 56
  A59, \\field Field 57
  A60, \\field Field 58
  A61, \\field Field 59
  A62, \\field Field 60
  A63, \\field Field 61
  A64, \\field Field 62
  A65, \\field Field 63
  A66, \\field Field 64
  A67, \\field Field 65
  A68, \\field Field 66
  A69, \\field Field 67
  A70, \\field Field 68
  A71, \\field Field 69
  A72, \\field Field 70
  A73, \\field Field 71
  A74, \\field Field 72
  A75, \\field Field 73
  A76, \\field Field 74
  A77, \\field Field 75
  A78, \\field Field 76
  A79, \\field Field 77
  A80, \\field Field 78
  A81, \\field Field 79
  A82, \\field Field 80
  A83, \\field Field 81
  A84, \\field Field 82
  A85, \\field Field 83
  A86, \\field Field 84
  A87, \\field Field 85
  A88, \\field Field 86
  A89, \\field Field 87
  A90, \\field Field 88
  A91, \\field Field 89
  A92, \\field Field 90
  A93, \\field Field 91
  A94, \\field Field 92
  A95, \\field Field 93
  A96, \\field Field 94
  A97, \\field Field 95
  A98, \\field Field 96
  A99, \\field Field 97
  A100, \\field Field 98
  A101, \\field Field 99
  A102, \\field Field 100
  A103, \\field Field 101
  A104, \\field Field 102
  A105, \\field Field 103
  A106, \\field Field 104
  A107, \\field Field 105
  A108, \\field Field 106
  A109, \\field Field 107
  A110, \\field Field 108
  A111, \\field Field 109
  A112, \\field Field 110
  A113, \\field Field 111
  A114, \\field Field 112
  A115, \\field Field 113
  A116, \\field Field 114
  A117, \\field Field 115
  A118, \\field Field 116
  A119, \\field Field 117
  A120, \\field Field 118
  A121, \\field Field 119
  A122, \\field Field 120
  A123, \\field Field 121
  A124, \\field Field 122
  A125, \\field Field 123
  A126, \\field Field 124
  A127, \\field Field 125
  A128, \\field Field 126
  A129, \\field Field 127
  A130, \\field Field 128
  A131, \\field Field 129
  A132, \\field Field 130
  A133, \\field Field 131
  A134, \\field Field 132
  A135, \\field Field 133
  A136, \\field Field 134
  A137, \\field Field 135
  A138, \\field Field 136
  A139, \\field Field 137
  A140, \\field Field 138
  A141, \\field Field 139
  A142, \\field Field 140
  A143, \\field Field 141
  A144, \\field Field 142
  A145, \\field Field 143
  A146, \\field Field 144
  A147, \\field Field 145
  A148, \\field Field 146
  A149, \\field Field 147
  A150, \\field Field 148
  A151, \\field Field 149
  A152, \\field Field 150
  A153,A154,A155,A156,A157,A158,A159,A160, \\note fields as indicated
  A161,A162,A163,A164,A165,A166,A167,A168,A169,A170,A171,A172,A173,A174,A175,A176,A177,A178,A179,A180, \\note fields as indicated
  A181,A182,A183,A184,A185,A186,A187,A188,A189,A190,A191,A192,A193,A194,A195,A196,A197,A198,A199,A200, \\note fields as indicated
  A201,A202,A203,A204,A205,A206,A207,A208,A209,A210,A211,A212,A213,A214,A215,A216,A217,A218,A219,A220, \\note fields as indicated
  A221,A222,A223,A224,A225,A226,A227,A228,A229,A230,A231,A232,A233,A234,A235,A236,A237,A238,A239,A240, \\note fields as indicated
  A241,A242,A243,A244,A245,A246,A247,A248,A249,A250,A251,A252,A253,A254,A255,A256,A257,A258,A259,A260, \\note fields as indicated
  A261,A262,A263,A264,A265,A266,A267,A268,A269,A270,A271,A272,A273,A274,A275,A276,A277,A278,A279,A280, \\note fields as indicated
  A281,A282,A283,A284,A285,A286,A287,A288,A289,A290,A291,A292,A293,A294,A295,A296,A297,A298,A299,A300, \\note fields as indicated
  A301,A302,A303,A304,A305,A306,A307,A308,A309,A310,A311,A312,A313,A314,A315,A316,A317,A318,A319,A320, \\note fields as indicated
  A321,A322,A323,A324,A325,A326,A327,A328,A329,A330,A331,A332,A333,A334,A335,A336,A337,A338,A339,A340, \\note fields as indicated
  A341,A342,A343,A344,A345,A346,A347,A348,A349,A350,A351,A352,A353,A354,A355,A356,A357,A358,A359,A360, \\note fields as indicated
  A361,A362,A363,A364,A365,A366,A367,A368,A369,A370,A371,A372,A373,A374,A375,A376,A377,A378,A379,A380, \\note fields as indicated
  A381,A382,A383,A384,A385,A386,A387,A388,A389,A390,A391,A392,A393,A394,A395,A396,A397,A398,A399,A400, \\note fields as indicated
  A401,A402,A403,A404,A405,A406,A407,A408,A409,A410,A411,A412,A413,A414,A415,A416,A417,A418,A419,A420, \\note fields as indicated
  A421,A422,A423,A424,A425,A426,A427,A428,A429,A430,A431,A432,A433,A434,A435,A436,A437,A438,A439,A440, \\note fields as indicated
  A441,A442,A443,A444,A445,A446,A447,A448,A449,A450,A451,A452,A453,A454,A455,A456,A457,A458,A459,A460, \\note fields as indicated
  A461,A462,A463,A464,A465,A466,A467,A468,A469,A470,A471,A472,A473,A474,A475,A476,A477,A478,A479,A480, \\note fields as indicated
  A481,A482,A483,A484,A485,A486,A487,A488,A489,A490,A491,A492,A493,A494,A495,A496,A497,A498,A499,A500, \\note fields as indicated
  A501,A502,A503,A504,A505,A506,A507,A508,A509,A510,A511,A512,A513,A514,A515,A516,A517,A518,A519,A520, \\note fields as indicated
  A521,A522,A523,A524,A525,A526,A527,A528,A529,A530,A531,A532,A533,A534,A535,A536,A537,A538,A539,A540, \\note fields as indicated
  A541,A542,A543,A544,A545,A546,A547,A548,A549,A550,A551,A552,A553,A554,A555,A556,A557,A558,A559,A560, \\note fields as indicated
  A561,A562,A563,A564,A565,A566,A567,A568,A569,A570,A571,A572,A573,A574,A575,A576,A577,A578,A579,A580, \\note fields as indicated
  A581,A582,A583,A584,A585,A586,A587,A588,A589,A590,A591,A592,A593,A594,A595,A596,A597,A598,A599,A600, \\note fields as indicated
  A601,A602,A603,A604,A605,A606,A607,A608,A609,A610,A611,A612,A613,A614,A615,A616,A617,A618,A619,A620, \\note fields as indicated
  A621,A622,A623,A624,A625,A626,A627,A628,A629,A630,A631,A632,A633,A634,A635,A636,A637,A638,A639,A640, \\note fields as indicated
  A641,A642,A643,A644,A645,A646,A647,A648,A649,A650,A651,A652,A653,A654,A655,A656,A657,A658,A659,A660, \\note fields as indicated
  A661,A662,A663,A664,A665,A666,A667,A668,A669,A670,A671,A672,A673,A674,A675,A676,A677,A678,A679,A680, \\note fields as indicated
  A681,A682,A683,A684,A685,A686,A687,A688,A689,A690,A691,A692,A693,A694,A695,A696,A697,A698,A699,A700, \\note fields as indicated
  A701,A702,A703,A704,A705,A706,A707,A708,A709,A710,A711,A712,A713,A714,A715,A716,A717,A718,A719,A720, \\note fields as indicated
  A721,A722,A723,A724,A725,A726,A727,A728,A729,A730,A731,A732,A733,A734,A735,A736,A737,A738,A739,A740, \\note fields as indicated
  A741,A742,A743,A744,A745,A746,A747,A748,A749,A750,A751,A752,A753,A754,A755,A756,A757,A758,A759,A760, \\note fields as indicated
  A761,A762,A763,A764,A765,A766,A767,A768,A769,A770,A771,A772,A773,A774,A775,A776,A777,A778,A779,A780, \\note fields as indicated
  A781,A782,A783,A784,A785,A786,A787,A788,A789,A790,A791,A792,A793,A794,A795,A796,A797,A798,A799,A800, \\note fields as indicated
  A801,A802,A803,A804,A805,A806,A807,A808,A809,A810,A811,A812,A813,A814,A815,A816,A817,A818,A819,A820, \\note fields as indicated
  A821,A822,A823,A824,A825,A826,A827,A828,A829,A830,A831,A832,A833,A834,A835,A836,A837,A838,A839,A840, \\note fields as indicated
  A841,A842,A843,A844,A845,A846,A847,A848,A849,A850,A851,A852,A853,A854,A855,A856,A857,A858,A859,A860, \\note fields as indicated
  A861,A862,A863,A864,A865,A866,A867,A868,A869,A870,A871,A872,A873,A874,A875,A876,A877,A878,A879,A880, \\note fields as indicated
  A881,A882,A883,A884,A885,A886,A887,A888,A889,A890,A891,A892,A893,A894,A895,A896,A897,A898,A899,A900, \\note fields as indicated
  A901,A902,A903,A904,A905,A906,A907,A908,A909,A910,A911,A912,A913,A914,A915,A916,A917,A918,A919,A920, \\note fields as indicated
  A921,A922,A923,A924,A925,A926,A927,A928,A929,A930,A931,A932,A933,A934,A935,A936,A937,A938,A939,A940, \\note fields as indicated
  A941,A942,A943,A944,A945,A946,A947,A948,A949,A950,A951,A952,A953,A954,A955,A956,A957,A958,A959,A960, \\note fields as indicated
  A961,A962,A963,A964,A965,A966,A967,A968,A969,A970,A971,A972,A973,A974,A975,A976,A977,A978,A979,A980, \\note fields as indicated
  A981,A982,A983,A984,A985,A986,A987,A988,A989,A990,A991,A992,A993,A994,A995,A996,A997,A998,A999,A1000, \\note fields as indicated
  A1001,A1002,A1003,A1004,A1005,A1006,A1007,A1008,A1009,A1010,A1011,A1012,A1013,A1014,A1015,A1016,A1017,A1018,A1019,A1020, \\note fields as indicated
  A1021,A1022,A1023,A1024,A1025,A1026,A1027,A1028,A1029,A1030,A1031,A1032,A1033,A1034,A1035,A1036,A1037,A1038,A1039,A1040, \\note fields as indicated
  A1041,A1042,A1043,A1044,A1045,A1046,A1047,A1048,A1049,A1050,A1051,A1052,A1053,A1054,A1055,A1056,A1057,A1058,A1059,A1060, \\note fields as indicated
  A1061,A1062,A1063,A1064,A1065,A1066,A1067,A1068,A1069,A1070,A1071,A1072,A1073,A1074,A1075,A1076,A1077,A1078,A1079,A1080, \\note fields as indicated
  A1081,A1082,A1083,A1084,A1085,A1086,A1087,A1088,A1089,A1090,A1091,A1092,A1093,A1094,A1095,A1096,A1097,A1098,A1099,A1100, \\note fields as indicated
  A1101,A1102,A1103,A1104,A1105,A1106,A1107,A1108,A1109,A1110,A1111,A1112,A1113,A1114,A1115,A1116,A1117,A1118,A1119,A1120, \\note fields as indicated
  A1121,A1122,A1123,A1124,A1125,A1126,A1127,A1128,A1129,A1130,A1131,A1132,A1133,A1134,A1135,A1136,A1137,A1138,A1139,A1140, \\note fields as indicated
  A1141,A1142,A1143,A1144,A1145,A1146,A1147,A1148,A1149,A1150,A1151,A1152,A1153,A1154,A1155,A1156,A1157,A1158,A1159,A1160, \\note fields as indicated
  A1161,A1162,A1163,A1164,A1165,A1166,A1167,A1168,A1169,A1170,A1171,A1172,A1173,A1174,A1175,A1176,A1177,A1178,A1179,A1180, \\note fields as indicated
  A1181,A1182,A1183,A1184,A1185,A1186,A1187,A1188,A1189,A1190,A1191,A1192,A1193,A1194,A1195,A1196,A1197,A1198,A1199,A1200, \\note fields as indicated
  A1201,A1202,A1203,A1204,A1205,A1206,A1207,A1208,A1209,A1210,A1211,A1212,A1213,A1214,A1215,A1216,A1217,A1218,A1219,A1220, \\note fields as indicated
  A1221,A1222,A1223,A1224,A1225,A1226,A1227,A1228,A1229,A1230,A1231,A1232,A1233,A1234,A1235,A1236,A1237,A1238,A1239,A1240, \\note fields as indicated
  A1241,A1242,A1243,A1244,A1245,A1246,A1247,A1248,A1249,A1250,A1251,A1252,A1253,A1254,A1255,A1256,A1257,A1258,A1259,A1260, \\note fields as indicated
  A1261,A1262,A1263,A1264,A1265,A1266,A1267,A1268,A1269,A1270,A1271,A1272,A1273,A1274,A1275,A1276,A1277,A1278,A1279,A1280, \\note fields as indicated
  A1281,A1282,A1283,A1284,A1285,A1286,A1287,A1288,A1289,A1290,A1291,A1292,A1293,A1294,A1295,A1296,A1297,A1298,A1299,A1300, \\note fields as indicated
  A1301,A1302,A1303,A1304,A1305,A1306,A1307,A1308,A1309,A1310,A1311,A1312,A1313,A1314,A1315,A1316,A1317,A1318,A1319,A1320, \\note fields as indicated
  A1321,A1322,A1323,A1324,A1325,A1326,A1327,A1328,A1329,A1330,A1331,A1332,A1333,A1334,A1335,A1336,A1337,A1338,A1339,A1340, \\note fields as indicated
  A1341,A1342,A1343,A1344,A1345,A1346,A1347,A1348,A1349,A1350,A1351,A1352,A1353,A1354,A1355,A1356,A1357,A1358,A1359,A1360, \\note fields as indicated
  A1361,A1362,A1363,A1364,A1365,A1366,A1367,A1368,A1369,A1370,A1371,A1372,A1373,A1374,A1375,A1376,A1377,A1378,A1379,A1380, \\note fields as indicated
  A1381,A1382,A1383,A1384,A1385,A1386,A1387,A1388,A1389,A1390,A1391,A1392,A1393,A1394,A1395,A1396,A1397,A1398,A1399,A1400, \\note fields as indicated
  A1401,A1402,A1403,A1404,A1405,A1406,A1407,A1408,A1409,A1410,A1411,A1412,A1413,A1414,A1415,A1416,A1417,A1418,A1419,A1420, \\note fields as indicated
  A1421,A1422,A1423,A1424,A1425,A1426,A1427,A1428,A1429,A1430,A1431,A1432,A1433,A1434,A1435,A1436,A1437,A1438,A1439,A1440, \\note fields as indicated
  A1441,A1442,A1443,A1444,A1445,A1446,A1447,A1448,A1449,A1450,A1451,A1452,A1453,A1454,A1455,A1456,A1457,A1458,A1459,A1460, \\note fields as indicated
  A1461,A1462,A1463,A1464,A1465,A1466,A1467,A1468,A1469,A1470,A1471,A1472,A1473,A1474,A1475,A1476,A1477,A1478,A1479,A1480, \\note fields as indicated
  A1481,A1482,A1483,A1484,A1485,A1486,A1487,A1488,A1489,A1490,A1491,A1492,A1493,A1494,A1495,A1496,A1497,A1498,A1499,A1500, \\note fields as indicated
  A1501,A1502,A1503,A1504,A1505,A1506,A1507,A1508,A1509,A1510,A1511,A1512,A1513,A1514,A1515,A1516,A1517,A1518,A1519,A1520, \\note fields as indicated
  A1521,A1522,A1523,A1524,A1525,A1526,A1527,A1528,A1529,A1530,A1531,A1532,A1533,A1534,A1535,A1536,A1537,A1538,A1539,A1540, \\note fields as indicated
  A1541,A1542,A1543,A1544,A1545,A1546,A1547,A1548,A1549,A1550,A1551,A1552,A1553,A1554,A1555,A1556,A1557,A1558,A1559,A1560, \\note fields as indicated
  A1561,A1562,A1563,A1564,A1565,A1566,A1567,A1568,A1569,A1570,A1571,A1572,A1573,A1574,A1575,A1576,A1577,A1578,A1579,A1580, \\note fields as indicated
  A1581,A1582,A1583,A1584,A1585,A1586,A1587,A1588,A1589,A1590,A1591,A1592,A1593,A1594,A1595,A1596,A1597,A1598,A1599,A1600, \\note fields as indicated
  A1601,A1602,A1603,A1604,A1605,A1606,A1607,A1608,A1609,A1610,A1611,A1612,A1613,A1614,A1615,A1616,A1617,A1618,A1619,A1620, \\note fields as indicated
  A1621,A1622,A1623,A1624,A1625,A1626,A1627,A1628,A1629,A1630,A1631,A1632,A1633,A1634,A1635,A1636,A1637,A1638,A1639,A1640, \\note fields as indicated
  A1641,A1642,A1643,A1644,A1645,A1646,A1647,A1648,A1649,A1650,A1651,A1652,A1653,A1654,A1655,A1656,A1657,A1658,A1659,A1660, \\note fields as indicated
  A1661,A1662,A1663,A1664,A1665,A1666,A1667,A1668,A1669,A1670,A1671,A1672,A1673,A1674,A1675,A1676,A1677,A1678,A1679,A1680, \\note fields as indicated
  A1681,A1682,A1683,A1684,A1685,A1686,A1687,A1688,A1689,A1690,A1691,A1692,A1693,A1694,A1695,A1696,A1697,A1698,A1699,A1700, \\note fields as indicated
  A1701,A1702,A1703,A1704,A1705,A1706,A1707,A1708,A1709,A1710,A1711,A1712,A1713,A1714,A1715,A1716,A1717,A1718,A1719,A1720, \\note fields as indicated
  A1721,A1722,A1723,A1724,A1725,A1726,A1727,A1728,A1729,A1730,A1731,A1732,A1733,A1734,A1735,A1736,A1737,A1738,A1739,A1740, \\note fields as indicated
  A1741,A1742,A1743,A1744,A1745,A1746,A1747,A1748,A1749,A1750,A1751,A1752,A1753,A1754,A1755,A1756,A1757,A1758,A1759,A1760, \\note fields as indicated
  A1761,A1762,A1763,A1764,A1765,A1766,A1767,A1768,A1769,A1770,A1771,A1772,A1773,A1774,A1775,A1776,A1777,A1778,A1779,A1780, \\note fields as indicated
  A1781,A1782,A1783,A1784,A1785,A1786,A1787,A1788,A1789,A1790,A1791,A1792,A1793,A1794,A1795,A1796,A1797,A1798,A1799,A1800, \\note fields as indicated
  A1801,A1802,A1803,A1804,A1805,A1806,A1807,A1808,A1809,A1810,A1811,A1812,A1813,A1814,A1815,A1816,A1817,A1818,A1819,A1820, \\note fields as indicated
  A1821,A1822,A1823,A1824,A1825,A1826,A1827,A1828,A1829,A1830,A1831,A1832,A1833,A1834,A1835,A1836,A1837,A1838,A1839,A1840, \\note fields as indicated
  A1841,A1842,A1843,A1844,A1845,A1846,A1847,A1848,A1849,A1850,A1851,A1852,A1853,A1854,A1855,A1856,A1857,A1858,A1859,A1860, \\note fields as indicated
  A1861,A1862,A1863,A1864,A1865,A1866,A1867,A1868,A1869,A1870,A1871,A1872,A1873,A1874,A1875,A1876,A1877,A1878,A1879,A1880, \\note fields as indicated
  A1881,A1882,A1883,A1884,A1885,A1886,A1887,A1888,A1889,A1890,A1891,A1892,A1893,A1894,A1895,A1896,A1897,A1898,A1899,A1900, \\note fields as indicated
  A1901,A1902,A1903,A1904,A1905,A1906,A1907,A1908,A1909,A1910,A1911,A1912,A1913,A1914,A1915,A1916,A1917,A1918,A1919,A1920, \\note fields as indicated
  A1921,A1922,A1923,A1924,A1925,A1926,A1927,A1928,A1929,A1930,A1931,A1932,A1933,A1934,A1935,A1936,A1937,A1938,A1939,A1940, \\note fields as indicated
  A1941,A1942,A1943,A1944,A1945,A1946,A1947,A1948,A1949,A1950,A1951,A1952,A1953,A1954,A1955,A1956,A1957,A1958,A1959,A1960, \\note fields as indicated
  A1961,A1962,A1963,A1964,A1965,A1966,A1967,A1968,A1969,A1970,A1971,A1972,A1973,A1974,A1975,A1976,A1977,A1978,A1979,A1980, \\note fields as indicated
  A1981,A1982,A1983,A1984,A1985,A1986,A1987,A1988,A1989,A1990,A1991,A1992,A1993,A1994,A1995,A1996,A1997,A1998,A1999,A2000, \\note fields as indicated
  A2001,A2002,A2003,A2004,A2005,A2006,A2007,A2008,A2009,A2010,A2011,A2012,A2013,A2014,A2015,A2016,A2017,A2018,A2019,A2020, \\note fields as indicated
  A2021,A2022,A2023,A2024,A2025,A2026,A2027,A2028,A2029,A2030,A2031,A2032,A2033,A2034,A2035,A2036,A2037,A2038,A2039,A2040, \\note fields as indicated
  A2041,A2042,A2043,A2044,A2045,A2046,A2047,A2048,A2049,A2050,A2051,A2052,A2053,A2054,A2055,A2056,A2057,A2058,A2059,A2060, \\note fields as indicated
  A2061,A2062,A2063,A2064,A2065,A2066,A2067,A2068,A2069,A2070,A2071,A2072,A2073,A2074,A2075,A2076,A2077,A2078,A2079,A2080, \\note fields as indicated
  A2081,A2082,A2083,A2084,A2085,A2086,A2087,A2088,A2089,A2090,A2091,A2092,A2093,A2094,A2095,A2096,A2097,A2098,A2099,A2100, \\note fields as indicated
  A2101,A2102,A2103,A2104,A2105,A2106,A2107,A2108,A2109,A2110,A2111,A2112,A2113,A2114,A2115,A2116,A2117,A2118,A2119,A2120, \\note fields as indicated
  A2121,A2122,A2123,A2124,A2125,A2126,A2127,A2128,A2129,A2130,A2131,A2132,A2133,A2134,A2135,A2136,A2137,A2138,A2139,A2140, \\note fields as indicated
  A2141,A2142,A2143,A2144,A2145,A2146,A2147,A2148,A2149,A2150,A2151,A2152,A2153,A2154,A2155,A2156,A2157,A2158,A2159,A2160, \\note fields as indicated
  A2161,A2162,A2163,A2164,A2165,A2166,A2167,A2168,A2169,A2170,A2171,A2172,A2173,A2174,A2175,A2176,A2177,A2178,A2179,A2180, \\note fields as indicated
  A2181,A2182,A2183,A2184,A2185,A2186,A2187,A2188,A2189,A2190,A2191,A2192,A2193,A2194,A2195,A2196,A2197,A2198,A2199,A2200, \\note fields as indicated
  A2201,A2202,A2203,A2204,A2205,A2206,A2207,A2208,A2209,A2210,A2211,A2212,A2213,A2214,A2215,A2216,A2217,A2218,A2219,A2220, \\note fields as indicated
  A2221,A2222,A2223,A2224,A2225,A2226,A2227,A2228,A2229,A2230,A2231,A2232,A2233,A2234,A2235,A2236,A2237,A2238,A2239,A2240, \\note fields as indicated
  A2241,A2242,A2243,A2244,A2245,A2246,A2247,A2248,A2249,A2250,A2251,A2252,A2253,A2254,A2255,A2256,A2257,A2258,A2259,A2260, \\note fields as indicated
  A2261,A2262,A2263,A2264,A2265,A2266,A2267,A2268,A2269,A2270,A2271,A2272,A2273,A2274,A2275,A2276,A2277,A2278,A2279,A2280, \\note fields as indicated
  A2281,A2282,A2283,A2284,A2285,A2286,A2287,A2288,A2289,A2290,A2291,A2292,A2293,A2294,A2295,A2296,A2297,A2298,A2299,A2300, \\note fields as indicated
  A2301,A2302,A2303,A2304,A2305,A2306,A2307,A2308,A2309,A2310,A2311,A2312,A2313,A2314,A2315,A2316,A2317,A2318,A2319,A2320, \\note fields as indicated
  A2321,A2322,A2323,A2324,A2325,A2326,A2327,A2328,A2329,A2330,A2331,A2332,A2333,A2334,A2335,A2336,A2337,A2338,A2339,A2340, \\note fields as indicated
  A2341,A2342,A2343,A2344,A2345,A2346,A2347,A2348,A2349,A2350,A2351,A2352,A2353,A2354,A2355,A2356,A2357,A2358,A2359,A2360, \\note fields as indicated
  A2361,A2362,A2363,A2364,A2365,A2366,A2367,A2368,A2369,A2370,A2371,A2372,A2373,A2374,A2375,A2376,A2377,A2378,A2379,A2380, \\note fields as indicated
  A2381,A2382,A2383,A2384,A2385,A2386,A2387,A2388,A2389,A2390,A2391,A2392,A2393,A2394,A2395,A2396,A2397,A2398,A2399,A2400, \\note fields as indicated
  A2401,A2402,A2403,A2404,A2405,A2406,A2407,A2408,A2409,A2410,A2411,A2412,A2413,A2414,A2415,A2416,A2417,A2418,A2419,A2420, \\note fields as indicated
  A2421,A2422,A2423,A2424,A2425,A2426,A2427,A2428,A2429,A2430,A2431,A2432,A2433,A2434,A2435,A2436,A2437,A2438,A2439,A2440, \\note fields as indicated
  A2441,A2442,A2443,A2444,A2445,A2446,A2447,A2448,A2449,A2450,A2451,A2452,A2453,A2454,A2455,A2456,A2457,A2458,A2459,A2460, \\note fields as indicated
  A2461,A2462,A2463,A2464,A2465,A2466,A2467,A2468,A2469,A2470,A2471,A2472,A2473,A2474,A2475,A2476,A2477,A2478,A2479,A2480, \\note fields as indicated
  A2481,A2482,A2483,A2484,A2485,A2486,A2487,A2488,A2489,A2490,A2491,A2492,A2493,A2494,A2495,A2496,A2497,A2498,A2499,A2500, \\note fields as indicated
  A2501,A2502,A2503,A2504,A2505,A2506,A2507,A2508,A2509,A2510,A2511,A2512,A2513,A2514,A2515,A2516,A2517,A2518,A2519,A2520, \\note fields as indicated
  A2521,A2522,A2523,A2524,A2525,A2526,A2527,A2528,A2529,A2530,A2531,A2532,A2533,A2534,A2535,A2536,A2537,A2538,A2539,A2540, \\note fields as indicated
  A2541,A2542,A2543,A2544,A2545,A2546,A2547,A2548,A2549,A2550,A2551,A2552,A2553,A2554,A2555,A2556,A2557,A2558,A2559,A2560, \\note fields as indicated
  A2561,A2562,A2563,A2564,A2565,A2566,A2567,A2568,A2569,A2570,A2571,A2572,A2573,A2574,A2575,A2576,A2577,A2578,A2579,A2580, \\note fields as indicated
  A2581,A2582,A2583,A2584,A2585,A2586,A2587,A2588,A2589,A2590,A2591,A2592,A2593,A2594,A2595,A2596,A2597,A2598,A2599,A2600, \\note fields as indicated
  A2601,A2602,A2603,A2604,A2605,A2606,A2607,A2608,A2609,A2610,A2611,A2612,A2613,A2614,A2615,A2616,A2617,A2618,A2619,A2620, \\note fields as indicated
  A2621,A2622,A2623,A2624,A2625,A2626,A2627,A2628,A2629,A2630,A2631,A2632,A2633,A2634,A2635,A2636,A2637,A2638,A2639,A2640, \\note fields as indicated
  A2641,A2642,A2643,A2644,A2645,A2646,A2647,A2648,A2649,A2650,A2651,A2652,A2653,A2654,A2655,A2656,A2657,A2658,A2659,A2660, \\note fields as indicated
  A2661,A2662,A2663,A2664,A2665,A2666,A2667,A2668,A2669,A2670,A2671,A2672,A2673,A2674,A2675,A2676,A2677,A2678,A2679,A2680, \\note fields as indicated
  A2681,A2682,A2683,A2684,A2685,A2686,A2687,A2688,A2689,A2690,A2691,A2692,A2693,A2694,A2695,A2696,A2697,A2698,A2699,A2700, \\note fields as indicated
  A2701,A2702,A2703,A2704,A2705,A2706,A2707,A2708,A2709,A2710,A2711,A2712,A2713,A2714,A2715,A2716,A2717,A2718,A2719,A2720, \\note fields as indicated
  A2721,A2722,A2723,A2724,A2725,A2726,A2727,A2728,A2729,A2730,A2731,A2732,A2733,A2734,A2735,A2736,A2737,A2738,A2739,A2740, \\note fields as indicated
  A2741,A2742,A2743,A2744,A2745,A2746,A2747,A2748,A2749,A2750,A2751,A2752,A2753,A2754,A2755,A2756,A2757,A2758,A2759,A2760, \\note fields as indicated
  A2761,A2762,A2763,A2764,A2765,A2766,A2767,A2768,A2769,A2770,A2771,A2772,A2773,A2774,A2775,A2776,A2777,A2778,A2779,A2780, \\note fields as indicated
  A2781,A2782,A2783,A2784,A2785,A2786,A2787,A2788,A2789,A2790,A2791,A2792,A2793,A2794,A2795,A2796,A2797,A2798,A2799,A2800, \\note fields as indicated
  A2801,A2802,A2803,A2804,A2805,A2806,A2807,A2808,A2809,A2810,A2811,A2812,A2813,A2814,A2815,A2816,A2817,A2818,A2819,A2820, \\note fields as indicated
  A2821,A2822,A2823,A2824,A2825,A2826,A2827,A2828,A2829,A2830,A2831,A2832,A2833,A2834,A2835,A2836,A2837,A2838,A2839,A2840, \\note fields as indicated
  A2841,A2842,A2843,A2844,A2845,A2846,A2847,A2848,A2849,A2850,A2851,A2852,A2853,A2854,A2855,A2856,A2857,A2858,A2859,A2860, \\note fields as indicated
  A2861,A2862,A2863,A2864,A2865,A2866,A2867,A2868,A2869,A2870,A2871,A2872,A2873,A2874,A2875,A2876,A2877,A2878,A2879,A2880, \\note fields as indicated
  A2881,A2882,A2883,A2884,A2885,A2886,A2887,A2888,A2889,A2890,A2891,A2892,A2893,A2894,A2895,A2896,A2897,A2898,A2899,A2900, \\note fields as indicated
  A2901,A2902,A2903,A2904,A2905,A2906,A2907,A2908,A2909,A2910,A2911,A2912,A2913,A2914,A2915,A2916,A2917,A2918,A2919,A2920, \\note fields as indicated
  A2921,A2922,A2923,A2924,A2925,A2926,A2927,A2928,A2929,A2930,A2931,A2932,A2933,A2934,A2935,A2936,A2937,A2938,A2939,A2940, \\note fields as indicated
  A2941,A2942,A2943,A2944,A2945,A2946,A2947,A2948,A2949,A2950,A2951,A2952,A2953,A2954,A2955,A2956,A2957,A2958,A2959,A2960, \\note fields as indicated
  A2961,A2962,A2963,A2964,A2965,A2966,A2967,A2968,A2969,A2970,A2971,A2972,A2973,A2974,A2975,A2976,A2977,A2978,A2979,A2980, \\note fields as indicated
  A2981,A2982,A2983,A2984,A2985,A2986,A2987,A2988,A2989,A2990,A2991,A2992,A2993,A2994,A2995,A2996,A2997,A2998,A2999,A3000, \\note fields as indicated
  A3001,A3002,A3003,A3004,A3005,A3006,A3007,A3008,A3009,A3010,A3011,A3012,A3013,A3014,A3015,A3016,A3017,A3018,A3019,A3020, \\note fields as indicated
  A3021,A3022,A3023,A3024,A3025,A3026,A3027,A3028,A3029,A3030,A3031,A3032,A3033,A3034,A3035,A3036,A3037,A3038,A3039,A3040, \\note fields as indicated
  A3041,A3042,A3043,A3044,A3045,A3046,A3047,A3048,A3049,A3050,A3051,A3052,A3053,A3054,A3055,A3056,A3057,A3058,A3059,A3060, \\note fields as indicated
  A3061,A3062,A3063,A3064,A3065,A3066,A3067,A3068,A3069,A3070,A3071,A3072,A3073,A3074,A3075,A3076,A3077,A3078,A3079,A3080, \\note fields as indicated
  A3081,A3082,A3083,A3084,A3085,A3086,A3087,A3088,A3089,A3090,A3091,A3092,A3093,A3094,A3095,A3096,A3097,A3098,A3099,A3100, \\note fields as indicated
  A3101,A3102,A3103,A3104,A3105,A3106,A3107,A3108,A3109,A3110,A3111,A3112,A3113,A3114,A3115,A3116,A3117,A3118,A3119,A3120, \\note fields as indicated
  A3121,A3122,A3123,A3124,A3125,A3126,A3127,A3128,A3129,A3130,A3131,A3132,A3133,A3134,A3135,A3136,A3137,A3138,A3139,A3140, \\note fields as indicated
  A3141,A3142,A3143,A3144,A3145,A3146,A3147,A3148,A3149,A3150,A3151,A3152,A3153,A3154,A3155,A3156,A3157,A3158,A3159,A3160, \\note fields as indicated
  A3161,A3162,A3163,A3164,A3165,A3166,A3167,A3168,A3169,A3170,A3171,A3172,A3173,A3174,A3175,A3176,A3177,A3178,A3179,A3180, \\note fields as indicated
  A3181,A3182,A3183,A3184,A3185,A3186,A3187,A3188,A3189,A3190,A3191,A3192,A3193,A3194,A3195,A3196,A3197,A3198,A3199,A3200, \\note fields as indicated
  A3201,A3202,A3203,A3204,A3205,A3206,A3207,A3208,A3209,A3210,A3211,A3212,A3213,A3214,A3215,A3216,A3217,A3218,A3219,A3220, \\note fields as indicated
  A3221,A3222,A3223,A3224,A3225,A3226,A3227,A3228,A3229,A3230,A3231,A3232,A3233,A3234,A3235,A3236,A3237,A3238,A3239,A3240, \\note fields as indicated
  A3241,A3242,A3243,A3244,A3245,A3246,A3247,A3248,A3249,A3250,A3251,A3252,A3253,A3254,A3255,A3256,A3257,A3258,A3259,A3260, \\note fields as indicated
  A3261,A3262,A3263,A3264,A3265,A3266,A3267,A3268,A3269,A3270,A3271,A3272,A3273,A3274,A3275,A3276,A3277,A3278,A3279,A3280, \\note fields as indicated
  A3281,A3282,A3283,A3284,A3285,A3286,A3287,A3288,A3289,A3290,A3291,A3292,A3293,A3294,A3295,A3296,A3297,A3298,A3299,A3300, \\note fields as indicated
  A3301,A3302,A3303,A3304,A3305,A3306,A3307,A3308,A3309,A3310,A3311,A3312,A3313,A3314,A3315,A3316,A3317,A3318,A3319,A3320, \\note fields as indicated
  A3321,A3322,A3323,A3324,A3325,A3326,A3327,A3328,A3329,A3330,A3331,A3332,A3333,A3334,A3335,A3336,A3337,A3338,A3339,A3340, \\note fields as indicated
  A3341,A3342,A3343,A3344,A3345,A3346,A3347,A3348,A3349,A3350,A3351,A3352,A3353,A3354,A3355,A3356,A3357,A3358,A3359,A3360, \\note fields as indicated
  A3361,A3362,A3363,A3364,A3365,A3366,A3367,A3368,A3369,A3370,A3371,A3372,A3373,A3374,A3375,A3376,A3377,A3378,A3379,A3380, \\note fields as indicated
  A3381,A3382,A3383,A3384,A3385,A3386,A3387,A3388,A3389,A3390,A3391,A3392,A3393,A3394,A3395,A3396,A3397,A3398,A3399,A3400, \\note fields as indicated
  A3401,A3402,A3403,A3404,A3405,A3406,A3407,A3408,A3409,A3410,A3411,A3412,A3413,A3414,A3415,A3416,A3417,A3418,A3419,A3420, \\note fields as indicated
  A3421,A3422,A3423,A3424,A3425,A3426,A3427,A3428,A3429,A3430,A3431,A3432,A3433,A3434,A3435,A3436,A3437,A3438,A3439,A3440, \\note fields as indicated
  A3441,A3442,A3443,A3444,A3445,A3446,A3447,A3448,A3449,A3450,A3451,A3452,A3453,A3454,A3455,A3456,A3457,A3458,A3459,A3460, \\note fields as indicated
  A3461,A3462,A3463,A3464,A3465,A3466,A3467,A3468,A3469,A3470,A3471,A3472,A3473,A3474,A3475,A3476,A3477,A3478,A3479,A3480, \\note fields as indicated
  A3481,A3482,A3483,A3484,A3485,A3486,A3487,A3488,A3489,A3490,A3491,A3492,A3493,A3494,A3495,A3496,A3497,A3498,A3499,A3500, \\note fields as indicated
  A3501,A3502,A3503,A3504,A3505,A3506,A3507,A3508,A3509,A3510,A3511,A3512,A3513,A3514,A3515,A3516,A3517,A3518,A3519,A3520, \\note fields as indicated
  A3521,A3522,A3523,A3524,A3525,A3526,A3527,A3528,A3529,A3530,A3531,A3532,A3533,A3534,A3535,A3536,A3537,A3538,A3539,A3540, \\note fields as indicated
  A3541,A3542,A3543,A3544,A3545,A3546,A3547,A3548,A3549,A3550,A3551,A3552,A3553,A3554,A3555,A3556,A3557,A3558,A3559,A3560, \\note fields as indicated
  A3561,A3562,A3563,A3564,A3565,A3566,A3567,A3568,A3569,A3570,A3571,A3572,A3573,A3574,A3575,A3576,A3577,A3578,A3579,A3580, \\note fields as indicated
  A3581,A3582,A3583,A3584,A3585,A3586,A3587,A3588,A3589,A3590,A3591,A3592,A3593,A3594,A3595,A3596,A3597,A3598,A3599,A3600, \\note fields as indicated
  A3601,A3602,A3603,A3604,A3605,A3606,A3607,A3608,A3609,A3610,A3611,A3612,A3613,A3614,A3615,A3616,A3617,A3618,A3619,A3620, \\note fields as indicated
  A3621,A3622,A3623,A3624,A3625,A3626,A3627,A3628,A3629,A3630,A3631,A3632,A3633,A3634,A3635,A3636,A3637,A3638,A3639,A3640, \\note fields as indicated
  A3641,A3642,A3643,A3644,A3645,A3646,A3647,A3648,A3649,A3650,A3651,A3652,A3653,A3654,A3655,A3656,A3657,A3658,A3659,A3660, \\note fields as indicated
  A3661,A3662,A3663,A3664,A3665,A3666,A3667,A3668,A3669,A3670,A3671,A3672,A3673,A3674,A3675,A3676,A3677,A3678,A3679,A3680, \\note fields as indicated
  A3681,A3682,A3683,A3684,A3685,A3686,A3687,A3688,A3689,A3690,A3691,A3692,A3693,A3694,A3695,A3696,A3697,A3698,A3699,A3700, \\note fields as indicated
  A3701,A3702,A3703,A3704,A3705,A3706,A3707,A3708,A3709,A3710,A3711,A3712,A3713,A3714,A3715,A3716,A3717,A3718,A3719,A3720, \\note fields as indicated
  A3721,A3722,A3723,A3724,A3725,A3726,A3727,A3728,A3729,A3730,A3731,A3732,A3733,A3734,A3735,A3736,A3737,A3738,A3739,A3740, \\note fields as indicated
  A3741,A3742,A3743,A3744,A3745,A3746,A3747,A3748,A3749,A3750,A3751,A3752,A3753,A3754,A3755,A3756,A3757,A3758,A3759,A3760, \\note fields as indicated
  A3761,A3762,A3763,A3764,A3765,A3766,A3767,A3768,A3769,A3770,A3771,A3772,A3773,A3774,A3775,A3776,A3777,A3778,A3779,A3780, \\note fields as indicated
  A3781,A3782,A3783,A3784,A3785,A3786,A3787,A3788,A3789,A3790,A3791,A3792,A3793,A3794,A3795,A3796,A3797,A3798,A3799,A3800, \\note fields as indicated
  A3801,A3802,A3803,A3804,A3805,A3806,A3807,A3808,A3809,A3810,A3811,A3812,A3813,A3814,A3815,A3816,A3817,A3818,A3819,A3820, \\note fields as indicated
  A3821,A3822,A3823,A3824,A3825,A3826,A3827,A3828,A3829,A3830,A3831,A3832,A3833,A3834,A3835,A3836,A3837,A3838,A3839,A3840, \\note fields as indicated
  A3841,A3842,A3843,A3844,A3845,A3846,A3847,A3848,A3849,A3850,A3851,A3852,A3853,A3854,A3855,A3856,A3857,A3858,A3859,A3860, \\note fields as indicated
  A3861,A3862,A3863,A3864,A3865,A3866,A3867,A3868,A3869,A3870,A3871,A3872,A3873,A3874,A3875,A3876,A3877,A3878,A3879,A3880, \\note fields as indicated
  A3881,A3882,A3883,A3884,A3885,A3886,A3887,A3888,A3889,A3890,A3891,A3892,A3893,A3894,A3895,A3896,A3897,A3898,A3899,A3900, \\note fields as indicated
  A3901,A3902,A3903,A3904,A3905,A3906,A3907,A3908,A3909,A3910,A3911,A3912,A3913,A3914,A3915,A3916,A3917,A3918,A3919,A3920, \\note fields as indicated
  A3921,A3922,A3923,A3924,A3925,A3926,A3927,A3928,A3929,A3930,A3931,A3932,A3933,A3934,A3935,A3936,A3937,A3938,A3939,A3940, \\note fields as indicated
  A3941,A3942,A3943,A3944,A3945,A3946,A3947,A3948,A3949,A3950,A3951,A3952,A3953,A3954,A3955,A3956,A3957,A3958,A3959,A3960, \\note fields as indicated
  A3961,A3962,A3963,A3964,A3965,A3966,A3967,A3968,A3969,A3970,A3971,A3972,A3973,A3974,A3975,A3976,A3977,A3978,A3979,A3980, \\note fields as indicated
  A3981,A3982,A3983,A3984,A3985,A3986,A3987,A3988,A3989,A3990,A3991,A3992,A3993,A3994,A3995,A3996,A3997,A3998,A3999,A4000, \\note fields as indicated
  A4001,A4002,A4003,A4004,A4005,A4006,A4007,A4008,A4009,A4010,A4011,A4012,A4013,A4014,A4015,A4016,A4017,A4018,A4019,A4020, \\note fields as indicated
  A4021,A4022,A4023,A4024,A4025,A4026,A4027,A4028,A4029,A4030,A4031,A4032,A4033,A4034,A4035,A4036,A4037,A4038,A4039,A4040, \\note fields as indicated
  A4041,A4042,A4043,A4044,A4045,A4046,A4047,A4048,A4049,A4050,A4051,A4052,A4053,A4054,A4055,A4056,A4057,A4058,A4059,A4060, \\note fields as indicated
  A4061,A4062,A4063,A4064,A4065,A4066,A4067,A4068,A4069,A4070,A4071,A4072,A4073,A4074,A4075,A4076,A4077,A4078,A4079,A4080, \\note fields as indicated
  A4081,A4082,A4083,A4084,A4085,A4086,A4087,A4088,A4089,A4090,A4091,A4092,A4093,A4094,A4095,A4096,A4097,A4098,A4099,A4100, \\note fields as indicated
  A4101,A4102,A4103,A4104,A4105,A4106,A4107,A4108,A4109,A4110,A4111,A4112,A4113,A4114,A4115,A4116,A4117,A4118,A4119,A4120, \\note fields as indicated
  A4121,A4122,A4123,A4124,A4125,A4126,A4127,A4128,A4129,A4130,A4131,A4132,A4133,A4134,A4135,A4136,A4137,A4138,A4139,A4140, \\note fields as indicated
  A4141,A4142,A4143,A4144,A4145,A4146,A4147,A4148,A4149,A4150,A4151,A4152,A4153,A4154,A4155,A4156,A4157,A4158,A4159,A4160, \\note fields as indicated
  A4161,A4162,A4163,A4164,A4165,A4166,A4167,A4168,A4169,A4170,A4171,A4172,A4173,A4174,A4175,A4176,A4177,A4178,A4179,A4180, \\note fields as indicated
  A4181,A4182,A4183,A4184,A4185,A4186,A4187,A4188,A4189,A4190,A4191,A4192,A4193,A4194,A4195,A4196,A4197,A4198,A4199,A4200, \\note fields as indicated
  A4201,A4202,A4203,A4204,A4205,A4206,A4207,A4208,A4209,A4210,A4211,A4212,A4213,A4214,A4215,A4216,A4217,A4218,A4219,A4220, \\note fields as indicated
  A4221,A4222,A4223,A4224,A4225,A4226,A4227,A4228,A4229,A4230,A4231,A4232,A4233,A4234,A4235,A4236,A4237,A4238,A4239,A4240, \\note fields as indicated
  A4241,A4242,A4243,A4244,A4245,A4246,A4247,A4248,A4249,A4250,A4251,A4252,A4253,A4254,A4255,A4256,A4257,A4258,A4259,A4260, \\note fields as indicated
  A4261,A4262,A4263,A4264,A4265,A4266,A4267,A4268,A4269,A4270,A4271,A4272,A4273,A4274,A4275,A4276,A4277,A4278,A4279,A4280, \\note fields as indicated
  A4281,A4282,A4283,A4284,A4285,A4286,A4287,A4288,A4289,A4290,A4291,A4292,A4293,A4294,A4295,A4296,A4297,A4298,A4299,A4300, \\note fields as indicated
  A4301,A4302,A4303,A4304,A4305,A4306,A4307,A4308,A4309,A4310,A4311,A4312,A4313,A4314,A4315,A4316,A4317,A4318,A4319,A4320, \\note fields as indicated
  A4321,A4322,A4323,A4324,A4325,A4326,A4327,A4328,A4329,A4330,A4331,A4332,A4333,A4334,A4335,A4336,A4337,A4338,A4339,A4340, \\note fields as indicated
  A4341,A4342,A4343,A4344,A4345,A4346,A4347,A4348,A4349,A4350,A4351,A4352,A4353,A4354,A4355,A4356,A4357,A4358,A4359,A4360, \\note fields as indicated
  A4361,A4362,A4363,A4364,A4365,A4366,A4367,A4368,A4369,A4370,A4371,A4372,A4373,A4374,A4375,A4376,A4377,A4378,A4379,A4380, \\note fields as indicated
  A4381,A4382,A4383,A4384,A4385,A4386,A4387,A4388,A4389,A4390,A4391,A4392,A4393,A4394,A4395,A4396,A4397,A4398,A4399,A4400, \\note fields as indicated
  A4401,A4402,A4403,A4404,A4405,A4406,A4407,A4408,A4409,A4410,A4411,A4412,A4413,A4414,A4415,A4416,A4417,A4418,A4419,A4420, \\note fields as indicated
  A4421,A4422,A4423,A4424,A4425,A4426,A4427,A4428,A4429,A4430,A4431,A4432,A4433,A4434,A4435,A4436,A4437,A4438,A4439,A4440, \\note fields as indicated
  A4441,A4442,A4443,A4444,A4445,A4446,A4447,A4448,A4449,A4450,A4451,A4452,A4453,A4454,A4455,A4456,A4457,A4458,A4459,A4460, \\note fields as indicated
  A4461,A4462,A4463,A4464,A4465,A4466,A4467,A4468,A4469,A4470,A4471,A4472,A4473,A4474,A4475,A4476,A4477,A4478,A4479,A4480, \\note fields as indicated
  A4481,A4482,A4483,A4484,A4485,A4486,A4487,A4488,A4489,A4490,A4491,A4492,A4493,A4494,A4495,A4496,A4497,A4498,A4499,A4500, \\note fields as indicated
  A4501,A4502,A4503,A4504,A4505,A4506,A4507,A4508,A4509,A4510,A4511,A4512,A4513,A4514,A4515,A4516,A4517,A4518,A4519,A4520, \\note fields as indicated
  A4521,A4522,A4523,A4524,A4525,A4526,A4527,A4528,A4529,A4530,A4531,A4532,A4533,A4534,A4535,A4536,A4537,A4538,A4539,A4540, \\note fields as indicated
  A4541,A4542,A4543,A4544,A4545,A4546,A4547,A4548,A4549,A4550,A4551,A4552,A4553,A4554,A4555,A4556,A4557,A4558,A4559,A4560, \\note fields as indicated
  A4561,A4562,A4563,A4564,A4565,A4566,A4567,A4568,A4569,A4570,A4571,A4572,A4573,A4574,A4575,A4576,A4577,A4578,A4579,A4580, \\note fields as indicated
  A4581,A4582,A4583,A4584,A4585,A4586,A4587,A4588,A4589,A4590,A4591,A4592,A4593,A4594,A4595,A4596,A4597,A4598,A4599,A4600, \\note fields as indicated
  A4601,A4602,A4603,A4604,A4605,A4606,A4607,A4608,A4609,A4610,A4611,A4612,A4613,A4614,A4615,A4616,A4617,A4618,A4619,A4620, \\note fields as indicated
  A4621,A4622,A4623,A4624,A4625,A4626,A4627,A4628,A4629,A4630,A4631,A4632,A4633,A4634,A4635,A4636,A4637,A4638,A4639,A4640, \\note fields as indicated
  A4641,A4642,A4643,A4644,A4645,A4646,A4647,A4648,A4649,A4650,A4651,A4652,A4653,A4654,A4655,A4656,A4657,A4658,A4659,A4660, \\note fields as indicated
  A4661,A4662,A4663,A4664,A4665,A4666,A4667,A4668,A4669,A4670,A4671,A4672,A4673,A4674,A4675,A4676,A4677,A4678,A4679,A4680, \\note fields as indicated
  A4681,A4682,A4683,A4684,A4685,A4686,A4687,A4688,A4689,A4690,A4691,A4692,A4693,A4694,A4695,A4696,A4697,A4698,A4699,A4700, \\note fields as indicated
  A4701,A4702,A4703,A4704,A4705,A4706,A4707,A4708,A4709,A4710,A4711,A4712,A4713,A4714,A4715,A4716,A4717,A4718,A4719,A4720, \\note fields as indicated
  A4721,A4722,A4723,A4724,A4725,A4726,A4727,A4728,A4729,A4730,A4731,A4732,A4733,A4734,A4735,A4736,A4737,A4738,A4739,A4740, \\note fields as indicated
  A4741,A4742,A4743,A4744,A4745,A4746,A4747,A4748,A4749,A4750,A4751,A4752,A4753,A4754,A4755,A4756,A4757,A4758,A4759,A4760, \\note fields as indicated
  A4761,A4762,A4763,A4764,A4765,A4766,A4767,A4768,A4769,A4770,A4771,A4772,A4773,A4774,A4775,A4776,A4777,A4778,A4779,A4780, \\note fields as indicated
  A4781,A4782,A4783,A4784,A4785,A4786,A4787,A4788,A4789,A4790,A4791,A4792,A4793,A4794,A4795,A4796,A4797,A4798,A4799,A4800, \\note fields as indicated
  A4801,A4802,A4803,A4804,A4805,A4806,A4807,A4808,A4809,A4810,A4811,A4812,A4813,A4814,A4815,A4816,A4817,A4818,A4819,A4820, \\note fields as indicated
  A4821,A4822,A4823,A4824,A4825,A4826,A4827,A4828,A4829,A4830,A4831,A4832,A4833,A4834,A4835,A4836,A4837,A4838,A4839,A4840, \\note fields as indicated
  A4841,A4842,A4843,A4844,A4845,A4846,A4847,A4848,A4849,A4850,A4851,A4852,A4853,A4854,A4855,A4856,A4857,A4858,A4859,A4860, \\note fields as indicated
  A4861,A4862,A4863,A4864,A4865,A4866,A4867,A4868,A4869,A4870,A4871,A4872,A4873,A4874,A4875,A4876,A4877,A4878,A4879,A4880, \\note fields as indicated
  A4881,A4882,A4883,A4884,A4885,A4886,A4887,A4888,A4889,A4890,A4891,A4892,A4893,A4894,A4895,A4896,A4897,A4898,A4899,A4900, \\note fields as indicated
  A4901,A4902,A4903,A4904,A4905,A4906,A4907,A4908,A4909,A4910,A4911,A4912,A4913,A4914,A4915,A4916,A4917,A4918,A4919,A4920, \\note fields as indicated
  A4921,A4922,A4923,A4924,A4925,A4926,A4927,A4928,A4929,A4930,A4931,A4932,A4933,A4934,A4935,A4936,A4937,A4938,A4939,A4940, \\note fields as indicated
  A4941,A4942,A4943,A4944,A4945,A4946,A4947,A4948,A4949,A4950,A4951,A4952,A4953,A4954,A4955,A4956,A4957,A4958,A4959,A4960, \\note fields as indicated
  A4961,A4962,A4963,A4964,A4965,A4966,A4967,A4968,A4969,A4970,A4971,A4972,A4973,A4974,A4975,A4976,A4977,A4978,A4979,A4980, \\note fields as indicated
  A4981,A4982,A4983,A4984,A4985,A4986,A4987,A4988,A4989,A4990,A4991,A4992,A4993,A4994,A4995,A4996,A4997,A4998,A4999,A5000, \\note fields as indicated
  A5001,A5002,A5003,A5004,A5005,A5006,A5007,A5008,A5009,A5010,A5011,A5012,A5013,A5014,A5015,A5016,A5017,A5018,A5019,A5020, \\note fields as indicated
  A5021,A5022,A5023,A5024,A5025,A5026,A5027,A5028,A5029,A5030,A5031,A5032,A5033,A5034,A5035,A5036,A5037,A5038,A5039,A5040, \\note fields as indicated
  A5041,A5042,A5043,A5044,A5045,A5046,A5047,A5048,A5049,A5050,A5051,A5052,A5053,A5054,A5055,A5056,A5057,A5058,A5059,A5060, \\note fields as indicated
  A5061,A5062,A5063,A5064,A5065,A5066,A5067,A5068,A5069,A5070,A5071,A5072,A5073,A5074,A5075,A5076,A5077,A5078,A5079,A5080, \\note fields as indicated
  A5081,A5082,A5083,A5084,A5085,A5086,A5087,A5088,A5089,A5090,A5091,A5092,A5093,A5094,A5095,A5096,A5097,A5098,A5099,A5100, \\note fields as indicated
  A5101,A5102,A5103,A5104,A5105,A5106,A5107,A5108,A5109,A5110,A5111,A5112,A5113,A5114,A5115,A5116,A5117,A5118,A5119,A5120, \\note fields as indicated
  A5121,A5122,A5123,A5124,A5125,A5126,A5127,A5128,A5129,A5130,A5131,A5132,A5133,A5134,A5135,A5136,A5137,A5138,A5139,A5140, \\note fields as indicated
  A5141,A5142,A5143,A5144,A5145,A5146,A5147,A5148,A5149,A5150,A5151,A5152,A5153,A5154,A5155,A5156,A5157,A5158,A5159,A5160, \\note fields as indicated
  A5161,A5162,A5163,A5164,A5165,A5166,A5167,A5168,A5169,A5170,A5171,A5172,A5173,A5174,A5175,A5176,A5177,A5178,A5179,A5180, \\note fields as indicated
  A5181,A5182,A5183,A5184,A5185,A5186,A5187,A5188,A5189,A5190,A5191,A5192,A5193,A5194,A5195,A5196,A5197,A5198,A5199,A5200, \\note fields as indicated
  A5201,A5202,A5203,A5204,A5205,A5206,A5207,A5208,A5209,A5210,A5211,A5212,A5213,A5214,A5215,A5216,A5217,A5218,A5219,A5220, \\note fields as indicated
  A5221,A5222,A5223,A5224,A5225,A5226,A5227,A5228,A5229,A5230,A5231,A5232,A5233,A5234,A5235,A5236,A5237,A5238,A5239,A5240, \\note fields as indicated
  A5241,A5242,A5243,A5244,A5245,A5246,A5247,A5248,A5249,A5250,A5251,A5252,A5253,A5254,A5255,A5256,A5257,A5258,A5259,A5260, \\note fields as indicated
  A5261,A5262,A5263,A5264,A5265,A5266,A5267,A5268,A5269,A5270,A5271,A5272,A5273,A5274,A5275,A5276,A5277,A5278,A5279,A5280, \\note fields as indicated
  A5281,A5282,A5283,A5284,A5285,A5286,A5287,A5288,A5289,A5290,A5291,A5292,A5293,A5294,A5295,A5296,A5297,A5298,A5299,A5300, \\note fields as indicated
  A5301,A5302,A5303,A5304,A5305,A5306,A5307,A5308,A5309,A5310,A5311,A5312,A5313,A5314,A5315,A5316,A5317,A5318,A5319,A5320, \\note fields as indicated
  A5321,A5322,A5323,A5324,A5325,A5326,A5327,A5328,A5329,A5330,A5331,A5332,A5333,A5334,A5335,A5336,A5337,A5338,A5339,A5340, \\note fields as indicated
  A5341,A5342,A5343,A5344,A5345,A5346,A5347,A5348,A5349,A5350,A5351,A5352,A5353,A5354,A5355,A5356,A5357,A5358,A5359,A5360, \\note fields as indicated
  A5361,A5362,A5363,A5364,A5365,A5366,A5367,A5368,A5369,A5370,A5371,A5372,A5373,A5374,A5375,A5376,A5377,A5378,A5379,A5380, \\note fields as indicated
  A5381,A5382,A5383,A5384,A5385,A5386,A5387,A5388,A5389,A5390,A5391,A5392,A5393,A5394,A5395,A5396,A5397,A5398,A5399,A5400, \\note fields as indicated
  A5401,A5402,A5403,A5404,A5405,A5406,A5407,A5408,A5409,A5410,A5411,A5412,A5413,A5414,A5415,A5416,A5417,A5418,A5419,A5420, \\note fields as indicated
  A5421,A5422,A5423,A5424,A5425,A5426,A5427,A5428,A5429,A5430,A5431,A5432,A5433,A5434,A5435,A5436,A5437,A5438,A5439,A5440, \\note fields as indicated
  A5441,A5442,A5443,A5444,A5445,A5446,A5447,A5448,A5449,A5450,A5451,A5452,A5453,A5454,A5455,A5456,A5457,A5458,A5459,A5460, \\note fields as indicated
  A5461,A5462,A5463,A5464,A5465,A5466,A5467,A5468,A5469,A5470,A5471,A5472,A5473,A5474,A5475,A5476,A5477,A5478,A5479,A5480, \\note fields as indicated
  A5481,A5482,A5483,A5484,A5485,A5486,A5487,A5488,A5489,A5490,A5491,A5492,A5493,A5494,A5495,A5496,A5497,A5498,A5499,A5500, \\note fields as indicated
  A5501,A5502,A5503,A5504,A5505,A5506,A5507,A5508,A5509,A5510,A5511,A5512,A5513,A5514,A5515,A5516,A5517,A5518,A5519,A5520, \\note fields as indicated
  A5521,A5522,A5523,A5524,A5525,A5526,A5527,A5528,A5529,A5530,A5531,A5532,A5533,A5534,A5535,A5536,A5537,A5538,A5539,A5540, \\note fields as indicated
  A5541,A5542,A5543,A5544,A5545,A5546,A5547,A5548,A5549,A5550,A5551,A5552,A5553,A5554,A5555,A5556,A5557,A5558,A5559,A5560, \\note fields as indicated
  A5561,A5562,A5563,A5564,A5565,A5566,A5567,A5568,A5569,A5570,A5571,A5572,A5573,A5574,A5575,A5576,A5577,A5578,A5579,A5580, \\note fields as indicated
  A5581,A5582,A5583,A5584,A5585,A5586,A5587,A5588,A5589,A5590,A5591,A5592,A5593,A5594,A5595,A5596,A5597,A5598,A5599,A5600, \\note fields as indicated
  A5601,A5602,A5603,A5604,A5605,A5606,A5607,A5608,A5609,A5610,A5611,A5612,A5613,A5614,A5615,A5616,A5617,A5618,A5619,A5620, \\note fields as indicated
  A5621,A5622,A5623,A5624,A5625,A5626,A5627,A5628,A5629,A5630,A5631,A5632,A5633,A5634,A5635,A5636,A5637,A5638,A5639,A5640, \\note fields as indicated
  A5641,A5642,A5643,A5644,A5645,A5646,A5647,A5648,A5649,A5650,A5651,A5652,A5653,A5654,A5655,A5656,A5657,A5658,A5659,A5660, \\note fields as indicated
  A5661,A5662,A5663,A5664,A5665,A5666,A5667,A5668,A5669,A5670,A5671,A5672,A5673,A5674,A5675,A5676,A5677,A5678,A5679,A5680, \\note fields as indicated
  A5681,A5682,A5683,A5684,A5685,A5686,A5687,A5688,A5689,A5690,A5691,A5692,A5693,A5694,A5695,A5696,A5697,A5698,A5699,A5700, \\note fields as indicated
  A5701,A5702,A5703,A5704,A5705,A5706,A5707,A5708,A5709,A5710,A5711,A5712,A5713,A5714,A5715,A5716,A5717,A5718,A5719,A5720, \\note fields as indicated
  A5721,A5722,A5723,A5724,A5725,A5726,A5727,A5728,A5729,A5730,A5731,A5732,A5733,A5734,A5735,A5736,A5737,A5738,A5739,A5740, \\note fields as indicated
  A5741,A5742,A5743,A5744,A5745,A5746,A5747,A5748,A5749,A5750,A5751,A5752,A5753,A5754,A5755,A5756,A5757,A5758,A5759,A5760, \\note fields as indicated
  A5761,A5762,A5763,A5764,A5765,A5766,A5767,A5768,A5769,A5770,A5771,A5772,A5773,A5774,A5775,A5776,A5777,A5778,A5779,A5780, \\note fields as indicated
  A5781,A5782,A5783,A5784,A5785,A5786,A5787,A5788,A5789,A5790,A5791,A5792,A5793,A5794,A5795,A5796,A5797,A5798,A5799,A5800, \\note fields as indicated
  A5801,A5802,A5803,A5804,A5805,A5806,A5807,A5808,A5809,A5810,A5811,A5812,A5813,A5814,A5815,A5816,A5817,A5818,A5819,A5820, \\note fields as indicated
  A5821,A5822,A5823,A5824,A5825,A5826,A5827,A5828,A5829,A5830,A5831,A5832,A5833,A5834,A5835,A5836,A5837,A5838,A5839,A5840, \\note fields as indicated
  A5841,A5842,A5843,A5844,A5845,A5846,A5847,A5848,A5849,A5850,A5851,A5852,A5853,A5854,A5855,A5856,A5857,A5858,A5859,A5860, \\note fields as indicated
  A5861,A5862,A5863,A5864,A5865,A5866,A5867,A5868,A5869,A5870,A5871,A5872,A5873,A5874,A5875,A5876,A5877,A5878,A5879,A5880, \\note fields as indicated
  A5881,A5882,A5883,A5884,A5885,A5886,A5887,A5888,A5889,A5890,A5891,A5892,A5893,A5894,A5895,A5896,A5897,A5898,A5899,A5900, \\note fields as indicated
  A5901,A5902,A5903,A5904,A5905,A5906,A5907,A5908,A5909,A5910,A5911,A5912,A5913,A5914,A5915,A5916,A5917,A5918,A5919,A5920, \\note fields as indicated
  A5921,A5922,A5923,A5924,A5925,A5926,A5927,A5928,A5929,A5930,A5931,A5932,A5933,A5934,A5935,A5936,A5937,A5938,A5939,A5940, \\note fields as indicated
  A5941,A5942,A5943,A5944,A5945,A5946,A5947,A5948,A5949,A5950,A5951,A5952,A5953,A5954,A5955,A5956,A5957,A5958,A5959,A5960, \\note fields as indicated
  A5961,A5962,A5963,A5964,A5965,A5966,A5967,A5968,A5969,A5970,A5971,A5972,A5973,A5974,A5975,A5976,A5977,A5978,A5979,A5980, \\note fields as indicated
  A5981,A5982,A5983,A5984,A5985,A5986,A5987,A5988,A5989,A5990,A5991,A5992,A5993,A5994,A5995,A5996,A5997,A5998,A5999,A6000, \\note fields as indicated
  A6001,A6002,A6003,A6004,A6005,A6006,A6007,A6008,A6009,A6010,A6011,A6012,A6013,A6014,A6015,A6016,A6017,A6018,A6019,A6020, \\note fields as indicated
  A6021,A6022,A6023,A6024,A6025,A6026,A6027,A6028,A6029,A6030,A6031,A6032,A6033,A6034,A6035,A6036,A6037,A6038,A6039,A6040, \\note fields as indicated
  A6041,A6042,A6043,A6044,A6045,A6046,A6047,A6048,A6049,A6050,A6051,A6052,A6053,A6054,A6055,A6056,A6057,A6058,A6059,A6060, \\note fields as indicated
  A6061,A6062,A6063,A6064,A6065,A6066,A6067,A6068,A6069,A6070,A6071,A6072,A6073,A6074,A6075,A6076,A6077,A6078,A6079,A6080, \\note fields as indicated
  A6081,A6082,A6083,A6084,A6085,A6086,A6087,A6088,A6089,A6090,A6091,A6092,A6093,A6094,A6095,A6096,A6097,A6098,A6099,A6100, \\note fields as indicated
  A6101,A6102,A6103,A6104,A6105,A6106,A6107,A6108,A6109,A6110,A6111,A6112,A6113,A6114,A6115,A6116,A6117,A6118,A6119,A6120, \\note fields as indicated
  A6121,A6122,A6123,A6124,A6125,A6126,A6127,A6128,A6129,A6130,A6131,A6132,A6133,A6134,A6135,A6136,A6137,A6138,A6139,A6140, \\note fields as indicated
  A6141,A6142,A6143,A6144,A6145,A6146,A6147,A6148,A6149,A6150,A6151,A6152,A6153,A6154,A6155,A6156,A6157,A6158,A6159,A6160, \\note fields as indicated
  A6161,A6162,A6163,A6164,A6165,A6166,A6167,A6168,A6169,A6170,A6171,A6172,A6173,A6174,A6175,A6176,A6177,A6178,A6179,A6180, \\note fields as indicated
  A6181,A6182,A6183,A6184,A6185,A6186,A6187,A6188,A6189,A6190,A6191,A6192,A6193,A6194,A6195,A6196,A6197,A6198,A6199,A6200, \\note fields as indicated
  A6201,A6202,A6203,A6204,A6205,A6206,A6207,A6208,A6209,A6210,A6211,A6212,A6213,A6214,A6215,A6216,A6217,A6218,A6219,A6220, \\note fields as indicated
  A6221,A6222,A6223,A6224,A6225,A6226,A6227,A6228,A6229,A6230,A6231,A6232,A6233,A6234,A6235,A6236,A6237,A6238,A6239,A6240, \\note fields as indicated
  A6241,A6242,A6243,A6244,A6245,A6246,A6247,A6248,A6249,A6250,A6251,A6252,A6253,A6254,A6255,A6256,A6257,A6258,A6259,A6260, \\note fields as indicated
  A6261,A6262,A6263,A6264,A6265,A6266,A6267,A6268,A6269,A6270,A6271,A6272,A6273,A6274,A6275,A6276,A6277,A6278,A6279,A6280, \\note fields as indicated
  A6281,A6282,A6283,A6284,A6285,A6286,A6287,A6288,A6289,A6290,A6291,A6292,A6293,A6294,A6295,A6296,A6297,A6298,A6299,A6300, \\note fields as indicated
  A6301,A6302,A6303,A6304,A6305,A6306,A6307,A6308,A6309,A6310,A6311,A6312,A6313,A6314,A6315,A6316,A6317,A6318,A6319,A6320, \\note fields as indicated
  A6321,A6322,A6323,A6324,A6325,A6326,A6327,A6328,A6329,A6330,A6331,A6332,A6333,A6334,A6335,A6336,A6337,A6338,A6339,A6340, \\note fields as indicated
  A6341,A6342,A6343,A6344,A6345,A6346,A6347,A6348,A6349,A6350,A6351,A6352,A6353,A6354,A6355,A6356,A6357,A6358,A6359,A6360, \\note fields as indicated
  A6361,A6362,A6363,A6364,A6365,A6366,A6367,A6368,A6369,A6370,A6371,A6372,A6373,A6374,A6375,A6376,A6377,A6378,A6379,A6380, \\note fields as indicated
  A6381,A6382,A6383,A6384,A6385,A6386,A6387,A6388,A6389,A6390,A6391,A6392,A6393,A6394,A6395,A6396,A6397,A6398,A6399,A6400, \\note fields as indicated
  A6401,A6402,A6403,A6404,A6405,A6406,A6407,A6408,A6409,A6410,A6411,A6412,A6413,A6414,A6415,A6416,A6417,A6418,A6419,A6420, \\note fields as indicated
  A6421,A6422,A6423,A6424,A6425,A6426,A6427,A6428,A6429,A6430,A6431,A6432,A6433,A6434,A6435,A6436,A6437,A6438,A6439,A6440, \\note fields as indicated
  A6441,A6442,A6443,A6444,A6445,A6446,A6447,A6448,A6449,A6450,A6451,A6452,A6453,A6454,A6455,A6456,A6457,A6458,A6459,A6460, \\note fields as indicated
  A6461,A6462,A6463,A6464,A6465,A6466,A6467,A6468,A6469,A6470,A6471,A6472,A6473,A6474,A6475,A6476,A6477,A6478,A6479,A6480, \\note fields as indicated
  A6481,A6482,A6483,A6484,A6485,A6486,A6487,A6488,A6489,A6490,A6491,A6492,A6493,A6494,A6495,A6496,A6497,A6498,A6499,A6500, \\note fields as indicated
  A6501,A6502,A6503,A6504,A6505,A6506,A6507,A6508,A6509,A6510,A6511,A6512,A6513,A6514,A6515,A6516,A6517,A6518,A6519,A6520, \\note fields as indicated
  A6521,A6522,A6523,A6524,A6525,A6526,A6527,A6528,A6529,A6530,A6531,A6532,A6533,A6534,A6535,A6536,A6537,A6538,A6539,A6540, \\note fields as indicated
  A6541,A6542,A6543,A6544,A6545,A6546,A6547,A6548,A6549,A6550,A6551,A6552,A6553,A6554,A6555,A6556,A6557,A6558,A6559,A6560, \\note fields as indicated
  A6561,A6562,A6563,A6564,A6565,A6566,A6567,A6568,A6569,A6570,A6571,A6572,A6573,A6574,A6575,A6576,A6577,A6578,A6579,A6580, \\note fields as indicated
  A6581,A6582,A6583,A6584,A6585,A6586,A6587,A6588,A6589,A6590,A6591,A6592,A6593,A6594,A6595,A6596,A6597,A6598,A6599,A6600, \\note fields as indicated
  A6601,A6602,A6603,A6604,A6605,A6606,A6607,A6608,A6609,A6610,A6611,A6612,A6613,A6614,A6615,A6616,A6617,A6618,A6619,A6620, \\note fields as indicated
  A6621,A6622,A6623,A6624,A6625,A6626,A6627,A6628,A6629,A6630,A6631,A6632,A6633,A6634,A6635,A6636,A6637,A6638,A6639,A6640, \\note fields as indicated
  A6641,A6642,A6643,A6644,A6645,A6646,A6647,A6648,A6649,A6650,A6651,A6652,A6653,A6654,A6655,A6656,A6657,A6658,A6659,A6660, \\note fields as indicated
  A6661,A6662,A6663,A6664,A6665,A6666,A6667,A6668,A6669,A6670,A6671,A6672,A6673,A6674,A6675,A6676,A6677,A6678,A6679,A6680, \\note fields as indicated
  A6681,A6682,A6683,A6684,A6685,A6686,A6687,A6688,A6689,A6690,A6691,A6692,A6693,A6694,A6695,A6696,A6697,A6698,A6699,A6700, \\note fields as indicated
  A6701,A6702,A6703,A6704,A6705,A6706,A6707,A6708,A6709,A6710,A6711,A6712,A6713,A6714,A6715,A6716,A6717,A6718,A6719,A6720, \\note fields as indicated
  A6721,A6722,A6723,A6724,A6725,A6726,A6727,A6728,A6729,A6730,A6731,A6732,A6733,A6734,A6735,A6736,A6737,A6738,A6739,A6740, \\note fields as indicated
  A6741,A6742,A6743,A6744,A6745,A6746,A6747,A6748,A6749,A6750,A6751,A6752,A6753,A6754,A6755,A6756,A6757,A6758,A6759,A6760, \\note fields as indicated
  A6761,A6762,A6763,A6764,A6765,A6766,A6767,A6768,A6769,A6770,A6771,A6772,A6773,A6774,A6775,A6776,A6777,A6778,A6779,A6780, \\note fields as indicated
  A6781,A6782,A6783,A6784,A6785,A6786,A6787,A6788,A6789,A6790,A6791,A6792,A6793,A6794,A6795,A6796,A6797,A6798,A6799,A6800, \\note fields as indicated
  A6801,A6802,A6803,A6804,A6805,A6806,A6807,A6808,A6809,A6810,A6811,A6812,A6813,A6814,A6815,A6816,A6817,A6818,A6819,A6820, \\note fields as indicated
  A6821,A6822,A6823,A6824,A6825,A6826,A6827,A6828,A6829,A6830,A6831,A6832,A6833,A6834,A6835,A6836,A6837,A6838,A6839,A6840, \\note fields as indicated
  A6841,A6842,A6843,A6844,A6845,A6846,A6847,A6848,A6849,A6850,A6851,A6852,A6853,A6854,A6855,A6856,A6857,A6858,A6859,A6860, \\note fields as indicated
  A6861,A6862,A6863,A6864,A6865,A6866,A6867,A6868,A6869,A6870,A6871,A6872,A6873,A6874,A6875,A6876,A6877,A6878,A6879,A6880, \\note fields as indicated
  A6881,A6882,A6883,A6884,A6885,A6886,A6887,A6888,A6889,A6890,A6891,A6892,A6893,A6894,A6895,A6896,A6897,A6898,A6899,A6900, \\note fields as indicated
  A6901,A6902,A6903,A6904,A6905,A6906,A6907,A6908,A6909,A6910,A6911,A6912,A6913,A6914,A6915,A6916,A6917,A6918,A6919,A6920, \\note fields as indicated
  A6921,A6922,A6923,A6924,A6925,A6926,A6927,A6928,A6929,A6930,A6931,A6932,A6933,A6934,A6935,A6936,A6937,A6938,A6939,A6940, \\note fields as indicated
  A6941,A6942,A6943,A6944,A6945,A6946,A6947,A6948,A6949,A6950,A6951,A6952,A6953,A6954,A6955,A6956,A6957,A6958,A6959,A6960, \\note fields as indicated
  A6961,A6962,A6963,A6964,A6965,A6966,A6967,A6968,A6969,A6970,A6971,A6972,A6973,A6974,A6975,A6976,A6977,A6978,A6979,A6980, \\note fields as indicated
  A6981,A6982,A6983,A6984,A6985,A6986,A6987,A6988,A6989,A6990,A6991,A6992,A6993,A6994,A6995,A6996,A6997,A6998,A6999,A7000, \\note fields as indicated
  A7001,A7002,A7003,A7004,A7005,A7006,A7007,A7008,A7009,A7010,A7011,A7012,A7013,A7014,A7015,A7016,A7017,A7018,A7019,A7020, \\note fields as indicated
  A7021,A7022,A7023,A7024,A7025,A7026,A7027,A7028,A7029,A7030,A7031,A7032,A7033,A7034,A7035,A7036,A7037,A7038,A7039,A7040, \\note fields as indicated
  A7041,A7042,A7043,A7044,A7045,A7046,A7047,A7048,A7049,A7050,A7051,A7052,A7053,A7054,A7055,A7056,A7057,A7058,A7059,A7060, \\note fields as indicated
  A7061,A7062,A7063,A7064,A7065,A7066,A7067,A7068,A7069,A7070,A7071,A7072,A7073,A7074,A7075,A7076,A7077,A7078,A7079,A7080, \\note fields as indicated
  A7081,A7082,A7083,A7084,A7085,A7086,A7087,A7088,A7089,A7090,A7091,A7092,A7093,A7094,A7095,A7096,A7097,A7098,A7099,A7100, \\note fields as indicated
  A7101,A7102,A7103,A7104,A7105,A7106,A7107,A7108,A7109,A7110,A7111,A7112,A7113,A7114,A7115,A7116,A7117,A7118,A7119,A7120, \\note fields as indicated
  A7121,A7122,A7123,A7124,A7125,A7126,A7127,A7128,A7129,A7130,A7131,A7132,A7133,A7134,A7135,A7136,A7137,A7138,A7139,A7140, \\note fields as indicated
  A7141,A7142,A7143,A7144,A7145,A7146,A7147,A7148,A7149,A7150,A7151,A7152,A7153,A7154,A7155,A7156,A7157,A7158,A7159,A7160, \\note fields as indicated
  A7161,A7162,A7163,A7164,A7165,A7166,A7167,A7168,A7169,A7170,A7171,A7172,A7173,A7174,A7175,A7176,A7177,A7178,A7179,A7180, \\note fields as indicated
  A7181,A7182,A7183,A7184,A7185,A7186,A7187,A7188,A7189,A7190,A7191,A7192,A7193,A7194,A7195,A7196,A7197,A7198,A7199,A7200, \\note fields as indicated
  A7201,A7202,A7203,A7204,A7205,A7206,A7207,A7208,A7209,A7210,A7211,A7212,A7213,A7214,A7215,A7216,A7217,A7218,A7219,A7220, \\note fields as indicated
  A7221,A7222,A7223,A7224,A7225,A7226,A7227,A7228,A7229,A7230,A7231,A7232,A7233,A7234,A7235,A7236,A7237,A7238,A7239,A7240, \\note fields as indicated
  A7241,A7242,A7243,A7244,A7245,A7246,A7247,A7248,A7249,A7250,A7251,A7252,A7253,A7254,A7255,A7256,A7257,A7258,A7259,A7260, \\note fields as indicated
  A7261,A7262,A7263,A7264,A7265,A7266,A7267,A7268,A7269,A7270,A7271,A7272,A7273,A7274,A7275,A7276,A7277,A7278,A7279,A7280, \\note fields as indicated
  A7281,A7282,A7283,A7284,A7285,A7286,A7287,A7288,A7289,A7290,A7291,A7292,A7293,A7294,A7295,A7296,A7297,A7298,A7299,A7300, \\note fields as indicated
  A7301,A7302,A7303,A7304,A7305,A7306,A7307,A7308,A7309,A7310,A7311,A7312,A7313,A7314,A7315,A7316,A7317,A7318,A7319,A7320, \\note fields as indicated
  A7321,A7322,A7323,A7324,A7325,A7326,A7327,A7328,A7329,A7330,A7331,A7332,A7333,A7334,A7335,A7336,A7337,A7338,A7339,A7340, \\note fields as indicated
  A7341,A7342,A7343,A7344,A7345,A7346,A7347,A7348,A7349,A7350,A7351,A7352,A7353,A7354,A7355,A7356,A7357,A7358,A7359,A7360, \\note fields as indicated
  A7361,A7362,A7363,A7364,A7365,A7366,A7367,A7368,A7369,A7370,A7371,A7372,A7373,A7374,A7375,A7376,A7377,A7378,A7379,A7380, \\note fields as indicated
  A7381,A7382,A7383,A7384,A7385,A7386,A7387,A7388,A7389,A7390,A7391,A7392,A7393,A7394,A7395,A7396,A7397,A7398,A7399,A7400, \\note fields as indicated
  A7401,A7402,A7403,A7404,A7405,A7406,A7407,A7408,A7409,A7410,A7411,A7412,A7413,A7414,A7415,A7416,A7417,A7418,A7419,A7420, \\note fields as indicated
  A7421,A7422,A7423,A7424,A7425,A7426,A7427,A7428,A7429,A7430,A7431,A7432,A7433,A7434,A7435,A7436,A7437,A7438,A7439,A7440, \\note fields as indicated
  A7441,A7442,A7443,A7444,A7445,A7446,A7447,A7448,A7449,A7450,A7451,A7452,A7453,A7454,A7455,A7456,A7457,A7458,A7459,A7460, \\note fields as indicated
  A7461,A7462,A7463,A7464,A7465,A7466,A7467,A7468,A7469,A7470,A7471,A7472,A7473,A7474,A7475,A7476,A7477,A7478,A7479,A7480, \\note fields as indicated
  A7481,A7482,A7483,A7484,A7485,A7486,A7487,A7488,A7489,A7490,A7491,A7492,A7493,A7494,A7495,A7496,A7497,A7498,A7499,A7500, \\note fields as indicated
  A7501,A7502,A7503,A7504,A7505,A7506,A7507,A7508,A7509,A7510,A7511,A7512,A7513,A7514,A7515,A7516,A7517,A7518,A7519,A7520, \\note fields as indicated
  A7521,A7522,A7523,A7524,A7525,A7526,A7527,A7528,A7529,A7530,A7531,A7532,A7533,A7534,A7535,A7536,A7537,A7538,A7539,A7540, \\note fields as indicated
  A7541,A7542,A7543,A7544,A7545,A7546,A7547,A7548,A7549,A7550,A7551,A7552,A7553,A7554,A7555,A7556,A7557,A7558,A7559,A7560, \\note fields as indicated
  A7561,A7562,A7563,A7564,A7565,A7566,A7567,A7568,A7569,A7570,A7571,A7572,A7573,A7574,A7575,A7576,A7577,A7578,A7579,A7580, \\note fields as indicated
  A7581,A7582,A7583,A7584,A7585,A7586,A7587,A7588,A7589,A7590,A7591,A7592,A7593,A7594,A7595,A7596,A7597,A7598,A7599,A7600, \\note fields as indicated
  A7601,A7602,A7603,A7604,A7605,A7606,A7607,A7608,A7609,A7610,A7611,A7612,A7613,A7614,A7615,A7616,A7617,A7618,A7619,A7620, \\note fields as indicated
  A7621,A7622,A7623,A7624,A7625,A7626,A7627,A7628,A7629,A7630,A7631,A7632,A7633,A7634,A7635,A7636,A7637,A7638,A7639,A7640, \\note fields as indicated
  A7641,A7642,A7643,A7644,A7645,A7646,A7647,A7648,A7649,A7650,A7651,A7652,A7653,A7654,A7655,A7656,A7657,A7658,A7659,A7660, \\note fields as indicated
  A7661,A7662,A7663,A7664,A7665,A7666,A7667,A7668,A7669,A7670,A7671,A7672,A7673,A7674,A7675,A7676,A7677,A7678,A7679,A7680, \\note fields as indicated
  A7681,A7682,A7683,A7684,A7685,A7686,A7687,A7688,A7689,A7690,A7691,A7692,A7693,A7694,A7695,A7696,A7697,A7698,A7699,A7700, \\note fields as indicated
  A7701,A7702,A7703,A7704,A7705,A7706,A7707,A7708,A7709,A7710,A7711,A7712,A7713,A7714,A7715,A7716,A7717,A7718,A7719,A7720, \\note fields as indicated
  A7721,A7722,A7723,A7724,A7725,A7726,A7727,A7728,A7729,A7730,A7731,A7732,A7733,A7734,A7735,A7736,A7737,A7738,A7739,A7740, \\note fields as indicated
  A7741,A7742,A7743,A7744,A7745,A7746,A7747,A7748,A7749,A7750,A7751,A7752,A7753,A7754,A7755,A7756,A7757,A7758,A7759,A7760, \\note fields as indicated
  A7761,A7762,A7763,A7764,A7765,A7766,A7767,A7768,A7769,A7770,A7771,A7772,A7773,A7774,A7775,A7776,A7777,A7778,A7779,A7780, \\note fields as indicated
  A7781,A7782,A7783,A7784,A7785,A7786,A7787,A7788,A7789,A7790,A7791,A7792,A7793,A7794,A7795,A7796,A7797,A7798,A7799,A7800, \\note fields as indicated
  A7801,A7802,A7803,A7804,A7805,A7806,A7807,A7808,A7809,A7810,A7811,A7812,A7813,A7814,A7815,A7816,A7817,A7818,A7819,A7820, \\note fields as indicated
  A7821,A7822,A7823,A7824,A7825,A7826,A7827,A7828,A7829,A7830,A7831,A7832,A7833,A7834,A7835,A7836,A7837,A7838,A7839,A7840, \\note fields as indicated
  A7841,A7842,A7843,A7844,A7845,A7846,A7847,A7848,A7849,A7850,A7851,A7852,A7853,A7854,A7855,A7856,A7857,A7858,A7859,A7860, \\note fields as indicated
  A7861,A7862,A7863,A7864,A7865,A7866,A7867,A7868,A7869,A7870,A7871,A7872,A7873,A7874,A7875,A7876,A7877,A7878,A7879,A7880, \\note fields as indicated
  A7881,A7882,A7883,A7884,A7885,A7886,A7887,A7888,A7889,A7890,A7891,A7892,A7893,A7894,A7895,A7896,A7897,A7898,A7899,A7900, \\note fields as indicated
  A7901,A7902,A7903,A7904,A7905,A7906,A7907,A7908,A7909,A7910,A7911,A7912,A7913,A7914,A7915,A7916,A7917,A7918,A7919,A7920, \\note fields as indicated
  A7921,A7922,A7923,A7924,A7925,A7926,A7927,A7928,A7929,A7930,A7931,A7932,A7933,A7934,A7935,A7936,A7937,A7938,A7939,A7940, \\note fields as indicated
  A7941,A7942,A7943,A7944,A7945,A7946,A7947,A7948,A7949,A7950,A7951,A7952,A7953,A7954,A7955,A7956,A7957,A7958,A7959,A7960, \\note fields as indicated
  A7961,A7962,A7963,A7964,A7965,A7966,A7967,A7968,A7969,A7970,A7971,A7972,A7973,A7974,A7975,A7976,A7977,A7978,A7979,A7980, \\note fields as indicated
  A7981,A7982,A7983,A7984,A7985,A7986,A7987,A7988,A7989,A7990,A7991,A7992,A7993,A7994,A7995,A7996,A7997,A7998,A7999,A8000, \\note fields as indicated
  A8001,A8002,A8003,A8004,A8005,A8006,A8007,A8008,A8009,A8010,A8011,A8012,A8013,A8014,A8015,A8016,A8017,A8018,A8019,A8020, \\note fields as indicated
  A8021,A8022,A8023,A8024,A8025,A8026,A8027,A8028,A8029,A8030,A8031,A8032,A8033,A8034,A8035,A8036,A8037,A8038,A8039,A8040, \\note fields as indicated
  A8041,A8042,A8043,A8044,A8045,A8046,A8047,A8048,A8049,A8050,A8051,A8052,A8053,A8054,A8055,A8056,A8057,A8058,A8059,A8060, \\note fields as indicated
  A8061,A8062,A8063,A8064,A8065,A8066,A8067,A8068,A8069,A8070,A8071,A8072,A8073,A8074,A8075,A8076,A8077,A8078,A8079,A8080, \\note fields as indicated
  A8081,A8082,A8083,A8084,A8085,A8086,A8087,A8088,A8089,A8090,A8091,A8092,A8093,A8094,A8095,A8096,A8097,A8098,A8099,A8100, \\note fields as indicated
  A8101,A8102,A8103,A8104,A8105,A8106,A8107,A8108,A8109,A8110,A8111,A8112,A8113,A8114,A8115,A8116,A8117,A8118,A8119,A8120, \\note fields as indicated
  A8121,A8122,A8123,A8124,A8125,A8126,A8127,A8128,A8129,A8130,A8131,A8132,A8133,A8134,A8135,A8136,A8137,A8138,A8139,A8140, \\note fields as indicated
  A8141,A8142,A8143,A8144,A8145,A8146,A8147,A8148,A8149,A8150,A8151,A8152,A8153,A8154,A8155,A8156,A8157,A8158,A8159,A8160, \\note fields as indicated
  A8161,A8162,A8163,A8164,A8165,A8166,A8167,A8168,A8169,A8170,A8171,A8172,A8173,A8174,A8175,A8176,A8177,A8178,A8179,A8180, \\note fields as indicated
  A8181,A8182,A8183,A8184,A8185,A8186,A8187,A8188,A8189,A8190,A8191,A8192,A8193,A8194,A8195,A8196,A8197,A8198,A8199,A8200, \\note fields as indicated
  A8201,A8202,A8203,A8204,A8205,A8206,A8207,A8208,A8209,A8210,A8211,A8212,A8213,A8214,A8215,A8216,A8217,A8218,A8219,A8220, \\note fields as indicated
  A8221,A8222,A8223,A8224,A8225,A8226,A8227,A8228,A8229,A8230,A8231,A8232,A8233,A8234,A8235,A8236,A8237,A8238,A8239,A8240, \\note fields as indicated
  A8241,A8242,A8243,A8244,A8245,A8246,A8247,A8248,A8249,A8250,A8251,A8252,A8253,A8254,A8255,A8256,A8257,A8258,A8259,A8260, \\note fields as indicated
  A8261,A8262,A8263,A8264,A8265,A8266,A8267,A8268,A8269,A8270,A8271,A8272,A8273,A8274,A8275,A8276,A8277,A8278,A8279,A8280, \\note fields as indicated
  A8281,A8282,A8283,A8284,A8285,A8286,A8287,A8288,A8289,A8290,A8291,A8292,A8293,A8294,A8295,A8296,A8297,A8298,A8299,A8300, \\note fields as indicated
  A8301,A8302,A8303,A8304,A8305,A8306,A8307,A8308,A8309,A8310,A8311,A8312,A8313,A8314,A8315,A8316,A8317,A8318,A8319,A8320, \\note fields as indicated
  A8321,A8322,A8323,A8324,A8325,A8326,A8327,A8328,A8329,A8330,A8331,A8332,A8333,A8334,A8335,A8336,A8337,A8338,A8339,A8340, \\note fields as indicated
  A8341,A8342,A8343,A8344,A8345,A8346,A8347,A8348,A8349,A8350,A8351,A8352,A8353,A8354,A8355,A8356,A8357,A8358,A8359,A8360, \\note fields as indicated
  A8361,A8362,A8363,A8364,A8365,A8366,A8367,A8368,A8369,A8370,A8371,A8372,A8373,A8374,A8375,A8376,A8377,A8378,A8379,A8380, \\note fields as indicated
  A8381,A8382,A8383,A8384,A8385,A8386,A8387,A8388,A8389,A8390,A8391,A8392,A8393,A8394,A8395,A8396,A8397,A8398,A8399,A8400, \\note fields as indicated
  A8401,A8402,A8403,A8404,A8405,A8406,A8407,A8408,A8409,A8410,A8411,A8412,A8413,A8414,A8415,A8416,A8417,A8418,A8419,A8420, \\note fields as indicated
  A8421,A8422,A8423,A8424,A8425,A8426,A8427,A8428,A8429,A8430,A8431,A8432,A8433,A8434,A8435,A8436,A8437,A8438,A8439,A8440, \\note fields as indicated
  A8441,A8442,A8443,A8444,A8445,A8446,A8447,A8448,A8449,A8450,A8451,A8452,A8453,A8454,A8455,A8456,A8457,A8458,A8459,A8460, \\note fields as indicated
  A8461,A8462,A8463,A8464,A8465,A8466,A8467,A8468,A8469,A8470,A8471,A8472,A8473,A8474,A8475,A8476,A8477,A8478,A8479,A8480, \\note fields as indicated
  A8481,A8482,A8483,A8484,A8485,A8486,A8487,A8488,A8489,A8490,A8491,A8492,A8493,A8494,A8495,A8496,A8497,A8498,A8499,A8500, \\note fields as indicated
  A8501,A8502,A8503,A8504,A8505,A8506,A8507,A8508,A8509,A8510,A8511,A8512,A8513,A8514,A8515,A8516,A8517,A8518,A8519,A8520, \\note fields as indicated
  A8521,A8522,A8523,A8524,A8525,A8526,A8527,A8528,A8529,A8530,A8531,A8532,A8533,A8534,A8535,A8536,A8537,A8538,A8539,A8540, \\note fields as indicated
  A8541,A8542,A8543,A8544,A8545,A8546,A8547,A8548,A8549,A8550,A8551,A8552,A8553,A8554,A8555,A8556,A8557,A8558,A8559,A8560, \\note fields as indicated
  A8561,A8562,A8563,A8564,A8565,A8566,A8567,A8568,A8569,A8570,A8571,A8572,A8573,A8574,A8575,A8576,A8577,A8578,A8579,A8580, \\note fields as indicated
  A8581,A8582,A8583,A8584,A8585,A8586,A8587,A8588,A8589,A8590,A8591,A8592,A8593,A8594,A8595,A8596,A8597,A8598,A8599,A8600, \\note fields as indicated
  A8601,A8602,A8603,A8604,A8605,A8606,A8607,A8608,A8609,A8610,A8611,A8612,A8613,A8614,A8615,A8616,A8617,A8618,A8619,A8620, \\note fields as indicated
  A8621,A8622,A8623,A8624,A8625,A8626,A8627,A8628,A8629,A8630,A8631,A8632,A8633,A8634,A8635,A8636,A8637,A8638,A8639,A8640, \\note fields as indicated
  A8641,A8642,A8643,A8644,A8645,A8646,A8647,A8648,A8649,A8650,A8651,A8652,A8653,A8654,A8655,A8656,A8657,A8658,A8659,A8660, \\note fields as indicated
  A8661,A8662,A8663,A8664,A8665,A8666,A8667,A8668,A8669,A8670,A8671,A8672,A8673,A8674,A8675,A8676,A8677,A8678,A8679,A8680, \\note fields as indicated
  A8681,A8682,A8683,A8684,A8685,A8686,A8687,A8688,A8689,A8690,A8691,A8692,A8693,A8694,A8695,A8696,A8697,A8698,A8699,A8700, \\note fields as indicated
  A8701,A8702,A8703,A8704,A8705,A8706,A8707,A8708,A8709,A8710,A8711,A8712,A8713,A8714,A8715,A8716,A8717,A8718,A8719,A8720, \\note fields as indicated
  A8721,A8722,A8723,A8724,A8725,A8726,A8727,A8728,A8729,A8730,A8731,A8732,A8733,A8734,A8735,A8736,A8737,A8738,A8739,A8740, \\note fields as indicated
  A8741,A8742,A8743,A8744,A8745,A8746,A8747,A8748,A8749,A8750,A8751,A8752,A8753,A8754,A8755,A8756,A8757,A8758,A8759,A8760, \\note fields as indicated
  A8761,A8762,A8763,A8764,A8765,A8766,A8767,A8768,A8769,A8770,A8771,A8772,A8773,A8774,A8775,A8776,A8777,A8778,A8779,A8780, \\note fields as indicated
  A8781,A8782,A8783,A8784,A8785,A8786,A8787,A8788,A8789,A8790,A8791,A8792,A8793,A8794,A8795,A8796,A8797,A8798,A8799,A8800, \\note fields as indicated
  A8801,A8802,A8803,A8804,A8805,A8806,A8807,A8808,A8809,A8810,A8811,A8812,A8813,A8814,A8815,A8816,A8817,A8818,A8819,A8820, \\note fields as indicated
  A8821,A8822,A8823,A8824,A8825,A8826,A8827,A8828,A8829,A8830,A8831,A8832,A8833,A8834,A8835,A8836,A8837,A8838,A8839,A8840, \\note fields as indicated
  A8841,A8842,A8843,A8844,A8845,A8846,A8847,A8848,A8849,A8850,A8851,A8852,A8853,A8854,A8855,A8856,A8857,A8858,A8859,A8860, \\note fields as indicated
  A8861,A8862,A8863,A8864,A8865,A8866,A8867,A8868,A8869,A8870,A8871,A8872,A8873,A8874,A8875,A8876,A8877,A8878,A8879,A8880, \\note fields as indicated
  A8881,A8882,A8883,A8884,A8885,A8886,A8887,A8888,A8889,A8890,A8891,A8892,A8893,A8894,A8895,A8896,A8897,A8898,A8899,A8900, \\note fields as indicated
  A8901,A8902,A8903,A8904,A8905,A8906,A8907,A8908,A8909,A8910,A8911,A8912,A8913,A8914,A8915,A8916,A8917,A8918,A8919,A8920, \\note fields as indicated
  A8921,A8922,A8923,A8924,A8925,A8926,A8927,A8928,A8929,A8930,A8931,A8932,A8933,A8934,A8935,A8936,A8937,A8938,A8939,A8940, \\note fields as indicated
  A8941,A8942,A8943,A8944,A8945,A8946,A8947,A8948,A8949,A8950,A8951,A8952,A8953,A8954,A8955,A8956,A8957,A8958,A8959,A8960, \\note fields as indicated
  A8961,A8962,A8963,A8964,A8965,A8966,A8967,A8968,A8969,A8970,A8971,A8972,A8973,A8974,A8975,A8976,A8977,A8978,A8979,A8980, \\note fields as indicated
  A8981,A8982,A8983,A8984,A8985,A8986,A8987,A8988,A8989,A8990,A8991,A8992,A8993,A8994,A8995,A8996,A8997,A8998,A8999,A9000, \\note fields as indicated
  A9001,A9002,A9003,A9004,A9005,A9006,A9007,A9008,A9009,A9010,A9011,A9012,A9013,A9014,A9015,A9016,A9017,A9018,A9019,A9020, \\note fields as indicated
  A9021,A9022,A9023,A9024,A9025,A9026,A9027,A9028,A9029,A9030,A9031,A9032,A9033,A9034,A9035,A9036,A9037,A9038,A9039,A9040, \\note fields as indicated
  A9041,A9042,A9043,A9044,A9045,A9046,A9047,A9048,A9049,A9050,A9051,A9052,A9053,A9054,A9055,A9056,A9057,A9058,A9059,A9060, \\note fields as indicated
  A9061,A9062,A9063,A9064,A9065,A9066,A9067,A9068,A9069,A9070,A9071,A9072,A9073,A9074,A9075,A9076,A9077,A9078,A9079,A9080, \\note fields as indicated
  A9081,A9082,A9083,A9084,A9085,A9086,A9087,A9088,A9089,A9090,A9091,A9092,A9093,A9094,A9095,A9096,A9097,A9098,A9099,A9100, \\note fields as indicated
  A9101,A9102,A9103,A9104,A9105,A9106,A9107,A9108,A9109,A9110,A9111,A9112,A9113,A9114,A9115,A9116,A9117,A9118,A9119,A9120, \\note fields as indicated
  A9121,A9122,A9123,A9124,A9125,A9126,A9127,A9128,A9129,A9130,A9131,A9132,A9133,A9134,A9135,A9136,A9137,A9138,A9139,A9140, \\note fields as indicated
  A9141,A9142,A9143,A9144,A9145,A9146,A9147,A9148,A9149,A9150,A9151,A9152,A9153,A9154,A9155,A9156,A9157,A9158,A9159,A9160, \\note fields as indicated
  A9161,A9162,A9163,A9164,A9165,A9166,A9167,A9168,A9169,A9170,A9171,A9172,A9173,A9174,A9175,A9176,A9177,A9178,A9179,A9180, \\note fields as indicated
  A9181,A9182,A9183,A9184,A9185,A9186,A9187,A9188,A9189,A9190,A9191,A9192,A9193,A9194,A9195,A9196,A9197,A9198,A9199,A9200, \\note fields as indicated
  A9201,A9202,A9203,A9204,A9205,A9206,A9207,A9208,A9209,A9210,A9211,A9212,A9213,A9214,A9215,A9216,A9217,A9218,A9219,A9220, \\note fields as indicated
  A9221,A9222,A9223,A9224,A9225,A9226,A9227,A9228,A9229,A9230,A9231,A9232,A9233,A9234,A9235,A9236,A9237,A9238,A9239,A9240, \\note fields as indicated
  A9241,A9242,A9243,A9244,A9245,A9246,A9247,A9248,A9249,A9250,A9251,A9252,A9253,A9254,A9255,A9256,A9257,A9258,A9259,A9260, \\note fields as indicated
  A9261,A9262,A9263,A9264,A9265,A9266,A9267,A9268,A9269,A9270,A9271,A9272,A9273,A9274,A9275,A9276,A9277,A9278,A9279,A9280, \\note fields as indicated
  A9281,A9282,A9283,A9284,A9285,A9286,A9287,A9288,A9289,A9290,A9291,A9292,A9293,A9294,A9295,A9296,A9297,A9298,A9299,A9300, \\note fields as indicated
  A9301,A9302,A9303,A9304,A9305,A9306,A9307,A9308,A9309,A9310,A9311,A9312,A9313,A9314,A9315,A9316,A9317,A9318,A9319,A9320, \\note fields as indicated
  A9321,A9322,A9323,A9324,A9325,A9326,A9327,A9328,A9329,A9330,A9331,A9332,A9333,A9334,A9335,A9336,A9337,A9338,A9339,A9340, \\note fields as indicated
  A9341,A9342,A9343,A9344,A9345,A9346,A9347,A9348,A9349,A9350,A9351,A9352,A9353,A9354,A9355,A9356,A9357,A9358,A9359,A9360, \\note fields as indicated
  A9361,A9362,A9363,A9364,A9365,A9366,A9367,A9368,A9369,A9370,A9371,A9372,A9373,A9374,A9375,A9376,A9377,A9378,A9379,A9380, \\note fields as indicated
  A9381,A9382,A9383,A9384,A9385,A9386,A9387,A9388,A9389,A9390,A9391,A9392,A9393,A9394,A9395,A9396,A9397,A9398,A9399,A9400, \\note fields as indicated
  A9401,A9402,A9403,A9404,A9405,A9406,A9407,A9408,A9409,A9410,A9411,A9412,A9413,A9414,A9415,A9416,A9417,A9418,A9419,A9420, \\note fields as indicated
  A9421,A9422,A9423,A9424,A9425,A9426,A9427,A9428,A9429,A9430,A9431,A9432,A9433,A9434,A9435,A9436,A9437,A9438,A9439,A9440, \\note fields as indicated
  A9441,A9442,A9443,A9444,A9445,A9446,A9447,A9448,A9449,A9450,A9451,A9452,A9453,A9454,A9455,A9456,A9457,A9458,A9459,A9460, \\note fields as indicated
  A9461,A9462,A9463,A9464,A9465,A9466,A9467,A9468,A9469,A9470,A9471,A9472,A9473,A9474,A9475,A9476,A9477,A9478,A9479,A9480, \\note fields as indicated
  A9481,A9482,A9483,A9484,A9485,A9486,A9487,A9488,A9489,A9490,A9491,A9492,A9493,A9494,A9495,A9496,A9497,A9498,A9499,A9500, \\note fields as indicated
  A9501,A9502,A9503,A9504,A9505,A9506,A9507,A9508,A9509,A9510,A9511,A9512,A9513,A9514,A9515,A9516,A9517,A9518,A9519,A9520, \\note fields as indicated
  A9521,A9522,A9523,A9524,A9525,A9526,A9527,A9528,A9529,A9530,A9531,A9532,A9533,A9534,A9535,A9536,A9537,A9538,A9539,A9540, \\note fields as indicated
  A9541,A9542,A9543,A9544,A9545,A9546,A9547,A9548,A9549,A9550,A9551,A9552,A9553,A9554,A9555,A9556,A9557,A9558,A9559,A9560, \\note fields as indicated
  A9561,A9562,A9563,A9564,A9565,A9566,A9567,A9568,A9569,A9570,A9571,A9572,A9573,A9574,A9575,A9576,A9577,A9578,A9579,A9580, \\note fields as indicated
  A9581,A9582,A9583,A9584,A9585,A9586,A9587,A9588,A9589,A9590,A9591,A9592,A9593,A9594,A9595,A9596,A9597,A9598,A9599,A9600, \\note fields as indicated
  A9601,A9602,A9603,A9604,A9605,A9606,A9607,A9608,A9609,A9610,A9611,A9612,A9613,A9614,A9615,A9616,A9617,A9618,A9619,A9620, \\note fields as indicated
  A9621,A9622,A9623,A9624,A9625,A9626,A9627,A9628,A9629,A9630,A9631,A9632,A9633,A9634,A9635,A9636,A9637,A9638,A9639,A9640, \\note fields as indicated
  A9641,A9642,A9643,A9644,A9645,A9646,A9647,A9648,A9649,A9650,A9651,A9652,A9653,A9654,A9655,A9656,A9657,A9658,A9659,A9660, \\note fields as indicated
  A9661,A9662,A9663,A9664,A9665,A9666,A9667,A9668,A9669,A9670,A9671,A9672,A9673,A9674,A9675,A9676,A9677,A9678,A9679,A9680, \\note fields as indicated
  A9681,A9682,A9683,A9684,A9685,A9686,A9687,A9688,A9689,A9690,A9691,A9692,A9693,A9694,A9695,A9696,A9697,A9698,A9699,A9700, \\note fields as indicated
  A9701,A9702,A9703,A9704,A9705,A9706,A9707,A9708,A9709,A9710,A9711,A9712,A9713,A9714,A9715,A9716,A9717,A9718,A9719,A9720, \\note fields as indicated
  A9721,A9722,A9723,A9724,A9725,A9726,A9727,A9728,A9729,A9730,A9731,A9732,A9733,A9734,A9735,A9736,A9737,A9738,A9739,A9740, \\note fields as indicated
  A9741,A9742,A9743,A9744,A9745,A9746,A9747,A9748,A9749,A9750,A9751,A9752,A9753,A9754,A9755,A9756,A9757,A9758,A9759,A9760, \\note fields as indicated
  A9761,A9762,A9763,A9764,A9765,A9766,A9767,A9768,A9769,A9770,A9771,A9772,A9773,A9774,A9775,A9776,A9777,A9778,A9779,A9780, \\note fields as indicated
  A9781,A9782,A9783,A9784,A9785,A9786,A9787,A9788,A9789,A9790,A9791,A9792,A9793,A9794,A9795,A9796,A9797,A9798,A9799,A9800, \\note fields as indicated
  A9801,A9802,A9803,A9804,A9805,A9806,A9807,A9808,A9809,A9810,A9811,A9812,A9813,A9814,A9815,A9816,A9817,A9818,A9819,A9820, \\note fields as indicated
  A9821,A9822,A9823,A9824,A9825,A9826,A9827,A9828,A9829,A9830,A9831,A9832,A9833,A9834,A9835,A9836,A9837,A9838,A9839,A9840, \\note fields as indicated
  A9841,A9842,A9843,A9844,A9845,A9846,A9847,A9848,A9849,A9850,A9851,A9852,A9853,A9854,A9855,A9856,A9857,A9858,A9859,A9860, \\note fields as indicated
  A9861,A9862,A9863,A9864,A9865,A9866,A9867,A9868,A9869,A9870,A9871,A9872,A9873,A9874,A9875,A9876,A9877,A9878,A9879,A9880, \\note fields as indicated
  A9881,A9882,A9883,A9884,A9885,A9886,A9887,A9888,A9889,A9890,A9891,A9892,A9893,A9894,A9895,A9896,A9897,A9898,A9899,A9900, \\note fields as indicated
  A9901,A9902,A9903,A9904,A9905,A9906,A9907,A9908,A9909,A9910,A9911,A9912,A9913,A9914,A9915,A9916,A9917,A9918,A9919,A9920, \\note fields as indicated
  A9921,A9922,A9923,A9924,A9925,A9926,A9927,A9928,A9929,A9930,A9931,A9932,A9933,A9934,A9935,A9936,A9937,A9938,A9939,A9940, \\note fields as indicated
  A9941,A9942,A9943,A9944,A9945,A9946,A9947,A9948,A9949,A9950,A9951,A9952,A9953,A9954,A9955,A9956,A9957,A9958,A9959,A9960, \\note fields as indicated
  A9961,A9962,A9963,A9964,A9965,A9966,A9967,A9968,A9969,A9970,A9971,A9972,A9973,A9974,A9975,A9976,A9977,A9978,A9979,A9980, \\note fields as indicated
  A9981,A9982,A9983,A9984,A9985,A9986,A9987,A9988,A9989,A9990,A9991,A9992,A9993,A9994,A9995,A9996,A9997,A9998,A9999,A10000; \\note fields as indicated

Schedule:Constant,
   \\memo Constant hourly value for entire year.
   \\format singleLine
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  N1 ; \\field Hourly Value
       \\type real
       \\default 0

Schedule:File:Shading,
       \\min-fields 1
       \\memo A Schedule:File:Shading points to a CSV file that has 8760-8784
       \\memo hours of sunlit fraction data for all or some of the exterior surfaces.
       \\unique-object
  A1 ; \\field File Name
       \\note The name of the file that writes all shading data.
       \\required-field
       \\retaincase

Schedule:File,
 \\min-fields 5
       \\memo A Schedule:File points to a text computer file that has 8760-8784 hours of data.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ScheduleNames
  A2 , \\field Schedule Type Limits Name
       \\type object-list
       \\object-list ScheduleTypeLimitsNames
  A3 , \\field File Name
       \\required-field
       \\retaincase
  N1 , \\field Column Number
       \\required-field
       \\type integer
       \\minimum 1
  N2 , \\field Rows to Skip at Top
       \\required-field
       \\type integer
       \\minimum 0
  N3 , \\field Number of Hours of Data
       \\note 8760 hours does not account for leap years, 8784 does.
       \\note should be either 8760 or 8784
       \\default 8760
       \\minimum 8760
       \\maximum 8784
  A4 , \\field Column Separator
       \\type choice
       \\key Comma
       \\key Tab
       \\key Space
       \\key Semicolon
       \\default Comma
  A5 , \\field Interpolate to Timestep
       \\note when the interval does not match the user specified timestep a "Yes" choice will average between the intervals request (to
       \\note timestep resolution. a "No" choice will use the interval value at the simulation timestep without regard to if it matches
       \\note the boundary or not.
       \\type choice
       \\key Yes
       \\key No
       \\default No
  N4 ; \\field Minutes per Item
       \\note Must be evenly divisible into 60
       \\type integer
       \\minimum 1
       \\maximum 60

\\group Surface Construction Elements

Material,
    \\memo Regular materials described with full set of thermal properties
    \\min-fields 6
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  A2 , \\field Roughness
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
       \\ip-units in
  N2 , \\field Conductivity
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N3 , \\field Density
       \\required-field
       \\units kg/m3
       \\type real
       \\minimum> 0
  N4 , \\field Specific Heat
       \\required-field
       \\units J/kg-K
       \\type real
       \\minimum 100
  N5 , \\field Thermal Absorptance
       \\type real
       \\minimum> 0
       \\default .9
       \\maximum 0.99999
  N6 , \\field Solar Absorptance
       \\type real
       \\default .7
       \\minimum 0
       \\maximum 1
  N7 ; \\field Visible Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1

Material:NoMass,
    \\memo Regular materials properties described whose principal description is R (Thermal Resistance)
     \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  A2 , \\field Roughness
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N1 , \\field Thermal Resistance
       \\required-field
       \\units m2-K/W
       \\type real
       \\minimum .001
  N2 , \\field Thermal Absorptance
       \\type real
       \\minimum> 0
       \\default .9
       \\maximum 0.99999
  N3 , \\field Solar Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1
  N4 ; \\field Visible Absorptance
       \\type real
       \\minimum 0
       \\default .7
       \\maximum 1

Material:InfraredTransparent,
       \\memo Special infrared transparent material. Similar to a Material:Nomass with low thermal resistance.
       \\memo  High absorptance in both wavelengths.
       \\memo  Area will be doubled internally to make internal radiant exchange accurate.
       \\memo  Should be only material in single layer surface construction.
       \\memo  All thermal properties are set internally. User needs only to supply name.
       \\memo Cannot be used with ConductionFiniteDifference solution algorithms
       \\min-fields 1
  A1 ; \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName

Material:AirGap,
       \\min-fields 2
       \\memo Air Space in Opaque Construction
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
  N1 ; \\field Thermal Resistance
       \\required-field
       \\units m2-K/W
       \\type real
       \\minimum> 0

Material:RoofVegetation,
  \\memo EcoRoof model, plant layer plus soil layer
  \\memo Implemented by Portland State University
  \\memo (Sailor et al., January, 2007)
  \\memo only one material must be referenced per simulation though the same EcoRoof material could be
  \\memo used in multiple constructions. New moisture redistribution scheme (2010) requires higher
  \\memo number of timesteps per hour (minimum 12 recommended).
  \\min-fields 19
  A1 ,\\field Name
      \\required-field
      \\type alpha
      \\reference MaterialName
  N1 ,\\field Height of Plants
      \\type real
      \\note The ecoroof module is designed for short plants and shrubs.
      \\minimum> 0.005
      \\maximum  1.0
      \\units m
      \\default .2
  N2 ,\\field Leaf Area Index
      \\units dimensionless
      \\note Entire surface is assumed covered, so decrease LAI accordingly.
      \\minimum> 0.001
      \\maximum 5.0
      \\default 1.0
      \\type real
  N3 ,\\field Leaf Reflectivity
      \\type real
      \\units dimensionless
      \\note Leaf reflectivity (albedo) is typically 0.18-0.25
      \\maximum 0.5
      \\minimum 0.05
      \\default 0.22
  N4 ,\\field Leaf Emissivity
      \\type real
      \\minimum 0.8
      \\maximum 1.0
      \\default 0.95
  N5 ,\\field Minimum Stomatal Resistance
      \\units s/m
      \\default 180.0
      \\note This depends upon plant type
      \\minimum 50.0
      \\maximum 300.
      \\type real
  A2 ,\\field Soil Layer Name
      \\type alpha
      \\default Green Roof Soil
  A3 ,\\field Roughness
      \\type choice
      \\key VeryRough
      \\key MediumRough
      \\key Rough
      \\key Smooth
      \\key MediumSmooth
      \\key VerySmooth
      \\default MediumRough
  N6 ,\\field Thickness
      \\note thickness of the soil layer of the EcoRoof
      \\units m
      \\type real
      \\note Soil depths of 0.15m (6in) and 0.30m (12in) are common.
      \\default 0.1
      \\minimum> 0.05
      \\maximum 0.7
      \\ip-units in
  N7 ,\\field Conductivity of Dry Soil
      \\units W/m-K
      \\type real
      \\note Thermal conductivity of dry soil.
      \\note Typical ecoroof soils range from 0.3 to 0.5
      \\default 0.35
      \\minimum  0.2
      \\maximum 1.5
  N8 ,\\field Density of Dry Soil
      \\units kg/m3
      \\note Density of dry soil (the code modifies this as the soil becomes moist)
      \\note Typical ecoroof soils range from 400 to 1000 (dry to wet)
      \\type real
      \\minimum 300
      \\maximum 2000
      \\default 1100
  N9 ,\\field Specific Heat of Dry Soil
      \\units J/kg-K
      \\type real
      \\note Specific heat of dry soil
      \\minimum> 500
      \\maximum 2000
      \\default 1200
  N10,\\field Thermal Absorptance
      \\type real
      \\note Soil emissivity is typically in range of 0.90 to 0.98
      \\minimum> 0.8
      \\default .9
      \\maximum 1.0
  N11,\\field Solar Absorptance
      \\type real
      \\note Solar absorptance of dry soil (1-albedo) is typically 0.60 to 0.85
      \\note corresponding to a dry albedo of 0.15 to 0.40
      \\default .70
      \\minimum 0.40
      \\maximum 0.9
  N12,\\field Visible Absorptance
      \\type real
      \\minimum> 0.5
      \\default .75
      \\maximum 1.0
  N13,\\field Saturation Volumetric Moisture Content of the Soil Layer
      \\type real
      \\note Maximum moisture content is typically less than 0.5
      \\minimum> 0.1
      \\maximum 0.5
      \\default 0.3
  N14,\\field Residual Volumetric Moisture Content of the Soil Layer
      \\type real
      \\minimum  0.01
      \\maximum  0.1
      \\default 0.01
  N15,\\field Initial Volumetric Moisture Content of the Soil Layer
      \\type real
      \\minimum> 0.05
      \\maximum  0.5
      \\default 0.1
  A4; \\field Moisture Diffusion Calculation Method
      \\note Advanced calculation requires increased number of timesteps (recommended >20).
      \\type choice
      \\key Simple
      \\key Advanced
      \\default Advanced

WindowMaterial:SimpleGlazingSystem,
       \\min-fields 3
       \\memo Alternate method of describing windows
       \\memo This window material object is used to define an entire glazing system
       \\memo using simple performance parameters.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field U-Factor
       \\required-field
       \\note Enter U-Factor including film coefficients
       \\note Note that the effective upper limit for U-factor is 5.8 W/m2-K
       \\units W/m2-K
       \\minimum> 0
       \\maximum  7
  N2 , \\field Solar Heat Gain Coefficient
       \\required-field
       \\note SHGC at Normal Incidence
       \\minimum> 0
       \\maximum< 1
  N3 ; \\field Visible Transmittance
       \\note VT at Normal Incidence
       \\note optional
       \\minimum> 0
       \\maximum< 1

WindowMaterial:Glazing,
    \\min-fields 14
    \\memo Glass material properties for Windows or Glass Doors
    \\memo Transmittance/Reflectance input method.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
       \\reference CFSGlazingName
  A2 , \\field Optical Data Type
       \\required-field
       \\type choice
       \\key SpectralAverage
       \\key Spectral
       \\key BSDF
       \\key SpectralAndAngle
  A3 , \\field Window Glass Spectral Data Set Name
       \\note Used only when Optical Data Type = Spectral
       \\type object-list
       \\object-list SpectralDataSets
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Solar Transmittance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N3 , \\field Front Side Solar Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N4 , \\field Back Side Solar Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N5 , \\field Visible Transmittance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N6 , \\field Front Side Visible Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N7 , \\field Back Side Visible Reflectance at Normal Incidence
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N8 , \\field Infrared Transmittance at Normal Incidence
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N9 , \\field Front Side Infrared Hemispherical Emissivity
       \\type real
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N10, \\field Back Side Infrared Hemispherical Emissivity
       \\type real
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N11, \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0.0
       \\default 0.9
  N12, \\field Dirt Correction Factor for Solar and Visible Transmittance
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
       \\default 1.0
  A4,  \\field Solar Diffusing
       \\type choice
       \\key No
       \\key Yes
       \\default No
  N13, \\field Young's modulus
       \\note coefficient used for deflection calculations. Used only with complex
       \\note fenestration when deflection model is set to TemperatureAndPressureInput
       \\units Pa
       \\type real
       \\minimum> 0.0
       \\default 7.2e10
  N14, \\field Poisson's ratio
       \\note coefficient used for deflection calculations. Used only with complex
       \\note fenestration when deflection model is set to TemperatureAndPressureInput
       \\type real
       \\minimum>  0.0
       \\maximum<  1.0
       \\default 0.22
  A5 , \\field Window Glass Spectral and Incident Angle Transmittance Data Set Table Name
       \\note Used only when Optical Data Type = SpectralAndAngle
       \\type object-list
       \\object-list BivariateFunctions
  A6 , \\field Window Glass Spectral and Incident Angle Front Reflectance Data Set Table Name
       \\note Used only when Optical Data Type = SpectralAndAngle
       \\type object-list
       \\object-list BivariateFunctions
  A7 ; \\field Window Glass Spectral and Incident Angle Back Reflectance Data Set Table Name
       \\note Used only when Optical Data Type = SpectralAndAngle
       \\type object-list
       \\object-list BivariateFunctions

WindowMaterial:GlazingGroup:Thermochromic,
    \\min-fields 3
    \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
    \\memo thermochromic glass at different temperatures
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field Optical Data Temperature 1
       \\begin-extensible
       \\required-field
       \\units C
       \\ip-units F
       \\type real
  A2 , \\field Window Material Glazing Name 1
       \\required-field
       \\type object-list
       \\object-list GlazingMaterialName
  N2 , \\field Optical Data Temperature 2
       \\units C
       \\ip-units F
       \\type real
  A3 , \\field Window Material Glazing Name 2
       \\type object-list
       \\object-list GlazingMaterialName
  N3 , \\field Optical Data Temperature 3
       \\units C
       \\ip-units F
       \\type real
  A4 , \\field Window Material Glazing Name 3
       \\type object-list
       \\object-list GlazingMaterialName
  N4 , \\field Optical Data Temperature 4
       \\units C
       \\ip-units F
       \\type real
  A5 , \\field Window Material Glazing Name 4
       \\type object-list
       \\object-list GlazingMaterialName
  N5 , \\field Optical Data Temperature 5
       \\units C
       \\ip-units F
       \\type real
  A6 , \\field Window Material Glazing Name 5
       \\type object-list
       \\object-list GlazingMaterialName
  N6 , \\field Optical Data Temperature 6
       \\units C
       \\ip-units F
       \\type real
  A7 , \\field Window Material Glazing Name 6
       \\type object-list
       \\object-list GlazingMaterialName
  N7 , \\field Optical Data Temperature 7
       \\units C
       \\ip-units F
       \\type real
  A8 , \\field Window Material Glazing Name 7
       \\type object-list
       \\object-list GlazingMaterialName
  N8 , \\field Optical Data Temperature 8
       \\units C
       \\ip-units F
       \\type real
  A9 , \\field Window Material Glazing Name 8
       \\type object-list
       \\object-list GlazingMaterialName
  N9 , \\field Optical Data Temperature 9
       \\units C
       \\ip-units F
       \\type real
  A10, \\field Window Material Glazing Name 9
       \\type object-list
       \\object-list GlazingMaterialName
  N10, \\field Optical Data Temperature 10
       \\units C
       \\ip-units F
       \\type real
  A11, \\field Window Material Glazing Name 10
       \\type object-list
       \\object-list GlazingMaterialName
  N11, \\field Optical Data Temperature 11
       \\units C
       \\ip-units F
       \\type real
  A12, \\field Window Material Glazing Name 11
       \\type object-list
       \\object-list GlazingMaterialName
  N12, \\field Optical Data Temperature 12
       \\units C
       \\ip-units F
       \\type real
  A13, \\field Window Material Glazing Name 12
       \\type object-list
       \\object-list GlazingMaterialName
  N13, \\field Optical Data Temperature 13
       \\units C
       \\ip-units F
       \\type real
  A14, \\field Window Material Glazing Name 13
       \\type object-list
       \\object-list GlazingMaterialName
  N14, \\field Optical Data Temperature 14
       \\units C
       \\ip-units F
       \\type real
  A15, \\field Window Material Glazing Name 14
       \\type object-list
       \\object-list GlazingMaterialName
  N15, \\field Optical Data Temperature 15
       \\units C
       \\ip-units F
       \\type real
  A16, \\field Window Material Glazing Name 15
       \\type object-list
       \\object-list GlazingMaterialName
  N16, \\field Optical Data Temperature 16
       \\units C
       \\ip-units F
       \\type real
  A17, \\field Window Material Glazing Name 16
       \\type object-list
       \\object-list GlazingMaterialName
  N17, \\field Optical Data Temperature 17
       \\units C
       \\ip-units F
       \\type real
  A18, \\field Window Material Glazing Name 17
       \\type object-list
       \\object-list GlazingMaterialName
  N18, \\field Optical Data Temperature 18
       \\units C
       \\ip-units F
       \\type real
  A19, \\field Window Material Glazing Name 18
       \\type object-list
       \\object-list GlazingMaterialName
  N19, \\field Optical Data Temperature 19
       \\units C
       \\ip-units F
       \\type real
  A20, \\field Window Material Glazing Name 19
       \\type object-list
       \\object-list GlazingMaterialName
  N20, \\field Optical Data Temperature 20
       \\units C
       \\ip-units F
       \\type real
  A21, \\field Window Material Glazing Name 20
       \\type object-list
       \\object-list GlazingMaterialName
  N21, \\field Optical Data Temperature 21
       \\units C
       \\ip-units F
       \\type real
  A22, \\field Window Material Glazing Name 21
       \\type object-list
       \\object-list GlazingMaterialName
  N22, \\field Optical Data Temperature 22
       \\units C
       \\ip-units F
       \\type real
  A23, \\field Window Material Glazing Name 22
       \\type object-list
       \\object-list GlazingMaterialName
  N23, \\field Optical Data Temperature 23
       \\units C
       \\ip-units F
       \\type real
  A24, \\field Window Material Glazing Name 23
       \\type object-list
       \\object-list GlazingMaterialName
  N24, \\field Optical Data Temperature 24
       \\units C
       \\ip-units F
       \\type real
  A25, \\field Window Material Glazing Name 24
       \\type object-list
       \\object-list GlazingMaterialName
  N25, \\field Optical Data Temperature 25
       \\units C
       \\ip-units F
       \\type real
  A26, \\field Window Material Glazing Name 25
       \\type object-list
       \\object-list GlazingMaterialName
  N26, \\field Optical Data Temperature 26
       \\units C
       \\ip-units F
       \\type real
  A27, \\field Window Material Glazing Name 26
       \\type object-list
       \\object-list GlazingMaterialName
  N27, \\field Optical Data Temperature 27
       \\units C
       \\ip-units F
       \\type real
  A28, \\field Window Material Glazing Name 27
       \\type object-list
       \\object-list GlazingMaterialName
  N28, \\field Optical Data Temperature 28
       \\units C
       \\ip-units F
       \\type real
  A29, \\field Window Material Glazing Name 28
       \\type object-list
       \\object-list GlazingMaterialName
  N29, \\field Optical Data Temperature 29
       \\units C
       \\ip-units F
       \\type real
  A30, \\field Window Material Glazing Name 29
       \\type object-list
       \\object-list GlazingMaterialName
  N30, \\field Optical Data Temperature 30
       \\units C
       \\ip-units F
       \\type real
  A31, \\field Window Material Glazing Name 30
       \\type object-list
       \\object-list GlazingMaterialName
  N31, \\field Optical Data Temperature 31
       \\units C
       \\ip-units F
       \\type real
  A32, \\field Window Material Glazing Name 31
       \\type object-list
       \\object-list GlazingMaterialName
  N32, \\field Optical Data Temperature 32
       \\units C
       \\ip-units F
       \\type real
  A33, \\field Window Material Glazing Name 32
       \\type object-list
       \\object-list GlazingMaterialName
  N33, \\field Optical Data Temperature 33
       \\units C
       \\ip-units F
       \\type real
  A34, \\field Window Material Glazing Name 33
       \\type object-list
       \\object-list GlazingMaterialName
  N34, \\field Optical Data Temperature 34
       \\units C
       \\ip-units F
       \\type real
  A35, \\field Window Material Glazing Name 34
       \\type object-list
       \\object-list GlazingMaterialName
  N35, \\field Optical Data Temperature 35
       \\units C
       \\ip-units F
       \\type real
  A36, \\field Window Material Glazing Name 35
       \\type object-list
       \\object-list GlazingMaterialName
  N36, \\field Optical Data Temperature 36
       \\units C
       \\ip-units F
       \\type real
  A37, \\field Window Material Glazing Name 36
       \\type object-list
       \\object-list GlazingMaterialName
  N37, \\field Optical Data Temperature 37
       \\units C
       \\ip-units F
       \\type real
  A38, \\field Window Material Glazing Name 37
       \\type object-list
       \\object-list GlazingMaterialName
  N38, \\field Optical Data Temperature 38
       \\units C
       \\ip-units F
       \\type real
  A39, \\field Window Material Glazing Name 38
       \\type object-list
       \\object-list GlazingMaterialName
  N39, \\field Optical Data Temperature 39
       \\units C
       \\ip-units F
       \\type real
  A40, \\field Window Material Glazing Name 39
       \\type object-list
       \\object-list GlazingMaterialName
  N40, \\field Optical Data Temperature 40
       \\units C
       \\ip-units F
       \\type real
  A41, \\field Window Material Glazing Name 40
       \\type object-list
       \\object-list GlazingMaterialName
  N41, \\field Optical Data Temperature 41
       \\units C
       \\ip-units F
       \\type real
  A42, \\field Window Material Glazing Name 41
       \\type object-list
       \\object-list GlazingMaterialName
  N42, \\field Optical Data Temperature 42
       \\units C
       \\ip-units F
       \\type real
  A43, \\field Window Material Glazing Name 42
       \\type object-list
       \\object-list GlazingMaterialName
  N43, \\field Optical Data Temperature 43
       \\units C
       \\ip-units F
       \\type real
  A44, \\field Window Material Glazing Name 43
       \\type object-list
       \\object-list GlazingMaterialName
  N44, \\field Optical Data Temperature 44
       \\units C
       \\ip-units F
       \\type real
  A45, \\field Window Material Glazing Name 44
       \\type object-list
       \\object-list GlazingMaterialName
  N45, \\field Optical Data Temperature 45
       \\units C
       \\ip-units F
       \\type real
  A46; \\field Window Material Glazing Name 45
       \\type object-list
       \\object-list GlazingMaterialName

WindowMaterial:Glazing:RefractionExtinctionMethod,
    \\memo Glass material properties for Windows or Glass Doors
    \\memo Index of Refraction/Extinction Coefficient input method
    \\memo Not to be used for coated glass
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference GlazingMaterialName
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Solar Index of Refraction
       \\required-field
       \\type real
       \\minimum> 1.0
  N3 , \\field Solar Extinction Coefficient
       \\required-field
       \\units 1/m
       \\type real
       \\minimum> 0.0
  N4 , \\field Visible Index of Refraction
       \\required-field
       \\type real
       \\minimum> 1.0
  N5 , \\field Visible Extinction Coefficient
       \\required-field
       \\units 1/m
       \\type real
       \\minimum> 0.0
  N6 , \\field Infrared Transmittance at Normal Incidence
       \\type real
       \\maximum< 1.0
       \\minimum 0.0
       \\default 0.0
  N7 , \\field Infrared Hemispherical Emissivity
       \\note Emissivity of front and back side assumed equal
       \\type real
       \\maximum< 1.0
       \\minimum> 0.0
       \\default 0.84
  N8 , \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0.0
       \\default 0.9
  N9 , \\field Dirt Correction Factor for Solar and Visible Transmittance
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
       \\default 1.0
  A2 ; \\field Solar Diffusing
       \\type choice
       \\key No
       \\key Yes
       \\default No

WindowMaterial:Gas,
    \\memo Gas material properties that are used in Windows or Glass Doors
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowGasAndGasMixtures
  A2 , \\field Gas Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
       \\key Custom
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  N2 , \\field Conductivity Coefficient A
       \\units W/m-K
       \\type real
       \\note Used only if Gas Type = Custom
  N3 , \\field Conductivity Coefficient B
       \\units W/m-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N4 , \\field Conductivity Coefficient C
       \\units W/m-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N5 , \\field Viscosity Coefficient A
       \\units kg/m-s
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N6 , \\field Viscosity Coefficient B
       \\units kg/m-s-K
       \\type real
       \\note Used only if Gas Type = Custom
  N7 , \\field Viscosity Coefficient C
       \\units kg/m-s-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N8 , \\field Specific Heat Coefficient A
       \\units J/kg-K
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N9 , \\field Specific Heat Coefficient B
       \\units J/kg-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N10 ,\\field Specific Heat Coefficient C
       \\units J/kg-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N11 ,\\field Molecular Weight
       \\type real
       \\note Used only if Gas Type = Custom
       \\units g/mol
       \\minimum 20.0
       \\maximum 200.0
  N12 ;\\field Specific Heat Ratio
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 1.0

WindowGap:SupportPillar,
    \\memo used to define pillar geometry for support pillars
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowGapSupportPillars
  N1 , \\field Spacing
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 0.04
 N2 ; \\field Radius
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 0.0004

WindowGap:DeflectionState,
       \\memo Used to enter data describing deflection state of the gap. It is referenced from
       \\memo WindowMaterial:Gap object only and it is used only when deflection model is set to
       \\memo MeasuredDeflection, otherwise it is ignored.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowGapDeflectionStates
  N1 , \\field Deflected Thickness
       \\note If left blank will be considered that gap has no deflection.
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.0
  N2 , \\field Initial Temperature
       \\units C
       \\type real
       \\minimum 0.0
       \\default 25
  N3 ; \\field Initial Pressure
       \\units Pa
       \\type real
       \\minimum 0.0
       \\default 101325

WindowMaterial:GasMixture,
    \\memo Gas mixtures that are used in Windows or Glass Doors
       \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowGasAndGasMixtures
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
  N2 , \\field Number of Gases in Mixture
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 4
  A2 , \\field Gas 1 Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N3 , \\field Gas 1 Fraction
       \\required-field
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A3 , \\field Gas 2 Type
       \\required-field
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N4 , \\field Gas 2 Fraction
       \\required-field
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A4 , \\field Gas 3 Type
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N5 , \\field Gas 3 Fraction
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
  A5 , \\field Gas 4 Type
       \\type choice
       \\key Air
       \\key Argon
       \\key Krypton
       \\key Xenon
  N6 ; \\field Gas 4 Fraction
       \\type real
       \\minimum> 0.0
       \\maximum 1.0

WindowMaterial:Gap,
       \\memo Used to define the gap between two layers in a complex fenestration system, where the
       \\memo Construction:ComplexFenestrationState object is used. It is referenced as a layer in the
       \\memo Construction:ComplexFenestrationState object. It cannot be referenced as a layer from the
       \\memo Construction object.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference CFSGap
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
  A2 , \\field Gas (or Gas Mixture)
       \\note This field should reference only WindowMaterial:Gas
       \\note or WindowMaterial:GasMixture objects
       \\required-field
       \\type object-list
       \\object-list WindowGasAndGasMixtures
  N2 , \\field Pressure
       \\units Pa
       \\type real
       \\default 101325
  A3 , \\field Deflection State
       \\note If left blank, it will be considered that gap is not deflected
       \\type object-list
       \\object-list WindowGapDeflectionStates
  A4 ; \\field Support Pillar
       \\note If left blank, it will be considered that gap does not have
       \\note support pillars
       \\type object-list
       \\object-list WindowGapSupportPillars

WindowMaterial:Shade,
       \\memo Specifies the properties of window shade materials. Reflectance and emissivity
       \\memo properties are assumed to be the same on both sides of the shade. Shades are considered
       \\memo to be perfect diffusers (all transmitted and reflected radiation is
       \\memo hemispherically-diffuse) independent of angle of incidence.
  \\min-fields 15
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  N1 , \\field Solar Transmittance
       \\required-field
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N2 , \\field Solar Reflectance
       \\required-field
       \\note Assumed same for both sides
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Visible Transmittance
       \\required-field
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N4 , \\field Visible Reflectance
       \\required-field
       \\note Assumed same for both sides
       \\note Assumed independent of incidence angle
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N5 , \\field Infrared Hemispherical Emissivity
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
  N6 , \\field Infrared Transmittance
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N7 , \\field Thickness
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N8 , \\field Conductivity
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N9 , \\field Shade to Glass Distance
       \\type real
       \\units m
       \\minimum 0.001
       \\maximum 1.0
       \\default 0.050
       \\ip-units in
  N10, \\field Top Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N11, \\field Bottom Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N12, \\field Left-Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N13, \\field Right-Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N14; \\field Airflow Permeability
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 0.8
       \\default 0.0

WindowMaterial:ComplexShade,
    \\memo Complex window shading layer thermal properties
     \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowComplexShades
  A2 , \\field Layer Type
       \\type choice
       \\key VenetianHorizontal
       \\key VenetianVertical
       \\key Woven
       \\key Perforated
       \\key BSDF
       \\key OtherShadingType
       \\default OtherShadingType
  N1 , \\field Thickness
       \\type real
       \\units m
       \\minimum> 0
       \\default 0.002
  N2 , \\field Conductivity
       \\units W/m-K
       \\type real
       \\minimum> 0
       \\default 1
  N3 , \\field IR Transmittance
       \\type real
       \\maximum 1
       \\minimum 0
       \\default 0
  N4 , \\field Front Emissivity
       \\type real
       \\maximum 1
       \\minimum> 0
       \\default 0.84
  N5 , \\field Back Emissivity
       \\type real
       \\maximum 1
       \\minimum> 0
       \\default 0.84
  N6 , \\field Top Opening Multiplier
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N7 , \\field Bottom Opening Multiplier
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N8 , \\field Left Side Opening Multiplier
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
  N9 , \\field Right Side Opening Multiplier
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0
 N10 , \\field Front Opening Multiplier
       \\type real
       \\minimum 0
       \\maximum 1
       \\default 0.05
 N11 , \\field Slat Width
       \\units m
       \\type real
       \\minimum> 0
       \\default 0.016
 N12 , \\field Slat Spacing
       \\note Distance between adjacent slat faces
       \\units m
       \\type real
       \\minimum> 0
       \\default 0.012
  N13 , \\field Slat Thickness
       \\note Distance between top and bottom surfaces of slat
       \\note Slat is assumed to be rectangular in cross section and flat
       \\type real
       \\units m
       \\minimum> 0
       \\default 0.0006
  N14 , \\field Slat Angle
       \\type real
       \\units deg
       \\default 90
       \\minimum -90
       \\maximum 90
  N15 , \\field Slat Conductivity
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 160.0
  N16 ; \\field Slat Curve
       \\note this value represents curvature radius of the slat.
       \\note if the slat is flat use zero.
       \\note if this value is not zero, then it must be > SlatWidth/2.
       \\type real
       \\units m
       \\minimum 0.0
       \\default 0

WindowMaterial:Blind,
    \\memo Window blind thermal properties
     \\min-fields 29
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  A2 , \\field Slat Orientation
       \\type choice
       \\key Horizontal
       \\key Vertical
       \\default Horizontal
  N1 , \\field Slat Width
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 1
       \\ip-units in
  N2 , \\field Slat Separation
       \\required-field
       \\note Distance between adjacent slat faces
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 1
       \\ip-units in
  N3 , \\field Slat Thickness
       \\note Distance between top and bottom surfaces of slat
       \\note Slat is assumed to be rectangular in cross section and flat
       \\type real
       \\units m
       \\minimum> 0
       \\maximum 0.1
       \\default 0.00025
       \\ip-units in
  N4 , \\field Slat Angle
       \\note If WindowShadingControl referencing the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = FixedSlatAngle,
       \\note then this is the fixed value of the slat angle;
       \\note If WindowShadingControl referencing the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = BlockBeamSolar,
       \\note then this is the slat angle when slat angle control
       \\note is not in effect (e.g., when there is no beam solar on the blind);
       \\note Not used if WindowShadingControl referencing the window that incorporates this blind
       \\note has Type of Slat Angle Control for Blinds = ScheduledSlatAngle.
       \\type real
       \\units deg
       \\default 45
       \\minimum 0
       \\maximum 180
  N5 , \\field Slat Conductivity
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 221.0
       \\note default is for aluminum
  N6 , \\field Slat Beam Solar Transmittance
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N7 , \\field Front Side Slat Beam Solar Reflectance
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N8 , \\field Back Side Slat Beam Solar Reflectance
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N9 , \\field Slat Diffuse Solar Transmittance
       \\note Must equal "Slat beam solar transmittance"
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N10, \\field Front Side Slat Diffuse Solar Reflectance
       \\note Must equal "Front Side Slat Beam Solar Reflectance"
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N11, \\field Back Side Slat Diffuse Solar Reflectance
       \\note Must equal "Back Side Slat Beam Solar Reflectance"
       \\required-field
       \\type real
       \\maximum< 1
       \\minimum 0
  N12, \\field Slat Beam Visible Transmittance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
       \\required-field
  N13, \\field Front Side Slat Beam Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
  N14, \\field Back Side Slat Beam Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\type real
       \\maximum< 1
       \\minimum 0
  N15, \\field Slat Diffuse Visible Transmittance
       \\note Used only for detailed daylighting calculation
       \\note Must equal "Slat Beam Visible Transmittance"
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N16, \\field Front Side Slat Diffuse Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\note Must equal "Front Side Slat Beam Visible Reflectance"
       \\type real
       \\maximum< 1
       \\minimum 0
  N17, \\field Back Side Slat Diffuse Visible Reflectance
       \\note Required for detailed daylighting calculation
       \\note Must equal "Back Side Slat Beam Visible Reflectance"
       \\type real
       \\maximum< 1
       \\minimum 0
  N18, \\field Slat Infrared Hemispherical Transmittance
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N19, \\field Front Side Slat Infrared Hemispherical Emissivity
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  N20, \\field Back Side Slat Infrared Hemispherical Emissivity
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  N21, \\field Blind to Glass Distance
       \\type real
       \\units m
       \\minimum 0.01
       \\maximum 1.0
       \\default 0.050
       \\ip-units in
  N22, \\field Blind Top Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N23, \\field Blind Bottom Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N24, \\field Blind Left Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N25, \\field Blind Right Side Opening Multiplier
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
  N26, \\field Minimum Slat Angle
       \\note Used only if WindowShadingControl referencing the window that incorporates
       \\note this blind varies the slat angle (i.e., WindowShadingControl with
       \\note Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note or BlockBeamSolar)
       \\type real
       \\units deg
       \\default 0
       \\minimum 0
       \\maximum 180
  N27; \\field Maximum Slat Angle
       \\note Used only if WindowShadingControl referencing the window that incorporates
       \\note this blind varies the slat angle (i.e., WindowShadingControl with
       \\note Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note or BlockBeamSolar)
       \\type real
       \\units deg
       \\default 180
       \\minimum 0
       \\maximum 180

WindowMaterial:Screen,
       \\memo Window screen physical properties. Can only be located on the exterior side of a window construction.
       \\min-fields 9
  A1 , \\field Name
       \\note Enter a unique name for this window screen material.
       \\required-field
       \\type alpha
       \\reference MaterialName
       \\reference WindowShadesScreensAndBlinds
  A2 , \\field Reflected Beam Transmittance Accounting Method
       \\note Select the method used to account for the beam solar reflected off the material surface.
       \\type choice
       \\key DoNotModel
       \\key ModelAsDirectBeam
       \\key ModelAsDiffuse
       \\default ModelAsDiffuse
  N1 , \\field Diffuse Solar Reflectance
       \\note Diffuse reflectance of the screen material over the entire solar radiation spectrum.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N2 , \\field Diffuse Visible Reflectance
       \\note Diffuse visible reflectance of the screen material averaged over the solar spectrum
       \\note and weighted by the response of the human eye.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Thermal Hemispherical Emissivity
       \\note Long-wave emissivity of the screen material.
       \\note Assumed to be the same for both sides of the screen.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.9
  N4 , \\field Conductivity
       \\note Thermal conductivity of the screen material.
       \\type real
       \\units W/m-K
       \\minimum> 0
       \\default 221.0
       \\note Default is for aluminum.
  N5 , \\field Screen Material Spacing
       \\note Spacing assumed to be the same in both directions.
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N6 , \\field Screen Material Diameter
       \\note Diameter assumed to be the same in both directions.
       \\required-field
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
  N7 , \\field Screen to Glass Distance
       \\note Distance from the window screen to the adjacent glass surface.
       \\type real
       \\units m
       \\minimum 0.001
       \\maximum 1.0
       \\default 0.025
       \\ip-units in
  N8 , \\field Top Opening Multiplier
       \\note Effective area for air flow at the top of the screen divided by the perpendicular
       \\note area between the glass and the top of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N9 , \\field Bottom Opening Multiplier
       \\note Effective area for air flow at the bottom of the screen divided by the perpendicular
       \\note area between the glass and the bottom of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N10, \\field Left Side Opening Multiplier
       \\note Effective area for air flow at the left side of the screen divided by the perpendicular
       \\note area between the glass and the left side of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N11, \\field Right Side Opening Multiplier
       \\note Effective area for air flow at the right side of the screen divided by the perpendicular
       \\note area between the glass and the right side of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N12; \\field Angle of Resolution for Screen Transmittance Output Map
       \\note Select the resolution of azimuth and altitude angles for the screen transmittance map.
       \\note A value of 0 means no transmittance map will be generated.
       \\note Valid values for this field are 0, 1, 2, 3 and 5.
       \\type choice
       \\units deg
       \\key 0
       \\key 1
       \\key 2
       \\key 3
       \\key 5
       \\default 0

WindowMaterial:Shade:EquivalentLayer,
       \\memo Specifies the properties of equivalent layer window shade material
       \\memo Shades are considered to be perfect diffusers (all transmitted and
       \\memo reflected radiation is hemispherically-diffuse) independent of angle
       \\memo  of incidence. Shade represents roller blinds.
       \\min-fields 6
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  N1 , \\field Shade Beam-Beam Solar Transmittance
       \\note The beam-beam solar transmittance at normal incidence. This value is
       \\note the same as the openness area fraction of the shade material. Assumed
       \\note to be the same for front and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 0.8
       \\default 0.0
  N2 , \\field Front Side Shade Beam-Diffuse Solar Transmittance
       \\required-field
       \\note The front side beam-diffuse solar transmittance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Back Side Shade Beam-Diffuse Solar Transmittance
       \\required-field
       \\note The back side beam-diffuse solar transmittance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N4 , \\field Front Side Shade Beam-Diffuse Solar Reflectance
       \\required-field
       \\note The front side beam-diffuse solar reflectance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N5 , \\field Back Side Shade Beam-Diffuse Solar Reflectance
       \\required-field
       \\note The back side beam-diffuse solar reflectance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N6 , \\field Shade Beam-Beam Visible Transmittance at Normal Incidence
       \\note The beam-beam visible transmittance at normal incidence averaged over the
       \\note visible spectrum range of solar radiation. Assumed to be the same for
       \\note front and back sides of the shade.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N7 , \\field Shade Beam-Diffuse Visible Transmittance at Normal Incidence
       \\note The beam-diffuse visible transmittance at normal incidence averaged over the
       \\note visible spectrum range of solar radiation. Assumed to be the same for
       \\note front and back sides of the shade.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N8 , \\field Shade Beam-Diffuse Visible Reflectance at Normal Incidence
       \\note The beam-diffuse visible reflectance at normal incidence averaged over the
       \\note visible spectrum range of solar radiation. Assumed to be the same for
       \\note front and back sides of the shade.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N9 , \\field Shade Material Infrared Transmittance
       \\note The long-wave transmittance of the shade material at zero shade openness.
       \\note Assumed to be the same for front and back sides of the shade.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0.05
  N10, \\field Front Side Shade Material Infrared Emissivity
       \\note The front side long-wave emissivity of the shade material at zero shade
       \\note openness. Openness fraction is used to calculate the effective emissivity
       \\note value.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.91
  N11; \\field Back Side Shade Material Infrared Emissivity
       \\note The back side long-wave emissivity of the shade material at zero shade
       \\note openness. Openness fraction is used to calculate the effective emissivity
       \\note value.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.91

WindowMaterial:Drape:EquivalentLayer,
       \\memo Specifies the properties of equivalent layer drape fabric materials.
       \\memo Shades are considered to be perfect diffusers (all transmitted and reflected
       \\memo radiation is hemispherically-diffuse) independent of angle of incidence.
       \\memo unpleated drape fabric is treated as thin and flat layer.
       \\min-fields 4
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  N1 , \\field Drape Beam-Beam Solar Transmittance at Normal Incidence
       \\note The beam-beam solar transmittance at normal incidence. This value is the
       \\note same as the openness area fraction of the drape fabric. Assumed to be
       \\note same for front and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 0.2
       \\default 0.0
  N2 , \\field Front Side Drape Beam-Diffuse Solar Transmittance
       \\required-field
       \\note The front side beam-diffuse solar transmittance at normal incidence averaged
       \\note over the entire spectrum of solar radiation. Assumed to be the same for front
       \\note and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Back Side Drape Beam-Diffuse Solar Transmittance
       \\required-field
       \\note The back side beam-diffuse solar transmittance at normal incidence averaged
       \\note over the entire spectrum of solar radiation. Assumed to be the same for front
       \\note and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N4 , \\field Front Side Drape Beam-Diffuse Solar Reflectance
       \\required-field
       \\note The front side beam-diffuse solar reflectance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N5 , \\field Back Side Drape Beam-Diffuse Solar Reflectance
       \\required-field
       \\note The back side beam-diffuse solar reflectance at normal incidence averaged
       \\note over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N6 , \\field Drape Beam-Beam Visible Transmittance
       \\note The beam-beam visible transmittance at normal incidence averaged over the
       \\note visible spectrum of solar radiation. Assumed same for front and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N7 , \\field Drape Beam-Diffuse Visible Transmittance
       \\note The beam-diffuse visible transmittance at normal incidence averaged over the
       \\note visible spectrum range of solar radiation. Assumed to be the same for front
       \\note and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N8 , \\field Drape Beam-Diffuse Visible Reflectance
       \\note The beam-diffuse visible reflectance at normal incidence average over the
       \\note visible spectrum range of solar radiation. Assumed to be the same for front
       \\note and back sides.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N9 , \\field Drape Material Infrared Transmittance
       \\note Long-wave transmittance of the drape fabric at zero openness fraction.
       \\note Assumed same for front and back sides.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0.05
  N10, \\field Front Side Drape Material Infrared Emissivity
       \\note Front side long-wave emissivity of the drape fabric at zero shade openness.
       \\note Openness fraction specified above is used to calculate the effective
       \\note emissivity value.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.87
  N11, \\field Back Side Drape Material Infrared Emissivity
       \\note Back side long-wave emissivity of the drape fabric at zero shade openness.
       \\note Openness fraction specified above is used to calculate the effective
       \\note emissivity value.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.87
  N12, \\field Width of Pleated Fabric
       \\note Width of the pleated section of the draped fabric. If the drape fabric is
       \\note unpleated or is flat, then the pleated section width is set to zero.
       \\type real
       \\units m
       \\minimum 0
       \\ip-units in
       \\default 0
  N13; \\field Length of Pleated Fabric
       \\note Length of the pleated section of the draped fabric. If the drape fabric is
       \\note unpleated or is flat, then the pleated section length is set to zero.
       \\type real
       \\units m
       \\minimum 0
       \\ip-units in
       \\default 0

WindowMaterial:Blind:EquivalentLayer,
       \\memo Window equivalent layer blind slat optical and thermal properties.
       \\memo The model assumes that slats are thin and flat, applies correction
       \\memo empirical correlation to account for curvature effect. Slats are
       \\memo assumed to transmit and reflect diffusely.
       \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  A2 , \\field Slat Orientation
       \\type choice
       \\key Horizontal
       \\key Vertical
       \\default Horizontal
  N1 , \\field Slat Width
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 0.025
       \\ip-units in
  N2 , \\field Slat Separation
       \\required-field
       \\note Distance between adjacent slat faces
       \\units m
       \\type real
       \\minimum> 0
       \\maximum 0.025
       \\ip-units in
  N3 , \\field Slat Crown
       \\note Perpendicular length between the cord and the curve.
       \\note Slat is assumed to be rectangular in cross section
       \\note and flat. Crown=0.0625x"Slat width"
       \\type real
       \\units m
       \\minimum 0
       \\maximum 0.00156
       \\default 0.0015
       \\ip-units in
  N4 , \\field Slat Angle
       \\type real
       \\units deg
       \\minimum -90
       \\maximum 90
       \\default 45
       \\note Slat angle is +ve if the tip of the slat front face is tilted upward, else
       \\note the slat angle is -ve if the tip of the slat front face is tilted downward.
       \\note The slat angle varies between -90 to +90. The default value is 45 degrees.
  N5 , \\field Front Side Slat Beam-Diffuse Solar Transmittance
       \\note The front side beam-diffuse solar transmittance of the slat at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N6 , \\field Back Side Slat Beam-Diffuse Solar Transmittance
       \\note The back side beam-diffuse solar transmittance of the slat at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0
  N7,  \\field Front Side Slat Beam-Diffuse Solar Reflectance
       \\note The front side beam-diffuse solar reflectance of the slat at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N8,  \\field Back Side Slat Beam-Diffuse Solar Reflectance
       \\note The back side beam-diffuse solar reflectance of the slat at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N9 , \\field Front Side Slat Beam-Diffuse Visible Transmittance
       \\note The front side beam-diffuse visible transmittance of the slat
       \\note at normal incidence averaged over the visible spectrum range
       \\note of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0
  N10, \\field Back Side Slat Beam-Diffuse Visible Transmittance
       \\note The back side beam-diffuse visible transmittance of the slat
       \\note at normal incidence averaged over the visible spectrum range
       \\note of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0
  N11, \\field Front Side Slat Beam-Diffuse Visible Reflectance
       \\note The front side beam-diffuse visible reflectance of the slat
       \\note at normal incidence averaged over the visible spectrum range
       \\note of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N12, \\field Back Side Slat Beam-Diffuse Visible Reflectance
       \\note The back side beam-diffuse visible reflectance of the slat
       \\note at normal incidence averaged over the visible spectrum range
       \\note of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N13, \\field Slat Diffuse-Diffuse Solar Transmittance
       \\note The beam-diffuse solar transmittance of the slat averaged
       \\note over the entire solar spectrum of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0
  N14, \\field Front Side Slat Diffuse-Diffuse Solar Reflectance
       \\note The front side beam-diffuse solar reflectance of the slat
       \\note averaged over the entire solar spectrum of solar radiation.
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N15, \\field Back Side Slat Diffuse-Diffuse Solar Reflectance
       \\note The back side beam-diffuse solar reflectance of the slat
       \\note averaged over the entire solar spectrum of solar radiation.
       \\required-field
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N16, \\field Slat Diffuse-Diffuse Visible Transmittance
       \\note The beam-diffuse visible transmittance of the slat averaged
       \\note over the visible spectrum range of solar radiation.
       \\type real
       \\maximum< 1
       \\minimum 0
  N17, \\field Front Side Slat Diffuse-Diffuse Visible Reflectance
       \\note The front side beam-diffuse visible reflectance of the slat
       \\note averaged over the visible spectrum range of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N18, \\field Back Side Slat Diffuse-Diffuse Visible Reflectance
       \\note The back side beam-diffuse visible reflectance of the slat
       \\note averaged over the visible spectrum range of solar radiation.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
  N19, \\field Slat Infrared Transmittance
       \\note Long-wave hemispherical transmittance of the slat material.
       \\note Assumed to be the same for both sides of the slat.
       \\type real
       \\maximum< 1
       \\minimum 0
       \\default 0
  N20, \\field Front Side Slat Infrared Emissivity
       \\note Front side long-wave hemispherical emissivity of the slat material.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  N21, \\field Back Side Slat Infrared Emissivity
       \\note Back side long-wave hemispherical emissivity of the slat material.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum 0
       \\default 0.9
  A3;  \\field Slat Angle Control
       \\note Used only if slat angle control is desired to either maximize solar
       \\note gain (MaximizeSolar), maximize visibility while eliminating beam solar
       \\note radiation (BlockBeamSolar), or fixed slate angle (FixedSlatAngle).
       \\note If FixedSlatAngle is selected, the slat angle entered above is used.
       \\type choice
       \\key FixedSlatAngle
       \\key MaximizeSolar
       \\key BlockBeamSolar
       \\default FixedSlatAngle

WindowMaterial:Screen:EquivalentLayer,
       \\memo Equivalent layer window screen physical properties. Can only be
       \\memo located on the exterior side of a window construction.
       \\min-fields 11
  A1 , \\field Name
       \\note Enter a unique name for this window screen material.
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  N1 , \\field Screen Beam-Beam Solar Transmittance
       \\note The beam-beam transmittance of the screen material at normal incidence.
       \\note This input field is the same as the material openness area fraction
       \\note and can be autocalculated from the wire spacing and wire and diameter.
       \\note Assumed to be the same for both sides of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
       \\autocalculatable
       \\default autocalculate
  N2 , \\field Screen Beam-Diffuse Solar Transmittance
       \\note The beam-diffuse solar transmittance of the screen material at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N3 , \\field Screen Beam-Diffuse Solar Reflectance
       \\note The beam-diffuse solar reflectance of the screen material at normal
       \\note incidence averaged over the entire spectrum of solar radiation.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N4 , \\field Screen Beam-Beam Visible Transmittance
       \\note The beam-beam visible transmittance of the screen material at normal
       \\note incidence averaged over the visible spectrum range of solar radiation.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N5 , \\field Screen Beam-Diffuse Visible Transmittance
       \\note The beam-diffuse visible transmittance of the screen material at normal
       \\note incidence averaged over the visible spectrum range of solar radiation.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N6 , \\field Screen Beam-Diffuse Visible Reflectance
       \\note Beam-diffuse visible reflectance of the screen material at normal
       \\note incidence averaged over the visible spectrum range of solar radiation.
       \\note Assumed to be the same for both sides of the screen.
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
  N7 , \\field Screen Infrared Transmittance
       \\note The long-wave hemispherical transmittance of the screen material.
       \\note Assumed to be the same for both sides of the screen.
       \\type real
       \\units dimensionless
       \\minimum 0
       \\maximum< 1
       \\default 0.02
  N8 , \\field Screen Infrared Emissivity
       \\note The long-wave hemispherical emissivity of the screen material.
       \\note Assumed to be the same for both sides of the screen.
       \\type real
       \\units dimensionless
       \\maximum< 1
       \\minimum> 0
       \\default 0.93
  N9 , \\field Screen Wire Spacing
       \\note Spacing assumed to be the same in both directions.
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
       \\default 0.025
  N10; \\field Screen Wire Diameter
       \\note Diameter assumed to be the same in both directions.
       \\type real
       \\units m
       \\minimum> 0
       \\ip-units in
       \\default 0.005

WindowMaterial:Glazing:EquivalentLayer,
       \\min-fields 11
       \\memo Glass material properties for Windows or Glass Doors
       \\memo Transmittance/Reflectance input method.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  A2 , \\field Optical Data Type
       \\type choice
       \\key Spectral
       \\key SpectralAverage
       \\default SpectralAverage
       \\note Spectral is not currently supported and SpectralAverage is the default.
  A3 , \\field Window Glass Spectral Data Set Name
       \\note Spectral data is not currently supported.
       \\note Used only when Optical Data Type = Spectral
       \\type object-list
       \\object-list SpectralDataSets
  N1 , \\field Front Side Beam-Beam Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N2 , \\field Back Side Beam-Beam Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N3 , \\field Front Side Beam-Beam Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N4 , \\field Back Side Beam-Beam Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N5 , \\field Front Side Beam-Beam Visible Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N6 , \\field Back Side Beam-Beam Visible Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N7 , \\field Front Side Beam-Beam Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N8 , \\field Back Side Beam-Beam Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N9 , \\field Front Side Beam-Diffuse Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N10, \\field Back Side Beam-Diffuse Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N11, \\field Front Side Beam-Diffuse Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N12, \\field Back Side Beam-Diffuse Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\type real
       \\minimum 0.0
       \\units dimensionless
       \\maximum 1.0
       \\default 0.0
  N13, \\field Front Side Beam-Diffuse Visible Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N14, \\field Back Side Beam-Diffuse Visible Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N15, \\field Front Side Beam-Diffuse Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Front Side is side closest to outdoor air
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N16, \\field Back Side Beam-Diffuse Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note Back Side is side closest to zone air
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N17, \\field Diffuse-Diffuse Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note If this field is autocalculate, then the diffuse-diffuse solar
       \\note transmittance is automatically estimated from other inputs and used
       \\note in subsequent calculations. If this field is zero or positive, then
       \\note the value entered here will be used.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
 N18, \\field Front Side Diffuse-Diffuse Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note If this field is autocalculate, then the front diffuse-diffuse solar
       \\note reflectance is automatically estimated from other inputs and used in
       \\note subsequent calculations. If this field is zero or positive, then the value
       \\note entered here will be used. Front Side is side closest to outdoor air.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
  N19, \\field Back Side Diffuse-Diffuse Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note If this field is autocalculate, then the back diffuse-diffuse solar
       \\note reflectance is automatically estimated from other inputs and used in
       \\note subsequent calculations. If this field is zero or positive, then the value
       \\note entered here will be used. Back side is side closest to indoor air.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
  N20, \\field Diffuse-Diffuse Visible Solar Transmittance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note This input field is not used currently.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
 N21,  \\field Front Side Diffuse-Diffuse Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note This input field is not used currently.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
  N22, \\field Back Side Diffuse-Diffuse Visible Solar Reflectance
       \\note Used only when Optical Data Type = SpectralAverage
       \\note This input field is not used currently.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\autocalculatable
       \\default autocalculate
  N23, \\field Infrared Transmittance (applies to front and back)
       \\note The long-wave hemispherical transmittance of the glazing.
       \\note Assumed to be the same for both sides of the glazing.
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N24, \\field Front Side Infrared Emissivity
       \\note The front side long-wave hemispherical emissivity of the glazing.
       \\type real
       \\units dimensionless
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N25, \\field Back Side Infrared Emissivity
       \\note The back side long-wave hemispherical emissivity of the glazing.
       \\type real
       \\units dimensionless
       \\minimum> 0.0
       \\maximum< 1.0
       \\default 0.84
  N26; \\field Thermal Resistance
       \\note This is the R-Value in SI for the glass. The default value is an
       \\note approximation for a single layer of glass at 1/4" inch thickness.
       \\note This field is used only for movable insulation defined with this
       \\note material type.
       \\type real
       \\units m2-K/W
       \\minimum> 0.0
       \\default 0.158

WindowMaterial:Gap:EquivalentLayer,
       \\memo Gas material properties that are used in Windows Equivalent Layer
       \\memo References only WindowMaterial:Gas properties
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowEquivalentLayerMaterialNames
  A2 , \\field Gas Type
       \\required-field
       \\type choice
       \\key AIR
       \\key ARGON
       \\key KRYPTON
       \\key XENON
       \\key CUSTOM
  N1 , \\field Thickness
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\ip-units in
  A3 , \\field Gap Vent Type
       \\required-field
       \\type choice
       \\key Sealed
       \\key VentedIndoor
       \\key VentedOutdoor
       \\note Sealed means the gap is enclosed and gas tight, i.e., no venting to indoor or
       \\note outdoor environment. VentedIndoor means the gap is vented to indoor environment, and
       \\note VentedOutdoor means the gap is vented to the outdoor environment. The gap types
       \\note VentedIndoor and VentedOutdoor are used with gas type "Air" only.
  N2 , \\field Conductivity Coefficient A
       \\units W/m-K
       \\type real
       \\note Used only if Gas Type = Custom
  N3 , \\field Conductivity Coefficient B
       \\units W/m-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N4 , \\field Conductivity Coefficient C
       \\units W/m-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N5 , \\field Viscosity Coefficient A
       \\units kg/m-s
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N6 , \\field Viscosity Coefficient B
       \\units kg/m-s-K
       \\type real
       \\note Used only if Gas Type = Custom
  N7 , \\field Viscosity Coefficient C
       \\units kg/m-s-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N8 , \\field Specific Heat Coefficient A
       \\units J/kg-K
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 0.0
  N9 , \\field Specific Heat Coefficient B
       \\units J/kg-K2
       \\type real
       \\note Used only if Gas Type = Custom
  N10 ,\\field Specific Heat Coefficient C
       \\units J/kg-K3
       \\type real
       \\note Used only if Gas Type = Custom
  N11 ,\\field Molecular Weight
       \\type real
       \\note Used only if Gas Type = Custom
       \\units g/mol
       \\minimum 20.0
       \\maximum 200.0
  N12 ;\\field Specific Heat Ratio
       \\type real
       \\note Used only if Gas Type = Custom
       \\minimum> 1.0

MaterialProperty:MoisturePenetrationDepth:Settings,
    \\memo Additional properties for moisture using EMPD procedure
    \\memo HeatBalanceAlgorithm choice=MoisturePenetrationDepthConductionTransferFunction only
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
    \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Material Name that the moisture properties will be added to.
       \\note Additional material properties required to perform the EMPD model.
       \\note Effective Mean Penetration Depth (EMPD)
  N1 , \\field Water Vapor Diffusion Resistance Factor
       \\required-field
       \\units dimensionless
       \\minimum 0.0
       \\type real
       \\note Ratio of water vapor permeability of stagnant air to water vapor
       \\note permeability of material
  N2 , \\field Moisture Equation Coefficient a
       \\required-field
       \\units dimensionless
       \\type real
  N3 , \\field Moisture Equation Coefficient b
       \\required-field
       \\units dimensionless
       \\type real
  N4 , \\field Moisture Equation Coefficient c
       \\required-field
       \\units dimensionless
       \\type real
  N5 , \\field Moisture Equation Coefficient d
       \\required-field
       \\units dimensionless
       \\type real
  N6 , \\field Surface Layer Penetration Depth
       \\units m
       \\ip-units in
       \\type real
       \\minimum> 0
       \\autocalculatable
       \\default autocalculate
  N7 , \\field Deep Layer Penetration Depth
       \\units m
       \\ip-units in
       \\type real
       \\minimum 0
       \\autocalculatable
       \\default autocalculate
  N8 , \\field Coating Layer Thickness
       \\required-field
       \\type real
       \\units m
       \\ip-units in
       \\minimum 0
  N9 ; \\field Coating Layer Water Vapor Diffusion Resistance Factor
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0
       \\note The coating's resistance to water vapor diffusion relative to the
       \\note resistance to water vapor diffusion in stagnant air
       \\note (see Water Vapor Diffusion Resistance Factor above).

MaterialProperty:PhaseChange,
    \\memo Additional properties for temperature dependent thermal conductivity
    \\memo and enthalpy for Phase Change Materials (PCM)
    \\memo HeatBalanceAlgorithm = CondFD(ConductionFiniteDifference) solution algorithm only.
    \\memo Constructions with this should use the detailed CondFD process.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Regular Material Name to which the additional properties will be added.
       \\note this the material name for the basic material properties.
  N1 , \\field Temperature Coefficient for Thermal Conductivity
       \\note The base temperature is 20C.
       \\note This is the thermal conductivity change per degree excursion from 20C.
       \\note This variable conductivity function is overridden by the VariableThermalConductivity object, if present.
       \\units W/m-K2
       \\type real
       \\default 0.0
  N2 , \\field Temperature 1
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N3,  \\field Enthalpy 1
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 1
       \\units J/kg
  N4 , \\field Temperature 2
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N5,  \\field Enthalpy 2
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 2
       \\units J/kg
       \\type real
  N6 , \\field Temperature 3
       \\required-field
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N7,  \\field Enthalpy 3
       \\required-field
       \\note for Temperature-enthalpy function corresponding to temperature 3
       \\units J/kg
       \\type real
  N8 , \\field Temperature 4
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N9,  \\field Enthalpy 4
       \\note for Temperature-enthalpy function corresponding to temperature 4
       \\units J/kg
       \\type real
  N10, \\field Temperature 5
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N11, \\field Enthalpy 5
       \\note for Temperature-enthalpy function corresponding to temperature 5
       \\units J/kg
       \\type real
  N12, \\field Temperature 6
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N13, \\field Enthalpy 6
       \\note for Temperature-enthalpy function corresponding to temperature 6
       \\units J/kg
       \\type real
  N14, \\field Temperature 7
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N15, \\field Enthalpy 7
       \\note for Temperature-enthalpy function corresponding to temperature 7
       \\units J/kg
       \\type real
  N16, \\field Temperature 8
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N17, \\field Enthalpy 8
       \\note for Temperature-enthalpy function corresponding to temperature 8
       \\units J/kg
       \\type real
  N18 , \\field Temperature 9
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N19,  \\field Enthalpy 9
       \\note for Temperature-enthalpy function corresponding to temperature 1
       \\units J/kg
  N20 , \\field Temperature 10
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N21,  \\field Enthalpy 10
       \\note for Temperature-enthalpy function corresponding to temperature 2
       \\units J/kg
       \\type real
  N22 , \\field Temperature 11
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N23,  \\field Enthalpy 11
       \\note for Temperature-enthalpy function corresponding to temperature 3
       \\units J/kg
       \\type real
  N24 , \\field Temperature 12
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N25,  \\field Enthalpy 12
       \\note for Temperature-enthalpy function corresponding to temperature 14
       \\units J/kg
       \\type real
  N26, \\field Temperature 13
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N27, \\field Enthalpy 13
       \\note for Temperature-enthalpy function corresponding to temperature 15
       \\units J/kg
       \\type real
  N28, \\field Temperature 14
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N29, \\field Enthalpy 14
       \\note for Temperature-enthalpy function corresponding to temperature 16
       \\units J/kg
       \\type real
  N30, \\field Temperature 15
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N31, \\field Enthalpy 15
       \\note for Temperature-enthalpy function corresponding to temperature 17
       \\units J/kg
       \\type real
  N32, \\field Temperature 16
       \\note for Temperature-enthalpy function
       \\units C
       \\type real
  N33; \\field Enthalpy 16
       \\note for Temperature-enthalpy function corresponding to temperature 16
       \\units J/kg
       \\type real

MaterialProperty:PhaseChangeHysteresis,
    \\memo Additional properties for temperature dependent thermal conductivity
    \\memo and enthalpy for Phase Change Materials (PCM) with separate melting and freezing curves.
    \\memo HeatBalanceAlgorithm = CondFD (ConductionFiniteDifference) solution algorithm only.
    \\memo Constructions with this should use the detailed CondFD process.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms.
  A1,  \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Regular Material Name to which the additional properties will be added.
       \\note this the material name for the basic material properties.
  N1 , \\field Latent Heat during the Entire Phase Change Process
       \\note The total latent heat absorbed or rejected during the transition from solid to liquid, or back
       \\required-field
       \\units J/kg
       \\type real
       \\minimum> 0
  N2 , \\field Liquid State Thermal Conductivity
       \\note The thermal conductivity used by this material when the material is fully liquid
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N3 , \\field Liquid State Density
       \\note The density used by this material when the material is fully liquid
       \\required-field
       \\units kg/m3
       \\type real
       \\minimum> 0
  N4 , \\field Liquid State Specific Heat
       \\note The constant specific heat used for the fully melted (liquid) state
       \\required-field
       \\units J/kg-K
       \\type real
       \\minimum> 0
  N5 , \\field High Temperature Difference of Melting Curve
       \\note The total melting range of the material is the sum of low and high temperature difference of melting curve.
       \\required-field
       \\units deltaC
       \\type real
       \\minimum> 0
  N6 , \\field Peak Melting Temperature
       \\note The temperature at which the melting curve peaks
       \\required-field
       \\units C
       \\type real
       \\minimum> 0
  N7 , \\field Low Temperature Difference of Melting Curve
       \\note The total melting range of the material is the sum of low and high temperature difference of melting curve.
       \\required-field
       \\units deltaC
       \\type real
       \\minimum> 0
  N8 , \\field Solid State Thermal Conductivity
       \\note The thermal conductivity used by this material when the material is fully solid
       \\required-field
       \\units W/m-K
       \\type real
       \\minimum> 0
  N9 , \\field Solid State Density
       \\note The density used by this material when the material is fully solid
       \\required-field
       \\units kg/m3
       \\type real
       \\minimum> 0
  N10, \\field Solid State Specific Heat
       \\note The constant specific heat used for the fully frozen (crystallized) state
       \\required-field
       \\units J/kg-K
       \\type real
       \\minimum> 0
  N11, \\field High Temperature Difference of Freezing Curve
       \\note The total freezing range of the material is the sum of low and high temperature difference of freezing curve.
       \\required-field
       \\units deltaC
       \\type real
       \\minimum> 0
  N12, \\field Peak Freezing Temperature
       \\note The temperature at which the freezing curve peaks
       \\required-field
       \\units C
       \\type real
       \\minimum> 0
  N13; \\field Low Temperature Difference of Freezing Curve
       \\note The total freezing range of the material is the sum of low and high temperature difference of freezing curve.
       \\required-field
       \\units deltaC
       \\type real
       \\minimum> 0

MaterialProperty:VariableThermalConductivity,
    \\memo Additional properties for temperature dependent thermal conductivity
    \\memo using piecewise linear temperature-conductivity function.
    \\memo HeatBalanceAlgorithm = CondFD(ConductionFiniteDifference) solution algorithm only.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Regular Material Name to which the additional properties will be added.
       \\note this the material name for the basic material properties.
  N1 , \\field Temperature 1
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N2,  \\field Thermal Conductivity 1
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 1
       \\units W/m-K
  N3 , \\field Temperature 2
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N4,  \\field Thermal Conductivity 2
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 2
       \\units W/m-K
       \\type real
  N5 , \\field Temperature 3
       \\required-field
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N6,  \\field Thermal Conductivity 3
       \\required-field
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 3
       \\units W/m-K
       \\type real
  N7 , \\field Temperature 4
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N8,  \\field Thermal Conductivity 4
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 4
       \\units W/m-K
       \\type real
  N9, \\field Temperature 5
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N10, \\field Thermal Conductivity 5
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 5
       \\units W/m-K
       \\type real
  N11, \\field Temperature 6
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N12, \\field Thermal Conductivity 6
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 6
       \\units W/m-K
       \\type real
  N13, \\field Temperature 7
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N14, \\field Thermal Conductivity 7
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 7
       \\units W/m-K
       \\type real
  N15, \\field Temperature 8
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N16, \\field Thermal Conductivity 8
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 8
       \\units W/m-K
       \\type real
  N17 , \\field Temperature 9
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N18,  \\field Thermal Conductivity 9
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 9
       \\units W/m-K
  N19 , \\field Temperature 10
       \\note for Temperature-Thermal Conductivity function
       \\units C
       \\type real
  N20;  \\field Thermal Conductivity 10
       \\note for Temperature-Thermal Conductivity function corresponding to temperature 10
       \\units W/m-K
       \\type real

MaterialProperty:HeatAndMoistureTransfer:Settings,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Additional material properties for surfaces.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
    \\min-fields 3
  A1, \\field Material Name
      \\required-field
      \\type object-list
      \\object-list MaterialName
      \\note Material Name that the moisture properties will be added to.
      \\note This augments material properties needed for combined heat and moisture transfer for surfaces.
  N1, \\field Porosity
      \\required-field
      \\units m3/m3
      \\minimum 0.0
      \\maximum 1.0
      \\type real
  N2; \\field Initial Water Content Ratio
      \\note units are the water/material density ratio at the beginning of each run period.
      \\units kg/kg
      \\minimum 0.0
      \\default 0.2
      \\type real

MaterialProperty:HeatAndMoistureTransfer:SorptionIsotherm,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between moisture content and relative humidity fraction.
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note The Material Name that the moisture sorption isotherm will be added to.
  N1,  \\field Number of Isotherm Coordinates
       \\required-field
       \\note Number of data Coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Relative Humidity Fraction 1
      \\required-field
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N3, \\field Moisture Content 1
      \\required-field
      \\minimum 0.0
      \\units kg/m3
  N4, \\field Relative Humidity Fraction 2
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N5, \\field Moisture Content 2
      \\minimum 0.0
      \\units kg/m3
  N6, \\field Relative Humidity Fraction 3
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N7, \\field Moisture Content 3
      \\minimum 0.0
      \\units kg/m3
  N8, \\field Relative Humidity Fraction 4
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N9, \\field Moisture Content 4
      \\units kg/m3
      \\minimum 0.0
  N10, \\field Relative Humidity Fraction 5
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N11, \\field Moisture Content 5
      \\minimum 0.0
      \\units kg/m3
  N12, \\field Relative Humidity Fraction 6
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N13, \\field Moisture Content 6
      \\minimum 0.0
      \\units kg/m3
  N14, \\field Relative Humidity Fraction 7
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N15, \\field Moisture Content 7
      \\minimum 0.0
      \\units kg/m3
  N16, \\field Relative Humidity Fraction 8
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N17, \\field Moisture Content 8
      \\minimum 0.0
      \\units kg/m3
  N18,\\field Relative Humidity Fraction 9
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N19, \\field Moisture Content 9
      \\minimum 0.0
      \\units kg/m3
  N20,\\field Relative Humidity Fraction 10
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N21, \\field Moisture Content 10
      \\minimum 0.0
      \\units kg/m3
  N22,\\field Relative Humidity Fraction 11
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N23, \\field Moisture Content 11
      \\minimum 0.0
      \\units kg/m3
  N24,\\field Relative Humidity Fraction 12
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N25, \\field Moisture Content 12
      \\minimum 0.0
      \\units kg/m3
  N26,\\field Relative Humidity Fraction 13
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N27, \\field Moisture Content 13
      \\minimum 0.0
      \\units kg/m3
  N28,\\field Relative Humidity Fraction 14
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N29,\\field Moisture Content 14
      \\minimum 0.0
      \\units kg/m3
  N30,\\field Relative Humidity Fraction 15
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N31,\\field Moisture Content 15
      \\minimum 0.0
      \\units kg/m3
  N32,\\field Relative Humidity Fraction 16
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N33,\\field Moisture Content 16
      \\minimum 0.0
      \\units kg/m3
  N34,\\field Relative Humidity Fraction 17
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N35,\\field Moisture Content 17
      \\minimum 0.0
      \\units kg/m3
  N36,\\field Relative Humidity Fraction 18
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N37,\\field Moisture Content 18
      \\minimum 0.0
      \\units kg/m3
  N38,\\field Relative Humidity Fraction 19
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N39,\\field Moisture Content 19
      \\minimum 0.0
      \\units kg/m3
  N40,\\field Relative Humidity Fraction 20
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N41,\\field Moisture Content 20
      \\minimum 0.0
      \\units kg/m3
  N42,\\field Relative Humidity Fraction 21
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N43,\\field Moisture Content 21
      \\minimum 0.0
      \\units kg/m3
  N44,\\field Relative Humidity Fraction 22
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N45,\\field Moisture Content 22
      \\minimum 0.0
      \\units kg/m3
  N46,\\field Relative Humidity Fraction 23
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N47,\\field Moisture Content 23
      \\minimum 0.0
      \\units kg/m3
  N48,\\field Relative Humidity Fraction 24
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N49,\\field Moisture Content 24
      \\minimum 0.0
      \\units kg/m3
  N50,\\field Relative Humidity Fraction 25
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N51;\\field Moisture Content 25
      \\minimum 0.0
      \\units kg/m3

MaterialProperty:HeatAndMoistureTransfer:Suction,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between liquid suction transport coefficient and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Material Name that the moisture properties will be added to.
  N1,  \\field Number of Suction points
       \\required-field
       \\note Number of Suction Liquid Transport Coefficient coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2,\\field Moisture Content 1
     \\required-field
     \\minimum 0.0
     \\units kg/m3
  N3,\\field Liquid Transport Coefficient 1
     \\required-field
     \\minimum 0.0
     \\units m2/s
  N4,\\field Moisture Content 2
      \\minimum 0.0
     \\units kg/m3
  N5,\\field Liquid Transport Coefficient 2
      \\minimum 0.0
     \\units m2/s
  N6,\\field Moisture Content 3
      \\minimum 0.0
     \\units kg/m3
  N7,\\field Liquid Transport Coefficient 3
      \\minimum 0.0
     \\units m2/s
  N8,\\field Moisture Content 4
      \\minimum 0.0
     \\units kg/m3
  N9,\\field Liquid Transport Coefficient 4
      \\minimum 0.0
     \\units m2/s
  N10,\\field Moisture Content 5
      \\minimum 0.0
     \\units kg/m3
  N11,\\field Liquid Transport Coefficient 5
      \\minimum 0.0
     \\units m2/s
  N12,\\field Moisture Content 6
      \\minimum 0.0
     \\units kg/m3
  N13,\\field Liquid Transport Coefficient 6
      \\minimum 0.0
     \\units m2/s
  N14,\\field Moisture Content 7
      \\minimum 0.0
     \\units kg/m3
  N15,\\field Liquid Transport Coefficient 7
      \\minimum 0.0
     \\units m2/s
  N16,\\field Moisture Content 8
      \\minimum 0.0
     \\units kg/m3
  N17,\\field Liquid Transport Coefficient 8
      \\minimum 0.0
     \\units m2/s
  N18,\\field Moisture Content 9
      \\minimum 0.0
     \\units kg/m3
  N19,\\field Liquid Transport Coefficient 9
      \\minimum 0.0
     \\units m2/s
  N20,\\field Moisture Content 10
      \\minimum 0.0
     \\units kg/m3
  N21,\\field Liquid Transport Coefficient 10
      \\minimum 0.0
     \\units m2/s
  N22,\\field Moisture Content 11
      \\minimum 0.0
     \\units kg/m3
  N23,\\field Liquid Transport Coefficient 11
      \\minimum 0.0
     \\units m2/s
  N24,\\field Moisture Content 12
      \\minimum 0.0
     \\units kg/m3
  N25,\\field Liquid Transport Coefficient 12
      \\minimum 0.0
     \\units m2/s
  N26,\\field Moisture Content 13
      \\minimum 0.0
     \\units kg/m3
  N27,\\field Liquid Transport Coefficient 13
      \\minimum 0.0
     \\units m2/s
  N28,\\field Moisture Content 14
      \\minimum 0.0
     \\units kg/m3
  N29,\\field Liquid Transport Coefficient 14
      \\minimum 0.0
     \\units m2/s
  N30,\\field Moisture Content 15
      \\minimum 0.0
     \\units kg/m3
  N31,\\field Liquid Transport Coefficient 15
      \\minimum 0.0
     \\units m2/s
  N32,\\field Moisture Content 16
      \\minimum 0.0
     \\units kg/m3
  N33,\\field Liquid Transport Coefficient 16
      \\minimum 0.0
     \\units m2/s
  N34,\\field Moisture Content 17
      \\minimum 0.0
     \\units kg/m3
  N35,\\field Liquid Transport Coefficient 17
      \\minimum 0.0
     \\units m2/s
  N36,\\field Moisture Content 18
      \\minimum 0.0
     \\units kg/m3
  N37,\\field Liquid Transport Coefficient 18
      \\minimum 0.0
     \\units m2/s
  N38,\\field Moisture Content 19
      \\minimum 0.0
     \\units kg/m3
  N39,\\field Liquid Transport Coefficient 19
      \\minimum 0.0
     \\units m2/s
  N40,\\field Moisture Content 20
      \\minimum 0.0
     \\units kg/m3
  N41,\\field Liquid Transport Coefficient 20
      \\minimum 0.0
     \\units m2/s
  N42,\\field Moisture Content 21
      \\minimum 0.0
     \\units kg/m3
  N43,\\field Liquid Transport Coefficient 21
      \\minimum 0.0
     \\units m2/s
  N44,\\field Moisture Content 22
      \\minimum 0.0
     \\units kg/m3
  N45,\\field Liquid Transport Coefficient 22
      \\minimum 0.0
     \\units m2/s
  N46,\\field Moisture Content 23
      \\minimum 0.0
     \\units kg/m3
  N47,\\field Liquid Transport Coefficient 23
      \\minimum 0.0
     \\units m2/s
  N48,\\field Moisture Content 24
      \\minimum 0.0
     \\units kg/m3
  N49,\\field Liquid Transport Coefficient 24
      \\minimum 0.0
     \\units m2/s
  N50,\\field Moisture Content 25
      \\minimum 0.0
     \\units kg/m3
  N51;\\field Liquid Transport Coefficient 25
      \\minimum 0.0
     \\units m2/s

MaterialProperty:HeatAndMoistureTransfer:Redistribution,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between liquid transport coefficient and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the moisture properties will be added to.
  N1,  \\field Number of Redistribution points
       \\required-field
       \\note number of data points
       \\minimum 1
       \\maximum 25
       \\type integer
  N2,\\field Moisture Content 1
     \\minimum 0.0
     \\required-field
     \\units kg/m3
  N3,\\field Liquid Transport Coefficient 1
     \\minimum 0.0
     \\required-field
     \\units m2/s
  N4,\\field Moisture Content 2
      \\minimum 0.0
     \\units kg/m3
  N5,\\field Liquid Transport Coefficient 2
      \\minimum 0.0
     \\units m2/s
  N6,\\field Moisture Content 3
      \\minimum 0.0
     \\units kg/m3
  N7,\\field Liquid Transport Coefficient 3
      \\minimum 0.0
     \\units m2/s
  N8,\\field Moisture Content 4
      \\minimum 0.0
     \\units kg/m3
  N9,\\field Liquid Transport Coefficient 4
      \\minimum 0.0
     \\units m2/s
  N10,\\field Moisture Content 5
      \\minimum 0.0
     \\units kg/m3
  N11,\\field Liquid Transport Coefficient 5
      \\minimum 0.0
     \\units m2/s
  N12,\\field Moisture Content 6
      \\minimum 0.0
     \\units kg/m3
  N13,\\field Liquid Transport Coefficient 6
      \\minimum 0.0
     \\units m2/s
  N14,\\field Moisture Content 7
      \\minimum 0.0
     \\units kg/m3
  N15,\\field Liquid Transport Coefficient 7
      \\minimum 0.0
     \\units m2/s
  N16,\\field Moisture Content 8
      \\minimum 0.0
     \\units kg/m3
  N17,\\field Liquid Transport Coefficient 8
      \\minimum 0.0
     \\units m2/s
  N18,\\field Moisture Content 9
      \\minimum 0.0
     \\units kg/m3
  N19,\\field Liquid Transport Coefficient 9
      \\minimum 0.0
     \\units m2/s
  N20,\\field Moisture Content 10
      \\minimum 0.0
     \\units kg/m3
  N21,\\field Liquid Transport Coefficient 10
      \\minimum 0.0
     \\units m2/s
  N22,\\field Moisture Content 11
      \\minimum 0.0
     \\units kg/m3
  N23,\\field Liquid Transport Coefficient 11
      \\minimum 0.0
     \\units m2/s
  N24,\\field Moisture Content 12
      \\minimum 0.0
     \\units kg/m3
  N25,\\field Liquid Transport Coefficient 12
      \\minimum 0.0
     \\units m2/s
  N26,\\field Moisture Content 13
      \\minimum 0.0
     \\units kg/m3
  N27,\\field Liquid Transport Coefficient 13
      \\minimum 0.0
     \\units m2/s
  N28,\\field Moisture Content 14
      \\minimum 0.0
     \\units kg/m3
  N29,\\field Liquid Transport Coefficient 14
      \\minimum 0.0
     \\units m2/s
  N30,\\field Moisture Content 15
      \\minimum 0.0
     \\units kg/m3
  N31,\\field Liquid Transport Coefficient 15
      \\minimum 0.0
     \\units m2/s
  N32,\\field Moisture Content 16
      \\minimum 0.0
     \\units kg/m3
  N33,\\field Liquid Transport Coefficient 16
      \\minimum 0.0
     \\units m2/s
  N34,\\field Moisture Content 17
      \\minimum 0.0
     \\units kg/m3
  N35,\\field Liquid Transport Coefficient 17
      \\minimum 0.0
     \\units m2/s
  N36,\\field Moisture Content 18
      \\minimum 0.0
     \\units kg/m3
  N37,\\field Liquid Transport Coefficient 18
      \\minimum 0.0
     \\units m2/s
  N38,\\field Moisture Content 19
      \\minimum 0.0
     \\units kg/m3
  N39,\\field Liquid Transport Coefficient 19
      \\minimum 0.0
     \\units m2/s
  N40,\\field Moisture Content 20
      \\minimum 0.0
     \\units kg/m3
  N41,\\field Liquid Transport Coefficient 20
      \\minimum 0.0
     \\units m2/s
  N42,\\field Moisture Content 21
      \\minimum 0.0
     \\units kg/m3
  N43,\\field Liquid Transport Coefficient 21
      \\minimum 0.0
     \\units m2/s
  N44,\\field Moisture Content 22
      \\minimum 0.0
     \\units kg/m3
  N45,\\field Liquid Transport Coefficient 22
      \\minimum 0.0
     \\units m2/s
  N46,\\field Moisture Content 23
      \\minimum 0.0
     \\units kg/m3
  N47,\\field Liquid Transport Coefficient 23
      \\minimum 0.0
     \\units m2/s
  N48,\\field Moisture Content 24
      \\minimum 0.0
     \\units kg/m3
  N49,\\field Liquid Transport Coefficient 24
      \\minimum 0.0
     \\units m2/s
  N50,\\field Moisture Content 25
      \\minimum 0.0
     \\units kg/m3
  N51;\\field Liquid Transport Coefficient 25
      \\minimum 0.0
     \\units m2/s

MaterialProperty:HeatAndMoistureTransfer:Diffusion,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between water vapor diffusion and relative humidity fraction
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the moisture properties will be added to.
  N1,  \\field Number of Data Pairs
       \\required-field
       \\note Water Vapor Diffusion Resistance Factor
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Relative Humidity Fraction 1
      \\required-field
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N3,\\field Water Vapor Diffusion Resistance Factor 1
      \\required-field
      \\minimum 0.0
      \\units dimensionless
  N4, \\field Relative Humidity Fraction 2
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N5,\\field Water Vapor Diffusion Resistance Factor 2
      \\minimum 0.0
      \\units dimensionless
  N6, \\field Relative Humidity Fraction 3
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N7,\\field Water Vapor Diffusion Resistance Factor 3
      \\minimum 0.0
      \\units dimensionless
  N8, \\field Relative Humidity Fraction 4
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N9,\\field Water Vapor Diffusion Resistance Factor 4
      \\minimum 0.0
      \\units dimensionless
  N10, \\field Relative Humidity Fraction 5
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N11,\\field Water Vapor Diffusion Resistance Factor 5
      \\minimum 0.0
      \\units dimensionless
  N12,\\field Relative Humidity Fraction 6
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N13,\\field Water Vapor Diffusion Resistance Factor 6
      \\minimum 0.0
      \\units dimensionless
  N14,\\field Relative Humidity Fraction 7
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N15,\\field Water Vapor Diffusion Resistance Factor 7
      \\minimum 0.0
      \\units dimensionless
  N16,\\field Relative Humidity Fraction 8
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N17,\\field Water Vapor Diffusion Resistance Factor 8
      \\minimum 0.0
      \\units dimensionless
  N18,\\field Relative Humidity Fraction 9
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N19,\\field Water Vapor Diffusion Resistance Factor 9
      \\minimum 0.0
      \\units dimensionless
  N20,\\field Relative Humidity Fraction 10
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N21,\\field Water Vapor Diffusion Resistance Factor 10
      \\minimum 0.0
      \\units dimensionless
  N22,\\field Relative Humidity Fraction 11
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N23,\\field Water Vapor Diffusion Resistance Factor 11
      \\minimum 0.0
      \\units dimensionless
 N24,\\field Relative Humidity Fraction 12
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N25,\\field Water Vapor Diffusion Resistance Factor 12
      \\minimum 0.0
      \\units dimensionless
  N26,\\field Relative Humidity Fraction 13
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N27,\\field Water Vapor Diffusion Resistance Factor 13
      \\minimum 0.0
      \\units dimensionless
  N28,\\field Relative Humidity Fraction 14
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N29,\\field Water Vapor Diffusion Resistance Factor 14
      \\minimum 0.0
      \\units dimensionless
  N30,\\field Relative Humidity Fraction 15
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N31,\\field Water Vapor Diffusion Resistance Factor 15
      \\minimum 0.0
      \\units dimensionless
  N32,\\field Relative Humidity Fraction 16
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N33,\\field Water Vapor Diffusion Resistance Factor 16
      \\minimum 0.0
      \\units dimensionless
  N34,\\field Relative Humidity Fraction 17
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N35,\\field Water Vapor Diffusion Resistance Factor 17
      \\minimum 0.0
      \\units dimensionless
  N36,\\field Relative Humidity Fraction 18
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N37,\\field Water Vapor Diffusion Resistance Factor 18
      \\minimum 0.0
      \\units dimensionless
  N38,\\field Relative Humidity Fraction 19
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N39,\\field Water Vapor Diffusion Resistance Factor 19
      \\minimum 0.0
      \\units dimensionless
  N40,\\field Relative Humidity Fraction 20
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N41,\\field Water Vapor Diffusion Resistance Factor 20
      \\minimum 0.0
      \\units dimensionless
  N42,\\field Relative Humidity Fraction 21
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N43,\\field Water Vapor Diffusion Resistance Factor 21
      \\minimum 0.0
      \\units dimensionless
  N44,\\field Relative Humidity Fraction 22
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N45,\\field Water Vapor Diffusion Resistance Factor 22
      \\minimum 0.0
      \\units dimensionless
  N46,\\field Relative Humidity Fraction 23
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N47,\\field Water Vapor Diffusion Resistance Factor 23
      \\minimum 0.0
      \\units dimensionless
  N48,\\field Relative Humidity Fraction 24
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N49,\\field Water Vapor Diffusion Resistance Factor 24
      \\minimum 0.0
      \\units dimensionless
  N50,\\field Relative Humidity Fraction 25
      \\note The relative humidity is entered as a fraction.
      \\minimum 0.0
      \\maximum 1.0
      \\units dimensionless
  N51;\\field Water Vapor Diffusion Resistance Factor 25
      \\minimum 0.0
      \\units dimensionless

MaterialProperty:HeatAndMoistureTransfer:ThermalConductivity,
    \\memo HeatBalanceAlgorithm = CombinedHeatAndMoistureFiniteElement solution algorithm only.
    \\memo Relationship between thermal conductivity and moisture content
    \\memo Has no effect with other HeatBalanceAlgorithm solution algorithms
  A1 , \\field Material Name
       \\required-field
       \\type object-list
       \\object-list MaterialName
       \\note Moisture Material Name that the Thermal Conductivity will be added to.
  N1,  \\field Number of Thermal Coordinates
       \\required-field
       \\note number of data coordinates
       \\minimum 1
       \\maximum 25
       \\type integer
  N2, \\field Moisture Content 1
      \\required-field
      \\minimum 0.0
      \\units kg/m3
  N3, \\field Thermal Conductivity 1
      \\required-field
      \\minimum> 0.0
      \\units W/m-K
  N4, \\field Moisture Content 2
      \\minimum 0.0
      \\units kg/m3
  N5, \\field Thermal Conductivity 2
      \\minimum> 0.0
      \\units W/m-K
  N6, \\field Moisture Content 3
      \\minimum 0.0
      \\units kg/m3
  N7, \\field Thermal Conductivity 3
      \\minimum> 0.0
      \\units W/m-K
  N8, \\field Moisture Content 4
      \\minimum 0.0
      \\units kg/m3
  N9, \\field Thermal Conductivity 4
      \\minimum> 0.0
      \\units W/m-K
  N10, \\field Moisture Content 5
      \\minimum 0.0
      \\units kg/m3
  N11,\\field Thermal Conductivity 5
      \\minimum> 0.0
      \\units W/m-K
  N12, \\field Moisture Content 6
      \\minimum 0.0
      \\units kg/m3
  N13,\\field Thermal Conductivity 6
      \\minimum> 0.0
      \\units W/m-K
  N14,\\field Moisture Content 7
      \\minimum 0.0
      \\units kg/m3
  N15,\\field Thermal Conductivity 7
      \\minimum> 0.0
      \\units W/m-K
  N16,\\field Moisture Content 8
      \\minimum 0.0
      \\units kg/m3
  N17,\\field Thermal Conductivity 8
      \\minimum> 0.0
      \\units W/m-K
  N18,\\field Moisture Content 9
      \\minimum 0.0
      \\units kg/m3
  N19,\\field Thermal Conductivity 9
      \\minimum> 0.0
      \\units W/m-K
  N20,\\field Moisture Content 10
      \\minimum 0.0
      \\units kg/m3
  N21,\\field Thermal Conductivity 10
      \\minimum> 0.0
      \\units W/m-K
  N22,\\field Moisture Content 11
      \\minimum 0.0
      \\units kg/m3
  N23,\\field Thermal Conductivity 11
      \\minimum> 0.0
      \\units W/m-K
  N24,\\field Moisture Content 12
      \\minimum 0.0
      \\units kg/m3
  N25,\\field Thermal Conductivity 12
      \\minimum> 0.0
      \\units W/m-K
  N26,\\field Moisture Content 13
      \\minimum 0.0
      \\units kg/m3
  N27,\\field Thermal Conductivity 13
      \\minimum> 0.0
      \\units W/m-K
  N28,\\field Moisture Content 14
      \\minimum 0.0
      \\units kg/m3
  N29,\\field Thermal Conductivity 14
      \\minimum> 0.0
      \\units W/m-K
  N30,\\field Moisture Content 15
      \\minimum 0.0
      \\units kg/m3
  N31,\\field Thermal Conductivity 15
      \\minimum> 0.0
      \\units W/m-K
  N32,\\field Moisture Content 16
      \\minimum 0.0
      \\units kg/m3
  N33,\\field Thermal Conductivity 16
      \\minimum> 0.0
      \\units W/m-K
  N34,\\field Moisture Content 17
      \\minimum 0.0
      \\units kg/m3
  N35,\\field Thermal Conductivity 17
      \\minimum> 0.0
      \\units W/m-K
  N36,\\field Moisture Content 18
      \\minimum 0.0
      \\units kg/m3
  N37,\\field Thermal Conductivity 18
      \\minimum> 0.0
      \\units W/m-K
  N38,\\field Moisture Content 19
      \\minimum 0.0
      \\units kg/m3
  N39,\\field Thermal Conductivity 19
      \\minimum> 0.0
      \\units W/m-K
  N40,\\field Moisture Content 20
      \\minimum 0.0
      \\units kg/m3
  N41,\\field Thermal Conductivity 20
      \\minimum> 0.0
      \\units W/m-K
  N42,\\field Moisture Content 21
      \\minimum 0.0
      \\units kg/m3
  N43,\\field Thermal Conductivity 21
      \\minimum> 0.0
      \\units W/m-K
  N44,\\field Moisture Content 22
      \\minimum 0.0
      \\units kg/m3
  N45,\\field Thermal Conductivity 22
      \\minimum> 0.0
      \\units W/m-K
  N46,\\field Moisture Content 23
      \\minimum 0.0
      \\units kg/m3
  N47,\\field Thermal Conductivity 23
      \\minimum> 0.0
      \\units W/m-K
  N48,\\field Moisture Content 24
      \\minimum 0.0
      \\units kg/m3
  N49,\\field Thermal Conductivity 24
      \\minimum> 0.0
      \\units W/m-K
  N50,\\field Moisture Content 25
      \\minimum 0.0
      \\units kg/m3
  N51;\\field Thermal Conductivity 25
      \\minimum> 0.0
      \\units W/m-K

MaterialProperty:GlazingSpectralData,
       \\memo Name is followed by up to 800 sets of normal-incidence measured values of
       \\memo [wavelength, transmittance, front reflectance, back reflectance] for wavelengths
       \\memo covering the solar spectrum (from about 0.25 to 2.5 microns)
       \\format Spectral
       \\extensible:4
  A1,  \\field Name
       \\required-field
       \\reference SpectralDataSets
  N1,  \\field Wavelength 1
       \\type real
       \\units micron
  N2,  \\field Transmittance 1
  N3,  \\field Front Reflectance 1
  N4,  \\field Back Reflectance 1
  N5,  \\field Wavelength 2
       \\type real
       \\units micron
  N6,  \\field Transmittance 2
  N7,  \\field Front Reflectance 2
  N8,  \\field Back Reflectance 2
  N9,  \\field Wavelength 3
       \\type real
       \\units micron
  N10, \\field Transmittance 3
  N11, \\field Front Reflectance 3
  N12, \\field Back Reflectance 3
  N13, \\field Wavelength 4
       \\type real
       \\units micron
  N14, \\field Transmittance 4
  N15, \\field Front Reflectance 4
  N16, \\field Back Reflectance 4
  N17, \\field Wavelength 5
       \\begin-extensible
       \\type real
       \\units micron
  N18, \\field Transmittance 5
  N19, \\field Front Reflectance 5
  N20, \\field Back Reflectance 5
  N21,N22,N23,N24,     N25,N26,N27,N28,     N29,N30,N31,N32,     N33,N34,N35,N36,     N37,N38,N39,N40, \\note fields as indicated
  N41,N42,N43,N44,     N45,N46,N47,N48,     N49,N50,N51,N52,     N53,N54,N55,N56,     N57,N58,N59,N60, \\note fields as indicated
  N61,N62,N63,N64,     N65,N66,N67,N68,     N69,N70,N71,N72,     N73,N74,N75,N76,     N77,N78,N79,N80, \\note fields as indicated
  N81,N82,N83,N84,     N85,N86,N87,N88,     N89,N90,N91,N92,     N93,N94,N95,N96,     N97,N98,N99,N100, \\note fields as indicated

  N101,N102,N103,N104, N105,N106,N107,N108, N109,N110,N111,N112, N113,N114,N115,N116, N117,N118,N119,N120, \\note fields as indicated
  N121,N122,N123,N124, N125,N126,N127,N128, N129,N130,N131,N132, N133,N134,N135,N136, N137,N138,N139,N140, \\note fields as indicated
  N141,N142,N143,N144, N145,N146,N147,N148, N149,N150,N151,N152, N153,N154,N155,N156, N157,N158,N159,N160, \\note fields as indicated
  N161,N162,N163,N164, N165,N166,N167,N168, N169,N170,N171,N172, N173,N174,N175,N176, N177,N178,N179,N180, \\note fields as indicated
  N181,N182,N183,N184, N185,N186,N187,N188, N189,N190,N191,N192, N193,N194,N195,N196, N197,N198,N199,N200, \\note fields as indicated

  N201,N202,N203,N204, N205,N206,N207,N208, N209,N210,N211,N212, N213,N214,N215,N216, N217,N218,N219,N220, \\note fields as indicated
  N221,N222,N223,N224, N225,N226,N227,N228, N229,N230,N231,N232, N233,N234,N235,N236, N237,N238,N239,N240, \\note fields as indicated
  N241,N242,N243,N244, N245,N246,N247,N248, N249,N250,N251,N252, N253,N254,N255,N256, N257,N258,N259,N260, \\note fields as indicated
  N261,N262,N263,N264, N265,N266,N267,N268, N269,N270,N271,N272, N273,N274,N275,N276, N277,N278,N279,N280, \\note fields as indicated
  N281,N282,N283,N284, N285,N286,N287,N288, N289,N290,N291,N292, N293,N294,N295,N296, N297,N298,N299,N300, \\note fields as indicated

  N301,N302,N303,N304, N305,N306,N307,N308, N309,N310,N311,N312, N313,N314,N315,N316, N317,N318,N319,N320, \\note fields as indicated
  N321,N322,N323,N324, N325,N326,N327,N328, N329,N330,N331,N332, N333,N334,N335,N336, N337,N338,N339,N340, \\note fields as indicated
  N341,N342,N343,N344, N345,N346,N347,N348, N349,N350,N351,N352, N353,N354,N355,N356, N357,N358,N359,N360, \\note fields as indicated
  N361,N362,N363,N364, N365,N366,N367,N368, N369,N370,N371,N372, N373,N374,N375,N376, N377,N378,N379,N380, \\note fields as indicated
  N381,N382,N383,N384, N385,N386,N387,N388, N389,N390,N391,N392, N393,N394,N395,N396, N397,N398,N399,N400, \\note fields as indicated

  N401,N402,N403,N404, N405,N406,N407,N408, N409,N410,N411,N412, N413,N414,N415,N416, N417,N418,N419,N420, \\note fields as indicated
  N421,N422,N423,N424, N425,N426,N427,N428, N429,N430,N431,N432, N433,N434,N435,N436, N437,N438,N439,N440, \\note fields as indicated
  N441,N442,N443,N444, N445,N446,N447,N448, N449,N450,N451,N452, N453,N454,N455,N456, N457,N458,N459,N460, \\note fields as indicated
  N461,N462,N463,N464, N465,N466,N467,N468, N469,N470,N471,N472, N473,N474,N475,N476, N477,N478,N479,N480, \\note fields as indicated
  N481,N482,N483,N484, N485,N486,N487,N488, N489,N490,N491,N492, N493,N494,N495,N496, N497,N498,N499,N500, \\note fields as indicated

  N501,N502,N503,N504, N505,N506,N507,N508, N509,N510,N511,N512, N513,N514,N515,N516, N517,N518,N519,N520, \\note fields as indicated
  N521,N522,N523,N524, N525,N526,N527,N528, N529,N530,N531,N532, N533,N534,N535,N536, N537,N538,N539,N540, \\note fields as indicated
  N541,N542,N543,N544, N545,N546,N547,N548, N549,N550,N551,N552, N553,N554,N555,N556, N557,N558,N559,N560, \\note fields as indicated
  N561,N562,N563,N564, N565,N566,N567,N568, N569,N570,N571,N572, N573,N574,N575,N576, N577,N578,N579,N580, \\note fields as indicated
  N581,N582,N583,N584, N585,N586,N587,N588, N589,N590,N591,N592, N593,N594,N595,N596, N597,N598,N599,N600, \\note fields as indicated

  N601,N602,N603,N604, N605,N606,N607,N608, N609,N610,N611,N612, N613,N614,N615,N616, N617,N618,N619,N620, \\note fields as indicated
  N621,N622,N623,N624, N625,N626,N627,N628, N629,N630,N631,N632, N633,N634,N635,N636, N637,N638,N639,N640, \\note fields as indicated
  N641,N642,N643,N644, N645,N646,N647,N648, N649,N650,N651,N652, N653,N654,N655,N656, N657,N658,N659,N660, \\note fields as indicated
  N661,N662,N663,N664, N665,N666,N667,N668, N669,N670,N671,N672, N673,N674,N675,N676, N677,N678,N679,N680, \\note fields as indicated
  N681,N682,N683,N684, N685,N686,N687,N688, N689,N690,N691,N692, N693,N694,N695,N696, N697,N698,N699,N700, \\note fields as indicated

  N701,N702,N703,N704, N705,N706,N707,N708, N709,N710,N711,N712, N713,N714,N715,N716, N717,N718,N719,N720, \\note fields as indicated
  N721,N722,N723,N724, N725,N726,N727,N728, N729,N730,N731,N732, N733,N734,N735,N736, N737,N738,N739,N740, \\note fields as indicated
  N741,N742,N743,N744, N745,N746,N747,N748, N749,N750,N751,N752, N753,N754,N755,N756, N757,N758,N759,N760, \\note fields as indicated
  N761,N762,N763,N764, N765,N766,N767,N768, N769,N770,N771,N772, N773,N774,N775,N776, N777,N778,N779,N780, \\note fields as indicated
  N781,N782,N783,N784, N785,N786,N787,N788, N789,N790,N791,N792, N793,N794,N795,N796, N797,N798,N799,N800, \\note fields as indicated

  N801,N802,N803,N804, N805,N806,N807,N808, N809,N810,N811,N812, N813,N814,N815,N816, N817,N818,N819,N820, \\note fields as indicated
  N821,N822,N823,N824, N825,N826,N827,N828, N829,N830,N831,N832, N833,N834,N835,N836, N837,N838,N839,N840, \\note fields as indicated
  N841,N842,N843,N844, N845,N846,N847,N848, N849,N850,N851,N852, N853,N854,N855,N856, N857,N858,N859,N860, \\note fields as indicated
  N861,N862,N863,N864, N865,N866,N867,N868, N869,N870,N871,N872, N873,N874,N875,N876, N877,N878,N879,N880, \\note fields as indicated
  N881,N882,N883,N884, N885,N886,N887,N888, N889,N890,N891,N892, N893,N894,N895,N896, N897,N898,N899,N900, \\note fields as indicated

  N901,N902,N903,N904, N905,N906,N907,N908, N909,N910,N911,N912, N913,N914,N915,N916, N917,N918,N919,N920, \\note fields as indicated
  N921,N922,N923,N924, N925,N926,N927,N928, N929,N930,N931,N932, N933,N934,N935,N936, N937,N938,N939,N940, \\note fields as indicated
  N941,N942,N943,N944, N945,N946,N947,N948, N949,N950,N951,N952, N953,N954,N955,N956, N957,N958,N959,N960, \\note fields as indicated
  N961,N962,N963,N964, N965,N966,N967,N968, N969,N970,N971,N972, N973,N974,N975,N976, N977,N978,N979,N980, \\note fields as indicated
  N981,N982,N983,N984, N985,N986,N987,N988, N989,N990,N991,N992, N993,N994,N995,N996, N997,N998,N999,N1000, \\note fields as indicated

  N1001,N1002,N1003,N1004, N1005,N1006,N1007,N1008, N1009,N1010,N1011,N1012, N1013,N1014,N1015,N1016, N1017,N1018,N1019,N1020, \\note fields as indicated
  N1021,N1022,N1023,N1024, N1025,N1026,N1027,N1028, N1029,N1030,N1031,N1032, N1033,N1034,N1035,N1036, N1037,N1038,N1039,N1040, \\note fields as indicated
  N1041,N1042,N1043,N1044, N1045,N1046,N1047,N1048, N1049,N1050,N1051,N1052, N1053,N1054,N1055,N1056, N1057,N1058,N1059,N1060, \\note fields as indicated
  N1061,N1062,N1063,N1064, N1065,N1066,N1067,N1068, N1069,N1070,N1071,N1072, N1073,N1074,N1075,N1076, N1077,N1078,N1079,N1080, \\note fields as indicated
  N1081,N1082,N1083,N1084, N1085,N1086,N1087,N1088, N1089,N1090,N1091,N1092, N1093,N1094,N1095,N1096, N1097,N1098,N1099,N1100, \\note fields as indicated

  N1101,N1102,N1103,N1104, N1105,N1106,N1107,N1108, N1109,N1110,N1111,N1112, N1113,N1114,N1115,N1116, N1117,N1118,N1119,N1120, \\note fields as indicated
  N1121,N1122,N1123,N1124, N1125,N1126,N1127,N1128, N1129,N1130,N1131,N1132, N1133,N1134,N1135,N1136, N1137,N1138,N1139,N1140, \\note fields as indicated
  N1141,N1142,N1143,N1144, N1145,N1146,N1147,N1148, N1149,N1150,N1151,N1152, N1153,N1154,N1155,N1156, N1157,N1158,N1159,N1160, \\note fields as indicated
  N1161,N1162,N1163,N1164, N1165,N1166,N1167,N1168, N1169,N1170,N1171,N1172, N1173,N1174,N1175,N1176, N1177,N1178,N1179,N1180, \\note fields as indicated
  N1181,N1182,N1183,N1184, N1185,N1186,N1187,N1188, N1189,N1190,N1191,N1192, N1193,N1194,N1195,N1196, N1197,N1198,N1199,N1200, \\note fields as indicated

  N1201,N1202,N1203,N1204, N1205,N1206,N1207,N1208, N1209,N1210,N1211,N1212, N1213,N1214,N1215,N1216, N1217,N1218,N1219,N1220, \\note fields as indicated
  N1221,N1222,N1223,N1224, N1225,N1226,N1227,N1228, N1229,N1230,N1231,N1232, N1233,N1234,N1235,N1236, N1237,N1238,N1239,N1240, \\note fields as indicated
  N1241,N1242,N1243,N1244, N1245,N1246,N1247,N1248, N1249,N1250,N1251,N1252, N1253,N1254,N1255,N1256, N1257,N1258,N1259,N1260, \\note fields as indicated
  N1261,N1262,N1263,N1264, N1265,N1266,N1267,N1268, N1269,N1270,N1271,N1272, N1273,N1274,N1275,N1276, N1277,N1278,N1279,N1280, \\note fields as indicated
  N1281,N1282,N1283,N1284, N1285,N1286,N1287,N1288, N1289,N1290,N1291,N1292, N1293,N1294,N1295,N1296, N1297,N1298,N1299,N1300, \\note fields as indicated

  N1301,N1302,N1303,N1304, N1305,N1306,N1307,N1308, N1309,N1310,N1311,N1312, N1313,N1314,N1315,N1316, N1317,N1318,N1319,N1320, \\note fields as indicated
  N1321,N1322,N1323,N1324, N1325,N1326,N1327,N1328, N1329,N1330,N1331,N1332, N1333,N1334,N1335,N1336, N1337,N1338,N1339,N1340, \\note fields as indicated
  N1341,N1342,N1343,N1344, N1345,N1346,N1347,N1348, N1349,N1350,N1351,N1352, N1353,N1354,N1355,N1356, N1357,N1358,N1359,N1360, \\note fields as indicated
  N1361,N1362,N1363,N1364, N1365,N1366,N1367,N1368, N1369,N1370,N1371,N1372, N1373,N1374,N1375,N1376, N1377,N1378,N1379,N1380, \\note fields as indicated
  N1381,N1382,N1383,N1384, N1385,N1386,N1387,N1388, N1389,N1390,N1391,N1392, N1393,N1394,N1395,N1396, N1397,N1398,N1399,N1400, \\note fields as indicated

  N1401,N1402,N1403,N1404, N1405,N1406,N1407,N1408, N1409,N1410,N1411,N1412, N1413,N1414,N1415,N1416, N1417,N1418,N1419,N1420, \\note fields as indicated
  N1421,N1422,N1423,N1424, N1425,N1426,N1427,N1428, N1429,N1430,N1431,N1432, N1433,N1434,N1435,N1436, N1437,N1438,N1439,N1440, \\note fields as indicated
  N1441,N1442,N1443,N1444, N1445,N1446,N1447,N1448, N1449,N1450,N1451,N1452, N1453,N1454,N1455,N1456, N1457,N1458,N1459,N1460, \\note fields as indicated
  N1461,N1462,N1463,N1464, N1465,N1466,N1467,N1468, N1469,N1470,N1471,N1472, N1473,N1474,N1475,N1476, N1477,N1478,N1479,N1480, \\note fields as indicated
  N1481,N1482,N1483,N1484, N1485,N1486,N1487,N1488, N1489,N1490,N1491,N1492, N1493,N1494,N1495,N1496, N1497,N1498,N1499,N1500, \\note fields as indicated

  N1501,N1502,N1503,N1504, N1505,N1506,N1507,N1508, N1509,N1510,N1511,N1512, N1513,N1514,N1515,N1516, N1517,N1518,N1519,N1520, \\note fields as indicated
  N1521,N1522,N1523,N1524, N1525,N1526,N1527,N1528, N1529,N1530,N1531,N1532, N1533,N1534,N1535,N1536, N1537,N1538,N1539,N1540, \\note fields as indicated
  N1541,N1542,N1543,N1544, N1545,N1546,N1547,N1548, N1549,N1550,N1551,N1552, N1553,N1554,N1555,N1556, N1557,N1558,N1559,N1560, \\note fields as indicated
  N1561,N1562,N1563,N1564, N1565,N1566,N1567,N1568, N1569,N1570,N1571,N1572, N1573,N1574,N1575,N1576, N1577,N1578,N1579,N1580, \\note fields as indicated
  N1581,N1582,N1583,N1584, N1585,N1586,N1587,N1588, N1589,N1590,N1591,N1592, N1593,N1594,N1595,N1596, N1597,N1598,N1599,N1600, \\note fields as indicated

  N1601,N1602,N1603,N1604, N1605,N1606,N1607,N1608, N1609,N1610,N1611,N1612, N1613,N1614,N1615,N1616, N1617,N1618,N1619,N1620, \\note fields as indicated
  N1621,N1622,N1623,N1624, N1625,N1626,N1627,N1628, N1629,N1630,N1631,N1632, N1633,N1634,N1635,N1636, N1637,N1638,N1639,N1640, \\note fields as indicated
  N1641,N1642,N1643,N1644, N1645,N1646,N1647,N1648, N1649,N1650,N1651,N1652, N1653,N1654,N1655,N1656, N1657,N1658,N1659,N1660, \\note fields as indicated
  N1661,N1662,N1663,N1664, N1665,N1666,N1667,N1668, N1669,N1670,N1671,N1672, N1673,N1674,N1675,N1676, N1677,N1678,N1679,N1680, \\note fields as indicated
  N1681,N1682,N1683,N1684, N1685,N1686,N1687,N1688, N1689,N1690,N1691,N1692, N1693,N1694,N1695,N1696, N1697,N1698,N1699,N1700, \\note fields as indicated

  N1701,N1702,N1703,N1704, N1705,N1706,N1707,N1708, N1709,N1710,N1711,N1712, N1713,N1714,N1715,N1716, N1717,N1718,N1719,N1720, \\note fields as indicated
  N1721,N1722,N1723,N1724, N1725,N1726,N1727,N1728, N1729,N1730,N1731,N1732, N1733,N1734,N1735,N1736, N1737,N1738,N1739,N1740, \\note fields as indicated
  N1741,N1742,N1743,N1744, N1745,N1746,N1747,N1748, N1749,N1750,N1751,N1752, N1753,N1754,N1755,N1756, N1757,N1758,N1759,N1760, \\note fields as indicated
  N1761,N1762,N1763,N1764, N1765,N1766,N1767,N1768, N1769,N1770,N1771,N1772, N1773,N1774,N1775,N1776, N1777,N1778,N1779,N1780, \\note fields as indicated
  N1781,N1782,N1783,N1784, N1785,N1786,N1787,N1788, N1789,N1790,N1791,N1792, N1793,N1794,N1795,N1796, N1797,N1798,N1799,N1800, \\note fields as indicated

  N1801,N1802,N1803,N1804, N1805,N1806,N1807,N1808, N1809,N1810,N1811,N1812, N1813,N1814,N1815,N1816, N1817,N1818,N1819,N1820,  \\note fields as indicated
  N1821,N1822,N1823,N1824, N1825,N1826,N1827,N1828, N1829,N1830,N1831,N1832, N1833,N1834,N1835,N1836, N1837,N1838,N1839,N1840,  \\note fields as indicated
  N1841,N1842,N1843,N1844, N1845,N1846,N1847,N1848, N1849,N1850,N1851,N1852, N1853,N1854,N1855,N1856, N1857,N1858,N1859,N1860,  \\note fields as indicated
  N1861,N1862,N1863,N1864, N1865,N1866,N1867,N1868, N1869,N1870,N1871,N1872, N1873,N1874,N1875,N1876, N1877,N1878,N1879,N1880,  \\note fields as indicated
  N1881,N1882,N1883,N1884, N1885,N1886,N1887,N1888, N1889,N1890,N1891,N1892, N1893,N1894,N1895,N1896, N1897,N1898,N1899,N1900,  \\note fields as indicated

  N1901,N1902,N1903,N1904, N1905,N1906,N1907,N1908, N1909,N1910,N1911,N1912, N1913,N1914,N1915,N1916, N1917,N1918,N1919,N1920,  \\note fields as indicated
  N1921,N1922,N1923,N1924, N1925,N1926,N1927,N1928, N1929,N1930,N1931,N1932, N1933,N1934,N1935,N1936, N1937,N1938,N1939,N1940,  \\note fields as indicated
  N1941,N1942,N1943,N1944, N1945,N1946,N1947,N1948, N1949,N1950,N1951,N1952, N1953,N1954,N1955,N1956, N1957,N1958,N1959,N1960,  \\note fields as indicated
  N1961,N1962,N1963,N1964, N1965,N1966,N1967,N1968, N1969,N1970,N1971,N1972, N1973,N1974,N1975,N1976, N1977,N1978,N1979,N1980,  \\note fields as indicated
  N1981,N1982,N1983,N1984, N1985,N1986,N1987,N1988, N1989,N1990,N1991,N1992, N1993,N1994,N1995,N1996, N1997,N1998,N1999,N2000,  \\note fields as indicated

  N2001,N2002,N2003,N2004, N2005,N2006,N2007,N2008, N2009,N2010,N2011,N2012, N2013,N2014,N2015,N2016, N2017,N2018,N2019,N2020,  \\note fields as indicated
  N2021,N2022,N2023,N2024, N2025,N2026,N2027,N2028, N2029,N2030,N2031,N2032, N2033,N2034,N2035,N2036, N2037,N2038,N2039,N2040,  \\note fields as indicated
  N2041,N2042,N2043,N2044, N2045,N2046,N2047,N2048, N2049,N2050,N2051,N2052, N2053,N2054,N2055,N2056, N2057,N2058,N2059,N2060,  \\note fields as indicated
  N2061,N2062,N2063,N2064, N2065,N2066,N2067,N2068, N2069,N2070,N2071,N2072, N2073,N2074,N2075,N2076, N2077,N2078,N2079,N2080,  \\note fields as indicated
  N2081,N2082,N2083,N2084, N2085,N2086,N2087,N2088, N2089,N2090,N2091,N2092, N2093,N2094,N2095,N2096, N2097,N2098,N2099,N2100,  \\note fields as indicated

  N2101,N2102,N2103,N2104, N2105,N2106,N2107,N2108, N2109,N2110,N2111,N2112, N2113,N2114,N2115,N2116, N2117,N2118,N2119,N2120,  \\note fields as indicated
  N2121,N2122,N2123,N2124, N2125,N2126,N2127,N2128, N2129,N2130,N2131,N2132, N2133,N2134,N2135,N2136, N2137,N2138,N2139,N2140,  \\note fields as indicated
  N2141,N2142,N2143,N2144, N2145,N2146,N2147,N2148, N2149,N2150,N2151,N2152, N2153,N2154,N2155,N2156, N2157,N2158,N2159,N2160,  \\note fields as indicated
  N2161,N2162,N2163,N2164, N2165,N2166,N2167,N2168, N2169,N2170,N2171,N2172, N2173,N2174,N2175,N2176, N2177,N2178,N2179,N2180,  \\note fields as indicated
  N2181,N2182,N2183,N2184, N2185,N2186,N2187,N2188, N2189,N2190,N2191,N2192, N2193,N2194,N2195,N2196, N2197,N2198,N2199,N2200,  \\note fields as indicated

  N2201,N2202,N2203,N2204, N2205,N2206,N2207,N2208, N2209,N2210,N2211,N2212, N2213,N2214,N2215,N2216, N2217,N2218,N2219,N2220,  \\note fields as indicated
  N2221,N2222,N2223,N2224, N2225,N2226,N2227,N2228, N2229,N2230,N2231,N2232, N2233,N2234,N2235,N2236, N2237,N2238,N2239,N2240,  \\note fields as indicated
  N2241,N2242,N2243,N2244, N2245,N2246,N2247,N2248, N2249,N2250,N2251,N2252, N2253,N2254,N2255,N2256, N2257,N2258,N2259,N2260,  \\note fields as indicated
  N2261,N2262,N2263,N2264, N2265,N2266,N2267,N2268, N2269,N2270,N2271,N2272, N2273,N2274,N2275,N2276, N2277,N2278,N2279,N2280,  \\note fields as indicated
  N2281,N2282,N2283,N2284, N2285,N2286,N2287,N2288, N2289,N2290,N2291,N2292, N2293,N2294,N2295,N2296, N2297,N2298,N2299,N2300,  \\note fields as indicated

  N2301,N2302,N2303,N2304, N2305,N2306,N2307,N2308, N2309,N2310,N2311,N2312, N2313,N2314,N2315,N2316, N2317,N2318,N2319,N2320,  \\note fields as indicated
  N2321,N2322,N2323,N2324, N2325,N2326,N2327,N2328, N2329,N2330,N2331,N2332, N2333,N2334,N2335,N2336, N2337,N2338,N2339,N2340,  \\note fields as indicated
  N2341,N2342,N2343,N2344, N2345,N2346,N2347,N2348, N2349,N2350,N2351,N2352, N2353,N2354,N2355,N2356, N2357,N2358,N2359,N2360,  \\note fields as indicated
  N2361,N2362,N2363,N2364, N2365,N2366,N2367,N2368, N2369,N2370,N2371,N2372, N2373,N2374,N2375,N2376, N2377,N2378,N2379,N2380,  \\note fields as indicated
  N2381,N2382,N2383,N2384, N2385,N2386,N2387,N2388, N2389,N2390,N2391,N2392, N2393,N2394,N2395,N2396, N2397,N2398,N2399,N2400,  \\note fields as indicated

  N2401,N2402,N2403,N2404, N2405,N2406,N2407,N2408, N2409,N2410,N2411,N2412, N2413,N2414,N2415,N2416, N2417,N2418,N2419,N2420,  \\note fields as indicated
  N2421,N2422,N2423,N2424, N2425,N2426,N2427,N2428, N2429,N2430,N2431,N2432, N2433,N2434,N2435,N2436, N2437,N2438,N2439,N2440,  \\note fields as indicated
  N2441,N2442,N2443,N2444, N2445,N2446,N2447,N2448, N2449,N2450,N2451,N2452, N2453,N2454,N2455,N2456, N2457,N2458,N2459,N2460,  \\note fields as indicated
  N2461,N2462,N2463,N2464, N2465,N2466,N2467,N2468, N2469,N2470,N2471,N2472, N2473,N2474,N2475,N2476, N2477,N2478,N2479,N2480,  \\note fields as indicated
  N2481,N2482,N2483,N2484, N2485,N2486,N2487,N2488, N2489,N2490,N2491,N2492, N2493,N2494,N2495,N2496, N2497,N2498,N2499,N2500,  \\note fields as indicated

  N2501,N2502,N2503,N2504, N2505,N2506,N2507,N2508, N2509,N2510,N2511,N2512, N2513,N2514,N2515,N2516, N2517,N2518,N2519,N2520,  \\note fields as indicated
  N2521,N2522,N2523,N2524, N2525,N2526,N2527,N2528, N2529,N2530,N2531,N2532, N2533,N2534,N2535,N2536, N2537,N2538,N2539,N2540,  \\note fields as indicated
  N2541,N2542,N2543,N2544, N2545,N2546,N2547,N2548, N2549,N2550,N2551,N2552, N2553,N2554,N2555,N2556, N2557,N2558,N2559,N2560,  \\note fields as indicated
  N2561,N2562,N2563,N2564, N2565,N2566,N2567,N2568, N2569,N2570,N2571,N2572, N2573,N2574,N2575,N2576, N2577,N2578,N2579,N2580,  \\note fields as indicated
  N2581,N2582,N2583,N2584, N2585,N2586,N2587,N2588, N2589,N2590,N2591,N2592, N2593,N2594,N2595,N2596, N2597,N2598,N2599,N2600,  \\note fields as indicated

  N2601,N2602,N2603,N2604, N2605,N2606,N2607,N2608, N2609,N2610,N2611,N2612, N2613,N2614,N2615,N2616, N2617,N2618,N2619,N2620,  \\note fields as indicated
  N2621,N2622,N2623,N2624, N2625,N2626,N2627,N2628, N2629,N2630,N2631,N2632, N2633,N2634,N2635,N2636, N2637,N2638,N2639,N2640,  \\note fields as indicated
  N2641,N2642,N2643,N2644, N2645,N2646,N2647,N2648, N2649,N2650,N2651,N2652, N2653,N2654,N2655,N2656, N2657,N2658,N2659,N2660,  \\note fields as indicated
  N2661,N2662,N2663,N2664, N2665,N2666,N2667,N2668, N2669,N2670,N2671,N2672, N2673,N2674,N2675,N2676, N2677,N2678,N2679,N2680,  \\note fields as indicated
  N2681,N2682,N2683,N2684, N2685,N2686,N2687,N2688, N2689,N2690,N2691,N2692, N2693,N2694,N2695,N2696, N2697,N2698,N2699,N2700,  \\note fields as indicated

  N2701,N2702,N2703,N2704, N2705,N2706,N2707,N2708, N2709,N2710,N2711,N2712, N2713,N2714,N2715,N2716, N2717,N2718,N2719,N2720,  \\note fields as indicated
  N2721,N2722,N2723,N2724, N2725,N2726,N2727,N2728, N2729,N2730,N2731,N2732, N2733,N2734,N2735,N2736, N2737,N2738,N2739,N2740,  \\note fields as indicated
  N2741,N2742,N2743,N2744, N2745,N2746,N2747,N2748, N2749,N2750,N2751,N2752, N2753,N2754,N2755,N2756, N2757,N2758,N2759,N2760,  \\note fields as indicated
  N2761,N2762,N2763,N2764, N2765,N2766,N2767,N2768, N2769,N2770,N2771,N2772, N2773,N2774,N2775,N2776, N2777,N2778,N2779,N2780,  \\note fields as indicated
  N2781,N2782,N2783,N2784, N2785,N2786,N2787,N2788, N2789,N2790,N2791,N2792, N2793,N2794,N2795,N2796, N2797,N2798,N2799,N2800,  \\note fields as indicated

  N2801,N2802,N2803,N2804, N2805,N2806,N2807,N2808, N2809,N2810,N2811,N2812, N2813,N2814,N2815,N2816, N2817,N2818,N2819,N2820,  \\note fields as indicated
  N2821,N2822,N2823,N2824, N2825,N2826,N2827,N2828, N2829,N2830,N2831,N2832, N2833,N2834,N2835,N2836, N2837,N2838,N2839,N2840,  \\note fields as indicated
  N2841,N2842,N2843,N2844, N2845,N2846,N2847,N2848, N2849,N2850,N2851,N2852, N2853,N2854,N2855,N2856, N2857,N2858,N2859,N2860,  \\note fields as indicated
  N2861,N2862,N2863,N2864, N2865,N2866,N2867,N2868, N2869,N2870,N2871,N2872, N2873,N2874,N2875,N2876, N2877,N2878,N2879,N2880,  \\note fields as indicated
  N2881,N2882,N2883,N2884, N2885,N2886,N2887,N2888, N2889,N2890,N2891,N2892, N2893,N2894,N2895,N2896, N2897,N2898,N2899,N2900,  \\note fields as indicated

  N2901,N2902,N2903,N2904, N2905,N2906,N2907,N2908, N2909,N2910,N2911,N2912, N2913,N2914,N2915,N2916, N2917,N2918,N2919,N2920,  \\note fields as indicated
  N2921,N2922,N2923,N2924, N2925,N2926,N2927,N2928, N2929,N2930,N2931,N2932, N2933,N2934,N2935,N2936, N2937,N2938,N2939,N2940,  \\note fields as indicated
  N2941,N2942,N2943,N2944, N2945,N2946,N2947,N2948, N2949,N2950,N2951,N2952, N2953,N2954,N2955,N2956, N2957,N2958,N2959,N2960,  \\note fields as indicated
  N2961,N2962,N2963,N2964, N2965,N2966,N2967,N2968, N2969,N2970,N2971,N2972, N2973,N2974,N2975,N2976, N2977,N2978,N2979,N2980,  \\note fields as indicated
  N2981,N2982,N2983,N2984, N2985,N2986,N2987,N2988, N2989,N2990,N2991,N2992, N2993,N2994,N2995,N2996, N2997,N2998,N2999,N3000,  \\note fields as indicated

  N3001,N3002,N3003,N3004, N3005,N3006,N3007,N3008, N3009,N3010,N3011,N3012, N3013,N3014,N3015,N3016, N3017,N3018,N3019,N3020,  \\note fields as indicated
  N3021,N3022,N3023,N3024, N3025,N3026,N3027,N3028, N3029,N3030,N3031,N3032, N3033,N3034,N3035,N3036, N3037,N3038,N3039,N3040,  \\note fields as indicated
  N3041,N3042,N3043,N3044, N3045,N3046,N3047,N3048, N3049,N3050,N3051,N3052, N3053,N3054,N3055,N3056, N3057,N3058,N3059,N3060,  \\note fields as indicated
  N3061,N3062,N3063,N3064, N3065,N3066,N3067,N3068, N3069,N3070,N3071,N3072, N3073,N3074,N3075,N3076, N3077,N3078,N3079,N3080,  \\note fields as indicated
  N3081,N3082,N3083,N3084, N3085,N3086,N3087,N3088, N3089,N3090,N3091,N3092, N3093,N3094,N3095,N3096, N3097,N3098,N3099,N3100,  \\note fields as indicated

  N3101,N3102,N3103,N3104, N3105,N3106,N3107,N3108, N3109,N3110,N3111,N3112, N3113,N3114,N3115,N3116, N3117,N3118,N3119,N3120,  \\note fields as indicated
  N3121,N3122,N3123,N3124, N3125,N3126,N3127,N3128, N3129,N3130,N3131,N3132, N3133,N3134,N3135,N3136, N3137,N3138,N3139,N3140,  \\note fields as indicated
  N3141,N3142,N3143,N3144, N3145,N3146,N3147,N3148, N3149,N3150,N3151,N3152, N3153,N3154,N3155,N3156, N3157,N3158,N3159,N3160,  \\note fields as indicated
  N3161,N3162,N3163,N3164, N3165,N3166,N3167,N3168, N3169,N3170,N3171,N3172, N3173,N3174,N3175,N3176, N3177,N3178,N3179,N3180,  \\note fields as indicated
  N3181,N3182,N3183,N3184, N3185,N3186,N3187,N3188, N3189,N3190,N3191,N3192, N3193,N3194,N3195,N3196, N3197,N3198,N3199,N3200;  \\note fields as indicated

Construction,
       \\memo Start with outside layer and work your way to the inside layer
       \\memo Up to 10 layers total, 8 for windows
       \\memo Enter the material name for each layer
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2 , \\field Outside Layer
       \\required-field
       \\type object-list
       \\object-list MaterialName
  A3 , \\field Layer 2
       \\type object-list
       \\object-list MaterialName
  A4 , \\field Layer 3
       \\type object-list
       \\object-list MaterialName
  A5 , \\field Layer 4
       \\type object-list
       \\object-list MaterialName
  A6 , \\field Layer 5
       \\type object-list
       \\object-list MaterialName
  A7 , \\field Layer 6
       \\type object-list
       \\object-list MaterialName
  A8 , \\field Layer 7
       \\type object-list
       \\object-list MaterialName
  A9 , \\field Layer 8
       \\type object-list
       \\object-list MaterialName
  A10, \\field Layer 9
       \\type object-list
       \\object-list MaterialName
  A11; \\field Layer 10
       \\type object-list
       \\object-list MaterialName

Construction:CfactorUndergroundWall,
       \\memo Alternate method of describing underground wall constructions
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  N1 , \\field C-Factor
       \\required-field
       \\units W/m2-K
       \\type real
       \\minimum> 0.0
       \\note Enter C-Factor without film coefficients or soil
  N2 ; \\field Height
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
       \\note Enter height of the underground wall

Construction:FfactorGroundFloor,
       \\memo Alternate method of describing slab-on-grade or underground floor constructions
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  N1 , \\field F-Factor
       \\required-field
       \\units W/m-K
       \\ip-units Btu/h-ft-F
       \\type real
       \\minimum> 0.0
  N2 , \\field Area
       \\required-field
       \\units m2
       \\type real
       \\minimum> 0.0
       \\note Enter area of the floor
  N3 ; \\field PerimeterExposed
       \\required-field
       \\units m
       \\type real
       \\minimum 0.0
       \\note Enter exposed perimeter of the floor

ConstructionProperty:InternalHeatSource,
       \\memo Internal heat source to be attached to a construction layer
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference InternalHeatSourceNames
  A2,  \\field Construction Name
       \\type object-list
       \\object-list ConstructionNames
  N1,  \\field Thermal Source Present After Layer Number
       \\required-field
       \\type integer
       \\minimum 1
       \\note refers to the list of materials which follows
  N2,  \\field Temperature Calculation Requested After Layer Number
       \\required-field
       \\type integer
       \\note refers to the list of materials which follows
  N3,  \\field Dimensions for the CTF Calculation
       \\required-field
       \\type integer
       \\minimum 1
       \\maximum 2
       \\note 1 = 1-dimensional calculation, 2 = 2-dimensional calculation
  N4,  \\field Tube Spacing
       \\required-field
       \\type real
       \\units m
       \\note uniform spacing between tubes or resistance wires in direction
       \\note perpendicular to main intended direction of heat transfer
  N5;  \\field Two-Dimensional Temperature Calculation Position
       \\required-field
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
       \\units dimensionless
       \\note used in conjunction with field Temperature Calculation Requested After Layer Number
       \\note this field is the location perpendicular to the main direction of heat transfer
       \\note 0.0 means in line with the tubing, 1.0 means at the midpoint between two adjacent pipes
       \\note this field is ignored for 1-D calculations

Construction:AirBoundary,
       \\memo Indicates an open boundary between two zones. It may be used for base surfaces and fenestration surfaces.
       \\memo The two adjacent zones are grouped together for solar, daylighting and radiant exchange.
       \\memo When this construction type is used, the Outside Boundary Condition of the surface
       \\memo (or the base surface of a fenestration surface) must be either Surface or Zone.
       \\memo A base surface with Construction:AirBoundary cannot hold any fenestration surfaces.
       \\min-fields 4
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2,  \\field Air Exchange Method
       \\note This field controls how air exchange is modeled across this boundary.
       \\type choice
       \\key None
       \\key SimpleMixing
       \\default None
  N1,  \\field Simple Mixing Air Changes per Hour
       \\note If the Air Exchange Method is SimpleMixing then this field specifies the air changes per hour
       \\note using the volume of the smaller zone as the basis.
       \\note If an AirflowNetwork simulation is active this field is ignored.
       \\units 1/hr
       \\type real
       \\minimum 0
       \\default 0.5
  A3;  \\field Simple Mixing Schedule Name
       \\note If the Air Exchange Method is SimpleMixing then this field specifies the air exchange schedule.
       \\note If this field is blank, the schedule is always 1.0.
       \\note If an AirflowNetwork simulation is active this field is ignored.
       \\type object-list
       \\object-list ScheduleNames

WindowThermalModel:Params,
       \\memo object is used to select which thermal model should be used in tarcog simulations
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowThermalModelParameters
  A2 , \\field standard
       \\type choice
       \\key ISO15099
       \\key EN673Declared
       \\key EN673Design
       \\default ISO15099
  A3 , \\field Thermal Model
       \\type choice
       \\key ISO15099
       \\key ScaledCavityWidth
       \\key ConvectiveScalarModel_NoSDThickness
       \\key ConvectiveScalarModel_withSDThickness
       \\default ISO15099
  N1 , \\field SDScalar
       \\type real
       \\minimum  0.0
       \\maximum 1.0
       \\default 1
  A4 , \\field Deflection Model
       \\type choice
       \\key NoDeflection
       \\key TemperatureAndPressureInput
       \\key MeasuredDeflection
       \\default NoDeflection
  N2 , \\field Vacuum Pressure Limit
       \\type real
       \\units Pa
       \\minimum> 0
       \\default 13.238
  N3 , \\field Initial temperature
       \\note This is temperature in time of window fabrication
       \\type real
       \\units C
       \\minimum> 0
       \\default 25
  N4 ; \\field Initial pressure
       \\note This is pressure in time of window fabrication
       \\type real
       \\units Pa
       \\minimum> 0
       \\default 101325

WindowsCalculationEngine,
       \\memo Describes which window model will be used in calculations. Built in windows model will use algorithms that are part of EnergyPlus,
       \\memo while ExternalWindowsModel will use Windows-CalcEngine library to perform optical and thermal performances of windows and doors.
  A1;  \\field Windows engine
       \\type choice
       \\key BuiltInWindowsModel
       \\key ExternalWindowsModel
       \\default BuiltInWindowsModel

Construction:ComplexFenestrationState,
       \\memo Describes one state for a complex glazing system
       \\memo These input objects are typically generated by using WINDOW software and export to IDF syntax
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ComplexFenestrationStates
  A2 , \\field Basis Type
       \\type choice
       \\key LBNLWINDOW
       \\key UserDefined
       \\default LBNLWINDOW
  A3 , \\field Basis Symmetry Type
       \\type choice
       \\key Axisymmetric
       \\key None
       \\default None
  A4 , \\field Window Thermal Model
       \\required-field
       \\type object-list
       \\object-list WindowThermalModelParameters
  A5 , \\field Basis Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A6 , \\field Solar Optical Complex Front Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A7 , \\field Solar Optical Complex Back Reflectance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A8 , \\field Visible Optical Complex Front Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A9 , \\field Visible Optical Complex Back Transmittance Matrix Name
       \\type object-list
       \\object-list DataMatrices
       \\required-field
  A10, \\field Outside Layer Name
       \\required-field
       \\type object-list
       \\object-list CFSGlazingName
       \\object-list WindowComplexShades
  A11,  \\field Outside Layer Directional Front Absoptance Matrix Name
       \\required-field
       \\type object-list
       \\object-list DataMatrices
  A12, \\field Outside Layer Directional Back Absoptance Matrix Name
       \\required-field
       \\type object-list
       \\object-list DataMatrices
  A13, \\field Gap 1 Name
       \\type object-list
       \\object-list CFSGap
  A14, \\field CFS Gap 1 Directional Front Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A15, \\field CFS Gap 1 Directional Back Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A16, \\field Layer 2 Name
       \\type object-list
       \\object-list CFSGlazingName
       \\object-list WindowComplexShades
  A17, \\field Layer 2 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A18, \\field Layer 2 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A19, \\field Gap 2 Name
       \\type object-list
       \\object-list CFSGap
  A20, \\field Gap 2 Directional Front Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A21, \\field Gap 2 Directional Back Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A22, \\field Layer 3 Name
       \\type object-list
       \\object-list CFSGlazingName
       \\object-list WindowComplexShades
  A23, \\field Layer 3 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A24, \\field Layer 3 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A25, \\field Gap 3 Name
       \\type object-list
       \\object-list CFSGap
  A26, \\field Gap 3 Directional Front Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A27, \\field Gap 3 Directional Back Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A28, \\field Layer 4 Name
       \\type object-list
       \\object-list CFSGlazingName
       \\object-list WindowComplexShades
  A29, \\field Layer 4 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A30, \\field Layer 4 Directional Back Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A31, \\field Gap 4 Name
       \\type object-list
       \\object-list CFSGap
  A32, \\field Gap 4 Directional Front Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A33, \\field Gap 4 Directional Back Absoptance Matrix Name
       \\note Reserved for future use. Leave it blank for this version
       \\type object-list
       \\object-list DataMatrices
  A34, \\field Layer 5 Name
       \\type object-list
       \\object-list CFSGlazingName
       \\object-list WindowComplexShades
  A35, \\field Layer 5 Directional Front Absoptance Matrix Name
       \\type object-list
       \\object-list DataMatrices
  A36; \\field Layer 5 Directional Back Absoptance Matrix Name

Construction:WindowEquivalentLayer,
       \\memo Start with outside layer and work your way to the inside Layer
       \\memo Up to 11 layers total. Up to six solid layers and up to five gaps.
       \\memo Enter the material name for each layer
       \\min-fields 2
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2 , \\field Outside Layer
       \\required-field
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A3 , \\field Layer 2
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A4 , \\field Layer 3
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A5 , \\field Layer 4
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A6 , \\field Layer 5
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A7 , \\field Layer 6
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A8 , \\field Layer 7
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A9 , \\field Layer 8
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A10, \\field Layer 9
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A11, \\field Layer 10
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames
  A12; \\field Layer 11
       \\type object-list
       \\object-list WindowEquivalentLayerMaterialNames

Construction:WindowDataFile,
       \\memo Initiates search of the Window data file for a window called Name.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ConstructionNames
  A2 ; \\field File Name
       \\retaincase
       \\note default file name is "Window5DataFile.dat"
       \\note limit on this field is 100 characters.

\\group Thermal Zones and Surfaces

GlobalGeometryRules,
      \\memo Specifies the geometric rules used to describe the input of surface vertices and
      \\memo daylighting reference points.
      \\required-object
      \\unique-object
  A1, \\field Starting Vertex Position
      \\required-field
      \\note Specified as entry for a 4 sided surface/rectangle
      \\note Surfaces are specified as viewed from outside the surface
      \\note Shading surfaces as viewed from behind. (towards what they are shading)
      \\type choice
      \\key UpperLeftCorner
      \\key LowerLeftCorner
      \\key UpperRightCorner
      \\key LowerRightCorner
  A2, \\field Vertex Entry Direction
      \\required-field
      \\type choice
      \\key Counterclockwise
      \\key Clockwise
  A3, \\field Coordinate System
      \\required-field
      \\note Relative -- coordinates are entered relative to zone origin
      \\note World -- all coordinates entered are "absolute" for this facility
      \\type choice
      \\key Relative
      \\key World
  A4, \\field Daylighting Reference Point Coordinate System
      \\type choice
      \\key Relative
      \\default Relative
      \\note Relative -- coordinates are entered relative to zone origin
      \\key World
      \\note World -- all coordinates entered are "absolute" for this facility
  A5; \\field Rectangular Surface Coordinate System
      \\type choice
      \\key Relative
      \\default Relative
      \\note Relative -- Starting corner is entered relative to zone origin
      \\key World
      \\note World -- Starting corner is entered in "absolute"

GeometryTransform,
      \\memo Provides a simple method of altering the footprint geometry of a model. The intent
      \\memo is to provide a single parameter that can be used to reshape the building description
      \\memo contained in the rest of the input file.
     \\unique-object
     \\min-fields 3
  A1, \\field Plane of Transform
      \\type choice
      \\key XY
      \\default XY
      \\note only current allowed value is "XY"
  N1, \\field Current Aspect Ratio
      \\required-field
      \\minimum> 0
      \\note Aspect ratio of building as described in idf
  N2; \\field New Aspect Ratio
      \\required-field
      \\minimum> 0
      \\note Aspect ratio to transform to during run

Space,
       \\memo Defines a space (room) in the building. All Spaces are part of a Zone.
       \\memo Every Zone contains one or more spaces. Space is an optional input.
       \\memo If a Zone has no Space(s) specified in input then a default Space named <Zone Name> will be created.
       \\memo If some surfaces in a Zone are assigned to a space and some are not, then a default Space
       \\memo named <Zone Name>-Remainder will be created. 
       \\memo Input references to Space Names must have a matching Space object
       \\memo (default space names may not be referenced except in output variable keys).
       \\min-fields 3
       \\extensible:1
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference SpaceNames
       \\reference SpaceAndSpaceListNames
  A2,  \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Floor Area
       \\note If this field is 0.0, negative or autocalculate, then the floor area of the space
       \\note is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\units m2
       \\type real
       \\autocalculatable
       \\default autocalculate
  A3,  \\field Space Type
       \\note Space type is used to tag spaces by activity type, such as office, classroom, storage, etc.
       \\type alpha
       \\default General
  A4,  \\field Tag 1
       \\note Optional reporting tag
       \\type alpha
       \\begin-extensible
  A5,  \\field Tag 2
       \\note Optional reporting tag
       \\type alpha
  A6;  \\field Tag 3
       \\note Optional reporting tag
       \\type alpha

SpaceList,
       \\memo Defines a list of Spaces which can be referenced as a group. The SpaceList name
       \\memo may be used elsewhere in the input to apply a parameter to all Spaces in the list.
       \\memo SpaceLists can be used effectively with the following objects: InternalMass, People, Lights,
       \\memo ElectricEquipment, GasEquipment, HotWaterEquipment, and others.
       \\min-fields 2
       \\extensible:1
  A1 , \\field Name
       \\note Name of the Space List
       \\required-field
       \\type alpha
       \\reference SpaceListNames
       \\reference SpaceAndSpaceListNames
  A2 , \\field Space 1 Name
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list SpaceNames
  A3 , \\field Space 2 Name
       \\type object-list
       \\object-list SpaceNames
  A4 , \\field Space 3 Name
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Space 4 Name
       \\type object-list
       \\object-list SpaceNames
  A6 , \\field Space 5 Name
       \\type object-list
       \\object-list SpaceNames
  A7 , \\field Space 6 Name
       \\type object-list
       \\object-list SpaceNames
  A8 , \\field Space 7 Name
       \\type object-list
       \\object-list SpaceNames
  A9 , \\field Space 8 Name
       \\type object-list
       \\object-list SpaceNames
  A10, \\field Space 9 Name
       \\type object-list
       \\object-list SpaceNames
  A11, \\field Space 10 Name
       \\type object-list
       \\object-list SpaceNames
  A12, \\field Space 11 Name
       \\type object-list
       \\object-list SpaceNames
  A13, \\field Space 12 Name
       \\type object-list
       \\object-list SpaceNames
  A14, \\field Space 13 Name
       \\type object-list
       \\object-list SpaceNames
  A15, \\field Space 14 Name
       \\type object-list
       \\object-list SpaceNames
  A16, \\field Space 15 Name
       \\type object-list
       \\object-list SpaceNames
  A17, \\field Space 16 Name
       \\type object-list
       \\object-list SpaceNames
  A18, \\field Space 17 Name
       \\type object-list
       \\object-list SpaceNames
  A19, \\field Space 18 Name
       \\type object-list
       \\object-list SpaceNames
  A20, \\field Space 19 Name
       \\type object-list
       \\object-list SpaceNames
  A21, \\field Space 20 Name
       \\type object-list
       \\object-list SpaceNames
  A22, \\field Space 21 Name
       \\type object-list
       \\object-list SpaceNames
  A23, \\field Space 22 Name
       \\type object-list
       \\object-list SpaceNames
  A24, \\field Space 23 Name
       \\type object-list
       \\object-list SpaceNames
  A25, \\field Space 24 Name
       \\type object-list
       \\object-list SpaceNames
  A26, \\field Space 25 Name
       \\type object-list
       \\object-list SpaceNames
  A27, \\field Space 26 Name
       \\type object-list
       \\object-list SpaceNames
  A28, \\field Space 27 Name
       \\type object-list
       \\object-list SpaceNames
  A29, \\field Space 28 Name
       \\type object-list
       \\object-list SpaceNames
  A30, \\field Space 29 Name
       \\type object-list
       \\object-list SpaceNames
  A31, \\field Space 30 Name
       \\type object-list
       \\object-list SpaceNames
  A32, \\field Space 31 Name
       \\type object-list
       \\object-list SpaceNames
  A33, \\field Space 32 Name
       \\type object-list
       \\object-list SpaceNames
  A34, \\field Space 33 Name
       \\type object-list
       \\object-list SpaceNames
  A35, \\field Space 34 Name
       \\type object-list
       \\object-list SpaceNames
  A36, \\field Space 35 Name
       \\type object-list
       \\object-list SpaceNames
  A37, \\field Space 36 Name
       \\type object-list
       \\object-list SpaceNames
  A38, \\field Space 37 Name
       \\type object-list
       \\object-list SpaceNames
  A39, \\field Space 38 Name
       \\type object-list
       \\object-list SpaceNames
  A40, \\field Space 39 Name
       \\type object-list
       \\object-list SpaceNames
  A41, \\field Space 40 Name
       \\type object-list
       \\object-list SpaceNames
  A42, \\field Space 41 Name
       \\type object-list
       \\object-list SpaceNames
  A43, \\field Space 42 Name
       \\type object-list
       \\object-list SpaceNames
  A44, \\field Space 43 Name
       \\type object-list
       \\object-list SpaceNames
  A45, \\field Space 44 Name
       \\type object-list
       \\object-list SpaceNames
  A46, \\field Space 45 Name
       \\type object-list
       \\object-list SpaceNames
  A47, \\field Space 46 Name
       \\type object-list
       \\object-list SpaceNames
  A48, \\field Space 47 Name
       \\type object-list
       \\object-list SpaceNames
  A49, \\field Space 48 Name
       \\type object-list
       \\object-list SpaceNames
  A50, \\field Space 49 Name
       \\type object-list
       \\object-list SpaceNames
  A51; \\field Space 50 Name
       \\type object-list
       \\object-list SpaceNames

Zone,
       \\memo Defines a thermal zone of the building. Every zone contains one or more Spaces.
       \\memo Space is an optional input. 
       \\memo If a Zone has no Space(s) specified in input then a default Space named <Zone Name> will be created.
       \\memo If some surfaces in a Zone are assigned to a space and some are not, then a default Space
       \\memo named <Zone Name>-Remainder will be created. 
       \\memo Input references to Space Names must have a matching Space object
       \\memo (default space names may not be referenced except in output variable keys).
       \\format vertices
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ZoneNames
       \\reference OutFaceEnvNames
       \\reference ZoneAndZoneListNames
       \\reference AirflowNetworkNodeAndZoneNames
  N1 , \\field Direction of Relative North
       \\units deg
       \\type real
       \\default 0
  N2 , \\field X Origin
       \\units m
       \\type real
       \\default 0
  N3 , \\field Y Origin
       \\units m
       \\type real
       \\default 0
  N4 , \\field Z Origin
       \\units m
       \\type real
       \\default 0
  N5 , \\field Type
       \\type integer
       \\maximum 1
       \\minimum 1
       \\default 1
  N6 , \\field Multiplier
       \\type integer
       \\minimum 1
       \\default 1
  N7 , \\field Ceiling Height
       \\note If this field is 0.0, negative or autocalculate, then the average height
       \\note of the zone is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\note Note that the Zone Ceiling Height is the distance from the Floor to
       \\note the Ceiling in the Zone, not an absolute height from the ground.
       \\units m
       \\type real
       \\autocalculatable
       \\default autocalculate
  N8 , \\field Volume
       \\note If this field is 0.0, negative or autocalculate, then the volume of the zone
       \\note is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\units m3
       \\type real
       \\autocalculatable
       \\default autocalculate
  N9 , \\field Floor Area
       \\note If this field is 0.0, negative or autocalculate, then the floor area of the zone
       \\note is automatically calculated and used in subsequent calculations.
       \\note If this field is positive, then the number entered here will be used.
       \\units m2
       \\type real
       \\autocalculatable
       \\default autocalculate
  A2 , \\field Zone Inside Convection Algorithm
       \\type choice
       \\key Simple
       \\key TARP
       \\key CeilingDiffuser
       \\key AdaptiveConvectionAlgorithm
       \\key TrombeWall
       \\key ASTMC1340
       \\note Will default to same value as SurfaceConvectionAlgorithm:Inside object
       \\note setting this field overrides the default SurfaceConvectionAlgorithm:Inside for this zone
       \\note Simple = constant natural convection (ASHRAE)
       \\note TARP = variable natural convection based on temperature difference (ASHRAE)
       \\note CeilingDiffuser = ACH based forced and mixed convection correlations
       \\note  for ceiling diffuser configuration with simple natural convection limit
       \\note AdaptiveConvectionAlgorithm = dynamic selection of convection models based on conditions
       \\note TrombeWall = variable natural convection in an enclosed rectangular cavity
       \\note ASTMC1340 = mixed convection correlations specified for attic zone
  A3,  \\field Zone Outside Convection Algorithm
       \\note Will default to same value as SurfaceConvectionAlgorithm:Outside object
       \\note setting this field overrides the default SurfaceConvectionAlgorithm:Outside for this zone
       \\type choice
       \\key SimpleCombined
       \\key TARP
       \\key DOE-2
       \\key MoWiTT
       \\key AdaptiveConvectionAlgorithm
       \\note SimpleCombined = Combined radiation and convection coefficient using simple ASHRAE model
       \\note TARP = correlation from models developed by ASHRAE, Walton, and Sparrow et. al.
       \\note MoWiTT = correlation from measurements by Klems and Yazdanian for smooth surfaces
       \\note DOE-2 = correlation from measurements by Klems and Yazdanian for rough surfaces
       \\note AdaptiveConvectionAlgorithm = dynamic selection of correlations based on conditions
  A4;  \\field Part of Total Floor Area
       \\type choice
       \\key Yes
       \\key No
       \\default Yes

ZoneList,
       \\memo Defines a list of thermal zones which can be referenced as a group. The ZoneList name
       \\memo may be used elsewhere in the input to apply a parameter to all zones in the list.
       \\memo ZoneLists can be used effectively with the following objects: People, Lights,
       \\memo ElectricEquipment, GasEquipment, HotWaterEquipment, ZoneInfiltration:DesignFlowRate,
       \\memo ZoneVentilation:DesignFlowRate, Sizing:Zone, ZoneControl:Thermostat, and others.
       \\min-fields 2
       \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
  A1 , \\field Name
       \\note Name of the Zone List
       \\required-field
       \\type alpha
       \\reference ZoneListNames
       \\reference ZoneAndZoneListNames
  A2 , \\field Zone 1 Name
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Zone 2 Name
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Zone 3 Name
       \\type object-list
       \\object-list ZoneNames
  A5 , \\field Zone 4 Name
       \\type object-list
       \\object-list ZoneNames
  A6 , \\field Zone 5 Name
       \\type object-list
       \\object-list ZoneNames
  A7 , \\field Zone 6 Name
       \\type object-list
       \\object-list ZoneNames
  A8 , \\field Zone 7 Name
       \\type object-list
       \\object-list ZoneNames
  A9 , \\field Zone 8 Name
       \\type object-list
       \\object-list ZoneNames
  A10, \\field Zone 9 Name
       \\type object-list
       \\object-list ZoneNames
  A11, \\field Zone 10 Name
       \\type object-list
       \\object-list ZoneNames
  A12, \\field Zone 11 Name
       \\type object-list
       \\object-list ZoneNames
  A13, \\field Zone 12 Name
       \\type object-list
       \\object-list ZoneNames
  A14, \\field Zone 13 Name
       \\type object-list
       \\object-list ZoneNames
  A15, \\field Zone 14 Name
       \\type object-list
       \\object-list ZoneNames
  A16, \\field Zone 15 Name
       \\type object-list
       \\object-list ZoneNames
  A17, \\field Zone 16 Name
       \\type object-list
       \\object-list ZoneNames
  A18, \\field Zone 17 Name
       \\type object-list
       \\object-list ZoneNames
  A19, \\field Zone 18 Name
       \\type object-list
       \\object-list ZoneNames
  A20, \\field Zone 19 Name
       \\type object-list
       \\object-list ZoneNames
  A21, \\field Zone 20 Name
       \\type object-list
       \\object-list ZoneNames
  A22, \\field Zone 21 Name
       \\type object-list
       \\object-list ZoneNames
  A23, \\field Zone 22 Name
       \\type object-list
       \\object-list ZoneNames
  A24, \\field Zone 23 Name
       \\type object-list
       \\object-list ZoneNames
  A25, \\field Zone 24 Name
       \\type object-list
       \\object-list ZoneNames
  A26, \\field Zone 25 Name
       \\type object-list
       \\object-list ZoneNames
  A27, \\field Zone 26 Name
       \\type object-list
       \\object-list ZoneNames
  A28, \\field Zone 27 Name
       \\type object-list
       \\object-list ZoneNames
  A29, \\field Zone 28 Name
       \\type object-list
       \\object-list ZoneNames
  A30, \\field Zone 29 Name
       \\type object-list
       \\object-list ZoneNames
  A31, \\field Zone 30 Name
       \\type object-list
       \\object-list ZoneNames
  A32, \\field Zone 31 Name
       \\type object-list
       \\object-list ZoneNames
  A33, \\field Zone 32 Name
       \\type object-list
       \\object-list ZoneNames
  A34, \\field Zone 33 Name
       \\type object-list
       \\object-list ZoneNames
  A35, \\field Zone 34 Name
       \\type object-list
       \\object-list ZoneNames
  A36, \\field Zone 35 Name
       \\type object-list
       \\object-list ZoneNames
  A37, \\field Zone 36 Name
       \\type object-list
       \\object-list ZoneNames
  A38, \\field Zone 37 Name
       \\type object-list
       \\object-list ZoneNames
  A39, \\field Zone 38 Name
       \\type object-list
       \\object-list ZoneNames
  A40, \\field Zone 39 Name
       \\type object-list
       \\object-list ZoneNames
  A41, \\field Zone 40 Name
       \\type object-list
       \\object-list ZoneNames
  A42, \\field Zone 41 Name
       \\type object-list
       \\object-list ZoneNames
  A43, \\field Zone 42 Name
       \\type object-list
       \\object-list ZoneNames
  A44, \\field Zone 43 Name
       \\type object-list
       \\object-list ZoneNames
  A45, \\field Zone 44 Name
       \\type object-list
       \\object-list ZoneNames
  A46, \\field Zone 45 Name
       \\type object-list
       \\object-list ZoneNames
  A47, \\field Zone 46 Name
       \\type object-list
       \\object-list ZoneNames
  A48, \\field Zone 47 Name
       \\type object-list
       \\object-list ZoneNames
  A49, \\field Zone 48 Name
       \\type object-list
       \\object-list ZoneNames
  A50, \\field Zone 49 Name
       \\type object-list
       \\object-list ZoneNames
  A51, \\field Zone 50 Name
       \\type object-list
       \\object-list ZoneNames
  A52, \\field Zone 51 Name
       \\type object-list
       \\object-list ZoneNames
  A53, \\field Zone 52 Name
       \\type object-list
       \\object-list ZoneNames
  A54, \\field Zone 53 Name
       \\type object-list
       \\object-list ZoneNames
  A55, \\field Zone 54 Name
       \\type object-list
       \\object-list ZoneNames
  A56, \\field Zone 55 Name
       \\type object-list
       \\object-list ZoneNames
  A57, \\field Zone 56 Name
       \\type object-list
       \\object-list ZoneNames
  A58, \\field Zone 57 Name
       \\type object-list
       \\object-list ZoneNames
  A59, \\field Zone 58 Name
       \\type object-list
       \\object-list ZoneNames
  A60, \\field Zone 59 Name
       \\type object-list
       \\object-list ZoneNames
  A61, \\field Zone 60 Name
       \\type object-list
       \\object-list ZoneNames
  A62, \\field Zone 61 Name
       \\type object-list
       \\object-list ZoneNames
  A63, \\field Zone 62 Name
       \\type object-list
       \\object-list ZoneNames
  A64, \\field Zone 63 Name
       \\type object-list
       \\object-list ZoneNames
  A65, \\field Zone 64 Name
       \\type object-list
       \\object-list ZoneNames
  A66, \\field Zone 65 Name
       \\type object-list
       \\object-list ZoneNames
  A67, \\field Zone 66 Name
       \\type object-list
       \\object-list ZoneNames
  A68, \\field Zone 67 Name
       \\type object-list
       \\object-list ZoneNames
  A69, \\field Zone 68 Name
       \\type object-list
       \\object-list ZoneNames
  A70, \\field Zone 69 Name
       \\type object-list
       \\object-list ZoneNames
  A71, \\field Zone 70 Name
       \\type object-list
       \\object-list ZoneNames
  A72, \\field Zone 71 Name
       \\type object-list
       \\object-list ZoneNames
  A73, \\field Zone 72 Name
       \\type object-list
       \\object-list ZoneNames
  A74, \\field Zone 73 Name
       \\type object-list
       \\object-list ZoneNames
  A75, \\field Zone 74 Name
       \\type object-list
       \\object-list ZoneNames
  A76, \\field Zone 75 Name
       \\type object-list
       \\object-list ZoneNames
  A77, \\field Zone 76 Name
       \\type object-list
       \\object-list ZoneNames
  A78, \\field Zone 77 Name
       \\type object-list
       \\object-list ZoneNames
  A79, \\field Zone 78 Name
       \\type object-list
       \\object-list ZoneNames
  A80, \\field Zone 79 Name
       \\type object-list
       \\object-list ZoneNames
  A81, \\field Zone 80 Name
       \\type object-list
       \\object-list ZoneNames
  A82, \\field Zone 81 Name
       \\type object-list
       \\object-list ZoneNames
  A83, \\field Zone 82 Name
       \\type object-list
       \\object-list ZoneNames
  A84, \\field Zone 83 Name
       \\type object-list
       \\object-list ZoneNames
  A85, \\field Zone 84 Name
       \\type object-list
       \\object-list ZoneNames
  A86, \\field Zone 85 Name
       \\type object-list
       \\object-list ZoneNames
  A87, \\field Zone 86 Name
       \\type object-list
       \\object-list ZoneNames
  A88, \\field Zone 87 Name
       \\type object-list
       \\object-list ZoneNames
  A89, \\field Zone 88 Name
       \\type object-list
       \\object-list ZoneNames
  A90, \\field Zone 89 Name
       \\type object-list
       \\object-list ZoneNames
  A91, \\field Zone 90 Name
       \\type object-list
       \\object-list ZoneNames
  A92, \\field Zone 91 Name
       \\type object-list
       \\object-list ZoneNames
  A93, \\field Zone 92 Name
       \\type object-list
       \\object-list ZoneNames
  A94, \\field Zone 93 Name
       \\type object-list
       \\object-list ZoneNames
  A95, \\field Zone 94 Name
       \\type object-list
       \\object-list ZoneNames
  A96, \\field Zone 95 Name
       \\type object-list
       \\object-list ZoneNames
  A97, \\field Zone 96 Name
       \\type object-list
       \\object-list ZoneNames
  A98, \\field Zone 97 Name
       \\type object-list
       \\object-list ZoneNames
  A99, \\field Zone 98 Name
       \\type object-list
       \\object-list ZoneNames
  A100, \\field Zone 99 Name
       \\type object-list
       \\object-list ZoneNames
  A101, \\field Zone 100 Name
       \\type object-list
       \\object-list ZoneNames
  A102,A103,A104,A105,A106,A107,A108,A109,A110,A111, \\note fields as indicated
  A112,A113,A114,A115,A116,A117,A118,A119,A120,A121, \\note fields as indicated
  A122,A123,A124,A125,A126,A127,A128,A129,A130,A131, \\note fields as indicated
  A132,A133,A134,A135,A136,A137,A138,A139,A140,A141, \\note fields as indicated
  A142,A143,A144,A145,A146,A147,A148,A149,A150,A151, \\note fields as indicated
  A152,A153,A154,A155,A156,A157,A158,A159,A160,A161, \\note fields as indicated
  A162,A163,A164,A165,A166,A167,A168,A169,A170,A171, \\note fields as indicated
  A172,A173,A174,A175,A176,A177,A178,A179,A180,A181, \\note fields as indicated
  A182,A183,A184,A185,A186,A187,A188,A189,A190,A191, \\note fields as indicated
  A192,A193,A194,A195,A196,A197,A198,A199,A200,A201, \\note fields as indicated
  A202,A203,A204,A205,A206,A207,A208,A209,A210,A211, \\note fields as indicated
  A212,A213,A214,A215,A216,A217,A218,A219,A220,A221, \\note fields as indicated
  A222,A223,A224,A225,A226,A227,A228,A229,A230,A231, \\note fields as indicated
  A232,A233,A234,A235,A236,A237,A238,A239,A240,A241, \\note fields as indicated
  A242,A243,A244,A245,A246,A247,A248,A249,A250,A251, \\note fields as indicated
  A252,A253,A254,A255,A256,A257,A258,A259,A260,A261, \\note fields as indicated
  A262,A263,A264,A265,A266,A267,A268,A269,A270,A271, \\note fields as indicated
  A272,A273,A274,A275,A276,A277,A278,A279,A280,A281, \\note fields as indicated
  A282,A283,A284,A285,A286,A287,A288,A289,A290,A291, \\note fields as indicated
  A292,A293,A294,A295,A296,A297,A298,A299,A300,A301, \\note fields as indicated
  A302,A303,A304,A305,A306,A307,A308,A309,A310,A311, \\note fields as indicated
  A312,A313,A314,A315,A316,A317,A318,A319,A320,A321, \\note fields as indicated
  A322,A323,A324,A325,A326,A327,A328,A329,A330,A331, \\note fields as indicated
  A332,A333,A334,A335,A336,A337,A338,A339,A340,A341, \\note fields as indicated
  A342,A343,A344,A345,A346,A347,A348,A349,A350,A351, \\note fields as indicated
  A352,A353,A354,A355,A356,A357,A358,A359,A360,A361, \\note fields as indicated
  A362,A363,A364,A365,A366,A367,A368,A369,A370,A371, \\note fields as indicated
  A372,A373,A374,A375,A376,A377,A378,A379,A380,A381, \\note fields as indicated
  A382,A383,A384,A385,A386,A387,A388,A389,A390,A391, \\note fields as indicated
  A392,A393,A394,A395,A396,A397,A398,A399,A400,A401, \\note fields as indicated
  A402,A403,A404,A405,A406,A407,A408,A409,A410,A411, \\note fields as indicated
  A412,A413,A414,A415,A416,A417,A418,A419,A420,A421, \\note fields as indicated
  A422,A423,A424,A425,A426,A427,A428,A429,A430,A431, \\note fields as indicated
  A432,A433,A434,A435,A436,A437,A438,A439,A440,A441, \\note fields as indicated
  A442,A443,A444,A445,A446,A447,A448,A449,A450,A451, \\note fields as indicated
  A452,A453,A454,A455,A456,A457,A458,A459,A460,A461, \\note fields as indicated
  A462,A463,A464,A465,A466,A467,A468,A469,A470,A471, \\note fields as indicated
  A472,A473,A474,A475,A476,A477,A478,A479,A480,A481, \\note fields as indicated
  A482,A483,A484,A485,A486,A487,A488,A489,A490,A491, \\note fields as indicated
  A492,A493,A494,A495,A496,A497,A498,A499,A500,A501; \\note fields as indicated

ZoneGroup,
       \\memo Adds a multiplier to a ZoneList. This can be used to reduce the amount of input
       \\memo necessary for simulating repetitive structures, such as the identical floors of a
       \\memo multi-story building.
       \\min-fields 2
  A1 , \\field Name
       \\note Name of the Zone Group
       \\required-field
       \\type alpha
  A2,  \\field Zone List Name
       \\required-field
       \\type object-list
       \\object-list ZoneListNames
  N1;  \\field Zone List Multiplier
       \\type integer
       \\default 1
       \\minimum 1

BuildingSurface:Detailed,
  \\memo Allows for detailed entry of building heat transfer surfaces. Does not include subsurfaces such as windows or doors.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 20
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
       \\reference FloorSurfaceNames
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key Floor
       \\key Wall
       \\key Ceiling
       \\key Roof
  A3 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A4 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A5 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A6 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Foundation
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A7,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If Foundation, specify the name of the corresponding Foundation object and
       \\note the program will calculate the heat transfer appropriately
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A8 , \\field Sun Exposure
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A9,  \\field Wind Exposure
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 120 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates (last 3 fields),
       \\note remembering to remove ; from "inner" fields.
       \\note for clarity in any error messages, renumber the fields as well.
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Y-coordinate
       \\type real
       \\units m
  N35, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Y-coordinate
       \\type real
       \\units m
  N38, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Y-coordinate
       \\type real
       \\units m
  N41, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Y-coordinate
       \\type real
       \\units m
  N44, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Y-coordinate
       \\type real
       \\units m
  N47, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Y-coordinate
       \\type real
       \\units m
  N50, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Y-coordinate
       \\type real
       \\units m
  N53, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Y-coordinate
       \\type real
       \\units m
  N56, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Y-coordinate
       \\type real
       \\units m
  N59, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Y-coordinate
       \\type real
       \\units m
  N62, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Y-coordinate
       \\type real
       \\units m
  N65, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Y-coordinate
       \\type real
       \\units m
  N68, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Y-coordinate
       \\type real
       \\units m
  N71, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Y-coordinate
       \\type real
       \\units m
  N74, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Y-coordinate
       \\type real
       \\units m
  N77, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Y-coordinate
       \\type real
       \\units m
  N80, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Y-coordinate
       \\type real
       \\units m
  N83, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Y-coordinate
       \\type real
       \\units m
  N86, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Y-coordinate
       \\type real
       \\units m
  N89, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Y-coordinate
       \\type real
       \\units m
  N92, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N361, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N362; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Wall:Detailed,
  \\memo Allows for detailed entry of wall heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 19
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Foundation
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A6,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If Foundation, specify the name of the corresponding Foundation object and
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A7 , \\field Sun Exposure
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A8,  \\field Wind Exposure
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

RoofCeiling:Detailed,
  \\memo Allows for detailed entry of roof/ceiling heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 19
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Ground
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A6,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A7 , \\field Sun Exposure
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A8,  \\field Wind Exposure
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

Floor:Detailed,
  \\memo Allows for detailed entry of floor heat transfer surfaces.
  \\extensible:3 -- duplicate last set of x,y,z coordinates (last 3 fields), remembering to remove ; from "inner" fields.
  \\format vertices
  \\min-fields 19
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
       \\reference FloorSurfaceNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition
       \\required-field
       \\type choice
       \\key Adiabatic
       \\key Surface
       \\key Zone
       \\key Outdoors
       \\key Foundation
       \\key Ground
       \\key GroundFCfactorMethod
       \\key OtherSideCoefficients
       \\key OtherSideConditionsModel
       \\key GroundSlabPreprocessorAverage
       \\key GroundSlabPreprocessorCore
       \\key GroundSlabPreprocessorPerimeter
       \\key GroundBasementPreprocessorAverageWall
       \\key GroundBasementPreprocessorAverageFloor
       \\key GroundBasementPreprocessorUpperWall
       \\key GroundBasementPreprocessorLowerWall
  A6,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if the field Outside Boundary Condition is Surface,
       \\note Zone, OtherSideCoefficients or OtherSideConditionsModel
       \\note If Surface, specify name of corresponding surface in adjacent zone or
       \\note specify current surface name for internal partition separating like zones
       \\note If Zone, specify the name of the corresponding zone and
       \\note the program will generate the corresponding interzone surface
       \\note If Foundation, specify the name of the corresponding Foundation object and
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note If OtherSideConditionsModel, specify name of SurfaceProperty:OtherSideConditionsModel
  A7,  \\field Sun Exposure
       \\type choice
       \\key SunExposed
       \\key NoSun
       \\default SunExposed
  A8,  \\field Wind Exposure
       \\type choice
       \\key WindExposed
       \\key NoWind
       \\default WindExposed
  N1,  \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  N2 , \\field Number of Vertices
       \\note shown with 10 vertex coordinates -- extensible object
       \\note  "extensible" -- duplicate last set of x,y,z coordinates, renumbering please
       \\note (and changing z terminator to a comma "," for all but last one which needs a semi-colon ";")
       \\autocalculatable
       \\minimum 3
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N3,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N14, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N17, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Y-coordinate
       \\type real
       \\units m
  N20, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Y-coordinate
       \\type real
       \\units m
  N23, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Y-coordinate
       \\type real
       \\units m
  N26, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Y-coordinate
       \\type real
       \\units m
  N29, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Y-coordinate
       \\type real
       \\units m
  N32; \\field Vertex 10 Z-coordinate
       \\units m
       \\type real

Wall:Exterior,
       \\memo Allows for simplified entry of exterior walls.
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Adiabatic,
       \\memo Allows for simplified entry of interior walls.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Underground,
       \\memo Allows for simplified entry of underground walls.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file.
       \\note If the construction is type "Construction:CfactorUndergroundWall",
       \\note then the GroundFCfactorMethod will be used.
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Wall:Interzone,
       \\memo Allows for simplified entry of interzone walls (walls between zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone for the inside face of the surface.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space for the inside face of the surface (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior walls.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior wall in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Walls are usually tilted 90 degrees
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting (x,y,z) coordinate is the Lower Left Corner of the Wall
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Roof,
       \\memo Allows for simplified entry of roofs (exterior).
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of Roof
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Flat Roofs are tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, Starting coordinate is the Lower Left Corner of the Roof
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Ceiling:Adiabatic,
       \\memo Allows for simplified entry of interior ceilings.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of Ceiling
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Ceilings are usually tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, Starting coordinate is the Lower Left Corner of the Ceiling
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Ceiling:Interzone,
       \\memo Allows for simplified entry of ceilings using adjacent zone
       \\memo (interzone) heat transfer - adjacent surface should be a floor
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior floors
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior floor in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of wall (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Ceilings are usually tilted 0 degrees
       \\minimum 0
       \\maximum 180
       \\default 0
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, should be Lower Left Corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:GroundContact,
       \\memo Allows for simplified entry of exterior floors with ground contact.
       \\memo View Factors to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
       \\reference FloorSurfaceNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\note If the construction is type "Construction:FfactorGroundFloor",
       \\note then the GroundFCfactorMethod will be used.
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\units deg
       \\minimum 0
       \\maximum 360
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\units deg
       \\minimum 0
       \\maximum 180
       \\default 180
  N3,  \\field Starting X Coordinate
       \\note if not flat, should be lower left corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:Adiabatic,
       \\memo Allows for simplified entry of exterior floors
       \\memo ignoring ground contact or interior floors.
       \\memo View Factor to Ground is automatically calculated.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
       \\reference FloorSurfaceNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone the surface is a part of.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  N1,  \\field Azimuth Angle
       \\units deg
       \\minimum 0
       \\maximum 360
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\units deg
       \\minimum 0
       \\maximum 180
       \\default 180
  N3,  \\field Starting X Coordinate
       \\note if not flat, should be lower left corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

Floor:Interzone,
       \\memo Allows for simplified entry of floors using adjacent zone
       \\memo (interzone) heat transfer - adjacent surface should be a ceiling.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
       \\reference FloorSurfaceNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone Name
       \\required-field
       \\note Zone for the inside face of the surface.
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Space Name
       \\note Space for the inside face of the surface (optional, see description of Space object for more details).
       \\type object-list
       \\object-list SpaceNames
  A5 , \\field Outside Boundary Condition Object
       \\required-field
       \\note Specify a surface name in an adjacent zone for known interior ceilings.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior ceiling in the adjacent zone.
       \\type object-list
       \\object-list OutFaceEnvNames
  N1,  \\field Azimuth Angle
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\note Floors are usually tilted 180 degrees
       \\minimum 0
       \\maximum 180
       \\default 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note If not Flat, should be Lower Left Corner (from outside)
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\note Along X Axis
       \\units m
  N7;  \\field Width
       \\note Along Y Axis
       \\units m

FenestrationSurface:Detailed,
       \\memo Allows for detailed entry of subsurfaces
       \\memo (windows, doors, glass doors, tubular daylighting devices).
       \\min-fields 18
       \\format vertices
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference GlazedExtSubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key Window
       \\key Door
       \\key GlassDoor
       \\key TubularDaylightDome
       \\key TubularDaylightDiffuser
  A3 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
       \\object-list ComplexFenestrationStates
  A4 , \\field Building Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A5,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Non-blank only if base surface field Outside Boundary Condition is
       \\note Surface or OtherSideCoefficients
       \\note If Base Surface's Surface, specify name of corresponding subsurface in adjacent zone or
       \\note specify current subsurface name for internal partition separating like zones
       \\note If OtherSideCoefficients, specify name of SurfaceProperty:OtherSideCoefficients
       \\note  or leave blank to inherit Base Surface's OtherSide Coefficients
  N1, \\field View Factor to Ground
       \\type real
       \\note From the exterior of the surface
       \\note Unused if one uses the "reflections" options in Solar Distribution in Building input
       \\note unless a DaylightingDevice:Shelf or DaylightingDevice:Tubular object has been specified.
       \\note autocalculate will automatically calculate this value from the tilt of the surface
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default autocalculate
  A6,  \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N2,  \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N3,  \\field Number of Vertices
       \\minimum 3
       \\maximum 4
       \\autocalculatable
       \\default autocalculate
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. If world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N4,  \\field Vertex 1 X-coordinate
       \\required-field
       \\units m
       \\type real
  N5 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N6 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N7,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N8,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N10,  \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N12, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N13, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
       \\note Not used for triangles
  N14, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
       \\note Not used for triangles
  N15; \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
       \\note Not used for triangles

Window,
       \\memo Allows for simplified entry of Windows.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference GlazedExtSubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Window is on (i.e., Base Surface)
       \\note Window assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4, \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Window starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Window starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Door,
       \\memo Allows for simplified entry of opaque Doors.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

GlazedDoor,
       \\memo Allows for simplified entry of glass Doors.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference GlazedExtSubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4, \\field Frame and Divider Name
       \\note Enter the name of a WindowProperty:FrameAndDivider object
       \\type object-list
       \\object-list WindowFrameAndDividerNames
       \\note Used only for exterior windows (rectangular) and glass doors.
       \\note Unused for triangular windows.
       \\note If not specified (blank), window or glass door has no frame or divider
       \\note and no beam solar reflection from reveal surfaces.
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Window:Interzone,
       \\memo Allows for simplified entry of interzone windows (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Window is on (i.e., Base Surface)
       \\note Window assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior windows.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior window in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Window starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Window starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

Door:Interzone,
       \\memo Allows for simplified entry of interzone (opaque interior) doors (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior doors.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior door in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

GlazedDoor:Interzone,
       \\memo Allows for simplified entry of interzone (glass interior) doors (adjacent to
       \\memo other zones).
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference SubSurfNames
       \\reference SurfAndSubSurfNames
       \\reference AllHeatTranSurfNames
       \\reference OutFaceEnvNames
       \\reference AllHeatTranAngFacNames
       \\reference AllShadingAndHTSurfNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Building Surface Name
       \\note Name of Surface (Wall, usually) the Door is on (i.e., Base Surface)
       \\note Door assumes the azimuth and tilt angles of the surface it is on.
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Outside Boundary Condition Object
       \\type object-list
       \\object-list OutFaceEnvNames
       \\note Specify a surface name in an adjacent zone for known interior doors.
       \\note Specify a zone name of an adjacent zone to automatically generate
       \\note the interior door in the adjacent zone.
       \\note a blank field will set up a Window in an adjacent zone
       \\note (same zone as adjacent to base surface)
  N1 , \\field Multiplier
       \\note Used only for Surface Type = WINDOW, GLASSDOOR or DOOR
       \\note Non-integer values will be truncated to integer
       \\default 1.0
       \\minimum 1.0
  N2,  \\field Starting X Coordinate
       \\note Door starting coordinate is specified relative to the Base Surface origin.
       \\units m
  N3,  \\field Starting Z Coordinate
       \\note How far up the wall the Door starts. (in 2-d, this would be a Y Coordinate)
       \\units m
  N4,  \\field Length
       \\units m
  N5;  \\field Height
       \\units m

WindowShadingControl,
       \\memo Specifies the type, location, and controls for window shades, window blinds, and
       \\memo switchable glazing. Referencing the surface objects for exterior windows and glass
       \\memo doors (ref: FenestrationSurface:Detailed, Window, and GlazedDoor).
       \\extensible:1
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference WindowShadeControlNames
       \\note Referenced by surfaces that are exterior windows
       \\note Not used by interzone windows
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Shading Control Sequence Number
       \\type integer
       \\minimum 1
       \\default 1
       \\note If multiple WindowShadingControl objects are used than the order that they deploy the window shades
       \\note can be set with this field. The first WindowShadingControl should be 1 and subsequent
       \\note WindowShadingControl should 2 or 3 or higher. This is usually used when the Multiple Surface Control Type
       \\note field is set to Group and groups of windows are being controlled in a certain order.
  A3 , \\field Shading Type
       \\required-field
       \\type choice
       \\key InteriorShade
       \\key ExteriorShade
       \\key ExteriorScreen
       \\key InteriorBlind
       \\key ExteriorBlind
       \\key BetweenGlassShade
       \\key BetweenGlassBlind
       \\key SwitchableGlazing
  A4 , \\field Construction with Shading Name
       \\type object-list
       \\object-list ConstructionNames
       \\note Required if Shading Type = SwitchableGlazing
       \\note Required if Shading Type = interior or exterior shade or blind, or exterior screen, and
       \\note "Shading Device Material Name" is not specified.
       \\note If both "Construction with Shading Name" and "Shading Device Material Name" are entered,
       \\note the former takes precedence.
  A5 , \\field Shading Control Type
       \\required-field
       \\type choice
       \\key AlwaysOn
       \\key AlwaysOff
       \\key OnIfScheduleAllows
       \\note OnIfScheduleAllows requires that Schedule Name be specified and
       \\note Shading Control Is Scheduled = Yes.
       \\note AlwaysOn, AlwaysOff and OnIfScheduleAllows are the only valid control types for ExteriorScreen.
       \\note The following six control types are used primarily to reduce
       \\note zone cooling load due to window solar gain
       \\key OnIfHighSolarOnWindow
       \\key OnIfHighHorizontalSolar
       \\key OnIfHighOutdoorAirTemperature
       \\key OnIfHighZoneAirTemperature
       \\key OnIfHighZoneCooling
       \\key OnIfHighGlare
       \\note Following entry should be used only if Shading Type = SwitchableGlazing
       \\note and window is in a daylit zone
       \\key MeetDaylightIlluminanceSetpoint
       \\note The following three control types are used to reduce zone Heating load. They can be
       \\note used with any Shading Type but are most appropriate for opaque interior or exterior
       \\note shades with high insulating value ("opaque movable insulation")
       \\key OnNightIfLowOutdoorTempAndOffDay
       \\key OnNightIfLowInsideTempAndOffDay
       \\key OnNightIfHeatingAndOffDay
       \\note The following two control types are used to reduce zone heating and cooling load.
       \\note They can be used with any Shading Type but are most appropriate for translucent interior
       \\note or exterior shades with high insulating value ("translucent movable insulation")
       \\key OnNightIfLowOutdoorTempAndOnDayIfCooling
       \\key OnNightIfHeatingAndOnDayIfCooling
       \\note The following two control types are used to reduce zone Cooling load.
       \\note They can be used with any Shading Type but are most appropriate for interior
       \\note or exterior blinds,interior or exterior shades with low insulating value, or
       \\note switchable glazing
       \\key OffNightAndOnDayIfCoolingAndHighSolarOnWindow
       \\key OnNightAndOnDayIfCoolingAndHighSolarOnWindow
       \\note The following four control types require that both Setpoint and Setpoint2 be specified
       \\note Setpoint will correspond to outdoor air temp or zone air temp (deg C)
       \\note Setpoint2 will correspond to solar on window or horizontal solar (W/m2)
       \\key OnIfHighOutdoorAirTempAndHighSolarOnWindow
       \\key OnIfHighOutdoorAirTempAndHighHorizontalSolar
       \\key OnIfHighZoneAirTempAndHighSolarOnWindow
       \\key OnIfHighZoneAirTempAndHighHorizontalSolar
  A6 , \\field Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Required if Shading Control Is Scheduled = Yes.
       \\note If schedule value = 1, shading control is active, i.e., shading can take place only
       \\note if the control test passes. If schedule value = 0, shading is off whether or not
       \\note the control test passes. Schedule Name is required if Shading Control Is Scheduled = Yes.
       \\note If Schedule Name is not specified, shading control is assumed to be active at all times.
  N2 , \\field Setpoint
       \\units W/m2, W or deg C
       \\note W/m2 for solar-based controls, W for cooling- or heating-based controls,
       \\note deg C for temperature-based controls.
       \\note Unused for Shading Control Type = AlwaysOn, AlwaysOff, OnIfScheduleAllows,
       \\note OnIfHighGlare, Glare, and DaylightIlluminance
       \\type real
  A7 , \\field Shading Control Is Scheduled
       \\type choice
       \\key No
       \\key Yes
       \\default No
       \\note If Yes, Schedule Name is required; if No, Schedule Name is not used.
       \\note Shading Control Is Scheduled = Yes is required if Shading Control Type = OnIfScheduleAllows.
  A8 , \\field Glare Control Is Active
       \\type choice
       \\key No
       \\key Yes
       \\default No
       \\note If Yes and window is in a daylit zone, shading is on if zone's discomfort glare index exceeds
       \\note the maximum discomfort glare index specified in the Daylighting object referenced by the zone.
       \\note The glare test is OR'ed with the test specified by Shading Control Type.
       \\note Glare Control Is Active = Yes is required if Shading Control Type = OnIfHighGlare.
  A9 , \\field Shading Device Material Name
       \\type object-list
       \\object-list WindowShadesScreensAndBlinds
       \\note Enter the name of a WindowMaterial:Shade, WindowMaterial:Screen or WindowMaterial:Blind object.
       \\note Required if "Construction with Shading Name" is not specified.
       \\note Not used if Shading Control Type = SwitchableGlazing, BetweenGlassShade, or BetweenGlassBlind.
       \\note If both "Construction with Shading Name" and "Shading Device Material Name" are entered,
       \\note the former takes precedence.
  A10, \\field Type of Slat Angle Control for Blinds
       \\type choice
       \\key FixedSlatAngle
       \\key ScheduledSlatAngle
       \\key BlockBeamSolar
       \\default FixedSlatAngle
       \\note Used only if Shading Type = InteriorBlind, ExteriorBlind or BetweenGlassBlind.
       \\note If choice is ScheduledSlatAngle then Slat Angle Schedule Name is required.
  A11, \\field Slat Angle Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Used only if Shading Type = InteriorBlind, ExteriorBlind or BetweenGlassBlind.
       \\note Required if Type of Slat Angle Control for Blinds = ScheduledSlatAngle
       \\note Schedule values should be degrees (0 minimum, 180 maximum)
  N3 , \\field Setpoint 2
       \\units W/m2 or deg C
       \\note W/m2 for solar-based controls, deg C for temperature-based controls.
       \\note Used only as the second setpoint for the following two-setpoint control types:
       \\note OnIfHighOutdoorAirTempAndHighSolarOnWindow, OnIfHighOutdoorAirTempAndHighHorizontalSolar,
       \\note OnIfHighZoneAirTempAndHighSolarOnWindow, and OnIfHighZoneAirTempAndHighHorizontalSolar
       \\type real
       \\ip-units unknown
  A12, \\field Daylighting Control Object Name
       \\type object-list
       \\object-list DaylightingControlNames
       \\note Reference to the Daylighting:Controls object that provides the glare and illuminance control to the zone.
  A13, \\field Multiple Surface Control Type
       \\type choice
       \\key Sequential
       \\key Group
       \\default Sequential
       \\note When Sequential is used the list of fenestration surfaces are controlled individually in the order specified
       \\note When Group is used the entire list is controlled simultaneously and if glare control is needed the entire
       \\note group of window shades are deployed together a the same time
  A14, \\field Fenestration Surface 1 Name
       \\required-field
       \\begin-extensible
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A15, \\field Fenestration Surface 2 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A16, \\field Fenestration Surface 3 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A17, \\field Fenestration Surface 4 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A18, \\field Fenestration Surface 5 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A19, \\field Fenestration Surface 6 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A20, \\field Fenestration Surface 7 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A21, \\field Fenestration Surface 8 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A22, \\field Fenestration Surface 9 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.
  A23; \\field Fenestration Surface 10 Name
       \\type object-list
       \\object-list GlazedExtSubSurfNames
       \\note When Multiple Surface Control Type is set to Sequential the shades will be deployed for the referenced surface objects in order.
       \\note When that field is set to Group the entire list is controlled simultaneously.

WindowProperty:FrameAndDivider,
         \\memo Specifies the dimensions of a window frame, dividers, and inside reveal surfaces.
         \\memo Referenced by the surface objects for exterior windows and glass doors
         \\memo (ref: FenestrationSurface:Detailed, Window, and GlazedDoor).
      \\min-fields 20
    A1 , \\field Name
         \\required-field
         \\type alpha
         \\reference WindowFrameAndDividerNames
         \\note Referenced by surfaces that are exterior windows
         \\note Not used by interzone windows
    N1 , \\field Frame Width
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Width of frame in plane of window
         \\note Frame width assumed the same on all sides of window
    N2 , \\field Frame Outside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that frame projects outward from the outside face of the glazing
    N3 , \\field Frame Inside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that frame projects inward from the inside face of the glazing
    N4 , \\field Frame Conductance
         \\units W/m2-K
         \\type real
         \\minimum 0.0
         \\note Effective conductance of frame
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N5 , \\field Ratio of Frame-Edge Glass Conductance to Center-Of-Glass Conductance
         \\type real
         \\minimum> 0.0
         \\maximum 4.0
         \\default 1.0
         \\note Excludes air films; applies only to multipane windows
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N6 , \\field Frame Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.7
         \\note Assumed same on outside and inside of frame
    N7 , \\field Frame Visible Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.7
         \\note Assumed same on outside and inside of frame
    N8 , \\field Frame Thermal Hemispherical Emissivity
         \\type real
         \\minimum> 0.0
         \\default 0.9
         \\note Assumed same on outside and inside of frame
    A2 , \\field Divider Type
         \\type choice
         \\key DividedLite
         \\key Suspended
         \\default DividedLite
    N9 , \\field Divider Width
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Width of dividers in plane of window
         \\note Width assumed the same for all dividers
    N10, \\field Number of Horizontal Dividers
         \\type real
         \\minimum 0
         \\default 0
         \\note "Horizontal" means parallel to local window X-axis
    N11, \\field Number of Vertical Dividers
         \\type real
         \\minimum 0
         \\default 0
         \\note "Vertical" means parallel to local window Y-axis
    N12, \\field Divider Outside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that divider projects outward from the outside face of the glazing
         \\note Outside projection assumed the same for all divider elements
    N13, \\field Divider Inside Projection
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 0.5
         \\default 0.0
         \\note Amount that divider projects inward from the inside face of the glazing
         \\note Inside projection assumed the same for all divider elements
    N14, \\field Divider Conductance
         \\units W/m2-K
         \\type real
         \\minimum 0.0
         \\default 0.0
         \\note Effective conductance of divider
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N15, \\field Ratio of Divider-Edge Glass Conductance to Center-Of-Glass Conductance
         \\type real
         \\minimum> 0.0
         \\maximum 4.0
         \\default 1.0
         \\note Excludes air films
         \\note Obtained from WINDOW 5 or other 2-D calculation
    N16, \\field Divider Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Assumed same on outside and inside of divider
    N17, \\field Divider Visible Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
         \\note Assumed same on outside and inside of divider
    N18, \\field Divider Thermal Hemispherical Emissivity
         \\type real
         \\minimum> 0.0
         \\maximum< 1.0
         \\default 0.9
         \\note Assumed same on outside and inside of divider
    N19, \\field Outside Reveal Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
    N20, \\field Inside Sill Depth
         \\units m
         \\type real
         \\minimum 0.0
         \\maximum 2.0
         \\default 0.0
    N21, \\field Inside Sill Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0
    N22, \\field Inside Reveal Depth
         \\note Distance from plane of inside surface of glazing
         \\note to plane of inside surface of wall.
         \\note Outside reveal depth is determined from the geometry
         \\note of the window and the wall it is on; it is non-zero if the plane of
         \\note the outside surface of the glazing is set back from the plane of the
         \\note outside surface of the wall.
         \\units m
         \\minimum 0.0
         \\maximum 2.0
         \\default 0.0
    N23; \\field Inside Reveal Solar Absorptance
         \\type real
         \\minimum 0.0
         \\maximum 1.0
         \\default 0.0

WindowProperty:AirflowControl,
    \\memo Used to control forced airflow through a gap between glass layers
    \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
       \\note Name must be that of an exterior window with two or three glass layers.
  A2 , \\field Airflow Source
       \\type choice
       \\key IndoorAir
       \\key OutdoorAir
       \\default IndoorAir
  A3 , \\field Airflow Destination
       \\note If ReturnAir is selected, the name of the Return Air Node may be specified below.
       \\type choice
       \\key IndoorAir
       \\key OutdoorAir
       \\key ReturnAir
       \\default OutdoorAir
  N1 , \\field Maximum Flow Rate
       \\units m3/s-m
       \\note Above is m3/s per m of glazing width
       \\ip-units ft3/min-ft
       \\default 0.0
       \\minimum 0.0
  A4 , \\field Airflow Control Type
       \\type choice
       \\key AlwaysOnAtMaximumFlow
       \\key AlwaysOff
       \\key ScheduledOnly
       \\note ScheduledOnly requires that Airflow Has Multiplier Schedule Name = Yes
       \\note  and that Airflow Multiplier Schedule Name is specified.
       \\default AlwaysOnAtMaximumFlow
  A5 , \\field Airflow Is Scheduled
       \\type choice
       \\key Yes
       \\key No
       \\default No
       \\note If Yes, then Airflow Multiplier Schedule Name must be specified
  A6 , \\field Airflow Multiplier Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Required if Airflow Is Scheduled = Yes.
       \\note Schedule values are 0.0 or 1.0 and multiply Maximum Air Flow.
  A7 ; \\field Airflow Return Air Node Name
       \\note Name of the return air node for this airflow window if the Airflow Destination is ReturnAir.
       \\note If left blank, defaults to the first return air node for the zone of the window surface.
       \\type node

WindowProperty:StormWindow,
       \\min-fields 7
       \\memo This is a movable exterior glass layer that is usually applied in the winter
       \\memo and removed in the summer.
  A1,  \\field Window Name
       \\note Must be the name of a FenestrationSurface:Detailed object with Surface Type = WINDOW.
       \\note The WindowProperty:StormWindow object can only be used with exterior windows.
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A2,  \\field Storm Glass Layer Name
       \\note Must be a WindowMaterial:Glazing or WindowMaterial:Glazing:RefractionExtinctionMethod
       \\note Gap between storm glass layer and adjacent glass layer is assumed to be filled
       \\note with Air
       \\required-field
       \\type object-list
       \\object-list GlazingMaterialName
  N1,  \\field Distance Between Storm Glass Layer and Adjacent Glass
       \\type real
       \\units m
       \\minimum> 0.0
       \\maximum 0.5
       \\default 0.050
  N2,  \\field Month that Storm Glass Layer is Put On
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N3,  \\field Day of Month that Storm Glass Layer is Put On
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer
  N4,  \\field Month that Storm Glass Layer is Taken Off
       \\required-field
       \\minimum 1
       \\maximum 12
       \\type integer
  N5;  \\field Day of Month that Storm Glass Layer is Taken Off
       \\required-field
       \\minimum 1
       \\maximum 31
       \\type integer

InternalMass,
       \\memo Used to describe internal zone surface area that does not need to be part of geometric
       \\memo representation. This should be the total surface area exposed to the zone air.
       \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
       \\memo to all the zones in the ZoneList. Likewise for SpaceList.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllHeatTranSurfNames
       \\reference AllHeatTranAngFacNames
       \\reference RadiantSurfaceNames
  A2 , \\field Construction Name
       \\required-field
       \\note To be matched with a construction in this input file
       \\type object-list
       \\object-list ConstructionNames
  A3 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\note Zone the surface is a part of.
       \\note used to be Interior Environment
  A4 , \\field Space or SpaceList Name
       \\type object-list
       \\object-list SpaceAndSpaceListNames
       \\note Space the surface is a part of (optional, see description of Space object for more details).
       \\note This field is ignored when a ZoneList Name is specified for Zone or ZoneList Name.
  N1 ; \\field Surface Area
       \\required-field
       \\units m2
       \\minimum> 0

Shading:Site,
       \\memo used for shading elements such as trees
       \\memo these items are fixed in space and would not move with relative geometry
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of shading device (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting coordinate is the Lower Left Corner of the Shade
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Shading:Building,
       \\memo used for shading elements such as trees, other buildings, parts of this building not being modeled
       \\memo these items are relative to the current building and would move with relative geometry
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  N1,  \\field Azimuth Angle
       \\note Facing direction of outside of shading device (S=180,N=0,E=90,W=270)
       \\minimum 0
       \\maximum 360
       \\units deg
  N2,  \\field Tilt Angle
       \\default 90
       \\minimum 0
       \\maximum 180
       \\units deg
  N3,  \\field Starting X Coordinate
       \\note Starting coordinate is the Lower Left Corner of the Shade
       \\units m
  N4,  \\field Starting Y Coordinate
       \\units m
  N5,  \\field Starting Z Coordinate
       \\units m
  N6,  \\field Length
       \\units m
  N7;  \\field Height
       \\units m

Shading:Site:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used for shading elements such as trees
       \\memo these items are fixed in space and would not move with relative geometry
       \\format vertices
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note Rules for vertices are given in GlobalGeometryRules coordinates --
       \\note For this object all surface coordinates are in world coordinates.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\units m
       \\type real
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Shading:Building:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used for shading elements such as trees, other buildings, parts of this building not being modeled
       \\memo these items are relative to the current building and would move with relative geometry
       \\format vertices
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note Rules for vertices are given in GlobalGeometryRules coordinates --
       \\note For this object all surface coordinates are relative to the building origin (0,0,0)
       \\note and will rotate with the BUILDING north axis.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\units m
       \\type real
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

Shading:Overhang,
      \\memo Overhangs are usually flat shading surfaces that reference a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Height above Window or Door
       \\units m
  N2,  \\field Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N3,  \\field Left extension from Window/Door Width
       \\units m
  N4,  \\field Right extension from Window/Door Width
       \\note N3 + N4 + Window/Door Width is Overhang Length
       \\units m
  N5;  \\field Depth
       \\units m
       \\minimum 0

Shading:Overhang:Projection,
      \\memo Overhangs are typically flat shading surfaces that reference a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Height above Window or Door
       \\units m
  N2,  \\field Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N3,  \\field Left extension from Window/Door Width
       \\units m
  N4,  \\field Right extension from Window/Door Width
       \\units m
       \\note N3 + N4 + Window/Door Width is Overhang Length
  N5;  \\field Depth as Fraction of Window/Door Height
       \\units dimensionless
       \\minimum 0

Shading:Fin,
      \\memo Fins are usually shading surfaces that are perpendicular to a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Left Extension from Window/Door
       \\units m
  N2,  \\field Left Distance Above Top of Window
       \\units m
  N3,  \\field Left Distance Below Bottom of Window
       \\units m
       \\note N2 + N3 + height of Window/Door is height of Fin
  N4,  \\field Left Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N5,  \\field Left Depth
       \\units m
       \\minimum 0
  N6,  \\field Right Extension from Window/Door
       \\units m
  N7,  \\field Right Distance Above Top of Window
       \\units m
  N8,  \\field Right Distance Below Bottom of Window
       \\note N7 + N8 + height of Window/Door is height of Fin
       \\units m
  N9,  \\field Right Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N10; \\field Right Depth
       \\units m
       \\minimum 0

Shading:Fin:Projection,
      \\memo Fins are usually shading surfaces that are perpendicular to a window or door.
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Window or Door Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Left Extension from Window/Door
       \\units m
  N2,  \\field Left Distance Above Top of Window
       \\units m
  N3,  \\field Left Distance Below Bottom of Window
       \\units m
       \\note N2 + N3 + height of Window/Door is height of Fin
  N4,  \\field Left Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N5,  \\field Left Depth as Fraction of Window/Door Width
       \\units dimensionless
       \\minimum 0
  N6,  \\field Right Extension from Window/Door
       \\units m
  N7,  \\field Right Distance Above Top of Window
       \\units m
  N8,  \\field Right Distance Below Bottom of Window
       \\note N7 + N8 + height of Window/Door is height of Fin
       \\units m
  N9,  \\field Right Tilt Angle from Window/Door
       \\units deg
       \\default 90
       \\minimum 0
       \\maximum 180
  N10; \\field Right Depth as Fraction of Window/Door Width
       \\units dimensionless
       \\minimum 0

Shading:Zone:Detailed,
  \\extensible:3 -- duplicate last set of x,y,z coordinates, renumbering please (and changing z terminator to , for all but last)
       \\memo used For fins, overhangs, elements that shade the building, are attached to the building
       \\memo but are not part of the heat transfer calculations
       \\format vertices
       \\min-fields 13
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference AttachedShadingSurfNames
       \\reference AllShadingAndHTSurfNames
       \\reference AllShadingSurfNames
  A2 , \\field Base Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A3,  \\field Transmittance Schedule Name
       \\note Transmittance schedule for the shading device, defaults to zero (always opaque)
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Vertices
       \\note shown with 6 vertex coordinates -- extensible object
       \\autocalculatable
       \\default autocalculate
       \\minimum 3
       \\note vertices are given in GlobalGeometryRules coordinates -- if relative, all surface coordinates
       \\note are "relative" to the Zone Origin. if world, then building and zone origins are used
       \\note for some internal calculations, but all coordinates are given in an "absolute" system.
  N2,  \\field Vertex 1 X-coordinate
       \\begin-extensible
       \\required-field
       \\units m
       \\type real
  N3 , \\field Vertex 1 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N4 , \\field Vertex 1 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N5,  \\field Vertex 2 X-coordinate
       \\required-field
       \\units m
       \\type real
  N6,  \\field Vertex 2 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N7, \\field Vertex 2 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N8, \\field Vertex 3 X-coordinate
       \\required-field
       \\units m
       \\type real
  N9,  \\field Vertex 3 Y-coordinate
       \\required-field
       \\units m
       \\type real
  N10, \\field Vertex 3 Z-coordinate
       \\required-field
       \\units m
       \\type real
  N11, \\field Vertex 4 X-coordinate
       \\units m
       \\type real
  N12, \\field Vertex 4 Y-coordinate
       \\type real
       \\units m
  N13, \\field Vertex 4 Z-coordinate
       \\units m
       \\type real
  N14, \\field Vertex 5 X-coordinate
       \\units m
       \\type real
  N15, \\field Vertex 5 Y-coordinate
       \\type real
       \\units m
  N16, \\field Vertex 5 Z-coordinate
       \\units m
       \\type real
  N17, \\field Vertex 6 X-coordinate
       \\units m
       \\type real
  N18, \\field Vertex 6 Y-coordinate
       \\units m
       \\type real
  N19, \\field Vertex 6 Z-coordinate
       \\units m
       \\type real
  N20, \\field Vertex 7 X-coordinate
       \\units m
       \\type real
  N21, \\field Vertex 7 Y-coordinate
       \\units m
       \\type real
  N22, \\field Vertex 7 Z-coordinate
       \\units m
       \\type real
  N23, \\field Vertex 8 X-coordinate
       \\units m
       \\type real
  N24, \\field Vertex 8 Y-coordinate
       \\units m
       \\type real
  N25, \\field Vertex 8 Z-coordinate
       \\units m
       \\type real
  N26, \\field Vertex 9 X-coordinate
       \\units m
       \\type real
  N27, \\field Vertex 9 Y-coordinate
       \\units m
       \\type real
  N28, \\field Vertex 9 Z-coordinate
       \\units m
       \\type real
  N29, \\field Vertex 10 X-coordinate
       \\units m
       \\type real
  N30, \\field Vertex 10 Y-coordinate
       \\units m
       \\type real
  N31, \\field Vertex 10 Z-coordinate
       \\units m
       \\type real
  N32, \\field Vertex 11 X-coordinate
       \\units m
       \\type real
  N33, \\field Vertex 11 Y-coordinate
       \\units m
       \\type real
  N34, \\field Vertex 11 Z-coordinate
       \\units m
       \\type real
  N35, \\field Vertex 12 X-coordinate
       \\units m
       \\type real
  N36, \\field Vertex 12 Y-coordinate
       \\units m
       \\type real
  N37, \\field Vertex 12 Z-coordinate
       \\units m
       \\type real
  N38, \\field Vertex 13 X-coordinate
       \\units m
       \\type real
  N39, \\field Vertex 13 Y-coordinate
       \\units m
       \\type real
  N40, \\field Vertex 13 Z-coordinate
       \\units m
       \\type real
  N41, \\field Vertex 14 X-coordinate
       \\units m
       \\type real
  N42, \\field Vertex 14 Y-coordinate
       \\units m
       \\type real
  N43, \\field Vertex 14 Z-coordinate
       \\units m
       \\type real
  N44, \\field Vertex 15 X-coordinate
       \\units m
       \\type real
  N45, \\field Vertex 15 Y-coordinate
       \\units m
       \\type real
  N46, \\field Vertex 15 Z-coordinate
       \\units m
       \\type real
  N47, \\field Vertex 16 X-coordinate
       \\units m
       \\type real
  N48, \\field Vertex 16 Y-coordinate
       \\units m
       \\type real
  N49, \\field Vertex 16 Z-coordinate
       \\units m
       \\type real
  N50, \\field Vertex 17 X-coordinate
       \\units m
       \\type real
  N51, \\field Vertex 17 Y-coordinate
       \\units m
       \\type real
  N52, \\field Vertex 17 Z-coordinate
       \\units m
       \\type real
  N53, \\field Vertex 18 X-coordinate
       \\units m
       \\type real
  N54, \\field Vertex 18 Y-coordinate
       \\units m
       \\type real
  N55, \\field Vertex 18 Z-coordinate
       \\units m
       \\type real
  N56, \\field Vertex 19 X-coordinate
       \\units m
       \\type real
  N57, \\field Vertex 19 Y-coordinate
       \\units m
       \\type real
  N58, \\field Vertex 19 Z-coordinate
       \\units m
       \\type real
  N59, \\field Vertex 20 X-coordinate
       \\units m
       \\type real
  N60, \\field Vertex 20 Y-coordinate
       \\units m
       \\type real
  N61, \\field Vertex 20 Z-coordinate
       \\units m
       \\type real
  N62, \\field Vertex 21 X-coordinate
       \\units m
       \\type real
  N63, \\field Vertex 21 Y-coordinate
       \\units m
       \\type real
  N64, \\field Vertex 21 Z-coordinate
       \\units m
       \\type real
  N65, \\field Vertex 22 X-coordinate
       \\units m
       \\type real
  N66, \\field Vertex 22 Y-coordinate
       \\units m
       \\type real
  N67, \\field Vertex 22 Z-coordinate
       \\units m
       \\type real
  N68, \\field Vertex 23 X-coordinate
       \\units m
       \\type real
  N69, \\field Vertex 23 Y-coordinate
       \\units m
       \\type real
  N70, \\field Vertex 23 Z-coordinate
       \\units m
       \\type real
  N71, \\field Vertex 24 X-coordinate
       \\units m
       \\type real
  N72, \\field Vertex 24 Y-coordinate
       \\units m
       \\type real
  N73, \\field Vertex 24 Z-coordinate
       \\units m
       \\type real
  N74, \\field Vertex 25 X-coordinate
       \\units m
       \\type real
  N75, \\field Vertex 25 Y-coordinate
       \\units m
       \\type real
  N76, \\field Vertex 25 Z-coordinate
       \\units m
       \\type real
  N77, \\field Vertex 26 X-coordinate
       \\units m
       \\type real
  N78, \\field Vertex 26 Y-coordinate
       \\units m
       \\type real
  N79, \\field Vertex 26 Z-coordinate
       \\units m
       \\type real
  N80, \\field Vertex 27 X-coordinate
       \\units m
       \\type real
  N81, \\field Vertex 27 Y-coordinate
       \\units m
       \\type real
  N82, \\field Vertex 27 Z-coordinate
       \\units m
       \\type real
  N83, \\field Vertex 28 X-coordinate
       \\units m
       \\type real
  N84, \\field Vertex 28 Y-coordinate
       \\units m
       \\type real
  N85, \\field Vertex 28 Z-coordinate
       \\units m
       \\type real
  N86, \\field Vertex 29 X-coordinate
       \\units m
       \\type real
  N87, \\field Vertex 29 Y-coordinate
       \\units m
       \\type real
  N88, \\field Vertex 29 Z-coordinate
       \\units m
       \\type real
  N89, \\field Vertex 30 X-coordinate
       \\units m
       \\type real
  N90, \\field Vertex 30 Y-coordinate
       \\units m
       \\type real
  N91, \\field Vertex 30 Z-coordinate
       \\units m
       \\type real
  N92, \\field Vertex 31 X-coordinate
       \\units m
       \\type real
  N93, \\field Vertex 31 Y-coordinate
       \\units m
       \\type real
  N94, \\field Vertex 31 Z-coordinate
       \\units m
       \\type real
  N95, \\field Vertex 32 X-coordinate
       \\units m
       \\type real
  N96, \\field Vertex 32 Y-coordinate
       \\units m
       \\type real
  N97, \\field Vertex 32 Z-coordinate
       \\units m
       \\type real
  N98, \\field Vertex 33 X-coordinate
       \\units m
       \\type real
  N99, \\field Vertex 33 Y-coordinate
       \\units m
       \\type real
  N100, \\field Vertex 33 Z-coordinate
       \\units m
       \\type real
  N101, \\field Vertex 34 X-coordinate
       \\units m
       \\type real
  N102, \\field Vertex 34 Y-coordinate
       \\units m
       \\type real
  N103, \\field Vertex 34 Z-coordinate
       \\units m
       \\type real
  N104, \\field Vertex 35 X-coordinate
       \\units m
       \\type real
  N105, \\field Vertex 35 Y-coordinate
       \\units m
       \\type real
  N106, \\field Vertex 35 Z-coordinate
       \\units m
       \\type real
  N107, \\field Vertex 36 X-coordinate
       \\units m
       \\type real
  N108, \\field Vertex 36 Y-coordinate
       \\units m
       \\type real
  N109, \\field Vertex 36 Z-coordinate
       \\units m
       \\type real
  N110, \\field Vertex 37 X-coordinate
       \\units m
       \\type real
  N111, \\field Vertex 37 Y-coordinate
       \\units m
       \\type real
  N112, \\field Vertex 37 Z-coordinate
       \\units m
       \\type real
  N113, \\field Vertex 38 X-coordinate
       \\units m
       \\type real
  N114, \\field Vertex 38 Y-coordinate
       \\units m
       \\type real
  N115, \\field Vertex 38 Z-coordinate
       \\units m
       \\type real
  N116, \\field Vertex 39 X-coordinate
       \\units m
       \\type real
  N117, \\field Vertex 39 Y-coordinate
       \\units m
       \\type real
  N118, \\field Vertex 39 Z-coordinate
       \\units m
       \\type real
  N119, \\field Vertex 40 X-coordinate
       \\units m
       \\type real
  N120, \\field Vertex 40 Y-coordinate
       \\units m
       \\type real
  N121, \\field Vertex 40 Z-coordinate
       \\units m
       \\type real
  N122, \\field Vertex 41 X-coordinate
       \\units m
       \\type real
  N123, \\field Vertex 41 Y-coordinate
       \\units m
       \\type real
  N124, \\field Vertex 41 Z-coordinate
       \\units m
       \\type real
  N125, \\field Vertex 42 X-coordinate
       \\units m
       \\type real
  N126, \\field Vertex 42 Y-coordinate
       \\units m
       \\type real
  N127, \\field Vertex 42 Z-coordinate
       \\units m
       \\type real
  N128, \\field Vertex 43 X-coordinate
       \\units m
       \\type real
  N129, \\field Vertex 43 Y-coordinate
       \\units m
       \\type real
  N130, \\field Vertex 43 Z-coordinate
       \\units m
       \\type real
  N131, \\field Vertex 44 X-coordinate
       \\units m
       \\type real
  N132, \\field Vertex 44 Y-coordinate
       \\units m
       \\type real
  N133, \\field Vertex 44 Z-coordinate
       \\units m
       \\type real
  N134, \\field Vertex 45 X-coordinate
       \\units m
       \\type real
  N135, \\field Vertex 45 Y-coordinate
       \\units m
       \\type real
  N136, \\field Vertex 45 Z-coordinate
       \\units m
       \\type real
  N137, \\field Vertex 46 X-coordinate
       \\units m
       \\type real
  N138, \\field Vertex 46 Y-coordinate
       \\units m
       \\type real
  N139, \\field Vertex 46 Z-coordinate
       \\units m
       \\type real
  N140, \\field Vertex 47 X-coordinate
       \\units m
       \\type real
  N141, \\field Vertex 47 Y-coordinate
       \\units m
       \\type real
  N142, \\field Vertex 47 Z-coordinate
       \\units m
       \\type real
  N143, \\field Vertex 48 X-coordinate
       \\units m
       \\type real
  N144, \\field Vertex 48 Y-coordinate
       \\units m
       \\type real
  N145, \\field Vertex 48 Z-coordinate
       \\units m
       \\type real
  N146, \\field Vertex 49 X-coordinate
       \\units m
       \\type real
  N147, \\field Vertex 49 Y-coordinate
       \\units m
       \\type real
  N148, \\field Vertex 49 Z-coordinate
       \\units m
       \\type real
  N149, \\field Vertex 50 X-coordinate
       \\units m
       \\type real
  N150, \\field Vertex 50 Y-coordinate
       \\units m
       \\type real
  N151, \\field Vertex 50 Z-coordinate
       \\units m
       \\type real
  N152, \\field Vertex 51 X-coordinate
       \\units m
       \\type real
  N153, \\field Vertex 51 Y-coordinate
       \\units m
       \\type real
  N154, \\field Vertex 51 Z-coordinate
       \\units m
       \\type real
  N155, \\field Vertex 52 X-coordinate
       \\units m
       \\type real
  N156, \\field Vertex 52 Y-coordinate
       \\units m
       \\type real
  N157, \\field Vertex 52 Z-coordinate
       \\units m
       \\type real
  N158, \\field Vertex 53 X-coordinate
       \\units m
       \\type real
  N159, \\field Vertex 53 Y-coordinate
       \\units m
       \\type real
  N160, \\field Vertex 53 Z-coordinate
       \\units m
       \\type real
  N161, \\field Vertex 54 X-coordinate
       \\units m
       \\type real
  N162, \\field Vertex 54 Y-coordinate
       \\units m
       \\type real
  N163, \\field Vertex 54 Z-coordinate
       \\units m
       \\type real
  N164, \\field Vertex 55 X-coordinate
       \\units m
       \\type real
  N165, \\field Vertex 55 Y-coordinate
       \\units m
       \\type real
  N166, \\field Vertex 55 Z-coordinate
       \\units m
       \\type real
  N167, \\field Vertex 56 X-coordinate
       \\units m
       \\type real
  N168, \\field Vertex 56 Y-coordinate
       \\units m
       \\type real
  N169, \\field Vertex 56 Z-coordinate
       \\units m
       \\type real
  N170, \\field Vertex 57 X-coordinate
       \\units m
       \\type real
  N171, \\field Vertex 57 Y-coordinate
       \\units m
       \\type real
  N172, \\field Vertex 57 Z-coordinate
       \\units m
       \\type real
  N173, \\field Vertex 58 X-coordinate
       \\units m
       \\type real
  N174, \\field Vertex 58 Y-coordinate
       \\units m
       \\type real
  N175, \\field Vertex 58 Z-coordinate
       \\units m
       \\type real
  N176, \\field Vertex 59 X-coordinate
       \\units m
       \\type real
  N177, \\field Vertex 59 Y-coordinate
       \\units m
       \\type real
  N178, \\field Vertex 59 Z-coordinate
       \\units m
       \\type real
  N179, \\field Vertex 60 X-coordinate
       \\units m
       \\type real
  N180, \\field Vertex 60 Y-coordinate
       \\units m
       \\type real
  N181, \\field Vertex 60 Z-coordinate
       \\units m
       \\type real
  N182, \\field Vertex 61 X-coordinate
       \\units m
       \\type real
  N183, \\field Vertex 61 Y-coordinate
       \\units m
       \\type real
  N184, \\field Vertex 61 Z-coordinate
       \\units m
       \\type real
  N185, \\field Vertex 62 X-coordinate
       \\units m
       \\type real
  N186, \\field Vertex 62 Y-coordinate
       \\units m
       \\type real
  N187, \\field Vertex 62 Z-coordinate
       \\units m
       \\type real
  N188, \\field Vertex 63 X-coordinate
       \\units m
       \\type real
  N189, \\field Vertex 63 Y-coordinate
       \\units m
       \\type real
  N190, \\field Vertex 63 Z-coordinate
       \\units m
       \\type real
  N191, \\field Vertex 64 X-coordinate
       \\units m
       \\type real
  N192, \\field Vertex 64 Y-coordinate
       \\units m
       \\type real
  N193, \\field Vertex 64 Z-coordinate
       \\units m
       \\type real
  N194, \\field Vertex 65 X-coordinate
       \\units m
       \\type real
  N195, \\field Vertex 65 Y-coordinate
       \\units m
       \\type real
  N196, \\field Vertex 65 Z-coordinate
       \\units m
       \\type real
  N197, \\field Vertex 66 X-coordinate
       \\units m
       \\type real
  N198, \\field Vertex 66 Y-coordinate
       \\units m
       \\type real
  N199, \\field Vertex 66 Z-coordinate
       \\units m
       \\type real
  N200, \\field Vertex 67 X-coordinate
       \\units m
       \\type real
  N201, \\field Vertex 67 Y-coordinate
       \\units m
       \\type real
  N202, \\field Vertex 67 Z-coordinate
       \\units m
       \\type real
  N203, \\field Vertex 68 X-coordinate
       \\units m
       \\type real
  N204, \\field Vertex 68 Y-coordinate
       \\units m
       \\type real
  N205, \\field Vertex 68 Z-coordinate
       \\units m
       \\type real
  N206, \\field Vertex 69 X-coordinate
       \\units m
       \\type real
  N207, \\field Vertex 69 Y-coordinate
       \\units m
       \\type real
  N208, \\field Vertex 69 Z-coordinate
       \\units m
       \\type real
  N209, \\field Vertex 70 X-coordinate
       \\units m
       \\type real
  N210, \\field Vertex 70 Y-coordinate
       \\units m
       \\type real
  N211, \\field Vertex 70 Z-coordinate
       \\units m
       \\type real
  N212, \\field Vertex 71 X-coordinate
       \\units m
       \\type real
  N213, \\field Vertex 71 Y-coordinate
       \\units m
       \\type real
  N214, \\field Vertex 71 Z-coordinate
       \\units m
       \\type real
  N215, \\field Vertex 72 X-coordinate
       \\units m
       \\type real
  N216, \\field Vertex 72 Y-coordinate
       \\units m
       \\type real
  N217, \\field Vertex 72 Z-coordinate
       \\units m
       \\type real
  N218, \\field Vertex 73 X-coordinate
       \\units m
       \\type real
  N219, \\field Vertex 73 Y-coordinate
       \\units m
       \\type real
  N220, \\field Vertex 73 Z-coordinate
       \\units m
       \\type real
  N221, \\field Vertex 74 X-coordinate
       \\units m
       \\type real
  N222, \\field Vertex 74 Y-coordinate
       \\units m
       \\type real
  N223, \\field Vertex 74 Z-coordinate
       \\units m
       \\type real
  N224, \\field Vertex 75 X-coordinate
       \\units m
       \\type real
  N225, \\field Vertex 75 Y-coordinate
       \\units m
       \\type real
  N226, \\field Vertex 75 Z-coordinate
       \\units m
       \\type real
  N227, \\field Vertex 76 X-coordinate
       \\units m
       \\type real
  N228, \\field Vertex 76 Y-coordinate
       \\units m
       \\type real
  N229, \\field Vertex 76 Z-coordinate
       \\units m
       \\type real
  N230, \\field Vertex 77 X-coordinate
       \\units m
       \\type real
  N231, \\field Vertex 77 Y-coordinate
       \\units m
       \\type real
  N232, \\field Vertex 77 Z-coordinate
       \\units m
       \\type real
  N233, \\field Vertex 78 X-coordinate
       \\units m
       \\type real
  N234, \\field Vertex 78 Y-coordinate
       \\units m
       \\type real
  N235, \\field Vertex 78 Z-coordinate
       \\units m
       \\type real
  N236, \\field Vertex 79 X-coordinate
       \\units m
       \\type real
  N237, \\field Vertex 79 Y-coordinate
       \\units m
       \\type real
  N238, \\field Vertex 79 Z-coordinate
       \\units m
       \\type real
  N239, \\field Vertex 80 X-coordinate
       \\units m
       \\type real
  N240, \\field Vertex 80 Y-coordinate
       \\units m
       \\type real
  N241, \\field Vertex 80 Z-coordinate
       \\units m
       \\type real
  N242, \\field Vertex 81 X-coordinate
       \\units m
       \\type real
  N243, \\field Vertex 81 Y-coordinate
       \\units m
       \\type real
  N244, \\field Vertex 81 Z-coordinate
       \\units m
       \\type real
  N245, \\field Vertex 82 X-coordinate
       \\units m
       \\type real
  N246, \\field Vertex 82 Y-coordinate
       \\units m
       \\type real
  N247, \\field Vertex 82 Z-coordinate
       \\units m
       \\type real
  N248, \\field Vertex 83 X-coordinate
       \\units m
       \\type real
  N249, \\field Vertex 83 Y-coordinate
       \\units m
       \\type real
  N250, \\field Vertex 83 Z-coordinate
       \\units m
       \\type real
  N251, \\field Vertex 84 X-coordinate
       \\units m
       \\type real
  N252, \\field Vertex 84 Y-coordinate
       \\units m
       \\type real
  N253, \\field Vertex 84 Z-coordinate
       \\units m
       \\type real
  N254, \\field Vertex 85 X-coordinate
       \\units m
       \\type real
  N255, \\field Vertex 85 Y-coordinate
       \\units m
       \\type real
  N256, \\field Vertex 85 Z-coordinate
       \\units m
       \\type real
  N257, \\field Vertex 86 X-coordinate
       \\units m
       \\type real
  N258, \\field Vertex 86 Y-coordinate
       \\units m
       \\type real
  N259, \\field Vertex 86 Z-coordinate
       \\units m
       \\type real
  N260, \\field Vertex 87 X-coordinate
       \\units m
       \\type real
  N261, \\field Vertex 87 Y-coordinate
       \\units m
       \\type real
  N262, \\field Vertex 87 Z-coordinate
       \\units m
       \\type real
  N263, \\field Vertex 88 X-coordinate
       \\units m
       \\type real
  N264, \\field Vertex 88 Y-coordinate
       \\units m
       \\type real
  N265, \\field Vertex 88 Z-coordinate
       \\units m
       \\type real
  N266, \\field Vertex 89 X-coordinate
       \\units m
       \\type real
  N267, \\field Vertex 89 Y-coordinate
       \\units m
       \\type real
  N268, \\field Vertex 89 Z-coordinate
       \\units m
       \\type real
  N269, \\field Vertex 90 X-coordinate
       \\units m
       \\type real
  N270, \\field Vertex 90 Y-coordinate
       \\units m
       \\type real
  N271, \\field Vertex 90 Z-coordinate
       \\units m
       \\type real
  N272, \\field Vertex 91 X-coordinate
       \\units m
       \\type real
  N273, \\field Vertex 91 Y-coordinate
       \\units m
       \\type real
  N274, \\field Vertex 91 Z-coordinate
       \\units m
       \\type real
  N275, \\field Vertex 92 X-coordinate
       \\units m
       \\type real
  N276, \\field Vertex 92 Y-coordinate
       \\units m
       \\type real
  N277, \\field Vertex 92 Z-coordinate
       \\units m
       \\type real
  N278, \\field Vertex 93 X-coordinate
       \\units m
       \\type real
  N279, \\field Vertex 93 Y-coordinate
       \\units m
       \\type real
  N280, \\field Vertex 93 Z-coordinate
       \\units m
       \\type real
  N281, \\field Vertex 94 X-coordinate
       \\units m
       \\type real
  N282, \\field Vertex 94 Y-coordinate
       \\units m
       \\type real
  N283, \\field Vertex 94 Z-coordinate
       \\units m
       \\type real
  N284, \\field Vertex 95 X-coordinate
       \\units m
       \\type real
  N285, \\field Vertex 95 Y-coordinate
       \\units m
       \\type real
  N286, \\field Vertex 95 Z-coordinate
       \\units m
       \\type real
  N287, \\field Vertex 96 X-coordinate
       \\units m
       \\type real
  N288, \\field Vertex 96 Y-coordinate
       \\units m
       \\type real
  N289, \\field Vertex 96 Z-coordinate
       \\units m
       \\type real
  N290, \\field Vertex 97 X-coordinate
       \\units m
       \\type real
  N291, \\field Vertex 97 Y-coordinate
       \\units m
       \\type real
  N292, \\field Vertex 97 Z-coordinate
       \\units m
       \\type real
  N293, \\field Vertex 98 X-coordinate
       \\units m
       \\type real
  N294, \\field Vertex 98 Y-coordinate
       \\units m
       \\type real
  N295, \\field Vertex 98 Z-coordinate
       \\units m
       \\type real
  N296, \\field Vertex 99 X-coordinate
       \\units m
       \\type real
  N297, \\field Vertex 99 Y-coordinate
       \\units m
       \\type real
  N298, \\field Vertex 99 Z-coordinate
       \\units m
       \\type real
  N299, \\field Vertex 100 X-coordinate
       \\units m
       \\type real
  N300, \\field Vertex 100 Y-coordinate
       \\units m
       \\type real
  N301, \\field Vertex 100 Z-coordinate
       \\units m
       \\type real
  N302, \\field Vertex 101 X-coordinate
       \\units m
       \\type real
  N303, \\field Vertex 101 Y-coordinate
       \\units m
       \\type real
  N304, \\field Vertex 101 Z-coordinate
       \\units m
       \\type real
  N305, \\field Vertex 102 X-coordinate
       \\units m
       \\type real
  N306, \\field Vertex 102 Y-coordinate
       \\units m
       \\type real
  N307, \\field Vertex 102 Z-coordinate
       \\units m
       \\type real
  N308, \\field Vertex 103 X-coordinate
       \\units m
       \\type real
  N309, \\field Vertex 103 Y-coordinate
       \\units m
       \\type real
  N310, \\field Vertex 103 Z-coordinate
       \\units m
       \\type real
  N311, \\field Vertex 104 X-coordinate
       \\units m
       \\type real
  N312, \\field Vertex 104 Y-coordinate
       \\units m
       \\type real
  N313, \\field Vertex 104 Z-coordinate
       \\units m
       \\type real
  N314, \\field Vertex 105 X-coordinate
       \\units m
       \\type real
  N315, \\field Vertex 105 Y-coordinate
       \\units m
       \\type real
  N316, \\field Vertex 105 Z-coordinate
       \\units m
       \\type real
  N317, \\field Vertex 106 X-coordinate
       \\units m
       \\type real
  N318, \\field Vertex 106 Y-coordinate
       \\units m
       \\type real
  N319, \\field Vertex 106 Z-coordinate
       \\units m
       \\type real
  N320, \\field Vertex 107 X-coordinate
       \\units m
       \\type real
  N321, \\field Vertex 107 Y-coordinate
       \\units m
       \\type real
  N322, \\field Vertex 107 Z-coordinate
       \\units m
       \\type real
  N323, \\field Vertex 108 X-coordinate
       \\units m
       \\type real
  N324, \\field Vertex 108 Y-coordinate
       \\units m
       \\type real
  N325, \\field Vertex 108 Z-coordinate
       \\units m
       \\type real
  N326, \\field Vertex 109 X-coordinate
       \\units m
       \\type real
  N327, \\field Vertex 109 Y-coordinate
       \\units m
       \\type real
  N328, \\field Vertex 109 Z-coordinate
       \\units m
       \\type real
  N329, \\field Vertex 110 X-coordinate
       \\units m
       \\type real
  N330, \\field Vertex 110 Y-coordinate
       \\units m
       \\type real
  N331, \\field Vertex 110 Z-coordinate
       \\units m
       \\type real
  N332, \\field Vertex 111 X-coordinate
       \\units m
       \\type real
  N333, \\field Vertex 111 Y-coordinate
       \\units m
       \\type real
  N334, \\field Vertex 111 Z-coordinate
       \\units m
       \\type real
  N335, \\field Vertex 112 X-coordinate
       \\units m
       \\type real
  N336, \\field Vertex 112 Y-coordinate
       \\units m
       \\type real
  N337, \\field Vertex 112 Z-coordinate
       \\units m
       \\type real
  N338, \\field Vertex 113 X-coordinate
       \\units m
       \\type real
  N339, \\field Vertex 113 Y-coordinate
       \\units m
       \\type real
  N340, \\field Vertex 113 Z-coordinate
       \\units m
       \\type real
  N341, \\field Vertex 114 X-coordinate
       \\units m
       \\type real
  N342, \\field Vertex 114 Y-coordinate
       \\units m
       \\type real
  N343, \\field Vertex 114 Z-coordinate
       \\units m
       \\type real
  N344, \\field Vertex 115 X-coordinate
       \\units m
       \\type real
  N345, \\field Vertex 115 Y-coordinate
       \\units m
       \\type real
  N346, \\field Vertex 115 Z-coordinate
       \\units m
       \\type real
  N347, \\field Vertex 116 X-coordinate
       \\units m
       \\type real
  N348, \\field Vertex 116 Y-coordinate
       \\units m
       \\type real
  N349, \\field Vertex 116 Z-coordinate
       \\units m
       \\type real
  N350, \\field Vertex 117 X-coordinate
       \\units m
       \\type real
  N351, \\field Vertex 117 Y-coordinate
       \\units m
       \\type real
  N352, \\field Vertex 117 Z-coordinate
       \\units m
       \\type real
  N353, \\field Vertex 118 X-coordinate
       \\units m
       \\type real
  N354, \\field Vertex 118 Y-coordinate
       \\units m
       \\type real
  N355, \\field Vertex 118 Z-coordinate
       \\units m
       \\type real
  N356, \\field Vertex 119 X-coordinate
       \\units m
       \\type real
  N357, \\field Vertex 119 Y-coordinate
       \\units m
       \\type real
  N358, \\field Vertex 119 Z-coordinate
       \\units m
       \\type real
  N359, \\field Vertex 120 X-coordinate
       \\units m
       \\type real
  N360, \\field Vertex 120 Y-coordinate
       \\units m
       \\type real
  N361; \\field Vertex 120 Z-coordinate
       \\units m
       \\type real

ShadingProperty:Reflectance,
       \\min-fields 3
       \\memo If this object is not defined for a shading surface the default values
       \\memo listed in following fields will be used in the solar reflection calculation.
  A1,  \\field Shading Surface Name
       \\required-field
       \\type object-list
       \\object-list AllShadingSurfNames
  N1,  \\field Diffuse Solar Reflectance of Unglazed Part of Shading Surface
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.2
  N2,  \\field Diffuse Visible Reflectance of Unglazed Part of Shading Surface
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.2
  N3,  \\field Fraction of Shading Surface That Is Glazed
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  A2;  \\field Glazing Construction Name
       \\note Required if Fraction of Shading Surface That Is Glazed > 0.0

\\group Advanced Construction, Surface, Zone Concepts

SurfaceProperty:HeatTransferAlgorithm,
       \\memo Determines which Heat Balance Algorithm will be used for a specific surface
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 2
  A1 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A2 ; \\field Algorithm
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction

SurfaceProperty:HeatTransferAlgorithm:MultipleSurface,
       \\memo Determines which Heat Balance Algorithm will be used for a group of surface types
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 3
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Surface Type
       \\required-field
       \\type choice
       \\key AllExteriorSurfaces
       \\key AllExteriorWalls
       \\key AllExteriorRoofs
       \\key AllExteriorFloors
       \\key AllGroundContactSurfaces
       \\key AllInteriorSurfaces
       \\key AllInteriorWalls
       \\key AllInteriorCeilings
       \\key AllInteriorFloors
  A3 ; \\field Algorithm
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction

SurfaceProperty:HeatTransferAlgorithm:SurfaceList,
       \\min-fields 3
       \\extensible:1
       \\memo Determines which Heat Balance Algorithm will be used for a list of surfaces
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Algorithm
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  A3 , \\field Surface Name 1
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A4 , \\field Surface Name 2
       \\type object-list
       \\object-list SurfaceNames
  A5 , \\field Surface Name 3
       \\type object-list
       \\object-list SurfaceNames
  A6 , \\field Surface Name 4
       \\type object-list
       \\object-list SurfaceNames
  A7 , \\field Surface Name 5
       \\type object-list
       \\object-list SurfaceNames
  A8 ; \\field Surface Name 6
       \\type object-list
       \\object-list SurfaceNames

SurfaceProperty:HeatTransferAlgorithm:Construction,
       \\memo Determines which Heat Balance Algorithm will be used for surfaces that have a specific type of construction
       \\memo Allows selectively overriding the global setting in HeatBalanceAlgorithm
       \\memo CTF (Conduction Transfer Functions),
       \\memo EMPD (Effective Moisture Penetration Depth with Conduction Transfer Functions).
       \\memo Advanced/Research Usage: CondFD (Conduction Finite Difference)
       \\memo Advanced/Research Usage: HAMT (Combined Heat And Moisture Finite Element)
       \\min-fields 3
  A1 , \\field Name
       \\type alpha
  A2 , \\field Algorithm
       \\type choice
       \\key ConductionTransferFunction
       \\key MoisturePenetrationDepthConductionTransferFunction
       \\key ConductionFiniteDifference
       \\key CombinedHeatAndMoistureFiniteElement
       \\default ConductionTransferFunction
  A3 ; \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ConstructionNames

SurfaceProperty:HeatBalanceSourceTerm,
       \\memo Allows an additional heat source term to be added to the inside or outside surface boundary.
       \\memo A heat source can be added to either or both the inside and outside of the same surface.
       \\min-fields 3
  A1 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A2 , \\field Inside Face Heat Source Term Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note The value of this schedule is the source term value for the inside face of this surface
       \\note If this field is left blank, no inside surface source term will be applied.
       \\note The schedule values are heat rate per surface area (W/m2), when positive
       \\note schedule values indicate heat gain and negative values indicates loss.
  A3 ; \\field Outside Face Heat Source Term Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note The value of this schedule is the source term value for the outside face of this surface
       \\note If this field is left blank, no outside surface source term will be applied.
       \\note The schedule values are heat rate per surface area (W/m2), when positive
       \\note schedule values indicate heat gain and negative values indicates loss.

SurfaceControl:MovableInsulation,
      \\memo Exterior or Interior Insulation on opaque surfaces
  A1, \\field Insulation Type
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A2, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfaceNames
  A3, \\field Material Name
      \\required-field
      \\type object-list
      \\object-list MaterialName
  A4; \\field Schedule Name
      \\required-field
      \\type object-list
      \\object-list ScheduleNames

SurfaceProperty:OtherSideCoefficients,
      \\memo This object sets the other side conditions for a surface in a variety of ways.
      \\min-fields 8
  A1, \\field Name
      \\required-field
      \\reference OutFaceEnvNames
  N1, \\field Combined Convective/Radiative Film Coefficient
      \\units W/m2-K
      \\required-field
      \\type real
      \\note if>0, this field becomes the exterior convective/radiative film coefficient
      \\note and the other fields are used to calculate the outdoor air temperature
      \\note then exterior surface temperature based on outdoor air and specified coefficient
      \\note if<=0, then remaining fields calculate the outside surface temperature
      \\note The following fields are used in the equation:
      \\note OtherSideTemp=N2*N3 + N4*OutdoorDry-bulb + N5*GroundTemp + N6*WindSpeed*OutdoorDry-bulb + N7*TempZone + N9*TempPrev
  N2, \\field Constant Temperature
      \\units C
      \\type real
      \\default 0
      \\note This parameter will be overwritten by the values from the Constant Temperature Schedule Name (below) if one is present
  N3, \\field Constant Temperature Coefficient
      \\note This coefficient is used even with a Schedule. It should normally be 1.0 in that case.
      \\note This field is ignored if Sinusoidal Variation of Constant Temperature Coefficient = Yes.
      \\default 1
  N4, \\field External Dry-Bulb Temperature Coefficient
      \\type real
      \\default 0
  N5, \\field Ground Temperature Coefficient
      \\type real
      \\default 0
  N6, \\field Wind Speed Coefficient
      \\type real
      \\default 0
  N7, \\field Zone Air Temperature Coefficient
      \\type real
      \\default 0
  A2, \\field Constant Temperature Schedule Name
      \\note Name of schedule for values of constant temperature.
      \\note Schedule values replace any value specified in the field Constant Temperature.
      \\type object-list
      \\object-list ScheduleNames
  A3, \\field Sinusoidal Variation of Constant Temperature Coefficient
      \\note Optionally used to vary Constant Temperature Coefficient with unitary sine wave
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N8, \\field Period of Sinusoidal Variation
      \\note Use with sinusoidal variation to define the time period
      \\type real
      \\units hr
      \\default 24
      \\minimum> 0
  N9, \\field Previous Other Side Temperature Coefficient
      \\note This coefficient multiplies the other side temperature result from the
      \\note previous zone timestep
      \\type real
      \\default 0
 N10, \\field Minimum Other Side Temperature Limit
      \\note This field specifies a lower limit for the other side temperature result.
      \\note Blank indicates no limit
      \\type real
      \\units C
 N11; \\field Maximum Other Side Temperature Limit
      \\note This field specifies an upper limit for the other side temperature result.
      \\note Blank indicates no limit
      \\type real
      \\units C

SurfaceProperty:OtherSideConditionsModel,
      \\memo This object sets up modifying the other side conditions for a surface from other model results.
  A1, \\field Name
      \\required-field
      \\reference OSCMNames
      \\reference OutFaceEnvNames
  A2; \\field Type of Modeling
      \\type choice
      \\key GapConvectionRadiation
      \\key UndergroundPipingSystemSurface
      \\key GroundCoupledSurface
      \\key ConvectiveUnderwater
      \\note GapConvectionRadiation provides boundary conditions for convection
      \\note  and linearized thermal radiation across a gap or cavity
      \\note  on the other side of the surface that are modeled separately.
      \\note UndergroundPipingSystemSurface provides boundary conditions for
      \\note  surfaces in contact with PipingSystem:Underground domains
      \\note GroundCoupledSurface provides boundary conditions for surfaces
      \\note  in contact with GroundDomain objects
      \\note ConvectiveUnderwater provides a connection between a surface and
      \\note  an underwater boundary condition defined using a
      \\note  SurfaceProperty:Underwater object
      \\default GapConvectionRadiation

SurfaceProperty:Underwater,
       \\memo This object sets up a convective water boundary condition for a surface
       \\memo The free stream temperature and velocity are scheduled. If the free stream
       \\memo velocity is zero, the surface will naturally convect with the surrounding water.
       \\min-fields 3
  A1,  \\field Name
       \\required-field
       \\reference SurfacePropUnderWaterNames
       \\type alpha
  N1,  \\field Distance from Surface Centroid to Leading Edge of Boundary Layer
       \\note This is the distance from the leading edge of the boundary layer development
       \\note to the centroid of the surface of interest. The value of this field is used
       \\note as the distance in the Reynolds number for evaluating the local convection coefficient.
       \\type real
       \\units m
       \\required-field
  A2,  \\field Free Stream Water Temperature Schedule
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\units C
  A3;  \\field Free Stream Water Velocity Schedule
       \\type object-list
       \\object-list ScheduleNames
       \\units m/s

Foundation:Kiva,
       \\memo Refined definition of the foundation surface construction used to
       \\memo inform two-dimensional heat transfer calculated using the Kiva
       \\memo ground heat transfer methodology.
       \\extensible:4
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference OutFaceEnvNames
  N1,  \\field Initial Indoor Air Temperature
       \\note Indoor air temperature used for Kiva initialization (prior to warmup period)
       \\note If left blank, indoor air temperature will be determined based on zone setpoints
       \\units C
       \\type real
  A2,  \\field Interior Horizontal Insulation Material Name
       \\type object-list
       \\object-list MaterialName
  N2,  \\field Interior Horizontal Insulation Depth
       \\note Distance from the slab bottom to the top of interior horizontal
       \\note insulation
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.0
  N3,  \\field Interior Horizontal Insulation Width
       \\note Extent of insulation as measured from the wall interior
       \\units m
       \\type real
       \\minimum> 0.0
  A3,  \\field Interior Vertical Insulation Material Name
       \\type object-list
       \\object-list MaterialName
  N4,  \\field Interior Vertical Insulation Depth
       \\note Extent of insulation as measured from the wall top to the bottom
       \\note edge of the interior vertical insulation
       \\units m
       \\type real
       \\minimum> 0.0
  A4,  \\field Exterior Horizontal Insulation Material Name
       \\type object-list
       \\object-list MaterialName
  N5,  \\field Exterior Horizontal Insulation Depth
       \\note Distance from the exterior grade to the top of exterior horizontal
       \\note insulation
       \\units m
       \\type real
       \\minimum 0.0
  N6,  \\field Exterior Horizontal Insulation Width
       \\note Extent of insulation as measured from the wall exterior
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.0
  A5,  \\field Exterior Vertical Insulation Material Name
       \\type object-list
       \\object-list MaterialName
  N7,  \\field Exterior Vertical Insulation Depth
       \\note Extent of insulation as measured from the wall top to the bottom
       \\note edge of the exterior vertical insulation
       \\units m
       \\type real
       \\minimum> 0.0
  N8,  \\field Wall Height Above Grade
       \\note Distance from the exterior grade to the wall top
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.2
  N9,  \\field Wall Depth Below Slab
       \\note Distance from the slab bottom to the bottom of the foundation wall
       \\units m
       \\type real
       \\minimum 0.0
       \\default 0.0
  A6,  \\field Footing Wall Construction Name
       \\note Defines the below-grade surface construction for slabs. Required
       \\note if foundation wall is not exposed to the zone.
       \\type object-list
       \\object-list ConstructionNames
  A7,  \\field Footing Material Name
       \\type object-list
       \\object-list MaterialName
  N10,  \\field Footing Depth
       \\note Top-to-bottom dimension of the footing (not to be confused with its
       \\note depth in the ground). The width of the footing is defined by the
       \\note material's thickness.
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 0.3
  A8,  \\field Custom Block 1 Material Name
       \\begin-extensible
       \\type object-list
       \\object-list MaterialName
  N11, \\field Custom Block 1 Depth
       \\note Top-to-bottom dimension of the block downward.
       \\units m
       \\type real
       \\minimum> 0.0
  N12, \\field Custom Block 1 X Position
       \\note Position outward (+) or inward (-) relative to the foundation wall
       \\note interior
       \\units m
       \\type real
  N13, \\field Custom Block 1 Z Position
       \\note Position downward (+) relative to the foundation wall top
       \\units m
       \\type real
  A9,  \\field Custom Block 2 Material Name
       \\type object-list
       \\object-list MaterialName
  N14, \\field Custom Block 2 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N15, \\field Custom Block 2 X Position
       \\units m
       \\type real
  N16, \\field Custom Block 2 Z Position
       \\units m
       \\type real
  A10, \\field Custom Block 3 Material Name
       \\type object-list
       \\object-list MaterialName
  N17, \\field Custom Block 3 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N18, \\field Custom Block 3 X Position
       \\units m
       \\type real
  N19, \\field Custom Block 3 Z Position
       \\units m
       \\type real
  A11, \\field Custom Block 4 Material Name
       \\type object-list
       \\object-list MaterialName
  N20, \\field Custom Block 4 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N21, \\field Custom Block 4 X Position
       \\units m
       \\type real
  N22, \\field Custom Block 4 Z Position
       \\units m
       \\type real
  A12, \\field Custom Block 5 Material Name
       \\type object-list
       \\object-list MaterialName
  N23, \\field Custom Block 5 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N24, \\field Custom Block 5 X Position
       \\units m
       \\type real
  N25, \\field Custom Block 5 Z Position
       \\units m
       \\type real
  A13, \\field Custom Block 6 Material Name
       \\type object-list
       \\object-list MaterialName
  N26, \\field Custom Block 6 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N27, \\field Custom Block 6 X Position
       \\units m
       \\type real
  N28, \\field Custom Block 6 Z Position
       \\units m
       \\type real
  A14, \\field Custom Block 7 Material Name
       \\type object-list
       \\object-list MaterialName
  N29, \\field Custom Block 7 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N30, \\field Custom Block 7 X Position
       \\units m
       \\type real
  N31, \\field Custom Block 7 Z Position
       \\units m
       \\type real
  A15, \\field Custom Block 8 Material Name
       \\type object-list
       \\object-list MaterialName
  N32, \\field Custom Block 8 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N33, \\field Custom Block 8 X Position
       \\units m
       \\type real
  N34, \\field Custom Block 8 Z Position
       \\units m
       \\type real
  A16, \\field Custom Block 9 Material Name
       \\type object-list
       \\object-list MaterialName
  N35, \\field Custom Block 9 Depth
       \\units m
       \\type real
       \\minimum> 0.0
  N36, \\field Custom Block 9 X Position
       \\units m
       \\type real
  N37, \\field Custom Block 9 Z Position
       \\units m
       \\type real
  A17, \\field Custom Block 10 Material Name
       \\type object-list
       \\object-list MaterialName
  N38, \\field Custom Block 10 Depth
       \\units m
       \\type real
  N39, \\field Custom Block 10 X Position
       \\units m
       \\type real
       \\minimum> 0.0
  N40; \\field Custom Block 10 Z Position
       \\units m
       \\type real

Foundation:Kiva:Settings,
       \\memo Settings applied across all Kiva foundation calculations.
       \\memo Object is not required. If not defined, defaults will be applied.
  N1,  \\field Soil Conductivity
       \\type real
       \\default 1.73
       \\units W/m-K
       \\minimum> 0.0
  N2,  \\field Soil Density
       \\type real
       \\default 1842
       \\units kg/m3
       \\minimum> 0.0
  N3,  \\field Soil Specific Heat
       \\type real
       \\default 419
       \\units J/kg-K
       \\minimum> 0.0
  N4,  \\field Ground Solar Absorptivity
       \\type real
       \\default 0.9
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N5,  \\field Ground Thermal Absorptivity
       \\type real
       \\default 0.9
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
  N6,  \\field Ground Surface Roughness
       \\type real
       \\default 0.03
       \\units m
       \\minimum> 0.0
  N7,  \\field Far-Field Width
       \\type real
       \\default 40
       \\units m
       \\minimum> 0.0
  A1,  \\field Deep-Ground Boundary Condition
       \\type choice
       \\key ZeroFlux
       \\key GroundWater
       \\key Autoselect
       \\default Autoselect
  N8,  \\field Deep-Ground Depth
       \\type real
       \\units m
       \\minimum> 0.0
       \\autocalculatable
       \\default autocalculate
  N9,  \\field Minimum Cell Dimension
       \\type real
       \\default 0.02
       \\units m
       \\minimum> 0.0
  N10, \\field Maximum Cell Growth Coefficient
       \\type real
       \\default 1.5
       \\units dimensionless
       \\minimum 1.0
  A2;  \\field Simulation Timestep
       \\type choice
       \\key Hourly
       \\key Timestep
       \\default Hourly

SurfaceProperty:ExposedFoundationPerimeter,
       \\memo Defines the perimeter of a foundation floor that is exposed to the
       \\memo exterior environment through the floor. User may either define the
       \\memo total exposed perimeter, fraction of perimeter exposed or
       \\memo individually define which segments of the floor surface perimeter
       \\memo are exposed.
       \\extensible:1
  A1 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list FloorSurfaceNames
  A2 , \\field Exposed Perimeter Calculation Method
       \\note Choices: TotalExposedPerimeter => total exposed perimeter in meters
       \\note ExposedPerimeterFraction => fraction of total perimeter that is
       \\note exposed. Value * Fraction = Total exposed perimeter
       \\note BySegment => define whether the segment between each set of
       \\note consecutive vertices of the floor surface is exposed.
       \\note SUM(exposed segement lengths) = Total exposed perimeter
       \\required-field
       \\type choice
       \\key TotalExposedPerimeter
       \\key ExposedPerimeterFraction
       \\key BySegment
  N1 , \\field Total Exposed Perimeter
       \\type real
       \\units m
       \\minimum 0.0
  N2 , \\field Exposed Perimeter Fraction
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A3 , \\field Surface Segment 1 Exposed
       \\note Surface Segment N is the perimeter between the Nth and (N+1)th
       \\note vertices
       \\begin-extensible
       \\type choice
       \\default Yes
       \\key Yes
       \\key No
  A4 , \\field Surface Segment 2 Exposed
       \\type choice
       \\key Yes
       \\key No
  A5 , \\field Surface Segment 3 Exposed
       \\type choice
       \\key Yes
       \\key No
  A6 , \\field Surface Segment 4 Exposed
       \\type choice
       \\key Yes
       \\key No
  A7 , \\field Surface Segment 5 Exposed
       \\type choice
       \\key Yes
       \\key No
  A8 , \\field Surface Segment 6 Exposed
       \\type choice
       \\key Yes
       \\key No
  A9 , \\field Surface Segment 7 Exposed
       \\type choice
       \\key Yes
       \\key No
  A10, \\field Surface Segment 8 Exposed
       \\type choice
       \\key Yes
       \\key No
  A11, \\field Surface Segment 9 Exposed
       \\type choice
       \\key Yes
       \\key No
  A12; \\field Surface Segment 10 Exposed
       \\type choice
       \\key Yes
       \\key No

SurfaceConvectionAlgorithm:Inside:AdaptiveModelSelections,
       \\unique-object
       \\memo Options to change the individual convection model equations for dynamic selection when using AdaptiveConvectiongAlgorithm
       \\memo This object is only needed to make changes to the default model selections for any or all of the surface categories.
       \\memo This object is for the inside face, the side of the surface facing a thermal zone.
       \\min-fields 91
  A1 , \\field Name
       \\type alpha
  A2 , \\field Simple Buoyancy Vertical Wall Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for vertical walls
       \\type choice
       \\default FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A3 , \\field Simple Buoyancy Vertical Wall User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A4 , \\field Simple Buoyancy Stable Horizontal Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A5 , \\field Simple Buoyancy Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A6 , \\field Simple Buoyancy Unstable Horizontal Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
        \\note This is for passive horizontal surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default AlamdariHammondUnstableHorizontal
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A7 , \\field Simple Buoyancy Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A8 , \\field Simple Buoyancy Stable Tilted Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A9 , \\field Simple Buoyancy Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A10 , \\field Simple Buoyancy Unstable Tilted Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A11, \\field Simple Buoyancy Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A12, \\field Simple Buoyancy Windows Equation Source
       \\note Applies to zone with no HVAC or when HVAC is off
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key KaradagChilledCeiling
       \\key ISO15099Windows
       \\key UserCurve
  A13, \\field Simple Buoyancy Windows Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A14, \\field Floor Heat Ceiling Cool Vertical Wall Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for vertical walls
       \\type choice
       \\default KhalifaEq3WallAwayFromHeat
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A15, \\field Floor Heat Ceiling Cool Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A16, \\field Floor Heat Ceiling Cool Stable Horizontal Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for passive horizontal surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A17, \\field Floor Heat Ceiling Cool Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A18, \\field Floor Heat Ceiling Cool Unstable Horizontal Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for passive horizontal surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default KhalifaEq4CeilingAwayFromHeat
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key UserCurve
  A19, \\field Floor Heat Ceiling Cool Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A20, \\field Floor Heat Ceiling Cool Heated Floor Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for a floor with active heating elements
       \\type choice
       \\default AwbiHattonHeatedFloor
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key AwbiHattonHeatedFloor
       \\key UserCurve
  A21, \\field Floor Heat Ceiling Cool Heated Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A22, \\field Floor Heat Ceiling Cool Chilled Ceiling Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for a ceiling with active cooling elements
       \\type choice
       \\default KaradagChilledCeiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KaradagChilledCeiling
       \\key UserCurve
  A23, \\field Floor Heat Ceiling Cool Chilled Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A24, \\field Floor Heat Ceiling Cool Stable Tilted Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A25, \\field Floor Heat Ceiling Cool Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A26, \\field Floor Heat Ceiling Cool Unstable Tilted Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A27, \\field Floor Heat Ceiling Cool Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A28, \\field Floor Heat Ceiling Cool Window Equation Source
       \\note Applies to zone with in-floor heating and/or in-ceiling cooling
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A29, \\field Floor Heat Ceiling Cool Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A30, \\field Wall Panel Heating Vertical Wall Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for vertical walls that are not actively heated
       \\type choice
       \\default KhalifaEq6NonHeatedWalls
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A31, \\field Wall Panel Heating Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A32, \\field Wall Panel Heating Heated Wall Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for vertical walls that are being actively heated
       \\type choice
       \\default AwbiHattonHeatedWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq5WallNearHeat
       \\key AwbiHattonHeatedWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A33, \\field Wall Panel Heating Heated Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A34, \\field Wall Panel Heating Stable Horizontal Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A35, \\field Wall Panel Heating Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A36, \\field Wall Panel Heating Unstable Horizontal Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for horizontal surfaces with heat flow directed for unstable thermal stratification
       \\type choice
       \\default KhalifaEq7Ceiling
       \\key ASHRAEVerticalWall
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq7Ceiling
       \\key KaradagChilledCeiling
       \\key UserCurve
  A37, \\field Wall Panel Heating Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A38, \\field Wall Panel Heating Stable Tilted Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A39, \\field Wall Panel Heating Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A40, \\field Wall Panel Heating Unstable Tilted Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key ISO15099Windows
       \\key UserCurve
  A41, \\field Wall Panel Heating Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A42, \\field Wall Panel Heating Window Equation Source
       \\note Applies to zone with in-wall panel heating
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A43, \\field Wall Panel Heating Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A44, \\field Convective Zone Heater Vertical Wall Equation Source
       \\note Applies to zone with convective heater
       \\note This is for vertical walls not directly affected by heater
       \\type choice
       \\default FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq6NonHeatedWalls
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A45, \\field Convective Zone Heater Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A46, \\field Convective Zone Heater Vertical Walls Near Heater Equation Source
       \\note Applies to zone with convective heater
       \\note This is for vertical walls that are directly affected by heater
       \\note Walls are considered "near" when listed in field set for Fraction of Radiant Energy to Surface
       \\type choice
       \\default KhalifaEq5WallNearHeat
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq5WallNearHeat
       \\key AwbiHattonHeatedWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A47, \\field Convective Zone Heater Vertical Walls Near Heater Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A48, \\field Convective Zone Heater Stable Horizontal Equation Source
       \\note Applies to zone with convective heater
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A49, \\field Convective Zone Heater Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A50, \\field Convective Zone Heater Unstable Horizontal Equation Source
       \\note Applies to zone with convective heater
       \\note This is for horizontal surfaces with heat flow directed for unstable thermal stratification
       \\type choice
       \\default KhalifaEq7Ceiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key KhalifaEq7Ceiling
       \\key UserCurve
  A51, \\field Convective Zone Heater Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A52, \\field Convective Zone Heater Stable Tilted Equation Source
       \\note Applies to zone with convective heater
       \\note This is for tilted surfaces with heat flow for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A53, \\field Convective Zone Heater Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A54, \\field Convective Zone Heater Unstable Tilted Equation Source
       \\note Applies to zone with convective heater
       \\note This is for tilted surfaces with heat flow for unstable thermal stratification
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A55, \\field Convective Zone Heater Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A56, \\field Convective Zone Heater Windows Equation Source
       \\note Applies to zone with convective heater
       \\note This is for all window surfaces
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key KhalifaEq3WallAwayFromHeat
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
  A57, \\field Convective Zone Heater Windows Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A58, \\field Central Air Diffuser Wall Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all wall surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWalls
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key AlamdariHammondVerticalWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A59, \\field Central Air Diffuser Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A60, \\field Central Air Diffuser Ceiling Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all ceiling surfaces
       \\type choice
       \\default FisherPedersenCeilingDiffuserCeiling
       \\key FisherPedersenCeilingDiffuserCeiling
       \\key BeausoleilMorrisonMixedStableCeiling
       \\key BeausoleilMorrisonMixedUnstableCeiling
       \\key UserCurve
  A61, \\field Central Air Diffuser Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A62, \\field Central Air Diffuser Floor Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all floor surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserFloor
       \\key FisherPedersenCeilingDiffuserFloor
       \\key BeausoleilMorrisonMixedStableFloor
       \\key BeausoleilMorrisonMixedUnstableFloor
       \\key GoldsteinNovoselacCeilingDiffuserFloor
       \\key UserCurve
  A63, \\field Central Air Diffuser Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A64, \\field Central Air Diffuser Window Equation Source
       \\note Applies to zone with mechanical forced central air with diffusers
       \\note This is for all window surfaces
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWindow
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key UserCurve
  A65, \\field Central Air Diffuser Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A66, \\field Mechanical Zone Fan Circulation Vertical Wall Equation Source
       \\note reference choice fields
       \\type choice
       \\default KhalifaEq3WallAwayFromHeat
       \\key KhalifaEq3WallAwayFromHeat
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key AlamdariHammondVerticalWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A67, \\field Mechanical Zone Fan Circulation Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A68, \\field Mechanical Zone Fan Circulation Stable Horizontal Equation Source
       \\note reference choice fields
       \\type choice
       \\default AlamdariHammondStableHorizontal
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A69, \\field Mechanical Zone Fan Circulation Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A70, \\field Mechanical Zone Fan Circulation Unstable Horizontal Equation Source
       \\note reference choice fields
       \\type choice
       \\default KhalifaEq4CeilingAwayFromHeat
       \\key KhalifaEq4CeilingAwayFromHeat
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A71, \\field Mechanical Zone Fan Circulation Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A72, \\field Mechanical Zone Fan Circulation Stable Tilted Equation Source
       \\note reference choice fields
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key UserCurve
  A73, \\field Mechanical Zone Fan Circulation Stable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A74, \\field Mechanical Zone Fan Circulation Unstable Tilted Equation Source
       \\note reference choice fields
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A75, \\field Mechanical Zone Fan Circulation Unstable Tilted Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A76, \\field Mechanical Zone Fan Circulation Window Equation Source
       \\note reference choice fields
       \\type choice
       \\default ISO15099Windows
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key UserCurve
  A77, \\field Mechanical Zone Fan Circulation Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A78, \\field Mixed Regime Buoyancy Assisting Flow on Walls Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedAssistedWall
       \\key BeausoleilMorrisonMixedAssistedWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A79, \\field Mixed Regime Buoyancy Assisting Flow on Walls Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A80, \\field Mixed Regime Buoyancy Opposing Flow on Walls Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedOpposingWall
       \\key BeausoleilMorrisonMixedOpposingWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ASHRAEVerticalWall
       \\key FisherPedersenCeilingDiffuserWalls
       \\key GoldsteinNovoselacCeilingDiffuserWalls
       \\key UserCurve
  A81, \\field Mixed Regime Buoyancy Opposing Flow on Walls Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A82, \\field Mixed Regime Stable Floor Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedStableFloor
       \\key BeausoleilMorrisonMixedStableFloor
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A83, \\field Mixed Regime Stable Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A84, \\field Mixed Regime Unstable Floor Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedUnstableFloor
       \\key BeausoleilMorrisonMixedUnstableFloor
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A85, \\field Mixed Regime Unstable Floor Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A86, \\field Mixed Regime Stable Ceiling Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedStableCeiling
       \\key BeausoleilMorrisonMixedStableCeiling
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
  A87, \\field Mixed Regime Stable Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A88, \\field Mixed Regime Unstable Ceiling Equation Source
       \\note reference choice fields
       \\type choice
       \\default BeausoleilMorrisonMixedUnstableCeiling
       \\key BeausoleilMorrisonMixedUnstableCeiling
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
  A89, \\field Mixed Regime Unstable Ceiling Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels
  A90, \\field Mixed Regime Window Equation Source
       \\note reference choice fields
       \\type choice
       \\default GoldsteinNovoselacCeilingDiffuserWindow
       \\key GoldsteinNovoselacCeilingDiffuserWindow
       \\key ISO15099Windows
       \\key UserCurve
  A91; \\field Mixed Regime Window Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Inside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionInsideModels

SurfaceConvectionAlgorithm:Outside:AdaptiveModelSelections,
       \\unique-object
       \\memo Options to change the individual convection model equations for dynamic selection when using AdaptiveConvectiongAlgorithm
       \\memo This object is only needed to make changes to the default model selections for any or all of the surface categories.
       \\memo This object is for the outside face, the side of the surface facing away from the thermal zone.
       \\min-fields 13
  A1 , \\field Name
       \\type alpha
  A2 , \\field Wind Convection Windward Vertical Wall Equation Source
       \\type choice
       \\default TARPWindward
       \\key SimpleCombined
       \\key TARPWindward
       \\key MoWiTTWindward
       \\key DOE2Windward
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key BlockenWindward
       \\key EmmelVertical
       \\key UserCurve
  A3 , \\field Wind Convection Windward Equation Vertical Wall User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A4 , \\field Wind Convection Leeward Vertical Wall Equation Source
       \\type choice
       \\default TARPLeeward
       \\key SimpleCombined
       \\key TARPLeeward
       \\key MoWiTTLeeward
       \\key DOE2Leeward
       \\key EmmelVertical
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key UserCurve
  A5 , \\field Wind Convection Leeward Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A6 , \\field Wind Convection Horizontal Roof Equation Source
       \\type choice
       \\default ClearRoof
       \\key SimpleCombined
       \\key TARPWindward
       \\key MoWiTTWindward
       \\key DOE2Windward
       \\key NusseltJurges
       \\key McAdams
       \\key Mitchell
       \\key BlockenWindward
       \\key EmmelRoof
       \\key ClearRoof
       \\key UserCurve
  A7 , \\field Wind Convection Horizontal Roof User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A8 , \\field Natural Convection Vertical Wall Equation Source
       \\note This is for vertical walls
       \\type choice
       \\default ASHRAEVerticalWall
       \\key ASHRAEVerticalWall
       \\key AlamdariHammondVerticalWall
       \\key FohannoPolidoriVerticalWall
       \\key ISO15099Windows
       \\key UserCurve
       \\key None
  A9 , \\field Natural Convection Vertical Wall Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A10, \\field Natural Convection Stable Horizontal Equation Source
       \\note This is for horizontal surfaces with heat flow directed for stable thermal stratification
       \\type choice
       \\default WaltonStableHorizontalOrTilt
       \\key WaltonStableHorizontalOrTilt
       \\key AlamdariHammondStableHorizontal
       \\key UserCurve
       \\key None
  A11, \\field Natural Convection Stable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels
  A12, \\field Natural Convection Unstable Horizontal Equation Source
       \\type choice
       \\default WaltonUnstableHorizontalOrTilt
       \\key WaltonUnstableHorizontalOrTilt
       \\key AlamdariHammondUnstableHorizontal
       \\key UserCurve
       \\key None
  A13; \\field Natural Convection Unstable Horizontal Equation User Curve Name
       \\note The SurfaceConvectionAlgorithm:Outside:UserCurve named in this field is used when the previous field is set to UserCurve
       \\type object-list
       \\object-list UserConvectionOutsideModels

SurfaceConvectionAlgorithm:Inside:UserCurve,
       \\memo Used to describe a custom model equation for surface convection heat transfer coefficient
       \\memo If more than one curve is referenced they are all used and added together.
  A1 , \\field Name
       \\reference UserConvectionInsideModels
       \\reference UserConvectionModels
  A2 , \\field Reference Temperature for Convection Heat Transfer
       \\note Controls which temperature is differenced from surface temperature when using the Hc value
       \\type choice
       \\key MeanAirTemperature
       \\key AdjacentAirTemperature
       \\key SupplyAirTemperature
  A3 , \\field Hc Function of Temperature Difference Curve Name
       \\note  Curve's "x" is absolute value of delta-T (Surface temperature minus reference temperature, (C))
       \\type object-list
       \\object-list UnivariateFunctions
  A4 , \\field Hc Function of Temperature Difference Divided by Height Curve Name
       \\note Curve's "x" is absolute value of delta-T/Height (Surface temp minus Air temp)/(vertical length scale), (C/m)
       \\note when used for an inside face the vertical length scale is the zone's interior height
       \\type object-list
       \\object-list UnivariateFunctions
  A5 , \\field Hc Function of Air Change Rate Curve Name
       \\note Curve's "x" is mechanical ACH (Air Changes per hour from mechanical air system), (1/hr)
       \\type object-list
       \\object-list UnivariateFunctions
  A6 ; \\field Hc Function of Air System Volume Flow Rate Divided by Zone Perimeter Length Curve Name
       \\note Curve's "x" is mechanical system air flow rate (m3/s) divided by zone's length along
       \\note exterior walls (m).
       \\type object-list
       \\object-list UnivariateFunctions

SurfaceConvectionAlgorithm:Outside:UserCurve,
       \\memo Used to describe a custom model equation for surface convection heat transfer coefficient
       \\memo If more than one curve is referenced they are all used and added together.
  A1 , \\field Name
       \\reference UserConvectionOutsideModels
       \\reference UserConvectionModels
  A2 , \\field Wind Speed Type for Curve
       \\type choice
       \\key WeatherFile
       \\key HeightAdjust
       \\key ParallelComponent
       \\key ParallelComponentHeightAdjust
       \\default HeightAdjust
  A3 , \\field Hf Function of Wind Speed Curve Name
       \\note Curve's "x" is wind speed of the type determined in the previous field (m/s)
       \\type object-list
       \\object-list UnivariateFunctions
  A4 , \\field Hn Function of Temperature Difference Curve Name
       \\note  Curve's "x" is absolute value of delta-T (Surface temperature minus air temperature, (C))
       \\type object-list
       \\object-list UnivariateFunctions
  A5 ; \\field Hn Function of Temperature Difference Divided by Height Curve Name
       \\note Curve's "x" is absolute value of delta-T/Height (Surface temp minus Air temp)/(vertical length scale), (C/m)
       \\note when used for an outside face the vertical length scale is the exterior facade's overall height
       \\type object-list
       \\object-list UnivariateFunctions

SurfaceProperty:ConvectionCoefficients,
      \\memo Allow user settable interior and/or exterior convection coefficients.
      \\memo Note that some other factors may limit the lower bounds for these values, such as
      \\memo for windows, the interior convection coefficient must be >.28,
      \\memo for trombe wall algorithm selection (zone), the interior convection coefficient must be >.1
      \\memo for TARP interior convection, the lower limit is also .1
      \\memo Minimum and maximum limits are set in HeatBalanceAlgorithm object.
      \\memo Defaults in HeatBalanceAlgorithm object are [.1,1000].
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list AllHeatTranSurfNames
  A2, \\field Convection Coefficient 1 Location
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A3, \\field Convection Coefficient 1 Type
      \\required-field
      \\type choice
      \\key Value
      \\key Schedule
      \\key UserCurve
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key ASTMC1340
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
  N1, \\field Convection Coefficient 1
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\units W/m2-K
  A4, \\field Convection Coefficient 1 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Convection Coefficient 1 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels
  A6, \\field Convection Coefficient 2 Location
      \\type choice
      \\key Outside
      \\key Inside
  A7, \\field Convection Coefficient 2 Type
      \\type choice
      \\key Value
      \\key Schedule
      \\key UserCurve
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key ASTMC1340
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
  N2, \\field Convection Coefficient 2
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\default .1
      \\units W/m2-K
  A8, \\field Convection Coefficient 2 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A9; \\field Convection Coefficient 2 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels

SurfaceProperty:ConvectionCoefficients:MultipleSurface,
      \\memo Allow user settable interior and/or exterior convection coefficients.
      \\memo Note that some other factors may limit the lower bounds for these values, such as
      \\memo for windows, the interior convection coefficient must be >.28,
      \\memo for trombe wall algorithm selection (zone), the interior convection coefficient must be >.1
      \\memo for TARP interior convection, the lower limit is also .1
      \\memo Minimum and maximum limits are set in HeatBalanceAlgorithm object.
      \\memo Defaults in HeatBalanceAlgorithm object are [.1,1000].
  A1, \\field Surface Type
      \\required-field
      \\type choice
      \\key AllExteriorSurfaces
      \\key AllExteriorWindows
      \\key AllExteriorWalls
      \\key AllExteriorRoofs
      \\key AllExteriorFloors
      \\key AllInteriorSurfaces
      \\key AllInteriorWalls
      \\key AllInteriorWindows
      \\key AllInteriorCeilings
      \\key AllInteriorFloors
  A2, \\field Convection Coefficient 1 Location
      \\required-field
      \\type choice
      \\key Outside
      \\key Inside
  A3, \\field Convection Coefficient 1 Type
      \\required-field
      \\type choice
      \\key Value
      \\key Schedule
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key ASTMC1340
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key BlockenWindard
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
      \\key UserCurve
  N1, \\field Convection Coefficient 1
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\units W/m2-K
  A4, \\field Convection Coefficient 1 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A5, \\field Convection Coefficient 1 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels
  A6, \\field Convection Coefficient 2 Location
      \\type choice
      \\key Outside
      \\key Inside
  A7, \\field Convection Coefficient 2 Type
      \\type choice
      \\key Value
      \\key Schedule
      \\key Simple
      \\key SimpleCombined
      \\key TARP
      \\key DOE-2
      \\key MoWitt
      \\key AdaptiveConvectionAlgorithm
      \\key ASHRAEVerticalWall
      \\key ASTMC1340
      \\key WaltonUnstableHorizontalOrTilt
      \\key WaltonStableHorizontalOrTilt
      \\key FisherPedersenCeilingDiffuserWalls
      \\key FisherPedersenCeilingDiffuserCeiling
      \\key FisherPedersenCeilingDiffuserFloor
      \\key AlamdariHammondStableHorizontal
      \\key AlamdariHammondUnstableHorizontal
      \\key AlamdariHammondVerticalWall
      \\key KhalifaEq3WallAwayFromHeat
      \\key KhalifaEq4CeilingAwayFromHeat
      \\key KhalifaEq5WallNearHeat
      \\key KhalifaEq6NonHeatedWalls
      \\key KhalifaEq7Ceiling
      \\key AwbiHattonHeatedFloor
      \\key AwbiHattonHeatedWall
      \\key BeausoleilMorrisonMixedAssistedWall
      \\key BeausoleilMorrisonMixedOpposingWall
      \\key BeausoleilMorrisonMixedStableFloor
      \\key BeausoleilMorrisonMixedUnstableFloor
      \\key BeausoleilMorrisonMixedStableCeiling
      \\key BeausoleilMorrisonMixedUnstableCeiling
      \\key FohannoPolidoriVerticalWall
      \\key KaradagChilledCeiling
      \\key ISO15099Windows
      \\key GoldsteinNovoselacCeilingDiffuserWindow
      \\key GoldsteinNovoselacCeilingDiffuserWalls
      \\key GoldsteinNovoselacCeilingDiffuserFloor
      \\key NusseltJurges
      \\key McAdams
      \\key Mitchell
      \\key BlockenWindard
      \\key EmmelVertical
      \\key EmmelRoof
      \\key ClearRoof
      \\key UserCurve
  N2, \\field Convection Coefficient 2
      \\note used if Convection Type=Value, min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\default .1
      \\units W/m2-K
  A8, \\field Convection Coefficient 2 Schedule Name
      \\note used if Convection Type=Schedule,  min and max limits are set in HeatBalanceAlgorithm object.
      \\note Default limits are Minimum >= 0.1 and Maximum <= 1000
      \\type object-list
      \\object-list ScheduleNames
  A9; \\field Convection Coefficient 2 User Curve Name
      \\note used if Convection Type = UserCurve
      \\type object-list
      \\object-list UserConvectionModels

SurfaceProperties:VaporCoefficients,
      \\memo The interior and external vapor transfer coefficients.
      \\memo Normally these value are calculated using the heat convection coefficient values.
      \\memo Use this object to used fixed constant values.
      \\memo Units are kg/Pa.s.m2
      \\memo This will only work with the CombinedHeatAndMoistureFiniteElement algorithm for surfaces.
      \\memo Other algorithms will ignore these coefficients
      \\min-fields 4
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfaceNames
  A2, \\field Constant External Vapor Transfer Coefficient
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N1, \\field External Vapor Coefficient Value
      \\units kg/Pa-s-m2
      \\default 0
      \\minimum 0.0
  A3, \\field Constant Internal vapor Transfer Coefficient
      \\type choice
      \\key Yes
      \\key No
      \\default No
  N2; \\field Internal Vapor Coefficient Value
      \\units kg/Pa-s-m2
      \\default 0
      \\minimum 0.0

SurfaceProperty:ExteriorNaturalVentedCavity,
       \\memo Used to describe the decoupled layer, or baffle, and the characteristics of the cavity
       \\memo and openings for naturally ventilated exterior surfaces. This object is also used in
       \\memo conjunction with the OtherSideConditionsModel.
       \\extensible:1 - repeat last field, remembering to remove ; from "inner" fields.
  A1,  \\field Name
       \\required-field
       \\type alpha
  A2,  \\field Boundary Conditions Model Name
       \\note Enter the name of a SurfaceProperty:OtherSideConditionsModel object
       \\required-field
       \\type object-list
       \\object-list OSCMNames
  N1,  \\field Area Fraction of Openings
       \\type real
       \\minimum> 0
       \\maximum 1.0
       \\units dimensionless
  N2,  \\field Thermal Emissivity of Exterior Baffle Material
       \\type real
       \\minimum 0
       \\maximum 1
       \\units dimensionless
  N3,  \\field Solar Absorbtivity of Exterior Baffle
       \\type real
       \\minimum 0
       \\maximum 1
       \\units dimensionless
  N4, \\field Height Scale for Buoyancy-Driven Ventilation
       \\type real
       \\units m
       \\minimum> 0.0
  N5,  \\field Effective Thickness of Cavity Behind Exterior Baffle
       \\type real
       \\minimum> 0.
       \\units m
       \\note if corrugated, use average depth
  N6,  \\field Ratio of Actual Surface Area to Projected Surface Area
       \\type real
       \\note this parameter is used to help account for corrugations in the collector
       \\default 1.0
       \\minimum 0.8
       \\maximum 2.0
       \\units dimensionless
  A3,  \\field Roughness of Exterior Surface
       \\required-field
       \\type choice
       \\key VeryRough
       \\key Rough
       \\key MediumRough
       \\key MediumSmooth
       \\key Smooth
       \\key VerySmooth
  N7,  \\field Effectiveness for Perforations with Respect to Wind
       \\type real
       \\units dimensionless
       \\default 0.25
       \\minimum> 0
       \\maximum 1.5
  N8,  \\field Discharge Coefficient for Openings with Respect to Buoyancy Driven Flow
       \\type real
       \\units dimensionless
       \\default 0.65
       \\minimum> 0.0
       \\maximum 1.5
  A4,  \\field Surface 1 Name
       \\begin-extensible
       \\required-field
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A5,  \\field Surface 2 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A6,  \\field Surface 3 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A7,  \\field Surface 4 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A8,  \\field Surface 5 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A9,  \\field Surface 6 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A10,  \\field Surface 7 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A11,  \\field Surface 8 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A12,  \\field Surface 9 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames
  A13;  \\field Surface 10 Name
       \\type object-list
       \\object-list AllShadingAndHTSurfNames

SurfaceProperty:SolarIncidentInside,
       \\memo Used to provide incident solar radiation on the inside of the surface. Reference surface-construction pair
       \\memo and if that pair is used in a simulation, then program will use value provided in schedule instead of calculating it.
  A1,  \\field Name
       \\required-field
  A2,  \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  A3,  \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ConstructionNames
  A4;  \\field Inside Surface Incident Sun Solar Radiation Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\required-field
       \\type object-list
       \\object-list ScheduleNames

SurfaceProperty:LocalEnvironment,
       \\min-fields 3
       \\memo This object defines the local environment properties of an exterior surface.
       \\memo One or more environment properties have to be defined and linked to the exterior surface.
   A1, \\field Name
       \\required-field
       \\type alpha
       \\reference SurfaceLocalEnvironmentNames
   A2, \\field Exterior Surface Name
       \\type object-list
       \\object-list SurfaceNames
       \\note Enter the name of an exterior surface object
   A3, \\field External Shading Fraction Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Enter the name of a Schedule object
   A4, \\field Surrounding Surfaces Object Name
       \\type object-list
       \\object-list SurroundingSurfacesNames
       \\note Enter the name of a SurfaceProperty:SurroundingSurfaces object
   A5; \\field Outdoor Air Node Name
       \\type object-list
       \\object-list OutdoorAirNodeNames
       \\note Enter the name of an OutdoorAir:Node object

ZoneProperty:LocalEnvironment,
       \\min-fields 3
       \\memo This object defines the local environment properties of a zone object.
       \\memo A corresponding outdoor air node should be defined and linked to the zone object.
   A1, \\field Name
       \\required-field
       \\type alpha
       \\reference ZoneLocalEnvironmentNames
   A2, \\field Zone Name
       \\type object-list
       \\object-list ZoneNames
       \\note Enter the name of a zone object
   A3; \\field Outdoor Air Node Name
       \\type object-list
       \\object-list OutdoorAirNodeNames
       \\note Enter the name of an OutdoorAir:Node object

SurfaceProperty:SurroundingSurfaces,
       \\min-fields 8
       \\memo This object defines a list of surrounding surfaces for an exterior surface.
       \\extensible:3 -- duplicate last set of surrounding surface properties (the last three fields), remembering to remove ; from "inner" fields.
   A1, \\field Name
       \\required-field
       \\type alpha
       \\reference SurroundingSurfacesNames
   N1, \\field Sky View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
       \\note optional
   A2, \\field Sky Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
       \\note optional
   N2, \\field Ground View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.5
       \\note optional
   A3, \\field Ground Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
       \\note optional
   A4, \\field Surrounding Surface 1 Name
       \\begin-extensible
       \\required-field
       \\type alpha
   N3, \\field Surrounding Surface 1 View Factor
       \\required-field
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A5, \\field Surrounding Surface 1 Temperature Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A6, \\field Surrounding Surface 2 Name
       \\type alpha
   N4, \\field Surrounding Surface 2 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A7, \\field Surrounding Surface 2 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A8, \\field Surrounding Surface 3 Name
       \\type alpha
   N5, \\field Surrounding Surface 3 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A9, \\field Surrounding Surface 3 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A10,\\field Surrounding Surface 4 Name
       \\type alpha
   N6, \\field Surrounding Surface 4 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A11,\\field Surrounding Surface 4 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A12,\\field Surrounding Surface 5 Name
       \\type alpha
   N7, \\field Surrounding Surface 5 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A13,\\field Surrounding Surface 5 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A14,\\field Surrounding Surface 6 Name
       \\type alpha
   N8, \\field Surrounding Surface 6 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A15,\\field Surrounding Surface 6 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A16,\\field Surrounding Surface 7 Name
       \\type alpha
   N9, \\field Surrounding Surface 7 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A17,\\field Surrounding Surface 7 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A18,\\field Surrounding Surface 8 Name
       \\type alpha
   N10,\\field Surrounding Surface 8 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A19,\\field Surrounding Surface 8 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A20, \\field Surrounding Surface 9 Name
       \\type alpha
   N11,\\field Surrounding Surface 9 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A21,\\field Surrounding Surface 9 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C
   A22,\\field Surrounding Surface 10 Name
       \\type alpha
   N12,\\field Surrounding Surface 10 View Factor
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
   A23;\\field Surrounding Surface 10 Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note Schedule values are real numbers, -100.0 to 100.0, units C

ComplexFenestrationProperty:SolarAbsorbedLayers,
       \\memo Used to provide solar radiation absorbed in fenestration layers. References surface-construction pair
       \\memo and if that pair is used in a simulation, then program will use value provided in schedules instead of calculating it.
  A1,  \\field Name
       \\required-field
  A2,  \\field Fenestration Surface
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A3,  \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ComplexFenestrationStates
  A4,  \\field Layer 1 Solar Radiation Absorbed Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A5,  \\field Layer 2 Solar Radiation Absorbed Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\type object-list
       \\object-list ScheduleNames
  A6,  \\field Layer 3 Solar Radiation Absorbed Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\type object-list
       \\object-list ScheduleNames
  A7,  \\field Layer 4 Solar Radiation Absorbed Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\type object-list
       \\object-list ScheduleNames
  A8;  \\field Layer 5 Solar Radiation Absorbed Schedule Name
       \\note Values in schedule are expected to be in W/m2
       \\type object-list
       \\object-list ScheduleNames


ZoneProperty:UserViewFactors:BySurfaceName,
       \\memo View factors for Surface to Surface in a zone.
       \\memo (Number of Surfaces)**2 are expected. Any omitted surface pairs will be assumed to have a view factor of zero.
       \\extensible:3 - copy last three fields, remembering to remove ;
       \\format ViewFactor
  A1,  \\field Zone or ZoneList or Space or SpaceList Name
       \\note View factors may be entered for a space, zone, group of spaces, or group of zones in the same enclosure
       \\note by way of Constructon:AirBoundary or open spaces within a zone. This name must align with an enclosure
       \\note encompassing the same zones or spaces.
       \\type object-list
       \\object-list SpaceNames
       \\object-list SpaceListNames
       \\object-list ZoneNames
       \\object-list ZoneListNames
  A2,  \\field From Surface 1
       \\begin-extensible
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A3,  \\field To Surface 1
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N1,  \\field View Factor 1
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A4,  \\field From Surface 2
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A5,  \\field To Surface 2
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N2,  \\field View Factor 2
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A6,  \\field From Surface 3
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A7,  \\field To Surface 3
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N3,  \\field View Factor 3
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A8,  \\field From Surface 4
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A9,  \\field To Surface 4
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N4,  \\field View Factor 4
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A10, \\field From Surface 5
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A11, \\field To Surface 5
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N5,  \\field View Factor 5
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A12, \\field From Surface 6
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A13, \\field To Surface 6
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N6,  \\field View Factor 6
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A14, \\field From Surface 7
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A15, \\field To Surface 7
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N7,  \\field View Factor 7
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A16, \\field From Surface 8
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A17, \\field To Surface 8
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N8,  \\field View Factor 8
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A18, \\field From Surface 9
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A19, \\field To Surface 9
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N9,  \\field View Factor 9
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A20, \\field From Surface 10
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A21, \\field To Surface 10
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N10, \\field View Factor 10
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A22, \\field From Surface 11
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A23, \\field To Surface 11
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N11, \\field View Factor 11
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A24, \\field From Surface 12
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A25, \\field To Surface 12
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N12, \\field View Factor 12
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A26, \\field From Surface 13
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A27, \\field To Surface 13
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N13, \\field View Factor 13
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A28, \\field From Surface 14
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A29, \\field To Surface 14
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N14, \\field View Factor 14
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A30, \\field From Surface 15
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A31, \\field To Surface 15
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N15, \\field View Factor 15
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A32, \\field From Surface 16
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A33, \\field To Surface 16
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N16, \\field View Factor 16
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A34, \\field From Surface 17
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A35, \\field To Surface 17
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N17, \\field View Factor 17
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A36, \\field From Surface 18
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A37, \\field To Surface 18
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N18, \\field View Factor 18
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A38, \\field From Surface 19
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A39, \\field To Surface 19
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N19, \\field View Factor 19
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A40, \\field From Surface 20
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A41, \\field To Surface 20
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N20, \\field View Factor 20
       \\note This value is the view factor value From Surface => To Surface
       \\type real
       \\maximum 1.0
  A42,A43,N21,A44,A45,N22,A46,A47,N23,A48,A49,N24,A50,A51,N25,A52,A53,N26,A54,A55,N27,A56,A57,N28,A58,A59,N29,A60,A61,N30,
  A62,A63,N31,A64,A65,N33,A66,A67,N35,A68,A69,N37,A70,A71,N39,A72,A73,N41,A74,A75,N43,A76,A77,N45,A78,A79,N47,A80,A81,N49,
  A82,A83,N41,A84,A85,N43,A86,A87,N45,A88,A89,N47,A90,A91,N49,A92,A93,N51,A94,A95,N53,A96,A97,N55,A98,A99,N57,A100,A101,N59,
  A102,A103,N51,A104,A105,N53,A106,A107,N55,A108,A109,N57,A110,A111,N59,A112,A113,N61,A114,A115,N63,A116,A117,N65,A118,A119,N67,A120,A121,N69,
  A122,A123,N61,A124,A125,N63,A126,A127,N65,A128,A129,N67,A130,A131,N69,A132,A133,N71,A134,A135,N73,A136,A137,N75,A138,A139,N77,A140,A141,N79,
  A142,A143,N71,A144,A145,N73,A146,A147,N75,A148,A149,N77,A150,A151,N79,A152,A153,N81,A154,A155,N83,A156,A157,N85,A158,A159,N87,A160,A161,N89,
  A162,A163,N81,A164,A165,N83,A166,A167,N85,A168,A169,N87,A170,A171,N89,A172,A173,N91,A174,A175,N93,A176,A177,N95,A178,A179,N97,A180,A181,N99,
  A182,A183,N91,A184,A185,N93,A186,A187,N95,A188,A189,N97,A190,A191,N99,A192,A193,N101,A194,A195,N103,A196,A197,N105,A198,A199,N107,A200,A201,N109,
  A202,A203,N101,A204,A205,N103,A206,A207,N105,A208,A209,N107,A210,A211,N109,A212,A213,N111,A214,A215,N113,A216,A217,N115,A218,A219,N117,A220,A221,N119,
  A222,A223,N111,A224,A225,N113,A226,A227,N115,A228,A229,N117,A230,A231,N119,A232,A233,N121,A234,A235,N123,A236,A237,N125,A238,A239,N127,A240,A241,N129,
  A242,A243,N121,A244,A245,N123,A246,A247,N125,A248,A249,N127,A250,A251,N129,A252,A253,N131,A254,A255,N133,A256,A257,N135,A258,A259,N137,A260,A261,N139,
  A262,A263,N131,A264,A265,N133,A266,A267,N135,A268,A269,N137,A270,A271,N139,A272,A273,N141,A274,A275,N143,A276,A277,N145,A278,A279,N147,A280,A281,N149,
  A282,A283,N141,A284,A285,N143,A286,A287,N145,A288,A289,N147,A290,A291,N149,A292,A293,N151,A294,A295,N153,A296,A297,N155,A298,A299,N157,A300,A301,N159,
  A302,A303,N151,A304,A305,N153,A306,A307,N155,A308,A309,N157,A310,A311,N159,A312,A313,N161,A314,A315,N163,A316,A317,N165,A318,A319,N167,A320,A321,N169,
  A322,A323,N161,A324,A325,N163,A326,A327,N165,A328,A329,N167,A330,A331,N169,A332,A333,N171,A334,A335,N173,A336,A337,N175,A338,A339,N177,A340,A341,N179,
  A342,A343,N171,A344,A345,N173,A346,A347,N175,A348,A349,N177,A350,A351,N179,A352,A353,N181,A354,A355,N183,A356,A357,N185,A358,A359,N187,A360,A361,N189,
  A362,A363,N181,A364,A365,N183,A366,A367,N185,A368,A369,N187,A370,A371,N189,A372,A373,N191,A374,A375,N193,A376,A377,N195,A378,A379,N197,A380,A381,N199,
  A382,A383,N191,A384,A385,N193,A386,A387,N195,A388,A389,N197,A390,A391,N199,A392,A393,N201,A394,A395,N203,A396,A397,N205,A398,A399,N207,A400,A401,N209,
  A402,A403,N201,A404,A405,N203,A406,A407,N205,A408,A409,N207,A410,A411,N209,A412,A413,N211,A414,A415,N213,A416,A417,N215,A418,A419,N217,A420,A421,N219,
  A422,A423,N211,A424,A425,N213,A426,A427,N215,A428,A429,N217,A430,A431,N219,A432,A433,N221,A434,A435,N223,A436,A437,N225,A438,A439,N227,A440,A441,N229,
  A442,A443,N221,A444,A445,N223,A446,A447,N225,A448,A449,N227,A450,A451,N229,A452,A453,N231,A454,A455,N233,A456,A457,N235,A458,A459,N237,A460,A461,N239,
  A462,A463,N231,A464,A465,N233,A466,A467,N235,A468,A469,N237,A470,A471,N239,A472,A473,N241,A474,A475,N243,A476,A477,N245,A478,A479,N247,A480,A481,N249,
  A482,A483,N241,A484,A485,N243,A486,A487,N245,A488,A489,N247,A490,A491,N249,A492,A493,N251,A494,A495,N253,A496,A497,N255,A498,A499,N257,A500,A501,N259,
  A502,A503,N251,A504,A505,N253,A506,A507,N255,A508,A509,N257,A510,A511,N259,A512,A513,N261,A514,A515,N263,A516,A517,N265,A518,A519,N267,A520,A521,N269,
  A522,A523,N261,A524,A525,N263,A526,A527,N265,A528,A529,N267,A530,A531,N269,A532,A533,N271,A534,A535,N273,A536,A537,N275,A538,A539,N277,A540,A541,N279,
  A542,A543,N271,A544,A545,N273,A546,A547,N275,A548,A549,N277,A550,A551,N279,A552,A553,N281,A554,A555,N283,A556,A557,N285,A558,A559,N287,A560,A561,N289,
  A562,A563,N281,A564,A565,N283,A566,A567,N285,A568,A569,N287,A570,A571,N289,A572,A573,N291,A574,A575,N293,A576,A577,N295,A578,A579,N297,A580,A581,N299,
  A582,A583,N291,A584,A585,N293,A586,A587,N295,A588,A589,N297,A590,A591,N299,A592,A593,N301,A594,A595,N303,A596,A597,N305,A598,A599,N307,A600,A601,N309,
  A602,A603,N301,A604,A605,N303,A606,A607,N305,A608,A609,N307,A610,A611,N309,A612,A613,N311,A614,A615,N313,A616,A617,N315,A618,A619,N317,A620,A621,N319,
  A622,A623,N311,A624,A625,N313,A626,A627,N315,A628,A629,N317,A630,A631,N319,A632,A633,N321,A634,A635,N323,A636,A637,N325,A638,A639,N327,A640,A641,N329,
  A642,A643,N321,A644,A645,N323,A646,A647,N325,A648,A649,N327,A650,A651,N329,A652,A653,N331,A654,A655,N333,A656,A657,N335,A658,A659,N337,A660,A661,N339,
  A662,A663,N331,A664,A665,N333,A666,A667,N335,A668,A669,N337,A670,A671,N339,A672,A673,N341,A674,A675,N343,A676,A677,N345,A678,A679,N347,A680,A681,N349,
  A682,A683,N341,A684,A685,N343,A686,A687,N345,A688,A689,N347,A690,A691,N349,A692,A693,N351,A694,A695,N353,A696,A697,N355,A698,A699,N357,A700,A701,N359,
  A702,A703,N351,A704,A705,N353,A706,A707,N355,A708,A709,N357,A710,A711,N359,A712,A713,N361,A714,A715,N363,A716,A717,N365,A718,A719,N367,A720,A721,N369,
  A722,A723,N361,A724,A725,N363,A726,A727,N365,A728,A729,N367,A730,A731,N369,A732,A733,N371,A734,A735,N373,A736,A737,N375,A738,A739,N377,A740,A741,N379,
  A742,A743,N371,A744,A745,N373,A746,A747,N375,A748,A749,N377,A750,A751,N379,A752,A753,N381,A754,A755,N383,A756,A757,N385,A758,A759,N387,A760,A761,N389,
  A762,A763,N381,A764,A765,N383,A766,A767,N385,A768,A769,N387,A770,A771,N389,A772,A773,N391,A774,A775,N393,A776,A777,N395,A778,A779,N397,A780,A781,N399,
  A782,A783,N391,A784,A785,N393,A786,A787,N395,A788,A789,N397,A790,A791,N399,A792,A793,N401,A794,A795,N403,A796,A797,N405,A798,A799,N407,A800,A801,N409,
  A802,A803,N401,A804,A805,N403,A806,A807,N405,A808,A809,N407,A810,A811,N409,A812,A813,N411,A814,A815,N413,A816,A817,N415,A818,A819,N417,A820,A821,N419,
  A822,A823,N411,A824,A825,N413,A826,A827,N415,A828,A829,N417,A830,A831,N419,A832,A833,N421,A834,A835,N423,A836,A837,N425,A838,A839,N427,A840,A841,N429,
  A842,A843,N421,A844,A845,N423,A846,A847,N425,A848,A849,N427,A850,A851,N429,A852,A853,N431,A854,A855,N433,A856,A857,N435,A858,A859,N437,A860,A861,N439,
  A862,A863,N431,A864,A865,N433,A866,A867,N435,A868,A869,N437,A870,A871,N439,A872,A873,N441,A874,A875,N443,A876,A877,N445,A878,A879,N447,A880,A881,N449,
  A882,A883,N441,A884,A885,N443,A886,A887,N445,A888,A889,N447,A890,A891,N449,A892,A893,N451,A894,A895,N453,A896,A897,N455,A898,A899,N457,A900,A901,N459,
  A902,A903,N451,A904,A905,N453,A906,A907,N455,A908,A909,N457,A910,A911,N459,A912,A913,N461,A914,A915,N463,A916,A917,N465,A918,A919,N467,A920,A921,N469,
  A922,A923,N461,A924,A925,N463,A926,A927,N465,A928,A929,N467,A930,A931,N469,A932,A933,N471,A934,A935,N473,A936,A937,N475,A938,A939,N477,A940,A941,N479,
  A942,A943,N471,A944,A945,N473,A946,A947,N475,A948,A949,N477,A950,A951,N479,A952,A953,N481,A954,A955,N483,A956,A957,N485,A958,A959,N487,A960,A961,N489,
  A962,A963,N481,A964,A965,N483,A966,A967,N485,A968,A969,N487,A970,A971,N489,A972,A973,N491,A974,A975,N493,A976,A977,N495,A978,A979,N497,A980,A981,N499;

\\group Detailed Ground Heat Transfer

GroundHeatTransfer:Control,
  \\memo Object determines if the Slab and Basement preprocessors
  \\memo are going to be executed.
  A1 , \\field Name
    \\note This field is included for consistency.11
  A2 , \\field Run Basement Preprocessor
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A3 ; \\field Run Slab Preprocessor
       \\type choice
       \\key Yes
       \\key No
       \\default No

GroundHeatTransfer:Slab:Materials,
    \\memo Object gives an overall description of the slab ground heat transfer model.
        N1, \\field NMAT: Number of materials
            \\note This field specifies the number of different materials that will be used in the model.
            \\note Typically only a ground material and a slab material are used. (2 materials)
            \\minimum> 0
          \\required-field
        N2, \\field ALBEDO: Surface Albedo: No Snow
            \\note Two fields specify the albedo value of the surface: first for no snow coverage days;
            \\note second for days with snow coverage. The albedo is the solar reflectivity of the surface,
            \\note and can vary from 0.05 for blacktop to 0.95 for fresh snow.
            \\note Typical values for North America reported by Bahnfleth range from 0.16 to 0.4.
            \\minimum 0.0
            \\maximum 1.0
          \\default 0.16
        N3, \\field ALBEDO: Surface Albedo: Snow
            \\minimum 0.0
            \\maximum 1.0
          \\default 0.40
        N4, \\field EPSLW: Surface Emissivity: No Snow
          \\note EPSLW (No Snow and Snow) specifies the long wavelength (thermal) emissivity of the ground surface.
          \\note primarily important for nighttime radiation to sky.
          \\note typical value .95
            \\minimum> 0.0
          \\default 0.94
        N5, \\field EPSLW: Surface Emissivity: Snow
            \\minimum> 0.0
          \\default 0.86
        N6, \\field Z0: Surface Roughness: No Snow
          \\note fields Z0 (No Snow and Snow) describe the height at which an experimentally velocity profile goes to zero.
          \\note typical value= .75 cm
         \\minimum> 0.0
          \\default .75
          \\units cm
        N7, \\field Z0: Surface Roughness: Snow
            \\note typical value= .05 cm
         \\minimum> 0.0
          \\default 0.25
          \\units cm
        N8, \\field HIN: Indoor HConv: Downward Flow
            \\note These fields specify the combined convective and radiative heat transfer coefficient between
            \\note the slab top inside surface and the room air for the cases where heat is flowing downward,
            \\note and upward. The program toggles between the two if the direction of the heat flux changes.
            \\note Typical values can be found in the ASHRAE Handbook of Fundamentals, but should be
            \\note about 6 W/(m2-K) for downward heat flow and 9 W/(m2-K) for upward heat flow.
            \\note typical value= 4-10
            \\units W/m2-K
            \\minimum> 0.0
          \\default 6.13
        N9; \\field HIN: Indoor HConv: Upward
            \\minimum> 0.0
            \\note typical value= 4-10
            \\units W/m2-K
          \\default 9.26

GroundHeatTransfer:Slab:MatlProps,
    \\memo This object contains the material properties for the materials
    \\memo used in the model. The fields are mostly self explanatory.
     N1,  \\field RHO: Slab Material density
          \\note Density of Slab Material
          \\note typical value= 2300.0
          \\units kg/m3
          \\minimum> 0.0
          \\default 2300
     N2,  \\field RHO: Soil Density
          \\note Density of Soil Material
          \\note typical value= 1200.0
          \\minimum> 0.0
          \\default 1200
          \\units kg/m3
     N3,  \\field CP: Slab CP
          \\note Specific Heat of Slab Material
          \\note typical value=650.0
          \\units J/kg-K
          \\minimum> 0.0
          \\default 650
     N4,  \\field CP: Soil CP
          \\note Specific Heat of Soil Material
          \\note typical value= 1200.0
          \\minimum> 0.0
          \\default 1200
          \\units J/kg-K
     N5,  \\field TCON: Slab k
          \\note Conductivity of Slab Material
          \\note typical value= .9
          \\minimum> 0.0
          \\units W/m-K
          \\default 0.9
     N6;  \\field TCON: Soil k
          \\note Conductivity of Soil Material
          \\note typical value= 1.0
          \\minimum> 0.0
          \\units W/m-K
          \\default 1.0

GroundHeatTransfer:Slab:BoundConds,
      \\memo Supplies some of the boundary conditions used in the ground heat transfer calculations.
        A1, \\field EVTR: Is surface evapotranspiration modeled
            \\note This field specifies whether or not to use the evapotransporation model.
            \\note The inclusion of evapotransporation in the calculation has the greatest
            \\note effect in warm dry climates, primarily on the ground surface temperature.
            \\note This field can be used to turn the evapotransporation off and on to check
            \\note sensitivity to it.
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        A2, \\field FIXBC: is the lower boundary at a fixed temperature
            \\note This field permits using a fixed temperature at the lower surface of the model
            \\note instead of a zero heat flux condition. This change normally has a very small
            \\note effect on the results.
            \\note FALSE selects the zero flux lower boundary condition
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        N1, \\field TDEEPin
            \\note User input lower boundary temperature if FIXBC is TRUE
            \\note Blank for FIXBC FALSE or to use the calculated 1-D deep ground temperature.
            \\units C
        A3, \\field USRHflag: Is the ground surface h specified by the user?
            \\note This field flags the use of a user specified heat transfer coefficient
            \\note on the ground surface. This condition is used primarily for testing.
            \\note For normal runs (USPHflag is FALSE) and the program calculates the heat
            \\note transfer coefficient using the weather conditions.
            \\type choice
            \\key TRUE
            \\key FALSE
          \\required-field
        N2; \\field USERH: User specified ground surface heat transfer coefficient
            \\note Used only if USRHflag is TRUE and the heat transfer coefficient value is
            \\note specified in this field.
            \\units W/m2-K

GroundHeatTransfer:Slab:BldgProps,
          \\memo Object provides information about the building and its operating conditions
          \\memo Monthly Average Temperature SetPoint fields
          \\memo specify the average indoor building set point temperatures for each
          \\memo month of the year. These fields are useful for simulating a building
          \\memo that is not temperature controlled for some of the year.
          \\memo In such a case, the average indoor set point temperatures
          \\memo can be obtained by first running the model in EnergyPlus with an
          \\memo insulated floor boundary condition, and then using the resulting
          \\memo monthly average zone temperatures in these fields.
      N1, \\field IYRS: Number of years to iterate
          \\note This field specifies the number of years to iterate.
          \\note Either the ground heat transfer calculations come to an
          \\note an annual steady periodic condition by converging to a tolerance
          \\note (see ConvTol field) or it runs for this number of years.
          \\note A ten year maximum is usually sufficient.
          \\default 10
          \\minimum 1
      N2, \\field Shape: Slab shape
          \\note Use only the value 0 here. Only a rectangular shape is implemented.
          \\minimum 0
          \\maximum 0
      N3, \\field HBLDG: Building height
          \\note This field supplies the building height. This is used to calculate
          \\note the building shadowing on the ground.
          \\minimum 0
          \\note typical value= 0-20
          \\units m
      N4, \\field TIN1: January Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N5, \\field TIN2: February Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N6, \\field TIN3: March Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N7, \\field TIN4: April Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N8, \\field TIN5: May Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N9, \\field TIN6: June Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N10,\\field TIN7: July Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N11,\\field TIN8: August Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N12,\\field TIN9: September Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N13,\\field TIN10: October Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N14,\\field TIN11: November Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N15,\\field TIN12: December Indoor Average Temperature Setpoint
          \\note see memo on object for more information
          \\default 22
          \\units C
      N16,\\field TINAmp: Daily Indoor sine wave variation amplitude
          \\note This field permits imposing a daily sinusoidal variation
          \\note in the indoor setpoint temperature to simulate the effect
          \\note of a setback profile.
          \\note The value specified is the amplitude of the sine wave.
          \\default 0
          \\units deltaC
      N17;\\field ConvTol: Convergence Tolerance
          \\note This field specifies the convergence tolerance used to
          \\note control the iteration. When the temperature change of all nodes
          \\note is less than the convergence value, iteration ceases.
          \\default 0.1

GroundHeatTransfer:Slab:Insulation,
    \\memo This object supplies the information about insulation used around the slab.
    \\memo There are two possible configurations: under the slab or vertical insulation
    \\memo around the slab.
    \\min-fields 5
        N1, \\field RINS: R value of under slab insulation
            \\note This field provides the thermal resistance value
            \\note of the under slab insulation. It should be zero
            \\note if the vertical insulation configuration is selected.
            \\note typical value= 0-2.0
            \\units m2-K/W
          \\default 0.0
        N2, \\field DINS: Width of strip of under slab insulation
            \\note This specifies the width of the perimeter strip of insulation
            \\note under the slab. It should be zero if for the vertical insulation
            \\note configuration is selected.
            \\note typical value= 0-2.0
            \\units m
          \\default 0.0
        N3, \\field RVINS: R value of vertical insulation
            \\note This field specifies the thermal resistance of the vertical
            \\note insulation. It should be zero if the under slab insulation
            \\note configuration is selected.
            \\note typical value= 0-3.0
            \\units m2-K/W
          \\default 0.0
        N4, \\field ZVINS: Depth of vertical insulation
            \\note This field specifies the depth of the vertical insulation
            \\note into the ground in meters. It starts at the slab upper surface
            \\note and extends into the ground.
            \\note It should be zero if the under slab insulation
            \\note configuration is selected.
            \\note only use values= .2 .4 .6 .8 1.0 1.5 2.0 2.5 3.0
            \\units m
          \\default 0
        N5; \\field IVINS: Flag: Is there vertical insulation
            \\note Specifies if the vertical insulation configuration is being used.
            \\note values: 1=yes vertical insulation 0=no under-slab insulation
          \\type choice
          \\key 0
          \\key 1
          \\default 0

GroundHeatTransfer:Slab:EquivalentSlab,
    \\memo Using an equivalent slab allows non-rectangular shapes to be modeled accurately.
    \\memo Object uses the area - perimeter (area/perimeter) ratio to determine the
    \\memo size of an equivalent rectangular slab.
    \\memo EnergyPlus users normally use this option.
     N1,  \\field APRatio: The area to perimeter ratio for this slab
          \\note Equivalent square slab is simulated,  side is 4*APRatio.
          \\units m
          \\minimum 1.5
          \\maximum 22
          \\required-field
     N2,  \\field SLABDEPTH: Thickness of slab on grade
          \\note This field specifies the thickness of the slab. The slab top surface is level
          \\note with the ground surface, so this is the depth into the ground.
          \\note The slab depth has a significant effect on the temperature calculation,
          \\note and it is also important for the auto-grid process.
          \\note The finite difference grids are set in such a way that they use the slab thickness
          \\note to determine the vertical grid spacing. Autogridding will fail if the slab thickness
          \\note is specified larger than 0.25 meters.
          \\default 0.1
          \\units m
     N3,  \\field CLEARANCE: Distance from edge of slab to domain edge
          \\note This field specifies the distance from the slab to the edge of
          \\note the area that will be modeled with the grid system. It is the basic size
          \\note dimension that is used to set the horizontal extent of the domain.
          \\note 15 meters is a reasonable value.
          \\default 15.0
          \\units m
     N4;  \\field ZCLEARANCE: Distance from bottom of slab to domain bottom
          \\note This field specifies the vertical distance from the slab to the
          \\note bottom edge of the area that will be modeled with the grid system.
          \\note 15 meters is a reasonable value.
          \\default 15.0
          \\units m

GroundHeatTransfer:Slab:AutoGrid,
            \\memo AutoGrid only necessary when EquivalentSlab option not chosen.
            \\memo  Not normally needed by EnergyPlus users.
            \\memo  This object permits user selection of rectangular slab dimensions.
            \\memo  NO SLAB DIMENSIONS LESS THAN 6 m.
        N1, \\field SLABX: X dimension of the building slab
            \\minimum 6
            \\note typical values= 6 to 60.0
            \\units m
          \\required-field
        N2, \\field SLABY: Y dimension of the building slab
            \\minimum 6
            \\note typical values= 6 to 60.0
            \\units m
          \\required-field
        N3, \\field SLABDEPTH: Thickness of slab on grade
            \\default 0.1
            \\units m
        N4, \\field CLEARANCE: Distance from edge of slab to domain edge
            \\default 15.0
            \\units m
        N5; \\field ZCLEARANCE: Distance from bottom of slab to domain bottom
            \\default 15.0
            \\units m

GroundHeatTransfer:Slab:ManualGrid,
            \\memo Manual Grid only necessary when using manual gridding (not recommended)
            \\memo Used only in special cases when previous two objects are not used.
            \\memo User must input complete gridding information.
        N1, \\field NX: Number of cells in the X direction
          \\minimum 1
          \\required-field
        N2, \\field NY: Number of cells in the Y direction
          \\minimum 1
          \\required-field
        N3, \\field NZ: Number of cells in the Z direction
          \\minimum 1
          \\required-field
        N4, \\field IBOX: X direction cell indicator of slab edge
            \\note typical values= 1-10
          \\required-field
        N5; \\field JBOX: Y direction cell indicator of slab edge
            \\note typical values= 1-10
          \\required-field

GroundHeatTransfer:Slab:XFACE,
         \\memo This is only needed when using manual gridding (not recommended)
         \\memo XFACE: X Direction cell face coordinates: m
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26, N27, N28, N29,    \\note fields as indicated
        N30, N31, N32, N33, N34, N35, N36, N37, N38, N39, N40;                        \\note fields as indicated

GroundHeatTransfer:Slab:YFACE,
         \\memo This is only needed when using manual gridding (not recommended)
         \\memo YFACE: Y Direction cell face coordinates: m,
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26, N27, N28, N29,    \\note fields as indicated
        N30, N31, N32, N33, N34, N35, N36, N37, N38, N39, N40;                        \\note fields as indicated

GroundHeatTransfer:Slab:ZFACE,
         \\memo This is only needed when using manual gridding (not recommended)
         \\memo ZFACE: Z Direction cell face coordinates: m
        N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,                  \\note fields as indicated
        N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25;                        \\note fields as indicated

GroundHeatTransfer:Basement:SimParameters,
          \\memo Specifies certain parameters that control the Basement preprocessor ground heat
          \\memo transfer simulation.
     N1,  \\field F: Multiplier for the ADI solution
         \\note 0<F<1.0,
          \\note typically 0.1 (0.3 for high k soil - saturated sand is about 2.6 w/m-K)
          \\minimum> 0.0
          \\maximum 1.0
      N2; \\field IYRS: Maximum number of yearly iterations:
         \\note typically 15-30]
          \\minimum 0
          \\default 15

GroundHeatTransfer:Basement:MatlProps,
         \\memo Specifies the material properties for the Basement preprocessor ground heat
         \\memo transfer simulation. Only the Foundation Wall, Floor Slab, Soil,
         \\memo and Gravel properties are currently used.
     N1, \\field NMAT: Number of materials in this domain
         \\maximum 6
          \\required-field
     N2, \\field Density for Foundation Wall
         \\minimum> 0.0
         \\default 2243
         \\units kg/m3
     N3, \\field density for Floor Slab
         \\minimum> 0.0
         \\default 2243
         \\units kg/m3
     N4, \\field density for Ceiling
         \\minimum> 0.0
         \\default 311
         \\units kg/m3
     N5, \\field density for Soil
         \\minimum> 0.0
         \\default 1500
         \\units kg/m3
     N6, \\field density for Gravel
         \\minimum> 0.0
         \\default 2000
         \\units kg/m3
     N7, \\field density for Wood
         \\minimum> 0.0
         \\default 449
         \\units kg/m3
     N8,  \\field Specific heat for foundation wall
          \\minimum> 0.0
          \\default 880
          \\units J/kg-K
     N9,  \\field Specific heat for floor slab
          \\minimum> 0.0
          \\default 880
          \\units J/kg-K
     N10, \\field Specific heat for ceiling
          \\minimum> 0.0
          \\default 1530
          \\units J/kg-K
     N11, \\field Specific heat for soil
          \\minimum> 0.0
          \\default 840
          \\units J/kg-K
     N12, \\field Specific heat for gravel
          \\minimum> 0.0
          \\default 720
          \\units J/kg-K
     N13, \\field Specific heat for wood
          \\minimum> 0.0
          \\default 1530
          \\units J/kg-K
     N14, \\field Thermal conductivity for foundation wall
          \\minimum> 0.0
          \\default 1.4
          \\units W/m-K
     N15, \\field Thermal conductivity for floor slab
          \\minimum> 0.0
          \\default 1.4
          \\units W/m-K
     N16, \\field Thermal conductivity for ceiling
          \\minimum> 0.0
          \\default 0.09
          \\units W/m-K
     N17, \\field thermal conductivity for soil
          \\minimum> 0.0
          \\default 1.1
          \\units W/m-K
     N18, \\field thermal conductivity for gravel
          \\minimum> 0.0
          \\default 1.9
          \\units W/m-K
     N19; \\field thermal conductivity for wood
          \\minimum> 0.0
          \\default 0.12
          \\units W/m-K

GroundHeatTransfer:Basement:Insulation,
         \\memo Describes the insulation used on an exterior basement wall for the Basement
         \\memo preprocessor ground heat transfer simulation.
     N1, \\field REXT: R Value of any exterior insulation
         \\minimum> 0.0
         \\units m2-K/W
     A1; \\field INSFULL: Flag: Is the wall fully insulated?
          \\required-field
         \\type choice
          \\key TRUE
          \\key FALSE
         \\note  True for full insulation
         \\note  False for insulation half way down side wall from grade line

GroundHeatTransfer:Basement:SurfaceProps,
         \\memo Specifies the soil surface properties for the Basement preprocessor ground
         \\memo heat transfer simulation.
         \\min-fields 7
     N1, \\field ALBEDO: Surface albedo for No snow conditions
         \\minimum 0.0
          \\maximum 1.0
         \\default 0.16
     N2, \\field ALBEDO: Surface albedo for snow conditions
         \\minimum 0.0
          \\maximum 1.0
         \\default 0.40
     N3, \\field EPSLN: Surface emissivity No Snow
          \\minimum 0.0
          \\maximum 1.0
         \\default 0.94
     N4, \\field EPSLN: Surface emissivity with Snow
          \\minimum 0.0
          \\maximum 1.0
         \\default 0.86
     N5, \\field VEGHT: Surface roughness No snow conditions
          \\minimum 0.0
         \\default 6.0
         \\units cm
     N6, \\field VEGHT: Surface roughness Snow conditions
          \\minimum 0.0
         \\default 0.25
         \\units cm
     A1; \\field PET: Flag, Potential evapotranspiration on?
          \\note  Typically, PET is False
         \\type choice
          \\key TRUE
          \\key FALSE
          \\default FALSE

GroundHeatTransfer:Basement:BldgData,
         \\memo Specifies the surface and gravel thicknesses used for the Basement
         \\memo preprocessor ground heat transfer simulation.
     N1, \\field DWALL: Wall thickness
         \\units m
         \\minimum 0.2
          \\default 0.2
     N2, \\field DSLAB: Floor slab thickness
         \\units m
         \\minimum> 0.0
         \\maximum 0.25
          \\default 0.1
     N3, \\field DGRAVXY: Width of gravel pit beside basement wall
         \\minimum> 0.0
         \\units  m
          \\default 0.3
     N4, \\field DGRAVZN: Gravel depth extending above the floor slab
         \\minimum> 0.0
         \\units m
          \\default 0.2
     N5; \\field DGRAVZP: Gravel depth below the floor slab
         \\minimum> 0.0
         \\units m
         \\default 0.1

GroundHeatTransfer:Basement:Interior,
       \\memo Provides the information needed to simulate the inside boundary conditions for
       \\memo the Basement preprocessor ground heat transfer simulation.
       \\min-fields 7
   A1, \\field COND: Flag: Is the basement conditioned?
       \\type choice
          \\key TRUE
          \\key FALSE
          \\default TRUE
       \\note for EnergyPlus this should be TRUE
   N1, \\field HIN: Downward convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 0.92
   N2, \\field HIN: Upward convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 4.04
   N3, \\field HIN: Horizontal convection only heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 3.08
   N4, \\field HIN: Downward combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 6.13
   N5, \\field HIN: Upward combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 9.26
   N6; \\field HIN: Horizontal combined (convection and radiation) heat transfer coefficient
       \\units W/m2-K
          \\minimum> 0.0
          \\default 8.29

GroundHeatTransfer:Basement:ComBldg,
   \\memo ComBldg contains the monthly average temperatures (C) and possibility of daily variation amplitude
   N1,  \\field January average temperature
        \\units C
          \\default 22
   N2,  \\field February average temperature
        \\units C
          \\default 22
   N3,  \\field March average temperature
        \\units C
          \\default 22
   N4,  \\field April average temperature
        \\units C
          \\default 22
   N5,  \\field May average temperature
        \\units C
          \\default 22
   N6,  \\field June average temperature
        \\units C
          \\default 22
   N7,  \\field July average temperature
        \\units C
          \\default 22
   N8,  \\field August average temperature
        \\units C
          \\default 22
   N9,  \\field September average temperature
        \\units C
          \\default 22
   N10, \\field October average temperature
        \\units C
          \\default 22
   N11, \\field November average temperature
        \\units C
          \\default 22
   N12, \\field December average temperature
        \\units C
          \\default 22
   N13; \\field Daily variation sine wave amplitude
          \\units deltaC
          \\default 0
        \\note (Normally zero, just for checking)

GroundHeatTransfer:Basement:EquivSlab,  !  Supplies the EquivSizing Flag
    \\memo Using an equivalent slab allows non-rectangular shapes to be
    \\memo modeled accurately.
    \\memo The simulation default should be EquivSizing=True
   N1, \\field APRatio: The area to perimeter ratio for this slab
       \\minimum> 0.0
       \\units m
          \\required-field
   A1; \\field EquivSizing: Flag
          \\required-field
       \\type choice
          \\key TRUE
          \\key FALSE
       \\note Will the dimensions of an equivalent slab be calculated (TRUE)
       \\note or will the dimensions be input directly? (FALSE)]
       \\note Only advanced special simulations should use FALSE.

GroundHeatTransfer:Basement:EquivAutoGrid,
    \\memo EquivAutoGrid necessary when EquivSizing=TRUE, TRUE is is the normal case.
   N1, \\field CLEARANCE: Distance from outside of wall to edge of 3-D ground domain
          \\minimum 0.0
       \\units m
       \\default 15
   N2, \\field SlabDepth: Thickness of the floor slab
          \\minimum 0.0
       \\units m
       \\default  0.1
   N3; \\field BaseDepth: Depth of the basement wall below grade
          \\minimum 0.0
       \\units  m
          \\default 2

GroundHeatTransfer:Basement:AutoGrid,
   \\memo AutoGrid only necessary when EquivSizing is false
   \\memo If the modeled building is not a rectangle or square, Equivalent
   \\memo sizing MUST be used to get accurate results
   N1, \\field CLEARANCE: Distance from outside of wall to edge,
          \\minimum 0
       \\units m
       \\default 15
   N2, \\field SLABX: X dimension of the building slab
          \\required-field
       \\units m
       \\minimum 0
       \\maximum 60
   N3, \\field SLABY: Y dimension of the building slab
          \\required-field
       \\units m
       \\minimum 0
       \\maximum 60
   N4, \\field ConcAGHeight: Height of the foundation wall above grade
       \\units m
          \\minimum 0
          \\default 0
   N5, \\field SlabDepth: Thickness of the floor slab
       \\units m
       \\default 0.1
   N6; \\field BaseDepth: Depth of the basement wall below grade
       \\units m
          \\minimum 0
          \\default 2

GroundHeatTransfer:Basement:ManualGrid,
    \\memo Manual Grid only necessary using manual gridding (not recommended)
       N1, \\field NX: Number of cells in the X direction: 20]
          \\minimum 1
          \\required-field
       N2, \\field NY: Number of cells in the Y direction: 20]
          \\minimum 1
          \\required-field
       N3, \\field NZAG: Number of cells in the Z direction. above grade: 4 Always]
          \\minimum 1
          \\required-field
       N4, \\field NZBG: Number of cells in Z direction. below grade: 10-35]
          \\minimum 1
          \\required-field
       N5, \\field IBASE: X direction cell indicator of slab edge: 5-20]
          \\required-field
       N6, \\field JBASE: Y direction cell indicator of slab edge: 5-20]
          \\required-field
       N7; \\field KBASE: Z direction cell indicator of the top of the floor slab: 5-20]
          \\required-field

GroundHeatTransfer:Basement:XFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo XFACE: X Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40, N41, N42, N43, N44;                                 \\note fields as indicated

GroundHeatTransfer:Basement:YFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo YFACE: Y Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40, N41, N42, N43, N44;                                 \\note fields as indicated

GroundHeatTransfer:Basement:ZFACE,
    \\memo This is only needed when using manual gridding (not recommended)
    \\memo ZFACE: Z Direction cell face coordinates: m
       N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12, N13, N14,  \\note fields as indicated
       N15, N16, N17, N18, N19, N20, N21, N22, N23, N24, N25, N26,   \\note fields as indicated
       N27, N28, N29, N30, N31, N32, N33, N34, N35, N36, N37, N38,   \\note fields as indicated
       N39, N40;                                                     \\note fields as indicated

\\group Room Air Models

RoomAirModelType,
      \\memo Selects the type of room air model to be used in a given zone. If no RoomAirModelType
      \\memo object is specified then the default Mixing model (all zone air at the same
      \\memo temperature) will be used.
      \\min-fields 4
  A1, \\field Name
      \\required-field
      \\type alpha
  A2, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  A3, \\field Room-Air Modeling Type
      \\type choice
      \\key Mixing
      \\key UserDefined
      \\key OneNodeDisplacementVentilation
      \\key ThreeNodeDisplacementVentilation
      \\key CrossVentilation
      \\key UnderFloorAirDistributionInterior
      \\key UnderFloorAirDistributionExterior
      \\key AirflowNetwork
      \\default Mixing
      \\note Mixing = Complete mixing air model
      \\note UserDefined = UserDefined Room Air Temperature Patterns
      \\note needs RoomAir:TemperaturePattern:UserDefined object referencing this Zone
      \\note OneNodeDisplacementVentilation = Mundt roomair model for displacement ventilation with single floor air node
      \\note needs RoomAirSettings:OneNodeDisplacementVentilation object referencing this Zone
      \\note ThreeNodeDisplacementVentilation = RoomAir modeling using UCSD three-node displacement ventilation model
      \\note needs RoomAirSettings:ThreeNodeDisplacementVentilation object referencing this Zone
      \\note CrossVentilation = RoomAir modeling using UCSD two-zone cross ventilation model
      \\note needs RoomAirSettings:CrossVentilation object referencing this Zone
      \\note UnderFloorAirDistributionInterior = 2-Node UFAD model for interior zones
      \\note needs RoomAirSettings:UnderFloorAirDistributionInterior object referencing this Zone
      \\note UnderFloorAirDistributionExterior = RoomAir modeling using 2-Node UFAD model for exterior zones
      \\note needs RoomAirSettings:UnderFloorAirDistributionExterior object referencing this Zone
      \\note AirflowNetwork = RoomAir modeling using AirflowNetwork
      \\note needs RoomAirSettings:AirflowNetwork object referencing this Zone
  A4; \\field Air Temperature Coupling Strategy
      \\type choice
      \\key Direct
      \\key Indirect
      \\default Direct

RoomAir:TemperaturePattern:UserDefined,
       \\memo Used to explicitly define temperature patterns that are to be applied to the mean air
       \\memo temperature within a thermal zone. Used with RoomAirModelType = UserDefined.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Availability Schedule Name
       \\note Availability schedule name for this model. Schedule value > 0 means the model is
       \\note active. Schedule value = 0 means the model is inactive and the zone will be modeled
       \\note as fully mixed (Mixing). If this field is blank, the model is always active.
       \\type object-list
       \\object-list ScheduleNames
  A4 ; \\field Pattern Control Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note The schedule should contain integer values that
       \\note correspond to unique Control Integer fields in
       \\note one of the RoomAir:TemperaturePattern:* objects.

RoomAir:TemperaturePattern:ConstantGradient,
      \\memo Used to model room air with a fixed temperature gradient in the vertical direction.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
  A1, \\field Room Air Temperature Pattern Constant Gradient Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in Schedule Name
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
      \\type real
  N3, \\field Return Air Offset
      \\note = (Tleaving - Mean Air Temp )
      \\units deltaC
      \\type real
  N4, \\field Exhaust Air Offset
      \\note = (Texhaust - Mean Air Temp) deg C
      \\units deltaC
      \\type real
  N5; \\field Temperature Gradient
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real

RoomAir:TemperaturePattern:TwoGradient,
      \\memo Used to model room air with two temperature gradients in the vertical direction.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
  A1, \\field Room Air Temperature Pattern Two Gradient Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in Schedule Name
      \\type integer
      \\required-field
  N2, \\field Thermostat Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N3, \\field Return Air Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N4, \\field Exhaust Air Height
      \\note = Distance from floor of zone
      \\units m
      \\type real
  N5, \\field Temperature Gradient Lower Bound
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real
  N6, \\field Temperature Gradient Upper  Bound
      \\note Slope of temperature change in vertical direction
      \\units K/m
      \\type real
  A2, \\field Gradient Interpolation Mode
      \\type choice
      \\key OutdoorDryBulbTemperature
      \\key ZoneDryBulbTemperature
      \\key ZoneAndOutdoorTemperatureDifference
      \\key SensibleCoolingLoad
      \\key SensibleHeatingLoad
  N7, \\field Upper Temperature Bound
      \\units C
      \\type real
  N8, \\field Lower Temperature Bound
      \\units C
      \\type real
  N9, \\field Upper Heat Rate Bound
      \\units W
      \\type real
  N10; \\field Lower Heat Rate Bound
      \\units W
      \\type real

RoomAir:TemperaturePattern:NondimensionalHeight,
      \\memo Defines a distribution pattern for air temperatures relative to the current mean air
      \\memo temperature as a function of height. The height, referred to as Zeta, is nondimensional
      \\memo by normalizing with the zone ceiling height.
      \\memo Used in combination with RoomAir:TemperaturePattern:UserDefined.
      \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note this value should appear in as a schedule value
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
      \\type real
  N3, \\field Return Air Offset
      \\note = (Temp leaving - Mean Air Temp ) deg C
      \\units deltaC
      \\type real
  N4, \\field Exhaust Air Offset
      \\note = (Temp exhaust - Mean Air Temp) deg C
      \\units deltaC
      \\type real
      \\note the remaining fields have pairs that describe the relative
      \\note temperature pattern in the vertical direction of a zone
      \\note Zeta is the nondimensional height (in z-direction). on [0..1]
      \\note DeltaTai =  (Tai - MAT) in units of deg. C
      \\note relative deg C on [-10.0 .. 20.0 ]
  N5, \\field Pair 1 Zeta Nondimensional Height
      \\begin-extensible
      \\type real
      \\required-field
  N6, \\field Pair 1 Delta Adjacent Air Temperature
      \\type real
      \\required-field
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N7, \\field Pair 2 Zeta Nondimensional Height
      \\type real
      \\required-field
  N8, \\field Pair 2 Delta Adjacent Air Temperature
      \\type real
      \\required-field
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N9, \\field Pair 3 Zeta Nondimensional Height
      \\type real
  N10,\\field Pair 3 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N11,\\field Pair 4 Zeta Nondimensional Height
      \\type real
  N12,\\field Pair 4 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N13,\\field Pair 5 Zeta Nondimensional Height
      \\type real
  N14,\\field Pair 5 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N15,\\field Pair 6 Zeta Nondimensional Height
      \\type real
  N16,\\field Pair 6 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N17,\\field Pair 7 Zeta Nondimensional Height
      \\type real
  N18,\\field Pair 7 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N19,\\field Pair 8 Zeta Nondimensional Height
      \\type real
  N20,\\field Pair 8 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N21,\\field Pair 9 Zeta Nondimensional Height
      \\type real
  N22,\\field Pair 9 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N23,\\field Pair 10 Zeta Nondimensional Height
      \\type real
  N24,\\field Pair 10 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N25,\\field Pair 11 Zeta Nondimensional Height
      \\type real
  N26,\\field Pair 11 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N27,\\field Pair 12 Zeta Nondimensional Height
      \\type real
  N28,\\field Pair 12 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N29,\\field Pair 13 Zeta Nondimensional Height
      \\type real
  N30,\\field Pair 13 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N31,\\field Pair 14 Zeta Nondimensional Height
      \\type real
  N32,\\field Pair 14 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N33,\\field Pair 15 Zeta Nondimensional Height
      \\type real
  N34,\\field Pair 15 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N35,\\field Pair 16 Zeta Nondimensional Height
      \\type real
  N36,\\field Pair 16 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N37,\\field Pair 17 Zeta Nondimensional Height
      \\type real
  N38,\\field Pair 17 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N39,\\field Pair 18 Zeta Nondimensional Height
      \\type real
  N40,\\field Pair 18 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0
  N41,\\field Pair 19 Zeta Nondimensional Height
      \\type real
  N42;\\field Pair 19 Delta Adjacent Air Temperature
      \\type real
      \\units deltaC
      \\minimum -10.0
      \\maximum 20.0

RoomAir:TemperaturePattern:SurfaceMapping,
      \\memo Defines a distribution pattern for the air temperatures adjacent to individual surfaces.
      \\memo This allows controlling the adjacent air temperature on a surface-by-surface basis
      \\memo rather than by height. This allows modeling different adjacent air temperatures on
      \\memo the opposite sides of the zone. Used in combination with
      \\memo RoomAir:TemperaturePattern:UserDefined.
      \\extensible:2 - repeat last two fields remembering to remove ; from "inner" fields.
  A1, \\field Name
      \\required-field
      \\type alpha
  N1, \\field Control Integer for Pattern Control Schedule Name
      \\note reference this entry in schedule
      \\type integer
      \\required-field
  N2, \\field Thermostat Offset
      \\note = (Temp at thermostat- Mean Air Temp)
      \\units deltaC
  N3, \\field Return Air Offset
      \\note = (Tleaving - Mean Air Temp ) deg C
      \\units deltaC
  N4, \\field Exhaust Air Offset
      \\note = (Texhaust - Mean Air Temp) deg C
      \\units deltaC
  A2, \\field Surface Name Pair 1
      \\begin-extensible
      \\required-field
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N5, \\field Delta Adjacent Air Temperature Pair 1
      \\required-field
      \\type real
      \\units deltaC
  A3, \\field Surface Name Pair 2
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N6, \\field Delta Adjacent Air Temperature Pair 2
      \\type real
      \\units deltaC
  A4, \\field Surface Name Pair 3
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N7, \\field Delta Adjacent Air Temperature Pair 3
      \\type real
      \\units deltaC
  A5, \\field Surface Name Pair 4
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N8, \\field Delta Adjacent Air Temperature Pair 4
      \\type real
      \\units deltaC
  A6, \\field Surface Name Pair 5
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N9, \\field Delta Adjacent Air Temperature Pair 5
      \\type real
      \\units deltaC
  A7, \\field Surface Name Pair 6
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N10,\\field Delta Adjacent Air Temperature Pair 6
      \\type real
      \\units deltaC
  A8, \\field Surface Name Pair 7
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N11,\\field Delta Adjacent Air Temperature Pair 7
      \\type real
      \\units deltaC
  A9, \\field Surface Name Pair 8
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N12,\\field Delta Adjacent Air Temperature Pair 8
      \\type real
      \\units deltaC
  A10,\\field Surface Name Pair 9
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N13,\\field Delta Adjacent Air Temperature Pair 9
      \\type real
      \\units deltaC
  A11,\\field Surface Name Pair 10
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N14,\\field Delta Adjacent Air Temperature Pair 10
      \\type real
      \\units deltaC
  A12,\\field Surface Name Pair 11
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N15,\\field Delta Adjacent Air Temperature Pair 11
      \\type real
      \\units deltaC
  A13,\\field Surface Name Pair 12
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N16,\\field Delta Adjacent Air Temperature Pair 12
      \\type real
      \\units deltaC
  A14,\\field Surface Name Pair 13
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N17,\\field Delta Adjacent Air Temperature Pair 13
      \\type real
      \\units deltaC
  A15,\\field Surface Name Pair 14
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N18,\\field Delta Adjacent Air Temperature Pair 14
      \\type real
      \\units deltaC
  A16,\\field Surface Name Pair 15
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N19,\\field Delta Adjacent Air Temperature Pair 15
      \\type real
      \\units deltaC
  A17,\\field Surface Name Pair 16
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N20,\\field Delta Adjacent Air Temperature Pair 16
      \\type real
      \\units deltaC
  A18,\\field Surface Name Pair 17
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N21,\\field Delta Adjacent Air Temperature Pair 17
      \\type real
      \\units deltaC
  A19,\\field Surface Name Pair 18
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N22,\\field Delta Adjacent Air Temperature Pair 18
      \\type real
      \\units deltaC
  A20,\\field Surface Name Pair 19
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N23,\\field Delta Adjacent Air Temperature Pair 19
      \\type real
      \\units deltaC
  A21,\\field Surface Name Pair 20
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N24,\\field Delta Adjacent Air Temperature Pair 20
      \\type real
      \\units deltaC
  A22,\\field Surface Name Pair 21
      \\type object-list
      \\object-list AllHeatTranSurfNames
  N25;\\field Delta Adjacent Air Temperature Pair 21
      \\type real
      \\units deltaC

RoomAir:Node,
      \\memo Define an air node for some types of nodal room air models
  A1, \\field Name
      \\type alpha
      \\reference RoomAirNodes
  A2, \\field Node Type
      \\required-field
      \\type choice
      \\key Inlet
      \\key Floor
      \\key Control
      \\key Ceiling
      \\key MundtRoom
      \\key Return
  A3, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  N1, \\field Height of Nodal Control Volume Center
      \\required-field
      \\type real
      \\units m
  A4 , \\field Surface 1 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A5 , \\field Surface 2 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A6 , \\field Surface 3 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A7 , \\field Surface 4 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A8 , \\field Surface 5 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A9 , \\field Surface 6 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A10, \\field Surface 7 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A11, \\field Surface 8 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A12, \\field Surface 9 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A13, \\field Surface 10 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A14, \\field Surface 11 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A15, \\field Surface 12 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A16, \\field Surface 13 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A17, \\field Surface 14 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A18, \\field Surface 15 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A19, \\field Surface 16 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A20, \\field Surface 17 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A21, \\field Surface 18 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A22, \\field Surface 19 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A23, \\field Surface 20 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A24; \\field Surface 21 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames

RoomAirSettings:OneNodeDisplacementVentilation,
       \\memo The Mundt model for displacement ventilation
  A1 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Fraction of Convective Internal Loads Added to Floor Air
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  N2 ; \\field Fraction of Infiltration Internal Loads Added to Floor Air
       \\type real
       \\minimum 0.0
       \\maximum 1.0

RoomAirSettings:ThreeNodeDisplacementVentilation,
       \\memo The UCSD model for Displacement Ventilation
       \\min-fields 6
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A2 , \\field Gain Distribution Schedule Name
       \\note Distribution of the convective heat gains between the occupied and mixed zones.
       \\note 0<= Accepted Value <= 1.
       \\note In the DV model 1 means all convective gains in the lower layer.
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Number of Plumes per Occupant
       \\note Used only in the UCSD displacement ventilation model.
       \\note Effective number of separate plumes per occupant in the occupied zone.
       \\note Plumes that merge together in the occupied zone count as one.
       \\type real
       \\minimum> 0.0
       \\default 1.0
  N2 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N3 , \\field Comfort Height
       \\note Height at which air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N4 ; \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between predicted upper and lower layer
       \\note temperatures above which DV auxiliary outputs are calculated.
       \\note These outputs are 'DV Transition Height', 'DV Fraction Min Recommended Flow Rate'
       \\note 'DV Average Temp Gradient' and 'DV Maximum Temp Gradient'. They
       \\note are set to negative values when the temperature difference is less than the
       \\note threshold and the output 'DV Zone Is Mixed' is set to 1
       \\units deltaC
       \\type real
       \\minimum 0.0
       \\default 0.4

RoomAirSettings:CrossVentilation,
       \\memo This UCSD Cross Ventilation Room Air Model provides a simple model for heat transfer
       \\memo and vertical temperature profile prediction in cross ventilated rooms. The model
       \\memo distinguishes two regions in the room, the main jet region and the recirculations,
       \\memo and predicts characteristic airflow velocities and average air temperatures.
       \\memo Used with RoomAirModelType = CrossVentilation.
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A2 , \\field Gain Distribution Schedule Name
       \\note Distribution of the convective heat gains between the jet and recirculation zones.
       \\note 0<= Accepted Value <= 1.
       \\note In the CV model 1 means all convective gains in the jet region.
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A3 ; \\field Airflow Region Used for Thermal Comfort Evaluation
       \\note Required field whenever thermal comfort is predicted
       \\note defines Air temperature and Airflow velocity that will be used in the Fanger model
       \\note conditions must refer to one of the two regions: jet or recirculation
       \\type choice
       \\key Jet
       \\key Recirculation

RoomAirSettings:UnderFloorAirDistributionInterior,
       \\memo This Room Air Model is applicable to interior spaces that are served by an underfloor
       \\memo air distribution system. The dominant sources of heat gain should be from people,
       \\memo equipment, and other localized sources located in the occupied part of the room.
       \\memo The model should be used with caution in zones which have large heat gains or losses
       \\memo through exterior walls or windows or which have considerable direct solar gain.
       \\memo Used with RoomAirModelType = UnderFloorAirDistributionInterior.
       \\min-fields 15
  A1 , \\field Zone Name
       \\note Name of Zone with underfloor air distribution
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Number of Diffusers
       \\note Total number of diffusers in this zone
       \\type real
       \\minimum> 0.0
       \\autocalculatable
       \\default autocalculate
  N2 , \\field Power per Plume
       \\type real
       \\minimum 0.0
       \\units W
       \\autocalculatable
       \\default autocalculate
  N3 , \\field Design Effective Area of Diffuser
       \\type real
       \\units m2
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N4 , \\field Diffuser Slot Angle from Vertical
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum 90.
       \\autocalculatable
       \\default Autocalculate
  N5 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.2
  N6 , \\field Comfort Height
       \\note Height at which air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N7 , \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between predicted upper and lower layer
       \\note temperatures above which UFAD auxiliary outputs are calculated.
       \\note These outputs are 'UF Transition Height' and 'UF Average Temp Gradient'. They
       \\note are set to zero values when the temperature difference is less than the
       \\note threshold and the output 'UF Zone Is Mixed' is set to 1
       \\units deltaC
       \\type real
       \\minimum 0.0
       \\default 0.4
  A2 , \\field Floor Diffuser Type
       \\type choice
       \\key Custom
       \\key Swirl
       \\key VariableArea
       \\key HorizontalSwirl
       \\key LinearBarGrille
       \\default Swirl
  N8 , \\field Transition Height
       \\note user-specified height above floor of boundary between occupied and upper subzones
       \\type real
       \\units m
       \\minimum> 0.0
       \\autocalculatable
       \\default 1.7
  N9,  \\field Coefficient A
       \\note Coefficient A in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N10, \\field Coefficient B
       \\note Coefficient B in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N11, \\field Coefficient C
       \\note Coefficient C in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N12, \\field Coefficient D
       \\note Coefficient D in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N13; \\field Coefficient E
       \\note Coefficient E in Formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate

RoomAirSettings:UnderFloorAirDistributionExterior,
       \\memo Applicable to exterior spaces that are served by an underfloor air distribution system.
       \\memo The dominant sources of heat gain should be from people, equipment, and other
       \\memo localized sources located in the occupied part of the room, as well as convective gain
       \\memo  coming from a warm window. Used with RoomAirModelType = CrossVentilation.
  \\min-fields 15
  A1 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Number of Diffusers per Zone
       \\type real
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N2 , \\field Power per Plume
       \\type real
       \\minimum 0.0
       \\units W
       \\autocalculatable
       \\default autocalculate
  N3 , \\field Design Effective Area of Diffuser
       \\type real
       \\units m2
       \\minimum> 0.0
       \\autocalculatable
       \\default Autocalculate
  N4 , \\field Diffuser Slot Angle from Vertical
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum 90.
       \\autocalculatable
       \\default autocalculate
  N5 , \\field Thermostat Height
       \\note Height of thermostat/temperature control sensor above floor
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.2
  N6 , \\field Comfort Height
       \\note Height at which Air temperature is calculated for comfort purposes
       \\units m
       \\type real
       \\minimum> 0.0
       \\default 1.1
  N7 , \\field Temperature Difference Threshold for Reporting
       \\note Minimum temperature difference between upper and lower layer
       \\note temperatures above which UFAD auxiliary outputs are calculated.
       \\note These outputs are 'UF Transition Height' and 'UF Average Temp Gradient'. They
       \\note are set to zero values when the temperature difference is less than the
       \\note threshold and the output 'UF Zone Is Mixed' is set to 1
       \\units deltaC
       \\type real
       \\minimum 0.0
       \\default 0.4
  A2 , \\field Floor Diffuser Type
       \\type choice
       \\key Custom
       \\key Swirl
       \\key VariableArea
       \\key HorizontalSwirl
       \\key LinearBarGrille
       \\default Swirl
  N8 , \\field Transition Height
       \\note User-specified height above floor of boundary between occupied and upper subzones
       \\type real
       \\units m
       \\minimum> 0.0
       \\autocalculatable
       \\default 1.7
  N9,  \\field Coefficient A in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N10, \\field Coefficient B in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N11, \\field Coefficient C in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N12, \\field Coefficient D in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate
  N13; \\field Coefficient E in formula Kc = A*Gamma**B + C + D*Gamma + E*Gamma**2
       \\note Kc is the fraction of the total zone load attributable to the lower subzone
       \\type real
       \\autocalculatable
       \\default Autocalculate

RoomAir:Node:AirflowNetwork,
      \\memo define an air node for some types of nodal air models
  A1, \\field Name
      \\type alpha
      \\reference RoomAirflowNetworkNodes
  A2, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  N1, \\field Fraction of Zone Air Volume
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  A3, \\field RoomAir:Node:AirflowNetwork:AdjacentSurfaceList Name
      \\type object-list
      \\object-list RoomAirNodeSurfaceLists
  A4, \\field RoomAir:Node:AirflowNetwork:InternalGains Name
      \\type object-list
      \\object-list RoomAirNodeGains
  A5; \\field RoomAir:Node:AirflowNetwork:HVACEquipment Name
      \\type object-list
      \\object-list RoomAirNodeHVACEquipment

RoomAir:Node:AirflowNetwork:AdjacentSurfaceList,
       \\extensible:1
       \\min-fields 2
  A1,  \\field Name
       \\type alpha
       \\reference RoomAirNodeSurfaceLists
  A2 , \\field Surface 1 Name
       \\begin-extensible
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A3 , \\field Surface 2 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A4 , \\field Surface 3 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A5 , \\field Surface 4 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A6 , \\field Surface 5 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A7 , \\field Surface 6 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A8, \\field Surface 7 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A9, \\field Surface 8 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A10, \\field Surface 9 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A11, \\field Surface 10 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A12, \\field Surface 11 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A13, \\field Surface 12 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A14, \\field Surface 13 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A15, \\field Surface 14 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A16, \\field Surface 15 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A17, \\field Surface 16 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A18, \\field Surface 17 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A19, \\field Surface 18 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A20, \\field Surface 19 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A21, \\field Surface 20 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  A22; \\field Surface 21 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames

RoomAir:Node:AirflowNetwork:InternalGains,
      \\extensible:3
      \\min-fields 4
      \\memo define the internal gains that are associated with one particular RoomAir:Node
  A1, \\field Name
      \\type alpha
      \\reference RoomAirNodeGains
  A2, \\field Internal Gain Object 1 Type
      \\begin-extensible
      \\type choice
      \\key People
      \\key Lights
      \\key ElectricEquipment
      \\key GasEquipment
      \\key HotWaterEquipment
      \\key SteamEquipment
      \\key OtherEquipment
      \\key ZoneBaseboard:OutdoorTemperatureControlled
      \\key ZoneContaminantSourceAndSink:CarbonDioxide
      \\key WaterUse:Equipment
      \\key DaylightingDevice:Tubular
      \\key WaterHeater:Mixed
      \\key WaterHeater:Stratified
      \\key ThermalStorage:ChilledWater:Mixed
      \\key ThermalStorage:ChilledWater:Stratified
      \\key Generator:FuelCell
      \\key Generator:MicroCHP
      \\key ElectricLoadCenter:Transformer
      \\key ElectricLoadCenter:Inverter:Simple
      \\key ElectricLoadCenter:Inverter:FunctionOfPower
      \\key ElectricLoadCenter:Inverter:LookUpTable
      \\key ElectricLoadCenter:Storage:LiIonNMCBattery
      \\key ElectricLoadCenter:Storage:Battery
      \\key ElectricLoadCenter:Storage:Simple
      \\key ElectricLoadCenter:Storage:Converter
      \\key Pipe:Indoor
      \\key Refrigeration:Case
      \\key Refrigeration:CompressorRack
      \\key Refrigeration:System:Condenser:AirCooled
      \\key Refrigeration:TranscriticalSystem:GasCooler:AirCooled
      \\key Refrigeration:System:SuctionPipe
      \\key Refrigeration:TranscriticalSystem:SuctionPipeMT
      \\key Refrigeration:TranscriticalSystem:SuctionPipeLT
      \\key Refrigeration:SecondarySystem:Receiver
      \\key Refrigeration:SecondarySystem:Pipe
      \\key Refrigeration:WalkIn
      \\key Pump:VariableSpeed
      \\key Pump:ConstantSpeed
      \\key Pump:VariableSpeed:Condensate
      \\key HeaderedPumps:VariableSpeed
      \\key HeaderedPumps:ConstantSpeed
      \\key ZoneContaminantSourceAndSink:GenericContaminant
      \\key PlantComponent:UserDefined
      \\key Coil:UserDefined
      \\key ZoneHVAC:ForcedAir:UserDefined
      \\key AirTerminal:SingleDuct:UserDefined
  A3, \\field Internal Gain Object 1 Name
      \\type alpha
  N1, \\field Fraction of Gains to Node 1
      \\type real
      \\minimum 0.0
      \\maximum 1.0
      \\note fraction applies to sensible, latent, carbon dioxide, and generic contaminant gains or losses
  A4, \\field Internal Gain Object 2 Type
      \\type choice
      \\key People
      \\key Lights
      \\key ElectricEquipment
      \\key GasEquipment
      \\key HotWaterEquipment
      \\key SteamEquipment
      \\key OtherEquipment
      \\key ZoneBaseboard:OutdoorTemperatureControlled
      \\key ZoneContaminantSourceAndSink:CarbonDioxide
      \\key WaterUse:Equipment
      \\key DaylightingDevice:Tubular
      \\key WaterHeater:Mixed
      \\key WaterHeater:Stratified
      \\key ThermalStorage:ChilledWater:Mixed
      \\key ThermalStorage:ChilledWater:Stratified
      \\key Generator:FuelCell
      \\key Generator:MicroCHP
      \\key ElectricLoadCenter:Transformer
      \\key ElectricLoadCenter:Inverter:Simple
      \\key ElectricLoadCenter:Inverter:FunctionOfPower
      \\key ElectricLoadCenter:Inverter:LookUpTable
      \\key ElectricLoadCenter:Storage:LiIonNMCBattery
      \\key ElectricLoadCenter:Storage:Battery
      \\key ElectricLoadCenter:Storage:Simple
      \\key ElectricLoadCenter:Storage:Converter
      \\key Pipe:Indoor
      \\key Refrigeration:Case
      \\key Refrigeration:CompressorRack
      \\key Refrigeration:System:Condenser:AirCooled
      \\key Refrigeration:TranscriticalSystem:GasCooler:AirCooled
      \\key Refrigeration:System:SuctionPipe
      \\key Refrigeration:TranscriticalSystem:SuctionPipeMT
      \\key Refrigeration:TranscriticalSystem:SuctionPipeLT
      \\key Refrigeration:SecondarySystem:Receiver
      \\key Refrigeration:SecondarySystem:Pipe
      \\key Refrigeration:WalkIn
      \\key Pump:VariableSpeed
      \\key Pump:ConstantSpeed
      \\key Pump:VariableSpeed:Condensate
      \\key HeaderedPumps:VariableSpeed
      \\key HeaderedPumps:ConstantSpeed
      \\key ZoneContaminantSourceAndSink:GenericContaminant
      \\key PlantComponent:UserDefined
      \\key Coil:UserDefined
      \\key ZoneHVAC:ForcedAir:UserDefined
      \\key AirTerminal:SingleDuct:UserDefined
  A5, \\field Internal Gain Object 2 Name
      \\type alpha
  N2, \\field Fraction of Gains to Node 2
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  A6, \\field Internal Gain Object 3 Type
      \\type choice
      \\key People
      \\key Lights
      \\key ElectricEquipment
      \\key GasEquipment
      \\key HotWaterEquipment
      \\key SteamEquipment
      \\key OtherEquipment
      \\key ZoneBaseboard:OutdoorTemperatureControlled
      \\key ZoneContaminantSourceAndSink:CarbonDioxide
      \\key WaterUse:Equipment
      \\key DaylightingDevice:Tubular
      \\key WaterHeater:Mixed
      \\key WaterHeater:Stratified
      \\key ThermalStorage:ChilledWater:Mixed
      \\key ThermalStorage:ChilledWater:Stratified
      \\key Generator:FuelCell
      \\key Generator:MicroCHP
      \\key ElectricLoadCenter:Transformer
      \\key ElectricLoadCenter:Inverter:Simple
      \\key ElectricLoadCenter:Inverter:FunctionOfPower
      \\key ElectricLoadCenter:Inverter:LookUpTable
      \\key ElectricLoadCenter:Storage:LiIonNMCBattery
      \\key ElectricLoadCenter:Storage:Battery
      \\key ElectricLoadCenter:Storage:Simple
      \\key ElectricLoadCenter:Storage:Converter
      \\key Pipe:Indoor
      \\key Refrigeration:Case
      \\key Refrigeration:CompressorRack
      \\key Refrigeration:System:Condenser:AirCooled
      \\key Refrigeration:TranscriticalSystem:GasCooler:AirCooled
      \\key Refrigeration:System:SuctionPipe
      \\key Refrigeration:TranscriticalSystem:SuctionPipeMT
      \\key Refrigeration:TranscriticalSystem:SuctionPipeLT
      \\key Refrigeration:SecondarySystem:Receiver
      \\key Refrigeration:SecondarySystem:Pipe
      \\key Refrigeration:WalkIn
      \\key Pump:VariableSpeed
      \\key Pump:ConstantSpeed
      \\key Pump:VariableSpeed:Condensate
      \\key HeaderedPumps:VariableSpeed
      \\key HeaderedPumps:ConstantSpeed
      \\key ZoneContaminantSourceAndSink:GenericContaminant
      \\key PlantComponent:UserDefined
      \\key Coil:UserDefined
      \\key ZoneHVAC:ForcedAir:UserDefined
      \\key AirTerminal:SingleDuct:UserDefined
  A7, \\field Internal Gain Object 3 Name
      \\type alpha
  N3; \\field Fraction of Gains to Node 3
      \\type real
      \\minimum 0.0
      \\maximum 1.0

RoomAir:Node:AirflowNetwork:HVACEquipment,
      \\extensible:4
      \\memo define the zone equipment associated with one particular RoomAir:Node
  A1, \\field Name
      \\type alpha
      \\reference RoomAirNodeHVACEquipment
  A2, \\field ZoneHVAC or Air Terminal Equipment Object Type 1
      \\begin-extensible
      \\type choice
      \\key ZoneHVAC:TerminalUnit:VariableRefrigerantFlow
      \\key ZoneHVAC:EnergyRecoveryVentilator
      \\key ZoneHVAC:FourPipeFanCoil
      \\key ZoneHVAC:OutdoorAirUnit
      \\key ZoneHVAC:PackagedTerminalAirConditioner
      \\key ZoneHVAC:PackagedTerminalHeatPump
      \\key ZoneHVAC:UnitHeater
      \\key ZoneHVAC:UnitVentilator
      \\key ZoneHVAC:VentilatedSlab
      \\key ZoneHVAC:WaterToAirHeatPump
      \\key ZoneHVAC:WindowAirConditioner
      \\key ZoneHVAC:Baseboard:RadiantConvective:Electric
      \\key ZoneHVAC:Baseboard:RadiantConvective:Water
      \\key ZoneHVAC:Baseboard:RadiantConvective:Steam
      \\key ZoneHVAC:Baseboard:Convective:Electric
      \\key ZoneHVAC:Baseboard:Convective:Water
      \\key ZoneHVAC:HighTemperatureRadiant
      \\key ZoneHVAC:Dehumidifier:DX
      \\key ZoneHVAC:IdealLoadsAirSystem
      \\key ZoneHVAC:RefrigerationChillerSet
      \\key Fan:ZoneExhaust
      \\key WaterHeater:HeatPump
      \\key AirTerminal:DualDuct:ConstantVolume
      \\key AirTerminal:DualDuct:VAV
      \\key AirTerminal:SingleDuct:ConstantVolume:Reheat
      \\key AirTerminal:SingleDuct:ConstantVolume:NoReheat
      \\key AirTerminal:SingleDuct:VAV:Reheat
      \\key AirTerminal:SingleDuct:VAV:NoReheat
      \\key AirTerminal:SingleDuct:SeriesPIU:Reheat
      \\key AirTerminal:SingleDuct:ParallelPIU:Reheat
      \\key AirTerminal:SingleDuct:ConstantVolume:FourPipeInduction
      \\key AirTerminal:SingleDuct:VAV:Reheat:VariableSpeedFan
      \\key AirTerminal:SingleDuct:VAV:HeatAndCool:Reheat
      \\key AirTerminal:SingleDuct:VAV:HeatAndCool:NoReheat
      \\key AirTerminal:SingleDuct:ConstantVolume:CooledBeam
      \\key AirTerminal:DualDuct:VAV:OutdoorAir
      \\key AirLoopHVACReturnAir
  A3, \\field ZoneHVAC or Air Terminal Equipment Object Name 1
      \\type alpha
      \\note for object type AirLoopHVACReturnAir, then enter zone return air node name
  N1, \\field Fraction of Output or Supply Air from HVAC Equipment 1
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  N2, \\field Fraction of Input or Return Air to HVAC Equipment 1
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  A4, \\field ZoneHVAC or Air Terminal Equipment Object Type 2
      \\type choice
      \\key ZoneHVAC:TerminalUnit:VariableRefrigerantFlow
      \\key ZoneHVAC:EnergyRecoveryVentilator
      \\key ZoneHVAC:FourPipeFanCoil
      \\key ZoneHVAC:OutdoorAirUnit
      \\key ZoneHVAC:PackagedTerminalAirConditioner
      \\key ZoneHVAC:PackagedTerminalHeatPump
      \\key ZoneHVAC:UnitHeater
      \\key ZoneHVAC:UnitVentilator
      \\key ZoneHVAC:VentilatedSlab
      \\key ZoneHVAC:WaterToAirHeatPump
      \\key ZoneHVAC:WindowAirConditioner
      \\key ZoneHVAC:Baseboard:RadiantConvective:Electric
      \\key ZoneHVAC:Baseboard:RadiantConvective:Water
      \\key ZoneHVAC:Baseboard:RadiantConvective:Steam
      \\key ZoneHVAC:Baseboard:Convective:Electric
      \\key ZoneHVAC:Baseboard:Convective:Water
      \\key ZoneHVAC:HighTemperatureRadiant
      \\key ZoneHVAC:Dehumidifier:DX
      \\key ZoneHVAC:IdealLoadsAirSystem
      \\key ZoneHVAC:RefrigerationChillerSet
      \\key Fan:ZoneExhaust
      \\key WaterHeater:HeatPump
      \\key AirTerminal:DualDuct:ConstantVolume
      \\key AirTerminal:DualDuct:VAV
      \\key AirTerminal:SingleDuct:ConstantVolume:Reheat
      \\key AirTerminal:SingleDuct:VAV:Reheat
      \\key AirTerminal:SingleDuct:VAV:NoReheat
      \\key AirTerminal:SingleDuct:SeriesPIU:Reheat
      \\key AirTerminal:SingleDuct:ParallelPIU:Reheat
      \\key AirTerminal:SingleDuct:ConstantVolume:FourPipeInduction
      \\key AirTerminal:SingleDuct:VAV:Reheat:VariableSpeedFan
      \\key AirTerminal:SingleDuct:VAV:HeatAndCool:Reheat
      \\key AirTerminal:SingleDuct:VAV:HeatAndCool:NoReheat
      \\key AirTerminal:SingleDuct:ConstantVolume:CooledBeam
      \\key AirTerminal:DualDuct:VAV:OutdoorAir
  A5, \\field ZoneHVAC or Air Terminal Equipment Object Name 2
      \\type alpha
  N3, \\field Fraction of Output or Supply Air from HVAC Equipment 2
      \\type real
      \\minimum 0.0
      \\maximum 1.0
  N4; \\field Fraction of Input or Return Air to HVAC Equipment 2
      \\type real
      \\minimum 0.0
      \\maximum 1.0

RoomAirSettings:AirflowNetwork,
       \\extensible:1
       \\memo RoomAir modeling using Airflow pressure network solver
       \\min-fields 5
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\note Name of Zone being described. Any existing zone name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Control Point RoomAirflowNetwork:Node Name
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
  A4 , \\field RoomAirflowNetwork:Node Name 1
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
       \\begin-extensible
  A5 , \\field RoomAirflowNetwork:Node Name 2
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
  A6 , \\field RoomAirflowNetwork:Node Name 3
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
  A7 , \\field RoomAirflowNetwork:Node Name 4
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
  A8 , \\field RoomAirflowNetwork:Node Name 5
       \\type object-list
       \\object-list RoomAirflowNetworkNodes
  A9 ; \\field RoomAirflowNetwork:Node Name 6
       \\type object-list
       \\object-list RoomAirflowNetworkNodes

\\group Internal Gains

People,
   \\memo Sets internal gains and contaminant rates for occupants in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference PeopleNames
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Number of People Schedule Name
       \\required-field
       \\type object-list
       \\note units in schedule should be fraction applied to number of people (0.0 - 1.0)
       \\object-list ScheduleNames
  A4 , \\field Number of People Calculation Method
       \\note The entered calculation method is used to create the maximum number of people
       \\note for this set of attributes (i.e. sensible fraction, schedule, etc)
       \\note Choices: People -- simply enter number of occupants.
       \\note People per Floor Area -- enter the number to apply. Value * Floor Area = Number of people
       \\note Floor Area per Person -- enter the number to apply. Floor Area / Value = Number of people
       \\type choice
       \\key People
       \\key People/Area
       \\key Area/Person
       \\default People
  N1 , \\field Number of People
       \\type real
       \\minimum 0
  N2 , \\field People per Floor Area
       \\type real
       \\minimum 0
       \\units person/m2
  N3 , \\field Floor Area per Person
       \\type real
       \\minimum 0
       \\units m2/person
  N4 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.3
       \\note This is radiant fraction of the sensible heat released by people in a zone. This value will be
       \\note multiplied by the total sensible heat released by people yields the amount of long wavelength
       \\note radiation gain from people in a zone. Default value is 0.30.
  N5,  \\field Sensible Heat Fraction
       \\note if input, overrides program calculated sensible/latent split
       \\autocalculatable
       \\default autocalculate
       \\minimum 0.0
       \\maximum 1.0
  A5 , \\field Activity Level Schedule Name
       \\required-field
       \\note Note that W has to be converted to mets in TC routine
       \\type object-list
       \\note units in schedule are W/person
       \\object-list ScheduleNames
  N6 , \\field Carbon Dioxide Generation Rate
       \\note CO2 generation rate per unit of activity level.
       \\type real
       \\units m3/s-W
       \\default 3.82E-8
       \\minimum 0.0
       \\maximum 3.82E-7
       \\note The default value is obtained from ASHRAE Std 62.1 at 0.0084 cfm/met/person over
       \\note the general adult population.
  A6 , \\field Enable ASHRAE 55 Comfort Warnings
       \\type choice
       \\key Yes
       \\key No
       \\default No
  A7 , \\field Mean Radiant Temperature Calculation Type
       \\note optional (only required for thermal comfort runs)
       \\type choice
       \\key ZoneAveraged
       \\key SurfaceWeighted
       \\key AngleFactor
       \\default ZoneAveraged
  A8 , \\field Surface Name/Angle Factor List Name
       \\type object-list
       \\object-list AllHeatTranAngFacNames
       \\note optional (only required for runs of thermal comfort models: Fanger, Pierce, KSU, CoolingEffectASH55 and AnkleDraftASH55)
  A9 , \\field Work Efficiency Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule are 0.0 to 1.0
       \\note optional (only required for runs of thermal comfort models: Fanger, Pierce, KSU, CoolingEffectASH55 and AnkleDraftASH55)
  A10, \\field Clothing Insulation Calculation Method
       \\type choice
       \\key ClothingInsulationSchedule
       \\key DynamicClothingModelASHRAE55
       \\key CalculationMethodSchedule
       \\default ClothingInsulationSchedule
  A11, \\field Clothing Insulation Calculation Method Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note a schedule value of 1 for the Scheduled method, and 2 for the DynamicClothingModelASHRAE55 method
  A12, \\field Clothing Insulation Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note use "Clo" from ASHRAE or Thermal Comfort guides
       \\note optional (only required for runs of thermal comfort models: Fanger, Pierce, KSU, CoolingEffectASH55 and AnkleDraftASH55)
  A13, \\field Air Velocity Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note units in the schedule are m/s
       \\note optional (only required for runs of thermal comfort models: Fanger, Pierce, KSU, CoolingEffectASH55 and AnkleDraftASH55)
  A14, \\field Thermal Comfort Model 1 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (only needed for people thermal comfort results reporting)
  A15, \\field Thermal Comfort Model 2 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (second type of thermal comfort model and results reporting)
  A16, \\field Thermal Comfort Model 3 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (third thermal comfort model and report type)
  A17, \\field Thermal Comfort Model 4 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (fourth thermal comfort model and report type)
  A18, \\field Thermal Comfort Model 5 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (fifth thermal comfort model and report type)
  A19, \\field Thermal Comfort Model 6 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (sixth thermal comfort model and report type)
  A20, \\field Thermal Comfort Model 7 Type
       \\type choice
       \\key Fanger
       \\key Pierce
       \\key KSU
       \\key AdaptiveASH55
       \\key AdaptiveCEN15251
       \\key CoolingEffectASH55
       \\key AnkleDraftASH55
       \\note optional (seventh thermal comfort model and report type)
  A21; \\field Ankle Level Air Velocity Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note units in the schedule are m/s
       \\note this is the schedule of the air speed at the 0.1 m above the floor
       \\note optional (only required for runs of thermal comfort models AnkleDraftASH55)

ComfortViewFactorAngles,
       \\memo Used to specify radiant view factors for thermal comfort calculations.
       \\memo Note that the following angle factor fractions must sum up to 1.0
       \\extensible:2 - repeat last two fields, remembering to remove ; from "inner" fields.
       \\memo The number of surfaces can be expanded beyond 100, if necessary, by adding more
       \\memo groups to the end of the list.
  A1 , \\field Name
       \\type alpha
       \\reference AllHeatTranAngFacNames
  A2 , \\field Zone Name
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Surface 1 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N1 , \\field Angle Factor 1
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A4 , \\field Surface 2 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N2 , \\field Angle Factor 2
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A5 , \\field Surface 3 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N3 , \\field Angle Factor 3
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A6 , \\field Surface 4 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N4 , \\field Angle Factor 4
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A7 , \\field Surface 5 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N5 , \\field Angle Factor 5
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A8 , \\field Surface 6 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N6 , \\field Angle Factor 6
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A9 , \\field Surface 7 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N7 , \\field Angle Factor 7
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A10, \\field Surface 8 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N8 , \\field Angle Factor 8
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A11, \\field Surface 9 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N9 , \\field Angle Factor 9
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A12, \\field Surface 10 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N10, \\field Angle Factor 10
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A13, \\field Surface 11 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N11, \\field Angle Factor 11
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A14, \\field Surface 12 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N12, \\field Angle Factor 12
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A15, \\field Surface 13 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N13, \\field Angle Factor 13
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A16, \\field Surface 14 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N14, \\field Angle Factor 14
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A17, \\field Surface 15 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N15, \\field Angle Factor 15
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A18, \\field Surface 16 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N16, \\field Angle Factor 16
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A19, \\field Surface 17 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N17, \\field Angle Factor 17
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A20, \\field Surface 18 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N18, \\field Angle Factor 18
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A21, \\field Surface 19 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N19, \\field Angle Factor 19
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A22, \\field Surface 20 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N20, \\field Angle Factor 20
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A23, \\field Surface 21 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N21, \\field Angle Factor 21
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A24, \\field Surface 22 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N22, \\field Angle Factor 22
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A25, \\field Surface 23 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N23, \\field Angle Factor 23
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A26, \\field Surface 24 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N24, \\field Angle Factor 24
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A27, \\field Surface 25 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N25, \\field Angle Factor 25
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A28, \\field Surface 26 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N26, \\field Angle Factor 26
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A29, \\field Surface 27 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N27, \\field Angle Factor 27
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A30, \\field Surface 28 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N28, \\field Angle Factor 28
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A31, \\field Surface 29 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N29, \\field Angle Factor 29
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A32, \\field Surface 30 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N30, \\field Angle Factor 30
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A33, \\field Surface 31 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N31, \\field Angle Factor 31
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A34, \\field Surface 32 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N32, \\field Angle Factor 32
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A35, \\field Surface 33 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N33, \\field Angle Factor 33
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A36, \\field Surface 34 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N34, \\field Angle Factor 34
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A37, \\field Surface 35 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N35, \\field Angle Factor 35
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A38, \\field Surface 36 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N36, \\field Angle Factor 36
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A39, \\field Surface 37 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N37, \\field Angle Factor 37
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A40, \\field Surface 38 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N38, \\field Angle Factor 38
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A41, \\field Surface 39 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N39, \\field Angle Factor 39
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A42, \\field Surface 40 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N40, \\field Angle Factor 40
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A43, \\field Surface 41 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N41, \\field Angle Factor 41
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A44, \\field Surface 42 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N42, \\field Angle Factor 42
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A45, \\field Surface 43 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N43, \\field Angle Factor 43
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A46, \\field Surface 44 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N44, \\field Angle Factor 44
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A47, \\field Surface 45 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N45, \\field Angle Factor 45
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A48, \\field Surface 46 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N46, \\field Angle Factor 46
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A49, \\field Surface 47 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N47, \\field Angle Factor 47
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A50, \\field Surface 48 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N48, \\field Angle Factor 48
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A51, \\field Surface 49 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N49, \\field Angle Factor 49
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A52, \\field Surface 50 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N50, \\field Angle Factor 50
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A53, \\field Surface 51 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N51, \\field Angle Factor 51
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A54, \\field Surface 52 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N52, \\field Angle Factor 52
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A55, \\field Surface 53 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N53, \\field Angle Factor 53
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A56, \\field Surface 54 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N54, \\field Angle Factor 54
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A57, \\field Surface 55 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N55, \\field Angle Factor 55
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A58, \\field Surface 56 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N56, \\field Angle Factor 56
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A59, \\field Surface 57 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N57, \\field Angle Factor 57
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A60, \\field Surface 58 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N58, \\field Angle Factor 58
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A61, \\field Surface 59 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N59, \\field Angle Factor 59
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A62, \\field Surface 60 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N60, \\field Angle Factor 60
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A63, \\field Surface 61 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N61, \\field Angle Factor 61
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A64, \\field Surface 62 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N62, \\field Angle Factor 62
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A65, \\field Surface 63 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N63, \\field Angle Factor 63
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A66, \\field Surface 64 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N64, \\field Angle Factor 64
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A67, \\field Surface 65 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N65, \\field Angle Factor 65
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A68, \\field Surface 66 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N66, \\field Angle Factor 66
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A69, \\field Surface 67 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N67, \\field Angle Factor 67
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A70, \\field Surface 68 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N68, \\field Angle Factor 68
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A71, \\field Surface 69 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N69, \\field Angle Factor 69
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A72, \\field Surface 70 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N70, \\field Angle Factor 70
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A73, \\field Surface 71 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N71, \\field Angle Factor 71
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A74, \\field Surface 72 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N72, \\field Angle Factor 72
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A75, \\field Surface 73 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N73, \\field Angle Factor 73
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A76, \\field Surface 74 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N74, \\field Angle Factor 74
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A77, \\field Surface 75 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N75, \\field Angle Factor 75
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A78, \\field Surface 76 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N76, \\field Angle Factor 76
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A79, \\field Surface 77 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N77, \\field Angle Factor 77
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A80, \\field Surface 78 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N78, \\field Angle Factor 78
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A81, \\field Surface 79 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N79, \\field Angle Factor 79
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A82, \\field Surface 80 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N80, \\field Angle Factor 80
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A83, \\field Surface 81 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N81, \\field Angle Factor 81
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A84, \\field Surface 82 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N82, \\field Angle Factor 82
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A85, \\field Surface 83 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N83, \\field Angle Factor 83
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A86, \\field Surface 84 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N84, \\field Angle Factor 84
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A87, \\field Surface 85 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N85, \\field Angle Factor 85
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A88, \\field Surface 86 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N86, \\field Angle Factor 86
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A89, \\field Surface 87 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N87, \\field Angle Factor 87
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A90, \\field Surface 88 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N88, \\field Angle Factor 88
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A91, \\field Surface 89 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N89, \\field Angle Factor 89
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A92, \\field Surface 90 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N90, \\field Angle Factor 90
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A93, \\field Surface 91 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N91, \\field Angle Factor 91
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A94, \\field Surface 92 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N92, \\field Angle Factor 92
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A95, \\field Surface 93 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N93, \\field Angle Factor 93
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A96, \\field Surface 94 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N94, \\field Angle Factor 94
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A97, \\field Surface 95 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N95, \\field Angle Factor 95
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A98, \\field Surface 96 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N96, \\field Angle Factor 96
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A99, \\field Surface 97 Name
       \\type object-list
       \\object-list AllHeatTranSurfNames
  N97, \\field Angle Factor 97
       \\type real
       \\minimum 0.0
       \\maximum 1.0
  A100, \\field Surface 98 Name
        \\type object-list
        \\object-list AllHeatTranSurfNames
  N98,  \\field Angle Factor 98
        \\type real
        \\minimum 0.0
        \\maximum 1.0
  A101, \\field Surface 99 Name
        \\type object-list
        \\object-list AllHeatTranSurfNames
  N99,  \\field Angle Factor 99
        \\type real
        \\minimum 0.0
        \\maximum 1.0
  A102, \\field Surface 100 Name
        \\type object-list
        \\object-list AllHeatTranSurfNames
  N100; \\field Angle Factor 100
        \\type real
        \\minimum 0.0
        \\maximum 1.0

Lights,
   \\memo Sets internal gains for lights in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
       \\min-fields 11
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference LightsNames
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to design level of lights, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of lights
       \\note for this set of attributes
       \\note Choices: LightingLevel => Lighting Level -- simply enter watts of lights
       \\note Watts/Area => Watts per Zone Floor Area -- enter the number to apply. Value * Floor Area = Lights
       \\note Watts/Person => Watts per Person -- enter the number to apply. Value * Occupants = Lights
       \\type choice
       \\key LightingLevel
       \\key Watts/Area
       \\key Watts/Person
       \\default LightingLevel
  N1 , \\field Lighting Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  N2 , \\field Watts per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units W/ft2
  N3 , \\field Watts per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units W/person
  N4 , \\field Return Air Fraction
       \\note Used only for sizing calculation if return-air-fraction
       \\note coefficients are specified.
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Visible
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N7 , \\field Fraction Replaceable
       \\note For Daylighting:Controls must be 0 or 1:  0 = no dimming control, 1 = full dimming control
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A5 , \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General
  A6 , \\field Return Air Fraction Calculated from Plenum Temperature
       \\type choice
       \\key Yes
       \\key No
       \\default No
  N8 , \\field Return Air Fraction Function of Plenum Temperature Coefficient 1
       \\note Used only if Return Air Fraction Is Calculated from Plenum Temperature = Yes
       \\note Equation is Return Air Fraction = Coefficient#1 - Coefficient#2 X PlenumTemp(degC)
       \\type real
       \\minimum 0.0
       \\default 0.0
  N9 , \\field Return Air Fraction Function of Plenum Temperature Coefficient 2
       \\note Used only if Return Air Fraction Is Calculated from Plenum Temperature = Yes
       \\note Equation is Return Air Fraction = Coefficient#1 - Coefficient#2 X PlenumTemp(degC)
       \\type real
       \\units 1/K
       \\minimum 0.0
       \\default 0.0
  A7 , \\field Return Air Heat Gain Node Name
       \\note Name of the return air node for this heat gain.
       \\note If left blank, defaults to the first return air node for the zone.
       \\note Leave this field blank when using a ZoneList name.
       \\type node
  A8 ; \\field Exhaust Air Heat Gain Node Name
       \\note Name of the exhaust air node for this heat gain.
       \\note If the node name is entered, return heat gain will be shared by both return and exhaust air nodes.
       \\note The air properties of both nodes are weighted by both node mass flow rates.
       \\type node

ElectricEquipment,
   \\memo Sets internal gains for electric equipment in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference ElectricEquipmentNames
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in schedule should be fraction applied to design level of electric equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of electric equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Equipment Level -- simply enter watts of equipment
       \\note Watts/Area => Watts per Zone Floor Area -- enter the number to apply. Value * Floor Area = Equipment Level
       \\note Watts/Person => Watts per Person -- enter the number to apply. Value * Occupants = Equipment Level
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  N2 , \\field Watts per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units W/ft2
  N3 , \\field Watts per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units W/person
  N4 , \\field Fraction Latent
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General

GasEquipment,
   \\memo Sets internal gains and contaminant rates for gas equipment in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of gas equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of gas equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply. Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply. Value * Occupants = Equipment Level
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N7 , \\field Carbon Dioxide Generation Rate
       \\note CO2 generation rate per unit of power input
       \\type real
       \\units m3/s-W
       \\ip-units (ft3/min)/(Btu/h)
       \\default 0.0
       \\minimum 0.0
       \\maximum 4.0E-7
       \\note The default value assumes the equipment is fully vented.
       \\note For unvented equipment, a suggested value is 3.45E-8 m3/s-W. This value is
       \\note converted from a natural gas CO2 emission rate of 117 lbs CO2 per million Btu.
       \\note The maximum value assumes to be 10 times of the recommended value.
  A5 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General

HotWaterEquipment,
   \\memo Sets internal gains for hot water equipment in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of hot water equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of hot water equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply. Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply. Value * Occupants = Equipment Level
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General

SteamEquipment,
   \\memo Sets internal gains for steam equipment in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 10
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of steam equipment, generally (0.0 - 1.0)
  A4 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of steam equipment
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply. Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply. Value * Occupants = Equipment Level
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\minimum 0
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\minimum 0
       \\units W/person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A5 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General

OtherEquipment,
   \\memo Sets internal gains or losses for "other" equipment in the zone.
   \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
   \\min-fields 11
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Fuel Type
       \\type choice
       \\key None
       \\key Electricity
       \\key NaturalGas
       \\key Propane
       \\key FuelOilNo1
       \\key FuelOilNo2
       \\key Diesel
       \\key Gasoline
       \\key Coal
       \\key OtherFuel1
       \\key OtherFuel2
       \\key Steam
       \\key DistrictHeating
       \\key DistrictCooling
       \\default None
  A3 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A4 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to design level of other equipment, generally (0.0 - 1.0)
  A5 , \\field Design Level Calculation Method
       \\note The entered calculation method is used to create the maximum amount of other equipment.
       \\note to set a loss, use a negative value in the following fields.
       \\note for this set of attributes
       \\note Choices: EquipmentLevel => Design Level -- simply enter power input of equipment
       \\note Watts/Area or Power/Area => Power per Zone Floor Area -- enter the number to apply. Value * Floor Area = Equipment Level
       \\note Watts/Person or Power/Person => Power per Person -- enter the number to apply. Value * Occupants = Equipment Level
       \\type choice
       \\key EquipmentLevel
       \\key Watts/Area
       \\key Watts/Person
       \\key Power/Area
       \\key Power/Person
       \\default EquipmentLevel
  N1 , \\field Design Level
       \\units W
       \\type real
       \\ip-units Btu/h
  N2 , \\field Power per Zone Floor Area
       \\type real
       \\units W/m2
       \\ip-units Btu/h-ft2
  N3 , \\field Power per Person
       \\type real
       \\units W/person
       \\ip-units Btu/h-person
  N4 , \\field Fraction Latent
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N6 , \\field Fraction Lost
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  N7 , \\field Carbon Dioxide Generation Rate
       \\note CO2 generation rate per unit of power input
       \\type real
       \\units m3/s-W
       \\ip-units (ft3/min)/(Btu/h)
       \\default 0.0
       \\minimum 0.0
       \\maximum 4.0E-7
       \\note The default value assumes the equipment is fully vented.
  A6 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General

ElectricEquipment:ITE:AirCooled,
   \\memo This object describes air-cooled electric information technology equipment (ITE) which has
   \\memo variable power consumption as a function of loading and temperature.
   \\memo If a Zone comprised of more than one Space is specified
   \\memo then this definition applies to all applicable spaces, and each instance will
   \\memo be named with the Space Name plus this Object Name.
       \\min-fields 28
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or Space Name
       \\note ZoneList and SpaceList names are not allowed.
       \\required-field
       \\type object-list
       \\object-list ZoneNames
       \\object-list SpaceNames
  A3 , \\field Air Flow Calculation Method
       \\note The specified method is used to calculate the IT inlet temperature and zone return
       \\note air temperature. If FlowFromSystem is chosen, the zone is assumed to be well-mixed.
       \\note If FlowControlWithApproachTemperatures is chosen, Supply and Return approach temperature
       \\note should be defined to indicate the temperature difference due to the air distribution. When
       \\note FlowControlWithApproachTemperatures is chosen, the inputs of Air Inlet Connection Type, Design Recirculation Fraction
       \\note and Recirculation Function of Loading and Supply Temperature Curve Name are ignored. For multiple
       \\note ITE objects defined for one zone, the same calculation method should apply.
       \\note The FlowControlWithApproachTemperatures only applies to ITE zones with single duct VAV terminal unit.
       \\note Other return air heat gains from window or lights are not allowed when FlowControlWithApproachTemperatures is chosen.
       \\type choice
       \\key FlowFromSystem
       \\key FlowControlWithApproachTemperatures
       \\default FlowFromSystem
  A4 , \\field Design Power Input Calculation Method
       \\note The entered calculation method is used to specify the design power input
       \\note Watts/Unit => Watts per Unit -- Design Power = Watts per Unit * Number of Units
       \\note Watts/Area => Watts per Zone Floor Area -- Design Power = Watts per Zone Floor Area * Floor Area
       \\type choice
       \\key Watts/Unit
       \\key Watts/Area
       \\default Watts/Unit
  N1 , \\field Watts per Unit
       \\units W
       \\type real
       \\minimum 0
       \\ip-units W
  N2 , \\field Number of Units
       \\type real
       \\minimum 0
       \\default 1
  N3 , \\field Watts per Zone Floor Area
       \\type real
       \\minimum 0
       \\units W/m2
       \\ip-units W/ft2
  A5 , \\field Design Power Input Schedule Name
       \\note Operating schedule for this equipment, fraction applied to the design power input,
       \\note generally (0.0 - 1.0)
       \\note If this field is blank, the schedule is assumed to always be 1.0.
       \\type object-list
       \\object-list ScheduleNames
  A6 , \\field CPU Loading  Schedule Name
       \\note CPU loading schedule for this equipment as a fraction from 0.0 (idle) to 1.0 (full load).
       \\note If this field is blank, the schedule is assumed to always be 1.0.
       \\type object-list
       \\object-list ScheduleNames
  A7 , \\field CPU Power Input Function of Loading and Air Temperature Curve Name
       \\required-field
       \\type object-list
       \\object-list BivariateFunctions
       \\note The name of a two-variable curve or table lookup object which modifies the CPU power
       \\note input as a function of CPU loading (x) and air inlet node temperature (y).
       \\note This curve (table) should equal 1.0 at design conditions (CPU loading = 1.0 and
       \\note Design Entering Air Temperature).
  N4 , \\field Design Fan Power Input Fraction
       \\note The fraction of the total power input at design conditions which is for the cooling fan(s)
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N5,  \\field Design Fan Air Flow Rate per Power Input
       \\note The cooling fan air flow rate per total electric power input at design conditions
       \\required-field
       \\type real
       \\units m3/s-W
       \\minimum 0.0
  A8 , \\field Air Flow Function of Loading and Air Temperature Curve Name
       \\required-field
       \\type object-list
       \\object-list BivariateFunctions
       \\note The name of a two-variable curve or table lookup object which modifies the cooling
       \\note air flow rate as a function of CPU loading (x) and air inlet node temperature (y).
       \\note This curve (table) should equal 1.0 at design conditions (CPU loading = 1.0 and
       \\note Design Entering Air Temperature).
  A9 , \\field Fan Power Input Function of Flow Curve Name
       \\required-field
       \\type object-list
       \\object-list UnivariateFunctions
       \\note The name of a single-variable curve or table lookup object which modifies the cooling
       \\note fan power as a function of flow fraction (x).
       \\note This curve (table) should equal 1.0 at a flow fraction of 1.0.
  N6,  \\field Design Entering Air Temperature
       \\note The entering air temperature at design conditions.
       \\type real
       \\units C
       \\default 15.0
  A10, \\field Environmental Class
       \\note Specifies the allowable operating conditions for the air inlet conditions.
       \\note Used for reporting time outside allowable conditions.
       \\type choice
       \\key None
       \\key A1
       \\key A2
       \\key A3
       \\key A4
       \\key B
       \\key C
       \\default None
  A11, \\field Air Inlet Connection Type
       \\note Specifies the type of connection between the zone and the ITE air inlet node.
       \\note AdjustedSupply = ITE inlet temperature will be the current Supply Air Node temperature
       \\note adjusted by the current recirculation fraction.
       \\note All heat output is added to the zone air heat balance as a convective gain.
       \\note ZoneAirNode = ITE air inlet condition is  the average zone condition.
       \\note All heat output is added to the zone air heat balance as a convective gain.
       \\note RoomAirModel = ITE air inlet and outlet are connected to room air model nodes.
       \\note This field is only used when Air Flow Calculation Method is FlowFromSystem.
       \\type choice
       \\key AdjustedSupply
       \\key ZoneAirNode
       \\key RoomAirModel
       \\default AdjustedSupply
  A12, \\field Air Inlet Room Air Model Node Name
       \\note Name of a RoomAir:Node object which is connected to the ITE air inlet.
       \\type object-list
       \\object-list RoomAirNodes
  A13, \\field Air Outlet Room Air Model Node Name
       \\note Name of a RoomAir:Node object which is connected to the ITE air outlet.
       \\type object-list
       \\object-list RoomAirNodes
  A14, \\field Supply Air Node Name
       \\note Name of the supply air inlet node serving this ITE. Required if the
       \\note Air Node Connection Type = AdjustedSupply. Also required if
       \\note Calculation Method = FlowControlWithApproachTemperatures. Also required if reporting of
       \\note Supply Heat Index is desired.
       \\type node
  N7,  \\field Design Recirculation Fraction
       \\note The recirculation fraction for this equipment at design conditions. This field is used only
       \\note if the Air Node Connection Type = AdjustedSupply. The default is 0.0 (no recirculation).
       \\note This field is only used when Air Flow Calculation Method is FlowFromSystem.
       \\type real
       \\minimum 0.0
       \\maximum 0.5
       \\default 0.0
  A15, \\field Recirculation Function of Loading and Supply Temperature Curve Name
       \\type object-list
       \\object-list BivariateFunctions
       \\note The name of a two-variable curve or table lookup object which modifies the recirculation
       \\note fractionas a function of CPU loading (x) and supply air node temperature (y).
       \\note This curve (table) should equal 1.0 at design conditions (CPU loading = 1.0 and
       \\note Design Entering Air Temperature).This field is used only if the
       \\note Air Node Connection Type = AdjustedSupply. If this curve is left blank, then the curve
       \\note is assumed to always equal 1.0.
       \\note This field is only used when Air Flow Calculation Method is FlowFromSystem.
  N8 , \\field Design Electric Power Supply Efficiency
       \\note The efficiency of the power supply system serving this ITE
       \\type real
       \\minimum> 0.0
       \\maximum 1.0
       \\default 1.0
  A16, \\field Electric Power Supply Efficiency Function of Part Load Ratio Curve Name
       \\type object-list
       \\object-list UnivariateFunctions
       \\note The name of a single-variable curve or table lookup object which modifies the electric
       \\note power supply efficiency as a function of part-load ratio (x).
       \\note This curve (table) should equal 1.0 at full load (PLR = 1.0).
       \\note If this curve is left blank, then the curve is assumed to always equal 1.0.
  N9 , \\field Fraction of Electric Power Supply Losses to Zone
       \\note Fraction of the electric power supply losses which are a heat gain to the zone
       \\note If this field is <1.0, the remainder of the losses are assumed to be lost to the outdoors.
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A17, \\field CPU End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default ITE-CPU
  A18, \\field Fan End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default ITE-Fans
  A19, \\field Electric Power Supply End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default ITE-UPS
  N10, \\field Supply Temperature Difference
       \\note The difference of the IT inlet temperature from the AHU supply air temperature.
       \\note Either Supply Temperature Difference or Supply Temperature Difference Schedule is required if Air Flow Calculation Method is set to FlowControlWithApproachTemperatures.
       \\note This field is ignored when Air Flow Calculation Method is FlowFromSystem.
       \\type real
       \\units deltaC
  A20, \\field Supply Temperature Difference Schedule
       \\note The difference schedule of the IT inlet temperature from the AHU supply air temperature.
       \\note Either Supply Temperature Difference or Supply Temperature Difference Schedule is required if Air Flow Calculation Method is set to FlowControlWithApproachTemperatures.
       \\note This field is ignored when Air Flow Calculation Method is FlowFromSystem.
       \\type object-list
       \\object-list ScheduleNames
  N11, \\field Return Temperature Difference
       \\note The difference of the the actual AHU return air temperature to the IT equipment outlet temperature.
       \\note Either Return Temperature Difference or Return Temperature Difference Schedule is required if Air Flow Calculation Method is set to FlowControlWithApproachTemperatures.
       \\note This field is ignored when Air Flow Calculation Method is FlowFromSystem.
       \\type real
       \\units deltaC
  A21; \\field Return Temperature Difference Schedule
       \\note The difference schedule of the actual AHU return air temperature to the IT equipment outlet temperature.
       \\note Either Return Temperature Difference or Return Temperature Difference Schedule is required if Air Flow Calculation Method is set to FlowControlWithApproachTemperatures.
       \\note This field is ignored when Air Flow Calculation Method is FlowFromSystem.
       \\type object-list
       \\object-list ScheduleNames

ZoneBaseboard:OutdoorTemperatureControlled,
       \\memo Specifies outside temperature-controlled electric baseboard heating.
       \\memo If a ZoneList, SpaceList, or a Zone comprised of more than one Space is specified
       \\memo then this definition applies to all applicable spaces, and each instance will
       \\memo be named with the Space Name plus this Object Name.
       \\min-fields 8
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList or Space or SpaceList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
       \\object-list SpaceAndSpaceListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note units in Schedule should be fraction applied to capacity of the baseboard heat equipment, generally (0.0 - 1.0)
  N1 , \\field Capacity at Low Temperature
       \\required-field
       \\type real
       \\units W
       \\minimum> 0
  N2 , \\field Low Temperature
       \\required-field
       \\units C
       \\type real
  N3 , \\field Capacity at High Temperature
       \\required-field
       \\type real
       \\units W
       \\minimum 0
  N4 , \\field High Temperature
       \\required-field
       \\units C
       \\type real
  N5 , \\field Fraction Radiant
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0
  A4 ; \\field End-Use Subcategory
       \\note Any text may be used here to categorize the end-uses in the ABUPS End Uses by Subcategory table.
       \\type alpha
       \\retaincase
       \\default General


SwimmingPool:Indoor,
       \\memo Specifies an indoor swimming pools linked to a floor surface.
       \\memo The pool is assumed to cover the entire floor to which it is linked.
       \\min-fields 16
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference-class-name validBranchEquipmentTypes
       \\reference validBranchEquipmentNames
  A2,  \\field Surface Name
       \\required-field
       \\note Name of the floor surface where the pool is located.
       \\type object-list
       \\object-list FloorSurfaceNames
  N1,  \\field Average Depth
       \\required-field
       \\type real
       \\units m
  A3,  \\field Activity Factor Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4,  \\field Make-up Water Supply Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A5,  \\field Cover Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N2,  \\field Cover Evaporation Factor
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N3,  \\field Cover Convection Factor
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N4,  \\field Cover Short-Wavelength Radiation Factor
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  N5,  \\field Cover Long-Wavelength Radiation Factor
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 0.0
  A6,  \\field Pool Water Inlet Node
       \\required-field
       \\type node
  A7,  \\field Pool Water Outlet Node
       \\required-field
       \\type node
  N6,  \\field Pool Heating System Maximum Water Flow Rate
       \\type real
       \\units m3/s
       \\ip-units gal/min
       \\minimum 0.0
  N7,  \\field Pool Miscellaneous Equipment Power
       \\note Power input per pool water flow rate
       \\units W/(m3/s)
       \\ip-units W/(gal/min)
       \\type real
       \\minimum 0.0
  A8,  \\field Setpoint Temperature Schedule
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N8,  \\field Maximum Number of People
       \\required-field
       \\minimum 0.0
  A9,  \\field People Schedule
       \\type object-list
       \\object-list ScheduleNames
  A10; \\field People Heat Gain Schedule
       \\type object-list
       \\object-list ScheduleNames

ZoneContaminantSourceAndSink:CarbonDioxide,
   \\memo Represents internal CO2 gains and sinks in the zone.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate
       \\units m3/s
       \\type real
       \\note Positive values represent sources and negative values represent sinks.
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the Design Generation Rate

ZoneContaminantSourceAndSink:Generic:Constant,
   \\memo Sets internal generic contaminant gains and sinks in a zone with constant values.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate
       \\units m3/s
       \\type real
       \\minimum 0.0
       \\note The values represent source.
  A3 , \\field Generation Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the Design Generation Rate
  N2 , \\field Design Removal Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
       \\note The value represent sink.
  A4 ; \\field Removal Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design removal Coefficient

SurfaceContaminantSourceAndSink:Generic:PressureDriven,
   \\memo Simulate generic contaminant source driven by the pressure difference across a surface.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfAndSubSurfNames
  N1 , \\field Design Generation Rate Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Generation Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design Generation Rate Coefficient
  N2 ; \\field Generation Exponent
       \\units dimensionless
       \\type real
       \\minimum> 0.0
       \\maximum 1.0

ZoneContaminantSourceAndSink:Generic:CutoffModel,
   \\memo Simulate generic contaminant source driven by the cutoff concentration model.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Design Generation Rate Coefficient
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Design Generation Rate Coefficient
  N2 ; \\field Cutoff Generic Contaminant at which Emission Ceases
       \\units ppm
       \\type real
       \\minimum> 0.0
       \\note When the zone concentration level is greater than the cutoff level, emission stops,
       \\note and the source level is zero.

ZoneContaminantSourceAndSink:Generic:DecaySource,
   \\memo Simulate generic contaminant source driven by the cutoff concentration model.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Initial Emission Rate
       \\units m3/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.
  N2 ; \\field Delay Time Constant
       \\units s
       \\type real
       \\minimum> 0.0

SurfaceContaminantSourceAndSink:Generic:BoundaryLayerDiffusion,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Mass Transfer Coefficient
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.
  N2 ; \\field Henry Adsorption Constant or Partition Coefficient
       \\units dimensionless
       \\type real
       \\minimum> 0.0

SurfaceContaminantSourceAndSink:Generic:DepositionVelocitySink,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Surface Name
       \\required-field
       \\type object-list
       \\object-list SurfaceNames
  N1 , \\field Deposition Velocity
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.

ZoneContaminantSourceAndSink:Generic:DepositionRateSink,
   \\memo Simulate generic contaminant source driven by the boundary layer diffusion controlled model.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Deposition Rate
       \\units m/s
       \\type real
       \\minimum 0.0
  A3 ; \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
       \\note Value in this schedule should be a fraction (generally 0.0 - 1.0) applied to the
       \\note Initial Emission Rate. When the value is equal to 1.0, the time will be reset to
       \\note zero.

\\group Daylighting

Daylighting:Controls,
       \\extensible:3 - repeat last three fields remembering to remove ; from "inner" fields.
       \\min-fields 16
       \\memo Dimming of overhead electric lighting is determined from each reference point.
       \\memo Glare from daylighting is also calculated.
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference DaylightingControlNames
  A2,  \\field Zone or Space Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
       \\object-list SpaceNames
  A3,  \\field Daylighting Method
       \\type choice
       \\key SplitFlux
       \\key DElight
       \\default SplitFlux
  A4,  \\field Availability Schedule Name
       \\type object-list
       \\object-list ScheduleNames
  A5,  \\field Lighting Control Type
       \\type choice
       \\key Continuous
       \\key Stepped
       \\key ContinuousOff
       \\default Continuous
  N1,  \\field Minimum Input Power Fraction for Continuous or ContinuousOff Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.3
  N2,  \\field Minimum Light Output Fraction for Continuous or ContinuousOff Dimming Control
       \\type real
       \\minimum 0.0
       \\maximum 0.6
       \\default 0.2
  N3,  \\field Number of Stepped Control Steps
       \\note The number of steps, excluding off, in a stepped lighting control system.
       \\note If Lighting Control Type is Stepped, this field must be greater than zero.
       \\note The steps are assumed to be equally spaced.
       \\type integer
       \\minimum 1
       \\default 1
  N4,  \\field Probability Lighting will be Reset When Needed in Manual Stepped Control
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  A6,  \\field Glare Calculation Daylighting Reference Point Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N5,  \\field Glare Calculation Azimuth Angle of View Direction Clockwise from Zone y-Axis
       \\units deg
       \\minimum 0
       \\maximum 360
       \\default 0
  N6,  \\field Maximum Allowable Discomfort Glare Index
       \\type real
       \\minimum 1
       \\note The default is for general office work
       \\default 22
  N7,  \\field DElight Gridding Resolution
       \\units m2
       \\type real
       \\note Maximum surface area for nodes in gridding all surfaces in the DElight zone.
       \\note All reflective and transmitting surfaces will be subdivided
       \\note into approximately square nodes that do not exceed this maximum.
       \\note Higher resolution subdivisions require greater calculation times,
       \\note but generally produce more accurate results.
       \\minimum> 0.0
  A7,  \\field Daylighting Reference Point 1 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
       \\begin-extensible
       \\required-field
  N8,  \\field Fraction of Lights Controlled by Reference Point 1
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N9,  \\field Illuminance Setpoint at Reference Point 1
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A8,  \\field Daylighting Reference Point 2 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N10, \\field Fraction of Lights Controlled by Reference Point 2
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N11, \\field Illuminance Setpoint at Reference Point 2
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A9,  \\field Daylighting Reference Point 3 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N12, \\field Fraction of Lights Controlled by Reference Point 3
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N13, \\field Illuminance Setpoint at Reference Point 3
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A10, \\field Daylighting Reference Point 4 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N14, \\field Fraction of Lights Controlled by Reference Point 4
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N15, \\field Illuminance Setpoint at Reference Point 4
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A11, \\field Daylighting Reference Point 5 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N16, \\field Fraction of Lights Controlled by Reference Point 5
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N17, \\field Illuminance Setpoint at Reference Point 5
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A12, \\field Daylighting Reference Point 6 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N18, \\field Fraction of Zone Controlled by Reference Point 6
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N19, \\field Illuminance Setpoint at Reference Point 6
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A13, \\field Daylighting Reference Point 7 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N20, \\field Fraction of Lights Controlled by Reference Point 7
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N21, \\field Illuminance Setpoint at Reference Point 7
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A14, \\field Daylighting Reference Point 8 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N22, \\field Fraction of Lights Controlled by Reference Point 8
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N23, \\field Illuminance Setpoint at Reference Point 8
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A15, \\field Daylighting Reference Point 9 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N24, \\field Fraction of Zone Controlled by Reference Point 9
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N25, \\field Illuminance Setpoint at Reference Point 9
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500
  A16, \\field Daylighting Reference Point 10 Name
       \\type object-list
       \\object-list DaylightReferencePointNames
  N26, \\field Fraction of Lights Controlled by Reference Point 10
       \\type real
       \\minimum 0.0
       \\maximum 1.0
       \\default 1.0
  N27; \\field Illuminance Setpoint at Reference Point 10
       \\units lux
       \\type real
       \\minimum 0.0
       \\default 500

Daylighting:ReferencePoint,
       \\min-fields 5
       \\memo Used by Daylighting:Controls to identify the reference point coordinates for each sensor.
       \\memo Reference points are given in coordinates specified in the GlobalGeometryRules object
       \\memo Daylighting Reference Point CoordinateSystem field.
  A1,  \\field Name
       \\required-field
       \\type alpha
       \\reference DaylightReferencePointNames
  A2,  \\field Zone or Space Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
       \\object-list SpaceNames
  N1,  \\field X-Coordinate of Reference Point
       \\units m
       \\required-field
       \\type real
  N2,  \\field Y-Coordinate of Reference Point
       \\units m
       \\required-field
       \\type real
  N3;  \\field Z-Coordinate of Reference Point
       \\units m
       \\default 0.8
       \\type real

Daylighting:DELight:ComplexFenestration,
       \\min-fields 5
       \\memo Used for DElight Complex Fenestration of all types
  A1,  \\field Name
       \\required-field
       \\note Only used for user reference
       \\type alpha
  A2,  \\field Complex Fenestration Type
       \\required-field
       \\note Used to select the appropriate Complex Fenestration BTDF data
       \\type alpha
  A3,  \\field Building Surface Name
       \\required-field
       \\note This is a reference to a valid surface object (such as BuildingSurface:Detailed) hosting
       \\note this complex fenestration, analogous to the base surface Name
       \\note field for subsurfaces such as Windows.
       \\type object-list
       \\object-list SurfaceNames
  A4,  \\field Window Name
       \\required-field
       \\note This is a reference to a valid FenestrationSurface:Detailed window object
       \\note used to account for the geometry, and the solar and thermal gains/losses,
       \\note of the Complex Fenestration
       \\type object-list
       \\object-list SubSurfNames
  N1;  \\field Fenestration Rotation
       \\units deg
       \\type real
       \\note In-plane counter-clockwise rotation angle of the Complex Fenestration
       \\note optical reference direction and the base edge of the Complex Fenestration.
       \\note The Rotation will typically be zero when the host and CFS surfaces
       \\note are rectangular and height and width edges are aligned.
       \\default 0.0

DaylightingDevice:Tubular,
       \\memo Defines a tubular daylighting device (TDD) consisting of three components:
       \\memo a dome, a pipe, and a diffuser. The dome and diffuser are defined separately using the
       \\memo FenestrationSurface:Detailed object.
       \\extensible:2 Duplicate the last two fields Transition Zone Name and Transition Zone Length
       \\min-fields 7
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Dome Name
       \\note This must refer to a subsurface object of type TubularDaylightDome
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A3 , \\field Diffuser Name
       \\note This must refer to a subsurface object of type TubularDaylightDiffuser
       \\note Delivery zone is specified in the diffuser object
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A4 , \\field Construction Name
       \\required-field
       \\type object-list
       \\object-list ConstructionNames
  N1 , \\field Diameter
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
  N2 , \\field Total Length
       \\note The exterior exposed length is the difference between total and sum of zone lengths
       \\required-field
       \\units m
       \\type real
       \\minimum> 0
  N3 , \\field Effective Thermal Resistance
       \\note R value between TubularDaylightDome and TubularDaylightDiffuser
       \\units m2-K/W
       \\type real
       \\minimum> 0
       \\default 0.28
  A5 , \\field Transition Zone 1 Name
       \\begin-extensible
       \\type object-list
       \\object-list ZoneNames
  N4 , \\field Transition Zone 1 Length
       \\units m
       \\type real
       \\minimum 0.0
  A6 , \\field Transition Zone 2 Name
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Transition Zone 2 Length
       \\units m
       \\type real
       \\minimum 0.0
  A7 , \\field Transition Zone 3 Name
       \\type object-list
       \\object-list ZoneNames
  N6 , \\field Transition Zone 3 Length
       \\units m
       \\type real
       \\minimum 0.0
  A8 , \\field Transition Zone 4 Name
       \\type object-list
       \\object-list ZoneNames
  N7; \\field Transition Zone 4 Length
       \\units m
       \\type real
       \\minimum 0.0

DaylightingDevice:Shelf,
       \\memo Defines a daylighting which can have an inside shelf, an outside shelf, or both.
       \\memo The inside shelf is defined as a building surface and the outside shelf is defined
       \\memo as a shading surface.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Window Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  A3 , \\field Inside Shelf Name
       \\note This must refer to a BuildingSurface:Detailed or equivalent object
       \\note This surface must be its own Surface for other side boundary conditions.
       \\type object-list
       \\object-list SurfaceNames
  A4 , \\field Outside Shelf Name
       \\note This must refer to a Shading:Zone:Detailed object
       \\type object-list
       \\object-list AttachedShadingSurfNames
  A5 , \\field Outside Shelf Construction Name
       \\note Required if outside shelf is specified
       \\type object-list
       \\object-list ConstructionNames
  N1 ; \\field View Factor to Outside Shelf
       \\type real
       \\minimum 0.0
       \\maximum 1.0

DaylightingDevice:LightWell,
       \\min-fields 5
       \\memo Applies only to exterior windows in daylighting-controlled zones or
       \\memo in zones that share an interior window with a daylighting-controlled  zone.
       \\memo Generally used with skylights.
  A1,  \\field Exterior Window Name
       \\required-field
       \\type object-list
       \\object-list SubSurfNames
  N1,  \\field Height of Well
       \\note Distance from Bottom of Window to Bottom of Well
       \\required-field
       \\type real
       \\units m
       \\minimum 0.0
  N2,  \\field Perimeter of Bottom of Well
       \\required-field
       \\units m
       \\type real
       \\minimum> 0.0
  N3,  \\field Area of Bottom of Well
       \\required-field
       \\type real
       \\units m2
       \\minimum> 0.0
  N4;  \\field Visible Reflectance of Well Walls
       \\required-field
       \\type real
       \\units dimensionless
       \\minimum 0.0
       \\maximum 1.0

Output:DaylightFactors,
   \\memo Reports hourly daylight factors for each exterior window for four sky types
   \\memo (clear, turbid clear, intermediate, and overcast).
  \\format singleLine
   A1;  \\field Reporting Days
   \\required-field
   \\type choice
   \\key SizingDays
   \\key AllShadowCalculationDays

Output:IlluminanceMap,
   \\min-fields 9
   \\memo reference points are given in coordinates specified in the GlobalGeometryRules object
   \\memo Daylighting Reference Point CoordinateSystem field
  A1 , \\field Name
       \\required-field
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Z height
       \\units m
       \\type real
       \\default 0.0
  N2 , \\field X Minimum Coordinate
       \\units m
       \\type real
       \\default 0.0
  N3 , \\field X Maximum Coordinate
       \\units m
       \\type real
       \\default 1.0
  N4 , \\field Number of X Grid Points
       \\note Maximum number of total grid points must be <= 2500 (X*Y)
       \\type integer
       \\minimum 1
       \\default 2
  N5 , \\field Y Minimum Coordinate
       \\units m
       \\type real
       \\default 0.0
  N6 , \\field Y Maximum Coordinate
       \\units m
       \\type real
       \\default 1.0
  N7 ; \\field Number of Y Grid Points
       \\note Maximum number of total grid points must be <= 2500 (X*Y)
       \\type integer
       \\minimum 1
       \\default 2

OutputControl:IlluminanceMap:Style,
       \\memo default style for the Daylighting Illuminance Map is comma -- this works well for
       \\memo importing into spreadsheet programs such as Excel(tm) but not so well for word
       \\memo processing programs -- there tab may be a better choice. fixed puts spaces between
       \\memo the "columns"
       \\unique-object
   A1; \\field Column Separator
       \\type choice
       \\key Comma
       \\key Tab
       \\key Fixed
       \\default Comma

\\group Zone Airflow

ZoneInfiltration:DesignFlowRate,
       \\memo  Infiltration is specified as a design level which is modified by a Schedule fraction, temperature difference and wind speed:
       \\memo  Infiltration=Idesign * FSchedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
       \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
       \\memo to all the zones in the ZoneList.
       \\min-fields 12
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of infiltration
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/ExteriorArea => Flow per Exterior Surface Area - Value * Exterior Surface Area (zone) = Design Flow Rate
       \\note Flow/ExteriorWallArea => Flow per Exterior Surface Area - Value * Exterior Wall Surface Area (zone) = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Idesign" in Equation is the result.
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/ExteriorArea
       \\key Flow/ExteriorWallArea
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
       \\ip-units ft3/min
  N2 , \\field Flow per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow per Exterior Surface Area
       \\note use key Flow/ExteriorArea for all exterior surface area
       \\note use key Flow/ExteriorWallArea to include only exterior wall area
       \\units m3/s-m2
       \\type real
       \\minimum 0
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  N5 , \\field Constant Term Coefficient
       \\note  "A" in Equation
       \\type real
       \\default 1
  N6 , \\field Temperature Term Coefficient
       \\note  "B" in Equation
       \\type real
       \\default 0
  N7 , \\field Velocity Term Coefficient
       \\note  "C" in Equation
       \\type real
       \\default 0
  N8 ; \\field Velocity Squared Term Coefficient
       \\note  "D" in Equation
       \\type real
       \\default 0

ZoneInfiltration:EffectiveLeakageArea,
       \\min-fields 6
       \\memo  Infiltration is specified as effective leakage area at 4 Pa, schedule fraction, stack and wind coefficients, and
       \\memo  is a function of temperature difference and wind speed:
       \\memo  Infiltration=FSchedule * (AL /1000) SQRT(Cs*|(Tzone-Todb)| +  Cw*WindSpd**2 )
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Effective Air Leakage Area
       \\units cm2
       \\note "AL" in Equation
       \\note units are cm2 (square centimeters)
       \\minimum> 0
       \\type real
       \\required-field
  N2 , \\field Stack Coefficient
       \\note "Cs" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N3 ; \\field Wind Coefficient
       \\note "Cw" in Equation
       \\minimum> 0
       \\type real
       \\required-field

ZoneInfiltration:FlowCoefficient,
       \\min-fields 8
       \\memo  Infiltration is specified as flow coefficient, schedule fraction, stack and wind coefficients, and
       \\memo  is a function of temperature difference and wind speed:
       \\memo  Infiltration=FSchedule * SQRT( (c * Cs*|(Tzone-Todb)|**n)**2 + (c* Cw*(s * WindSpd)**2n)**2 )
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Flow Coefficient
       \\note "c" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N2 , \\field Stack Coefficient
       \\note "Cs" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N3 , \\field Pressure Exponent
       \\note "n" in Equation
       \\minimum> 0
       \\type real
       \\default 0.67
  N4 , \\field Wind Coefficient
       \\note "Cw" in Equation
       \\minimum> 0
       \\type real
       \\required-field
  N5 ; \\field Shelter Factor
       \\note "s" in Equation
       \\minimum> 0
       \\type real
       \\required-field

ZoneVentilation:DesignFlowRate,
   \\memo  Ventilation is specified as a design level which is modified by a schedule fraction, temperature difference and wind speed:
   \\memo  Ventilation=Vdesign * Fschedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
   \\memo If you use a ZoneList in the Zone or ZoneList name field then this definition applies
   \\memo to all the zones in the ZoneList.
   \\min-fields 15
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference VentilationNames
  A2 , \\field Zone or ZoneList Name
       \\required-field
       \\type object-list
       \\object-list ZoneAndZoneListNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/Person
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Ventilation Type
       \\type choice
       \\key Natural
       \\key Intake
       \\key Exhaust
       \\key Balanced
       \\default Natural
  N5 , \\field Fan Pressure Rise
       \\note pressure rise across the fan
       \\type real
       \\units Pa
       \\minimum 0
       \\default 0
  N6 , \\field Fan Total Efficiency
       \\type real
       \\minimum> 0
       \\default 1
  N7 , \\field Constant Term Coefficient
       \\note  "A" in Equation
       \\type real
       \\default 1
  N8 , \\field Temperature Term Coefficient
       \\note  "B" in Equation
       \\type real
       \\default 0
  N9 , \\field Velocity Term Coefficient
       \\note  "C" in Equation
       \\type real
       \\default 0
  N10, \\field Velocity Squared Term Coefficient
       \\note  "D" in Equation
       \\type real
       \\default 0
  N11, \\field Minimum Indoor Temperature
       \\note this is the indoor temperature below which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A6 , \\field Minimum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note ventilation is shutoff.
  N12, \\field Maximum Indoor Temperature
       \\note this is the indoor temperature above which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A7 , \\field Maximum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note ventilation is shutoff.
  N13, \\field Delta Temperature
       \\note This is the temperature differential between indoor and outdoor below which ventilation is shutoff.
       \\note If ((IndoorTemp - OutdoorTemp) < DeltaTemperature) then ventilation is not allowed.
       \\note For example, if delta temperature is 2C, ventilation is assumed to be available if the outside air temperature
       \\note is at least 2C cooler than the zone air temperature. The values for this field can include negative numbers.
       \\note This allows ventilation to occur even if the outdoor temperature is above the indoor temperature.
       \\units deltaC
       \\type real
       \\minimum -100
       \\default -100
  A8 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between indoor and outdoor
       \\note versus time below which ventilation is shutoff.
  N14, \\field Minimum Outdoor Temperature
       \\note this is the outdoor temperature below which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A9 , \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note ventilation is shutoff.
  N15, \\field Maximum Outdoor Temperature
       \\note this is the outdoor temperature above which ventilation is shutoff
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A10, \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note ventilation is shutoff.
  N16; \\field Maximum Wind Speed
       \\note this is the outdoor wind speed above which ventilation is shutoff
       \\units m/s
       \\type real
       \\minimum 0
       \\maximum 40
       \\default 40

ZoneVentilation:WindandStackOpenArea,
  \\min-fields 8
       \\memo This object is specified as natural ventilation driven by wind and stack effect only:
       \\memo Ventilation Wind = Cw * Opening Area * Schedule * WindSpd
       \\memo Ventilation Stack = Cd * Opening Area * Schedule * SQRT(2*g*DH*(|(Tzone-Todb)|/Tzone))
       \\memo Total Ventilation = SQRT((Ventilation Wind)^2 + (Ventilation Stack)^2)
  A1 , \\field Name
       \\required-field
       \\type alpha
       \\reference VentilationNames
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N1 , \\field Opening Area
       \\note This is the opening area used to calculate stack effect and wind driven ventilation.
       \\units m2
       \\type real
       \\minimum 0
       \\default 0
  A3 , \\field Opening Area Fraction Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the fraction values applied to the opening area given in the previous
       \\note input field (0.0 - 1.0).
  N2 , \\field Opening Effectiveness
       \\note This field is used to calculate wind driven ventilation.
       \\note  "Cw" in the wind-driven equation and the maximum value is 1.0.
       \\note When the input is Autocalculate, the program calculates Cw based on an angle between
       \\note wind direction and effective angle
       \\note Cw = 0.55 at angle = 0, and Cw = 0.3 at angle=180
       \\note Linear interpolation is used to calculate Cw based on the above two values.
       \\units dimensionless
       \\autocalculatable
       \\type real
       \\minimum 0
       \\maximum 1
       \\default Autocalculate
  N3 , \\field Effective Angle
       \\note This field is defined as normal angle of the opening area and is used when input
       \\note field Opening Effectiveness = Autocalculate.
       \\type real
       \\units deg
       \\minimum 0.0
       \\maximum< 360.0
       \\default 0
  N4 , \\field Height Difference
       \\note This is the height difference between the midpoint of an opening and
       \\note the neutral pressure level.
       \\units m
       \\type real
       \\minimum 0
       \\default 0
       \\note  "DH" in the stack equation.
  N5 , \\field Discharge Coefficient for Opening
       \\note This is the discharge coefficient used to calculate stack effect.
       \\note  "Cd" in the stack equation and the maximum value is 1.0.
       \\note When the input is Autocalculate, the following equation is used to calculate the
       \\note coefficient:
       \\note Cd = 0.4 + 0.0045*|(Tzone-Todb)|
       \\autocalculatable
       \\minimum 0.0
       \\maximum 1.0
       \\default Autocalculate
  N6 , \\field Minimum Indoor Temperature
       \\note This is the indoor temperature below which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A4 , \\field Minimum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note ventilation is shutoff.
  N7 , \\field Maximum Indoor Temperature
       \\note This is the indoor temperature above which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A5 , \\field Maximum Indoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note ventilation is shutoff.
  N8 , \\field Delta Temperature
       \\note This is the temperature differential between indoor and outdoor below
       \\note which ventilation is shutoff.
       \\units deltaC
       \\type real
       \\minimum -100
       \\default -100
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between indoor and outdoor
       \\note versus time below which ventilation is shutoff.
  N9 , \\field Minimum Outdoor Temperature
       \\note This is the outdoor temperature below which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default -100
  A7 , \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note ventilation is shutoff.
  N10, \\field Maximum Outdoor Temperature
       \\note This is the outdoor temperature above which ventilation is shutoff.
       \\units C
       \\type real
       \\minimum -100
       \\maximum 100
       \\default 100
  A8 , \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note ventilation is shutoff.
  N11; \\field Maximum Wind Speed
       \\note This is the outdoor wind speed above which ventilation is shutoff.
       \\units m/s
       \\type real
       \\minimum 0
       \\maximum 40
       \\default 40

ZoneAirBalance:OutdoorAir,
       \\memo Provide a combined zone outdoor air flow by including interactions between
       \\memo mechanical ventilation, infiltration and duct leakage.
       \\memo This object will combine outdoor flows from all ZoneInfiltration and
       \\memo ZoneVentilation objects in the same zone. Balanced flows will be summed, while
       \\memo unbalanced flows will be added in quadrature.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Air Balance Method
       \\type choice
       \\key Quadrature
       \\key None
       \\default Quadrature
       \\note None: Only perform simple calculations without using a combined zone outdoor air.
       \\note Quadrature: A combined outdoor air is used in the quadrature sum.
  N1 , \\field Induced Outdoor Air Due to Unbalanced Duct Leakage
       \\units m3/s
       \\type real
       \\minimum 0
       \\default 0
  A4 ; \\field Induced Outdoor Air Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the fraction values applied to the Induced Outdoor Air given in the
       \\note previous input field (0.0 - 1.0).

ZoneMixing,
       \\memo ZoneMixing is a simple air exchange from one zone to another. Note that this statement
       \\memo only affects the energy balance of the "receiving" zone and will not produce
       \\memo any effect on the "source" zone. Mixing statements can be complementary and include
       \\memo multiple zones, but the balancing of flows between zones is left to the user's
       \\memo discretion.
 \\min-fields 9
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\type choice
       \\key Flow/Zone
       \\key Flow/Area
       \\key Flow/Person
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Source Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Delta Temperature
       \\units deltaC
       \\type real
       \\default 0
       \\note This field contains the constant temperature differential between source and
       \\note receiving zones below which mixing is shutoff.
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between source and receiving
       \\note zones versus time below which mixing is shutoff.
  A7 , \\field Minimum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the zone dry-bulb temperature versus time below which
       \\note mixing is shutoff.
  A8 , \\field Maximum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the zone dry-bulb temperature versus time above which
       \\note mixing is shutoff.
  A9 , \\field Minimum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time below
       \\note which mixing is shutoff.
  A10, \\field Maximum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time above
       \\note which mixing is shutoff.
  A11, \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note mixing is shutoff.
  A12; \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note mixing is shutoff.

ZoneCrossMixing,
       \\memo ZoneCrossMixing exchanges an equal amount of air between two zones. Note that this
       \\memo statement affects the energy balance of both zones.
  \\min-fields 9
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Schedule Name
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  A4 , \\field Design Flow Rate Calculation Method
       \\note The entered calculation method is used to create the maximum amount of ventilation
       \\note for this set of attributes
       \\note Choices: Flow/Zone => Design Flow Rate -- simply enter Design Flow Rate
       \\note Flow/Area => Flow Rate per Zone Floor Area - Value * Floor Area (zone) = Design Flow Rate
       \\note Flow/Person => Flow Rate per Person - Value * #people = Design Flow Rate
       \\note AirChanges/Hour => Air Changes per Hour - Value * Floor Volume (zone) adjusted for m3/s = Design Volume Flow Rate
       \\note  "Vdesign" in Equation is the result.
       \\type choice
       \\key Flow/Zone
       \\key Flow/Person
       \\key Flow/Area
       \\key AirChanges/Hour
       \\default Flow/Zone
  N1 , \\field Design Flow Rate
       \\units m3/s
       \\type real
       \\minimum 0
  N2 , \\field Flow Rate per Zone Floor Area
       \\type real
       \\minimum 0
       \\units m3/s-m2
  N3 , \\field Flow Rate per Person
       \\type real
       \\minimum 0
       \\units m3/s-person
  N4 , \\field Air Changes per Hour
       \\units 1/hr
       \\type real
       \\minimum 0
  A5 , \\field Source Zone Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  N5 , \\field Delta Temperature
       \\units deltaC
       \\minimum 0.0
       \\type real
       \\default 0
       \\note This field contains the constant temperature differential between source and
       \\note receiving zones below which cross mixing is shutoff. This value must be greater
       \\note than or equal to zero.
  A6 , \\field Delta Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the temperature differential between source and receiving
       \\note zones versus time below which cross mixing is shutoff.
  A7 , \\field Minimum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time below which
       \\note cross mixing is shutoff.
  A8 , \\field Maximum Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the indoor temperature versus time above which
       \\note cross mixing is shutoff.
  A9 , \\field Minimum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time below
       \\note which cross mixing is shutoff.
  A10, \\field Maximum Source Zone Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the source zone dry-bulb temperature versus time above
       \\note which cross mixing is shutoff.
  A11, \\field Minimum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time below which
       \\note cross mixing is shutoff.
  A12; \\field Maximum Outdoor Temperature Schedule Name
       \\type object-list
       \\object-list ScheduleNames
       \\note This schedule contains the outdoor temperature versus time above which
       \\note cross mixing is shutoff.

ZoneRefrigerationDoorMixing,
  \\min-fields 4
       \\memo Refrigeration Door Mixing is used for an opening between two zones that are at the
       \\memo   same elevation but have different air temperatures. In this case, the mixing air flow
       \\memo   between the two zones is determined by the density difference between the two zones.
       \\memo   This would typically be used between two zones in a refrigerated warehouse that are
       \\memo   controlled at different temperatures. It could also be used to model a door to a walk-in
       \\memo   refrigerated space if that space were modeled as a zone instead of using the object Refrigeration:WalkIn.
  A1 , \\field Name
       \\required-field
       \\type alpha
  A2 , \\field Zone 1 Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A3 , \\field Zone 2 Name
       \\required-field
       \\type object-list
       \\object-list ZoneNames
  A4 , \\field Schedule Name
       \\note This schedule defines the fraction of the time the refrigeration door is open
       \\note  For example, if the warehouse is closed at night and there are no door openings
       \\note   between two zones, the value for that time period would be 0.
       \\note   If doors were propped open, the value  over that time period would be 1.0
       \\note   If the doors were open about 20% of the time, the value over that period would be 0.2
       \\note   Schedule values must lie between 0 and 1.0
       \\required-field
       \\type object-list
       \\object-list ScheduleNames
  N1 , \\field Door Height
       \\units m
       \\type real
       \\minimum 0
       \\maximum 50.
       \\default 3.0
  N2 , \\field Door Area
       \\type real
       \\minimum 0
       \\maximum 400.
       \\default 9.
       \\units m2
  A5;  \\field Door Protection Type
       \\note Door protection can reduce the air flow through a refrigeration door
       \\note The default value is "None"
       \\note Choices: "None", "AirCurtain", and "StripCurtain"
       \\note A strip curtain reduces the air flow more than an air curtain
       \\type choice
       \\key None
       \\key AirCurtain
       \\key StripCurtain
       \\default None

ZoneEarthtube,
  \\min-fields 22
      \\memo  Earth Tube is specified as a design level which is modified by a Schedule fraction, temperature difference and wind speed:
      \\memo  Earthtube=Edesign * Fschedule * (A + B*|(Tzone-Todb)| + C*WindSpd + D * WindSpd**2)
  A1, \\field Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
  A2, \\field Schedule Name
      \\required-field
      \\type object-list
      \\object-list ScheduleNames
  N1, \\field Design Flow Rate
      \\required-field
      \\units m3/s
      \\note  "Edesign" in Equation
      \\type real
      \\minimum 0
  N2, \\field Minimum Zone Temperature when Cooling
      \\required-field
      \\note this is the indoor temperature below which the earth tube is shut off
      \\units C
      \\type real
      \\minimum -100
      \\maximum 100
  N3, \\field Maximum Zone Temperature when Heating
      \\required-field
      \\note this is the indoor temperature above which the earth tube is shut off
      \\units C
      \\type real
      \\minimum -100
      \\maximum 100
  N4, \\field Delta Temperature
      \\required-field
      \\note This is the temperature difference between indoor and outdoor below which the earth tube is shut off
      \\units deltaC
      \\type real
      \\minimum 0
  A3, \\field Earthtube Type
      \\type choice
      \\key Natural
      \\key Intake
      \\key Exhaust
      \\default Natural
  N5, \\field Fan Pressure Rise
      \\note pressure rise across the fan
      \\type real
      \\units Pa
      \\minimum 0
      \\default 0
  N6, \\field Fan Total Efficiency
      \\type real
      \\minimum> 0
      \\default 1
  N7, \\field Pipe Radius
      \\units m
      \\type real
      \\minimum> 0
      \\default 1
  N8, \\field Pipe Thickness
      \\units m
      \\type real
      \\minimum> 0
      \\default 0.2
  N9, \\field Pipe Length
      \\units m
      \\type real
      \\minimum> 0
      \\default 15
 N10, \\field Pipe Thermal Conductivity
      \\units W/m-K
      \\type real
      \\minimum> 0
      \\default 200
 N11, \\field Pipe Depth Under Ground Surface
      \\units m
      \\type real
      \\minimum> 0
      \\default 3
  A4, \\field Soil Condition
      \\type choice
      \\key HeavyAndSaturated
      \\key HeavyAndDamp
      \\key HeavyAndDry
      \\key LightAndDry
      \\default HeavyAndDamp
 N12, \\field Average Soil Surface Temperature
      \\required-field
      \\units C
      \\type real
 N13, \\field Amplitude of Soil Surface Temperature
      \\required-field
      \\units deltaC
      \\type real
      \\minimum 0
 N14, \\field Phase Constant of Soil Surface Temperature
      \\required-field
      \\units days
      \\type real
      \\minimum 0
 N15, \\field Constant Term Flow Coefficient
      \\note  "A" in Equation
      \\type real
      \\default 1
 N16, \\field Temperature Term Flow Coefficient
      \\note  "B" in Equation
      \\type real
      \\default 0
 N17, \\field Velocity Term Flow Coefficient
      \\note  "C" in Equation
      \\type real
      \\default 0
 N18; \\field Velocity Squared Term Flow Coefficient
      \\note  "D" in Equation
      \\type real
      \\default 0

ZoneCoolTower:Shower,
     \\memo A cooltower (sometimes referred to as a wind tower or a shower cooling tower)
     \\memo models passive downdraught evaporative cooling (PDEC) that is designed to capture the
     \\memo wind at the top of a tower and cool the outdoor air using water evaporation before
     \\memo delivering it to a space.
 A1, \\field Name
     \\required-field
 A2, \\field Availability Schedule Name
     \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
     \\note If this field is blank, the system is always available.
     \\type object-list
     \\object-list ScheduleNames
 A3, \\field Zone Name
     \\required-field
     \\type object-list
     \\object-list ZoneNames
 A4, \\field Water Supply Storage Tank Name
     \\note In case of stand alone tank or underground water, leave this input blank
     \\type object-list
     \\object-list WaterStorageTankNames
 A5, \\field Flow Control Type
     \\note Water flow schedule should be selected when the water flow rate is known.
     \\note Wind-driven flow should be selected when the water flow rate is unknown.
     \\type choice
     \\key WaterFlowSchedule
     \\key WindDrivenFlow
     \\default WindDrivenFlow
 A6, \\field Pump Flow Rate Schedule Name
     \\required-field
     \\type object-list
     \\object-list ScheduleNames
 N1, \\field Maximum Water Flow Rate
     \\required-field
     \\units m3/s
     \\ip-units gal/min
     \\type real
 N2, \\field Effective Tower Height
     \\note This field is from either the spray or the wet pad to the top of the outlet.
     \\required-field
     \\units m
     \\type real
 N3, \\field Airflow Outlet Area
     \\note User have to specify effective area when outlet area is relatively bigger than the cross sectional area
     \\note of cooltower. If the number of outlet is more than one, assume the air passes through only one.
     \\required-field
     \\units m2
     \\type real
 N4, \\field Maximum Air Flow Rate
     \\required-field
     \\units m3/s
     \\type real
     \\minimum 0
 N5, \\field Minimum Indoor Temperature
     \\required-field
     \\note This field is to specify the indoor temperature below which cooltower is shutoff.
     \\units C
     \\type real
     \\minimum -100
     \\maximum 100
 N6, \\field Fraction of Water Loss
     \\minimum 0
     \\maximum 1
 N7, \\field Fraction of Flow Schedule
     \\minimum 0
     \\maximum 1
 N8; \\field Rated Power Consumption
     \\required-field
     \\units W
     \\type real

ZoneThermalChimney,
       \\memo A thermal chimney is a vertical shaft utilizing solar radiation to enhance natural
       \\memo ventilation. It consists of an absorber wall, air gap and glass cover with high solar
       \\memo transmissivity.
   \\min-fields 10
   A1, \\field Name
        \\required-field
   A2,  \\field Zone Name
        \\note Name of zone that is the thermal chimney
        \\required-field
        \\type object-list
        \\object-list ZoneNames
   A3, \\field Availability Schedule Name
        \\note Availability schedule name for this system. Schedule value > 0 means the system is available.
        \\note If this field is blank, the system is always available.
        \\type object-list
        \\object-list ScheduleNames
   N1, \\field Width of the Absorber Wall
        \\required-field
        \\units m
        \\type real
        \\minimum 0
   N2, \\field Cross Sectional Area of Air Channel Outlet
        \\required-field
        \\units m2
        \\type real
        \\minimum 0
   N3, \\field Discharge Coefficient
        \\type real
        \\minimum 0
        \\maximum 1
        \\default 0.8
   A4, \\field Zone 1 Name
        \\required-field
        \\type object-list
        \\object-list ZoneNames
   N4, \\field Distance from Top of Thermal Chimney to Inlet 1
        \\required-field
        \\units m
        \\type real
        \\minimum 0
   N5, \\field Relative Ratios of Air Flow Rates Passing through Zone 1
        \\type real
        \\minimum 0
        \\maximum 1
        \\default 1.0
   N6, \\field Cross Sectional Areas of Air Channel Inlet 1
        \\required-field
        \\units m2
        \\type real
        \\minimum 0
   A5, \\field Zone 2 Name
        \\type object-list
        \\object-list ZoneNames
   N7, \\field Distance from Top of Thermal Chimney to Inlet 2
        \\units m
        \\type real
        \\minimum 0
   N8, \\field Relative Ratios of Air Flow Rates Passing through Zone 2
        \\type real
        \\minimum 0
        \\maximum 1
   N9, \\field Cross Sectional Areas of Air Channel Inlet 2
        \\units m2
        \\type real
        \\minimum 0
   A6, \\field Zone 3 Name
        \\type object-list
        \\object-list ZoneNames
   N10, \\field Distance from Top of Thermal Chimney to Inlet 3
        \\units m
        \\type real
        \\minimum 0
   N11, \\field Relative Ratios of Air Flow Rates Passing through Zone 3
        \\type real
        \\minimum 0
        \\maximum 1
   N12, \\field Cross Sectional Areas of Air Channel Inlet 3
        \\units m2
        \\type real
        \\minimum 0
   A7, \\field Zone 4 Name
        \\type object-list
        \\object-list ZoneNames
   N13, \\field Distance from Top of Thermal Chimney to Inlet 4
        \\units m
        \\type real
        \\minimum 0
   N14, \\field Relative Ratios of Air Flow Rates Passing through Zone 4
        \\type real
        \\minimum 0
        \\maximum 1
   N15, \\field Cross Sectional Areas of Air Channel Inlet 4
        \\units m2
        \\type real
        \\minimum 0
   A8, \\field Zone 5 Name
        \\type object-list
        \\object-list ZoneNames
   N16, \\field Distance from Top of Thermal Chimney to Inlet 5
        \\units m
        \\type real
        \\minimum 0
   N17, \\field Relative Ratios of Air Flow Rates Passing through Zone 5
        \\type real
        \\minimum 0
        \\maximum 1
   N18, \\field Cross Sectional Areas of Air Channel Inlet 5
        \\units m2
        \\type real
        \\minimum 0
   A9, \\field Zone 6 Name
        \\type object-list
        \\object-list ZoneNames
   N19, \\field Distance from Top of Thermal Chimney to Inlet 6
        \\units m
        \\type real
        \\minimum 0
   N20, \\field Relative Ratios of Air Flow Rates Passing through Zone 6
        \\type real
        \\minimum 0
        \\maximum 1
   N21, \\field Cross Sectional Areas of Air Channel Inlet 6
        \\units m2
        \\type real
        \\minimum 0
   A10, \\field Zone 7 Name
        \\type object-list
        \\object-list ZoneNames
   N22, \\field Distance from Top of Thermal Chimney to Inlet 7
        \\units m
        \\type real
        \\minimum 0
   N23, \\field Relative Ratios of Air Flow Rates Passing through Zone 7
        \\type real
        \\minimum 0
        \\maximum 1
   N24, \\field Cross Sectional Areas of Air Channel Inlet 7
        \\units m2
        \\type real
        \\minimum 0
   A11, \\field Zone 8 Name
        \\type object-list
        \\object-list ZoneNames
   N25, \\field Distance from Top of Thermal Chimney to Inlet 8
        \\units m
        \\type real
        \\minimum 0
   N26, \\field Relative Ratios of Air Flow Rates Passing through Zone 8
        \\type real
        \\minimum 0
        \\maximum 1
   N27, \\field Cross Sectional Areas of Air Channel Inlet 8
        \\units m2
        \\type real
        \\minimum 0
   A12, \\field Zone 9 Name
        \\type object-list
        \\object-list ZoneNames
   N28, \\field Distance from Top of Thermal Chimney to Inlet 9
        \\units m
        \\type real
        \\minimum 0
   N29, \\field Relative Ratios of Air Flow Rates Passing through Zone 9
        \\type real
        \\minimum 0
        \\maximum 1
   N30, \\field Cross Sectional Areas of Air Channel Inlet 9
        \\units m2
        \\type real
        \\minimum 0
   A13, \\field Zone 10 Name
        \\type object-list
        \\object-list ZoneNames
   N31, \\field Distance from Top of Thermal Chimney to Inlet 10
        \\units m
        \\type real
        \\minimum 0
   N32, \\field Relative Ratios of Air Flow Rates Passing through Zone 10
        \\type real
        \\minimum 0
        \\maximum 1
   N33, \\field Cross Sectional Areas of Air Channel Inlet 10
        \\units m2
        \\type real
        \\minimum 0
   A14, \\field Zone 11 Name
        \\type object-list
        \\object-list ZoneNames
   N34, \\field Distance from Top of Thermal Chimney to Inlet 11
        \\units m
        \\type real
        \\minimum 0
   N35, \\field Relative Ratios of Air Flow Rates Passing through Zone 11
        \\type real
        \\minimum 0
        \\maximum 1
   N36, \\field Cross Sectional Areas of Air Channel Inlet 11
        \\units m2
        \\type real
        \\minimum 0
   A15, \\field Zone 12 Name
        \\type object-list
        \\object-list ZoneNames
   N37, \\field Distance from Top of Thermal Chimney to Inlet 12
        \\units m
        \\type real
        \\minimum 0
   N38, \\field Relative Ratios of Air Flow Rates Passing through Zone 12
        \\type real
        \\minimum 0
        \\maximum 1
   N39, \\field Cross Sectional Areas of Air Channel Inlet 12
        \\units m2
        \\type real
        \\minimum 0
   A16, \\field Zone 13 Name
        \\type object-list
        \\object-list ZoneNames
   N40, \\field Distance from Top of Thermal Chimney to Inlet 13
        \\units m
        \\type real
        \\minimum 0
   N41, \\field Relative Ratios of Air Flow Rates Passing through Zone 13
        \\type real
        \\minimum 0
        \\maximum 1
   N42, \\field Cross Sectional Areas of Air Channel Inlet 13
        \\units m2
        \\type real
        \\minimum 0
   A17, \\field Zone 14 Name
        \\type object-list
        \\object-list ZoneNames
   N43, \\field Distance from Top of Thermal Chimney to Inlet 14
        \\units m
        \\type real
        \\minimum 0
   N44, \\field Relative Ratios of Air Flow Rates Passing through Zone 14
        \\type real
        \\minimum 0
        \\maximum 1
   N45, \\field Cross Sectional Areas of Air Channel Inlet 14
        \\units m2
        \\type real
        \\minimum 0
   A18, \\field Zone 15 Name
        \\type object-list
        \\object-list ZoneNames
   N46, \\field Distance from Top of Thermal Chimney to Inlet 15
        \\units m
        \\type real
        \\minimum 0
   N47, \\field Relative Ratios of Air Flow Rates Passing through Zone 15
        \\type real
        \\minimum 0
        \\maximum 1
   N48, \\field Cross Sectional Areas of Air Channel Inlet 15
        \\units m2
        \\type real
        \\minimum 0
   A19, \\field Zone 16 Name
        \\type object-list
        \\object-list ZoneNames
   N49, \\field Distance from Top of Thermal Chimney to Inlet 16
        \\units m
        \\type real
        \\minimum 0
   N50, \\field Relative Ratios of Air Flow Rates Passing through Zone 16
        \\type real
        \\minimum 0
        \\maximum 1
   N51, \\field Cross Sectional Areas of Air Channel Inlet 16
        \\units m2
        \\type real
        \\minimum 0
   A20, \\field Zone 17 Name
        \\type object-list
        \\object-list ZoneNames
   N52, \\field Distance from Top of Thermal Chimney to Inlet 17
        \\units m
        \\type real
        \\minimum 0
   N53, \\field Relative Ratios of Air Flow Rates Passing through Zone 17
        \\type real
        \\minimum 0
        \\maximum 1
   N54, \\field Cross Sectional Areas of Air Channel Inlet 17
        \\units m2
        \\type real
        \\minimum 0
   A21, \\field Zone 18 Name
        \\type object-list
        \\object-list ZoneNames
   N55, \\field Distance from Top of Thermal Chimney to Inlet 18
        \\units m
        \\type real
        \\minimum 0
   N56, \\field Relative Ratios of Air Flow Rates Passing through Zone 18
        \\type real
        \\minimum 0
        \\maximum 1
   N57, \\field Cross Sectional Areas of Air Channel Inlet 18
        \\units m2
        \\type real
        \\minimum 0
   A22, \\field Zone 19 Name
        \\type object-list
        \\object-list ZoneNames
   N58, \\field Distance from Top of Thermal Chimney to Inlet 19
        \\units m
        \\type real
        \\minimum 0
   N59, \\field Relative Ratios of Air Flow Rates Passing through Zone 19
        \\type real
        \\minimum 0
        \\maximum 1
   N60, \\field Cross Sectional Areas of Air Channel Inlet 19
        \\units m2
        \\type real
        \\minimum 0
   A23, \\field Zone 20 Name
        \\type object-list
        \\object-list ZoneNames
   N61, \\field Distance from Top of Thermal Chimney to Inlet 20
        \\units m
        \\type real
        \\minimum 0
   N62, \\field Relative Ratios of Air Flow Rates Passing through Zone 20
        \\type real
        \\minimum 0
        \\maximum 1
   N63; \\field Cross Sectional Areas of Air Channel Inlet 20
        \\units m2
        \\type real
        \\minimum 0

\\group AirflowNetwork

! Basic parameters
AirflowNetwork:SimulationControl,
      \\min-fields 12
      \\unique-object
      \\memo This object defines the global parameters used in an Airflow Network simulation.
 A1 , \\field Name
      \\required-field
      \\note Enter a unique name for this object.
 A2 , \\field AirflowNetwork Control
      \\type choice
      \\key MultizoneWithDistribution
      \\key MultizoneWithoutDistribution
      \\key MultizoneWithDistributionOnlyDuringFanOperation
      \\key NoMultizoneOrDistribution
      \\default NoMultizoneOrDistribution
      \\note NoMultizoneOrDistribution: Only perform Simple calculations (objects ZoneInfiltration:*,
      \\note ZoneVentilation:*, ZoneMixing, ZoneCrossMixing, ZoneRefrigerationDoorMixing,
      \\note ZoneAirBalance:OutdoorAir, ZoneEarthtube, ZoneThermalChimney, and ZoneCoolTower:Shower);
      \\note MultizoneWithoutDistribution: Use AirflowNetwork objects to simulate multizone
      \\note Airflows driven by wind during simulation time,
      \\note and objects of ZoneInfiltration:*, ZoneVentilation:*, ZoneMixing, ZoneCrossMixing
      \\note ZoneRefrigerationDoorMixing, ZoneAirBalance:OutdoorAir, ZoneEarthtube,
      \\note ZoneThermalChimney, and ZoneCoolTower:Shower are ignored;
      \\note MultizoneWithDistributionOnlyDuringFanOperation: Perform distribution system
      \\note calculations during system fan on time
      \\note and Simple calculations during system Fan off time;
      \\note MultizoneWithDistribution: Perform distribution system calculations during system
      \\note fan on time and multizone Airflow driven by wind during system fan off time.
 A3 , \\field Wind Pressure Coefficient Type
      \\type choice
      \\key Input
      \\key SurfaceAverageCalculation
      \\default SurfaceAverageCalculation
      \\note Input: User must enter AirflowNetwork:MultiZone:WindPressureCoefficientArray,
      \\note AirflowNetwork:MultiZone:ExternalNode, and
      \\note AirflowNetwork:MultiZone:WindPressureCoefficientValues objects.
      \\note SurfaceAverageCalculation: used only for rectangular buildings.
      \\note If SurfaceAverageCalculation is selected,
      \\note AirflowNetwork:MultiZone:WindPressureCoefficientArray, AirflowNetwork:MultiZone:ExternalNode,
      \\note and AirflowNetwork:MultiZone:WindPressureCoefficientValues objects are not used.
 A4 , \\field Height Selection for Local Wind Pressure Calculation
      \\type choice
      \\key ExternalNode
      \\key OpeningHeight
      \\default OpeningHeight
      \\note If ExternalNode is selected, the height given in the
      \\note AirflowNetwork:MultiZone:ExternalNode object will be used.
      \\note If OpeningHeight is selected, the surface opening height (centroid) will be used to
      \\note calculate local wind pressure
      \\note This field is ignored when the choice of the Wind Pressure Coefficient Type field is
      \\note SurfaceAverageCalculation.
 A5 , \\field Building Type
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation,
      \\note otherwise this field may be left blank.
      \\type choice
      \\key LowRise
      \\key HighRise
      \\default LowRise
 N1 , \\field Maximum Number of Iterations
      \\type integer
      \\units dimensionless
      \\default 500
      \\minimum> 10
      \\maximum 30000
      \\note Determines the maximum number of iterations used to converge on a solution. If this limit
      \\note is exceeded, the program terminates.
 A6 , \\field Initialization Type
      \\type choice
      \\key LinearInitializationMethod
      \\key ZeroNodePressures
      \\default ZeroNodePressures
 N2 , \\field Relative Airflow Convergence Tolerance
      \\type real
      \\units dimensionless
      \\default 1.E-4
      \\minimum> 0
      \\note This tolerance is defined as the absolute value of the sum of the mass Flow Rates
      \\note divided by the sum of the absolute value of the mass Flow Rates. The mass Flow Rates
      \\note described here refer to the mass Flow Rates at all Nodes in the AirflowNetwork model.
      \\note The solution converges when both this tolerance and the tolerance in the next field
      \\note (Absolute Airflow Convergence Tolerance) are satisfied.
 N3 , \\field Absolute Airflow Convergence Tolerance
      \\type real
      \\units kg/s
      \\default 1.E-6
      \\minimum> 0
      \\note This tolerance is defined as the absolute value of the sum of the mass flow rates. The mass
      \\note flow rates described here refer to the mass flow rates at all nodes in the AirflowNetwork
      \\note model. The solution converges when both this tolerance and the tolerance in the previous
      \\note field (Relative Airflow Convergence Tolerance) are satisfied.
 N4 , \\field Convergence Acceleration Limit
      \\type real
      \\units dimensionless
      \\note Used only for AirflowNetwork:SimulationControl
      \\minimum -1
      \\maximum 1
      \\default -0.5
 N5 , \\field Azimuth Angle of Long Axis of Building
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 180.0
      \\default 0.0
      \\note Degrees clockwise from true North.
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation.
 N6 , \\field Ratio of Building Width Along Short Axis to Width Along Long Axis
      \\type real
      \\minimum> 0.0
      \\maximum 1.0
      \\default 1.0
      \\note Used only if Wind Pressure Coefficient Type = SurfaceAverageCalculation.
 A7 , \\field Height Dependence of External Node Temperature
      \\note If Yes, external node temperature is height dependent.
      \\note If No, external node temperature is based on zero height.
      \\type choice
      \\key Yes
      \\key No
      \\default No
 A8 , \\field Solver
      \\note Select the solver to use for the pressure network solution
      \\type choice
      \\key SkylineLU
      \\key ConjugateGradient
      \\default SkylineLU
 A9 ; \\field Allow Unsupported Zone Equipment
      \\note Set this input to Yes to have zone equipment that are currently unsupported in the AirflowNetwork model
      \\note allowed in the simulation if present. Setting this field to Yes, allows the following equipments
      \\note to be modeled along an AirflowNetwork model: ZoneHVAC:Dehumidifier, ZoneHVAC:EnergyRecoveryVentilator,
      \\note WaterHeater:HeatPump:*.
      \\type choice
      \\key Yes
      \\key No
      \\default No

AirflowNetwork:MultiZone:Zone,
      \\min-fields 8
      \\memo This object is used to simultaneously control a thermal zone's window and door openings,
      \\memo both exterior and interior.
  A1, \\field Zone Name
      \\required-field
      \\reference AirFlowNetworkMultizoneZones
      \\type object-list
      \\object-list ZoneNames
      \\note Enter the zone name where ventilation control is required.
  A2, \\field Ventilation Control Mode
      \\type choice
      \\key Temperature
      \\key Enthalpy
      \\key Constant
      \\key ASHRAE55Adaptive
      \\key CEN15251Adaptive
      \\key NoVent
      \\default NoVent
      \\note When Ventilation Control Mode = Temperature or Enthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for all
      \\note window and door openings in the zone according to the zone's
      \\note indoor-outdoor temperature or enthalpy difference.
      \\note Constant: controlled by field Venting Schedule Name.
      \\note NoVent: control will not open window or door during simulation (Ventilation Open Factor = 0).
  A3, \\field Ventilation Control Zone Temperature Setpoint Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N1, \\field Minimum Venting Open Factor
      \\type real
      \\units dimensionless
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.0
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N2, \\field Indoor and Outdoor Temperature Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum 0.0
      \\maximum< 100.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be less than the corresponding upper value (next field).
  N3, \\field Indoor and Outdoor Temperature Difference Upper Limit for Minimum Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum> 0.0
      \\default 100.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be greater than the corresponding lower value (previous field).
  N4, \\field Indoor and Outdoor Enthalpy Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum 0.0
      \\maximum< 300000.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be less than the corresponding upper value (next field).
  N5, \\field Indoor and Outdoor Enthalpy Difference Upper Limit for Minimum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum> 0.0
      \\default 300000.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be greater than the corresponding lower value (previous field).
  A4, \\field Venting Availability Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Non-zero Schedule value means venting is allowed if other venting control conditions are
      \\note satisfied. A zero (or negative) Schedule value means venting is not allowed under any
      \\note The Schedule values should be greater than or equal to 0 and less than or equal to 1.
      \\note circumstances. If this Schedule is not specified then venting is allowed if
      \\note other venting control conditions are satisfied.
      \\note Not used if Ventilation Control Mode = NoVent.
  A5, \\field Single Sided Wind Pressure Coefficient Algorithm
      \\type choice
      \\key Advanced
      \\key Standard
      \\default Standard
      \\note Selecting Advanced results in EnergyPlus calculating modified Wind Pressure Coefficients
      \\note to account for wind direction and turbulence effects on single sided ventilation rates.
      \\note Model is only valid for zones with 2 openings, both of which are on a single facade.
  N6, \\field Facade Width
      \\type real
      \\units m
      \\minimum 0.0
      \\default 10.0
      \\note This is the whole building width along the direction of the facade of this zone.
  A6; \\field Occupant Ventilation Control Name
      \\type object-list
      \\object-list AirflowNetworkOccupantVentilationControlNames
      \\note Enter the name where Occupancy Ventilation Control is required.

AirflowNetwork:MultiZone:Surface,
      \\min-fields 4
      \\memo This object specifies the properties of a surface linkage through which air flows.
      \\memo Airflow Report: Node 1 as an inside face zone;
      \\memo Node 2 as an outside face zone or external node.
  A1, \\field Surface Name
      \\required-field
      \\type object-list
      \\object-list SurfAndSubSurfNames
      \\note Enter the name of a heat transfer surface.
  A2, \\field Leakage Component Name
      \\required-field
      \\type object-list
      \\object-list SurfaceAirflowLeakageNames
      \\note Enter the name of an Airflow Network leakage component. A leakage component is
      \\note one of the following AirflowNetwork:Multizone objects:
      \\note AirflowNetwork:MultiZone:Component:DetailedOpening,
      \\note AirflowNetwork:MultiZone:Component:SimpleOpening,
      \\note AirflowNetwork:MultiZone:Surface:Crack,
      \\note AirflowNetwork:MultiZone:Surface:EffectiveLeakageArea,
      \\note AirflowNetwork:MultiZone:Component:HorizontalOpening, or
      \\note AirflowNetwork:MultiZone:Component:ZoneExhaustFan.
      \\note When the zone exhaust fan name is entered, any surface control fields below A3 are
      \\note ignored when the zone exhaust fan turns on.
  A3, \\field External Node Name
      \\type object-list
      \\object-list ExternalNodeNames
      \\object-list OutdoorAirNodeNames
      \\note Used if Wind Pressure Coefficient Type = Input in the AirflowNetwork:SimulationControl object,
      \\note otherwise this field may be left blank.
  N1, \\field Window/Door Opening Factor, or Crack Factor
      \\type real
      \\units dimensionless
      \\minimum> 0.0
      \\maximum 1.0
      \\default 1.0
      \\note This field specifies a multiplier for a crack, window, or door.
  A4, \\field Ventilation Control Mode
      \\type choice
      \\key Temperature
      \\key Enthalpy
      \\key Constant
      \\key ASHRAE55Adaptive
      \\key CEN15251Adaptive
      \\key NoVent
      \\key ZoneLevel
      \\key AdjacentTemperature
      \\key AdjacentEnthalpy
      \\default ZoneLevel
      \\note When Ventilation Control Mode = Temperature or Enthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for a
      \\note window or door opening according to the parent zone's
      \\note indoor-outdoor temperature or enthalpy difference.
      \\note When Ventilation Control Mode = AdjacentTemperature or AdjacentEnthalpy, the following
      \\note fields are used to modulate the Ventilation Open Factor for an interior
      \\note window or door opening according to temperature or enthalpy difference
      \\note between the parent zone and the adjacent zone.
      \\note Constant: controlled by field Venting Schedule Name.
      \\note NoVent: control will not open window or door during simulation (Ventilation Open Factor = 0).
      \\note ZoneLevel: control will be controlled by AirflowNetwork:MultiZone:Zone
      \\note Mode.
  A5, \\field Ventilation Control Zone Temperature Setpoint Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N2, \\field Minimum Venting Open Factor
      \\type real
      \\units dimensionless
      \\minimum 0.0
      \\maximum 1.0
      \\default 0.0
      \\note Used only if Ventilation Control Mode = Temperature or Enthalpy.
  N3, \\field Indoor and Outdoor Temperature Difference Lower Limit For Maximum Venting Open Factor
      \\note Applicable only if Ventilation Control Mode = Temperature
      \\type real
      \\units deltaC
      \\minimum 0.0
      \\maximum< 100
      \\default 0.0
  N4, \\field Indoor and Outdoor Temperature Difference Upper Limit for Minimum Venting Open Factor
      \\type real
      \\units deltaC
      \\minimum> 0.0
      \\default 100.0
      \\note Applicable only if Ventilation Control Mode = Temperature.
      \\note This value must be greater than the corresponding lower value (previous field).
  N5, \\field Indoor and Outdoor Enthalpy Difference Lower Limit For Maximum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum 0.0
      \\maximum< 300000.0
      \\default 0.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be less than the corresponding upper value (next field).
  N6, \\field Indoor and Outdoor Enthalpy Difference Upper Limit for Minimum Venting Open Factor
      \\type real
      \\units deltaJ/kg
      \\minimum> 0.0
      \\default 300000.0
      \\note Applicable only if Ventilation Control Mode = Enthalpy.
      \\note This value must be greater than the corresponding lower value (previous field).
  A6, \\field Venting Availability Schedule Name
      \\type object-list
      \\object-list ScheduleNames
      \\note Non-zero schedule value means venting is allowed if other venting control conditions are
      \\note satisfied. A zero (or negative) schedule value means venting is not allowed under any
      \\note circumstances. The schedule values should be greater than or equal to 0 and less than or
      \\note equal to 1. If this schedule is not specified then venting is allowed if
      \\note other venting control conditions are satisfied.
      \\note Not used if Ventilation Control Mode = NoVent or ZoneLevel.
  A7, \\field Occupant Ventilation Control Name
      \\type object-list
      \\object-list AirflowNetworkOccupantVentilationControlNames
      \\note Enter the name where Occupancy Ventilation Control is required.
  A8, \\field Equivalent Rectangle Method
      \\type choice
      \\key PolygonHeight
      \\key BaseSurfaceAspectRatio
      \\key UserDefinedAspectRatio
      \\default PolygonHeight
      \\note This field is applied to a non-rectangular window or door. The equivalent shape has
      \\note the same area as a polygonal window or door.
  N7; \\field Equivalent Rectangle Aspect Ratio
      \\note This field is used when UserDefinedAspectRatio is entered in the Equivalent
      \\note Rectangle Method field.
      \\units dimensionless
      \\type real
      \\minimum> 0.0
      \\default 1.0

AirflowNetwork:MultiZone:ReferenceCrackConditions,
      \\min-fields 4
      \\memo This object specifies the conditions under which the air mass flow coefficient was measured.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference ReferenceCrackConditions
      \\note Enter a unique name for this object.
 N1 , \\field Reference Temperature
      \\required-field
      \\type real
      \\units C
      \\note Enter the reference temperature under which the surface crack data were obtained. 
      \\note Suggested value 20C.
 N2 , \\field Reference Barometric Pressure
      \\type real
      \\units Pa
      \\default 101325
      \\minimum 31000
      \\maximum 120000
      \\ip-units inHg
      \\note Enter the reference barometric pressure under which the surface crack data were obtained.
 N3 ; \\field Reference Humidity Ratio
      \\type real
      \\units kgWater/kgDryAir
      \\default 0
      \\note Enter the reference humidity ratio under which the surface crack data were obtained.

AirflowNetwork:MultiZone:Surface:Crack,
      \\min-fields 3
      \\memo This object specifies the properties of airflow through a crack.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient at Reference Conditions
      \\type real
      \\required-field
      \\units kg/s
      \\minimum> 0
      \\note Enter the air mass flow coefficient at the conditions defined
      \\note in the Reference Crack Conditions object.
      \\note Defined at 1 Pa pressure difference across this crack.
 N2 , \\field Air Mass Flow Exponent
      \\type real
      \\units dimensionless
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the air mass flow exponent for the surface crack.
 A2 ; \\field Reference Crack Conditions
      \\type object-list
      \\object-list ReferenceCrackConditions
      \\note Select a AirflowNetwork:MultiZone:ReferenceCrackConditions name associated with
      \\note the air mass flow coefficient entered above.

AirflowNetwork:MultiZone:Surface:EffectiveLeakageArea,
      \\min-fields 5
      \\memo This object is used to define surface air leakage.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Effective Leakage Area
      \\required-field
      \\type real
      \\units m2
      \\minimum> 0
      \\note Enter the effective leakage area.
 N2 , \\field Discharge Coefficient
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\default 1.0
      \\note Enter the coefficient used in the air mass flow equation.
 N3 , \\field Reference Pressure Difference
      \\type real
      \\units Pa
      \\minimum> 0
      \\default 4.0
      \\note Enter the pressure difference used to define the air mass flow coefficient and exponent.
 N4 ; \\field Air Mass Flow Exponent
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the air mass flow equation.

AirflowNetwork:MultiZone:SpecifiedFlowRate,
      \\min-fields 2
      \\memo This object is used to define specified flow through a linkage.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Flow Value
      \\required-field
      \\type real
      \\unitsBasedOnField A2
      \\note Enter the specified flow rate.
 A2 ; \\field Air Flow Units
      \\type choice
      \\key VolumetricFlow
      \\key MassFlow
      \\default MassFlow
      \\note Enter the units of the air flow value.
      \\note VolumetricFlow (m3/s)
      \\note MassFlow (kg/s)

AirflowNetwork:MultiZone:Component:DetailedOpening,
      \\min-fields 16
      \\memo This object specifies the properties of airflow through windows and doors (window, door and
      \\memo glass door heat transfer subsurfaces) when they are closed or open.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\units kg/s-m
      \\minimum> 0
      \\note Defined at 1 Pa per meter of crack length. Enter the coefficient used in the following
      \\note equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 A2 , \\field Type of Rectangular Large Vertical Opening (LVO)
      \\type choice
      \\key NonPivoted
      \\key HorizontallyPivoted
      \\note Select the type of vertical opening: Non-pivoted opening or Horizontally pivoted opening.
      \\default NonPivoted
 N3 , \\field Extra Crack Length or Height of Pivoting Axis
      \\type real
      \\units m
      \\minimum 0
      \\default 0
      \\note Extra crack length is used for LVO Non-pivoted type with multiple openable parts.
      \\note Height of pivoting axis is used for LVO Horizontally pivoted type.
      \\note Specifies window or door characteristics that depend on the LVO type.
      \\note For Non-pivoted Type (rectangular windows and doors), this field is the extra crack length
      \\note in meters due to multiple openable parts, if present. Extra here means in addition
      \\note to the length of the cracks on the top, bottom and sides of the window/door.
      \\note For Horizontally pivoted Type, this field gives the height of the
      \\note pivoting axis measured from the bottom of the glazed part of the window (m).
 N4 , \\field Number of Sets of Opening Factor Data
      \\required-field
      \\type integer
      \\minimum 2
      \\maximum 4
      \\note Enter the number of the following sets of data for opening factor,
      \\note discharge coefficient, width factor, height factor, and start height factor.
 N5 , \\field Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 0
      \\default 0
      \\note This value must be specified as 0.
 N6 , \\field Discharge Coefficient for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 0.001
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N7 , \\field Width Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N8 , \\field Height Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N9 , \\field Start Height Factor for Opening Factor 1
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N10, \\field Opening Factor 2
      \\required-field
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 2, this value must be 1.0.
      \\note If Number of Sets of Opening Factor Data = 3, this value must be less than 1.0.
      \\note If Number of Sets of Opening Factor Data = 4, this value must be less than the
      \\note value entered for Opening factor 3 and greater than the value entered
      \\note for Opening factor 1.
 N11, \\field Discharge Coefficient for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N12, \\field Width Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Width Factor is the opening width divided by the window or door width.
 N13, \\field Height Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum> 0
      \\maximum 1
      \\default 1
      \\note The Height Factor is the opening height divided by the window or door height.
 N14, \\field Start Height Factor for Opening Factor 2
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum< 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N15, \\field Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 3, this value must be 1.0.
      \\note If Number of Sets of Opening Factor Data = 4, this value must be less than 1.0,
      \\note and greater than value entered for Opening factor 2.
 N16, \\field Discharge Coefficient for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N17, \\field Width Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N18, \\field Height Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N19, \\field Start Height Factor for Opening Factor 3
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.
 N20, \\field Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\note If Number of Sets of Opening Factor Data = 4, this value must be 1.0
 N21, \\field Discharge Coefficient for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.
 N22, \\field Width Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Width Factor is the opening width divided by the window or door width.
 N23, \\field Height Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Height Factor is the opening height divided by the window or door height.
 N24; \\field Start Height Factor for Opening Factor 4
      \\type real
      \\units dimensionless
      \\minimum 0
      \\maximum 1
      \\default 0
      \\note The Start Height Factor is the Start Height divided by the window or door height.
      \\note Start Height is the distance between the bottom of the window or door and the
      \\note bottom of the window or door opening. The sum of the Height Factor and the Start Height
      \\note Factor must be less than 1.0 in order to have the opening within the window or door
      \\note dimensions.

AirflowNetwork:MultiZone:Component:SimpleOpening,
      \\min-fields 5
      \\memo This object specifies the properties of air flow through windows and doors (window, door and
      \\memo glass door heat transfer subsurfaces) when they are closed or open.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\minimum> 0
      \\units kg/s-m
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening (window or door) is closed.
 N3 , \\field Minimum Density Difference for Two-Way Flow
      \\required-field
      \\units kg/m3
      \\type real
      \\minimum> 0
      \\note Enter the minimum density difference above which two-way flow may occur due to stack effect.
 N4 ; \\field Discharge Coefficient
      \\required-field
      \\units dimensionless
      \\type real
      \\minimum> 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through a window or door at that Opening Factor.

AirflowNetwork:MultiZone:Component:HorizontalOpening,
      \\min-fields 5
      \\memo This object specifies the properties of air flow through a horizontal opening
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference SurfaceAirflowLeakageNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient When Opening is Closed
      \\required-field
      \\type real
      \\minimum> 0
      \\units kg/s-m
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following equation:
      \\note Mass flow rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening is closed.
 N2 , \\field Air Mass Flow Exponent When Opening is Closed
      \\units dimensionless
      \\type real
      \\default .65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the following equation:
      \\note Mass flow rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when opening is closed.
 N3 , \\field Sloping Plane Angle
      \\units deg
      \\type real
      \\minimum> 0
      \\maximum 90
      \\default 90
      \\note Sloping plane angle = 90 is equivalent to fully open.
 N4 ; \\field Discharge Coefficient
      \\required-field
      \\units dimensionless
      \\type real
      \\minimum> 0
      \\note The Discharge Coefficient indicates the fractional effectiveness
      \\note for air flow through the opening at that Opening Factor.

AirflowNetwork:MultiZone:Component:ZoneExhaustFan,
      \\min-fields 3
      \\memo This object specifies the additional properties for a zone exhaust fan
      \\memo to perform multizone airflow calculations.
 A1 , \\field Name
      \\required-field
      \\type object-list
      \\object-list FansZoneExhaust
      \\reference SurfaceAirflowLeakageNames
      \\note Enter the name of a Fan:ZoneExhaust object.
 N1 , \\field Air Mass Flow Coefficient When the Zone Exhaust Fan is Off at Reference Conditions
      \\required-field
      \\type real
      \\units kg/s
      \\minimum> 0
      \\note Enter the air mass flow coefficient at the conditions defined
      \\note in the Reference Crack Conditions object.
      \\note Defined at 1 Pa pressure difference. Enter the coefficient used in the following
      \\note equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when the fan is off.
 N2 , \\field Air Mass Flow Exponent When the Zone Exhaust Fan is Off
      \\units dimensionless
      \\type real
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent.
      \\note Used only when the fan is off.
 A2 ; \\field Reference Crack Conditions
      \\type object-list
      \\object-list ReferenceCrackConditions
      \\note Select a AirflowNetwork:MultiZone:ReferenceCrackConditions name associated with
      \\note the air mass flow coefficient entered above.

AirflowNetwork:MultiZone:ExternalNode,
      \\min-fields 3
      \\memo This object defines outdoor environmental conditions outside of the building.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference ExternalNodeNames
      \\note Enter a unique name for this object.
      \\note This node name will be referenced by a particular building facade.
 N1 , \\field External Node Height
      \\type real
      \\units m
      \\default 0.0
      \\note Designates the reference height used to calculate relative pressure.
 A2 , \\field Wind Pressure Coefficient Curve Name
      \\required-field
      \\type object-list
      \\object-list WPCValueNames
      \\object-list UnivariateFunctions
      \\note The name of the AirflowNetwork:MultiZone:WindPressureCoefficientValues, curve, or table object specifying the wind pressure coefficient.
 A3 , \\field Symmetric Wind Pressure Coefficient Curve
      \\type choice
      \\key Yes
      \\key No
      \\default No
      \\note Specify whether the pressure curve is symmetric or not.
      \\note Specify Yes for curves that should be evaluated from 0 to 180 degrees
      \\note Specify No for curves that should be evaluated from 0 to 360 degrees
 A4 ; \\field Wind Angle Type
      \\type choice
      \\key Absolute
      \\key Relative
      \\default Absolute
      \\note Specify whether the angle used to compute the wind pressure coefficient is absolute or relative
      \\note Specify Relative to compute the angle between the wind direction and the surface azimuth
      \\note Specify Absolute to use the wind direction angle directly

AirflowNetwork:MultiZone:WindPressureCoefficientArray,
      \\min-fields 3
      \\memo Used only if Wind Pressure Coefficient (WPC) Type = Input in the AirflowNetwork:SimulationControl
      \\memo object. Number of WPC Values in the corresponding AirflowNetwork:MultiZone:WindPressureCoefficientValues
      \\memo object must be the same as the number of wind directions specified for
      \\memo this AirflowNetwork:MultiZone:WindPressureCoefficientArray object.
 A1 , \\field Name
      \\required-field
      \\reference WPCSetNames
      \\type alpha
      \\note Enter a unique name for the object.
 N1 , \\field Wind Direction 1
      \\required-field
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 1st WPC Array value.
 N2 , \\field Wind Direction 2
      \\required-field
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 2nd WPC Array value.
 N3 , \\field Wind Direction 3
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 3rd WPC Array value.
 N4 , \\field Wind Direction 4
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 4th WPC Array value.
 N5 , \\field Wind Direction 5
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 5th WPC Array value.
 N6 , \\field Wind Direction 6
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 6th WPC Array value.
 N7 , \\field Wind Direction 7
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 7th WPC Array value.
 N8 , \\field Wind Direction 8
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 8th WPC Array value.
 N9 , \\field Wind Direction 9
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 9th WPC Array value.
 N10, \\field Wind Direction 10
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 10th WPC Array value.
 N11, \\field Wind Direction 11
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 11th WPC Array value.
 N12, \\field Wind Direction 12
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 12th WPC Array value.
 N13, \\field Wind Direction 13
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 13th WPC Array value.
 N14, \\field Wind Direction 14
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 14th WPC Array value.
 N15, \\field Wind Direction 15
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 15th WPC Array value.
 N16, \\field Wind Direction 16
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 16th WPC Array value.
 N17, \\field Wind Direction 17
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 17th WPC Array value.
 N18, \\field Wind Direction 18
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 18th WPC Array value.
 N19, \\field Wind Direction 19
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 19th WPC Array value.
 N20, \\field Wind Direction 20
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 20th WPC Array value.
 N21, \\field Wind Direction 21
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 21st WPC Array value.
 N22, \\field Wind Direction 22
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 22nd WPC Array value.
 N23, \\field Wind Direction 23
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 23rd WPC Array value.
 N24, \\field Wind Direction 24
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 24th WPC Array value.
 N25, \\field Wind Direction 25
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 25th WPC Array value.
 N26, \\field Wind Direction 26
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 26th WPC Array value.
 N27, \\field Wind Direction 27
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 27th WPC Array value.
 N28, \\field Wind Direction 28
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 28th WPC Array value.
 N29, \\field Wind Direction 29
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 29th WPC Array value.
 N30, \\field Wind Direction 30
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 30th WPC Array value.
 N31, \\field Wind Direction 31
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 31st WPC Array value.
 N32, \\field Wind Direction 32
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 32nd WPC Array value.
 N33, \\field Wind Direction 33
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 33rd WPC Array value.
 N34, \\field Wind Direction 34
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 34th WPC Array value.
 N35, \\field Wind Direction 35
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 35th WPC Array value.
 N36; \\field Wind Direction 36
      \\type real
      \\units deg
      \\minimum 0.0
      \\maximum 360.0
      \\note Enter the wind direction corresponding to the 36th WPC Array value.

AirflowNetwork:MultiZone:WindPressureCoefficientValues,
      \\min-fields 4
      \\memo Used only if Wind Pressure Coefficient (WPC) Type = INPUT in the AirflowNetwork:SimulationControl
      \\memo object. The number of WPC numeric inputs must correspond to the number of wind direction
      \\memo inputs in the AirflowNetwork:Multizone:WindPressureCoefficientArray object.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference WPCValueNames
      \\note Enter a unique name for this object.
 A2 , \\field AirflowNetwork:MultiZone:WindPressureCoefficientArray Name
      \\required-field
      \\type object-list
      \\object-list WPCSetNames
      \\note Enter the name of the AirflowNetwork:Multizone:WindPressureCoefficientArray object.
 N1 , \\field Wind Pressure Coefficient Value 1
      \\required-field
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 1st wind direction.
 N2 , \\field Wind Pressure Coefficient Value 2
      \\required-field
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 2nd wind direction.
 N3 , \\field Wind Pressure Coefficient Value 3
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 3rd wind direction.
 N4 , \\field Wind Pressure Coefficient Value 4
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 4th wind direction.
 N5 , \\field Wind Pressure Coefficient Value 5
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 5th wind direction.
 N6 , \\field Wind Pressure Coefficient Value 6
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 6th wind direction.
 N7 , \\field Wind Pressure Coefficient Value 7
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 7th wind direction.
 N8 , \\field Wind Pressure Coefficient Value 8
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 8th wind direction.
 N9 , \\field Wind Pressure Coefficient Value 9
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 9th wind direction.
 N10, \\field Wind Pressure Coefficient Value 10
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 10th wind direction.
 N11, \\field Wind Pressure Coefficient Value 11
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 11th wind direction.
 N12, \\field Wind Pressure Coefficient Value 12
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 12th wind direction.
 N13, \\field Wind Pressure Coefficient Value 13
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 13th wind direction.
 N14, \\field Wind Pressure Coefficient Value 14
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 14th wind direction.
 N15, \\field Wind Pressure Coefficient Value 15
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 15th wind direction.
 N16, \\field Wind Pressure Coefficient Value 16
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 16th wind direction.
 N17, \\field Wind Pressure Coefficient Value 17
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 17th wind direction.
 N18, \\field Wind Pressure Coefficient Value 18
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 18th wind direction.
 N19, \\field Wind Pressure Coefficient Value 19
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 19th wind direction.
 N20, \\field Wind Pressure Coefficient Value 20
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 20th wind direction.
 N21, \\field Wind Pressure Coefficient Value 21
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 21st wind direction.
 N22, \\field Wind Pressure Coefficient Value 22
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 22nd wind direction.
 N23, \\field Wind Pressure Coefficient Value 23
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 23rd wind direction.
 N24, \\field Wind Pressure Coefficient Value 24
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 24th wind direction.
 N25, \\field Wind Pressure Coefficient Value 25
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 25th wind direction.
 N26, \\field Wind Pressure Coefficient Value 26
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 26th wind direction.
 N27, \\field Wind Pressure Coefficient Value 27
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 27th wind direction.
 N28, \\field Wind Pressure Coefficient Value 28
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 28th wind direction.
 N29, \\field Wind Pressure Coefficient Value 29
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 29th wind direction.
 N30, \\field Wind Pressure Coefficient Value 30
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 30th wind direction.
 N31, \\field Wind Pressure Coefficient Value 31
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 31st wind direction.
 N32, \\field Wind Pressure Coefficient Value 32
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 32nd wind direction.
 N33, \\field Wind Pressure Coefficient Value 33
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 33rd wind direction.
 N34, \\field Wind Pressure Coefficient Value 34
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 34th wind direction.
 N35, \\field Wind Pressure Coefficient Value 35
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 35th wind direction.
 N36; \\field Wind Pressure Coefficient Value 36
      \\type real
      \\units dimensionless
      \\note Enter the WPC Value corresponding to the 36th wind direction.

AirflowNetwork:ZoneControl:PressureController,
      \\memo This object is used to control a zone to a specified indoor pressure
      \\memo using the AirflowNetwork model. The specified pressure setpoint is used
      \\memo to control the zone exhaust fan flow rate in a controlled zone or
      \\memo the relief air flow rate in an air loop.
      \\unique-object
 A1 , \\field Name
      \\required-field
      \\reference AirflowNetworkZoneControlPressureControllerNames
 A2 , \\field Control Zone Name
      \\required-field
      \\type object-list
      \\object-list ZoneNames
 A3 , \\field Control Object Type
      \\required-field
      \\type choice
      \\key AirflowNetwork:MultiZone:Component:ZoneExhaustFan
      \\key AirflowNetwork:Distribution:Component:ReliefAirFlow
      \\note The current selection is AirflowNetwork:MultiZone:Component:ZoneExhaustFan
      \\note or AirflowNetwork:Distribution:Component:ReliefAirFlow.
 A4 , \\field Control Object Name
      \\note Control names are names of individual control objects
      \\required-field
      \\type object-list
      \\object-list AFNReliefAirFlowNames
      \\object-list FansZoneExhaust
 A5 , \\field Pressure Control Availability Schedule Name
      \\note Availability schedule name for pressure controller. Schedule value > 0 means the
      \\note pressure controller is enabled. If this field is blank, then pressure controller is
      \\note always enabled.
      \\type object-list
      \\object-list ScheduleNames
 A6 ; \\field Pressure Setpoint Schedule Name
      \\required-field
      \\type object-list
      \\object-list ScheduleNames

AirflowNetwork:Distribution:Node,
      \\min-fields 4
      \\memo This object represents an air distribution node in the AirflowNetwork model.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkNodeAndZoneNames
      \\note Enter a unique name for this object.
 A2 , \\field Component Name or Node Name
      \\type alpha
      \\note Designates node names defined in another object. The node name may occur in air branches.
      \\note Enter a node name to represent a node already defined in an air loop.
      \\note Leave this field blank if the Node or Object Type field below is entered as
      \\note AirLoopHVAC:ZoneMixer, AirLoopHVAC:ZoneSplitter, AirLoopHVAC:OutdoorAirSystem, or Other.
 A3 , \\field Component Object Type or Node Type
      \\type choice
      \\key AirLoopHVAC:ZoneMixer
      \\key AirLoopHVAC:ZoneSplitter
      \\key AirLoopHVAC:OutdoorAirSystem
      \\key OAMixerOutdoorAirStreamNode
      \\key OutdoorAir:NodeList
      \\key OutdoorAir:Node
      \\key Other
      \\default Other
      \\note Designates Node type for the Node or Component Name defined in the field above.
      \\note AirLoopHVAC:ZoneMixer -- Represents a AirLoopHVAC:ZoneMixer object.
      \\note AirLoopHVAC:ZoneSplitter -- Represents a AirLoopHVAC:ZoneSplitter object.
      \\note AirLoopHVAC:OutdoorAirSystem -- Represents an AirLoopHVAC:OutdoorAirSystem object.
      \\note OAMixerOutdoorAirStreamNode -- Represents an external node used in the OutdoorAir:Mixer
      \\note OutdoorAir:NodeList -- Represents an external node when a heat exchanger is used before
      \\note the OutdoorAir:Mixer
      \\note OutdoorAir:Node -- Represents an external node when a heat exchanger is used before
      \\note the OutdoorAir:Mixer
      \\note Other -- none of the above, the Node name already defined in the previous field is part
      \\note of an air loop.
 N1 ; \\field Node Height
      \\type real
      \\units m
      \\default 0.0
      \\note Enter the reference height used to calculate the relative pressure.

AirflowNetwork:Distribution:Component:Leak,
      \\min-fields 3
      \\memo This object defines the characteristics of a supply or return air leak.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Air Mass Flow Coefficient
      \\required-field
      \\type real
      \\units kg/s
      \\minimum> 0
      \\note Defined at 1 Pa pressure difference across this component.
      \\note Enter the coefficient used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent
 N2 ; \\field Air Mass Flow Exponent
      \\type real
      \\units dimensionless
      \\minimum 0.5
      \\maximum 1.0
      \\default 0.65
      \\note Enter the exponent used in the following equation:
      \\note Mass Flow Rate = Air Mass Flow Coefficient * (dP)^Air Mass Flow Exponent

AirflowNetwork:Distribution:Component:LeakageRatio,
      \\min-fields 5
      \\memo This object is used to define supply and return air leaks with respect to the fan's maximum
      \\memo air flow rate.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Effective Leakage Ratio
      \\type real
      \\units dimensionless
      \\minimum> 0.0
      \\maximum 1.0
      \\note Defined as a ratio of leak flow rate to the maximum flow rate.
 N2 , \\field Maximum Flow Rate
      \\required-field
      \\units m3/s
      \\type real
      \\minimum> 0.0
      \\note Enter the maximum air flow rate in this air loop.
 N3 , \\field Reference Pressure Difference
      \\required-field
      \\units Pa
      \\type real
      \\minimum> 0.0
      \\note Enter the pressure corresponding to the Effective leakage ratio entered above.
 N4 ; \\field Air Mass Flow Exponent
      \\units dimensionless
      \\type real
      \\default 0.65
      \\minimum 0.5
      \\maximum 1.0
      \\note Enter the exponent used in the air mass flow equation.

AirflowNetwork:Distribution:Component:Duct,
      \\min-fields 8
      \\memo This object defines the relationship between pressure and air flow through the duct.
 A1 , \\field Name
      \\required-field
      \\type alpha
      \\reference AirflowNetworkComponentNames
      \\note Enter a unique name for this object.
 N1 , \\field Duct Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0.0
      \\note Enter the length of the duct.
 N2 , \\field Hydraulic Diameter
      \\required-field
      \\type real
      \\units m
      \\minimum> 0.0
      \\note Enter the hydraulic diameter of the duct.
      \\note Hydraulic diameter is defined as 4 multiplied by cross section area divided by perimeter
 N3 , \\field Cross Section Area
      \\required-field
      \\type real
      \\units m2
      \\minimum> 0.0
      \\note Enter the cross section area of the duct.
 N4 , \\field Surface Roughness
      \\type real
      \\units m
      \\default 0.0009
      \\minimum> 0.0
      \\note Enter the inside surface roughness of the duct.
 N5 , \\field Coefficient for Local Dynamic Loss Due to Fitting
      \\type real
      \\units dimensionless
      \\default 0.0
      \\minimum 0.0
      \\note Enter the coefficient used to calculate dynamic losses of fittings (e.g. elbows).
 N6 , \\field Heat Transmittance Coefficient (U-Factor) for Duct Wall Construction
      \\note conduction only
      \\type real
      \\units W/m2-K
      \\minimum> 0.0
      \\default 0.943
      \\note Default value of 0.943 is equivalent to 1.06 m2-K/W (R6) duct insulation.
 N7 , \\field Overall Moisture Transmittance Coefficient from Air to Air
      \\type real
      \\units kg/m2
      \\minimum> 0.0
      \\default 0.001
      \\note Enter the overall moisture transmittance coefficient
      \\note including moisture film coefficients at both surfaces.
 N8 , \\field Outside Convection Coefficient
      \\note optional. convection coefficient calculated automatically, unless specified
      \\type real
      \\units W/m2-K
      \\minimum> 0.0
 N9 ; \\field Inside Convection Coefficient
      \\note optional. convection coefficient calculated automatically, unless specified
      \\type real
      \\units W/m2-K
      \\minimum> 0.0

AirflowNetwork:Distribution:Component:Fan,
      \\min-fields 2
      \\memo This object defines the name of the supply Air Fan used in an Air loop.
 A1 , \\field Fan Name
      \\required-field
      \\type object-list
      \\object-list FansCVandOnOffandVAV
      \\object-list FansSystemModel
      \\reference AirflowNetworkComponentNames
      \\note Enter the name of the fan in the primary air loop.
 A2 ; \\field Supply Fan Object Type
      \\type choice
      \\key Fan:OnOff
      \\key Fan:ConstantVolume
      \\key Fan:VariableVolume
      \\key Fan:SystemModel
      \\default Fan:ConstantVolume

AirflowNetwork:Distribution:Component:Coil,
      \\min-fields 4
      \\memo This object defines the name of a coil used in an air loop.
 A1 , \\field Coil Name
      \\required-field
      \\type object-list
      \\reference AirflowNetworkComponentNames
      \\object-list AFNCoilNames
      \\note Enter the name of a cooling or heating coil in the primary Air loop.
 A2 , \\field Coil Object Type
      \\required-field
      \\type choice
      \\key Coil:Cooling:DX
      \\key Coil:Cooling:DX:SingleSpeed
      \\key Coil:Cooling:DX:TwoSpeed
      \\key Coil:Heating:Fuel
      \\key Coil:Heating:Electric
      \\key Coil:Heating:DX:SingleSpeed
      \\key Coil:Cooling:Water
      \\key Coil:Heating:Water
      \\key Coil:Cooling:Water:DetailedGeometry
      \\key Coil:Cooling:DX:TwoStageWithHumidityControlMode
      \\key Coil:Cooling:DX:MultiSpeed
      \\key Coil:Heating:DX:MultiSpeed
      \\key Coil:Heating:Desuperheater
      \\note Select the type of coil corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the coil.
 N2 ; \\field Air Path Hydraulic Diameter
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\note Enter the hydraulic diameter of this coil. The hydraulic diameter is
      \\note defined as 4 multiplied by the cross section area divided by perimeter.

AirflowNetwork:Distribution:Component:HeatExchanger,
      \\min-fields 4
      \\memo This object defines the name of an air-to-air heat exchanger used in an air loop.
 A1 , \\field HeatExchanger Name
      \\required-field
      \\type object-list
      \\object-list AFNHeatExchangerNames
      \\reference AirflowNetworkComponentNames
      \\note Enter the name of an air-to-air heat exchanger in the primary Air loop.
 A2 , \\field HeatExchanger Object Type
      \\required-field
      \\type choice
      \\key HeatExchanger:AirToAir:FlatPlate
      \\key HeatExchanger:AirToAir:SensibleAndLatent
      \\key HeatExchanger:Desiccant:BalancedFlow
      \\note Select the type of heat exchanger corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the heat exchanger.
 N2 ; \\field Air Path Hydraulic Diameter
      \\required-field
      \\units m
      \\type real
      \\minimum> 0
      \\note Enter the hydraulic diameter of this heat exchanger. The hydraulic diameter is
      \\note defined as 4 multiplied by the cross section area divided by perimeter.

AirflowNetwork:Distribution:Component:TerminalUnit,
      \\min-fields 4
      \\memo This object defines the name of a terminal unit in an air loop.
 A1 , \\field Terminal Unit Name
      \\required-field
      \\type object-list
      \\reference AirflowNetworkComponentNames
      \\object-list AFNTerminalUnitNames
      \\note Enter the name of a terminal unit in the AirLoopHVAC.
 A2 , \\field Terminal Unit Object Type
      \\required-field
      \\type choice
      \\key AirTerminal:SingleDuct:ConstantVolume:Reheat
      \\key AirTerminal:SingleDuct:VAV:Reheat
      \\note Select the type of terminal unit corresponding to the name entered in the field above.
 N1 , \\field Air Path Length
      \\required-field
      \\type real
      \\units m
      \\minimum> 0
      \\note Enter the air path length (depth) for the terminal unit.
 