"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expression = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Expression for events in Detector Model state.
 * @see https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
 */
class Expression {
    constructor() {
    }
    /**
     * Create a expression from the given string.
     */
    static fromString(value) {
        return new StringExpression(value);
    }
    /**
     * Create a expression for function `currentInput()`.
     * It is evaluated to true if the specified input message was received.
     */
    static currentInput(input) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.currentInput);
            }
            throw error;
        }
        return this.fromString(`currentInput("${input.inputName}")`);
    }
    /**
     * Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     */
    static inputAttribute(input, path) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inputAttribute);
            }
            throw error;
        }
        return this.fromString(`$input.${input.inputName}.${path}`);
    }
    /**
     * Create a expression for the Equal operator.
     */
    static eq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.eq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '==', right, 9);
    }
    /**
     * Create a expression for the Not Equal operator.
     */
    static neq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.neq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '!=', right, 9);
    }
    /**
     * Create a expression for the Less Than operator.
     */
    static lt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<', right, 10);
    }
    /**
     * Create a expression for the Less Than Or Equal operator.
     */
    static lte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<=', right, 10);
    }
    /**
     * Create a expression for the Greater Than operator.
     */
    static gt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>', right, 10);
    }
    /**
     * Create a expression for the Greater Than Or Equal operator.
     */
    static gte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>=', right, 10);
    }
    /**
     * Create a expression for the AND operator.
     */
    static and(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.and);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '&&', right, 5);
    }
    /**
     * Create a expression for the OR operator.
     */
    static or(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.or);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '||', right, 4);
    }
}
exports.Expression = Expression;
_a = JSII_RTTI_SYMBOL_1;
Expression[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Expression", version: "2.22.0-alpha.0" };
class StringExpression extends Expression {
    constructor(value) {
        super();
        this.value = value;
    }
    evaluate() {
        return this.value;
    }
}
class BinaryOperationExpression extends Expression {
    constructor(left, operator, right, 
    /**
     * Indicates the priority of the operator.
     * This is intended to be set according to MDN rules.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_Precedence#table
     */
    priority) {
        super();
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.priority = priority;
    }
    evaluate(parentPriority) {
        const expression = `${this.left.evaluate(this.priority)} ${this.operator} ${this.right.evaluate(this.priority)}`;
        return parentPriority === undefined || parentPriority <= this.priority
            ? expression
            : `(${expression})`;
    }
}
//# sourceMappingURL=data:application/json;base64,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