import * as iam from 'aws-cdk-lib/aws-iam';
import { Resource, IResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Represents an AWS IoT Events input.
 */
export interface IInput extends IResource {
    /**
     * The name of the input.
     *
     * @attribute
     */
    readonly inputName: string;
    /**
     * The ARN of the input.
     *
     * @attribute
     */
    readonly inputArn: string;
    /**
     * Grant write permissions on this input and its contents to an IAM principal (Role/Group/User).
     *
     * @param grantee the principal
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * Grant the indicated permissions on this input to the given IAM principal (Role/Group/User).
     *
     * @param grantee the principal
     * @param actions the set of actions to allow (i.e. "iotevents:BatchPutMessage")
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
declare abstract class InputBase extends Resource implements IInput {
    abstract readonly inputName: string;
    abstract readonly inputArn: string;
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * Properties for defining an AWS IoT Events input.
 */
export interface InputProps {
    /**
     * The name of the input.
     *
     * @default - CloudFormation will generate a unique name of the input
     */
    readonly inputName?: string;
    /**
     * An expression that specifies an attribute-value pair in a JSON structure.
     * Use this to specify an attribute from the JSON payload that is made available
     * by the input. Inputs are derived from messages sent to AWS IoT Events (BatchPutMessage).
     * Each such message contains a JSON payload. The attribute (and its paired value)
     * specified here are available for use in the condition expressions used by detectors.
     */
    readonly attributeJsonPaths: string[];
}
/**
 * Defines an AWS IoT Events input in this stack.
 */
export declare class Input extends InputBase {
    /**
     * Import an existing input.
     */
    static fromInputName(scope: Construct, id: string, inputName: string): IInput;
    readonly inputName: string;
    readonly inputArn: string;
    constructor(scope: Construct, id: string, props: InputProps);
}
export {};
