"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.State = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines a state of a detector.
 */
class State {
    constructor(props) {
        this.props = props;
        this.transitionEvents = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_StateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.stateName = props.stateName;
    }
    /**
     * Add a transition event to the state.
     * The transition event will be triggered if condition is evaluated to `true`.
     *
     * @param targetState the state that will be transit to when the event triggered
     * @param options transition options including the condition that causes the state transition
     */
    transitionTo(targetState, options) {
        var _b;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_State(targetState);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_TransitionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.transitionTo);
            }
            throw error;
        }
        const alreadyAdded = this.transitionEvents.some(transitionEvent => transitionEvent.nextState === targetState);
        if (alreadyAdded) {
            throw new Error(`State '${this.stateName}' already has a transition defined to '${targetState.stateName}'`);
        }
        this.transitionEvents.push({
            eventName: (_b = options.eventName) !== null && _b !== void 0 ? _b : `${this.stateName}_to_${targetState.stateName}`,
            nextState: targetState,
            condition: options.when,
            actions: options.executing,
        });
    }
    /**
     * Collect states in dependency gragh that constructed by state transitions,
     * and return the JSONs of the states.
     * This function is called recursively and collect the states.
     *
     * @internal
     */
    _collectStateJsons(scope, actionBindOptions, collectedStates) {
        if (collectedStates.has(this)) {
            return [];
        }
        collectedStates.add(this);
        return [
            this.toStateJson(scope, actionBindOptions),
            ...this.transitionEvents.flatMap(transitionEvent => {
                return transitionEvent.nextState._collectStateJsons(scope, actionBindOptions, collectedStates);
            }),
        ];
    }
    /**
     * Returns true if this state has at least one condition via events.
     *
     * @internal
     */
    _onEnterEventsHaveAtLeastOneCondition() {
        var _b, _c;
        return (_c = (_b = this.props.onEnter) === null || _b === void 0 ? void 0 : _b.some(event => event.condition)) !== null && _c !== void 0 ? _c : false;
    }
    toStateJson(scope, actionBindOptions) {
        const { onEnter, onInput, onExit } = this.props;
        return {
            stateName: this.stateName,
            onEnter: onEnter && {
                events: toEventsJson(scope, actionBindOptions, onEnter),
            },
            onInput: (onInput || this.transitionEvents.length !== 0) ? {
                events: toEventsJson(scope, actionBindOptions, onInput),
                transitionEvents: toTransitionEventsJson(scope, actionBindOptions, this.transitionEvents),
            } : undefined,
            onExit: onExit && {
                events: toEventsJson(scope, actionBindOptions, onExit),
            },
        };
    }
}
exports.State = State;
_a = JSII_RTTI_SYMBOL_1;
State[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.State", version: "2.22.0-alpha.0" };
function toEventsJson(scope, actionBindOptions, events) {
    return events === null || events === void 0 ? void 0 : events.map(event => {
        var _b, _c;
        return ({
            eventName: event.eventName,
            condition: (_b = event.condition) === null || _b === void 0 ? void 0 : _b.evaluate(),
            actions: (_c = event.actions) === null || _c === void 0 ? void 0 : _c.map(action => action.bind(scope, actionBindOptions).configuration),
        });
    });
}
function toTransitionEventsJson(scope, actionBindOptions, transitionEvents) {
    if (transitionEvents.length === 0) {
        return undefined;
    }
    return transitionEvents.map(transitionEvent => {
        var _b;
        return ({
            eventName: transitionEvent.eventName,
            condition: transitionEvent.condition.evaluate(),
            actions: (_b = transitionEvent.actions) === null || _b === void 0 ? void 0 : _b.map(action => action.bind(scope, actionBindOptions).configuration),
            nextState: transitionEvent.nextState.stateName,
        });
    });
}
//# sourceMappingURL=data:application/json;base64,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