from collections.abc import Sequence
import enum
from typing import overload

import sourcepp._sourcepp_impl.sourcepp.math


class CmdSeq:
    @overload
    def __init__(self, path: str) -> None: ...

    @overload
    def __init__(self, type: CmdSeq.Type) -> None: ...

    class Command:
        class Special(enum.Enum):
            NONE = 0

            CHANGE_DIRECTORY = 256

            COPY_FILE = 257

            DELETE_FILE = 258

            RENAME_FILE = 259

            COPY_FILE_IF_EXISTS_ALIAS = 260

            COPY_FILE_IF_EXISTS = 261

        @property
        def enabled(self) -> bool: ...

        @enabled.setter
        def enabled(self, arg: bool, /) -> None: ...

        @property
        def executable(self) -> str: ...

        @executable.setter
        def executable(self, arg: str, /) -> None: ...

        @property
        def arguments(self) -> str: ...

        @arguments.setter
        def arguments(self, arg: str, /) -> None: ...

        @property
        def ensure_file_exists(self) -> bool: ...

        @ensure_file_exists.setter
        def ensure_file_exists(self, arg: bool, /) -> None: ...

        @property
        def path_to_theoretically_existing_file(self) -> str: ...

        @path_to_theoretically_existing_file.setter
        def path_to_theoretically_existing_file(self, arg: str, /) -> None: ...

        @property
        def use_process_window(self) -> bool: ...

        @use_process_window.setter
        def use_process_window(self, arg: bool, /) -> None: ...

        @property
        def wait_for_keypress(self) -> bool: ...

        @wait_for_keypress.setter
        def wait_for_keypress(self, arg: bool, /) -> None: ...

        @staticmethod
        def get_special_display_name_for(special: CmdSeq.Command.Special) -> str: ...

        def get_executable_display_name(self) -> str: ...

    class Sequence:
        @property
        def name(self) -> str: ...

        @name.setter
        def name(self, arg: str, /) -> None: ...

        @property
        def commands(self) -> list[CmdSeq.Command]: ...

        @commands.setter
        def commands(self, arg: Sequence[CmdSeq.Command], /) -> None: ...

    class Type(enum.Enum):
        INVALID = 0

        BINARY = 1

        KEYVALUES_STRATA = 2

    def __bool__(self) -> bool: ...

    @property
    def type(self) -> CmdSeq.Type: ...

    @type.setter
    def type(self, arg: CmdSeq.Type, /) -> None: ...

    @property
    def version(self) -> float: ...

    def set_version(self, is_v02: bool) -> None: ...

    def sequences(self) -> list[CmdSeq.Sequence]: ...

    def bake(self) -> bytes: ...

    def bake_to_file(self, path: str) -> bool: ...

class FGD:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, fgd_path: str) -> None: ...

    class Entity:
        class ClassProperty:
            @property
            def name(self) -> str: ...

            @property
            def arguments(self) -> str: ...

        class Field:
            @property
            def name(self) -> str: ...

            @property
            def value_type(self) -> str: ...

            @property
            def readonly(self) -> bool: ...

            @property
            def reportable(self) -> bool: ...

            @property
            def display_name(self) -> str: ...

            @property
            def value_default(self) -> str: ...

            @property
            def description(self) -> str: ...

        class FieldChoices:
            class Choice:
                @property
                def value(self) -> str: ...

                @property
                def display_name(self) -> str: ...

            @property
            def name(self) -> str: ...

            @property
            def readonly(self) -> bool: ...

            @property
            def reportable(self) -> bool: ...

            @property
            def display_name(self) -> str: ...

            @property
            def value_default(self) -> str: ...

            @property
            def description(self) -> str: ...

            @property
            def choices(self) -> list[FGD.Entity.FieldChoices.Choice]: ...

        class IO:
            @property
            def name(self) -> str: ...

            @property
            def value_type(self) -> str: ...

            @property
            def description(self) -> str: ...

        @property
        def class_type(self) -> str: ...

        @property
        def class_properties(self) -> list[FGD.Entity.ClassProperty]: ...

        @property
        def description(self) -> str: ...

        @property
        def docs_url(self) -> str: ...

        @property
        def fields(self) -> list[FGD.Entity.Field]: ...

        @property
        def fields_with_choices(self) -> list[FGD.Entity.FieldChoices]: ...

        @property
        def fields_with_flags(self) -> list[FGDEntityFieldFlags]: ...

        @property
        def inputs(self) -> list[FGD.Entity.IO]: ...

        @property
        def outputs(self) -> list[FGD.Entity.IO]: ...

    class AutoVisGroup:
        @property
        def parent_name(self) -> str: ...

        @property
        def name(self) -> str: ...

        @property
        def entities(self) -> list[str]: ...

    def load(self, fgd_path: str) -> None: ...

    @property
    def version(self) -> int: ...

    @property
    def map_size(self) -> sourcepp._sourcepp_impl.sourcepp.math.Vec2i32: ...

    @property
    def entities(self) -> dict[str, FGD.Entity]: ...

    @property
    def material_exclusion_dirs(self) -> list[str]: ...

    @property
    def auto_visgroups(self) -> list[FGD.AutoVisGroup]: ...

class FGDEntityFieldFlags:
    class Flag:
        @property
        def value(self) -> int: ...

        @property
        def display_name(self) -> str: ...

        @property
        def enabled_by_default(self) -> bool: ...

        @property
        def description(self) -> str: ...

    @property
    def name(self) -> str: ...

    @property
    def readonly(self) -> bool: ...

    @property
    def reportable(self) -> bool: ...

    @property
    def display_name(self) -> str: ...

    @property
    def description(self) -> str: ...

    @property
    def flags(self) -> list[FGDEntityFieldFlags.Flag]: ...

class FGDWriter:
    class AutoVisGroupWriter:
        def visgroup(self, name: str, entities: Sequence[str]) -> FGDWriter.AutoVisGroupWriter: ...

        def end_auto_visgroup(self) -> FGDWriter: ...

    class EntityWriter:
        class KeyValueChoicesWriter:
            def choice(self, value: str, display_name: str) -> FGDWriter.EntityWriter.KeyValueChoicesWriter: ...

            def end_key_value_choices(self) -> FGDWriter.EntityWriter: ...

        class KeyValueFlagsWriter:
            def flag(self, value: int, display_name: str, enabled_by_default: bool, description: str = '') -> FGDWriter.EntityWriter.KeyValueFlagsWriter: ...

            def end_key_value_flags(self) -> FGDWriter.EntityWriter: ...

        def key_value(self, name: str, value_type: str, display_name: str = '', value_default: str = '', description: str = '', readonly: bool = False, report: bool = False) -> FGDWriter.EntityWriter: ...

        def begin_key_value_choices(self, name: str, display_name: str = '', value_default: str = '', description: str = '', readonly: bool = False, report: bool = False) -> FGDWriter.EntityWriter.KeyValueChoicesWriter: ...

        def begin_key_value_flags(self, name: str, display_name: str = '', description: str = '', readonly: bool = False, report: bool = False) -> FGDWriter.EntityWriter.KeyValueFlagsWriter: ...

        def input(self, name: str, value_type: str, description: str = '') -> FGDWriter.EntityWriter: ...

        def output(self, name: str, value_type: str, description: str = '') -> FGDWriter.EntityWriter: ...

        def end_entity(self) -> FGDWriter: ...

    @staticmethod
    def begin() -> FGDWriter: ...

    def include(self, fgd_path: str) -> FGDWriter: ...

    def version(self, version: int) -> FGDWriter: ...

    def map_size(self, map_size: sourcepp._sourcepp_impl.sourcepp.math.Vec2i32) -> FGDWriter: ...

    def material_exclusion_dirs(self, material_exclusion_dirs: Sequence[str]) -> FGDWriter: ...

    def begin_auto_visgroup(self, parent_name: str) -> FGDWriter.AutoVisGroupWriter: ...

    def begin_entity(self, class_type: str, class_properties: Sequence[str], name: str, description: str = '', docs_url: str = '') -> FGDWriter.EntityWriter: ...

    def bake(self) -> bytes: ...

    def bake_to_file(self, path: str) -> bool: ...
